<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.0
 * @date 12/04/19
 * @time 12:36 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
        <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('settings/office365Settings')?>"><?=$data['crumb1']?></a></li>
                <li><?=$data['crumb2']?></li>
        </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='ccS'?></span>
            <?php if($_SESSION['storageResult'] == 'error'){ ?>
             <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php }elseif($_SESSION['storageResult'] == 'success'){ ?>
             <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php } ?>
            <?php $_SESSION['storageResult'] = ''; ?>
            <?php $_SESSION['storageMessage'] = ''; ?>
            <div class="row">
                    <div class="forODB">
                        <div class="panel col-lg-12">
                            <div class="panel-heading"><h4>Exchange Tenant Settings</h4></div>
                            <div class="panel-body">
                                <form class="exchangeConfiguration" id="exchangeConfiguration" ng-submit="saveExchangeConfiguration()" data-parsley-validate>
                                    <div class="row">
                                    <input type="text" class="d-none" hidden value="<?=$data["configId"]?>" name="configId" />
				    <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                                    <div class="form-group col-lg-6">
                                        <label for="clientId">Client ID</label>
                                        <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter Client Id" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientSecret">Client Secret</label>
                                            <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter Secret Key" required autocomplete="off">
                                            <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created an app.</span>
                                    </div>
				    <div class="form-group col-lg-6">
                                        <label for="appName">App Name</label>
                                        <input type="text" class="form-control" name="appName" id="appName" value="<?=$data["appName"]?>" placeholder="Enter App Name" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- App Name will be the name which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6 tenantId">
                                        <label for="tenantId"><?=Language::show('Tenant ID', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenantId" id="tenantId" value="<?=$data["tenantId"]?>" placeholder="Enter Tenant ID" autocomplete="off" required>
                                        <span class="help-line text-muted">Note:- Tenant ID will be the key which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="clientRedirectURI">Client Redirect URL</label>
                                        <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter Client Redirect URL" autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientResourceURL">Client OneDrive for Business URL</label>
                                        <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter Client OneDrive for Business URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your SharePoint app URL)</span>
                                    </div>
                                    <div class="form-group col-lg-6" style="margin-bottom:40px;">
                                        <label for="clientTokenURL">Client Token URL</label>
                                        <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="<?=$data["clientTokenURL"]?>" placeholder="Enter client token URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="portalURL">Portal URL</label>
                                        <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter Portal URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                        <br/><br/>
                                    </div>
<!--				</div>-->
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-success float-right">Save Settings</button>
				</div>
</div>
				</form>
                            </div>
			</div>
<?php //if($data['tokenMapped'] == "false") { ?>
<div class="panel col-lg-12">
<div class="panel-heading"><h4>For Admin Consent</h4></div>
 <div class="panel-body">
<?php
$tenentId = $data["tenantId"];
$clientId = $data["clientID"];
$user_principal = $data['user_principal'];
//$redirectURI = $data["clientRedirectURI"];
                                if(useLocalPackage != true){
                                    $redirectURI = "https://api-app.parablu.com/adminConsentExchange.php";
                                    $appURL = "https://api-app.parablu.com/callConsent.php";
                                }else{
                                    $redirectURI = LOCAL_IP."/app/adminConsentExchange.php";
                                    $appURL = LOCAL_IP."/app/callConsent.php";
                                }
                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
                    //$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                    $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
?>
<p>
       <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
</p>
</div>
</div>
<?php //} ?>
                    </div>
                </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?php echo microtime();?>" type="text/javascript"></script>
