<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4.1
* @date 17/06/19
* @time 04:27 PM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                    <li><span><?='OneDrive for Business Policy Mapping'?></span></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
                <span class="d-none currentPage"><?='singleOneDrivePolicyMapping'?></span>
                <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=$data['crumb2']?></h4>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <form class="col-lg-12" ng-submit="updateOfficePolicyMappingList(0, search.userName)">
                                <div class="col-lg-12">
                                    <input name="searchUsername"
                                           type="text"
                                           class="pull-right form-control"
                                           ng-model="search.userName"
                                           placeholder="Enter a list of comma separated user names or just type 'all (for all users)' and hit enter to search"
                                           data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                           data-content="Entered users were not found!!! "
                                        />
                                </div>
                            </form>
                        </div>
                        <br/>
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped userPolicyMappingListTable" style="display: none;">
                            <colgroup>
                                <col class="col-xs-3">
                                <col class="col-xs-5">
                                <col class="col-xs-3">
                            </colgroup>
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="sortTypeMapping = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortTypeMapping == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMapping == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortTypeMapping = 'backupPolicyName'; sortReverse = !sortReverse">
                                    <?=Language::show('policyName', 'keywords')?>
                                    <span ng-show="sortTypeMapping == 'backupPolicyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMapping == 'backupPolicyName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in userOneDrivePolicyMappingUsers | orderBy:sortTypeMapping:sortReverse" class="mappingRow{{$index}}">
                                <td class="userName" ng-cloak>{{ value.userName | limitTo:25}}{{value.userName.length > 25 ? '...' : ''}}
                                    <span id="actualUserName{{$index}}" class="hide actualUserName{{$index}}">{{value.userName}}</span>
                                </td>
                                <td class="policyName" ng-cloak style="white-space:unset !important;">
                                    <span>{{ value.oneDrivePolicyName | limitTo:25}}{{value.oneDrivePolicyName.length > 25 ? '...' : ''}}</span>
                                    <form style="display: none;">
                                        <select class="form-control" name="userPolicyMappingPolicyName{{$index}}" id="userPolicyMappingPolicyName{{$index}}" required="">
                                            <option ng-repeat="policy in userOneDrivePolicyMappingPolicies" value="{{ policy }}">{{ policy }}</option>
                                        </select>
                                    </form>
                                </td>
                                <td class="action" ng-cloak>
                                    <a class="edit btn btn-default btn-small" ng-click="showMappingList($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-success btn-small" ng-click="changeOfficePolicy($index,value.oneDrivePolicyName)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-danger btn-small" ng-click="cancelChangePolicy($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="row userPolicyMappingListTablePage" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                                <a class="btn btn-primary first" ng-click="updateOfficePolicyMappingListNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                                <a class="btn btn-primary previous" ng-click="updateOfficePolicyMappingListNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                                <a class="btn btn-primary next" ng-click="updateOfficePolicyMappingListNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                                <a class="btn btn-primary last" ng-click="updateOfficePolicyMappingListNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                        </div>
                        <!--<div ng-if="searchForUserName == 'all'" class="row loadMore" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <a class="loadMoreBtn btn btn-primary" ng-click="updateOneDrivePolicyMappingList(skipValue, 'all')">Load More ...</a>
                            </div>
                        </div>-->
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
                                    
