<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 28/10/2022
* @time 18:30 PM
*
 */
?>
<div id="userAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="userPercentage"> </span>
        <span class="pull-right" ng-click="closeUserWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<div id="storageAlert" style="background-color: red;text-align: center;display:none;margin-bottom:2px;">
        <span style="color: white;font-size: 18px;" id="storagePercentage"> </span>
        <span class="pull-right" ng-click="closeStorageWarning()" style="font-size: 18px;width: 2%;cursor: pointer;background-color: red;">×</span>
</div>
<!--<div class="container">
    <div>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>-->
<div class="main" ng-controller="ReportController">
    <span class="d-none currentPage"><?='sbmdashboard'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="forceSessionLogoutAfterChangepassword d-none"><?=$data['forceSessionLogoutAfterChangepassword']?></span>
    <span class="reportProductType d-none"><?='backup'?></span>
    <div class="row profile">        
        <div class="col-lg-12 col-md-12 col-sm-12">
<!--new start-->
<?php if(isMobile()){ ?>
                    <ul class="nav nav-pills flex-column" style="border: 1px solid #EC6621;border-radius: 10px;">
                            <li class="nav-item" style="display:unset !important;"><a href="" id="userM" class="nav-link active" data-target="#user" aria-controls="user" aria-expanded="true" data-toggle="tab">User Management</a></li>
                            <li class="nav-item" style="display:unset !important;"><a href="" id="deviceM" class="nav-link" data-target="#device" aria-controls="device" aria-expanded="false" data-toggle="tab">Device Management</a></li>
                            <li class="nav-item" style="display:unset !important;"><a href="" id="policyM" class="nav-link" data-target="#policy" aria-controls="policy" aria-expanded="false" data-toggle="tab">Policy Management</a></li>
		     	    <li class="nav-item" style="display:unset !important;"><a href="" id="reportM" class="nav-link" data-target="#report" aria-controls="report" aria-expanded="false" data-toggle="tab">Reports</a></li>
                    </ul>
            <?php } ?>
<?php if(!isMobile()){ ?>
		    <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">
			    <li role="presentation" class="nav-item hide"><a href="" class="nav-link" data-target="#overview" aria-controls="overview" role="tab" data-toggle="tab">Overview</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="userM" class="nav-link active" data-target="#user" aria-controls="user" role="tab" data-toggle="tab">User Management</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="deviceM" class="nav-link" data-target="#device" aria-controls="device" role="tab" data-toggle="tab">Device Management</a></li>
			    <li role="presentation" class="nav-item"><a href="" id="policyM" class="nav-link" data-target="#policy" aria-controls="policy" role="tab" data-toggle="tab">Policy Management</a></li>
                            <li role="presentation" class="nav-item"><a href="" id="reportM" class="nav-link" data-target="#report" aria-controls="report" role="tab" data-toggle="tab">Reports</a></li>
                    </ul>
            <?php } ?>
            
            
            
            <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="user">
<br>
		    <!--backup start-->
<div class="row">
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-success" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-users"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Users</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfActiveUsers }}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-purple" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-desktop"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Managed Data</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalStorageUtilized }} / {{ statistics.totalStorageAlloted }}</span>
                                            </div>
                                        </div>
                                </div>
                                <div class="col-lg-4" block-ui="myBlockUI">
                                        <div class="panel panel-default no-box-shadow widget-danger" style="border-radius:10px;">
                                            <div class="background">
                                                <!--<i class="fa fa-history"></i>-->
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <!--<i class="fa fa-desktop"></i>-->
                                                <span style="font-size: 20px;margin-top: -20px;color:white;">Devices Installed</span><span class="pull-right" style="font-size: 20px;color:white;" ng-cloak>{{ statistics.totalNoOfDevices }}</span>
                                            </div>
                                        </div>
                                </div>
</div>
		    <div class="panel" style="height:500px;overflow:scroll;">
		    <div class="panel-heading">
                    <h4>
			<?=Language::show('list_of_users', 'keywords');?>                        
                        <a ng-click="exportUsersToExcel()" class="btn btn-small btn-primary <?php if(!isMobile()) { ?> pull-right <?php } ?>">Export Users</a>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == true || \Helpers\Auth::checkCloudPermission('sync') == true){ ?>
                            <a class="btn btn-success btn-small pull-right d-none"  href="<?=Url::basePath('userGroup')?>">Manage User Group</a>
                        <?php } ?>
                        <?php //if($data['readOnlyAdminUser'] == 'No'){ ?>
                        <?php if(block == false){ ?>
                            <a class="btn btn-primary btn-small pull-right" disabled style="color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                        <?php } else {?>
                            <?php if(!isMobile()) { ?>
                                <a class="btn btn-primary btn-small pull-right hide" style="color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                            <?php }else{ ?>
                                <a class="btn btn-primary btn-small hide" style="margin-top: 2px; color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>">Manage Users in Bulk</a>
                            <?php } ?>
                        <?php } ?>
			<?php //} ?>
			<button class="btn btn-primary btn-small pull-right" data-toggle="modal" data-target="#addUser">Add Users in Bulk</button>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                            <?php //if($data['readOnlyAdminUser'] == 'No'){ ?>
                                <!--<a class="btn btn-primary btn-small pull-right" href="<?=Url::basePath('user/create')?>">Create User</a>-->
                            <?php //} ?>
                        <?php } ?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
			<form class="col-lg-12" ng-submit="searchUser1()" data-parsley-validate>
				<div class="row">
				    <div class="col-lg-12">
					<select class="assignUsersMsp" name="userNames[]" style="width: 100%;" data-parsley-trigger="change" id="selectAssignUsersMsp" multiple="multiple"></select>
				    </div>
				    <!--<div class="col-lg-2">
					<button type="submit" class="btn btn-default" >Search</button>
				    </div>-->
				</div>
			</form>
                    </div>
                    <br/>
		    <div class="panel nouserListTable" style="display: none;">
                    	<div>
                        	<h2 align="center">No Users Found</h2>
                    	</div>
                    </div>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table table-bordered table-striped userListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="sortTypeMSPU = 'emailId'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'emailId' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'emailId' && sortReverseMSPU" class="fa fa-caret-down"></span>
				</th>
				<th class="text-left clickAble" ng-click="sortTypeMSPU = 'userName'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('Policy', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'userName' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'userName' && sortReverseMSPU" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortTypeMSPU = 'timeinmillis'; sortReverseMSPU = !sortReverseMSPU">
                                    <?=Language::show('Last Modified Time', 'keywords')?>
                                    <span ng-show="sortTypeMSPU == 'timeinmillis' && !sortReverseMSPU" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMSPU == 'timeinmillis' && sortReverseMSPU" class="fa fa-caret-down"></span>
				</th>
				<th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                <!--<th class="text-left clickAble" ng-click="sortType = 'isActive'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'isActive' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'isActive' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left"><?=Language::show('action', 'keywords')?></th>-->
                            </tr>
			    </thead>
			    <tbody>
			    <tr class="addUserBtnRow">
				<td class="addUserBtnTD"><a class="btn btn-primary btn-small" ng-click="addUserRow()">Add User</a></td>
<td></td>
<td></td>
<td></td>
			    </tr>
<tr class="addUserRow" style="display:none;">
<td>
<div class="form-group">
                                                                    <label for="emailId"><?=Language::show('Email Id', 'keywords')?></label>
                                                                    <input type="text" class="form-control" name="newemailId" id="newemailId" value="" placeholder="Enter Email Id" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Please enter valid Email Id.">
								</div>
</td>
<td>
<div class="form-group">
                                                                    <label for="policy"><?=Language::show('Policy', 'keywords')?></label>
                                                                    <select class="form-control" name="newpolicy" id="newpolicy">
                                                                        <option value="<?=$data['policy_staging']?>">No Backup</option>
									<option value="<?=$data['policy']?>" selected>Backup</option>
                                                                    </select>
                                                                </div>
</td>
<td>
<a class="btn btn-success btn-small" ng-click="addSingleMspUser()" style="margin-top:10%;">Save</a>
<a class="btn btn-danger btn-small addUserCancel" ng-click="addUserCancel()" style="margin-top:10%;">Cancel</a>
</td>

                            </tr>
			    <tr class="existingUsers{{$index}}" ng-repeat="value in users  | orderBy:sortTypeMSPU:sortReverseMSPU track by $index" class="mappingRowUsers{{$index}}">
				<td ng-cloak  title="{{value.emailId}}">{{ value.emailId | limitTo:30}}{{value.emailId.length > 30 ? '...' : ''}}
<input type="hidden" class="gotemail" value="{{value.emailId}}" />
</td>
				<td class="policyNameUsers" ng-cloak>
<input type="hidden" class="gotname" value="{{value.policyName}}" />
<!--<span class="userPolicy{{$index}}">{{ value.policyName}}</span>-->
					<select class="form-control userPolicy" name="userPolicyMappingPolicyNameUsers{{$index}}" id="userPolicyMappingPolicyNameUsers{{$index}}" onchange="changedPolicy(this.id)">
					<?php 
						$policy = $data['policy'];
						$policy_staging = $data['policy_staging'];
					?>

						<option value="<?=$policy?>" ng-selected="value.policyName == '<?=$policy?>'">Backup</option>
						<option value="<?=$policy_staging?>" ng-selected="value.policyName == '<?=$policy_staging?>'">No Backup</option>
                                        </select>
<!--<a class="editUsers btn btn-default btn-small pull-right" ng-click="showMappingListUsers($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                        <a style="display: none;" class="saveUsers btn btn-success btn-small" ng-click="changePolicyUsers($index,value.backupPolicyName)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                        <a style="display: none;" class="saveUsers btn btn-danger btn-small" ng-click="cancelChangePolicyUsers($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>-->
				</td>
				<td ng-cloak>{{ value.time }}
<input type="hidden" class="time" value="{{value.time}}" />
</td>
<td ng-cloak>
<a ng-show="value.isActive" class="btn btn-warning btn-small" ng-bootbox-confirm="<h4><?=Language::show('blockConfirmMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="background: #6d5cae !important;color:white!important;width: 125px;"><?=Language::show('Deactivate', 'keywords');?></a>
<a ng-show="!value.isActive" class="btn btn-success btn-small" ng-bootbox-confirm="<h4>Confirmation</h4><hr><span>Please note that after user re-activation, devices belonging to this user will have to be<ol><li>Re-activated separately from the Device Management screen.</li><li>Re-installed with the endpoint agent.</li></ol>Are you sure you wish to Re-activate the selected user?</span>" ng-bootbox-confirm-action="unBlockUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('Reactivate', 'keywords');?></a>
<a ng-hide="value.isActive" class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirm', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this user.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteUserProfile(value.userName, 'true', 'user')" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="color:white!important;width: 130px;"><?=Language::show('delete', 'keywords');?></a>
</td>                                
			    </tr>
                            </tbody>
			</table>
<a href="" class="btn btn-primary clickAble pull-right edittUsers" ng-click="closeMSPUsers()" style="display:none;">Cancel</a>
<a href="" class="btn btn-primary clickAble pull-right edittUsers" ng-click="updateMultipleUsersMsp()" style="display:none;">Apply</a>
                    </div>
                    <div class="row userListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="updateUsersNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="updateUsersNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="updateUsersNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="updateUsersNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
		    </div>
		    <!--exportUsersToExcelModal starts-->
		    <div class="modal fade exportUsersToExcelModal" id="exportUsersToExcelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
				<div class="modal-header">
				    <h4 class="modal-title" id="myModalLabel">Export Users</h4>
				    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
				    <div class="col-lg-12" id="chooserUsers">
					<div class="col-lg-6">
						<input type="radio" name="optradioUsers" value="allUsers" checked>
						<label for="link"><?=Language::show('All Users', 'keywords');?></label>
					</div>
					<!--<div class="col-lg-6">
						<input type="radio" name="optradioUsers" value="onlyActiveUsers">
						<label for="link"><?=Language::show('Only Active Users', 'keywords');?></label>
					</div>-->
				    </div>
				    <br>
				</div>
				<div class="modal-footer">
				    <a ng-click="exportUsersToExcel()" class="btn btn-success">Export Excel</a>
				    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
				</div>
			    </div>
			</div>
		    </div>
		    <!--exportUsersToExcelModal ends-->
		</div>
		</div>
		    <!--backup ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="device">
<br>
<!--backup start-->
		<div class="panel panel-default files-panel no-box-shadow" style="height:500px;overflow:scroll;">
                <div class="status" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesList" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchBluvaultInput" onkeyup="searchedBluvaultDevices()" placeholder="Search for Devices.." title="Type in a Device Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'name'; sortReverseMSPD = !sortReverseMSPD">
                                Device
                                <span ng-show="sortTypeMSPD == 'name' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'name' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'userNamePlain'; sortReverseMSPD = !sortReverseMSPD">
                                UserName
                                <span ng-show="sortTypeMSPD == 'userNamePlain' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'userNamePlain' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'status'; sortReverseMSPD = !sortReverseMSPD">
                                Status
                                <span ng-show="sortTypeMSPD == 'status' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'status' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'createdOn'; sortReverseMSPD = !sortReverseMSPD">
                                Device Configured on
                                <span ng-show="sortTypeMSPD == 'createdOn' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'createdOn' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortTypeMSPD = 'lastSuccessfullBackup'; sortReverseMSPD = !sortReverseMSPD">
                                Last Successful Backup
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'storageValue'; sortReverseMSPD = !sortReverseMSPD">
                                Data Utilized
                                <span ng-show="sortTypeMSPD == 'storageValue' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'storageValue' && sortReverseMSPD" class="fa fa-caret-down"></span>
			    </th>
			    <th class="text-left clickAble" ng-click="sortTypeMSPD = 'lastSuccessfullBackup'; sortReverseMSPD = !sortReverseMSPD">
                                Action
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && !sortReverseMSPD" class="fa fa-caret-up"></span>
                                <span ng-show="sortTypeMSPD == 'lastSuccessfullBackup' && sortReverseMSPD" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="value in devices | orderBy:sortTypeMSPD:sortReverseMSPD track by $index">
                            <td class="text-left clickAble" title="{{ value.name }}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <span ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)"style="color:blue;text-decoration:underline;">{{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</span> <a class="hide" title="Device Configuration" ng-click="updateUserDevicePolicyInfoMsp(value.uuId)" style="font-size: 12px;"><i class="fa fa-info-circle" aria-hidden="true"></i></a></td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left" ng-cloak>{{ value.storageUsedByDevice}}</td>			    
			    <td class="text-left">
				<a href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameNew }}')?>" class="btn btn-small btn-primary" style="width: 130px;">Backup Summary</a>
				<a ng-if="(value.blocked == false && value.backupStatus != 'STARTED') && (value.blocked == false && value.backupStatus != 'SCANNING')" ng-click="initiateBackupMSP(value.uuId)" class="btn btn-small btn-primary initiateBackupBtn{{$index}}" style="color:white !important;margin-left:5px;width: 130px;">Initiate Backup</a>
				<a ng-if="(value.blocked == false && value.backupStatus == 'STARTED') || (value.blocked == false && value.backupStatus == 'SCANNING')" class="btn btn-small btn-primary" style="color:white !important;margin-left:5px;width: 130px;cursor:unset !important;">Backup In Progress</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDeviceMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, true,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked == false" class="btn btn-small btn-success" style="background: #6d5cae !important;color:white!important;margin-left:5px;width: 130px;">Deactivate</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDeviceMsp', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.uuId, false,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" class="btn btn-success btn-small" ng-if="value.blocked == true" style="color:white!important;margin-left:5px;width: 130px;">Reactivate</a>
				<a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteDevice(value.uuId,value.userNamePlain, value.name, 'backup')" ng-bootbox-confirm-action-cancel="" class="btn btn-danger btn-small" ng-if="value.blocked == true" style="color:white!important;margin-left:5px;width: 130px;">Delete</a>
				<!--<a ng-if="value.blocked == false && value.backupStatus != 'STARTED'" ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management">Backup Management</a>-->
			    </td>
                        </tr>
			</tbody>
                    </table>
		</div>
		<div class="row devicesListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountD}} of {{totalpageCountD}}</span></p>
                            <a class="btn btn-primary firstD" title="First" ng-click="manageDevicesNavigate('backup', firstD)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousD" title="Previous" ng-click="manageDevicesNavigate('backup', previousD)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextD" title="Next" ng-click="manageDevicesNavigate('backup', nextD)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastD" title="Last" ng-click="manageDevicesNavigate('backup', lastD)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
		<!--modal start-->
<div class="modal fade" id="foldersMsp">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <h4 class="modal-title">Device Configuration</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                <!-- table start-->
                                <div class="table-responsive">
                                    <table class="col-lg-12 table table-bordered table-striped">
                                        <tbody>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Default folders that will be backed up automatically</span>
                                            </td>
                                            <td class="col-lg-9">
						<!--<li ng-repeat="value in defaultFoldersMspList track by $index" ng-cloak>-->
						<span ng-repeat="value in defaultFoldersMspList track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
						</span>
						<!--</li>-->						
                                            </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>File types that will be {{filterTypeMsp}}</span>
                                            </td>
					    <td class="col-lg-9">
                                                <span>{{fileTypesMsp}}</span>
                                            </td>
                                         </tr>
                                         <tr ng-if="userDefinedFoldersMsp.length > 0">
                                            <td class="col-lg-3">
                                                <span>Device Inclusion folders</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <!--<li ng-repeat="value in userDefinedFoldersMsp track by $index" ng-cloak>-->
                                                <span ng-repeat="value in userDefinedFoldersMsp track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
                                                </span>
                                                <!--</li>-->
                                            </td>
                                         </tr>
                                         <tr ng-if="userExcludedFoldersMsp.length > 0">
                                            <td class="col-lg-3">
                                                <span>Device Exclusion folders</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <!--<li ng-repeat="value in userExcludedFoldersMsp track by $index" ng-cloak>-->
                                                <span ng-repeat="value in userExcludedFoldersMsp track by $index" ng-cloak>
                                                        <a title="{{value}}" style="word-wrap:break-word;" ng-cloak><span ng-if="$index != 0">,</span>{{ value }}</a>
                                                </span>
                                                <!--</li>-->
                                            </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Maximum file size allowed</span>
                                            </td>
					    <td class="col-lg-9">
                                                <span ng-if="maxSizeAllowedMsp == '1048576.00 MB'"> Unlimited</span>
                                                <span ng-if="maxSizeAllowedMsp != '1048576.00 MB'">Any file more than <span ng-cloak>{{ maxSizeAllowedMsp }}</span> will not be backed up</p>
                                            </td>
                                         </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- table ends-->                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
            </div>
        </div>
    </div>
<!--modal ends-->
	    </div>
		    <!--backup ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="policy" ng-controller="PmsController">
<br>
		    <!--policy management  start-->
<!--summary modal starts-->
<!--<div class="modal fade summaryPolicy" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-lg">
                <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>" <?php if(!isMobile()){ ?>style="margin-left: -50% !important;width: 200% !important;"<?php } ?>>
                    <div class="modal-header">
                        <h4 class="modal-title">Policy Summary</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">-->
			<!-- start -->
		<div class="panel" ng-controller="PmsController">
                <div class="panel-heading">
		    <h4><?=Language::show('Policy Summary', 'keywords');?>
			<select name="summaryPolicyName" id="summaryPolicyName" class="summaryPolicyName col-lg-2 hide" title='Select Backup Policy Name' style="margin-left:20px;">
                        <?php if(!empty($data['backupPolicies'])){ ?>
				<?php foreach($data['backupPolicies'] as $value){
				    if($value != 'STAGING_POLICY'){
                                	$label = $value;
                                        if( strlen( $value ) > 25 ) {
                                        	$label = substr( $label, 0, 25 ) . '...';
					}?>
                                        <option value="<?=$value?>"><?=$label?></option>
                                <?php }} ?>
                        <?php } ?>
                        </select>
			<span class="pull-right">
				<a title="Edit" class="toolTip" id="policyEdit" data-toggle="tooltip" data-placement="left" href="" ng-click="editSpecificFields()" style="margin:5px;"><i class="fa fa-edit"></i> </a>
				<a title="Export as PDF" href="" class="toolTip" id="policyDownload" data-toggle="tooltip" data-placement="top" ng-click="downloadPolicyPdfSummary()" style="margin:5px;"><i class="fa fa-download"></i></a>
			</span>
		    </h4>
                </div>
                    <div class="panel-body" id="viewBody" style="padding: 0px 30px 30px 30px;">                   
                    <div class="row">
<!--summary table starts-->
<!-- table start-->
                                <div class="table-responsive">
                                    <table class="col-lg-12 table table-bordered table-striped deviceListTable">
                                        <tbody>
                                        <!--<tr>
                                            <td class="col-lg-3">
                                                <span>Policy Name</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <span id="policygroupNameS"></span>
                                            </td>
                                         </tr>-->
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Schedules</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <!--Schedule Name : <span id="schedulesS"></span>
                                                <br>
						Schedule Time : <span id="scheduleTimeS"></span>-->
						<span class="oldd" id="scheduleTimeS"></span>
<div class="col-lg-4 editt" style="display:none;">
                                        <select class="form-control selectScheduleEditPicker" ng-model="schedulesS" name="schedulesS[]" id="schedulesS" multiple title='Select Schedules' data-max-options="2">
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
						    <?php if(strpos($value, 'AM') !== false || strpos($value, 'PM') !== false){?>
                                                    	<option value="<?=$value?>"><?=$value?></option>
						    <?php } ?>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
				    </div>
						<!--<span><a href="" class="clickAble editt" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;display:none;">Edit Schedule</a></span>-->
                                            </td>
                                         </tr>
                                         <!--<tr>
                                            <td class="col-lg-3">
                                                <span>File Versions</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <span id="maxVersionsSMo">UNLIMITED</span>
                                           </td>
                                         </tr>
                                        <tr>
                                            <td class="col-lg-3">
                                                <span>Maximum Permissible File Size (In MB)</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <span id="maxPermissibleFileSizeS"></span>
                                           </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Per Device Backup Storage Limit (In GB)</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <span id="perUserBackupStorageLimitSMo">250 GB</span>
                                           </td>
                                         </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                            	<span>Maximum Devices Allowed</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <span id="noOfDevicesAllowedS"></span>
                                           </td>
                                         </tr>-->
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>Default Folders for Backup</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <div class="col-lg-12 row"><span style="white-space: break-spaces;" id="defaultFoldersS"></span></div>
                                           </td>
					 </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Excluded Folders for Backup</span>
                                            </td>
                                            <td class="col-lg-9" style="white-space: unset;">
                                                <span class="oldd" id="excludedFoldersS"></span>
                                                <div class="col-lg-12 editt" style="display:none;">
                                                        <div class="col-lg-12 row">
                                                                <ul class="list-group list-group-horizontal" ng-show="newExcluded.length" style="display:contents !important;">
                                                                        <li class="list-group-item" ng-if="value != '' " ng-repeat="value in newExcluded track by $index">{{ value }} <a href="javascript:;" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-bootbox-confirm="Are you sure you want to remove this folder?" ng-bootbox-confirm-action="removeExclusionFolder($index)" ng-bootbox-confirm-action-cancel="" style="margin-left:10px;"><i class="fa fa-times-circle-o"></i></a></li>
                                                                </ul>
                                                        </div>
                                                        <div class="input-group col-lg-6 row">
                                                                <input type="text" class="form-control" ng-model="exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>"/>
                                                                <span class="input-group-btn">
                                                                        <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default">Add</button>
                                                                </span>
                                                        </div >
                                                </div>
                                           </td>
                                         </tr>
                                         <!--<tr>
                                            <td>
                                                <span>Exceptions to exclusions</span>
                                            </td>
                                            <td>
                                                <span id="exceptionToExclusionsFoldersS"></span>
                                           </td>
                                         </tr>-->
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>File Filters</span>
                                            </td>
                                            <td class="col-lg-9">
						<div class="col-lg-12 row">
                                                	Filter <span id="filtersType1S"></span> : <span id="filtersS"></span>
						</div>
                                                	<!--<br>
                                                	Filter Extensions : <span id="filterExtS"></span>-->
                                            </td>
                                         </tr>
					 <tr>
                                            <td class="col-lg-3">
                                                <span>Network Throttle Setting from Client to BluKrypt</span>
                                            </td>
                                            <td class="col-lg-9">
						<div class="col-lg-12 row">
	                                                <span class="oldd" id="nwFromClientToPGMBS"></span> <span class="oldd" id="networkThrottlingUnitS"></span>
	                                                <div class="slidecontainer editt" style="display:none">
	                                              		<input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRangeEdit">
	                                              		<p><span id="demoEdit">5</span> Mbps</p>
	                                            	</div>
						</div>
                                                <!--<span><a href="" class="clickAble editt" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;display:none;">Edit</a></span>-->
                                            </td>
                                         </tr>
					 <tr class="hide">
                                            <td class="col-lg-3">
                                                <span>CPU Throttling</span>
                                            </td>
                                            <td class="col-lg-9">
                                                <div class="slidecontainerS">
                                              		<input type="range" min="1" max="10" value="" name="cpuThrottlingS" class="slidercpuS" id="myRangeS"><span style="margin:20px;">  Value: <span id="demoS"></span></span>
                                            	</div>
                                            </td>
					 </tr>
                                         <tr>
                                            <td class="col-lg-3">
                                                <span>User Action Preferences</span>
                                            </td>
                                            <td class="col-lg-9">                                         
<div id="accordion">
  <div class="card">
    <div class="card-header" id="headingOne">
      <h5 class="mb-0">
	<a style="color:black; text-decoration: none;cursor:pointer;" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">Show User Action Preferences</a>
      </h5>
    </div>

    <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
      <div class="card-body" style="pointer-events:none;opacity:0.6;">
	<div class="col-lg-12 row">
	    <div class="col-lg-12 row">
		<h4 style="margin-left: 20px;">Agent</h4>
	    </div>
	    <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchMyBackupFiles" type="checkbox" name="switchMyBackupFiles" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">My Backup Files</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRestore" type="checkbox" name="switchRestore" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSettings" type="checkbox" name="switchSettings" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Settings</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchRefreshPolicy" type="checkbox" name="switchRefreshPolicy" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Refresh Policy</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchInitiateBackup" type="checkbox" name="switchInitiateBackup" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Initiate Backup</span>
            </div>
            <div class="col-lg-3 row">
		<div class="col-lg-2">
		    <label class="switch">
			<input id="switchPauseBackup" type="checkbox" name="switchPauseBackup" value="true">
			<div class="slider round"></div>
		    </label>
                </div>
                <span style="margin-left: 20%;">Pause Backup</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchStopBackup" type="checkbox" name="switchStopBackup" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Stop Backup</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchCheckForUpdate" type="checkbox" name="switchCheckForUpdate" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Check for Update</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSupportRequest" type="checkbox" name="switchSupportRequest" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Support Request</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchDecoupleDevice" type="checkbox" name="switchDecoupleDevice" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Decouple Device</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchAbout" type="checkbox" name="switchAbout" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">About</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchExit" type="checkbox" name="switchExit" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Exit</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
		    <label class="switch">
                        <input id="switchSystemIcon" type="checkbox" name="switchSystemIcon" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Systray Icon</span>
            </div>
	</div>
	<div class="col-lg-12 row">
            <div class="col-lg-12 row">
                <h4 style="margin-left: 20px;">Portal</h4>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchOpen" type="checkbox" name="switchOpen" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Open</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchView" type="checkbox" name="switchView" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">View</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchVersions" type="checkbox" name="switchVersions" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Versions</span>
            </div>
            <div class="col-lg-3 row hide">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchRestoreP" type="checkbox" name="switchRestoreP" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Restore</span>
            </div>
            <div class="col-lg-3 row">
                <div class="col-lg-2">
                    <label class="switch">
                        <input id="switchDownload" type="checkbox" name="switchDownload" value="true">
                        <div class="slider round"></div>
                    </label>
                </div>
                <span style="margin-left: 20%;">Download</span>
            </div>
	</div>
      </div>
    </div>
  </div>    
  </div>
</div>
</td>
                                         </tr>
                                         <!--<tr>
                                            <td>
                                                <span>BluKrypt Settings</span>
                                            </td>
                                            <td>
                                                BluKrypt Search Algorithm : <span id="searchAlgoForPgS"></span>
                                                <br>
                                                Preferred BluKrypt Hostnames : <span id="BlukryptipaddressS"></span>
                                           </td>
                                         </tr>-->
                                        </tbody>
				    </table>
<a href="" class="btn btn-primary clickAble pull-right editt" ng-click="closeMSPPolicy()" style="display:none;">Cancel</a>
<a href="" class="btn btn-primary clickAble pull-right editt" ng-click="policyCreateEditMsp()" style="display:none;">Apply</a>
                                </div>
                                <!-- table ends-->
<!--summary table ends-->
<!--exclusion confirmation starts-->
<div class="modal fade" id="confirmAdd1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirm(exclusionFolderName)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
<!--exclusion confirmation ends-->
                    </div>
</div>
                    </div>                   
<!--summary modal ends-->

<!--actual policy edit starts-->
<div class="panel-body hide" style="padding: 0px 30px 30px 30px;">
                    <span class="d-none currentPage"><?='editPolicy'?></span>
                    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
			'id' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreateEdit()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" value="{{ selectedPolicy.policygroupName }}" required autocomplete="off" readonly>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
			    </div>
<div class="form-group">
                                <label for="policyStorageSizeAllowed"><?=Language::show('policyStorageSizeAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyStorageSizeAllowed" id="policyStorageSizeAllowed" placeholder="" value="" autocomplete="off">
                                <label for="policyUsersAllowed"><?=Language::show('policyUsersAllowed', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyUsersAllowed" id="policyUsersAllowed" placeholder="" value="" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                      <li class="nav-item d-none" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#search" aria-expanded="false" aria-controls="advanced">Search</a></li>
<?php } ?>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                        <!--<li class="shareDetailsTab" role="presentation"><a data-target="#shareDetails" aria-controls="advanced" role="tab" data-toggle="tab">Secure Sharing</a></li>-->
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                        <li class="nav-item d-none" role="presentation"><a href="" class="nav-link" data-target="#search" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?><?php  if(PORTAL_LIGHT_VERSION == false){ ?> - <a href="" class="clickAble" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;">Create New Schedule</a><?php } ?></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                            <td>
                                                                <!--<a class="btn btn-default btn-small" ng-click="getParticularSchedule(value.scheduleName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="getParticularSchedule(value.scheduleName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxFileVersions == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchver" type="checkbox" <?php if(maxFileVersions == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxFileVersions == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxPermissibleFileSize == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox" <?php if(maxPermissibleFileSize == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxPermissibleFileSize == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>d-none<?php } ?>">
					<label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(userStorageQuta == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox" <?php if(userStorageQuta == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(userStorageQuta == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                            <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" min="1" onfocusout="myFunctionDevice();"/>
                                        <span id="deviceerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div   class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type' disabled>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div><?php } else {?>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                    		<button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default" style="padding-bottom: 10px;" type="button">Add</button>
                                	    </span>
                                        </div>
                                    </div>
				    <!-- sql start-->
				    <?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
				    <div class="form-group">
                                        <label for="sqlBackupFolders"><?=Language::show('defaultFoldersBackup', 'keywords');?> for MS SQL</label> <a href="" class="clickAble showSQLSettings" ng-click="addSqlServer()" style="font-size: small;font-weight: 600;">Configure SQL Server</a>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="sqlBackupFolders" name="sqlBackupFolders" id="sqlBackupFolders" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?> for SQL" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                        	<button ng-click="addDefaultFolderSQL(sqlBackupFolders)" class="btn btn-default sqlBackupFoldersBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    	    </span>
                                        </div>
				    </div>
				    <div class="form-group hide">
				    	<label for="serverUserNameToSave"><?=Language::show('Server User Name', 'keywords');?></label>
				    	<input type="text" class="form-control" name="serverUserNameToSave" id="serverUserNameToSave" value="" placeholder="Enter Server User Name" autocomplete="off">
				    </div>
				    <div class="form-group hide">
				    	<label for="serverPasswordToSave"><?=Language::show('Server Password', 'keywords');?></label>
				    	<input type="password" class="form-control" name="serverPasswordToSave" id="serverPasswordToSave" value="" placeholder="Enter Password" autocomplete="off">
				    </div>
				    <?php } ?>
				    <!--sql end-->
                                    <div class="form-group">
                                        <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName" placeholder="Enter the full path of the folder" autocomplete="off"
                                                data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default">Add</button>
                                            </span>
                                        </div >
                                    </div>
                                    <!--start-->
                                    <div>
                                        <div class="form-group col-lg-12">
                                            <label for="exceptionFolderName"><?=Language::show('Exceptions to exclusions', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" ng-model="exceptionFolderName" name="exceptionFolderName" id="exceptionFolderName" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>"/>
                                                <span class="input-group-btn">
                                                    <button type="button" ng-click="addExceptionFolder(exceptionFolderName)" class="btn btn-default exceptionFoldersBtn">Add</button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end-->
                                    <div class="form-group d-none">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="clientDedup"><?=Language::show('Client Dedup', 'keywords');?></label>
                                        <select class="form-control clientDedup" name="clientDedup" id="clientDedup" title='Select <?=Language::show('clientDedup', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="maxFileSizeForBkpBatch"><?=Language::show('Maximun File Size For Backup Batch', 'keywords');?></label>
                                        <input type="text" class="form-control" name="maxFileSizeForBkpBatch" id="maxFileSizeForBkpBatch" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSizeForBkpBatch', 'keywords');?>" autocomplete="off" value="50" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="overflow-y: scroll;height: 450px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
						<?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
						<div class="form-group hide" style="margin-left:10px;">
                                                    <div class="checkbox check-primary">
                                                        <input id="sqlbkpEnabled" name="sqlbkpEnabled" type="checkbox" value="enabled">
                                                        <label for="sqlbkpEnabled"><?=Language::show('Backup SQL Database', 'keywords');?></label>
                                                    </div>
						</div>
						<!--SQl start-->
						<div class="panel panel-default" style="overflow-y: scroll;height: 150px;">
							<div class="panel-heading">
								<h5> <i class="fa fa-folder-open"></i> Default MS SQL Folders</h5>
						       </div>
							<div class="panel-body">
								<div class="table-responsive">
									<div  ng-if="osType == 'universal'">
										<ul class="list-group" ng-if="sqlBackupFoldersList.length >= 1">
											<li style="word-wrap: break-word" ng-repeat="value in sqlBackupFoldersList track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolderSQL($index)"><i class="fa fa-times-circle-o"></i></a></li>
										</ul>
										<span ng-if="sqlBackupFoldersList.length <= 0">There are no default folders for SQL to backup</span>
									</div>
								</div>
							</div>
						</div>
						<!--SQL ends-->
						<?php } ?>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindows.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMac.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversal.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <!--start-->
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Exceptions to exclusions </h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersWindows.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersMac.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersUniversal.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                </div>
                                                <!--end-->
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectFilterTypePicker" name="filtersType" id="filtersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-1 inclusionBadge" style="margin-top: 10px;"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-1 exclusionBadge" style="display:none;margin-top:10px;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <!--<select class="form-control selectFilterPicker inc" ng-model="filters" name="filters[]" id="filters" title='Select Filters' multiple>
                                            <?php //if(!empty($data['IncFilters'])){ ?>
                                                <?php //foreach($data['IncFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                            <?php //} ?>
                                        </select>
                                        <select class="form-control selectFilterPicker exc" ng-model="filters" name="filters[]" id="filters1" title='Select Filters' multiple>
                                           <?php //if(!empty($data['ExcFilters'])){ ?>
                                                <?php //foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                        <?php //} ?>
                                        </select>-->
                                        <select class="col-lg-10 selectFilterPicker" name="filters[]" id="filters" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
					<div class="col-lg-12 row" style="margin-top:20px;">
						<div class="col-lg-2">
							<label class="switch">
								<input id="applyFilterToExceptionsToExclusion" type="checkbox" name="applyFilterToExceptionsToExclusion" value="true">
								<div class="slider round"></div>
							</label>
						</div>
						<span style="margin-top:5px;">Apply filters to Exceptions To Exclusions</span>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
						    <!--new start-->
						    <div class="form-group">
                                                        <label for="backupFilesWithoutExtension">Backup files without an extension</label>
                                                        <input type="checkbox" class="backupFilesWithoutExtension" name="backupFilesWithoutExtension"/>
						    </div>
						    <!--new end-->
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <!--<a class="btn btn-default btn-small pull-right" ng-click="newFilterEdit(defaultFilter.filterName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control userCreateAdmins" name="createUser[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdmins" name="deviceDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadmins" name="deviceDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsers" name="deviceDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdmins" name="deviceBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadmins" name="deviceBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsers" name="deviceBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdmins" name="deviceDecoupled[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadmins" name="deviceDecoupled[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsers" name="deviceDecoupled[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control deviceLimitReachedAdmins" name="deviceLimitReached[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadmins" name="deviceLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsers" name="deviceLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdmins" name="weeklyBkpreport[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadmins" name="weeklyBkpreport[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsers" name="weeklyBkpreport[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdmins" name="firstBkpCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadmins" name="firstBkpCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsers" name="firstBkpCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdmins" name="restoreInitiated[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadmins" name="restoreInitiated[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsers" name="restoreInitiated[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
				    
				<div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreCompletedAdmins" name="restoreCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreCompletedReadonlyadmins" name="restoreCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore completed', 'keywords');?></label>
                                        <select class="form-control restoreCompletedUsers" name="restoreCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdmins" name="storageLimitReached[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadmins" name="storageLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsers" name="storageLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <select class="form-control initiatebackup" name="initiatebackup" id="initiatebackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <select class="form-control stopbackup" name="stopbackup" id="stopbackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="about"><?=Language::show('ABOUT', 'keywords');?></label>
                                        <select class="form-control about" name="about" id="about" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                   <div class="form-group">
                                        <label for="systrayIcon"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIcon" name="systrayIcon" id="systrayIcon" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="pauseBackup"><?=Language::show('PAUSE_BACKUP', 'keywords');?></label>
                                        <select class="form-control pauseBackup" name="pauseBackup" id="pauseBackup" required="" title='Select <?=Language::show('pauseBackup', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>				    
				    <div class="form-group hide">
                                        <label for="disallowAdminRestores"><?=Language::show('Disallow Admin Restores', 'keywords');?></label>
                                        <select class="form-control disallowAdminRestores" name="disallowAdminRestores" id="disallowAdminRestores" required="" title='Select <?=Language::show('Disallow Admin Restores', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 row">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share hide">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestore">
                                            <label for="portalRestore"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestore" name="portalRestore" id="portalRestore" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabel hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
			   	    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabled" name="shareDomainsEnabled" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabled"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                        </div>
					<div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusions"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusions" id="shareDomainIncExclusions" placeholder="" autocomplete="off" value="" />
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainType" id="only" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainType" id="withall" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains excepting these', 'keywords');?></label>
							</div>
						</div>
					</div>
				    </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlock">
                                        	<label class="switch">
                                        		<input id="controllerSL" type="checkbox" name="controllerSL" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;">Allow sharer visibility to the shared link</span>

				    </div>
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">
							<div class="col-lg-2 controllerCPBlock">
								<label class="switch">
									<input id="controllerCP" type="checkbox" name="controllerCP" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>							
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlock">
								<label class="switch">
									<input id="controllerMFA" type="checkbox" name="controllerMFA" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				   </div>                                    
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectSearchFilterTypePicker" name="searchFilterType" id="searchfiltersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
                                            <!--<select class="form-control selectSearchFilterPicker incSearch" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple>
                                            <?php if(!empty($data['IncFilters'])){ ?>
                                                <?php foreach($data['IncFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                            </select>
                                            <select class="form-control selectSearchFilterPicker excSearch" name="searchfilters[]" id="searchfilters1" title='Select Filters' multiple>
                                           <?php if(!empty($data['ExcFilters'])){ ?>
                                                <?php foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>-->
					<select class="form-control selectSearchFilterPicker" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple <?php if($data['searchEnabled'] == true){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td>
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4 d-none" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group d-none" <?php if(partialFileTransfer == false){ ?>  class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version" <?php } ?>>
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>' <?php if(partialFileTransfer == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?></label>
                                            <div class="col-lg-8" <?php if(networkThrotlling == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switch" type="checkbox" <?php if(networkThrotlling == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
					</label></div>
<div class="row">
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              <span id="switchwarning" style="color: #f27331;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
					      </div>
</div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="cpuThrottling"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="slidecontainer">
                                              <input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRange">
                                              <p>Value: <span id="demo"></span></p>
                                            </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5 d-none">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group" <?php if(legalHold == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <div class="checkbox check-primary">
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled"  <?php if(legalHold == false){ ?> disabled <?php }?>>
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span class="systemFolders" style="display: none;">
                                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                                </span>
                                        </div>
                                    </div>
				    <?php if($data['rwDetectionEnabled'] == 'true'){ ?>
						<div class="col-lg-6 row">
							<span style="margin-top:5px;">Unusual Activity Detection Enabled</span>
							<div class="col-lg-2 rwDetectionEnabledBlock">
								<label class="switch">
									<input id="rwDetectionEnabled" type="checkbox" name="rwDetectionEnabled" value="true" checked>
									<div class="slider round"></div>
								</label>
							</div>
                                                </div>
				    <?php } ?>
                                    <div class="form-group col-lg-12">
				    <label class="col-lg-12" style="margin-left: -30px;" for="noOfDaysToKeepDeviceNotHeard"><?=Language::show('Block devices which have not been heard from in', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchnoOfDaysToKeepDeviceNotHeard" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-4">
                                            <input type="text" class="form-control" name="noOfDaysToKeepDeviceNotHeard" id="noOfDaysToKeepDeviceNotHeard" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('No. of Days To Keep Device Not Heard', 'keywords');?>" required autocomplete="off" value="60" onfocusout="myFunctionnoOfDaysToKeepDeviceNotHeard();"/>
                                            <span id="noOfDaysToKeepDeviceNotHearderror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
					<div class="col-lg-2" style="margin-top: 10px;"><label>days</label></div>
</div>
                                    </div>
				    <div class="form-group d-none">
                                        <label for="numberOfThreadsAllowedForBackup"><?=Language::show('Number of threads allowed for Backup', 'keywords');?></label>
                                        <input type="number" class="form-control" name="numberOfThreadsAllowedForBackup" id="numberOfThreadsAllowedForBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Number of threads allowed for Backup', 'keywords');?>" required autocomplete="off" value="" min="1" max="5"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestore"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminRestore" id="canAdminRestore" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>' onclick="flipAllowEndUserTocontrolRestore()">
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" style="margin-left:30px;<?php if($data['overridePolicySettings'] == true){?>pointer-events:none;opacity: 0.4;<?php } ?>">
                                        <label for="allowEndUserTocontrolRestore"><?=Language::show('Allow end-user over-ride', 'keywords');?></label>
                                        <select class="form-control allowEndUserTocontrolRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="allowEndUserTocontrolRestore" id="allowEndUserTocontrolRestore" required="" title='Select option'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"> <?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDelete"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDelete <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminDelete" id="canAdminDelete" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>' <?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'<?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group d-none">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>' <?php if(enableCompression == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer d-none" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'<?php if(backupFilesInUse == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg" <?php if(blukryptSearch == false){ ?> class="toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Field cannot be edited in Lite Version"<?php }?>>
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>' <?php if(blukryptSearch == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" style="background-color:#dcdcdc;" id="Blukryptipaddress" readonly />
                                    </div>
                                    <?php } else {?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <?php if(!empty($data['pgs'])){ ?>
                                            <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                <?php foreach($data['pgs'] as $key => $value){ ?>
                                                    <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                <?php } ?>
                                            </select>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group" <?php if(policyRefresh == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" required="" <?php if(policyRefresh == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                    </div>
				    <div class="form-group d-none">
                                        <label class="col-lg-12" for="logUnaccessedFiles" style="margin-top:10px;"><?=Language::show('Capture Unaccessed Items', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchlogUnaccessedFiles" name="switchlogUnaccessedFiles" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                    </div>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
				    <div class="form-group">
                                       <label for="autoupdateAgent"><?=Language::show('Auto Update Agent', 'keywords');?></label>
                                       <select class="form-control autoUpdateAgent" name="autoUpdateAgent" id="autoUpdateAgent" required="" title='Select <?=Language::show('Auto Update Agent', 'keywords')?>'>
                                           <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
				    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="switchAgentPassword" style="margin-left:-14px;"><?=Language::show('Agent uninstallation password', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAgentPassword" name="switchAgentPassword" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentPassword" style="margin-left:-14px;"><?=Language::show('password', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentPassword" id="agentPassword" value="" placeholder="Enter Password" autocomplete="off" readonly>
                                                <span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentRePassword" style="margin-left:-14px;"><?=Language::show('rePassword', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentRePassword" id="agentRePassword" placeholder="Re-Type Password" autocomplete="off" value="" data-parsley-equalto="#agentPassword" data-parsley-trigger="change" readonly/>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group">
                                       <label for="canBackupHiddenFiles"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFiles" name="canBackupHiddenFiles" id="canBackupHiddenFiles" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div style="padding-left:3%;" class="form-group row d-none">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithm" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div class="form-group">
					 <span class="row" style="margin-left: 0px;"><p>Purge deleted files from the catalog after</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchnoOfDaysToKeepDeletedFiles" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="noOfDaysToKeepDeletedFiles" id="noOfDaysToKeepDeletedFiles"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionnoOfDaysToKeepDeletedFiles();" disabled/>
                                             <span id="sizenoOfDaysToKeepDeletedFiles" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
					 </div>
					</div>
					   <div class="form-group <?php if($data['showUserConsentFieldInPolicies'] != true){?>hide<?php } ?>">
                                         <span class="row" style="margin-left: 0px;"><p>User Consent Display Text</p></span>
					<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchuserConsentEnabled" name="userConsentEnabled" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-10">
                                             <!--<input type="text" class="form-control" name="userConsentDisplayText" id="userConsentDisplayText" autocomptocomplete="off" value="" onfocusout="checkTextLength()"/>-->
						 <textarea style="width:100%" class="userConsentDisplayText" name="userConsentDisplayText" id="userConsentDisplayText" placeholder="Enter User Consent Display Text" data-parsley-trigger="change" rows="3" onfocusout="checkTextLength()"></textarea>
					     <span id="texterror" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
					</div>
					</div>   
                                     </div>
				    <div class="row">
					    <div class="col-lg-4">
						<label for="preScanCommandEnabled">Enable Pre Scan Command</label><br>
						<label class="switch">
						<input id="preScanCommandEnabled" name="preScanCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="preScanCommand"><?=Language::show('Pre Scan Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preScanCommand" id="preScanCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
					    	<div class="form-group">
					    	    <label for="legalHold">Continue backup on command-failure</label>
						    <input id="continueOnPreScan" name="continueOnPreScan" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
				    <div class="row">
				    	<div class="col-lg-4">
						<label for="preBackupCommandEnabled">Enable Pre Backup Command</label><br>
						<label class="switch">
						<input id="preBackupCommandEnabled" name="preBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					</div>
					<div class="col-lg-5 form-group">
						<label for="preBackupCommand"><?=Language::show('Pre Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preBackupCommand" id="preBackupCommand" placeholder="" autocomplete="off" value="">
					</div>
					<div class="col-lg-3">
						<div class="form-group">
							<label for="legalHold">Continue backup on command-failure</label>
							<input id="continueOnPreBkp" name="continueOnPreBkp" type="checkbox" value="enabled">
							</div>
					    </div>
					</div>
					<div class="row">
					    <div class="col-lg-4">
						<label for="postBackupCommandEnabled">Enable Post Backup Command</label><br>
						<label class="switch">
						<input id="postBackupCommandEnabled" name="postBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="postBackupCommand"><?=Language::show('Post Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="postBackupCommand" id="postBackupCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
						<div class="form-group">
					    	<label for="legalHold">Continue backup on command-failure</label>
						<input id="continueOnPostBkp" name="continueOnPostBkp" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
                                    <div class="form-group d-none">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate d-none" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
			    <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Grayed out options are currently controlled in Cloud Properties. Please speak to you Administrator or visit the Cloud Properties page to change their behavior.
                                        <br/>Both password enforcement options cannot be disabled at same time.
                                    </p>
                                </div>
                            </div>
			    </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">
                            <!--<button id="save" type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>-->
                            <a ng-bootbox-confirm="<h4><?=Language::show('Will be effective on next policy refresh, for immediate effect manually refresh policy.', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreateEdit()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/policies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
<!--actual policy edit ends-->
		    <!--policymanagement tab ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane" id="report">
<br>
		    <!--report starts-->
			<div class="row">
                <div class="panel col-lg-12">
		    <div class="panel-heading">
			<h3>Data Protection Scorecard
			<button class="btn btn-primary dropdown-toggle pull-right" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadUserBackupSummaryReport(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdf(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                              </ul>
                                        </h3>
		    </div>
<br>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12 hide">
                                <form ng-submit="updateUserBackupSummary(search.noOfDays,search.searchPolicyName)">
                                    <div class="row">
                                        <div class="col-lg-4">       
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?> 
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">Data Protection Scorecard for</label>
                                            <input type="number" id="noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" value="30"> <label style="margin-top:12px;">days </label>
                                        </div>
                                        <!--<div class="dropdown col-lg-4" style="margin-top:25px;">
                                            <button type="submit" class="btn btn-primary">View</button>
                                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadUserBackupSummaryReport(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadUserBackupSummaryReportPdf(search.noOfDays,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                              </ul>
                                            <a title="Schedule" class="btn btn-primary" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendBkpSummeryReportTimer')"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>-->
                                    </div>
                                </form>
                            </div>
                        </div>
<!--                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <br/>-->
                        <div class="table-responsive">
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Users</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left notForOffice" ng-cloak>Users with at least one device assigned</td>
                                <td class="text-left forOffice" ng-cloak>Users with at least one OneDrive assigned</td>
                                <td ng-cloak>{{ userBackupSummary.userWithDevices }}</td>
			    </tr>
			    <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users without device registered</td>
                                <td class="text-left forOffice" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left" ng-cloak>No. of users for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <!--<tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users without device registered</td>
                                <td class="text-left forOffice" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>-->
                            <?php if( $data['reportProductType'] != 'office'){ ?>
                                <tr class="text-center">
                                    <td class="text-center" ng-cloak>5.</td>
                                    <td class="text-left" ng-cloak>No. of users whose devices had a heartbeat to the server in the last <span class="heartbeat"></span> days</td>
                                    <td ng-cloak>{{ userBackupSummary.noOfUsersHeardCount }}</td>
                                </tr>
                            <?php } ?>                            
                            <tr class="text-center">
                                <?php if( $data['reportProductType'] != 'office'){ ?>
                                    <td class="text-center" ng-cloak>6.</td>
                                <?php } else { ?>
                                    <td class="text-center" ng-cloak>5.</td>
                                <?php } ?>
                                <td class="text-left notForOffice" ng-cloak>No. of users whose devices have been protected in the last <span class="protected"></span> days</td>
                                <td class="text-left forOffice" ng-cloak>No. of users whose OneDrives have been protected in the last <span class="protected"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
                            </tbody></table>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                    </div>
                </div>
		    <!--report ends-->
		    </div>
            </div>
<!--new ends-->
<!--start add-->
                <div class="modal fade" id="addUser" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <div class="modal-header">
                                <h4 class="modal-title">Add User</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
				<div class="row">
<div class="form-group col-lg-8">
					<a href="javascript:;" class="btn btn-success btn-small" ngf-select="readUserNamesFromExcelMsp($files)" <?php if(isMobile()){ ?> disabled <?php } ?>> <i class="share-icon fa fa-upload"> Import Usernames from Excel</i></a>
					<a href="" ng-click="downloadSampleMsp()" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
				    </div>
<!--start-->
<div class="row uncreatedUsers col-lg-12" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            User creation status
                            <a id="uncreatedDump" ng-click="downloadSampleExcel('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            <span id="uncreatedDumpStatement" style="color: #f55753;font-size: 0.7em !important;"></span>
                        </h3>
                    </div>
                    <div class="panel-body col-lg-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in not_created track by $index">
                                    <!--<td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{ value.userName }}</td>-->
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td ng-cloak>{{ value.errorMessage }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                
            </div>
<!--stop-->
					<div class="panel-body col-lg-12 bulkUserPanel" style="display:none;">
<div class="col-lg-10" style="border: 1px dotted #f27331;border-radius: 10px;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead ng-show="discoveredSites.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Users</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="discoveredSites.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>Add Users to Configure</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="discoveredSites.length > 0">
                                            <tr>
                                                <th class="col-lg-2"></th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Users
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
						</th>
						<th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Policy
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="discoveredSites.length > 0">
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="col-lg-2 text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
						<td ng-click="pickElement(value, $index)" ng-cloak><span title="{{value}}" style="cursor: pointer;">{{value | limitTo:25}}{{value.length > 25 ? '...' : ''}}</span></td>
						<td ng-cloak style="white-space:unset !important;">
                                                                <div>
                                                                    <select class="form-control" name="policy">
                                                                        <option value="No_Backup">No Backup</option>
                                                                        <option value="Backup">Backup</option>
                                                                    </select>
                                                                </div>
                                                 </td>
                                            </tr>
<!--                                        <tr class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="admin"/>
                                                </td>
                                                <td ng-click="pickElement('admin', $index)" ng-cloak><span title="admin" style="cursor: pointer;">admin</span></td>
                                            </tr>-->
                                        </tbody>
                                    </table>
                                </div>
                                                <!--<table class="table table-bordered">
                                                    <tbody>
                                                        <tr>
                                                            <td ng-cloak>
                                                                <div class="form-group">
                                                                    <label for="emailId"><?=Language::show('Email Id', 'keywords')?></label>
                                                                    <input type="text" class="form-control" name="emailId" id="emailId" value="" placeholder="Enter Email Id" autocomplete="off">
                                                                </div>
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <div class="form-group">
                                                                    <label for="policy"><?=Language::show('Policy', 'keywords')?></label>
                                                                    <select class="form-control" name="policy" id="policy">
                                                                        <option value="No_Backup">No Backup</option>
                                                                        <option value="Backup">Backup</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>-->
                                        </div>
                                </div>
                            </div>                            
                        </div>
                    </div>
                </div>
<!--end add-->
<!--modal start-->
<?php if($data['popup'] == 'visible') { ?>
<div class="modal fade" id="changePasswordForFirstloginConsent" tabindex="-1" role="dialog" data-keyboard="false" data-backdrop="static" aria-labelledby="myModalLabel">
                <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Change Password Consent</h4>
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            </div>
                            <div class="modal-body">
                                <p>Please change password to proceed further.</p>
                            </div>
                            <div class="modal-footer">
                                <!--<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>-->
                                <a class="btn btn-primary" id="proceedBtn" ng-click="proceedForChangePassword()">Proceed</a>
                            </div>
                        </div>
                </div>
            </div>
<?php } ?>
<!--modal ends-->
<!--modal-->
<?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
                <div class="modal-dialog">
                <!-- Modal content-->
                        <div class="modal-content">
                        <?=Form::open(array(
                            		'ng-submit' => 'changePasswordForFirstlogin()',
                            		'method' => 'post',
                            		'id' => 'changePasswordForFirstlogin',
                            		'csrf' => $data['csrf_token'],
                            		'autocomplete' => 'off',
                            		'data-parsley-validate' => true
                        		));
                        ?>
        		<div class="modal-header">
          			<h4 class="modal-title">Change Password</h4>
        		</div>
        		<div class="modal-body">
	                        <div class="form-group">
	                        	<label for="passwordGuest">Password</label>
	                        	<?php if(complexPassword == true) { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } else { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } ?>
                        	</div>
                        	<div class="form-group">
                            		<label for="rePasswordGuest">Re Type Password</label>
                            		<input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
					<span id="rePasswordError" style="color: #f55753;font-size: 0.9em;"></span>
                        	</div>
				<?php if(multifactorAuthWithAccessCode == true){ ?>
                        	<div class="form-group">
                                        <label for="accessKey">Enter One Time Access Code sent to the registered Email address - <a href="" id="generateOtpLink" style="cursor:pointer;">Resend One Time Access Code</a></label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" placeholder="<?=Language::show('Enter', 'keywords');?> <?=Language::show('One Time Access Code', 'keywords');?>" required autocomplete="off">
                                </div>
                        	<?php } ?>
				<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
				<!--collapse start-->
				<div class="form-group">
					<a ng-click="requestQR()" href="" style="margin-top:25px;">Request QR Code</a>
                                	<!--<a data-toggle="collapse" href="#qrCollapse" role="button" aria-expanded="false" aria-controls="qrCollapse"><span class="aa">Request QR Code</span><span class="aa hide">Request QR Code</span></a>-->
                            	</div>
				<div class="col-lg-12 collapse" id="qrCollapse" style="border: 1px solid rgb(242, 115, 49);">
					<div class="row" style="margin-bottom:10px;">
                                		<div class="col-lg-8">
                                    			<label for="mailId"><?=Language::show('Email Id', 'keywords');?></label>
                                    			<input type="text" class="form-control" name="mailId" id="mailId" value="<?=$_SESSION['emailId']?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('Email Id', 'keywords');?>" autocomplete="off" style="opacity:0.5;pointer-events:none;">
                                            	</div>
						<div class="col-lg-2">
						    <a type="button" class="btn btn-success" ng-click="requestQR()" style="margin-top:25px;"><?=Language::show('Submit', 'share');?></a>
						</div>
						<div class="col-lg-12">
						    <span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
						    <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
						</div>
					</div>
                            	</div>
				<!--collapse end-->
				<center class="hide"><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
                                </div></center>
				<?php } ?>
        		</div>
        		<div class="modal-footer">
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
          				<p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan the QR code sent to your Email Id and generate a one-time key.</p>
				<?php } else { ?>
        				<p style="float: left;">Note: Please change password to proceed further.</p>
				<?php } ?>
          			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
                			<a id="changePasswordBtnGuest" ng-bootbox-confirm="<h4>You may use Microsoft or Google Authenticator to set up Multi-Factor Authentication (MFA) using the QR code sent to your Email Id.  If you have not requested for QR code yet, please click Cancel and get QR code from 'Request QR Code' first.</h4>"
                                       ng-bootbox-confirm-action="changePasswordForFirstlogin()"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-primary"> <?=Language::show('save', 'keywords');?></a>
          			<?php } else { ?>
                			<button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
          			<?php } ?>
        		</div>
        		<?=Form::close();?>
      		</div>
      	</div>
  </div>
  <?php } ?>
<!--modal-->
<?php if($data['MSP_Environment_Enabled'] == 'Yes' && $data['popup'] != 'visible'){?>			    
<!--change password msp user start-->
<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?= Form::open(array(
                                                'ng-submit' => 'changePasswordMsp()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                     )); ?>                                    
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userName']?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['recoverykey']?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['googleSecretKey']?>">
				    <div class="form-group">
                                                <label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>

                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                                </div>
					    <div id="captchaDiv">
			    <?php
		    	    if(enableRecaptcha == true){
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                                imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $data['letter'];
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
			    imagepng($image, "image" . $data['count'] . ".png");
			    }
                        ?>
			</div>
			<?php if(enableRecaptcha == true){ ?>
				<div class="from-group">
				    <label>Enter captcha shown below </label>
				    <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
				    <!--<img id="captchaImage" src="image<?php echo $data['count'] ?>.png">-->
				    <span id="captchaSpan">
					<img id="captchaImage" src="https://<?=PARACLOUD_IP?>/portal/image<?=$data['count']?>.png">
				    </span>
				    <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
				</div>
                        <?php }else{ ?>
                        	<input class="form-control d-none" type="text" id="code" name="code" value="<?=$data['letter']?>" autocomplete="off"/>
			<?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>

                                </div>
                            </div>
<!--change password msp user end-->
<?php } ?>										   
<!--event hub modal start-->
<div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Backup Management</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12 hide" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12 hide" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs hide" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="row col-lg-12 fBackup hide" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                            </center>
                        </div>
                    </div>
		     <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['readOnlyAdminUser'] == 'Yes'){ ?>hide<?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Initiate Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()" style="border-radius:15px;">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius:15px;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()" style="border-radius:15px;">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()" style="border-radius:15px;">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
		    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
<!--                                        <a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--event hub modal ends-->
<!--configure sites modal start-->
<div class="modal fade configureSites">
        <div class="modal-dialog" style="width:1250px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Configure Sites</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <!--added starts-->
                    <div class="usersFound">
                            <div class="table-responsive browsePathDivOnedrive col-lg-12">
                                <div class="row col-lg-12">
<div class="col-lg-4">
                                        <div class="checkbox check-primary" style="margin-top:15px;">
                                                <input id="autoDiscover" name="autoDiscover" id="autoDiscover" type="checkbox" value="enabled">
                                                <label for="autoDiscover"><?=Language::show('Automatically configure all discovered SharePoint sites', 'keywords');?></label>
                                        </div>
</div>
<div class="col-lg-4">
                                    <div class="form-group">
                                        <!--<label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
                                        <input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">-->
                                        <label for="policyName"><?=Language::show('SharePoint Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                </div>
                                </div>
<hr>
                                <div class="row col-lg-12">
<div class="form-group col-lg-12 row">
                                <input class="form-control col-lg-3" type="text" id="searchDiscoveredSite" onkeyup="searchDiscoveredSite()" placeholder="Search for Sites.." title="Type in a Site name">

<div class="form-group col-lg-3"></div>
                                <input class="form-control col-lg-3" type="text" id="searchConfiguredSite" onkeyup="searchConfiguredSite()" placeholder="Search for Sites.." title="Type in a Site name" style="margin-left: 12px;">
</div>
                                <div class="col-lg-4" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Discovered SharePoint Sites
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
                                                <td ng-click="pickElement(value, $index)" ng-cloak><span title="{{value}}" style="cursor: pointer;">{{value | limitTo:25}}{{value.length > 25 ? '...' : ''}}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-2">
<center style="margin-top:50%;">
                                    <a ng-click="itemSelect1()" class="block btn btn-small btn-success" style="width: 50%;">><a>
                                    <br>
                                    <a ng-click="addAllName()" class="block btn btn-small btn-success" style="width: 50%;"> >><a>
                                    <br>
                                    <a ng-click="removeName1()" class="block btn btn-small btn-danger" style="width: 50%;"><</a>
                                    <br>
                                    <a ng-click="removeAllName()" class="block btn btn-small btn-danger" style="width: 50%;"><<</a>
</center>
                                </div>
                                <div class="col-lg-6" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="addedSites" class="table table-hover table-bordered">
                                        <thead ng-show="siteMapKeys.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Configured Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="siteMapKeys.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="siteMapKeys.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Configured Sites</th>
                                                <th>Policy Assigned</th>
                                            </tr>
                                        </thead>
<tbody ng-show="siteMapKeys.length > 0">
                                            <tr ng-repeat="(key,value) in aad " class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ key }}"/>
                                                </td>
                                                <td ng-click="pickElement1(key, $index)" ng-cloak><span title="{{key}}" style="cursor: pointer;">{{key | limitTo:25}}{{key.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            $la = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>" ng-selected="value == '<?=$la?>'"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
<!--<tbody ng-show="siteMapKeys.length > 0">
                                            <tr ng-repeat="(key,value) in aad" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(key, $index)" ng-cloak><span title="{{key}}" style="cursor: pointer;">{{key | limitTo:25}}{{key.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>-->
<!--                                        <tbody ng-show="addedSites.length > 0">
                                            <tr ng-repeat="value1 in addedSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1, $index)" ng-cloak><span title="{{value1}}" style="cursor: pointer;">{{value1 | limitTo:25}}{{value1.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>-->
                                    </table>
                                </div>
                                <div class="col-lg-6">
                                </div>
</div>
                            </div>
                            <div class="col-lg-12" style="margin-top:5%;">
<div class="row">
                                <div class="col-lg-6">
                                </div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success btn-small pull-right"
                                        ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to configure selected sites to the selected policy?', 'keywords')?></h4>"
                                        ng-bootbox-confirm-action="startSiteConfiguration()"
                                        ng-bootbox-confirm-action-cancel=""
                                        href="javascript:;"><?=Language::show('Configure Sites', 'keywords');?></a>
<button type="button" class="btn btn-default btn-small pull-right" data-dismiss="modal" style="margin-right:10px;">Close</button>
                                </div>
</div>
                            </div>
                        </div>
                        <!--added ends-->
                </div>
                <div class="modal-footer hide">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--configure sites model ends-->
        </div>
    </div>    
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php //View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
<script>
$(".searchDeviceNameSharepointDevice").select2({
ajax: {
            url: "<?=DIR?>"+"getAllUnBlockedSites",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultSites,
        templateSelection: selectTemplateSelectionSites,
        placeholder: 'Select sites'
    });

    function selectTemplateResultSites(users){
    	if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionSites(users){

            console.log("gggggggg : "+users.text);
            if(users.text != 'Select user'){
            $.ajax({
            url: "<?=DIR?>"+"devicesSharepoint",
            data: {deviceName: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.devicesSharepoint);
            console.log("newone111 : "+jData.devicesSharepoint[0].deviceUUID);
            if (jData.devicesSharepoint){
            var options = "";
/*jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
            });*/
//$('.searchDeviceNameOnedriveDevice').html(options);
	    /*xx start*/
//$("#uuuSharepointDevice").val(users.text);	   
$("#uuuSharepointDevice").val(jData.devicesSharepoint[0].deviceUUID);
        /*xx end*/
        	}else{
//              $('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
//                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
                $("#uuuSharepointDevice").val('');
            }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
</script>
<script>
$('.restoreDateSharepointDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
        container:'.restoreBuckettSharepointDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateSharepointDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateSharepointDevice').removeAttr('disabled');
        $('#restoreTimeSharepointDevice').removeAttr('disabled');
    } else {
        $('#restoreDateSharepointDevice').attr('disabled', true); //disable input
        $('#restoreTimeSharepointDevice').attr('disabled', true);
    }
});


$("#switchinplaceSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('required', 'required');
        $('#destinationPathlabelSharepointDevice').removeClass('star');
        $('#destinationPathSharepointDevice').attr('disabled', true);
        $('#browseSharepointDevice').attr('disabled', true);
    } else {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('disabled');
        $('#destinationPathlabelSharepointDevice').addClass('star');
        $('#destinationPathSharepointDevice').attr('required', 'required');
        $('#browseSharepointDevice').removeAttr('disabled');
    }
});

    function searchDiscoveredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchDiscoveredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("discoveredSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    function searchConfiguredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchConfiguredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("addedSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    //for user management tab start
    var assignUsers = $(".assignUsers").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsers').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }

    //for user management tab end
    
    //for device management tab starts
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevicesForDeviceList",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Devices'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
    //for device management tab ends
    
    $("#userPolicyMappingPolicyNameUsers0").change(function() {
            console.log("changed");
    });

    function changedPolicy(id) {
	    console.log("changed : "+id);
	    var index = id.replace('userPolicyMappingPolicyNameUsers', '');
	    if(!$('.existingUsers'+index).hasClass("updatedUser")){
		    $('.existingUsers'+index).addClass('updatedUser');
	    }
	    $('.edittUsers').show();
    }

    $('.selectSchedulePicker').selectpicker('render');
    $('.selectScheduleEditPicker').selectpicker('render');

    var slider = document.getElementById("myRangeEdit");
var output = document.getElementById("demoEdit");
//output.innerHTML = slider.value;

slider.oninput = function() {
  output.innerHTML = this.value;
}
</script>
<style>
.fab-wrapper{
display: none!important;
}
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 22px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
					    <script>
					    var assignUsers = $(".assignUsersMsp").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            //delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultMsp,
        templateSelection: selectTemplateSelectionMsp,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsersMsp').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResultMsp(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionMsp(users){
        return users.text;
    }

    function searchedBluvaultDevices() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchBluvaultInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    <?php if($data['popup'] == 'visible') { ?>
        $('#changePasswordForFirstloginConsent').modal('show');
    <?php } ?>

    $('#addUser').on('hidden.bs.modal', function () {
        $('.uncreatedUsers').hide();
        $('#uncreatedDump').hide();
	document.getElementById("uncreatedDumpStatement").innerHTML = "";
    });					
    </script>
    <style>
	    .invalid{
	        background-color: gainsboro !important;
	        cursor:not-allowed !important;
	        opacity: 0.4 !important;
	        pointer-events:none !important;
	    }
	    div.dropdown-menu.open{
	        max-height: 314px !important;
	        overflow: hidden;
	    }
	    ul.dropdown-menu.inner{
	        max-height: 260px !important;
	        overflow-y: auto;
	    }
 
    </style>
