<?php
use \Core\View;
use Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
*@author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 16/11/22
* @time 15:58 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
		<li><a href="<?=Url::basePath('unusualActivityHistoryForAll')?>"><?=$data['crumb1']?></a></li>
		<li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="HistoryController">
    <span class="hide currentPage"><?='unusualActivityHistory'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
<span class="hide userName"><?=$data['userName']?></span>
<span class="hide deviceName"><?=$data['deviceName']?></span>
<span class="hide deviceUUID"><?=$data['deviceUUID']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
<div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('Unusual Activity History', 'keywords')?> for <b><?=$data['currentDevice']?></b>
                    </h4>
                </div>
		<div class="panel-body noRecords" style="padding: 0px 10px 10px 10px;">
		    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center">No records found!</h2>
                        </div>
                    </div>
		</div>
<div class="hide">
                <div class="panel-body records" style="padding: 0px 10px 10px 10px; display:none;">
                    <div class="table-responsive" style="padding: 20px 10px 20px 40px;">
                        <div class="h4 loading text-center">Loading.....</div>
                        <ul class="mini-timeline">
                            <li ng-repeat="value in audits track by $index" class="mini-timeline-{{value.color}}">
                                <div class="timeline-icon"></div>
                                <div class="timeline-body">
                                    <div class="timeline-content">
					<a href="javascript:;" class="name" ng-cloak>{{ value.actionByUser }}</a> {{ value.action }} <span class="text-primary" ng-cloak>{{ value.actionOnObject }}</span> <span ng-if="value.actionUsingObject.length > 0"> <a ng-if="value.additionalInfo.length > 1" class="name" href="javascript:;" ng-cloak>{{ value.additionalInfo }}</a> using <a class="name" href="javascript:;" ng-cloak>{{ value.actionUsingObject }}</a></span>
                                        <span class="time" ng-cloak>{{ value.time }}</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="navigateUnusualActivityHistory(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="navigateUnusualActivityHistory(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="navigateUnusualActivityHistory(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="navigateUnusualActivityHistory(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
		</div>
</div>
<!--starts-->
<div class="panel-body widget widget-body" style="border: 1px solid #f27331;border-radius: 10px;">
	<h4>Device Summary</h4>
        <div class="row col-lg-12">
                <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
		<!--<p>Device Name:<b ng-cloak><?=$data['currentDevice']?></b></p>-->
		<p>User Name: <b ng-cloak><?=$data['currentUser']?></b></p>
                        <p>Total UDA Alerts: <b ng-cloak>{{ totalAlerts}}</b></p>
                </div>
                <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                        <p>Device Type: <b ng-cloak>{{ osType}}</b></p>
                        <!--<p>User Role: <b ng-cloak>{{ userRole}}</b></p>-->
                        <p>Active UDA Alerts: <b ng-cloak>{{ totalActiveAlerts}}</b></p>
                </div>
        </div>
</div>
<br>
<div class="row records">
<div class="col-lg-12">
<a class="btn btn-success showTrend pull-right" ng-click="showTrend()" style="border-radius: 20px;">Show Trend</a>
<span style="float: right;border: 1px solid #f27331;border-radius: 10px;padding-left: 5px;padding-top: 6px;">
                                <span>
                                        <input id="activeIncidents" name="activeIncidents" type="checkbox" value="enabled" checked>
                                        <label for="activeIncidents" style="font-size:11.9px;"><?=Language::show('Active Incidents Only', 'keywords');?></label>
                                </span>
</span>
<a class="btn btn-danger quarantineSpecificDevice pull-right" ng-if="statuss == false && ualen == 1" ng-click="unusualActivityActionSpecific('disabledevice')" style="border-radius: 20px;">Disable Device</a>
<a class="btn btn-success enableSpecificDevice pull-right" ng-if="statuss == true && ualen == 1" ng-click="unusualActivityActionSpecific('enabledevice')" style="border-radius: 20px;">Enable Device</a>
<a class="btn btn-primary downloadSpecificLogs pull-right" ng-click="getLogs()" style="border-radius: 20px;display:none;">Get Logs</a>
<a class="btn btn-primary ignoreSpecific pull-right" ng-click="unusualActivityActionSpecific('ignore')" style="border-radius: 20px;display:none;">Resolve</a>
</div>
</div>
<br>
<center><span id="allUnusualSpecificSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
<div class="row records">
<div class="table-responsive col-lg-12">
                            </hr>
                            <table id="CurrentBackuptable" class="table table-bordered currentBackuptable">
                                <thead>
                                <tr>
                                <th class="active text-center">
                                        <input type="checkbox" title="Select all" class="select-allS checkbox hide" name="select-allS"/>
                                </th>                                
                                <th class="text-center clickAble" ng-click="sortTypeUA = 'userName'; sortReverseUA = !sortReverseUA">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'userName' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'userName' && sortReverseUA" class="fa fa-caret-down"></span>
                                </th>
                                 <th class="text-center clickAble" ng-click="sortTypeUA = 'backupStartTimestamp'; sortReverseUA = !sortReverseUA">
                                        <?=Language::show('Backup Start Time', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'backupStartTimestamp' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'backupStartTimestamp' && sortReverseUA" class="fa fa-caret-down"></span>
                                    </th>
                                <th class="text-center clickAble" ng-click="sortTypeUA = 'alertType'; sortReverseUA = !sortReverseUA">
                                        <?=Language::show('Alert Type', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'alertType' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'alertType' && sortReverseUA" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeUA = 'totalNumberOfFiles'; sortReverseUA = !sortReverseUA">
                                        <?=Language::show('Total No. of files', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'totalNumberOfFiles' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'totalNumberOfFiles' && sortReverseUA" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeUA = 'numberOfFilesInfected'; sortReverseUA = !sortReverseUA">
                                <?=Language::show('No. of impacted files', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'numberOfFilesInfected' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'numberOfFilesInfected' && sortReverseUA" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-centerclickAble" ng-click="sortTypeUA = 'status'; sortReverseUA = !sortReverseUA">
                                        <?=Language::show('status', 'keywords')?>
                                        <span ng-show="sortTypeUA == 'status' && !sortReverseUA" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeUA == 'status' && sortReverseUA" class="fa fa-caret-down"></span>
                                </th>
                                </tr>
                                </thead>
                                <tbody>
<!--<tr class="text-center">
<td><input type="checkbox" class="select-item checkbox" name="select-item" onclick="newone()" value="{{ value.deviceUUID }}"/></td>
<td><a href="" ng-click="showDeviceDetails(value.batchId)" ng-cloak>dummy</a></td>
<td>dummy</td>
<td>dummy</td>
<td>dummy</td>
<td>dummy</td>
<td>dummy</td>
</tr>-->
                                <tr ng-repeat="value in audits | orderBy:sortTypeUA:sortReverseUA" class="text-center">
                                    <td>
                                        <input type="checkbox" class="select-itemS checkbox" name="select-itemS" ng-click="itemSelectS(value.quarantineDevice, value.deviceUUID, value.batchId)" value="{{ value.id }}"/>
                                    </td>                                    
                                    <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-cloak>{{ value.backupStartTime}}</td>
                                    <td ng-cloak>{{ value.alertType}}</td>
                                    <td ng-cloak>{{ value.totalNumberOfFiles}}</td>
                                    <td ng-cloak>{{ value.numberOfFilesInfected}}</td>
                                    <td ng-cloak>{{ value.status}}</td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<!--<div class="row records">
<div class="col-lg-12 row">
<div class="col-lg-6">
<a class="btn btn-primary quarantineDevice" ng-click="quarantineDevice()">Disable Device</a>
<a class="btn btn-primary downloadLogs" ng-click="downloadLogs()">Get Logs</a>
<a class="btn btn-primary ignore" ng-click="ignore()" style="display:none;">Ignore</a>
</div>
</div>
</div>-->
                            <div class="row records">
                            <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="navigateUnusualActivityHistory(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="navigateUnusualActivityHistory(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="navigateUnusualActivityHistory(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="navigateUnusualActivityHistory(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>

</div>
<!--modal starts-->
<div class="modal fade infGraph" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg" style="width:800px !important;">
                    <div class="modal-content">
                        <div class="modal-header">
                                        <h4 class="modal-title">Device Details</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
<div class="panel-body widget widget-body">
        <div class="row col-lg-12">
		<div class="col-lg-8 first" id="devicePro" style="border: 1px dashed black;">
                        <canvas id="myChart11" width="400" height="400" style="width:400px;height:400px;"></canvas>
                </div>
        </div>
</div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
        </div>
<!--modal ends-->
<!--modal starts-->
<div class="modal fade deviceDetails" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg" style="width:800px !important;">
                    <div class="modal-content">
                        <div class="modal-header">
			                <h4 class="modal-title">Device Details</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
			<div class="modal-body">
<div class="panel-body widget widget-body">                                                
	<div class="row col-lg-12">
		<div class="col-lg-6" style="padding: 30px 10px 10px 35px;">                                                        
			<p>Device Name:<b ng-cloak>dummy</b></p>
			<p>User Name: <b ng-cloak>dummy</b></p>
			<p>Total UDA Alerts: <b ng-cloak>dummy hours</b></p>			
		</div>
		<div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
			<p>Device Type: <b ng-cloak>dummy</b></p>
			<p>User Role: <b ng-cloak>dummy</b></p>
			<p>Active UDA Alerts: <b ng-cloak>dummy</b></p>
		</div>		
	</div>
</div>
                        <!--tableresponsive-->
                            <div class="table-responsive hide">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Start Time</th>
                                                <th>End Time</th>
                                                <th>Total No Of Files Uploaded</th>
                                                <th>Uploaded Size</th>
                                                <th>Percentage Completed</th>
                                                <th>Status</th>
                                                <th>Reason</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in batchElements">
                                                <td ng-cloak>{{ value.startTime }}</td>
                                                <td ng-cloak>{{ value.endTime }}</td>
                                                <td ng-cloak>{{ value.totalNoOfFiles }}</td>
                                                <td ng-cloak>{{ value.uploadedSize }}</td>
                                                <td ng-cloak>{{ value.uploadedPercentage }}</td>
                                                <td ng-cloak>{{ value.status }}</td>
                                                <td ng-cloak>{{ value.comments }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
        </div>
<!--modal ends-->
<!--ends-->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    /*endpoint backup start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all1").click(function () {
            var checked = this.checked;
            $("input.select-item1").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item1:checked:checked").length > 1){
               /* $('.downloadLogs').show();
	       $('.quarantineDevice').show();*/
                $('.ignore').show();
                /*$('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');*/
            }else{
                /*$('.downloadLogs').hide();
		$('.quarantineDevice').hide();*/
                $('.ignore').hide();
                /*$('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');*/
	    }
	    var arr = $('input.select-item1:checkbox:checked').map(function () {
            return this.value;
           }).get();
        console.log("arrrrr : "+arr);
        });
        //check selected items
        $("input.select-item1").click(function () {
                console.log("cameeeeeeeeeeee");
            var checked = this.checked;
            checkSelected();
            if($("input.select-item1:checked:checked").length > 1){
                    console.log("cameeeeeeeeeeee111");
                $('.downloadLogs').show();
                $('.quarantineDevice').show();
                /*$('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');*/
            }else{
                    console.log("cameeeeeeeeeeee2222");
                $('.downloadLogs').hide();
                $('.quarantineDevice').hide();
                /*$('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');*/
            }
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all1")[0];
            var total = $("input.select-item1").length;
            var len = $("input.select-item1:checked:checked").length;
            all.checked = len===total;
        }
    });
/**endpoint backup end**/
</script>
