<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
<?php if($data['MSP_Environment_Enabled'] == 'No'){?>
                <ol class="breadcrumb">
                    <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                        <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                    <?php }else{ ?>
                        <li><h3><?=$data['title']?></h3></li>
                    <?php } ?>
                    <li><a href="<?=Url::basePath('myAccount/'.$data['currentUser'])?>"><?=$data['crumb1']?></a></li>
                    <li><span>Backup Summary</span></li>
                </ol>
<?php } else { ?>
                <ol class="breadcrumb">
                    <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                        <li><h3><?=$data['title']?></h3></li>
                    <?php }else{ ?>
                        <li><h3><?=$data['title']?></h3></li>
                    <?php } ?>
                    <li><?=$data['crumb1']?></li>
                    <li><span>Backup Summary</span></li>
                </ol>
<?php } ?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="HistoryController">
        <span class="d-none token"><?=$data['csrf_token']?></span>
        <span class="d-none currentPage"><?='deviceBackupHistory'?></span>
        <div class="row profile">
            <?php if($data['MSP_Environment_Enabled'] == 'No'){?>
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <?php } else { ?>
            <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
            <?php } ?>
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('backup_activity_history', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                        <div class="table-responsive deviceHistoryTableDiv">
                            <!--<hr/>
                            <div>Summary - Total Number of Files : <span class="text-info">{{ summary.totalNoOfFiles }}</span>, Files to be backed up :  <span class="text-danger">{{ summary.noOfFilesToBeUploaded }}</span>, Percentage Completed : <span class="text-success">{{ summary.completedPercentage }}</span></div>
                            <hr/>-->
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryTable" style="display: none;">
                                <!--<colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                </colgroup>-->
                                <thead>
                                    <tr>
                                        <th class="text-left clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                            <?=Language::show('start_time', 'keywords')?>
                                            <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'endTimeLong'; sortReverse = !sortReverse">
                                            <?=Language::show('end_time', 'keywords')?>
                                            <span ng-show="sortType == 'endTimeLong' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'endTimeLong' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'totalFile'; sortReverse = !sortReverse">
                                            <?=Language::show('attempted', 'keywords')?>
                                            <span ng-show="sortType == 'totalFile' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'totalFile' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'totalNumberOfFiles'; sortReverse = !sortReverse">
                                            <?=Language::show('Total Items', 'keywords')?>
                                            <span ng-show="sortType == 'totalNumberOfFiles' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'totalNumberOfFiles' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'percentage'; sortReverse = !sortReverse">
                                            <?=Language::show('success', 'keywords')?>
                                            <span ng-show="sortType == 'percentage' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'percentage' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'failed'; sortReverse = !sortReverse">
                                            <?=Language::show('failed', 'keywords')?> 
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Click on the number below to view failed files details"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span ng-show="sortType == 'failed' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'failed' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'comments'; sortReverse = !sortReverse">
                                            <?=Language::show('comments', 'keywords')?>
                                            <span ng-show="sortType == 'comments' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'comments' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                            <?=Language::show('Detailed Analysis', 'keywords')?>
                                            <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in history | orderBy:sortType:sortReverse">
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td style="white-space:nowrap !important;" ng-if="value.status !='HIDE'" ng-cloak>{{ value.endTime }}</td>
                                    <td style="white-space:nowrap !important;" ng-if="value.status =='HIDE'" ng-cloak>-</td>
                                    <td><span class="text-info" ng-cloak>{{ value.totalFile }}</span></td>
                                    <td><span class="text-info" ng-cloak>{{ value.totalNumberOfFiles }}</span></td>
                                    <!--<td><span class="text-success clickAble" ng-click="showHistoryDetails(value.batchId, 'Uploaded', value.percentage)" ng-cloak>{{ value.percentage }}</span></td>
                                    <td><span class="text-danger clickAble" ng-click="showHistoryDetails(value.batchId, 'Failed', value.failed)" ng-cloak>{{ value.failed }}</span></td>-->
                                    <td><span class="text-success" ng-cloak>{{ value.percentage }}</span></td>
                                    <td ng-show="value.failed != 0" ng-cloak><a class="toolTip" data-toggle="tooltip" data-placement="top" href="" title="Failed files list" ng-click="downloadLogFile('<?=$data['deviceUUID']?>',value.batchId)" class="text-danger" ng-cloak>{{ value.failed }}</a></td>
                                    <td ng-show="value.failed == 0"><span class="text-info" ng-cloak>{{ value.failed }}</span></td>
                                    <td ng-cloak>{{ value.comments }} <span ng-if="value.fullBackup == true">* </span></td>
                                    <td ng-show="value.attemptIsThere == true" ><a href="" ng-click="showDetailedAnalysis(value.batchId)" class="text-danger" ng-cloak>Show Details</a></td>
                                    <td ng-show="value.attemptIsThere != true" ng-cloak> - </td>
                                </tr>
                                </tbody>
                            </table>
			    <span class="help-line text-muted deviceHistoryTable">Note:- * denotes a full backup.</span>
                        </div>
                        <div class="row deviceHistoryTable" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                                <a class="btn btn-primary first" title="First" ng-click="updateDeviceBackupHistoryNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                                <a class="btn btn-primary previous" title="Previous" ng-click="updateDeviceBackupHistoryNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                                <a class="btn btn-primary next" title="Next" ng-click="updateDeviceBackupHistoryNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                                <a class="btn btn-primary last" title="Last" ng-click="updateDeviceBackupHistoryNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php if($data['MSP_Environment_Enabled'] == 'Yes'){?>	
<!--change password msp user start-->
<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?= Form::open(array(
                                                'ng-submit' => 'changePasswordMsp()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                     )); ?>
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userName']?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['recoverykey']?>">
                                        <input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['googleSecretKey']?>">
                                    <div class="form-group">
                                                <label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>

                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                                </div>
                                            <div id="captchaDiv">
                            <?php
                            if(enableRecaptcha == true){
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                             	imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $data['letter'];
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
                            imagepng($image, "image" . $data['count'] . ".png");
                            }
                        ?>
                        </div>
                        <?php if(enableRecaptcha == true){ ?>
                                <div class="from-group">
                                    <label>Enter captcha shown below </label>
                                    <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
                                    <!--<img id="captchaImage" src="image<?php echo $data['count'] ?>.png">-->
                                    <span id="captchaSpan">
                                        <img id="captchaImage" src="https://<?=PARACLOUD_IP?>/portal/image<?=$data['count']?>.png">
                                    </span>
                                    <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
                                </div>
                        <?php }else{ ?>
                                <input class="form-control d-none" type="text" id="code" name="code" value="<?=$data['letter']?>" autocomplete="off"/>
                        <?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>

                                </div>
                            </div>
<!--change password msp user end-->
<?php } ?>
        <div class="modal fade detailedAnalysis" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg" style="width:800px !important;">
                    <div class="modal-content">
                        <div class="modal-header">
			                <h4 class="modal-title">Detailed Analysis</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                        <!--tableresponsive-->
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Start Time</th>
                                                <th>End Time</th>
                                                <th>Total No Of Files Uploaded</th>
                                                <th>Uploaded Size</th>
                                                <th>Percentage Completed</th>
                                                <th>Status</th>
                                                <th>Reason</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in batchElements">
                                                <td ng-cloak>{{ value.startTime }}</td>
                                                <td ng-cloak>{{ value.endTime }}</td>
                                                <td ng-cloak>{{ value.totalNoOfFiles }}</td>
                                                <td ng-cloak>{{ value.uploadedSize }}</td>
                                                <td ng-cloak>{{ value.uploadedPercentage }}</td>
                                                <td ng-cloak>{{ value.status }}</td>
                                                <td ng-cloak>{{ value.comments }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
        </div>
        <div class="modal fade backupHistoryDetailsModal whiteAndBigModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header" style="margin-bottom: -10px;">
			            <h4 class="modal-title">Backup History Details</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" style="margin-top: -20px;">
                            <hr/>
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-6">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                <tr>
                                    <th><?=Language::show('file_name', 'keywords')?></th>
                                    <th><?=Language::show('file_path', 'keywords')?></th>
                                    <th><?=Language::show('file_size', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in historyDetails | filterStatusType:historyDetailsType">
                                    <td ng-cloak>{{ value.fileName }}</td>
                                    <td ng-cloak>{{ value.filePath }}</td>
                                    <td><span class="text-info" ng-cloak>{{ value.size }}</span></td>
                                    <td ng-cloak>{{ value.status }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'top'
});
</script>
