<?php
use \Helpers\Url;
use \Helpers\Auth;
use Core\Language;
use Helpers\Session;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* search.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 8/6/15
* @time 3:00 PM
* 
*/
?>
<?php
$session = new Session();
    $searchEnabled = 'none';
    if(Auth::checkCloudPermission('sync') || Auth::checkCloudPermission('office365') || Auth::checkCloudPermission('backup')){
        if(Auth::checkUserPermission('admin') || Auth::checkUserPermission('readOnlyAdmin')){
            $searchEnabled = 'all';
        }else{
            $searchEnabled = 'files';
        }
    }else{
        if(Auth::checkUserPermission('admin') || Auth::checkUserPermission('readOnlyAdmin')){
            $searchEnabled = 'usersDevices';
        }else{
            $searchEnabled = 'none';
        }
    }
?>
<?php if(($session->get('MSP_Environment_Enabled') == 'true' && $session->get('userType') == 'delegatedAdmin') || ($session->get('MSP_Environment_Enabled') == 'true' && $session->get('userType') == 'user')){
$searchEnabled = 'none';
}?>
<!--<div class="morphSearchText hide"><?=$searchEnabled;?></div>-->
<div class="morphSearchText hide">all</div>
<div class="searchEnabled hide"><?php
        if(!empty($_SESSION['search']) && $_SESSION['search'] == 'enabled'){
            echo 'enabled';
        }else{
            echo 'disabled';
        }
        $_SESSION['search'] = '';
    ?></div>
<?php if($searchEnabled != 'none'){ ?>
    <?php if(Auth::checkCloudPermission('serverBackup') == false){ ?>
    
    <div id="morphsearch" class="morphsearch col-lg-12">
<!--tab start-->
		<ul class="nav nav-tabs searchTabs hide" id="searchTabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">                
                    <li role="presentation" class="nav-item"><a class="nav-link active" data-target="#simpleSearch" aria-controls="simpleSearch" role="tab" data-toggle="tab">Search</a></li>
		    <?php if(Auth::checkCloudPermission('backup') == true || $_SESSION['one_drive_backup_enabled'] == 'true' || $_SESSION['sharepointBkpEnabled'] == 'true'){ ?>
                    	<li role="presentation" class="nav-item"><a class="nav-link" data-target="#advancedSearch" aria-controls="advancedSearch" role="tab" data-toggle="tab">Advanced Search</a></li>
		    <?php } ?>
                </ul>
<!--tab ends-->
<!--        <form class="morphsearch-form" ng-submit="searchThisText(search.text)">
	    <div class="col-lg-12">
		<div class="row">
			<div class="col-lg-2 form-group">
				<select class="form-control hide" name="searchProduct" id="searchProduct" style="color: #ee5421 !important;">
					<?php if(Auth::checkCloudPermission('backup') == true){ ?>
						<option value="backup">Backup</option>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('sync') == true){ ?>
						<option value="sync">Sync</option>
					<?php } ?>
					<?php if($_SESSION['exchange_backup_enabled'] == 'true'){?>
						<option value="mail">Mail</option>
					<?php } ?>
					<?php if($_SESSION['one_drive_backup_enabled'] == 'true'){?>
						<option value="oneDrive">OneDrive</option>
					<?php } ?>
				</select>
			</div>
            <?php if(enableheaderSearch == true){ ?>
        <?php if(Auth::checkCloudPermission('sync') == '1' || Auth::checkCloudPermission('backup') == '0' )  { ?>
            <div class="col-lg-6 form-control" id="input_container col-lg-6" style="background-color:unset !important;border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>"/></div>
        <?php } else { ?>
            <div class="col-lg-6 form-control" id="input_container col-lg-6" style="background-color:unset !important;border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=BACKUP_SEARCH_MESSAGE?>"/></div>
        <?php } ?>
        <?php } elseif(enableheaderSearch == false) {?>
		<div data-toggle="tooltip" data-placement="bottom" title="Search is Disabled in Lite Version" class="toolTip col-lg-6 form-control" id="input_container col-lg-6" style="background-color:unset !important;border:1px solid #aa9184;;border-radius:10px;width:50%;" disabled="true"><span id="input_img" class="fa fa-search fa-x" style="color:#aa9184;"></span><input id="morphsearch-input" ng-modal="search.text" class="form-control" style="padding: 10px;margin-left: 14px;line-height: 25px; background: none;border: 0px; width: 96%;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>" disabled/></div>
	<?php }?>
	</div>
            <button class="morphsearch-submit" type="submit">Search</button>
         </div>
        </form>
        
        <div class="morphsearch-content">
            <div class="dummy-column">
                <a href="" class="status-text" style="font-weight: 600;">Let me know what you’d like me to search?</a>
                <a href="" class="h4 status-error" style="display: none;"></a>
                <center><span id="searchSpinnerGS" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                <div class="search-results row">
                    <div class="col-lg-6" ng-repeat="value in foundUsers track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userNameForView }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3 style="color:black;">{{ value.userName }}</h3>
                        </a>
                    </div>
		    <div class="col-lg-6" ng-repeat="value in foundSites track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.encodedUserName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3 style="color:black;">{{ value.userName }}</h3>
                        </a>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundDevices track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userNameForSearch }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/desktop_vector.jpg')?>" alt="{{ value.devicename }}"/>
                            <h3 style="color:black;">
                                <i class="fa fa-desktop"></i> {{ value.deviceName }} of user "{{ value.userName }}"
                            </h3>
                        </a>
                    </div>
                    <br>
                    <div class="col-lg-12 col-md-6 col-sm-3" id="normalView" style="display:none;">
                        <section class="dummy-media-object" style="cursor: auto; padding: 15px;" ng-repeat="value in foundFiles track by $index">
                            <a class="h4" style="color:black;">{{ value.fileName }}</a>
                            <a ng-if="value.backup =='false'" ng-click="searchDownload(value.filePath, value.fileName, value.fileRevisionID, value.backup, value.fileUser)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                            <a ng-if="value.backup =='false'" ng-click="searchOpenFolderOption(value.filePath, value.fileName)" class="btn btn-primary btn-small pull-right toolTip d-none" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>
                            <a ng-if="value.backup =='true'" ng-click="searchDownloadBackup(value.fileName, value.filePath, value.fileRevisionID, value.backup, value.fileUser, value.deviceUUID)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                            <a ng-if="value.backup =='true'" ng-click="searchOpenFolderOptionBackup(value.filePath, value.deviceId, value.deviceUUID, value.deviceName, value.deviceType, value.deviceOs, value.fileUser, value.exists)" class="btn btn-primary btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>
                            <p><span ng-bind-html="getHtmlContent(value.content)"></span></p>
                            <hr style="margin-top:0px;margin-bottom:5px;">
                            <p><span style="border: 1px solid #f27331;border-radius:5px;padding:5px;">{{value.fileUser}} : {{value.filePath}}</span></p>                        </section>
                    </div>
                    <div class="col-lg-12 col-md-6 col-sm-3" id="mailView" style="display:none;border-radius:10px;border:1px solid #f27331;margin-bottom:10px;">
                        <div id="mailViewGlobal" class="col-lg-5 col-md-6 col-sm-3" style="overflow-y: scroll;height:500px;">                 
                            <div class="table-responsive">
                                <table class="table table-hover" style="background: white;">
                                    <tr ng-class="{'selectedForSearchCommon':$index == selectedRowSearchCommon}" ng-repeat="value in foundFiles">
                                        <td ng-click="viewOutlookSearchCommon(value.fileRevisionID, value.deviceId, $index)">
                                            <div class="col-lg-1" style="margin-left:-10px;margin-top:7px;">
                                                <span class="aplhaC" style="padding:6px !important;border: 1px solid black;border-radius:50%;background:{{value.alphaColor}};">{{value.showIcon}}</span>
                                            </div>
                                            <div class="col-lg-10" style="width:90% !important;">
                                                <a class="h4" style="color:black;" ng-bind-html="value.subject | charLimitMail"> </a>
                                                <span class="pull-right">
                                                    <i ng-if="value.hasAttachments == 'true'" class="fa fa-paperclip fa-1x attach" style="margin-right:5px;color:#f27331;font-weight:bold;"></i>
                                                    <a ng-click="searchDownloadOutlookCommon(value.userName,value.fileRevisionID)" class="pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                                                    <a ng-click="initiateRestoreForOutlookSearchFileModalGS(value.deviceUUID, value.fileRevisionID, value.filePath, value.subject)" class="pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Restore file" style="margin-right:5px;"><i class="fa fa-history"></i> </a>
                                                </span>
                                                <p style="margin-top:12px;">
                                                    <span ng-bind-html="getHtmlContent(value.content)" style="font-size:11px;"></span>
                                                    <hr style="margin-top:0px;margin-bottom:5px;">
                                                    <p style="word-break:break-all;font-size:11px;"> <b>Found in:</b><span>{{value.userName}} : {{value.filePath}}</span></p>
                                                </p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="col-lg-7" style="background: #f8f8f9;">
                            <div class="panel panelMailSearchCommon" style="display:none;overflow-x: scroll;overflow-y: scroll;height:500px;">
                                                <div class="panel-heading"></div>
                                                <div class="panel-body">
                                                        <div class="subject1SearchCommon" style="display: none;"></div>
                                                        <div class="from1SearchCommon" style="display: none;"></div>
                                                        <div class="sentDate1SearchCommon" style="display: none;"></div>
                                                        <div class="to1SearchCommon" style="display: none;"></div>
                                                        <div class="cc1SearchCommon" style="display: none;"></div>
                                                        <div class="bcc1SearchCommon" style="display: none;"></div>
                                                        <div class="attachments1SearchCommon" style="display: none;">
                                                            <div class="dataa1SearchCommon" style="display:none;">
                                                                <span ng-repeat="value1 in attachmentsCommon" style="margin-right:5px;border: 1px solid #f27331;padding:2px;border-radius:5px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
                                                                    <a class="d-none" ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
                                                                </span>&nbsp;
                                                            </div>
                                                        </div>
                                                        <br>
							<div class="contentOutlook1SearchCommonDiv">
                                                        	<iframe class="contentOutlook1SearchCommon" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
							</div>								
                                                </div>
                                        </div>
                            </div>
                    </div>
                    <div class="row paginationGS" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p ng-if="currentpageCountGS !='' && totalpageCountGS != ''"><span ng-cloak>Page {{currentpageCountGS}} of {{totalpageCountGS}}</span></p>
                            <a class="btn btn-primary firstGS" title="First" ng-click="contentSearchNavigate(search.text, firstGS)" style="display: none;"><i class="fa fa-angle-double-left"></i></a></a>
                            <a class="btn btn-primary previousGS" title="Previous" ng-click="contentSearchNavigate(search.text, previousGS)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextGS" title="Next" ng-click="contentSearchNavigate(search.text, nextGS)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastGS" title="Last" ng-click="contentSearchNavigate(search.text, lastGS)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <br>                    
                </div>
            </div>
        </div>-->
<!--new tabs start-->
<div class="tab-content">
<div role="tabpanel" class="tab-pane active" id="simpleSearch">
<form class="morphsearch-form" ng-submit="searchThisText(search.text)">
	    <div class="col-lg-12">
		<div class="row">
			<div class="col-lg-2 form-group hide">
				<select class="form-control hide" name="searchProduct" id="searchProduct" style="color: #ee5421 !important;">
					<?php if(Auth::checkCloudPermission('backup') == true){ ?>
						<option value="backup">Backup</option>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('sync') == true){ ?>
						<option value="sync">Sync</option>
					<?php } ?>
					<?php if($_SESSION['exchange_backup_enabled'] == 'true'){?>
						<option value="mail">Mail</option>
					<?php } ?>
					<?php if($_SESSION['one_drive_backup_enabled'] == 'true'){?>
						<option value="oneDrive">OneDrive</option>
					<?php } ?>
				</select>
			</div>
            <?php if(enableheaderSearch == true){ ?>
        <?php if(Auth::checkCloudPermission('sync') == '1' || Auth::checkCloudPermission('backup') == '0' )  { ?>
            <div class="col-lg-6 form-control" id="input_container" style="background-color:unset !important;border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>"/></div>
        <?php } else { ?>
            <div class="col-lg-6 form-control" id="input_container" style="background-color:unset !important;border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=BACKUP_SEARCH_MESSAGE?>"/></div>
        <?php } ?>
        <?php } elseif(enableheaderSearch == false) {?>
		<div data-toggle="tooltip" data-placement="bottom" title="Search is Disabled in Lite Version" class="toolTip col-lg-6 form-control" id="input_container" style="background-color:unset !important;border:1px solid #aa9184;;border-radius:10px;width:50%;" disabled="true"><span id="input_img" class="fa fa-search fa-x" style="color:#aa9184;"></span><input id="morphsearch-input" ng-modal="search.text" class="form-control" style="padding: 10px;margin-left: 14px;line-height: 25px; background: none;border: 0px; width: 96%;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>" disabled/></div>
	<?php }?>
<button id="morphsearch-submit" class="morphsearch-submit" type="submit">Search</button>
	</div>
<!--            <button class="morphsearch-submit" type="submit">Search</button>-->
         </div>
        </form>
<div class="morphsearch-content">
            <div class="dummy-column">
<!--                <a class="status-text" style="font-weight: 600;">Let me know what do you want me to search for?</a>-->
                <a class="h4 status-error" style="display: none;"></a>
                <center><span id="searchSpinnerGS" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                <div class="search-results row">                                                            
                    <div class="col-lg-6" ng-repeat="value in foundUsers track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.encodedUserName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3 style="color:black;">{{ value.userName }}</h3>
                        </a>
                    </div>
		    <div class="col-lg-6" ng-repeat="value in foundSites track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.encodedUserName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3 style="color:black;">{{ value.userName }}</h3>
                        </a>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundDevices track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userNameForSearch }}/{{ value.devicename }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/desktop_vector.jpg')?>" alt="{{ value.devicename }}"/>
                            <h3 style="color:black;">
                                <i class="fa fa-desktop"></i> {{ value.deviceName }} of user "{{ value.userName }}"
                            </h3>
                        </a>
                    </div>
		    <span ng-if="foundUsers.length <= 0 && foundDevices.length <= 0 " class="h4">Couldn't find any users or devices matching the search criteria</span>
                </div>
            </div>
        </div>
        
</div>
<div role="tabpanel" class="tab-pane" id="advancedSearch">

<form class="morphsearch-form" ng-submit="searchThisTextAd(search.text)">
	    <div class="col-lg-12">
		<div class="row">
			<div class="col-lg-2 form-group searchProductAdDiv hide">
				<label for="searchProductAd">Product Type</label>
				<select class="form-control" name="searchProductAd" id="searchProductAd" style="color: #ee5421 !important;">
					<?php if(Auth::checkCloudPermission('backup') == true){ ?>
						<option value="backup">Backup</option>
					<?php } ?>
					<?php if($_SESSION['one_drive_backup_enabled'] == 'true'){?>
						<option value="oneDrive">OneDrive</option>
					<?php } ?>
					<?php if($_SESSION['Sharepoint_Backup_Enabled'] == 'true' || $_SESSION['sharepointBkpEnabled'] == 'true'){?>
                                                <option value="SHAREPOINT">SharePoint Online</option>
                                        <?php } ?>
				</select>
			</div>
			<div class="col-lg-4 searchUsernameAdDiv hide" style="display:none;">
				<label class="star" id="searchUsernamelabelAd" for="searchUsernameAd">User ID</label>
				<?php if($session->get('admin') == '1'){?>
                                            <select name="searchUsernameAd"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameAd"
                                                    id="searchUsernameAd"
						    placeholder="Enter a 'username' and hit enter to search"
						    
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
					    </select>
				<?php } else { ?>
                                            <select name="searchUsernameAd"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameAd"
                                                    id="searchUsernameAd"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
                                                    <option value="<?=$session->get('userName')?>"><?=$session->get('userName')?></option>
                                            </select>
				<?php } ?>
			</div>
			<div class="form-group col-lg-4 selectOwnerShipAdDiv hide" style="display:none;">
                        	<label class="star" id="searchDeviceNamelabelAd" for="ownerAd">Device Name</label>
				<select class="searchDeviceNameAd form-control" id="searchDeviceNameAd" readonly></select>
				<!--<select class="searchDeviceNameAd form-control" id="searchDeviceNameAd" required="required" readonly></select>-->
			</div>
			<!--<div class="form-group col-lg-4 selectSharepointAdDiv hide" style="display:none">-->
			<div class="form-group col-lg-4 selectSharepointAdDiv">
                        	<label class="star" id="searchSharepointlabelAd" for="ownerAd">Site</label>
                        	<select class="searchSharepointAd form-control" id="searchSharepointAd" style="width:100%;"></select>
			</div>
                    </div>
                    <div class="row">
            <?php if(enableheaderSearch == true){ ?>
        <?php if(Auth::checkCloudPermission('sync') == '1' || Auth::checkCloudPermission('backup') == '0' )  { ?>
            <div class="col-lg-10 form-control" id="input_containerAd" style="background-color:unset !important;border:1px solid #f27331;border-radius:10px;width:50%;"><span id="input_imgAd" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-inputAd" ng-modal="search.text" class="morphsearch-inputAd" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE1?>"/></div>
        <?php } else { ?>
            <div class="col-lg-10 form-control" id="input_containerAd" style="background-color:unset !important;border:1px solid #f27331;border-radius:10px;width:50%;"><span id="input_imgAd" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-inputAd" ng-modal="search.text" class="morphsearch-inputAd" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=BACKUP_SEARCH_MESSAGE1?>"/></div>
        <?php } ?>
        <?php } elseif(enableheaderSearch == false) {?>
		<div data-toggle="tooltip" data-placement="bottom" title="Search is Disabled in Lite Version" class="toolTip col-lg-10 form-control" id="input_containerAd" style="background-color:unset !important;border:1px solid #aa9184;;border-radius:10px;width:50%;" disabled="true"><span id="input_img" class="fa fa-search fa-x" style="color:#aa9184;"></span><input id="morphsearch-inputAd" ng-modal="search.text" class="form-control" style="padding: 10px;margin-left: 14px;line-height: 25px; background: none;border: 0px; width: 96%;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE1?>" disabled/></div>
	<?php }?>
	<div class="col-lg-2">
                <button id="morphsearch-submitAd" class="morphsearch-submit" type="submit">Search</button>
        </div>
	</div>
            <!--<button id="morphsearch-submitAd" class="morphsearch-submit" type="submit">Search</button>-->
         </div>
        </form>

<div class="morphsearch-content">
            <div class="dummy-column">
<!--                <a class="status-text" style="font-weight: 600;">Let me know what do you want me to search for?</a>-->
                <a class="h4 status-errorAd" style="display: none;"></a>
                <center><span id="searchSpinnerGSAd" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                <div class="search-resultsAd row">
                    <div class="col-lg-12 col-md-6 col-sm-3" id="normalView" style="display:none;border-radius: 10px;border: 1px solid #f27331;">
                        <section class="dummy-media-object" style="cursor: auto; padding: 15px;" ng-repeat="value in foundFiles track by $index">
                            <a class="h4" style="color:black;">{{ value.fileName }} <!--<span class="h6" style="color:black;">, <b>Found in:</b> {{ value.filePath }}</span>--></a>
<!--                            <a ng-if="value.backup =='false'" ng-click="searchDownload(value.filePath, value.fileName, value.fileRevisionID, value.backup, value.fileUser)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                            <a ng-if="value.backup =='false'" ng-click="searchOpenFolderOption(value.filePath, value.fileName)" class="btn btn-primary btn-small pull-right toolTip hide" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>-->
                            <a ng-click="searchDownloadBackup(value.fileName, value.filePath, value.fileRevisionID, value.backup, value.fileUser, value.deviceUUID, value.folder)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
			    <a ng-click="searchOpenFolderOptionBackup(value.filePath, value.deviceId, value.deviceUUID, value.deviceNameEnc, value.deviceType, value.deviceOs, value.fileUser, value.blocked)" class="btn btn-primary btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>
			    <p><span class="h6" style="color:black;"><b>Found in:</b> {{ value.filePath }}</span></p>
                            <p><span ng-bind-html="getHtmlContent(value.content)"></span></p>
                        </section>
		    </div>
<div class="col-lg-12 col-md-6 col-sm-3 row" id="mailView" style="display:none;border-radius:10px;border:1px solid #f27331;margin-bottom:10px;">
                        <div id="mailViewGlobal" class="col-lg-5 col-md-6 col-sm-3" style="overflow-y: scroll;height:500px;">
                            <div class="table-responsive">
                                <table class="table table-hover" style="background: white;">
                                    <tr ng-class="{'selectedForSearchCommon':$index == selectedRowSearchCommon}" ng-repeat="value in foundFiles">
                                        <td ng-click="viewOutlookSearchCommon(value.fileRevisionID, value.deviceId, $index)">
                                            <div class="col-lg-12 row">
						<div class="col-lg-1" style="margin-left:-10px;margin-top:7px;">
                                                	<span class="aplhaC" style="padding:6px !important;border: 1px solid black;border-radius:50%;background:{{value.alphaColor}};">{{value.showIcon}}</span>
                                            	</div>
                                            	<div class="col-lg-12" style="width:100% !important;">
                                                	<a class="h4" style="color:black;" ng-bind-html="value.subject | charLimitMail"> </a>
                                                	<span class="pull-right">
                                                    		<i ng-if="value.hasAttachments == 'true'" class="fa fa-paperclip fa-1x attach" style="margin-right:5px;color:#f27331;font-weight:bold;"></i>
                                                    		<a ng-click="searchDownloadOutlookCommon(value.userName,value.fileRevisionID)" class="pull-right" data-toggle="tooltip" data-placement="bottom" title="Download" style="cursor:pointer;"><i class="fa fa-download"></i> </a>
                                                    		<a ng-click="initiateRestoreForOutlookSearchFileModalGS(value.deviceUUID, value.fileRevisionID, value.filePath, value.subject)" class="pull-right" data-toggle="tooltip" data-placement="bottom" title="Restore file" style="margin-right:5px;cursor:pointer;"><i class="fa fa-history"></i> </a>
                                                	</span>
                                                	<p style="margin-top:12px;">
                                                    		<span ng-bind-html="getHtmlContent(value.content)" style="font-size:11px;"></span>
                                                    		<hr style="margin-top:0px;margin-bottom:5px;">
                                                    		<p style="word-break:break-all;font-size:11px;"> <b>Found in:</b><span>{{value.userName}} : {{value.filePath}}</span></p>
                                                	</p>
                                            	</div>
					    </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="col-lg-7" style="background: #f8f8f9;">
                            <div class="panel panelMailSearchCommon" style="display:none;overflow-x: scroll;overflow-y: scroll;height:500px;">
                                                <div class="panel-heading"></div>
                                                <div class="panel-body">
                                                        <div class="subject1SearchCommon" style="display: none;"></div>
                                                        <div class="from1SearchCommon" style="display: none;"></div>
                                                        <div class="sentDate1SearchCommon" style="display: none;"></div>
                                                        <div class="to1SearchCommon" style="display: none;"></div>
                                                        <div class="cc1SearchCommon" style="display: none;"></div>
                                                        <div class="bcc1SearchCommon" style="display: none;"></div>
                                                        <div class="attachments1SearchCommon" style="display: none;">
                                                            <div class="dataa1SearchCommon" style="display:none;">
                                                                <span ng-repeat="value1 in attachmentsCommon" style="margin-right:5px;border: 1px solid #f27331;padding:2px;border-radius:5px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
                                                                    <a class="d-none" ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
                                                                </span>&nbsp;
                                                            </div>
                                                        </div>
                                                        <br>
							<div class="contentOutlook1SearchCommonDiv">
                                                        	<iframe class="contentOutlook1SearchCommon" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
							</div>
                                                </div>
                                        </div>
                            </div>
                    </div>
                    <div class="row paginationGS" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <!--<p ng-if="currentpageCountGS !='' && totalpageCountGS != ''"><span ng-cloak>Page {{currentpageCountGS}} of {{totalpageCountGS}}</span></p>-->
			    <!--<a class="btn btn-primary firstGS" title="First" ng-click="contentSearchNavigate(search.text, firstGS)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>-->
                            <!--<a class="btn btn-primary previousGS" title="Previous" ng-click="searchThisTextAdNavigate(previousGS)" style="display: none;"><i class="fa fa-angle-left"></i></a>-->
                            <!--<a class="btn btn-primary nextGS" title="Next" ng-click="searchThisTextAdNavigate(nextGS)" style="display: none;"><i class="fa fa-angle-right"></i></a>-->
			    <!--<a class="btn btn-primary lastGS" title="Last" ng-click="contentSearchNavigate(search.text, lastGS)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>-->
                        </div>
                    </div>                                        
                </div>
            </div>
        </div>  
        
        </div>    
        </div>
<!--new tabs ends-->	
        <span class="morphsearch-close"></span>
    </div><!-- /morphsearch -->

<!-- restore for outlook file search start -->
<div class="modal fade restoreBuckettOutlookSearchFileGS" style="z-index: 10000000000;" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                 <!--       <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <div class="form-group col-lg-12">
                                        <span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookSearchFileGS"></span>
                                    </div>
                                <div class="settingsDivOutlookSearchFileGS">
                                    <div class="col-lg-12">
                                        <div class="row" style="margin-left:0px;">
                                            <span class="star" for="searchDeviceNameOutlookSearchFileGS">Search a destination device:</span>
					</div>
<div class="row">
                                        <?php if(Auth::checkUserPermission('admin')){ ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookSearchFileGS">User ID</label>
                                            <select name="searchUsernameOutlookSearchFileGS"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookSearchFileGS"
                                                    id="searchUsernameOutlookSearchFileGS"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
                                        <?php } else { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookSearchFileGS">User ID</label>
                                            <select name="searchUsernameOutlookSearchFileGS"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookSearchFileGS"
                                                    id="searchUsernameOutlookSearchFileGS"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
                                                    <option value="<?=$_SESSION['userName']?>"><?=$_SESSION['userName']?></option>
                                            </select>
                                        </div>
                                        <?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookSearchFileGS" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookSearchFileGS form-control" id="searchDeviceNameOutlookSearchFileGS" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="d-none" type="text" id="uuuOutlookSearchFileGS" value=""/>

                                    <div class="form-group col-lg-12 destinationPathlabelOutlookSearchFileDivGS">
                                        <br/>
                                        <label id="destinationPathlabelOutlookSearchFileGS" for="destinationPathOutlookSearchFileGS">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathlabelOutlookSearchFileGS" id="destinationPathlabelOutlookSearchFileGS" placeholder="<?=Language::show('Select a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOutlookSearchFileGS" ng-click="browseOutlookSearchFileGS()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;">Restore Options</legend>
                                        <div class="col-lg-12 row disallowbackupOutlookSearchFileDivGS">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookSearchFileGS">Disallow new backups during this restore</label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookSearchFileGS" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookSearchFileGS">In place Restore</label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookSearchFileGS" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row restoreDeletedFilesOutlookSearchFileGSDiv">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookSearchFileGS"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookSearchFileGS" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 RestoreDataBeforeDivOutlookSearchFileGS" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
<label style="margin-top:7px;" for="maxVersionsOutlookSearchFileGS">Restore Data Before</label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlookSearchFileGS" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                                </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookSearchFileGS">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookSearchFileGS" id="restoreDateOutlookSearchFileGS" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookSearchFileGS">Time</label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookSearchFileGS" name="restoreTimeOutlookSearchFileGS" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookSearchFileGS col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
                                    <span class="d-none" id="batchIdOutlookSearchFileGS"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span title="{{progress.currentFolderPath}}/{{ progress.subject}}" ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
                                            <td ng-if="progress.currentFolderPath == ''">-</td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress" title="{{progress.totalRestorePct}}%">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="cursor:pointer;color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOutlookSearchFileGS()"  class="btn btn-default initiateRestoreBtnOutlookSearchFileGS">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmOutlookSearchFileGS()" class="btn btn-primary cancelRestoreBtnOutlookSearchFileGS" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookSearchFileGS()" class="btn btn-default normalCancelOutlookSearchFileGS" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookSearchFileGS()"  class="btn btn-default warningCancelOutlookSearchFileGS" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>

<div class="modal fade restoreWindowConfirmCloseOutlookSearchFileGS" style="z-index: 10000000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookSearchFileGS()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookSearchFileGS" style="z-index: 10000000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookSearchFileGS()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                            </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookSearchFileGS" style="z-index:1000000000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
			<div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookSearchFileGS == ''" ng-cloak>/</span><span ng-if="pathOutlookSearchFileGS != ''" ng-cloak>{{pathOutlookSearchFileGS}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookSearchFileGS(pathOutlookSearchFileGS)" style="margin:5px;" ng-if="pathOutlookSearchFileGS != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookSearchFileGS">
<span class="noPathOutlookSearchFileGS" style="display:none;"> No path available</span>
                        <span ng-if="browseElementsGS == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookSearchFileGS" class="table table-hover table-bordered browsePathOutlookSearchFileGS" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElementsGS" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookSearchFileGS(value, $index)" ng-dblclick="getChildsOutlookSearchFileGS(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
    <label for="newFolderOutlookSearchFileGS"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookSearchFileGS" id="newFolderOutlookSearchFileGS" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookSearchFileGS()" class="btn btn-default addNewFolderBtnOutlookSearchFileGS" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookSearchFileGS" ng-click="usePathOutlookSearchFileGS(pathOutlookSearchFileGS)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook file search end -->
<div id="overlayText"><center><h2 style="color:white;margin-top:20%;">Your files are being prepared for download. This operation could take some time. Please be patient during this time and don’t close this tab. If you wish to perform other operations – you can duplicate this tab and continue to perform other actions.</h2></center></div>
    <?php } ?>
<?php } ?>
<style>
    #input_container {
    position:relative;
    padding:0 0 0 20px;
    margin:0 20px;
    border-radius: 10px !important;
    width: 50%;
    border: 1px solid white;
    
    }
    #input_img {
    position:absolute;
    left:9px;
    top:9px;
    }

#input_imgAd {
    position:absolute;
    left:9px;
    top:9px;
    }

#input_imgFull {
    position:absolute;
    left:9px;
    top:9px;
    }
    
#custom-search-input{
    border: solid 1px #E4E4E4;
    border-radius: 6px;
    background-color: #fff;
}

#custom-search-input input{
    border: 0;
    box-shadow: none;
}

#custom-search-input button{
    margin: 2px 0 0 0;
    background: none;
    box-shadow: none;
    border: 0;
    color: #666666;
    padding: 0 8px 0 10px;
    border-left: solid 1px #f27331;
}

#custom-search-input button:hover{
    border: 0;
    box-shadow: none;
    border-left: solid 1px #f27331;
}

#custom-search-input .glyphicon-search{
    font-size: 23px;
}

@-moz-document url-prefix() {
  #input_img {
     /*padding-top: 10px;*/
  }
  #morphsearch-input {
    margin-left: 25px;
  }
}
/*#input_container {
    position:relative;
    padding:0 0 0 20px;
    margin:0 20px;
    border-radius: 10px !important;
    width: 50%;
    border: 1px solid white !important;

    }
    #input_img {
    position:absolute;
    left:9px;
    top:9px;
    }

#custom-search-input{
    border: solid 1px #E4E4E4;
    border-radius: 6px;
    background-color: #fff;
}

#custom-search-input input{
    border: 0;
    box-shadow: none;
}

#custom-search-input button{
    margin: 2px 0 0 0;
    background: none;
    box-shadow: none;
    border: 0;
    color: #666666;
    padding: 0 8px 0 10px;
    border-left: solid 1px #f27331;
}

#custom-search-input button:hover{
    border: 0;
    box-shadow: none;
    border-left: solid 1px #f27331;
}

#custom-search-input .glyphicon-search{
    font-size: 23px;
}

@-moz-document url-prefix() {
  #input_img {
     padding-top: 10px;
  }
  #morphsearch-input {
    margin-left: 25px;
  }
}*/
</style>
<style>
.selectedForSearchCommon{
background: #ece5e2 !important;
/*background: #f27331 !important;*/
/*    background-color:black;
    color:white;
    font-weight:bold;*/
}
.selectedForSearchCommon .attach{
/*color: white !important;*/
}
td:nth-child(2) {
white-space: unset !important;
}
</style>

<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.example {
  border: 1px solid;
  border-radius: 10px;
  padding: 10px;
  box-shadow: 5px 10px #888888;
}
</style>
<style>
.selected td{
background: #ece5e2 !important;
/*    background-color:black;
    color:white;
    font-weight:bold;*/
}
</style>
<style>
.modal {
  overflow-y:auto;
}
#overlayText {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 1000000000000;
  cursor: pointer;
}	
</style>
