/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SupportController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.sortReverse = true;
    $scope.sortType = 'convertedOne';
    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.parabluInstalledVerion = '';
    $scope.statistics = {};
    $scope.pageNumber = 1;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';
    $scope.fileList = [];
    $scope.sortTypeD = 'lastServerModifiedTimeinMillis';

    $scope.updatedSupportLogs = function(){
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        $.ajax({
            url: $scope.BASE_FOLDER+'/support',
            data: {secret: '',csrf_token: $('.csrf_token').html(),pageNumber:pageNumber},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                console.log("prev : "+jData.metadata.links.previous);
                console.log("next : "+jData.metadata.links.next);
                console.log("last : "+jData.metadata.links.last);
                //console.log("self : "+jData.metadata.links.self);
                console.log("first : "+jData.metadata.links.first);
                if(jData.supportLogs.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
                    $scope.supportLogs = jData.supportLogs;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no support logs found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updatedSupportLogsNavigate = function(url){
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        $.ajax({
            url: $scope.BASE_FOLDER+'/support1',
            data: {secret: '',csrf_token: $('.csrf_token').html(),url:url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                console.log("prev : "+jData.metadata.links.previous);
                console.log("next : "+jData.metadata.links.next);
                console.log("last : "+jData.metadata.links.last);
                //console.log("self : "+jData.metadata.links.self);
                console.log("first : "+jData.metadata.links.first);
                if(jData.supportLogs.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
                    $scope.supportLogs = jData.supportLogs;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no support logs found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getSupportLogs = function(serverHostName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/getSupportLogs',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
                $scope.updatedSupportLogs();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.overview = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/supportOverview',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                //$scope.parabluInstalledVerion = jData.parabluInstalledVerion;
                $scope.statistics = jData.statistics;
                $scope.updatedSupportLogs();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadLog = function(log){
        window.location.href = log;
    };
    
    $scope.sendMeTo = function(location){
        window.location.href = location;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'support'){
            blockUI.start();
            $scope.overview();
            //$scope.updatedSupportLogs();
        }
        if($scope.currentPage == 'downloads'){
	        $scope.getDownloads();
	    }
    });

    $scope.getDownloads = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/support/getDownloads',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.fileList.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
		            $scope.fileList = jData.fileList;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no files found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
		        $scope.$apply();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadFile1 = function($type){
        window.location.href = $scope.BASE_FOLDER+'/trigger/downloadFile?type='+$type;
    };
    
    $scope.downloadFile = function(name){
        var browser = '';
        if(navigator.userAgent.indexOf("Firefox") != -1 ){
            browser = 'Firefox';
        }
        if(navigator.userAgent.indexOf("Chrome") != -1 ){
            browser = 'Chrome';
        }
        window.open($('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/download/pstFile/?fileName='+Base64.encode(htmlspecialchars_decode(name))+'&user-agent='+browser, '_self');
    };

	var Base64 = {
    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

        }

        return output;
},


    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;
    },

    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {
        c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }

}

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

}]);
