/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SettingController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'md5', function($scope, toastr, Upload, $http, $ngBootbox, blockUI, BASE_FOLDER, md5) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.userStatus   = $('.userStatusCollector').html();
    $scope.currentPage   = $('.currentPage').html();
    $scope.adcS = [];
    $scope.ccS = [];
    $scope.keys = [];
    $scope.aad = [];
    $scope.pro = [];
    $scope.gpname = [];
    $scope.listSortType = 'lastModifiedTimeMillis';
    $scope.sortReverse = true;
    $scope.addedElements = [];
    $scope.aadList = [];
    $scope.vaultSecret = '';
	
    $scope.showInfo = function(){
        $('#info').modal('show');
    };

    $scope.saveEmailConfiguration = function(){
        if($('.emailConfiguration').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/email',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    $scope.saveOneDriveConfiguration = function(){
        if($('.oneDriveConfiguration').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#oneDriveConfiguration input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/oneDriveDetails',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 1000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>','Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveBlukryptSettings = function(){
            var proxySaveHtml = $('.proxySave').html();
            $('.proxySave').attr('disabled','disabled');
            $('.proxySave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/blukryptSettings',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.proxySave').removeAttr('disabled');
                $('.proxySave').html(proxySaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $scope.saveSmtpConfiguration = function () {
        if($('.smtpConfiguration').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#smtpConfiguration input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var html = $('.saveSMTP').html();
            $('.saveSMTP').attr('disabled','disabled');
            $('.saveSMTP').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var encrypt = new JSEncrypt();
            encrypt.setPublicKey($('#pubkey').val());
            var encrypted = encrypt.encrypt($('#smtpPwd').val());
            encrypted = encrypted.replace(/\//g,"_");
            encrypted = encrypted.replace(/\+/g,".");
            encrypted = encrypted.replace(/\=/g,"-");
            
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/smtp',
                data: $('.smtpConfiguration').not("#smtpPwd").serialize()+'&smtpPwd='+encrypted,
                type: 'POST'
            }).done(function(data){
                $('.saveSMTP').removeAttr('disabled');
                $('.saveSMTP').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#testMail').modal('show');
                    /*setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/settings';
                    }, 3000);*/
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    $scope.testMail = function(){
        var email = $('#testEmail').val();
        var btn = $('.testEmailBtn');
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Sending... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/testMail',
            data: {csrf_token: $('.csrf_token').html(), email: email}
        }).done(function(data){
                btn.removeAttr('disabled');
                btn.html(html);
                /*var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#testMail').modal('hide');
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/settings';
                    }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    $('#testMail').modal('hide');
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/settings';
                    }, 3000);
                }*/
                toastr.success('An Email has been triggered to your email address please check', 'Successful!!!', {allowHtml: true});
                    $('#testMail').modal('hide');
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/settings';
                    }, 3000);
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                     }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };


    $scope.closeTestMail = function () {
        $('#testMail').modal('hide');
        setTimeout(function(){
            window.location.href = $scope.BASE_FOLDER+'/settings';
        }, 1000);
    };

    $scope.saveCloudConfiguration = function () {
	var re = /(<([^>]+)>)/gi;
        var ja = /({([^>]+)})/gi;
        var count = 0;
        $("form#cloudConfiguration input[type=text]").each(function(){
		var input = $(this);
		var text = $(this).val();
		if (text.match(re) || text.match(ja)) {
		count = count+1;
		}
	});
        if(count >0){
        	toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
        	return;
        }
        var canUser = $('select[name="canUserChangePassword1"]').val();
        var canAdmin = $('select[name="canAdminChangeUserPassword1"]').val();
        if($('span#delayerror').text() != "")
        {
            toastr.error('Please check the value for Bulk Email Delay  ', 'Fail!!!', {allowHtml: true});
            return;
        }
	if($("#enableRecaptcha").val() == 'true' && $("#googleAuthenticator").val() == 'true'){
            toastr.error('Either Brute force protection or Multi-factor authentication is allowed, Please choose any one.', 'Fail!!!', {allowHtml: true});
            return;
        }
        var supportMailNew = $('#supportMail').val();
        supportMailNew = supportMailNew.replace(/\s/g, "");
        supportMailNew = supportMailNew.split(',');
        var flag = $('#controller1').is(':checked');
         console.log("flag :"+$('select[name="canUserChangePassword1"]').val());
         if(flag){
             if($('select[name="canUserChangePassword1"]').val() == 'false' && $('select[name="canAdminChangeUserPassword1"]').val() == 'false'){
                 toastr.error('Please check password enforcment  ', 'Fail!!!', {allowHtml: true});
             return;
             }
         }
        if($('.cloudConfiguration').parsley().isValid()){
            var html = $('.saveCloudProperties').html();
            $('.saveCloudProperties').attr('disabled','disabled');
            $('.saveCloudProperties').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/cloudProperties',
                 data: $('.cloudConfiguration').serialize()+'&canUser='+canUser+'&canAdmin='+canAdmin+'&supportMailNew='+supportMailNew,
                type: 'POST'
            }).done(function(data){
                $('.saveCloudProperties').removeAttr('disabled');
                $('.saveCloudProperties').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/settings';
                    }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }

    };

    $scope.saveProxyConfiguration = function(){
        if($('.proxyConfiguration').parsley().isValid()){
            var proxySaveHtml = $('.proxySave').html();
            $('.proxySave').attr('disabled','disabled');
            $('.proxySave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var encrypt = new JSEncrypt();
            encrypt.setPublicKey($('#pubkey').val());
            var encrypted = encrypt.encrypt($('#proxyPassword').val());
            encrypted = encrypted.replace(/\//g,"_");
            encrypted = encrypted.replace(/\+/g,".");
            encrypted = encrypted.replace(/\=/g,"-");
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/proxy',
                data: $('form').find('input[name!=proxyPassword]').serialize()+'&proxyPassword='+encrypted,
                type: 'POST'
            }).done(function(data){
                $('.proxySave').removeAttr('disabled');
                $('.proxySave').html(proxySaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    $scope.editProxyConfiguration = function(){
        //if($('.proxyConfiguration').parsley().isValid()){
            var proxySaveHtml = $('.proxySave').html();
            $('.eproxySave').attr('disabled','disabled');
            $('.eproxySave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var encrypt = new JSEncrypt();
            encrypt.setPublicKey($('#pubkey').val());
            var encrypted = encrypt.encrypt($('#proxyPassword').val());
            encrypted = encrypted.replace(/\//g,"_");
            encrypted = encrypted.replace(/\+/g,".");
            encrypted = encrypted.replace(/\=/g,"-");
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/editproxy',
                data: $('form').find('input[name!=proxyPassword]').serialize()+'&proxyPassword='+encrypted,
                type: 'POST'
            }).done(function(data){
                $('.eproxySave').removeAttr('disabled');
                $('.eproxySave').html(proxySaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        //}
    };

    $scope.removeProxyConfiguration = function(){
            var btn = $('.proxyRemove');
            var html = btn.html();
            var host = $('#proxyURL').val();
            $('.proxyRemove').attr('disabled','disabled');
            $('.proxyRemove').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                type: 'POST',
                url: $scope.BASE_FOLDER+'/settings/proxyremove',
                data: {csrf_token: $('csrf_token').html(), proxyHost: host}
            }).done(function(data){
                btn.removeAttr('disabled');
                btn.html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $scope.updateAdCredentials();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        };

    $scope.saveGoogleConfiguration = function(){
        if($('.googleConfiguration').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#googleConfiguration input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/google',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveOdcConfiguration = function(){
        //if($('.odcConfiguration').parsley().isValid()){
        //    $.ajax({
        //        url: $scope.BASE_FOLDER+'/settings/obc',
        //        data: $('form').serialize(),
        //        type: 'POST'
        //    }).done(function(data){
        //        var jData = $.parseJSON(data);
        //        if(jData.result == 'success'){
        //            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
        //        }else{
        //            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
        //        }
        //    }).fail(function(data){
        //        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
        //        if(data.status == 424){
        //            setTimeout(function(){
        //                window.location.href = $scope.BASE_FOLDER+'/sleep';
        //            }, 3000);
        //        }else if(data.status == 503){
        //            setTimeout(function(){
        //                window.location.href = $scope.BASE_FOLDER+'/serviceDown';
        //            }, 3000);
        //        }
        //    });
        //}
        toastr.info('This Section is not enabled to be used', 'Successful!!!', {allowHtml: true});
    };

    $scope.saveOdbConfiguration = function(){
        if($('.odbConfiguration').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#odbConfiguration input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/odb',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 1000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveDomainConfiguration = function(){
        if($('.domainConfiguration').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/domain',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveEncryptionConfiguration = function(){
        if($('.encryptionConfiguration').parsley().isValid()){
                $('.saveEncSetting').attr('disabled','disabled');
                var html = $('.saveEncSetting').html();
                $('.saveEncSetting').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                if($('#azureType').val() == 'AZURE'){
                        /*new start*/
                        var nav = [];
                        var nav1 = [];
                        var arr = [];
                        var book = {};
                        var vault;
                        var kkk;
                        var i=0;
                        var vaultt = [];
                        var secrett = [];
                        var countt = [];
                        var emptyVault = 0;
                        $(".first1").each(function() {
                                var j = 0;
                                $("td", this).each(function() {
                                        $(this).find('[id^=vaultName]').each(function() {
                                                if($(this).val() == ''){
                                                        emptyVault = emptyVault+1;
                                                }
                                                nav.push($(this).val());
                                                vault = $(this).val();
                                                vaultt[i] = $(this).val();
                                        });
                                        $(this).find('[id^=secretNames]').each(function() {
                                                if($( this ).is( "span" )){
                                                        nav1.push($(this).text());
                                                        j=j+1;
                                                }
                                                if($( this ).is( "input" )){
							if($(this).val() != ''){
                                                                nav1.push($(this).val());
                                                                j=j+1;
                                                        }
                                                }
                                        });
                                        kkk = nav1.join(',');
                                        secrett[i] = nav1;
                                        book[vault] = kkk;
                                });
                                countt.push(j);
                                i++;
                                arr[nav] = nav1
                                nav = [];
                                nav1 = [];
                        });
                        var hh = [];
                        hh[vaultt[0]] = secrett[0];
                        var array = [];
                        secrett.forEach(function(value) {
                                array.push({
                                        'secret': value
                                });
                        });
                        var jsonString = JSON.stringify(array);
                        var array1 = [];
                        vaultt.forEach(function(value) {
                                array1.push({
                                        'vault': value
                                });
                        });
                        var jsonString1 = JSON.stringify(array1);
                        book = JSON.stringify(book);
                        if(emptyVault > 0){
				toastr.error("Vault Name should have a valid name and can't be empty ", 'Fail!!!', {allowHtml: true});
                                $('.saveEncSetting').html(html);
                                $('.saveEncSetting').removeAttr('disabled');
                                return false;
                        }
                        /*new end*/
                        }
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/encryption',
                data: $('form').serialize()+'&azureType='+$('#azureType').val()+'&book='+book+'&vaultt='+jsonString1+'&secrett='+secrett+'&countt='+countt,
                //data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.saveEncSetting').html(html);
                $('.saveEncSetting').removeAttr('disabled');
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
		    }, 3000);
                }
            });
        }
    };

    $scope.saveLocalConfiguration = function(){
        if($('.localConfiguration').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/local',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $('.SSLConfiguration').on('submit', function(event){
        event.preventDefault();
	var mainCRT = $('#mainCRTFile').val()
        var lastmainCRT = mainCRT.split('.').pop();
        lastmainCRT = lastmainCRT.toLowerCase();
        
        var keyCRT = $('#keyFile').val();
        var lastkeyCRT = keyCRT.split('.').pop();
        lastkeyCRT = lastkeyCRT.toLowerCase();

        var chainCRT = $('#chainCRTFile').val();
        var lastchainCRT = chainCRT.split('.').pop();
        lastchainCRT = lastchainCRT.toLowerCase();        
        if(lastmainCRT != 'crt'){
            toastr.error('Please select valid Main Crt File ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if(lastkeyCRT != 'key'){
            toastr.error('Please select valid Key File ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if(lastchainCRT != ''){
            if(lastchainCRT != 'crt'){
                toastr.error('Please select valid Chain Crt File ', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/ssl',
            data: new FormData( this ),
            processData: false,
            contentType: false
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    });

    $scope.updateAdCredentials = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getAdCredentials',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.adcS.length > 0){
                    $scope.adcS = jData.adcS;
                    $scope.$apply();
                    $('.adPanel').show();
		    $('#noActive').hide();
                    $('#adButton').addClass('toolTip');
                    $('#adButton').attr('title','This feature is disabled in Lite Version');
                    $('.adButton').attr('disabled','disabled');
                    $('[data-toggle="tooltip"]').tooltip();
                }else{
		    $('#noActive').show();
		}
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    $scope.getAdCredentials = function(key){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getAdCredential',
            data: {csrf_token: $('.csrf_token').html(), id: $scope.adcS[key].id}
            
        }).done(function(data){
            console.log('id'+$scope.adcS[key].id);
            var jData = $.parseJSON(data);
            console.log(jData);
            if(jData.result == 'success'){
                if(jData.adcS != null){
                    var decrypt = new JSEncrypt();
                    decrypt.setPrivateKey($('#privkey1').val());
                    var uncrypted = decrypt.decrypt(jData.adcS.adPassword);
                    uncrypted = uncrypted.replace(/\//g,"_");
                    uncrypted = uncrypted.replace(/\+/g,".");
                    uncrypted = uncrypted.replace(/\=/g,"-");
                    var adURL = jData.adcS.adUrl;
                    var parts = adURL.split(':', 3);
                    $('#editAdCredentialsModal').modal('show');
                    $('#id').val(jData.adcS.id);
                    $('#editUserDn').val(jData.adcS.userDn);
                    $('#editAdPassword').val(uncrypted);
                    $('#editAdBase').val(jData.adcS.adBase);
                    //$('#editAdCn').val(jData.adcS.adCn);
                    if(jData.adcS.adCn === 'cn'){
                         $('#editAdCn').find('option[value="cn"]').prop("selected",true);
                    }else if(jData.adcS.adCn === 'sAMAccountName'){
                         $('#editAdCn').find('option[value="sAMAccountName"]').prop("selected",true);
                    }
                    $('#editAdCn').selectpicker('refresh');
                    parts[1] = parts[1].replace(/\//g, '');
                    $('#editAdUrl').val(parts[1]);
                    $('#editAdPort').val(parts[2]);
                    $('#editAdGroupName').val(jData.adcS.adGroupName);
                    if(jData.adcS.adProductType == 'sync'){
                        $('#editAdProductType').find('option[value="BluSync"]').prop("selected",true);
                    }else if(jData.adcS.adProductType == 'backup'){
                        $('#editAdProductType').find('option[value="BluVault"]').prop("selected",true);
                    }else{
                        $('#editAdProductType').find('option[value="O365"]').prop("selected",true);
                    }
                    $('#editAdProductType').selectpicker('refresh');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    $scope.saveAdCredentials = function(form){
        var btn;
	var re = /(<([^>]+)>)/gi;
        var ja = /({([^>]+)})/gi;
        var count = 0;
        $("form#createAdCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
        });
        if(count >0){
                toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
        	return;
        }
        if($(".createAdCredentials input[type=text]").hasClass("parsley-error")) {
            return false;
        }
        if(form == 'createAdCredentials'){
            if(checkIfExistsInAD($('[name="userDn"]').val())){
                return false;
            }
            btn = $('.createCredentialsBtn');
            var encrypt = new JSEncrypt();
            encrypt.setPublicKey($('#pubkey').val());
            var encrypted = encrypt.encrypt($('#adPassword').val());
            var type = $('#adProductType').val();
        }
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        encrypted = encrypted.toString().replace(/\//g,"_");
        encrypted = encrypted.toString().replace(/\+/g,".");
        encrypted = encrypted.toString().replace(/\=/g,"-");
        var newAdCn = $('#adCn').val();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/saveAdCredentials',
            data: $('.'+form).find('input[name!=adPassword]').serialize()+'&newAdCn='+newAdCn+'&adPassword='+encrypted+'&adProductType='+type
        }).done(function(data){
            btn.removeAttr('disabled');
            btn.html(html);
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(form == 'editAdCredentials'){
                    $('#editAdCredentialsModal').modal('hide');
                    $('#editUserDn').val('');
                    $('#editAdPassword').val('');
                    $('#editAdBase').val('');
                    $('#editAdCn').val('');
                    $('#editAdUrl').val('');
                    $('#editAdPort').val('');
                    $('#editAdGroupName').val();
                }
                $scope.updateAdCredentials();
                setTimeout(function(){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }, 20);
                setTimeout(function(){
                window.location.reload();
                }, 300);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.editAdCredentials = function(form){
	var re = /(<([^>]+)>)/gi;
	var ja = /({([^>]+)})/gi;
	var count = 0;
	$("form#editAdCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	});
	if(count >0){
                toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
	}
        var btn;
        btn = $('.editCredentialsBtn');
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var type = $('#editAdProductType').val();
        var encrypt = new JSEncrypt();
        encrypt.setPublicKey($('#pubkey').val());
        var encrypted = encrypt.encrypt($('#editAdPassword').val());
        encrypted = encrypted.toString().replace(/\//g,"_");
        encrypted = encrypted.toString().replace(/\+/g,".");
        encrypted = encrypted.toString().replace(/\=/g,"-");
        var newAdCn = $('#editAdCn').val();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/editAdCredentials',
            data: $('.'+form).find('input[name!=editAdPassword]').serialize()+'&newAdCn='+newAdCn+'&editAdPassword='+encrypted+'&editAdProductType='+type
        }).done(function(data){
            btn.removeAttr('disabled');
            btn.html(html);
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(form == 'editAdCredentials'){
                    $('#editAdCredentialsModal').modal('hide');
                    $('#editUserDn').val('');
                    $('#editAdPassword').val('');
                    $('#editAdBase').val('');
                    $('#editAdCn').val('');
                    $('#editAdUrl').val('');
                    $('#editAdPort').val('');
                    $('#editAdGroupName').val();
                }
                $scope.updateAdCredentials();
                setTimeout(function(){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }, 20);
                setTimeout(function(){
                window.location.reload();
                }, 300);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function checkIfExistsInAD(newUserDn){
        var result = false;
        $scope.adcS.forEach(function(value, key){
            if(value.userDn == newUserDn){
                toastr.error('User Domain Name already exists', 'Fail!!!', {allowHtml: true});
                result = true;
            }
        });
        return result;
    }

    $scope.removeAdCredentials = function(key){
        var btn = $('.removeCredentialsBtn'+key);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/removeAdCredentials',
            data: {csrf_token: $('.csrf_token').html(), userDn: $scope.adcS[key].userDn}
        }).done(function(data){
            btn.removeAttr('disabled');
            btn.html(html);
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $scope.updateAdCredentials();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.getAllCloudCredentials = function(){
        console.log({csrf_token: $(".csrf_token").html()});
        $.ajax({
            url: $scope.BASE_FOLDER+'/settings/getCloudCredentials',
            data: {csrf_token: $(".csrf_token").html()},
            type: 'POST'
        }).done(function(data){
            $('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.ccS.length > 0){
                    $scope.ccS = jData.ccS;
                    $scope.$apply();
                }else{
                    $('.createCCSPanel').show();
                }
		if($scope.ccS[0].identity == null){
                        $('.createCCSPanel').show();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveCloudCredentials = function(type){
        if($('.cloudCredentials').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#cloudCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var html = $('.saveCcS').html();
            $('.saveCcS').attr('disabled','disabled');
            $('.saveCcS').html('Deleting... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/saveCloudCredentials',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.saveCcS').removeAttr('disabled');
                $('.saveCcS').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		    $('.createCCSPanel').hide()
                    if(type == true){
                        $('.createCcS').modal('hide');
                        $('#ccS').append($('<option>', {
                            value: $('[name="identity"]').val(),
                            text: $('[name="identity"]').val()
                        }));
                        $('.selectCcSPicker').selectpicker('val', $('[name="identity"]').val());
                        $('.selectCcSPicker').selectpicker('refresh');
                    }else{
                        $scope.getAllCloudCredentials();
                    }
                    $('.cloudCredentials input').val('');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.removeCloudCredentials = function(key){
        console.log(key);
        var btn = $('.removeCredentialsBtn'+key);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Removing... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if($scope.ccS[key]){
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/removeCloudCredentials',
                data: {identity: $scope.ccS[key].identity, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                btn.removeAttr('disabled');
                btn.html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
	
    $scope.getEncryptionKeys = function(){
        console.log({csrf_token: $(".csrf_token").html()});
        $.ajax({
            url: $scope.BASE_FOLDER+'/settings/encryption',
            data: {csrf_token: $(".csrf_token").html()},
            type: 'GET'
        }).done(function(data){
            //$('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
//                if(jData.azureType == 'AZURE' || jData.azureType == 'LOCAL'){
                if(jData.result == 'success'){
                    $('.keychart').removeClass('d-none');
                    $scope.keys = jData.keys;
                        console.log("keys : "+$scope.keys);
                    //$scope.encryptionKeyList = jData.encryptionKeyList;
                    console.log("azureType : "+jData.azureType);
                        $('.azureVaultSettings').hide();
                        $('.localSettings').show();
                        $('.deviceListTable').show();
                        $("#azureType").val('localKey');
/*                    if(jData.azureType == 'AZURE'){
                        $('.azureVaultSettings').show();
                        $('.localSettings').hide();
                        $('.deviceListTable').hide();
                        $("#azureType").val('AZURE');
                        $('#clientId').val(jData.clientId);
                        //$('#clientId').attr("readonly", "readonly");
                        $('#secretKey').val(jData.secretKey);
                        //$('#secretKey').attr("readonly", "readonly");
                        $('#tenantId').val(jData.tenantId);
                        //$('#tenantId').attr("readonly", "readonly");
                        $('#clientIdLabel').addClass('star');
                        $('#secretKeyLabel').addClass('star');
                        $('#tenantIdLabel').addClass('star');
                        $scope.vaultSecret = jData.keys;
                    }else{
                        $('.azureVaultSettings').hide();
                        $('.localSettings').show();
                        $('.deviceListTable').show();
                        $("#azureType").val('localKey');
                    }*/
                    $scope.$apply();
                }else{
                    $('.keychart').addClass('d-none');
                }
            }else{
                $('.azureVaultSettings').hide();
                $('.localSettings').show();
                $('.deviceListTable').hide();
               toastr.info('No Encryption Configured found.', 'Information!!!', {allowHtml: true});
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    /*$scope.getEncryptionKeys = function(){
        console.log({csrf_token: $(".csrf_token").html()});
        $.ajax({
            url: $scope.BASE_FOLDER+'/settings/encryption',
            data: {csrf_token: $(".csrf_token").html()},
            type: 'GET'
        }).done(function(data){
            //$('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.keys.length > 0){
                    $('.keychart').removeClass('d-none');
                    $scope.keys = jData.keys;
                    $scope.$apply();
                }else{
                    $('.keychart').addClass('d-none');
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!'<br>'No Encryption Configured');
            }
        });
    };*/
    
    $scope.updateAadCredentials = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/aadCredentials',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.adcS.length > 0){
                    $scope.adcS = jData.adcS;
                    $scope.$apply();
                    $('.adPanel').show();
                    $('#noActive').hide();
                    $('#adButton').addClass('toolTip');
                    $('#adButton').attr('title','This feature is disabled in Lite Version');
                    $('.adButton').attr('disabled','disabled');
                    $('[data-toggle="tooltip"]').tooltip();
                }else{
            $('#noActive').show();
        }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

        $scope.saveAadConfiguration = function(){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#aadAadCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var aadSaveHtml = $('.aadSave').html();
            $('.aadSave').attr('disabled','disabled');
            $('.aadSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/addAadCredentials',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.aadSave').removeAttr('disabled');
                $('.aadSave').html(aadSaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $scope.saveAadConfiguration1 = function(){
        console.log("saveAadConfiguration1");
        console.log("data : "+$('.editAadCredentials').serialize());
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#editAadCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var aadSaveHtml = $('.editCredentialsBtn').html();
            $('.editCredentialsBtn').attr('disabled','disabled');
            $('.editCredentialsBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/aadCredentials',
                data: $('.editAadCredentials').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.editCredentialsBtn').removeAttr('disabled');
                $('.editCredentialsBtn').html(aadSaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    //for AAD start
    $scope.updateAadCredentials = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getAadCredentials',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.aadcS.length > 0){
                    $scope.aadcS = jData.aadcS;
                    $scope.$apply();
                    $('.aadPanel').show();
                    $('#noActive').hide();
                    $('#aadButton').addClass('toolTip');
                    $('#aadButton').attr('title','This feature is disabled in Lite Version');
                    $('.aadButton').attr('disabled','disabled');
                    $('[data-toggle="tooltip"]').tooltip();
                }else{
            $('#noActive').show();
        }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    $scope.getAadCredentials = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getAadCredentials',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $('.aadCredentialsPanel').show();
                $('.storageMappingButton').show();
                $('.noAadCredentialsPanel').hide();
                $('#editAAD').show();
                $('#addAAD').hide();
                var gpname = [];
                $scope.aad = jData.aad.groupConfig;
                $('#clientIdForLogin').val(jData.aad.clientIdForLogin);
                $('#clientId').val(jData.aad.clientId);
                $('#secretKey').val(jData.aad.secretKey);
                $('#tenentId').val(jData.aad.tenentId);
                $('#redirectURI').val(jData.aad.redirectURI);
                $('#endpointRedirectURI').val(jData.aad.endpointRedirectURI);
                $('#portalRedirectURI').val(jData.aad.portalRedirectURI);
		$('#loginMode').val(jData.aad.loginMode);
                $scope.groupConfig = jData.aad.groupConfig;
                Object.keys(jData.aad.groupConfig).forEach(function(key) {
                    $scope.pro.push(key);
                        gpname.push(jData.aad.groupConfig[key]);
                });
		var tt = [];		    
		jData.aad.tenants.forEach(function(key){
			tt.push(key);
		});
		$scope.tenants = tt;		    	    
                $scope.gpname = gpname;
		if(jData.aad.loginMode == 'Okta'){
                        $('.groupConfigurationsPanel').hide();
                }
                $scope.$apply();
            }else{
                $('.aadCredentialsPanel').hide();
                $('.storageMappingButton').hide();
                $('.noAadCredentialsPanel').show();
                $('#editAAD').hide();
                $('#addAAD').show();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveAadCredentials = function(form){
        var btn;
        if(form == 'createAAdCredentials'){
            btn = $('.createCredentialsBtn');
            var type = $('#aadProductType').val();
        }
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/saveAadCredentials',
            data: $('.'+form).serialize()+'&aadProductType='+type
        }).done(function(data){
            btn.removeAttr('disabled');
            btn.html(html);
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(form == 'editAAdCredentials'){
                    $('#editAAdCredentialsModal').modal('hide');
                    $('#editClientIdForLogin').val('');
                    $('#editClientIdForAADSync').val('');
                    $('#editClientSecretKey').val('');
                    $('#editRedirectURI').val('');
                    $('#editPortalRedirectURI').val('');
                    $('#editAadGroupName').val('');
                }
                $scope.updateAdCredentials();
                setTimeout(function(){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }, 3000);
                location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.editAadCredentials = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getAadCredentials',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#editAad').modal('show');
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                var gpname = [];
                $scope.aad = jData.aad.groupConfig;
                if($scope.aad == undefined){
                    $scope.aad = 'null';
                }
                $('#clientIdForLogin1').val(jData.aad.clientIdForLogin);
                $('#clientId1').val(jData.aad.clientId);
                $('#secretKey1').val(jData.aad.secretKey);
                $('#tenentId1').val(jData.aad.tenentId);
                $('#redirectURI1').val(jData.aad.redirectURI);
                $('#endpointRedirectURI1').val(jData.aad.endpointRedirectURI);
                $('#portalRedirectURI1').val(jData.aad.portalRedirectURI);
		if(jData.aad.loginMode == 'Microsoft'){
            		$('#loginMode1').find('option[value="Microsoft"]').prop("selected",true);
        	}else{
            		$('#loginMode1').find('option[value="Okta"]').prop("selected",true);
        	}
                $('#loginMode1').selectpicker('render');
                $scope.groupConfig = jData.aad.groupConfig;
                Object.keys(jData.aad.groupConfig).forEach(function(key) {
                    $scope.pro.push(key);
                    gpname.push(jData.aad.groupConfig[key]);

                });
		var tt = [];
		$scope.tenants = [];		    
		jData.aad.tenants.forEach(function(key){
			tt.push(key);
		});
		$scope.tenants = tt;		    
                $scope.gpname = gpname;
		var count = Object.keys($scope.gpname).length;
                if(count == 1){                      
                	$("[id*='remove']").addClass('disabled');
                }
		if($scope.tenants.length == 1){
			$("[id*='tenantEditRemove']").addClass('disabled');
		}
		if(jData.aad.loginMode == 'Okta'){
                        $('.groupConfigurationsPanelEdit').hide();
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.removeAadCredentials = function(id){
        var btn = $('.removeCredentialsBtn'+id);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/removeAadCredentials',
            data: {csrf_token: $('.csrf_token').html(), id: id}
        }).done(function(data){
            btn.removeAttr('disabled');
            btn.html(html);
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
//                $scope.updateAdCredentials();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
//for AAD end

    $scope.saveSharepointConfiguration = function(){
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/saveSharepointConfiguration',
                data: $('.sharepointConfiguration').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
        });
    };


    $scope.downloadPackage = function(){
        window.location.href = $scope.BASE_FOLDER+'/downloadPackage';
    };
    
    $scope.checkOkMac = function(){
        $('#confirmMac').modal('hide');
        var formData = new FormData($('.macAgentForm')[0]);
        //start
        document.getElementById('fileUploadingProgressMac').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var macSaveHtml = $('.macSave').html();
        $('.macSave').attr('disabled','disabled');
        $('.macSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaMacOne',
	                    data: formData,
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.macSave').removeAttr('disabled');
                        $('.macSave').html(macSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
    };

    $scope.checkOk = function(){
        $('#confirm').modal('hide');
        console.log("set true");
        var formData = new FormData($('.winAgentForm')[0]);
        //start
        document.getElementById('fileUploadingProgress').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
        var winSaveHtml = $('.winSave').html();
        $('.winSave').attr('disabled','disabled');
        $('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                    $.ajax({
                        type: 'POST',
                        url: $scope.BASE_FOLDER+'/settings/epaWindowsOne',
                        //data: new FormData( this ),
                        data : formData,
                        processData: false,
                        contentType: false
                    }).done(function(data){
                        $('.winSave').removeAttr('disabled');
                        $('.winSave').html(winSaveHtml);
                        var jData = JSON.parse(data);
                        if(jData.result == 'success'){
                            document.getElementById('fileUploadingProgress').innerHTML = '';
                            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                            setTimeout(function(){
                                window.location.reload();
                                }, 3000);
                            }else{
                                document.getElementById('fileUploadingProgress').innerHTML = '';
                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                            }
                    }).fail(function(data){
                        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                        if(data.status == 424){
                            setTimeout(function(){
                                window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                        }else if(data.status == 503){
                            setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                            }, 3000);
                        }
                    });
                    //end
    };
    
    $scope.checkOkFile = function(){
        $('#confirmFile').modal('hide');
        var formData = new FormData($('.winAgentForm')[0]);
        document.getElementById('fileUploadingProgress').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    var winSaveHtml = $('.winSave').html();
        $('.winSave').attr('disabled','disabled');
        $('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    $.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-win').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-win").width(percentComplete + '%');
				    $("#progress-bar-win").html('<div id="progress-status-win">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaWindows',
	            data: formData,
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!! ', {allowHtml: true});
	                document.getElementById('fileUploadingProgress').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaWindowsOne',
	                            data: formData,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.winSave').removeAttr('disabled');
                                $('.winSave').html(winSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgress').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgress').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.winSave').removeAttr('disabled');
                    $('.winSave').html(winSaveHtml);
                    document.getElementById('fileUploadingProgress').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
        
    };
    
    $scope.checkOkFileMac = function(){
        $('#confirmFileMac').modal('hide');
        var formData = new FormData($('.macAgentForm')[0]);
        document.getElementById('fileUploadingProgressMac').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    var macSaveHtml = $('.macSave').html();
        $('.macSave').attr('disabled','disabled');
        $('.macSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    $.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-mac').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-mac").width(percentComplete + '%');
				    $("#progress-bar-mac").html('<div id="progress-status-mac">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaMac',
	            data: formData,
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressMac').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaMacOne',
	                            data: formData,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.macSave').removeAttr('disabled');
                                $('.macSave').html(macSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.macSave').removeAttr('disabled');
                    $('.macSave').html(macSaveHtml);
                    document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
    };

    $scope.checkCancel = function(){
    $('#confirm').modal('hide');
    console.log("set false");
    };
    
    $scope.checkCancelMac = function(){
    $('#confirmMac').modal('hide');
    console.log("set false");
    };
    
    $scope.checkCancelFile = function(){
    $('#confirmFile').modal('hide');
    console.log("set false");
    };
    
    $scope.checkCancelFileMac = function(){
    $('#confirmFileMac').modal('hide');
    console.log("set false");
    };
    
    function checkIt(){
    $('#confirm').modal('show');
    }
    
    function checkItMac(){
    $('#confirmMac').modal('show');
    }
    
    function checkItFile(){
    $('#confirmFile').modal('show');
    }
    
    function checkItFileMac(){
    $('#confirmFileMac').modal('show');
    }

    $('.winAgentForm').on('submit', function(event){
	if($('#link').val() == '' && document.getElementById("updateFileName").files.length == 0){
		document.getElementById('fileUploadingProgress').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var winSaveHtml = $('.winSave').html();
		$('.winSave').attr('disabled','disabled');
		$('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                //start
                   	$.ajax({
                        type: 'POST',
                        url: $scope.BASE_FOLDER+'/settings/epaWindowsOne',
                        data: new FormData( this ),
                        processData: false,
                        contentType: false
                    }).done(function(data){
                        $('.winSave').removeAttr('disabled');
                        $('.winSave').html(winSaveHtml);
                        var jData = JSON.parse(data);
                        if(jData.result == 'success'){
							document.getElementById('fileUploadingProgress').innerHTML = '';
                            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
                        		window.location.reload();
                    		}, 3000);
                        }else{
                            $('.winSave').removeAttr('disabled');
                            $('.winSave').html(winSaveHtml);
							document.getElementById('fileUploadingProgress').innerHTML = '';
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                        }
                    }).fail(function(data){
                        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                    	            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                    });
                //end
	}

	if($('#link').val() != ''){
	    var currentWinAgentVersion = $('#currentWinAgentVersion').html();
	    var inputt = $('#link').val();
	    var lastSegment = inputt.split('/').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1)
	    var nameWith = $('#link').val();
	    var lastSegment = nameWith.split('/').pop();
	    var n = lastSegment.startsWith("Windows_");
	    if(n == false){
	    	toastr.error('Provided link should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	        return;
	    }	    
	    if(lastFinal == currentWinAgentVersion){
            checkIt();
        }else{
	                //start
    		document.getElementById('fileUploadingProgress').innerHTML = 'Details are being saved in server';
    		var winSaveHtml = $('.winSave').html();
            $('.winSave').attr('disabled','disabled');
            $('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaWindowsOne',
	                    data: new FormData( this ),
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.winSave').removeAttr('disabled');
                        $('.winSave').html(winSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgress').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgress').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
        }
	}
	if( document.getElementById("updateFileName").files.length != 0 ){	    
	    var currentWinAgentVersion = $('#currentWinAgentVersion').html();
	    var inputt = $('#updateFileName').val();
	    var lastSegment = inputt.split('\\').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1)        
	    var nameWith = $('#updateFileName').val();
	    var lastSegment = nameWith.split('\\').pop();
	    var d1 = new FormData( this );
	    var n = lastSegment.startsWith("Windows_");
	    if(n == false){
	            toastr.error('Selected file should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	            return;
	    }        
	    if(lastFinal == currentWinAgentVersion){
            	checkItFile();
	    }else{	    
	    	document.getElementById('fileUploadingProgress').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    	var winSaveHtml = $('.winSave').html();
        	$('.winSave').attr('disabled','disabled');
        	$('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    	$.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-win').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-win").width(percentComplete + '%');
				    $("#progress-bar-win").html('<div id="progress-status-win">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaWindows',
	            data: new FormData( this ),
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgress').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaWindowsOne',
	                            data: d1,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.winSave').removeAttr('disabled');
                                $('.winSave').html(winSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgress').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgress').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.winSave').removeAttr('disabled');
                    $('.winSave').html(winSaveHtml);
                    document.getElementById('fileUploadingProgress').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
	    }
	}
    });

    //for mac start
    $('.macAgentForm').on('submit', function(event){
	if($('#linkMac').val() == '' && document.getElementById("updateFileNameMac").files.length == 0){
		document.getElementById('fileUploadingProgressMac').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var macSaveHtml = $('.macSave').html();
		$('.macSave').attr('disabled','disabled');
		$('.macSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                //start
                   	$.ajax({
                        type: 'POST',
                        url: $scope.BASE_FOLDER+'/settings/epaMacOne',
                        data: new FormData( this ),
                        processData: false,
                        contentType: false
                    }).done(function(data){
                        $('.macSave').removeAttr('disabled');
                        $('.macSave').html(macSaveHtml);
                        var jData = JSON.parse(data);
                        if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressMac').innerHTML = '';
                            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
                        		window.location.reload();
                    		}, 3000);
                        }else{
							document.getElementById('fileUploadingProgressMac').innerHTML = '';
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                        }
                    }).fail(function(data){
                        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                    	            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                    });
                //end
	}

	if($('#linkMac').val() != ''){
	    var currentMacAgentVersion = $('#currentMacAgentVersion').html();
	    var inputt = $('#linkMac').val();
	    var lastSegment = inputt.split('/').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1)        
	    var nameWith = $('#linkMac').val();
	    var lastSegment = nameWith.split('/').pop();
	    var n = lastSegment.startsWith("Mac_");
	    if(n == false){
	    	toastr.error('Provided link should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	        return;
	    }	    
	    if(lastFinal == currentMacAgentVersion){
            	checkItMac();
	    }else{
	                //start
		document.getElementById('fileUploadingProgressMac').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var macSaveHtml = $('.macSave').html();
		$('.macSave').attr('disabled','disabled');
		$('.macSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
		$.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaMacOne',
	                    data: new FormData( this ),
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.macSave').removeAttr('disabled');
                        $('.macSave').html(macSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
        }
	}
	if( document.getElementById("updateFileNameMac").files.length != 0 ){
	    var currentMacAgentVersion = $('#currentMacAgentVersion').html();
	    var inputt = $('#updateFileNameMac').val();
	    var lastSegment = inputt.split('\\').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1)        
	    var nameWith = $('#updateFileNameMac').val();
	    var lastSegment = nameWith.split('\\').pop();
	    var d1 = new FormData( this );
	    var n = lastSegment.startsWith("Mac_");
	    if(n == false){
	            toastr.error('Selected file should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	            return;
	    }
	    if(lastFinal == currentMacAgentVersion){
            	checkItFileMac();
	    }else{
	    	document.getElementById('fileUploadingProgressMac').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    	var macSaveHtml = $('.macSave').html();
	    	$('.macSave').attr('disabled','disabled');
	    	$('.macSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    	$.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-mac').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-mac").width(percentComplete + '%');
				    $("#progress-bar-mac").html('<div id="progress-status-mac">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaMac',
	            data: new FormData( this ),
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressMac').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaMacOne',
	                            data: d1,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.macSave').removeAttr('disabled');
                                $('.macSave').html(macSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.macSave').removeAttr('disabled');
                    $('.macSave').html(macSaveHtml);
                    document.getElementById('fileUploadingProgressMac').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
        }
	}
    });
    /*for mac end*/
	
    /*for linux deb start*/
    $scope.checkOkLinux = function(){
        $('#confirmLinux').modal('hide');
        var formData = new FormData($('.linuxAgentForm')[0]);
        //start
        document.getElementById('fileUploadingProgressLinux').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
        var linuxSaveHtml = $('.linuxSave').html();
        $('.linuxSave').attr('disabled','disabled');
        $('.linuxSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaLinuxOne',
	                    data: formData,
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.linuxSave').removeAttr('disabled');
                        $('.linuxSave').html(linuxSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
    };
        
    $scope.checkOkFileLinux = function(){
        $('#confirmFileLinux').modal('hide');
        var formData = new FormData($('.linuxAgentForm')[0]);
        document.getElementById('fileUploadingProgressLinux').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	var linuxSaveHtml = $('.linuxSave').html();
        $('.linuxSave').attr('disabled','disabled');
        $('.linuxSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    $.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-linux').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-linux").width(percentComplete + '%');
				    $("#progress-bar-linux").html('<div id="progress-status-linux">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaLinux',
	            data: formData,
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressLinux').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaLinuxOne',
	                            data: formData,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.linuxSave').removeAttr('disabled');
                                $('.linuxSave').html(linuxSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.linuxSave').removeAttr('disabled');
                    $('.linuxSave').html(linuxSaveHtml);
                    document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
    };
    
    $scope.checkCancelLinux = function(){
    $('#confirmLinux').modal('hide');
    console.log("set false");
    };
    
    $scope.checkCancelFileLinux = function(){
    $('#confirmFileLinux').modal('hide');
    console.log("set false");
    };
    
    function checkItLinux(){
    $('#confirmLinux').modal('show');
    }
    
    function checkItFileLinux(){
    $('#confirmFileLinux').modal('show');
    }
    
    $('.linuxAgentForm').on('submit', function(event){
    var radioValueLinux = $("input[name='optradioLinux']:checked").val();        
	if($('#linkLinux').val() == '' && document.getElementById("updateFileNameLinux").files.length == 0){
		document.getElementById('fileUploadingProgressLinux').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var linuxSaveHtml = $('.linuxSave').html();
		$('.linuxSave').attr('disabled','disabled');
		$('.linuxSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                //start
                   	$.ajax({
                        type: 'POST',
                        url: $scope.BASE_FOLDER+'/settings/epaLinuxOne',
                        data: new FormData( this ),
                        processData: false,
                        contentType: false
                    }).done(function(data){
                        $('.linuxSave').removeAttr('disabled');
                        $('.linuxSave').html(linuxSaveHtml);
                        var jData = JSON.parse(data);
                        if(jData.result == 'success'){
                            document.getElementById('fileUploadingProgressLinux').innerHTML = '';
                            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                            setTimeout(function(){
                        		window.location.reload();
                    		}, 3000);
                        }else{
                            document.getElementById('fileUploadingProgressLinux').innerHTML = '';
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                        }
                    }).fail(function(data){
                        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                    	            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                    });
                //end
	}
	    
	if($('#linkLinux').val() != '' && radioValueLinux == 'linkClickedLinux'){
	    var currentLinuxDebAgentVersion = $('#currentLinuxDebAgentVersion').html();
	    //var currentLinuxRpmAgentVersion = $('#currentLinuxRpmAgentVersion').html();
	    var inputt = $('#linkLinux').val();
	    var lastSegment = inputt.split('/').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1);
	    var pkgname = last2.substring(0,last2.lastIndexOf("_"));
        
	    var nameWith = $('#linkLinux').val();
	    var lastSegment = nameWith.split('/').pop();
	    var n = lastSegment.startsWith("Linux-DEB_");
	    if(n == false){
	    	toastr.error('Provided link should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	        return;
	    }	    
	    	if(pkgname != 'Linux-DEB'){
			toastr.error('Selected file should be a Debian package.', 'Fail!!!', {allowHtml: true});
	            	return;
		}
	    	if(pkgname == 'Linux-DEB' && lastFinal == currentLinuxDebAgentVersion){
            		checkItLinux();
        	}else{
	                //start
	    document.getElementById('fileUploadingProgressLinux').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    var linuxSaveHtml = $('.linuxSave').html();
	    $('.linuxSave').attr('disabled','disabled');
	    $('.linuxSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaLinuxOne',
	                    data: new FormData( this ),
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.linuxSave').removeAttr('disabled');
                        $('.linuxSave').html(linuxSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
        }
	}
	if( document.getElementById("updateFileNameLinux").files.length != 0 && radioValueLinux == 'fileClickedLinux'){
	    var currentLinuxDebAgentVersion = $('#currentLinuxDebAgentVersion').html();
	    //var currentLinuxRpmAgentVersion = $('#currentLinuxRpmAgentVersion').html();
	    var inputt = $('#updateFileNameLinux').val();
	    var lastSegment = inputt.split('\\').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1);
	    var pkgname = last2.substring(0,last2.lastIndexOf("_"));
        
	    var nameWith = $('#updateFileNameLinux').val();
	    var lastSegment = nameWith.split('\\').pop();
	    var d1 = new FormData( this );
	    var n = last1.startsWith("Linux-DEB_");
	        if(n == false){
	            toastr.error('Selected file should have proper naming convention  ', 'Fail!!!', {allowHtml: true});
	            return;
	        }		
		if(pkgname != 'Linux-DEB'){
			toastr.error('Selected file should be a Debian package.', 'Fail!!!', {allowHtml: true});
	            	return;
		}
		if(pkgname == 'Linux-DEB' && lastFinal == currentLinuxDebAgentVersion){
			checkItFileLinux();
		}else{
			console.log("elseeee");
	    document.getElementById('fileUploadingProgressLinux').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    var linuxSaveHtml = $('.linuxSave').html();
	    $('.linuxSave').attr('disabled','disabled');
	    $('.linuxSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    var types = ["application/zip", "application/x-zip-compressed"];
	    if(!types.includes(document.getElementById("updateFileNameLinux").files[0].type)){
		toastr.error('Selected file should be a proper zip file.', 'Fail!!!', {allowHtml: true});
		return;
	    }
	    $.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-linux').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-linux").width(percentComplete + '%');
				    $("#progress-bar-linux").html('<div id="progress-status-linux">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaLinux',
	            data: new FormData( this ),
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressLinux').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaLinuxOne',
	                            data: d1,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.linuxSave').removeAttr('disabled');
                                $('.linuxSave').html(linuxSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.linuxSave').removeAttr('disabled');
                    $('.linuxSave').html(linuxSaveHtml);
                    document.getElementById('fileUploadingProgressLinux').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
        }
	}
    });
    
/*for linux deb end*/
	
    /*for linux start*/
    $scope.checkOkLinuxrpm = function(){
        $('#confirmLinuxrpm').modal('hide');
        var formData = new FormData($('.linuxrpmAgentForm')[0]);
        //start
        document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
        var linuxSaveHtml = $('.linuxrpmSave').html();
        $('.linuxrpmSave').attr('disabled','disabled');
        $('.linuxrpmSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaLinuxrpmOne',
	                    data: formData,
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.linuxrpmSave').removeAttr('disabled');
                        $('.linuxrpmSave').html(linuxSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
    };


    $scope.checkOkFileLinuxrpm = function(){
        $('#confirmFileLinuxrpm').modal('hide');
        var formData = new FormData($('.linuxrpmAgentForm')[0]);
        document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
        var linuxSaveHtml = $('.linuxSave').html();
        $('.linuxrpmSave').attr('disabled','disabled');
        $('.linuxrpmSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    $.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-linuxrpm').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-linuxrpm").width(percentComplete + '%');
				    $("#progress-bar-linuxrpm").html('<div id="progress-status-linuxrpm">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaLinuxrpm',
	            data: formData,
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaLinuxrpmOne',
	                            data: formData,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.linuxrpmSave').removeAttr('disabled');
                                $('.linuxrpmSave').html(linuxSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.linuxrpmSave').removeAttr('disabled');
                    $('.linuxrpmSave').html(linuxSaveHtml);
                    document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
    };

    $scope.checkCancelLinuxrpm = function(){
    	$('#confirmLinuxrpm').modal('hide');
    };

    $scope.checkCancelFileLinuxrpm = function(){
    	$('#confirmFileLinuxrpm').modal('hide');
    };

    function checkItLinuxrpm(){
    	$('#confirmLinuxrpm').modal('show');
    }

    function checkItFileLinuxrpm(){
    	$('#confirmFileLinuxrpm').modal('show');
    }

    $('.linuxrpmAgentForm').on('submit', function(event){
	var radioValueLinux = $("input[name='optradioLinuxrpm']:checked").val();
	if($('#linkLinuxrpm').val() == '' && document.getElementById("updateFileNameLinuxrpm").files.length == 0){
		document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var linuxSaveHtml = $('.linuxrpmSave').html();
		$('.linuxrpmSave').attr('disabled','disabled');
		$('.linuxrpmSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                //start
                   	$.ajax({
                        type: 'POST',
                        url: $scope.BASE_FOLDER+'/settings/epaLinuxrpmOne',
                        data: new FormData( this ),
                        processData: false,
                        contentType: false
                    }).done(function(data){
                        $('.linuxrpmSave').removeAttr('disabled');
                        $('.linuxrpmSave').html(linuxSaveHtml);
                        var jData = JSON.parse(data);
                        if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
                            toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
                        		window.location.reload();
                    		}, 3000);
                        }else{
							document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                        }
                    }).fail(function(data){
                        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                    	            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                    });
                //end
	}

	if($('#linkLinuxrpm').val() != '' && radioValueLinux == 'linkClickedLinuxrpm'){
//	    var currentLinuxDebAgentVersion = $('#currentLinuxDebAgentVersion').html();
	    var currentLinuxRpmAgentVersion = $('#currentLinuxRpmAgentVersion').html();
	    var inputt = $('#linkLinuxrpm').val();
	    var lastSegment = inputt.split('/').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1);
	    var pkgname = last2.substring(0,last2.lastIndexOf("_"));
		
	    var nameWith = $('#linkLinuxrpm').val();
	    var lastSegment = nameWith.split('/').pop();
	    var n = lastSegment.startsWith("Linux-RPM_");
	    if(n == false){
	    	toastr.error('Provided link should have proper naming convention.', 'Fail!!!', {allowHtml: true});
	        return;
	    }
	    	if(pkgname != 'Linux-RPM'){
			toastr.error('Selected file should be a RPM package.', 'Fail!!!', {allowHtml: true});
	            	return;
		}
	    	if(pkgname == 'Linux-RPM' && lastFinal == currentLinuxRpmAgentVersion){
			checkItLinuxrpm();
		}else{
	                //start
		document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
		var linuxSaveHtml = $('.linuxrpmSave').html();
		$('.linuxrpmSave').attr('disabled','disabled');
		$('.linuxrpmSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
	    		    $.ajax({
	                    type: 'POST',
	                    url: $scope.BASE_FOLDER+'/settings/epaLinuxrpmOne',
	                    data: new FormData( this ),
	                    processData: false,
	                    contentType: false
	                }).done(function(data){
	                    $('.linuxrpmSave').removeAttr('disabled');
                        $('.linuxrpmSave').html(linuxSaveHtml);
	                    var jData = JSON.parse(data);
	                    if(jData.result == 'success'){
							document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                	    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
							setTimeout(function(){
	                        	window.location.reload();
	                    		}, 3000);
	                        }else{
								document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                        	toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                        }
	                }).fail(function(data){
	                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                    if(data.status == 424){
	                	    setTimeout(function(){
	                            window.location.href = $scope.BASE_FOLDER+'/sleep';
	                            }, 3000);
	                    }else if(data.status == 503){
	                        setTimeout(function(){
	                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                        }, 3000);
	                    }
	                });
	                //end
        }
	}
	if( document.getElementById("updateFileNameLinuxrpm").files.length != 0 && radioValueLinux == 'fileClickedLinuxrpm'){
	    //var currentLinuxDebAgentVersion = $('#currentLinuxDebAgentVersion').html();
	    var currentLinuxRpmAgentVersion = $('#currentLinuxRpmAgentVersion').html();
	    var inputt = $('#updateFileNameLinuxrpm').val();
	    var lastSegment = inputt.split('\\').pop();
	    var last1 = lastSegment.substring(0,lastSegment.lastIndexOf("_"));
	    var last2 = last1.substring(0,last1.lastIndexOf("_"));
	    var lastFinal = last2.substring(last2.lastIndexOf("_")+1);
	    var pkgname = last2.substring(0,last2.lastIndexOf("_"));	
	    var nameWith = $('#updateFileNameLinuxrpm').val();
	    var lastSegment = nameWith.split('\\').pop();
	    var d1 = new FormData( this );
	    var n = lastSegment.startsWith("Linux-RPM_");
	    if(n == false){
	            toastr.error('Selected file should have proper naming convention.', 'Fail!!!', {allowHtml: true});
	            return;
	    }
	    if(pkgname != 'Linux-RPM'){
	            toastr.error('Selected file should be a RPM package.', 'Fail!!!', {allowHtml: true});
	            return;
	    }
	    if(pkgname == 'Linux-RPM' && lastFinal == currentLinuxRpmAgentVersion){
	            checkItFileLinuxrpm();
	    }else{
	    	document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'File Uploading in progress <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	    	var linuxSaveHtml = $('.linuxrpmSave').html();
        	$('.linuxrpmSave').attr('disabled','disabled');
        	$('.linuxrpmSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
		var types = ["application/zip", "application/x-zip-compressed"];
		if(!types.includes(document.getElementById("updateFileNameLinuxrpm").files[0].type)){
			toastr.error('Selected file should be a proper zip file.', 'Fail!!!', {allowHtml: true});
			return;
		}
	    	$.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-linuxrpm').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-linuxrpm").width(percentComplete + '%');
				    $("#progress-bar-linuxrpm").html('<div id="progress-status-linuxrpm">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/settings/epaLinuxrpm',
	            data: new FormData( this ),
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/settings/epaLinuxrpmOne',
	                            data: d1,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            $('.linuxrpmSave').removeAttr('disabled');
                                $('.linuxrpmSave').html(linuxSaveHtml);
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
	                $('.linuxrpmSave').removeAttr('disabled');
                    $('.linuxrpmSave').html(linuxSaveHtml);
                    document.getElementById('fileUploadingProgressLinuxrpm').innerHTML = '';
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });
        }
	}
    });

/*for linux end*/

    $scope.getEPAWindows = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getEPAWindows',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.winDetails.productVersion == '' || jData.winDetails.productVersion == undefined){
                    document.getElementById("currentWinAgentVersion").innerHTML = 'NA';
                }else{
                    document.getElementById("currentWinAgentVersion").innerHTML = jData.winDetails.productVersion;
                }
                if(jData.winDetails.updateAgent == true){
                    $('#autoUpdate').attr('checked', 'checked');
                    document.getElementById("chooser").style.pointerEvents = "auto";
                    //document.getElementById("updateFileName").style.pointerEvents = "auto";
                    //document.getElementById("link").style.pointerEvents = "auto";
                }
                if(jData.winDetails.downloadAgent == true){
                    $('#downloadAgent').attr('checked', 'checked');
                    document.getElementById("chooser").style.pointerEvents = "auto";
                    //document.getElementById("updateFileName").style.pointerEvents = "auto";
                    //document.getElementById("link").style.pointerEvents = "auto";
                }
                if(jData.macDetails.productVersion == '' || jData.macDetails.productVersion == undefined){
                    document.getElementById("currentMacAgentVersion").innerHTML = 'NA';
                }else{
                    document.getElementById("currentMacAgentVersion").innerHTML = jData.macDetails.productVersion;
                }
                if(jData.macDetails.downloadAgent == true){
                    $('#downloadAgentMac').attr('checked', 'checked');
                    document.getElementById("chooserMac").style.pointerEvents = "auto";
                    //document.getElementById("updateFileNameMac").style.pointerEvents = "auto";
                    //document.getElementById("linkMac").style.pointerEvents = "auto";
                }
		if(jData.linuxdebDetails.productVersion == '' || jData.linuxdebDetails.productVersion == undefined){
                    document.getElementById("currentLinuxDebAgentVersion").innerHTML = 'NA';
                }else{
                    document.getElementById("currentLinuxDebAgentVersion").innerHTML = jData.linuxdebDetails.productVersion;
                }
                if(jData.linuxdebDetails.downloadAgent == true){
                    $('#downloadAgentLinux').attr('checked', 'checked');
                    document.getElementById("chooserLinux").style.pointerEvents = "auto";
                }
                if(jData.linuxrpmDetails.productVersion == '' || jData.linuxrpmDetails.productVersion == undefined){
                    document.getElementById("currentLinuxRpmAgentVersion").innerHTML = 'NA';
                }else{
                    document.getElementById("currentLinuxRpmAgentVersion").innerHTML = jData.linuxrpmDetails.productVersion;
                }
                if(jData.linuxrpmDetails.downloadAgent == true){
                    $('#downloadAgentLinuxrpm').attr('checked', 'checked');
                    document.getElementById("chooserLinuxrpm").style.pointerEvents = "auto";
                }

                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.saveMongoProperties = function(){
        if($('.mongoProperties').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#mongoProperties input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var proxySaveHtml = $('.proxySave').html();
            $('.mongoSave').attr('disabled','disabled');
            $('.mongoSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var encrypt = new JSEncrypt();
            encrypt.setPublicKey($('#pubkey').val());
            var encrypted = encrypt.encrypt($('#proxyPassword').val());
            encrypted = encrypted.replace(/\//g,"_");
            encrypted = encrypted.replace(/\+/g,".");
            encrypted = encrypted.replace(/\=/g,"-");
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/mongoProperties',
                data: $('form').find('input[name!=proxyPassword]').serialize()+'&proxyPassword='+encrypted,
                type: 'POST'
            }).done(function(data){
                $('.mongoSave').removeAttr('disabled');
                $('.mongoSave').html(proxySaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    $scope.savePortalProperties = function(){
            var proxySaveHtml = $('.proxySave').html();
            $('.mongoSave').attr('disabled','disabled');
            $('.mongoSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/portalProperties',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.mongoSave').removeAttr('disabled');
                $('.mongoSave').html(proxySaveHtml);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    //datamigration start
    $scope.users = [];

    $scope.getBlockedUsers = function(){
        $.ajax({
            //url: $scope.BASE_FOLDER+'/users',
            url: $scope.BASE_FOLDER+'/usersDataMigration',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.users.length >= 1){
                    $('.usersFound').show();
                    $('.noUsers').hide();
                }else{
                    $('.usersFound').hide();
                    $('.noUsers').show();
                }
                $scope.users = jData.users;
		$scope.users = $scope.users.sort();
		$scope.browseElements = $scope.users;
                if(jData.users.length > 10){
                    $('.usersTable').scroll();
                    $('.usersTable').height('400px');
                }
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.pickElement = function(value, index){
                $scope.selectedRow = index;
                $scope.picked = value;
        };

        $scope.addName = function(){
                if($scope.addedElements.indexOf($scope.picked) == '-1'){
                        $scope.addedElements.push($scope.picked);
                        //console.log("addedElements : "+$scope.addedElements);
                }
        };

        $scope.pickElement1 = function(value, index){
                $scope.selectedRow1 = index;
                $scope.picked1 = value;
        };

        $scope.removeName = function(){
                var index = $scope.addedElements.indexOf($scope.picked1); // get index if value found otherwise -1
                if (index > -1) { //if found
                        $scope.addedElements.splice(index, 1);
                }
                //console.log("final list of Elements : "+$scope.addedElements);
        };
	
	$scope.itemSelect1 = function(){
        	//var all = $("input.select-all")[0];
            	var total = $("input.select-item").length;
            	var len = $("input.select-item:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-item:checkbox:checked').map(function () {
			//console.log("value to be added : "+this.value);
			/*remove login starts*/
			var index = $scope.browseElements.indexOf(this.value); // get index if value found otherwise -1
			if (index > -1) { //if found
				$scope.browseElements.splice(index, 1);
				$scope.addedElements = $scope.addedElements.concat(this.value);
				$scope.addedElements = $scope.addedElements.sort();
				$scope.browseElements = $scope.browseElements.sort();
			}
			/*remove logic ends*/
			return this.value;
        	}).get();
        	usersSelected = arr;
	};
	
	$scope.removeName1 = function(){
		//var all = $("input.select-all")[0];
            	var total = $("input.select-itemright").length;
            	var len = $("input.select-itemright:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-itemright:checkbox:checked').map(function () {
			/*remove login starts*/
			var index = $scope.addedElements.indexOf(this.value); // get index if value found otherwise -1
			if (index > -1) { //if found
				$scope.addedElements.splice(index, 1);
				$scope.browseElements = $scope.browseElements.concat(this.value);
				$scope.browseElements = $scope.browseElements.sort();
				$scope.addedElements = $scope.addedElements.sort();
			}
			/*remove logic ends*/
            	return this.value;
        	}).get();
        	usersSelected = arr;
        };
	
	$scope.removeAllName = function(){
		$scope.browseElements = $scope.browseElements.concat($scope.addedElements);
		$scope.browseElements = $scope.browseElements.sort();
		$scope.addedElements = [];
        };

    $scope.startDataMigration = function(){
    var usersSelected;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
           }).get();
        usersSelected = arr;
        console.log("users : "+usersSelected);
        console.log("bucket name : "+$('.bucketName').val());
	if($scope.addedElements.length <= 0){
        	toastr.error('Please select at least one blocked user for data migration.', 'Fail!!!', {allowHtml: true});
                return;
        }
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/startDataMigration',
            //data: {users : usersSelected, bucketName : $('.bucketName').val(), csrf_token: $('.csrf_token').html()}
	    data: {users : $scope.addedElements, bucketName : $('.bucketName').val(), csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $scope.$apply();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.itemSelect = function(){
        var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        var usersSelected;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
        }).get();
        usersSelected = arr;
        console.log("users : "+usersSelected);
        $('.selectedUsers').tagsinput('removeAll');
        $('.selectedUsers').tagsinput('add', usersSelected.join());
};

    //datamigration end
    //branding start	
    $scope.branding = function(){
        $('.branding').modal('show');
        };

        $scope.noRestart = function(){
        $('.branding').modal('hide');
        $('.scriptConfirm').modal('hide');
                setTimeout(function(){
                    location.reload();
                }, 2000);
        };

        $scope.restartScript = function(){
	$.ajax({
           url: $scope.BASE_FOLDER+'/settings/curlCall',
                   type: "POST",
                   data : {csrf_token: $('.csrf_token').html()},
                   contentType: false,
                   cache: false,
                   processData:false,
  	}).done(function(data){
          var jData = JSON.parse(data);
          if(jData.result == 'success'){
		$('.branding').modal('hide');
		$('.scriptConfirm').modal('hide');
		document.getElementById("overlayText").style.display = "block";
		setTimeout(function(){
                    location.reload();
                }, 10000);
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
	   }else if(jData.result=='invalid'){
             	toastr.error(jData.msg, 'Error!!!', {allowHtml: true});
           }else{
             	toastr.error(jData.msg, 'Error!!!', {allowHtml: true});
           }
  	}).fail(function(data){
		toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
 	});
        };

        $(".logoform").on('submit',function(event) {
		var loginlogoFileName = $('#loginlogo').val();
            	var loginlogoFileNameLast = loginlogoFileName.split('.').pop();
            	loginlogoFileNameLast = loginlogoFileNameLast.toLowerCase();
		if(loginlogoFileName != ''){
		    if(loginlogoFileNameLast != 'png'){
		    toastr.error('Please select valid png file ', 'Fail!!!', {allowHtml: true});
		    return;
		    }
		}

		var headerlogoFileName = $('#headerlogo').val();
            	var headerlogoFileNameLast = headerlogoFileName.split('.').pop();
            	headerlogoFileNameLast = headerlogoFileNameLast.toLowerCase();
		if(headerlogoFileName != ''){
		    if(headerlogoFileNameLast != 'png'){
		    toastr.error('Please select valid png file ', 'Fail!!!', {allowHtml: true});
		    return;
		    }
		}
		
		var disclaimerFileName = $('#disclaimer').val();
        	var disclaimerFileNameLast = disclaimerFileName.split('.').pop();
        	disclaimerFileNameLast = disclaimerFileNameLast.toLowerCase();
		if(disclaimerFileName != ''){
		    if(disclaimerFileNameLast != 'txt'){
			toastr.error('Please select valid Disclaimer text file ', 'Fail!!!', {allowHtml: true});
			return;
		    }
		}
		
		var customemailFileName = $('#customemail').val();
            	var customemailFileNameLast = customemailFileName.split('.').pop();
            	customemailFileNameLast = customemailFileNameLast.toLowerCase();

		if(customemailFileName != ''){
		    if(customemailFileNameLast != 'xml'){
		    toastr.error('Please select valid xml file ', 'Fail!!!', {allowHtml: true});
		    return;
		    }
		}
                var myBlockUI = blockUI.instances.get('myBlockUI');
                blockUI.start();
  		$.ajax({
           	   url: $scope.BASE_FOLDER+'/settings/brandingUpload',
                   type: "POST",
                   data:  new FormData(this),
                   contentType: false,
                   cache: false,
	  	   processData:false,
  		}).done(function(data){
		  var jData = JSON.parse(data);
		  if(jData.result == 'success'){
			  myBlockUI.stop();
			  blockUI.stop();
			  $('.scriptConfirm').modal('show');
			toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		    }else if(jData.result=='invalid'){
		     toastr.error(jData.msg, 'Error!!!', {allowHtml: true});
		   }else{
                        toastr.error(jData.msg, 'Error!!!', {allowHtml: true});
                   }
	  	}).fail(function(data){
			toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
		    if(data.status == 424){
			setTimeout(function(){
			    window.location.href = $scope.BASE_FOLDER+'/sleep';
			}, 3000);
		    }else if(data.status == 503){
			setTimeout(function(){
			    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
			}, 3000);
		    }
 		});
 	});
    //branding ends
	
    $('.licenseKeyForm').on('submit', function(event){
        var nameWith = $('#licenseKeyFileName').val();
	var ext = nameWith.split('\\').pop();
            ext = ext.split('.').pop();
            ext = ext.toLowerCase();
            if(ext != 'pblic'){
            toastr.error('Please select valid License Key File ', 'Fail!!!', {allowHtml: true});
            return;
        }
        var ll = new FormData( this );
	var upload = 'true';
        var lastSegment;
        var finalList = [];
	if($scope.licenseKeyList){
        	$scope.licenseKeyList.forEach(function(value){
                	finalList.push(value.fileName);
			if(nameWith != ''){
				lastSegment = nameWith.split('\\').pop();
			}else{
				lastSegment = '';  
			}
			if(value.fileName == lastSegment){
        			upload = 'false';
        			$('#forceUpload').modal('show');
			}else{
        			upload = 'true';
			}
		});
	}else{
		upload = 'true';
	}
	if(finalList.includes(lastSegment) == false){
        var winSaveHtml = $('.winSave').html();
        $('.winSave').attr('disabled','disabled');
        $('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            xhr: function() {
            var xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function(evt) {
                $('#progress-div-win').show();
                if (evt.lengthComputable) {
                var percentComplete = (evt.loaded / evt.total) * 100;
                    percentComplete = percentComplete.toFixed(1);
                    $("#progress-bar-win").width(percentComplete + '%');
                    $("#progress-bar-win").html('<div id="progress-status-win">' + percentComplete +' %</div>')
                }
            }, false);
            return xhr;
            },
                type: 'POST',
                url: $scope.BASE_FOLDER+'/settings/uploadLicenseKey',
                data: new FormData( this ),
                processData: false,
                contentType: false
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                                    setTimeout(function(){
                                        window.location.reload();
                                        }, 2000);
                }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                        if(jData.result == 'exists'){
                                $('#forceUpload').modal('show');
                        }
                }
            }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
	}else{
		$('#forceUpload').modal('show');
	}
    });

$scope.forceUpload = function(){
        $('#forceUpload').modal('hide');
        $('#progress-div-win').hide();
var nameWith = $('#licenseKeyFileName').val();
        var winSaveHtml = $('.winSave').html();
        $('.winSave').attr('disabled','disabled');
        $('.winSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var formData = new FormData($('.licenseKeyForm')[0]);
        $.ajax({
            xhr: function() {
            var xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function(evt) {
                $('#progress-div-win').show();
                if (evt.lengthComputable) {
                var percentComplete = (evt.loaded / evt.total) * 100;
                    percentComplete = percentComplete.toFixed(1);
                    $("#progress-bar-win").width(percentComplete + '%');
                    $("#progress-bar-win").html('<div id="progress-status-win">' + percentComplete +' %</div>')
                }
            }, false);
            return xhr;
            },
                type: 'POST',
                url: $scope.BASE_FOLDER+'/settings/uploadLicenseKeyForce',
                data: formData,
                processData: false,
                contentType: false
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                                    setTimeout(function(){
                                        window.location.reload();
                                        }, 2000);
                }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
/*                        if(jData.result == 'exists'){
                                $('#forceUpload').modal('show');
                        }*/
                }
            }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
};

    $scope.updateLicenseKeyList = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getLicenseKeyList',
            data: {csrf_token: $('.csrf_token').html()}
            }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.licenseKeyList.length > 0){
                    $scope.licenseKeyList = jData.licenseKeyList;
                        console.log("$scope.licenseKeyList :"+$scope.licenseKeyList);
			console.log("$scope.licenseKeyList :"+data);
			jData.licenseKeyList.forEach(function(value){
				console.log("filename : "+value.fileName);
if(value.fileName.includes('EncryptedLicenseKey.pblic')){
                     console.log("yesssssssss");
                 }
			});
                    $scope.$apply();
                    $('#licenseKeyList').show();
                    $('#noKeys').hide();
                }else{
                    $('#noKeys').show();
                    $('#licenseKeyList').hide();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
		    $('#noKeys').show();
                    $('#licenseKeyList').hide();
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.confirmApply = function(fileName){

        var fileName = fileName;
        document.getElementById('fileNameForAction').innerHTML = fileName;
        document.getElementById('fileNameForActionn').innerHTML = fileName;
        $('.applyConfirm').modal('show');
    };

    $scope.licenseKeyAction = function(fileName, action){

        if(action == 'view'){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        //$('#paraviewContainer').modal('show');
        $('#viewww').modal('show');
        $.ajax({
            url: $scope.BASE_FOLDER+'/settings/view',
            data: {csrf_token: $('.csrf_token').html(), fileName : fileName, action : action},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            if(jData.result == 'fail'){
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                //$('#paraviewContainer').modal('hide');
                $('#viewww').modal('hide');
                return;
            }

            if(jData.type == 'image') {
            $('#paraviewContainer .modal-title').html(fileName);
                $('.imageViewer').html(jData.html);
                $('.imageViewer').show();
                $('.paraviewLoading').hide();

            }else if(jData.type == 'text') {

                $('#paraviewContainer .modal-title').html(fileName);
                    jData.html = jData.html.replace(/\r\n/g, "<br>").replace(/\r/g, "<br>");
                $('.content').html(jData.html);
                $('.paraviewLoading').hide();
                $('.content').show();
		$(".fileNameTitle").html(fileName);
		jData.cloudName = jData.cloudName.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#cloudName').val(jData.cloudName);
		    
                jData.noOfUsersAllowed = jData.noOfUsersAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfUsersAllowed').val(jData.noOfUsersAllowed);

		jData.noOfBackupUsersAllowed = jData.noOfBackupUsersAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfBackupUsersAllowed').val(jData.noOfBackupUsersAllowed);

		jData.noOfSyncUsersAllowed = jData.noOfSyncUsersAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfSyncUsersAllowed').val(jData.noOfSyncUsersAllowed);

		jData.validityPeriod = jData.validityPeriod.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#validityPeriod').val(jData.validityPeriod);

		jData.contentSearchEnabled = jData.contentSearchEnabled.replace(/\r\n/g, "").replace(/\r/g, "");
                    if(jData.contentSearchEnabled == '1'){
                    $('.contentSearchEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                    $('.contentSearchEnabled').find('option[value="false"]').prop("selected",true);
                    }
		    $('.contentSearchEnabled').attr("disabled", "disabled");

		jData.versioningEnabled = jData.versioningEnabled.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#versioningEnabled').val(jData.versioningEnabled);

		jData.noOfMiniCloudsAllowed = jData.noOfMiniCloudsAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfMiniCloudsAllowed').val(jData.noOfMiniCloudsAllowed);

		jData.noOfOdbBackupUsersAllowed = jData.noOfOdbBackupUsersAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfOdbBackupUsersAllowed').val(jData.noOfOdbBackupUsersAllowed);

		jData.cloudSizeAllowed = jData.cloudSizeAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
		    function formatNumber (num) {
    			return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,")
		    }
		jData.cloudSizeAllowed = formatNumber(jData.cloudSizeAllowed);
                    $('#cloudSizeAllowed').val(jData.cloudSizeAllowed);

		jData.noOfDevicesAllowed = jData.noOfDevicesAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                    $('#noOfDevicesAllowed').val(jData.noOfDevicesAllowed);
		    
		if(jData.noOfExchangeBackupUsersAllowed){
                        jData.noOfExchangeBackupUsersAllowed = jData.noOfExchangeBackupUsersAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
                        $('.noOfExchangeBackupUsersAllowedBlock').show();
                        $('#noOfExchangeBackupUsersAllowed').val(jData.noOfExchangeBackupUsersAllowed);
                        $('.noOfExchangeBackupUsersAllowed').attr("disabled", "disabled");
                }else{
                        $('.noOfExchangeBackupUsersAllowedBlock').hide();
                }
		    
		//jData.sqlLicenseAllowed = jData.sqlLicenseAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
		jData.sqlLicenseAllowed = jData.sqlLicenseAllowed.trim();
                    if(jData.sqlLicenseAllowed){
                    	$('.sqlLicenseAllowedBlock').show();
                    	if(jData.sqlLicenseAllowed == '1'){
                    		$('.sqlLicenseAllowed').find('option[value="true"]').prop("selected",true);
                    	}else{
                    		$('.sqlLicenseAllowed').find('option[value="false"]').prop("selected",true);
                    	}
                    	$('.sqlLicenseAllowed').attr("disabled", "disabled");
			}else{
				$('.sqlLicenseAllowedBlock').hide();
			}

		//jData.ClamAVLicenseAllowed = jData.ClamAVLicenseAllowed.replace(/\r\n/g, "").replace(/\r/g, "");
		jData.ClamAVLicenseAllowed = jData.ClamAVLicenseAllowed.trim();
			if(jData.ClamAVLicenseAllowed){
			$('.ClamAVLicenseAllowedBlock').show();
				    if(jData.ClamAVLicenseAllowed == '1'){
				    	$('.ClamAVLicenseAllowed').find('option[value="true"]').prop("selected",true);
				    }else{
				    	$('.ClamAVLicenseAllowed').find('option[value="false"]').prop("selected",true);
				    }
				    $('.ClamAVLicenseAllowed').attr("disabled", "disabled");
		}else{
			$('.ClamAVLicenseAllowedBlock').hide();
		}
		jData.RWLicenseAllowed = jData.RWLicenseAllowed.trim();
                        if(jData.RWLicenseAllowed != 'not there'){
                        $('.RWLicenseAllowedBlock').show();
                                    if(jData.RWLicenseAllowed == '1'){
                                        $('.RWLicenseAllowed').find('option[value="true"]').prop("selected",true);
                                    }else{
                                        $('.RWLicenseAllowed').find('option[value="false"]').prop("selected",true);
                                    }
                                    $('.RWLicenseAllowed').attr("disabled", "disabled");
                }else{
                        $('.RWLicenseAllowedBlock').hide();
                }
		jData.c2cRestoreEnabled = jData.c2cRestoreEnabled.trim();
                        if(jData.c2cRestoreEnabled != 'not there'){
                        $('.c2cRestoreEnabledBlock').show();
                                    if(jData.c2cRestoreEnabled == '1'){
                                        $('.c2cRestoreEnabled').find('option[value="true"]').prop("selected",true);
                                    }else{
                                        $('.c2cRestoreEnabled').find('option[value="false"]').prop("selected",true);
                                    }
                                    $('.c2cRestoreEnabled').attr("disabled", "disabled");
                }else{
                        $('.c2cRestoreEnabledBlock').hide();
                }
            }else{

                $('#paraviewContainer .modal-title').html(fileName);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 400, 100);

            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
}
if(action == 'apply'){
        var fileName = $('#fileNameForAction').html();
	$.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/apply',
            data: {csrf_token: $('.csrf_token').html(), fileName : fileName, action : action}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                    $('.applyConfirm').modal('hide');
                    toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
                    setTimeout(function(){
                        location.reload();
                    }, 3000);
            }else{
                     $('.applyConfirm').modal('hide');
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){

            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
	}
    };
	
    $scope.getSMTP = function(){
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/getSMTP',
            data: {csrf_token: $('.csrf_token').html()}

        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.smtp != null){
                    $('#smtpHost').val(jData.smtp.smtpHost);
                    $('#sslPort').val(jData.smtp.sslPort);
                    $('#factoryClass').val(jData.smtp.sslFactoryClass);
                    $('#smtpPort').val(jData.smtp.smtpPort);
                    console.log("jData.smtp.smtpAuth : "+jData.smtp.smtpAuth);
                    if(jData.smtp.smtpAuth == true){
                        $('#smtpAuth').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('#smtpAuth').find('option[value="false"]').prop("selected",true);
                    }
                    $('#smtpAuth').selectpicker('refresh');
                    if(jData.smtp.smtpStarttlsEnable == true){
                        $('#smtpStarttlsEnable').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('#smtpStarttlsEnable').find('option[value="false"]').prop("selected",true);
                    }
                    $('#smtpStarttlsEnable').selectpicker('refresh');
                    if(jData.smtp.smtpSSLEnable == true){
                        $('#smtpSSLEnable').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('#smtpSSLEnable').find('option[value="false"]').prop("selected",true);
                    }
                    $('#smtpSSLEnable').selectpicker('refresh');
                    $('#smtpUname').val(jData.smtp.smtpUserName);
                    $('#smtpPwd').val(jData.smtp.smtpPwd);
                    $('#email').val(jData.smtp.fromEmail);
                    if(jData.smtp.enableEmail == true){
                        $('#enableMail').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('#enableMail').find('option[value="false"]').prop("selected",true);
                    }
                    $('#enableMail').selectpicker('refresh');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.saveExchangeConfiguration = function(){
        if($('.exchangeConfiguration').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#exchangeConfiguration input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/exchangeDetails',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 1000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>','Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
	
    $scope.redirectTo = function(url){
        window.location = url;
    };

    $scope.sendMeTo = function(location){
        window.location.href = location;
    };
	
    $scope.getAllSiemCredentials = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/settings/getSiemCredentials',
            data: {csrf_token: $(".csrf_token").html()},
            type: 'POST'
        }).done(function(data){
            $('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
		if(jData.ccS.cloudNameInCaps != ''){
			$scope.cloudNameInCaps = jData.ccS.cloudNameInCaps;
                        $scope.identity = jData.ccS.identity;
                        $scope.msAppName = jData.ccS.msAppName;
			$('.createCCSPanel').hide();
			$('.ccSPanel').show();
			$('.cloudType option[value="'+jData.ccS.cloudName+'"]').prop('selected', true);
			$('#cloudType').val(jData.ccS.cloudName);		    
			$('#siemId').val(jData.ccS.id);		    
			$('#cloudType').selectpicker('render');		    
			document.getElementById("cloudTypeDiv").style['pointer-events'] = 'none';
			document.getElementById("cloudTypeDiv").style.opacity = "0.5";
			//document.getElementById("cloudTypeDiv").style.backgroundColor = "#868a8f";
			//$('#cloudType').on('change', function(){		    
			var type = jData.ccS.cloudName;
        			if(type == 'amazon'){
            				$('.localStorage').hide();
            				$('.containerName').show();
            				$('.accessKey').show();
            				$('.identity').show();
            				$('.epaUrl').show();
            				$('#containerNameAzr').show();
            				$('#bucketName').hide();
            				$('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            				$('[name="containerName"').attr('required', 'required');
            				$('[name="accessKey"').attr('required', 'required');
            				$('[name="identity"').attr('required', 'required');
            				$('[name="epaUrl"').attr('required', 'required');
            				$('[name="localStorage"').removeAttr('required', 'required');
            				$('#identity').val(jData.ccS.identity);
					$('#accessKey').val(jData.ccS.credential);
					$('#containerName').val(jData.ccS.containerName);
					$('#epaUrl').val(jData.ccS.endPointUrl);
            				$('.clientId').hide();		
            				$('.clientSecret').hide();
            				$('.appName').hide();
            				$('.tenantId').hide();
            				$('.clientRedirectURI').hide();
            				$('.clientResourceURL').hide();
            				$('.clientTokenURL').hide();
            				$('.portalURL').hide();		
            				$('[name="clientSecret"').removeAttr('required', 'required');
            				$('[name="appName"').removeAttr('required', 'required');
            				$('[name="tenantId"').removeAttr('required', 'required');
            				$('[name="clientRedirectURI"').removeAttr('required', 'required');
            				$('[name="clientResourceURL"').removeAttr('required', 'required');
            				$('[name="clientTokenURL"').removeAttr('required', 'required');
            				$('[name="portalURL"').removeAttr('required', 'required');		
        			}else if(type == 'ibmCloud'){
            				$('.localStorage').hide();
            				$('.containerName').hide();
            				$('.accessKey').show();
            				$('.identity').show();
            				$('.epaUrl').show();
            				$('[name="containerName"').removeAttr('required', 'required');
            				$('[name="accessKey"').attr('required', 'required');
            				$('[name="identity"').attr('required', 'required');
            				$('[name="epaUrl"').attr('required', 'required');
            				$('[name="localStorage"').removeAttr('required', 'required');
					$('#identity').val(jData.ccS.identity);
					$('#accessKey').val(jData.ccS.credential);
					$('#epaUrl').val(jData.ccS.endPointUrl);		
					$('.clientId').hide();		
					$('.clientSecret').hide();
					$('.appName').hide();
					$('.tenantId').hide();
					$('.clientRedirectURI').hide();
					$('.clientResourceURL').hide();
					$('.clientTokenURL').hide();
					$('.portalURL').hide();		
					$('[name="clientSecret"').removeAttr('required', 'required');
					$('[name="appName"').removeAttr('required', 'required');
					$('[name="tenantId"').removeAttr('required', 'required');
					$('[name="clientRedirectURI"').removeAttr('required', 'required');
					$('[name="clientResourceURL"').removeAttr('required', 'required');
					$('[name="clientTokenURL"').removeAttr('required', 'required');
					$('[name="portalURL"').removeAttr('required', 'required');		
        			}else if(type == 's3'){
            				$('.localStorage').hide();
            				$('.containerName').show();
            				$('.accessKey').show();
            				$('.identity').show();
            				$('.epaUrl').show();
            				$('#containerNameAzr').hide();
            				$('#bucketName').show();
            				$('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            				$('[name="containerName"').attr('required', 'required');
            				$('[name="accessKey"').attr('required', 'required');
            				$('[name="identity"').attr('required', 'required');
            				$('[name="epaUrl"').attr('required', 'required');
            				$('[name="localStorage"').removeAttr('required', 'required');
					$('#identity').val(jData.ccS.identity);
					$('#accessKey').val(jData.ccS.credential);
					$('#containerName').val(jData.ccS.containerName);
					$('#epaUrl').val(jData.ccS.endPointUrl);		
					$('.clientId').hide();		
					$('.clientSecret').hide();
					$('.appName').hide();
					$('.tenantId').hide();
					$('.clientRedirectURI').hide();
					$('.clientResourceURL').hide();
					$('.clientTokenURL').hide();
					$('.portalURL').hide();		
					$('[name="clientSecret"').removeAttr('required', 'required');
					$('[name="appName"').removeAttr('required', 'required');
					$('[name="tenantId"').removeAttr('required', 'required');
					$('[name="clientRedirectURI"').removeAttr('required', 'required');
					$('[name="clientResourceURL"').removeAttr('required', 'required');
					$('[name="clientTokenURL"').removeAttr('required', 'required');
					$('[name="portalURL"').removeAttr('required', 'required');		
        			}else if(type == 'localStorage'){
            				$('.localStorage').show();
            				$('[name="localStorage"').attr('required', 'required');
            				$('.accessKey').hide();
            				$('.identity').hide();
            				$('.epaUrl').hide();
            				$('.containerName').hide();
            				$('[name="accessKey"').removeAttr('required', 'required');
            				$('[name="identity"').removeAttr('required', 'required');
            				$('[name="epaUrl"').removeAttr('required', 'required');
            				$('[name="containerName"').removeAttr('required', 'required');
					$('#containerName').val(jData.ccS.containerName);		
					$('.clientId').hide();		
					$('.clientSecret').hide();
					$('.appName').hide();
					$('.tenantId').hide();
					$('.clientRedirectURI').hide();
					$('.clientResourceURL').hide();
					$('.clientTokenURL').hide();
					$('.portalURL').hide();		
					$('[name="clientSecret"').removeAttr('required', 'required');
					$('[name="appName"').removeAttr('required', 'required');
					$('[name="tenantId"').removeAttr('required', 'required');
					$('[name="clientRedirectURI"').removeAttr('required', 'required');
					$('[name="clientResourceURL"').removeAttr('required', 'required');
					$('[name="clientTokenURL"').removeAttr('required', 'required');
					$('[name="portalURL"').removeAttr('required', 'required');		
        			}else if(type == 'odb'){
            				$('.localStorage').hide();
            				$('.odbLoginId').show();
            				$('[name="odbLoginId"').attr('required', 'required');
            				$('#odbLoginId').val(jData.ccS.odbLoginId);
            				$('[name="localStorage"').removeAttr('required', 'required');
            				$('.accessKey').hide();
            				$('.identity').hide();
            				$('.epaUrl').hide();
            				$('.containerName').hide();
            				$('[name="accessKey"').removeAttr('required', 'required');
            				$('[name="identity"').removeAttr('required', 'required');
            				$('[name="epaUrl"').removeAttr('required', 'required');
            				$('[name="containerName"').removeAttr('required', 'required');		
            				$('#containerName').val(jData.ccS.containerName);
					$('.clientId').show();		
					$('.clientSecret').show();
					$('.appName').show();
					$('.tenantId').show();
					$('.clientRedirectURI').show();
					$('.clientResourceURL').show();
					$('.clientTokenURL').show();
					$('.portalURL').show();		
					$('#clientId').val(jData.ccS.msClientId);		
					$('#clientSecret').val(jData.ccS.msClientSecretKey);
					$('#appName').val(jData.ccS.msAppName);
					$('#tenantId').val(jData.ccS.msTenantId);
					//$('#clientRedirectURI').val(jData.ccS.msClientRedirectURI);
					$('#clientResourceURL').val(jData.ccS.msClientResourceURL);
					$('#clientTokenURL').val(jData.ccS.msClientTokenURL);
					$('#portalURL').val(jData.ccS.portalURL);		
					$('[name="clientSecret"').attr('required', 'required');
					$('[name="appName"').attr('required', 'required');
					$('[name="tenantId"').attr('required', 'required');
					//$('[name="clientRedirectURI"').attr('required', 'required');
					$('[name="clientResourceURL"').attr('required', 'required');
					$('[name="clientTokenURL"').attr('required', 'required');
					$('[name="portalURL"').attr('required', 'required');		
        			}else if(type == 'b2'){
            				$('.localStorage').hide();
            				$('.epaUrl').hide();
            				$('.accessKey').show();
            				$('.identity').show();
            				$('[name="epaUrl"').removeAttr('required', 'required');
            				$('[name="accessKey"').attr('required', 'required');
            				$('[name="identity"').attr('required', 'required');
            				$('[name="localStorage"').removeAttr('required', 'required');
            				$('.containerName').show();
            				$('#containerNameAzr').hide();
            				$('#bucketName').show();
            				$('[name="containerName"').attr('placeholder', 'Enter your Bucket Name');
            				$('[name="containerName"').attr('required', 'required');
					$('#identity').val(jData.ccS.identity);
					$('#accessKey').val(jData.ccS.credential);
					$('#containerName').val(jData.ccS.containerName);		
					$('.clientId').hide();		
					$('.clientSecret').hide();
					$('.appName').hide();
					$('.tenantId').hide();
					$('.clientRedirectURI').hide();
					$('.clientResourceURL').hide();
					$('.clientTokenURL').hide();
					$('.portalURL').hide();		
					$('[name="clientSecret"').removeAttr('required', 'required');
					$('[name="appName"').removeAttr('required', 'required');
					$('[name="tenantId"').removeAttr('required', 'required');
					$('[name="clientRedirectURI"').removeAttr('required', 'required');
					$('[name="clientResourceURL"').removeAttr('required', 'required');
					$('[name="clientTokenURL"').removeAttr('required', 'required');
					$('[name="portalURL"').removeAttr('required', 'required');		
        			}else{
            				$('.localStorage').hide();
            				$('.epaUrl').hide();
            				$('.accessKey').show();
            				$('.identity').show();
            				$('[name="epaUrl"').removeAttr('required', 'required');
            				$('.containerName').hide();
            				$('[name="containerName"').removeAttr('required', 'required');
            				$('[name="accessKey"').attr('required', 'required');
            				$('[name="identity"').attr('required', 'required');
            				$('[name="localStorage"').removeAttr('required', 'required');
					$('#identity').val(jData.ccS.identity);
					$('#accessKey').val(jData.ccS.credential);		
					$('.clientId').hide();		
					$('.clientSecret').hide();
					$('.appName').hide();
					$('.tenantId').hide();
					$('.clientRedirectURI').hide();
					$('.clientResourceURL').hide();
					$('.clientTokenURL').hide();
					$('.portalURL').hide();		
					$('[name="clientSecret"').removeAttr('required', 'required');
					$('[name="appName"').removeAttr('required', 'required');
					$('[name="tenantId"').removeAttr('required', 'required');
					$('[name="clientRedirectURI"').removeAttr('required', 'required');
					$('[name="clientResourceURL"').removeAttr('required', 'required');
					$('[name="clientTokenURL"').removeAttr('required', 'required');
					$('[name="portalURL"').removeAttr('required', 'required');		
        			}
		    $('.removeSiemCredentialsBtn').show();
		    $scope.$apply();
		}else{
			$scope.ccS = [];
			$('.createCCSPanel').show();
			$('.ccSPanel').hide();
                        $('.removeSiemCredentialsBtn').hide();
		}
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
		    $scope.ccS = [];
                    $('.createCCSPanel').show();
                    $('.ccSPanel').hide();
                    $('.removeSiemCredentialsBtn').hide();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveSiemCredentials = function(type){
	    console.log("came saveSiemCredentials");
        if($('.siemCredentials').parsley().isValid()){
	    var re = /(<([^>]+)>)/gi;
            var ja = /({([^>]+)})/gi;
            var count = 0;
            $("form#siemCredentials input[type=text]").each(function(){
 		var input = $(this);
        	var text = $(this).val();
        	if (text.match(re) || text.match(ja)) {
                	count = count+1;
        	}
	    });
                if(count >0){
                        toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
                return;
                }
            var html = $('.saveCcS').html();
            $('.saveCcS').attr('disabled','disabled');
            $('.saveCcS').html('Deleting... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/settings/saveSiemCredentials',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.saveCcS').removeAttr('disabled');
                $('.saveCcS').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		    setTimeout(function(){
                        window.location.reload();
                    }, 3000);
//		    $('.createCCSPanel').hide()
                    /*if(type == true){
                        $('.createCcS').modal('hide');
                        $('#ccS').append($('<option>', {
                            value: $('[name="identity"]').val(),
                            text: $('[name="identity"]').val()
                        }));
                        $('.selectCcSPicker').selectpicker('val', $('[name="identity"]').val());
                        $('.selectCcSPicker').selectpicker('refresh');
                    }else{
                        $scope.getAllSiemCredentials();
                    }
                    $('.siemCredentials input').val('');*/
		    //$scope.getAllSiemCredentials();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.removeSiemCredentials = function(key){
/*        var btn = $('.removeCredentialsBtn'+key);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();*/
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/settings/removeSiemCredentials',
            data: {csrf_token: $('.csrf_token').html(), id: $('#siemId').val()}
        }).done(function(data){
/*            btn.removeAttr('disabled');
            btn.html(html);*/
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $scope.getAllSiemCredentials();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload();
                    }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.syncNow = function(){
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/syncNow',
            data: {secret: 'asd', csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.$apply();
                    toastr.success('Synchronization request has been submitted. <br> Please check the user dashboard to see new users.', 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.info('Sync operation already in progress', 'Information!!!', {allowHtml: true});
                }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        if($scope.currentPage == 'adCredentials'){
            $scope.updateAdCredentials();
        }

        if($scope.currentPage == 'ccS'){
            $scope.getAllCloudCredentials();
        }
	    
	if($scope.currentPage == 'siemCredentials'){
            $scope.getAllSiemCredentials();
        }
        
        if($scope.currentPage == 'aadCredentials'){
            $scope.getAadCredentials();
        }

	if($scope.currentPage == 'SSL and Encryption Configuration'){
            $scope.getEncryptionKeys();
        }
        
        if($scope.currentPage == 'epaManager'){
            $scope.getEPAWindows();
        }
	    
	if($scope.currentPage == 'smtp'){
            $scope.getSMTP();
        }
        
        if($scope.currentPage == 'dataMigration'){
            $scope.getBlockedUsers();
        }
	    
	if($scope.currentPage == 'licenseKeyList'){
            $scope.updateLicenseKeyList();
        }
	    
	var error = $('.resultError').html();
        if(error){
            if(error.length > 0){
                toastr.error(error, 'Fail');
            }
        }

        var success = $('.resultSuccess').html();
        if(success){
            if(success.length > 0){
                toastr.success(success, 'Successful');
            }
        }
    });

}]);
