/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ReportController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'timeAgo', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, timeAgo, Upload, $timeout) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = false;
    $scope.sortReverseR = true;
    $scope.currentBackupSortType = '';
    $scope.overviewSortType = 'userId';
    $scope.nobackupSortType = 'deviceName';
    $scope.restoreHistorySortType = 'restoreTimeInMillis';
    $scope.lastAgentServerSortType = 'deviceName';
    $scope.sortTypeMigration = 'userName';
    $scope.sortType = 'userId';
    $scope.sortTypeIn = 'userName';

    $scope.current = {};
    $scope.summary = {};
    $scope.statistics = {};
    $scope.statisticsSync = {};
    $scope.statisticsOneDrive = {};
    $scope.overviewJobTime = '';
    $scope.overview = [];
    $scope.skipValue = 0;
    $scope.restoreByDate = [];
    $scope.initialLimit = 500;
    $scope.longBackup = [];
    $scope.currentBackup = [];
    $scope.currentBackupOnedrive = [];
    $scope.currentBackupE = [];
    $scope.currentBackupOnedriveE = [];
    $scope.currentRestore = [];
    $scope.currentRestoreOnedrive = [];
    $scope.currentRestoreE = [];
    $scope.currentRestoreEOnedrive = [];
    $scope.noBackup = [];
    $scope.userBackupSummary = [];
    $scope.storageUtilized = [];
    $scope.storageUtilizedByPG = [];
    $scope.failedBackup = [];
    $scope.failedBackupByUserOrDevice = [];
    $scope.dailyUserBackupOverview = [];
    $scope.userBackupHistory = [];
    $scope.userDeviceHistory = [];
    $scope.policyName = [];
    $scope.policy = 'true';
    $scope.all = 'all';
    $scope.userNdDevice = '';
    $scope.search = {};
    var currentDate = new Date();
    $scope.search.to = getFormattedDate(currentDate);
    $scope.unit = '';
    $scope.pageNumber = 1;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';
    
    $scope.productOverviewPSSortType = 'policygroupName';   
    $scope.productOverviewSortType = 'userId';  
    $scope.productOverviewFBSortType = 'userName';  
    $scope.productOverviewLBSSortType = 'userName';
    $scope.productOverviewRASortType = 'userName';  
    $scope.productOverviewBUSortType = 'userName';  
    $scope.productOverviewADSortType = 'userName';  
    $scope.productOverviewBDSortType = 'userName';
    $scope.productOverviewPMSortType = 'policyName';

    $scope.sortTypeMSPU = 'emailId';
    $scope.sortReverseMSPU = false;	
    $scope.sortTypeMSPD = 'name';
    $scope.sortReverseMSPD = false;
    $scope.currentpageCountD = '';
    $scope.totalpageCountD = '';

    function toggleSelectAllODB(control) {
        var allOptionIsSelected = (control.val() || []).indexOf("all") > -1;
        function valuesOf(elements) {
                return $.map(elements, function(element) {
                        return element.value;
                });
        }
	    if (control.data('allOptionIsSelected') != allOptionIsSelected) {        
		if (allOptionIsSelected) {            
		    control.selectpicker('val', 'all');
		} else {
		    control.selectpicker('val', []);
		}
	    } else {        
		if (allOptionIsSelected && control.val().length != control.find('option').length) {            
		    control.selectpicker('val', valuesOf(control.find('option:selected[value!=all]')));
		    allOptionIsSelected = false;
		} else if (!allOptionIsSelected && control.val().length == control.find('option').length - 1) {            
		    control.selectpicker('val', 'all');
		    allOptionIsSelected = true;
		}    
	    }
    	control.data('allOptionIsSelected', allOptionIsSelected);
	if($('#searchODBPolicyName').val() == ''){
        	toastr.error('Please select atleast on policy.', {allowHtml: true});
                return;
        }
    }
    $('#searchODBPolicyName').selectpicker().change(function(){toggleSelectAllODB($(this));}).trigger('change');
    function toggleSelectAllExchange(control) {
        var allOptionIsSelected = (control.val() || []).indexOf("all") > -1;
        function valuesOf(elements) {
                return $.map(elements, function(element) {
                        return element.value;
                });
        }
	    if (control.data('allOptionIsSelected') != allOptionIsSelected) {        
		if (allOptionIsSelected) {            
		    control.selectpicker('val', 'all');
		} else {
		    control.selectpicker('val', []);
		}
	    } else {        
		if (allOptionIsSelected && control.val().length != control.find('option').length) {            
		    control.selectpicker('val', valuesOf(control.find('option:selected[value!=all]')));
		    allOptionIsSelected = false;
		} else if (!allOptionIsSelected && control.val().length == control.find('option').length - 1) {            
		    control.selectpicker('val', 'all');
		    allOptionIsSelected = true;
		}    
	    }
    	control.data('allOptionIsSelected', allOptionIsSelected);
	if($('#searchExchangePolicyName').val() == ''){
                toastr.error('Please select atleast on policy.', {allowHtml: true});
                return;
        }
    }
    $('#searchExchangePolicyName').selectpicker().change(function(){toggleSelectAllExchange($(this));}).trigger('change');
    function toggleSelectAllSharepoint(control) {
        var allOptionIsSelected = (control.val() || []).indexOf("all") > -1;
        function valuesOf(elements) {
                return $.map(elements, function(element) {
                        return element.value;
                });
        }
	    if (control.data('allOptionIsSelected') != allOptionIsSelected) {        
		if (allOptionIsSelected) {            
		    control.selectpicker('val', 'all');
		} else {
		    control.selectpicker('val', []);
		}
	    } else {        
		if (allOptionIsSelected && control.val().length != control.find('option').length) {            
		    control.selectpicker('val', valuesOf(control.find('option:selected[value!=all]')));
		    allOptionIsSelected = false;
		} else if (!allOptionIsSelected && control.val().length == control.find('option').length - 1) {            
		    control.selectpicker('val', 'all');
		    allOptionIsSelected = true;
		}    
	    }
    	control.data('allOptionIsSelected', allOptionIsSelected);
	if($('#searchSharepointPolicyName').val() == ''){
                toastr.error('Please select atleast on policy.', {allowHtml: true});
                return;
        }
    }
    $('#searchSharepointPolicyName').selectpicker().change(function(){toggleSelectAllSharepoint($(this));}).trigger('change');
	
    $scope.proceedForChangePassword = function(){
        $('#changePasswordForFirstloginConsent').modal('hide');
        $('#changePasswordForFirstlogin').modal('show');
        $.ajax({
                url: $scope.BASE_FOLDER+'/generateOtpForcePasswordChange',
                data: {csrf_token: $('.csrf_token').html()},
		//data: $('form').serialize(),
                method: 'POST'
            }).done(function(data){
                    console.log("data : "+data);
                    console.log("data=> : "+JSON.stringify(data));
                var jData = $.parseJSON(data);
                    var timee = jData.timee;
                if(jData.result == 'success'){
                }else if(jData.result == 'fieldFail'){
                    $('.error').show();
                    for(var key in jData.msg){
                        if (jData.msg.hasOwnProperty(key)) {
                            if($('.error').html() != ''){
                                $('.error').append('<br/>'+jData.msg[key]);
                            }else{
                                $('.error').html(jData.msg[key]);
                            }
                            $('[name="'+key.toLowerCase()+'"]').removeClass('parsley-success');
                            $('[name="'+key.toLowerCase()+'"]').addClass('parsley-error');
                        }
                    }
                    $('.login').removeAttr('disabled');
                    $('.login').html(html);
                }else{
                    $('.login').removeAttr('disabled');
                    $('.login').html(html);
                    $('[name="username"]').removeClass('parsley-success');
                    $('[name="username"]').addClass('parsley-error');
                    $('[name="password"]').removeClass('parsley-success');
		    $('[name="password"]').addClass('parsley-error');
                    $('.error').show();
                    $('.error').html(jData.msg);
                }
            }).fail(function(data){
                if(data.status == 424){
                    $('.error').show();
                    $('.error').html('Either username or password is wrong, please check again if still not working contact your administrator');
                    $('.login').removeAttr('disabled');
                    $('.login').html(html);
                    $('[name="username"]').removeClass('parsley-success');
                    $('[name="username"]').addClass('parsley-error');
                    $('[name="password"]').removeClass('parsley-success');
                    $('[name="password"]').addClass('parsley-error');
                    $('.error').show();
                    $('.error').html(jData.msg);
                }else if(data.status == 503){
                    $('.error').show();
                    $('.error').html('Server is down please contact your administrator');
                    $('.login').removeAttr('disabled');
                    $('.login').html(html);
                    $('[name="username"]').removeClass('parsley-success');
                    $('[name="username"]').addClass('parsley-error');
                    $('[name="password"]').removeClass('parsley-success');
                    $('[name="password"]').addClass('parsley-error');
                    $('.error').show();
                    $('.error').html(jData.msg);
                }
            });
    };
    
    $scope.redirect = function(report, type){
        var reportName = report;
        var productType = type;
        document.getElementById("reportProductType").innerHTML = type;
        $('.userBackupSummaryModal').modal('show');
        $scope.updateUserBackupSummary(30,'all');
        if(type == 'office'){
            $('.notForOffice').hide();
            $('.forOffice').show();
        }else{
            $('.notForOffice').show();
            $('.forOffice').hide();
        }
    };
    
    $('.backupType').on('change', function(){
        if($('.backupType').val() == 'INCR'){
        	$scope.expandView(1, '', 'INCR');
        }else if($('.backupType').val() == 'FULL'){
        	$scope.expandView(1, '', 'FULL');
        }else{
       		$scope.expandView(1, '', '');
        }
        $('.actionn').show();
    });
    
    $('.backupTypeOnedrive').on('change', function(){
        if($('.backupTypeOnedrive').val() == 'INCR'){
        	$scope.expandViewOnedrive(1, '', 'INCR');
        }else if($('.backupTypeOnedrive').val() == 'FULL'){
        	$scope.expandViewOnedrive(1, '', 'FULL');
        }else{
       		$scope.expandViewOnedrive(1, '', '');
        }
        $('.actionnOnedrive').show();
    });
    
    $scope.searchCurrentlyRunningBackups = function(term){
    	if(term.length != 0){
    		if(term == 'all'){
    			$scope.expandView(1, '', '');
    		}else{
    			$scope.expandView(1, term, '');
    		}
   	 }
    };  
    
   $scope.searchCurrentlyRunningBackupsOnedrive = function(term){
   	if(term.length != 0){
   		if(term == 'all'){
   			$scope.expandViewOnedrive(1, '', '');
  		}else{
   			$scope.expandViewOnedrive(1, term, '');
   		}
   	}
   };
    
    /*backup endpoint start*/
   $scope.saveBulkEventHubCurrentBackup = function(action){
            var deviceUUID = $('input.select-item:checkbox:checked').map(function () {
            	return this.value;
            }).get();
            var stopBackup = 'false';
            var pauseBackup = 'false';
            if(action == 'pause'){
                pauseBackup = 'true';
            }else{
                stopBackup = 'true';
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveBulkEventHubCurrentBackup',
                data: {actionToDeviceUUID : deviceUUID, stopBackup : stopBackup, pauseBackup : pauseBackup},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(action == 'pause'){ 
                        toastr.success('Your request has been Queued.', 'Success!!!');
                    }else{ 
                        toastr.success('Your request has been Queued.', 'Success!!!');
                    }
		    setTimeout(function(){
                        location.reload();
                    }, 3000);                    
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

/*backup endpoint ends*/    

/*backup onedrive start*/

    $scope.saveBulkEventHubCurrentBackupSharepoint = function(action){
            var deviceUUID = $('input.select-item-sharepoint:checkbox:checked').map(function () {
            	return this.value;
            }).get();
            var stopBackup = 'false';
            var pauseBackup = 'false';
            if(action == 'pause'){
                pauseBackup = 'true';
            }else{
                stopBackup = 'true';
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveBulkEventHubCurrentBackup',
                data: {actionToDeviceUUID : deviceUUID, stopBackup : stopBackup, pauseBackup : pauseBackup},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(action == 'pause'){ 
                        toastr.success('Your request has been Queued.', 'Success!!!');
                    }else{ 
                        toastr.success('Your request has been Queued.', 'Success!!!');
                    }
                    setTimeout(function(){
                        location.reload();
                    }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };    

/*backup onedrive ends*/

/*restore endpoint start*/

    $scope.stopRestore = function(userName, deviceUUID, action, key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/stopRestore',
            data: {actionToDeviceUUID: deviceUUID,csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                document.getElementById('stopRestore_'+key).style.color="grey";
                document.getElementById('stopRestore_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.stopBulkRestore = function(){
            var deviceUUID = $('input.select-item-restore:checkbox:checked').map(function () {
            	return this.value;
            }).get();
            $.ajax({
                url: $scope.BASE_FOLDER+'/stopBulkRestore',
                data: {actionToDeviceUUID : deviceUUID},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Your request has been Queued.', 'Success!!!');
                    location.reload();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

/*restore endpoint ends*/    

/*restore onedrive start*/

    $scope.stopRestoreOnedrive = function(userName, deviceUUID, action, key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/stopRestore',
            data: {actionToDeviceUUID: deviceUUID,csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                document.getElementById('stopRestore_'+key).style.color="grey";
                document.getElementById('stopRestore_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.stopBulkRestoreSharepoint = function(){
            var deviceUUID = $('input.select-item-restore-sharepoint:checkbox:checked').map(function () {
            	return this.value;
            }).get();
            $.ajax({
                url: $scope.BASE_FOLDER+'/stopBulkRestore',
                data: {actionToDeviceUUID : deviceUUID},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Your request has been Queued.', 'Success!!!');
                    location.reload();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

/*restpre onedrive ends*/       

    function getMeDate(came){
	    var str = came;
	    var year = str.split('-').pop();
	    var daymonth = str.substring(0, str.lastIndexOf("-"));
	    var day = daymonth.substring(0, daymonth.lastIndexOf("-"));
	    var month = daymonth.split('-').pop();
	    var mon;
	    var finall;
	    switch (month) {
	      case 'Jan':
		mon = "01";
		break;
	      case 'Feb':
		mon = "02";
		break;
	      case 'Mar':
		mon = "03";
		break;
	      case 'Apr':
		mon = "04";
		break;
	      case 'May':
		mon = "05";
		break;
	      case  'Jun':
		mon = "06";
		break;
	      case 'Jul':
		mon = "07";
		break;
	      case 'Aug':
		mon = "08";
		break;
	      case 'Sep':
		mon = "09";
		break;
	      case 'Oct':
		mon = "10";
		break;
	      case 'Nov':
		mon = "11";
		break;
	      case  'Dec':
		mon = "12";
	    }
	    finall = mon+"/"+day+"/"+year;
	    return finall;
    }
    
    currentDate.setDate(currentDate.getDate() - 29);
    $scope.search.from = getFormattedDate(currentDate);
    $scope.isUserWithoutDeviceEnabled=false;
    $scope.showBlockedUsers =true;
    $scope.showBlockedDevices = true;

    function getFormattedDate(today){
        var dd = today.getDate();
        var mm = today.getMonth()+1;

        var yyyy = today.getFullYear();
        if(dd<10){
            dd='0'+dd
        }
        if(mm<10){
            mm='0'+mm
        }
        return mm+'/'+dd+'/'+yyyy;
    }
    
    function toggleSelectAll(control) {
    	var allOptionIsSelected = (control.val() || []).indexOf("all") > -1;
    	function valuesOf(elements) {
        	return $.map(elements, function(element) {
            		return element.value;
        });
    }

    if (control.data('allOptionIsSelected') != allOptionIsSelected) {
        // User clicked 'All' option
        if (allOptionIsSelected) {
            // Can't use .selectpicker('selectAll') because multiple "change" events will be triggered
            //control.selectpicker('val', valuesOf(control.find('option')));
            control.selectpicker('val', 'all');
        } else {
            control.selectpicker('val', []);
        }
    } else {
        // User clicked other option
        if (allOptionIsSelected && control.val().length != control.find('option').length) {
            // All options were selected, user deselected one option
            // => unselect 'All' option
            control.selectpicker('val', valuesOf(control.find('option:selected[value!=all]')));
            allOptionIsSelected = false;
        } else if (!allOptionIsSelected && control.val().length == control.find('option').length - 1) {
            // Not all options were selected, user selected all options except 'All' option
            // => select 'All' option too
            //control.selectpicker('val', valuesOf(control.find('option')));
            control.selectpicker('val', 'all');
            allOptionIsSelected = true;
        }
    }
    control.data('allOptionIsSelected', allOptionIsSelected);
    if($('#searchPolicyName').val() == ''){
                toastr.error('Please select atleast on policy.', {allowHtml: true});
                return;
                }
    }

    $('#searchPolicyName').selectpicker().change(function(){toggleSelectAll($(this));}).trigger('change');

    $("input:radio").change(function () {
        $('#searchPolicyName').selectpicker('render');
        $('#policyName').find('option[value="all"]').prop("selected",true);
        var val = $('input[name=userOption]:checked').val();
        if(val == 'policy'){
            $scope.policy = 'true';
            $scope.userNdDevice = 'false';
            $('#searchPolicyName').selectpicker('val', 'all');
            $(".searchUsername").select2("val", "all");
            $(".searchUsername").find('option[value="all"]').prop("selected",true);
            $('.searchDeviceName').val('');
        }else{
            $('#searchPolicyName').selectpicker('val', 'all');
            $('#searchPolicyName').find('option[value="all"]').prop("selected",true);
            $('.searchDeviceName').val('');
            $scope.policy = 'false';
            $scope.userNdDevice = 'true';
        }
    });
    
    $scope.updateStatisticsSync = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/syncStatistics',
            data: {secret: '',csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statisticsSync = jData.statisticsSync;
            $scope.unit = jData.unit;
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 401){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStatistics = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/statistics',
            data: {secret: '',csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statistics = jData.statistics;
	    if(jData.showBanner == 'yes'){
            	$('#licensewarning').show();
                document.getElementById('expiryDate').innerHTML = jData.isExpired;
            }
	    if(jData.showSoftBlockBanner == 'yes'){
                $('#softblockwarning').show();
            }
            $scope.$apply();
            $('.widget a').removeClass('d-none');
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 401){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateStatisticsOneDrive = function(type){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/onedDriveStatistics',
            data: {secret: '',csrf_token: $('.csrf_token').html(), type: type},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statisticsOneDrive = jData.statistics;
            $scope.$apply();
            $('.widget a').removeClass('d-none');
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 401){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerBackupDetails = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/statistics/serverBackup',
            data: {secret: '',csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statistics = jData.statistics;
            $scope.$apply();
            $('.widget a').removeClass('hide');
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateOverview = function(userName, pageNumber, deviceName,policyName ,isUserWithoutDeviceEnabled, showBlockedUsers, showBlockedDevices){
    	//blockUI.start();	
    	$('.first').hide();
    	//$('.self').hide();
    	$('.previous').hide();
    	$('.next').hide();
    	$('.last').hide();
    	$scope.pageNumber = pageNumber;
        //policyName = $('.selectPicker').selectpicker('val');
    	/*policyName = $('#searchPolicyName').val();
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        policyName = $('#searchPolicyName').val();*/
        if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }            
            
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
		showBlockedDevices = showBlockedUsers;
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
	if(userName == "? undefined:undefined ?"){
            userName = "all";
        }
	    console.log("policyName : "+policyName);
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/overview',
            //data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName,policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled},
            data: {pageNumber: pageNumber,csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName,policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled, showBlockedUsers: showBlockedUsers, showBlockedDevices:showBlockedDevices, reportProductType: productType},

            type: 'POST'
        }).done(function(data){
            //blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    $scope.previous = jData.metadata.links.previous;
		    $scope.next = jData.metadata.links.next;
		    $scope.last = jData.metadata.links.last;
		    //$scope.self = jData.metadata.links.self;
		    $scope.first = jData.metadata.links.first;
		    $scope.currentpageCount = jData.metadata.pageNumber;
		    $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		    if($scope.first){
		    	$('.first').show();
		    }
		    if($scope.previous){
		    	$('.previous').show();
		    }
		    if($scope.next){
		    	$('.next').show();
		    }
		    if($scope.last){
		    	$('.last').show();
		    }
		    $('.overviewListTable').show();
		    $('.loading').hide();
		    if(jData.overview.length > 0){
                    	$('.noBackupOverviewData').hide();                   
			$scope.overview = jData.overview;
			$scope.overviewJobTime = jData.overViewJobTime;
			$('.overviewJobTime').show();
			if(userName == 'all' && userName != ''){
				//$scope.skipValue = skipValue+1;
				$scope.pageNumber = pageNumber+1;
				$('.loadMoreBtn').removeAttr('disabled');
				$('.loadMoreBtn').html('Load More ...');
				$('.loadMoreBtn').show();
				$('.loadMore').show();
			}else{
				$('.loadMore').hide();
			}
			if(jData.overview != null && jData.overview.length < jData.metadata.recordsPerPage){
				$('.next').addClass('invalid');
			}else{
				$('.next').removeClass('invalid');
			}
			$scope.$apply();
			//if($scope.overview.length < $scope.initialLimit && userName == 'all'){
			//$scope.updateOverview('all', $scope.skipValue, 'all');
			//}
		    }else{
			$('.loading').hide();
			$('.loadMore').hide();
			$('.overviewListTable').hide();
			$('.noBackupOverviewData').show();
		    }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };


    $scope.updateOverviewNavigate = function(userName, deviceName,policyName ,isUserWithoutDeviceEnabled, url, showBlockedUsers, showBlockedDevices){
    	//blockUI.start();
    	/*$('.first').hide();
    	//$('.self').hide();
    	$('.previous').hide();
    	$('.next').hide();
    	$('.last').hide();*/
    	//$scope.pageNumber = pageNumber;
        //policyName = $('.selectPicker').selectpicker('val');
    	/*policyName = $('#searchPolicyName').val();
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
    	policyName = $('#searchPolicyName').val();*/
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }   
            
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
		showBlockedDevices = showBlockedUsers;
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
	if(userName == "? undefined:undefined ?"){
            userName = "all";
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/overview1',
    	    //data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName,policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled},
    	    data: {csrf_token: $('.csrf_token').html(),userName: userName, deviceName: deviceName,policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled, url:url, showBlockedUsers: showBlockedUsers, showBlockedDevices:showBlockedDevices, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            //blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
                $('.overviewListTable').show();
                $('.loading').hide();
                if(jData.overview.length > 0){
                    $('.noBackupOverviewData').hide();                   
                    $scope.overview = jData.overview;
                    $scope.overviewJobTime = jData.overViewJobTime;
                    $('.overviewJobTime').show();
                    if(userName == 'all' && userName != ''){
                    	//$scope.skipValue = skipValue+1;
                    	//$scope.pageNumber = pageNumber+1;
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
		    if(jData.overview != null && jData.overview.length < jData.metadata.recordsPerPage){
				$('.next').addClass('invalid');
			}else{
				$('.next').removeClass('invalid');
			}
                    $scope.$apply();
                    //if($scope.overview.length < $scope.initialLimit && userName == 'all'){
                    //    $scope.updateOverview('all', $scope.skipValue, 'all');
                    //}
                }else{
                    $('.loading').hide();
                    $('.loadMore').hide();
                    $('.overviewListTable').hide();
                    $('.noBackupOverviewData').show();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchUserInOverView = function(userName ,policyName){
    	if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        $('.noBackupOverviewData').show();
        $('.overviewListTable').hide();
           return;
        }
        $('.loading').show();
        $('.loading').html('Loading...');
        if($scope.policy == 'true'){
        	if(policyName == ""){
        		$('.loading').hide();
        		toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        		return;
        	}
		policyName = policyName;
        }else{
        	policyName = 'all';
        }
	if($scope.all == 'all'){
		$scope.policyName = 'all';
	}else{
		$scope.policyName = policyName;
	}
	var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled").prop('checked');
	$scope.isUserWithoutDeviceEnabled=isUserWithoutDeviceEnabled;

	var showBlockedUsers = $("#showBlockedUsers").prop('checked');
	$scope.showBlockedUsers=showBlockedUsers;

	var showBlockedDevices = $("#showBlockedDevices").prop('checked');
	$scope.showBlockedDevices=showBlockedDevices;
	if(userName == "all"){
            $scope.skipValue = 0;
            //$scope.$apply();
        }
        var userName = $('.searchUsername').val();
        var deviceName = $('.searchDeviceName').val();
        $scope.policyName = $('#searchPolicyName').val();
        $scope.updateOverview(userName, 1, deviceName,$scope.policyName,$scope.isUserWithoutDeviceEnabled, $scope.showBlockedUsers, $scope.showBlockedDevices);               
    };

    $scope.searchUserInOverViewNavigate = function(userName ,policyName, url){
	if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        	toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        	$('.noBackupOverviewData').show();
        	$('.overviewListTable').hide();
        	return;
        }
        $('.loading').show();
        $('.loading').html('Loading...');
	if($scope.policy == 'true'){
		if(policyName == ""){
			$('.loading').hide();
			toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           		return;
		}
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		$scope.policyName = 'all';
	}else{
		$scope.policyName = policyName;
	}
	var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled").prop('checked');
	$scope.isUserWithoutDeviceEnabled=isUserWithoutDeviceEnabled;

	var showBlockedUsers = $("#showBlockedUsers").prop('checked');
	$scope.showBlockedUsers=showBlockedUsers;

	var showBlockedDevices = $("#showBlockedDevices").prop('checked');
	$scope.showBlockedDevices=showBlockedDevices;
	if(userName == "all"){
		//$scope.skipValue = 0;
		//$scope.$apply();
        }
        var userName = $('.searchUsername').val();
        var deviceName = $('.searchDeviceName').val();
        $scope.policyName = $('#searchPolicyName').val();
        $scope.updateOverviewNavigate(userName, deviceName,$scope.policyName,$scope.isUserWithoutDeviceEnabled, url, $scope.showBlockedUsers, $scope.showBlockedDevices);
               
    };

    $scope.updateRestoreHistory = function(from, to, userName, deviceName, pageNumber,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
	if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        	toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
		$('.restoreError').show();
		$('.restoreHistory').hide();
           return;
        }
        if(userName.length <= 0 || userName == 'all'){
            userName = $('.searchUsername').val();
        }

        if(deviceName.length <= 0 || deviceName == 'all'){
            deviceName = $('.searchDeviceName').val();
        }
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        /*policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }*/
	//$scope.skipValue = skipValue;
	var pageNumber = $scope.pageNumber;
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        //policyName = $('#searchPolicyName').val();
        var from = $('#from').val();
        var to = $('#to').val();            
        from = getMeDate(from);
        to = getMeDate(to);
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }               
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	if(userName == "? undefined:undefined ?"){
            //userName = "all";
            userName = "null";
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.restoreError').show();
            $('.restoreHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
        blockUI.start();
	    console.log("productType : "+productType);
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/restoreHistory',
            data: {pageNumber:pageNumber,csrf_token: $('.csrf_token').html(), to: to, from: from, userName: userName, deviceName:deviceName,policyName:policyName, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.restoreByDate == null){
                    $('.restoreError').show();
                    $('.restoreHistory').hide();
                }else{
                    $('.restoreError').hide();
                    $('.restoreHistory').show();
                }                
		$scope.restoreByDate = jData.restoreByDate;
		if(jData.restoreByDate != null && jData.restoreByDate.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
		//$scope.skipValue = parseInt(skipValue)+1;
		//$scope.pageNumber = pageNumber+1;
                $scope.$apply();
                if(jData.restoreByDate != null && $scope.restoreByDate.length < $scope.initialLimit){
                    //$scope.updateRestoreHistory(from, to, userName, deviceName, $scope.skipValue);
                }else{
                    if(jData.restoreByDate != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };


    $scope.updateRestoreHistoryNavigate = function(from, to, userName, deviceName,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        	toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
       		$('.restoreError').show();
        	$('.restoreHistory').hide();
           	return;
        }
        if(userName.length <= 0 || userName == 'all'){
            userName = $('.searchUsername').val();
        }
        if(deviceName.length <= 0 || deviceName == 'all'){
            deviceName = $('.searchDeviceName').val();
        }
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}        
        //policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
    	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }   
            
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	if(userName == "? undefined:undefined ?"){
            //userName = "all";
            userName = "null";
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.restoreError').show();
            $('.restoreHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
        var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
    	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/restoreHistory1',
            data: {csrf_token: $('.csrf_token').html(), to: to, from: from, userName: userName, deviceName:deviceName,policyName:policyName,url:url, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	$scope.previous = jData.metadata.links.previous;
            	$scope.next = jData.metadata.links.next;
            	$scope.last = jData.metadata.links.last;
            	//$scope.self = jData.metadata.links.self;
            	$scope.first = jData.metadata.links.first;
            	$scope.currentpageCount = jData.metadata.pageNumber;
            	$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            	if($scope.first){
            		$('.first').show();
            	}else{
            		$('.first').hide();
            	}
            	if($scope.previous){
            		$('.previous').show();
            	}else{
            		$('.previous').hide();
            	}
            	if($scope.next){
            		$('.next').show();
            	}
            	if($scope.last){
            		$('.last').show();
            	}else{
            		$('.last').hide();
            	}
                if(jData.restoreByDate == null){
                    $('.restoreError').show();
                    $('.restoreHistory').hide();
                }else{
                    $('.restoreError').hide();
                    $('.restoreHistory').show();
                }
		$scope.restoreByDate = jData.restoreByDate;
		if(jData.restoreByDate != null && jData.restoreByDate.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
		//$scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.restoreByDate != null && $scope.restoreByDate.length < $scope.initialLimit){
                    //$scope.updateRestoreHistory(from, to, userName, deviceName, $scope.skipValue);
                }else{
                    if(jData.restoreByDate != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateSyncCloudUsageDetails = function(from, to){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/updateSyncCloudUsageDetails',
            data: {csrf_token: $('.csrf_token').html(), to: to, from: from},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.syncCloudUsageDetails == null){
                    $('.syncCLoudUsageError').show();
                    $('.syncCLoudUsageWithDetails').hide();
                }else{
                    $('.syncCLoudUsageError').hide();
                    $('.syncCLoudUsageWithDetails').show();
                }
                $scope.syncCloudUsageDetails = jData.syncCloudUsageDetails;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateLongBackup = function(skipValue){
        $scope.skipValue = skipValue;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/longBackup',
            data: {skipValue: skipValue, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.longBackup == null){
                    $('.longBackupError').show();
                    $('.longBackup').hide();
                }else{
                    $('.longBackupError').hide();
                    $('.longBackup').show();
                }
                if($scope.skipValue == 0){
                    $scope.longBackup = jData.longBackup;
                }else{
                    if(jData.longBackup != null){
                        $scope.longBackup = $scope.longBackup.concat(jData.longBackup);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.longBackup != null && $scope.longBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.longBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateCurrentBackup = function(pageNumber, productType){
	if(productType == 'backup'){
		var type = 'BACKUP';
	}else{
		var type = productType;
	}
        $.ajax({
		url: $scope.BASE_FOLDER+'/report/currentBackup',
            data: {pageNumber: pageNumber, csrf_token: $('.token').html(), backupType: '', searchValue: '', type: type, productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
	    console.log("data : "+data);
            if(jData.result == 'success'){
		if(productType == 'backup'){
			if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    		$('.currentBackupError').show();
                    		$('.currentBackup').hide();
		    		$('.currentBackupDiv').hide();
		    		$('#expandBackupStatement').hide();
                	}else{
                    		$('.currentBackupError').hide();
                    		$('.currentBackup').show();
		    		$('.currentBackupDiv').show();
		    		$('#expandBackupStatement').show();
                	}
		}
		if(productType == 'ONEDRIVE'){
                        if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    		$('.currentBackupErrorOnedrive').show();
                    		$('.currentBackupOnedrive').hide();
                    		$('.currentBackupDivOnedrive').hide();
                    		$('#expandBackupStatementOnedrive').hide();
                	}else{
                    		$('.currentBackupErrorOnedrive').hide();
                    		$('.currentBackupOnedrive').show();
                    		$('.currentBackupDivOnedrive').show();
                    		$('#expandBackupStatementOnedrive').show();
                	}
                }
		if(productType == 'EXCHANGE'){
                        if(jData.currentBackup == null || jData.currentBackup.length == 0){
                                $('.currentBackupErrorExchange').show();
                                $('.currentBackupExchange').hide();
                                $('.currentBackupDivExchange').hide();
                                $('#expandBackupStatementExchange').hide();
                        }else{
                                $('.currentBackupErrorExchange').hide();
                                $('.currentBackupExchange').show();
                                $('.currentBackupDivExchange').show();
                                $('#expandBackupStatementExchange').show();
                        }
                }
		$scope.currentBackup = jData.currentBackup;		
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateCurrentBackupSharepoint = function(pageNumber, productType){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup',
            data: {pageNumber: pageNumber, csrf_token: $('.token').html(),backupType: '', searchValue: '', type: 'SHAREPOINT', productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
	    console.log("data : "+data);
            if(jData.result == 'success'){
		if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    $('.currentBackupErrorSharepoint').show();
                    $('.currentBackupSharepoint').hide();
		    $('.currentBackupDivSharepoint').hide();
		    $('#expandBackupStatementSharepoint').hide();
                }else{
                    $('.currentBackupErrorSharepoint').hide();
                    $('.currentBackupSharepoint').show();
		    $('.currentBackupDivSharepoint').show();
		    $('#expandBackupStatementSharepoint').show();
                }
		$scope.currentBackup = jData.currentBackup;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateNoBackup = function(pageNumber, numberOfDays,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        if($scope.all == 'all'){
        policyName = 'all';
        }else{
        policyName = policyName;
        }
        $('.noBackupError').hide();
	//$scope.skipValue = skipValue;
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                    policyName.splice(i, 1);
            }
        }*/
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                console.log("policyNameOOOOO : "+policyName);
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        //policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
	var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/noBackup',
            data: {pageNumber: pageNumber, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.noBackup == null || jData.noBackup == ''){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }		
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}		
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
		$scope.noBackup = jData.noBackup;
                if(jData.noBackup == 'noData'){
                	$('.noBackupError').show();
                	$('.noBackup').hide();
                }
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
		$scope.pageNumber = pageNumber+1;
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                $('.noBackupError').show();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateNoBackupNavigate = function(numberOfDays,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        if($scope.all == 'all'){
        policyName = 'all';
        }
        else{
        policyName = policyName;
        }
        $('.noBackupError').hide();
	//$scope.skipValue = skipValue;
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                    policyName.splice(i, 1);
            }
        }
    	policyName = $('#searchPolicyName').val();*/
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                console.log("policyNameOOOOO : "+policyName);
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
    	var numberOfDays = $('#noOfDays').val();
	var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
    	blockUI.stop();
	myBlockUI.stop();
	$('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/noBackup1',
            data: {numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.noBackup == null || jData.noBackup == ''){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
		$scope.noBackup = jData.noBackup;
                if(jData.noBackup == 'noData'){
                	$('.noBackupError').show();
                        $('.noBackup').hide();
                }
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                $('.noBackupError').show();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateAgentNotHeard = function(numberOfDays,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        if($scope.all == 'all' || policyName==undefined){
        policyName = 'all';
        }
        else{
        policyName = policyName;
        }
        var number = $('#noOfDays').val();
        $('.noBackupError').hide();
        if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/lastAgentServerConnectionDetails',
            data: {numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(),pageNumber:pageNumber, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            //$('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.noBackup').show();          
			$scope.previous = jData.metadata.links.previous;
			$scope.next = jData.metadata.links.next;
			$scope.last = jData.metadata.links.last;
			//$scope.self = jData.metadata.links.self;
			$scope.first = jData.metadata.links.first;
			$scope.currentpageCount = jData.metadata.pageNumber;
			$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			if($scope.first){
				$('.first').show();
			}			
			if($scope.previous){
				$('.previous').show();
			}
			if($scope.next){
				$('.next').show();
			}
			if($scope.last){
				$('.last').show();
			}
			}else{
				$('.noBackup').hide();
			}
			if(jData.noBackup == null){
				$('.noBackupError').show();
				$('.noBackup').hide();
			}else{
				$('.noBackupError').hide();
				$('.noBackup').show();
			}
			if(jData.noBackup != null){
                        	//$scope.noBackup = $scope.noBackup.concat(jData.noBackup);
                        	$scope.noBackup = jData.noBackup;
			}
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateAgentNotHeardNavigate = function(numberOfDays,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        if($scope.all == 'all' || policyName==undefined){
        policyName = 'all';
        }
        else{
        policyName = policyName;
        }
        var number = $('#noOfDays').val();
        $('.noBackupError').hide();
        if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }        
        policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/lastAgentServerConnectionDetails1',
            data: {numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            //$('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.metadata != ''){
                	$('.noBackup').show();          
                	$scope.previous = jData.metadata.links.previous;
                	$scope.next = jData.metadata.links.next;
                	$scope.last = jData.metadata.links.last;
                	//$scope.self = jData.metadata.links.self;
                	$scope.first = jData.metadata.links.first;
                	$scope.currentpageCount = jData.metadata.pageNumber;
                	$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                	if($scope.first){
                		$('.first').show();
                	}else{
                		$('.first').hide();
                	}
                	if($scope.previous){
                		$('.previous').show();
                	}else{
                		$('.previous').hide();
                	}
                	if($scope.next){
                		$('.next').show();
                	}
                	if($scope.last){
                		$('.last').show();
                	}else{
				$('.last').hide();
			}
                }else{
                	$('.noBackup').hide();
                }   
                if(jData.noBackup == null){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }
                if(jData.noBackup != null){
                        //$scope.noBackup = $scope.noBackup.concat(jData.noBackup);
                        $scope.noBackup = jData.noBackup;
                }
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadAgentNotHeardReport = function(number, policyName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
    	}   
        var number = $('#noOfDays').val();
        if (number <= 0 || typeof number === 'undefined' || number === null ){
                toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }
        policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadAgentNotHeardReport',
            data: {number : number, policyName: policyName, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadAgentNotHeardReportExcel';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');	   
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateUserBackupSummary = function(numberOfDays,policyName){
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        /*if($scope.all == 'all' || policyName==undefined){
        policyName = 'all';
        }
        else{
        policyName = policyName;
        }*/
        var number = $('#noOfDays').val();
        $('.noBackupError').hide();
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }*/
        if($('.reportProductType').html() == 'office'){
            $('.notForOffice').hide();
            $('.forOffice').show();
        }else{
            $('.notForOffice').show();
            $('.forOffice').hide();
        }
        if(document.getElementsByClassName("heartbeat")[0]){
                document.getElementsByClassName("heartbeat")[0].innerHTML = number;
        }
        if(document.getElementsByClassName("protected")[0] ){
                document.getElementsByClassName("protected")[0].innerHTML = number;
        }
        if(document.getElementsByClassName("protected")[1] ){
                document.getElementsByClassName("protected")[1].innerHTML = number;
        }   
        //policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
	if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
		productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
		productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
		productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
		productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
        $('.loading').show();
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userBackupSummary',
        data: {numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            //$('.downloadButton').show();
            blockUI.stop();
        $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userBackupSummary == null){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
		    $('.onlysharepoint').hide();
                }else{
                    $('.noBackupError').hide();
		    if($('.reportProductType').html() != 'sharepoint'){
                    	$('.noBackup').show();
			$('.onlysharepoint').hide()
		    }
		    if($('.reportProductType').html() == 'sharepoint'){
			$('.onlysharepoint').show();
			$('.noBackup').hide();
		    }
                }
                if(jData.userBackupSummary != null){
                    //$scope.noBackup = $scope.noBackup.concat(jData.noBackup);
                    $scope.userBackupSummary = jData.userBackupSummary;
                }
                $scope.$apply();
                if(jData.userBackupSummary != null && $scope.userBackupSummary.length < $scope.initialLimit){
                }else{
                    if(jData.userBackupSummary != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.downloadUserBackupSummaryReport = function(number, policyName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        /*if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }*/    
        var number = $('#noOfDays').val();
        if (number <= 0 || typeof number === 'undefined' || number === null ){
                toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }
        policyName = $('#searchPolicyName').val();*/
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val();
                var userName = $('.searchSitename').val();
        }       
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadUserBackupSummaryReport',
        data: {number : number, policyName: policyName, reportProductType: productType, includeDetails: $("#includeDetails").prop('checked')},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadUserBackupSummaryReportExcel';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageUtilized = function(userName, deviceName, skipValue){
        $('.storageUtilizedError').hide();
        $scope.current.userName = userName;
        $scope.current.deviceName = deviceName;
        $scope.skipValue = skipValue;
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/storageUtilized',
            data: {skipValue: skipValue, csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.storageUtilized == null){
                    $('.storageUtilizedError').show();
                    $('.storageUtilized').hide();
                }else{
                    $('.storageUtilizedError').hide();
                    $('.storageUtilized').show();
                }
                if($scope.skipValue == 0){
                    $scope.storageUtilized = jData.storageUtilized;
                }else{
                    if(jData.storageUtilized != null){
                        $scope.storageUtilized = $scope.storageUtilized.concat(jData.storageUtilized);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.storageUtilized != null && $scope.storageUtilized.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.storageUtilized != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageUtilizedByPG = function(){
        $('.storageUtilizedByPGError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/storageUtilizedByPG',
            data: {skipValue: '', csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.storageUtilizedByPG == null){
                    $('.storageUtilizedByPGError').show();
                    $('.storageUtilizedByPG').hide();
                }else{
                    $('.storageUtilizedByPGError').hide();
                    $('.storageUtilizedByPG').show();
                }
                $scope.storageUtilizedByPG = jData.storageUtilizedByPG;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFailedBackupByDate = function(from, to, pageNumber,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        $('.failedBackupError').show();
        $('.failedBackup').hide();
           return;
        }
        var userName = $('.searchUsername').val();
        if(userName == "? undefined:undefined ?"){
            userName = "null";
        }
        var deviceName = $('.searchDeviceName').val();
        $scope.policyName = policyName;
	if($scope.policy == 'true'){
        	policyName = policyName;
        }else{
        	policyName = 'all';
        }
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }
        $('.failedBackupError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        policyName = $('#searchPolicyName').val();
        var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/failedBackup',
            data: {pageNumber: pageNumber, from: from, to: to,userName: userName, deviceName: deviceName,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupError').show();
                    $('.failedBackup').hide();
                }else{
                    $('.failedBackupError').hide();
                    $('.failedBackup').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }
                /*if($scope.self){
                	$('.self').show();
                }*/
                if($scope.previous){
                	$('.previous').show();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }
                $scope.failedBackup = jData.failedBackup;
		if(jData.failedBackup != null && jData.failedBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.pageNumber = pageNumber+1;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFailedBackupByDateNavigate = function(from, to, policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
           toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           $('.failedBackupError').show();
           $('.failedBackup').hide();
           return;
        }
        var userName = $('.searchUsername').val();
        if(userName == "? undefined:undefined ?"){
            userName = "null";
        }
        var deviceName = $('.searchDeviceName').val();
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
        	policyName = policyName;
        }else{
        	policyName = 'all';
        }
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
       	 policyName = policyName;
        }        
        $('.failedBackupError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        policyName = $('#searchPolicyName').val();
        var from = $('#from').val();
        var to = $('#to').val();            
        from = getMeDate(from);
        to = getMeDate(to);
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/failedBackup1',
            data: {from: from, to: to,userName: userName, deviceName: deviceName,policyName:policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }else{
                	$('.first').hide();
                }
                if($scope.previous){
                	$('.previous').show();
                }else{
                	$('.previous').hide();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }else{
                $('.last').hide();
                }
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupError').show();
                    $('.failedBackup').hide();
                }else{
                    $('.failedBackupError').hide();
                    $('.failedBackup').show();
                }
                $scope.failedBackup = jData.failedBackup;
		if(jData.failedBackup != null && jData.failedBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFailedBackupByUserOrDevice = function(userName, deviceName, skipValue){
        $('.failedBackupByUserOrDeviceError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/failedBackup',
            data: {skipValue: skipValue, userName: userName, deviceName: deviceName, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupByUserOrDeviceError').show();
                    $('.failedBackupByUserOrDevice').hide();
                }else{
                    $('.failedBackupByUserOrDeviceError').hide();
                    $('.failedBackupByUserOrDevice').show();
                }
                if(skipValue == 0){
                    $scope.failedBackupByUserOrDevice = jData.failedBackup;
                }else{
                    $scope.failedBackupByUserOrDevice = $scope.failedBackupByUserOrDevice.concat(jData.failedBackup);
                    if(jData.failedBackup.length > 0){
                        $scope.skipValue = skipValue+1;
                        $scope.updateFailedBackupByUserOrDevice(from, to, skipValue)
                    }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserDeviceHistory = function(userName){
        $('.userDeviceHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userDeviceHistory',
            data: {userName: userName, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userDeviceHistory == null){
                    $('.userDeviceHistoryError').show();
                    $('.userDeviceHistory').hide();
                }else{
                    $('.userDeviceHistoryError').hide();
                    $('.userDeviceHistory').show();
                }
                $scope.userDeviceHistory = jData.userDeviceHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function showDetailsForSelectedRow() {
        $("td[details=9]").find("p").hide();
        $("#SomeTable").click(function(event) {
            event.stopPropagation();
            var $target = $(event.target);
            if ( $target.closest("td").attr("details") > 1 ) {
                $target.slideUp();
            } else {
                $target.closest("tr").next().find("p").slideToggle();
            }
        });
    }

    $scope.updateUserBackupHistory = function(userName, from, to,deviceName,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
           return;
        }
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
	}
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }
        if(userName == undefined){
            userName = "null";
        }
        if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
        	policyName = policyName;
        }else{
        	policyName = 'all';
        }
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }        
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        /*policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }*/
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        //policyName = $('#searchPolicyName').val();
	if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
		var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
		var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
		var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
		var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
	if(policyName == ''){
	    toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
		blockUI.stop();
            myBlockUI.stop();
           return;
	}
        var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
        blockUI.start();
	if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userBackupHistory',
            data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(), pageNumber:pageNumber, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userBackupHistory == null || jData.userBackupHistory.length <= 0){
                    $('.userBackupHistoryError').show();
                    $('.userBackupHistory').hide();
                }else{
                    $('.userBackupHistoryError').hide();
                    $('.userBackupHistory').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }
                if($scope.previous){
               		$('.previous').show();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }
                $scope.userBackupHistory = jData.userBackupHistory;
		if(jData.userBackupHistory != null && jData.userBackupHistory.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserBackupHistoryNavigate = function(userName, from, to,deviceName,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
           return;
        }
        //var deviceName = $('.searchDeviceName').val();
        //var userName = $('.searchUsername').val();
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }
        if(userName == undefined){
            userName = "null";
        }
        if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
        	policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        /*policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    
        policyName = $('#searchPolicyName').val();*/
	if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
        var from = $('#from').val();
        var to = $('#to').val();
	from = getMeDate(from);
        to = getMeDate(to);
        blockUI.start();
	if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userBackupHistory1',
            data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userBackupHistory == null){
                    $('.userBackupHistoryError').show();
                    $('.userBackupHistory').hide();
                }else{
                    $('.userBackupHistoryError').hide();
                    $('.userBackupHistory').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }else{
                	$('.first').hide();
                }
                if($scope.previous){
                	$('.previous').show();
                }else{
                	$('.previous').hide();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }else{
                	$('.last').hide();
                }
                $scope.userBackupHistory = jData.userBackupHistory;
		if(jData.userBackupHistory != null && jData.userBackupHistory.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDailyUserBackupOverview = function(userName,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
           toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           $('.dailyUserBackupOverviewError').show();
           $('.dailyUserBackupOverview').hide();
           return;
        }
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        var userName = $('.searchUsername').val();
        var deviceName = $('.searchDeviceName').val();
        if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
        	policyName = policyName;
        }else{
        	policyName = 'all';
        }
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        policyName = $('#searchPolicyName').val();
        blockUI.start();    
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/getDailyUserBackupOverview',
            data: {userName: userName,deviceName: deviceName, policyName: policyName, csrf_token: $('.csrf_token').html(),pageNumber:pageNumber, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.dailyUserBackupOverview.length <=0){
                    $('.dailyUserBackupOverviewError').show();
                    $('.dailyUserBackupOverview').hide();
                }else{
                    $('.dailyUserBackupOverviewError').hide();
                    $('.dailyUserBackupOverview').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                $scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }
                if($scope.self){
                	$('.self').show();
                }
                if($scope.previous){
                	$('.previous').show();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }
                $scope.dailyUserBackupOverview = jData.dailyUserBackupOverview;
		if(jData.dailyUserBackupOverview != null && jData.dailyUserBackupOverview.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };


    $scope.updateDailyUserBackupOverviewNavigate = function(userName,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           $('.dailyUserBackupOverviewError').show();
           $('.dailyUserBackupOverview').hide();
           return;
        }
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        var userName = $('.searchUsername').val();
        var deviceName = $('.searchDeviceName').val();
        if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
        	policyName = policyName;
        }else{
		policyName = 'all';
	}
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }        
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    
        policyName = $('#searchPolicyName').val();
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/getDailyUserBackupOverview1',
            data: {userName: userName,deviceName: deviceName, policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.dailyUserBackupOverview.length <=0){
                    $('.dailyUserBackupOverviewError').show();
                    $('.dailyUserBackupOverview').hide();
                }else{
                    $('.dailyUserBackupOverviewError').hide();
                    $('.dailyUserBackupOverview').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                $scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }else{
                	$('.first').hide();
                }
                if($scope.previous){
                	$('.previous').show();
                }else{
                	$('.previous').hide();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }else{
                	$('.last').hide();
		}
                $scope.dailyUserBackupOverview = jData.dailyUserBackupOverview;
		if(jData.dailyUserBackupOverview != null && jData.dailyUserBackupOverview.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadDailyUserBackupOverview = function(userName, policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
            return;
        }
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
	policyName = $('#searchPolicyName').val();
	var userName = $('.searchUsername').val();
	var deviceName = $('.searchDeviceName').val();
	if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverview',
            data: {userName: userName, deviceName: deviceName, policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverviewExcel';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageTrend = function(from, to){
        var source = '';
        if($scope.currentPage != 'dashboard' && $scope.currentPage != 'serverBackup'){
            $('.storageTrend').html();
            $('.storageTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        }else{
            source = 'dashboard';
        }
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/storageTrend',
            data: { from : from, to : to, source: source}
        }).success(function(response){
            $('.loading').hide();
            var jData = jQuery.parseJSON(response);
            if(jData.result == 'fail') {
                if($scope.currentPage == 'dashboard' || $scope.currentPage == 'serverBackup'){
                    $('.storageTrendPanel').html('<div class="text-center" style="height:260px; width:545px"><br/><br/><br/><br/><br/>There was no recent activity :)</div>');
                }
                $('#myChart').addClass('hide');
                if(jData.msg.length > 0){
                    toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                }else if(from.length > 0 && from.to > 0){
                    toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                }else{
                    toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                }
            }else {
                $('#myChart').removeClass('hide');
                var data = {
                    labels: [],
                    datasets: []
                };
                for (var key in jData) {
                    var label = key;
                    var seriesData = [];
                    var color   = getRandomColor();
                    jData[key].forEach(function (item) {
                        if ($.inArray(item.date, data.labels) == -1) {
                            data.labels.push(item.date);
                        }
                        seriesData.push(item.size);
                    });
                    data.datasets.push(
                        {
                            label: label,
                            fillColor: "rgba(236,102,33,0)",
                            strokeColor: color,
                            pointColor: color,
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(238,84,33,1)",
                            data: seriesData
                        }
                    );
                }
                Chart.defaults.global.responsive = true;
                Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                var ctx = document.getElementById("myChart").getContext("2d");
                var myLineChart = new Chart(ctx).Line(data);
                myLineChart.removeData();
            }
        }).fail(function(data){
        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateBlobTrend = function(from, to){
        $('.blobTrend').html();
        $('.blobTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/blobTrend',
            data: { from : from, to : to }
        }).success(function(response){
                $('.loading').hide();
                var jData = jQuery.parseJSON(response);
                if(jData.result == 'fail') {
                    $('#myChart').addClass('hide');
                    if(jData.msg.length > 0){
                        toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                    }else if(from.length > 0 && from.to > 0){
                        toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                    }else{
                        toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                    }
                }else {
                    $('#myChart').removeClass('hide');
                    var data = {
                        labels: [],
                        datasets: []
                    };
                    for (var key in jData) {
                        var label = key;
                        var seriesData = [];
                        var color   = getRandomColor();
                        jData[key].forEach(function (item) {
                            if ($.inArray(item.date, data.labels) == -1) {
                                data.labels.push(item.date);
                            }
                            seriesData.push(item.size);
                        });
                        data.datasets.push(
                            {
                                label: label,
                                fillColor: "rgba(236,102,33,0)",
                                strokeColor: color,
                                pointColor: color,
                                pointStrokeColor: "#fff",
                                pointHighlightFill: "#fff",
                                pointHighlightStroke: "rgba(238,84,33,1)",
                                data: seriesData
                            }
                        );
                    }
                    Chart.defaults.global.responsive = true;
                    Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    var ctx = document.getElementById("myChart").getContext("2d");
                    var myLineChart = new Chart(ctx).Line(data);
                    myLineChart.removeData();
                }
            }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateBackupTrend = function(from, to){
        $('.blobTrend').html();
        $('.blobTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/backupTrend',
            data: { from : from, to : to }
        }).success(function(response){
                $('.loading').hide();
                var jData = jQuery.parseJSON(response);
                if(jData.result == 'fail') {
                    $('#myChart').addClass('hide');
                    if(jData.msg.length > 0){
                        toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                    }else if(from.length > 0 && from.to > 0){
                        toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                    }else{
                        toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                    }
                }else {
                    $('#myChart').removeClass('hide');
                    var data = {
                        labels: [],
                        datasets: []
                    };
                    for (var key in jData) {
                        var label = key;
                        var seriesData = [];
                        var color   = getRandomColor();
                        jData[key].forEach(function (item) {
                            if ($.inArray(item.date, data.labels) == -1) {
                                data.labels.push(item.date);
                            }
                            seriesData.push(item.size);
                        });
                        data.datasets.push(
                            {
                                label: label,
                                fillColor: "rgba(236,102,33,0)",
                                strokeColor: color,
                                pointColor: color,
                                pointStrokeColor: "#fff",
                                pointHighlightFill: "#fff",
                                pointHighlightStroke: "rgba(238,84,33,1)",
                                data: seriesData
                            }
                        );
                    }
                    Chart.defaults.global.responsive = true;
                    Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    var ctx = document.getElementById("myChart").getContext("2d");
                    var myLineChart = new Chart(ctx).Line(data);
                    myLineChart.removeData();
                }
            }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function getRandomColor() {
        var letters = '0123456789ABCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++ ) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }

    $scope.updateDeviceUserHistory = function(deviceName){
        $('.deviceUserHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceUserHistory',
            data: {deviceName: deviceName, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceUserHistory == null){
                    $('.deviceUserHistoryError').show();
                    $('.deviceUserHistory').hide();
                }else{
                    $('.deviceUserHistoryError').hide();
                    $('.deviceUserHistory').show();
                }
                $scope.deviceUserHistory = jData.deviceUserHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDeviceBackupHistory = function(deviceName, from, to){
        $('.deviceBackupHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceBackupHistory',
            data: {deviceName: deviceName, from: from, to: to, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceBackupHistory == null){
                    $('.deviceBackupHistoryError').show();
                    $('.deviceBackupHistory').hide();
                }else{
                    $('.deviceBackupHistoryError').hide();
                    $('.deviceBackupHistory').show();
                }
                $scope.deviceBackupHistory = jData.deviceBackupHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getLastBackupDetails = function(deviceName, userName){
        $('.lastBackupDetailsError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/lastBackupDetails',
            data: {deviceName: deviceName, userName: userName, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.lastBackupDetails == null){
                    $('.lastBackupDetailsError').show();
                    $('.lastBackupDetails').hide();
                }else{
                    $('.lastBackupDetailsError').hide();
                    $('.lastBackupDetails').show();
                }
                $scope.lastBackupDetails = jData.lastBackupDetails;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateAlertHistory = function(userName, deviceName, from, to){
        $('.alertHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/alertHistory',
            data: {deviceName: deviceName, userName: userName, from: from, to: to, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.alertHistory == null){
                    $('.alertHistoryError').show();
                    $('.alertHistory').hide();
                }else{
                    $('.alertHistoryError').hide();
                    $('.alertHistory').show();
                }
                $scope.alertHistory = jData.alertHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserMigration = function(skipValue){
        $('.userMigrationError').hide();
        $('.loading').show();
        var pageNumber = $scope.pageNumber;
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userMigration',
            data: {skipValue: skipValue, csrf_token: $('.csrf_token').html(),pageNumber: pageNumber},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.loading').hide();
                if(jData.userMigration.length > 0){
                $('.userMigrationNavigate').show();
                $('.userMigration').show();
                $('.userMigrationError').hide();
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                	$('.first').show();
                }       
                if($scope.previous){
                	$('.previous').show();
                }
                if($scope.next){
                	$('.next').show();
                }
                if($scope.last){
                	$('.last').show();
                }
                $scope.userMigration = jData.userMigration;
                }else{
            		$('.userMigration').hide();
        		$('.userMigrationNavigate').hide();
            		$('.userMigrationError').show();
                }
                $scope.$apply();
            }else{
                $('.userMigration').hide();
        }
        }).fail(function(data){
               toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserMigrationNavigate = function(url){
        $('.userMigrationError').hide();
        $('.loading').show();
        /*$('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();*/
        blockUI.start();
            $.ajax({
            url: $scope.BASE_FOLDER+'/report/userMigration1',
            data: {csrf_token: $('.csrf_token').html(),url: url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            $('.loading').hide();
            if(jData.userMigration.length > 0){
                $('.userMigration').show();
                $('.userMigrationNavigate').show();
                $('.userMigrationError').hide();
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }else{
                $('.first').hide();
                }
                if($scope.previous){
                $('.previous').show();
                }else{
                $('.previous').hide();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }else{
                $('.last').hide();
                }
                $scope.userMigration = jData.userMigration;
            }else{
                $('.userMigration').hide();
                $('.userMigrationNavigate').hide();
                $('.userMigrationError').show();
            }
            $scope.$apply();
        }else{
            $('.userMigration').hide();
        }
        }).fail(function(data){
               toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
            setTimeout(function(){
                window.location.href = $scope.BASE_FOLDER+'/sleep';
            }, 3000);
            }else if(data.status == 503){
            setTimeout(function(){
                window.location.href = $scope.BASE_FOLDER+'/serviceDown';
            }, 3000);
            }
        });
        };

    $scope.loadMore = function(skipValue, type){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if(type == 'overview'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateOverview('all', skipValue, 'all' ,$scope.isUserWithoutDeviceEnabled);
        }
        if(type == 'restoreHistory'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateRestoreHistory($scope.current.from, $scope.current.to, $scope.current.userName, $scope.current.deviceName, skipValue);
        }
        if(type == 'restoreHistory'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateSyncCloudUsageDetails($scope.current.from, $scope.current.to);
        }
        if(type == 'longBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateLongBackup($scope.skipValue);
        }
        if(type == 'currentBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateCurrentBackup($scope.skipValue);
        }
        if(type == 'noBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateNoBackup($scope.skipValue, 7);
        }
        if(type == 'storageUtilized'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateStorageUtilized($scope.current.userName, $scope.current.deviceName, $scope.skipValue);
        }
        if(type == 'storageUtilizedByPG'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateStorageUtilizedByPG();
        }
        if(type == 'failedBackupByDate'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateFailedBackupByDate('', '', $scope.skipValue);
        }
        if(type == 'failedBackupByUserOrDevice'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateFailedBackupByUserOrDevice('', '', $scope.skipValue);
        }
        if(type == 'userMigration'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateUserMigration($scope.skipValue);
        }
    };

    $scope.updateSyncCLoudUsage = function(skipValue){
        $('.syncCLoudUsageError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/syncCLoudUsage',
            data: {skipValue: skipValue, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.syncCLoudUsage == null && $scope.syncCLoudUsage.length < 0){
                    $('.syncCLoudUsageError').show();
                    $('.syncCLoudUsage').hide();
                }else{
                    $('.syncCLoudUsageError').hide();
                    $('.syncCLoudUsage').show();
                }
                $scope.syncCLoudUsage = jData.syncCLoudUsage;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadOverview = function(userName, deviceName, policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           return;
        }
        if($scope.policy == 'true'){
        	policyName = policyName;
        	if($scope.all == 'all'){
        		policyName = 'all';
        	}
        }else{
        	policyName = 'all';
        }
        var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled").prop('checked');
        /*policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
            policyName.splice(i, 1);
        }*/
        var showBlockedUsers = $("#showBlockedUsers").prop('checked');
        $scope.showBlockedUsers=showBlockedUsers;

        var showBlockedDevices = $("#showBlockedDevices").prop('checked');
        $scope.showBlockedDevices=showBlockedDevices;
        //policyName = $('#searchPolicyName').val();
        //var userName = $('.searchUsername').val();
        //var deviceName = $('.searchDeviceName').val();
        if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }   
                    
          if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
		$scope.showBlockedDevices = $scope.showBlockedUsers;
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
	if(userName == "? undefined:undefined ?"){
            userName = "all";
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/overviewReport',
            data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName, policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled, showBlockedUsers: $scope.showBlockedUsers, showBlockedDevices: $scope.showBlockedDevices, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-12').removeClass('block-ui-active block-ui-visible');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		window.location.href = $scope.BASE_FOLDER+'/report/downloadOverViewReportToExcel';
               	toastr.success('Report generated', {allowHtml: true}); 
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-12').removeClass('block-ui-active block-ui-visible');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.saveEventHubCurrentBackup = function(userName, deviceUUID, action, key){
            var stopBackup = 'false';
            var pauseBackup = 'false';
            if(action == 'pause'){
                pauseBackup = 'true';
            }else{
                stopBackup = 'true';
            }            
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveEventHubCurrentBackup',
                data: {actionToDeviceUUID : deviceUUID, stopBackup : stopBackup, pauseBackup : pauseBackup},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
            if(action == 'pause'){ 
                $('#stop_'+key).hide();
                document.getElementById('pause_'+key).style.color="grey";
                document.getElementById('pause_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }else{ 
                $('#pause_'+key).hide();
                document.getElementById('stop_'+key).style.color="grey";
                document.getElementById('stop_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    $scope.saveEventHubCurrentBackupOneDrive = function(userName, deviceUUID, action, key){
            var stopBackup = 'false';
            var pauseBackup = 'false';
            if(action == 'pause'){
                pauseBackup = 'true';
            }else{
                stopBackup = 'true';
            }            
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveEventHubCurrentBackup',
                data: {actionToDeviceUUID : deviceUUID, stopBackup : stopBackup, pauseBackup : pauseBackup},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
            if(action == 'pause'){ 
                $('#stop_'+key).hide();
                document.getElementById('pause_'+key).style.color="grey";
                document.getElementById('pause_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }else{ 
                $('#pause_'+key).hide();
                document.getElementById('stop_'+key).style.color="grey";
                document.getElementById('stop_'+key).style.pointerEvents="none";
                toastr.success('Your request has been Queued.', 'Success!!!');
            }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    $scope.downloadNoBackupExcel = function(skipValue, numberOfDays,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if ($('#noOfDays').val() == ""){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
             return;
         }
         if (numberOfDays <= 0){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
         }
         if($scope.all == 'all'){
         policyName = 'all';
         }
         else{
         policyName = policyName;
         }
         $('.noBackupError').hide();
         $scope.skipValue = skipValue;
         /*if($('.selectPicker').selectpicker('val') == null){
             policyName = 'all';
         }else{
             policyName = $('.selectPicker').selectpicker('val');
             var i = policyName.indexOf("all");
             if(i != -1) {
                     policyName.splice(i, 1);
             }
         }
         policyName = $('#searchPolicyName').val();*/
         if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	 var numberOfDays = $('#noOfDays').val();
	 var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/noBackupExcel',
             data: {skipValue: skipValue, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadNobackupReportToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                 window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
 
 
     $scope.downloadRestoreHistoryExcel = function(from, to, userName, deviceName, skipValue,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
         toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
         $('.restoreError').show();
         $('.restoreHistory').hide();
            return;
         }
         if(userName.length <= 0 || userName == 'all'){
             userName = $('.searchUsername').val();
         }
         if(deviceName.length <= 0 || deviceName == 'all'){
             deviceName = $('.searchDeviceName').val();
         }
         $scope.policyName = policyName;
         if($scope.policy == 'true'){
         policyName = policyName;
         }
         else{
         policyName = 'all';
         }
         if($scope.all == 'all'){
         policyName = 'all';
         }
         else{
         policyName = policyName;
         }
         //policyName = $('.selectPicker').selectpicker('val');
         /*var i = policyName.indexOf("all");
         if(i != -1) {
         	policyName.splice(i, 1);
         }*/
         $scope.skipValue = skipValue;
         //policyName = $('#searchPolicyName').val();
         var from = $('#from').val();
         var to = $('#to').val();            
         from = getMeDate(from);
         to = getMeDate(to);
	 if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            //$('.userBackupHistoryError').show();
            //$('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
	if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/restoreHistoryReportExcel',
             data: {skipValue: skipValue,csrf_token: $('.csrf_token').html(), to: to, from: from, userName: userName, deviceName:deviceName,policyName:policyName, reportProductType: productType},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadRestoreHistoryReportToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
          }).fail(function(data){
	     myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
 
 
     $scope.downloadUserBackupHistoryExcel = function(userName, from, to,deviceName,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
         toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
         $('.userBackupHistoryError').show();
         $('.userBackupHistory').hide();
            return;
         }
         //var deviceName = $('.searchDeviceName').val();
        //var userName = $('.searchUsername').val();
         if(userName == undefined){
             userName = "null";
         }
         if(userName == "? undefined:undefined ?"){
            userName = "";
         }
         $scope.policyName = policyName;
         if($scope.policy == 'true'){
         policyName = policyName;
         }
         else{
         policyName = 'all';
         }
         if($scope.all == 'all'){
         policyName = 'all';
         }
         else{
         policyName = policyName;
         }
         $('.userBackupHistoryError').hide();
         $('.loading').show();
         /*policyName = $('.selectPicker').selectpicker('val');
         var i = policyName.indexOf("all");
         if(i != -1) {
                 policyName.splice(i, 1);
         }
         policyName = $('#searchPolicyName').val();*/
	 if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }   
            
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }
        if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() == 'policy'){
                var deviceName = '';
                var userName = '';
        }    
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
	if($('.reportProductType').html() == 'sharepoint' && $('input[name=userOption]:checked').val() != 'policy'){
                policyName = 'all';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            //$('.userBackupHistoryError').show();
            //$('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
         var from = $('#from').val();
         var to = $('#to').val();
         from = getMeDate(from);
         to = getMeDate(to);
	 if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/userBackupHistoryExcel',
             data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadBackupHistoryReportToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
             toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
 
     $scope.downloadFailedBackupExcel = function(from, to, skipValue,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
	 if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
            $('.failedBackupError').show();
            $('.failedBackup').hide();
            return;
         }
         var userName = $('.searchUsername').val();
         if(userName == "? undefined:undefined ?"){
             userName = "null";
         }
         var deviceName = $('.searchDeviceName').val();
 	 $scope.policyName = policyName;
 	 if($scope.policy == 'true'){
 	 	policyName = policyName;
 	 }else{
  	 	policyName = 'all';
  	 }
 	 if($scope.all == 'all'){
 	 	policyName = 'all';
 	 }else{
 	 	policyName = policyName;
 	 }
         $('.failedBackupError').hide();
         $('.loading').show();
         policyName = $('.selectPicker').selectpicker('val');
         var i = policyName.indexOf("all");
 	 if(i != -1) {
                 policyName.splice(i, 1);
         }
 	 policyName = $('#searchPolicyName').val();
 	 var from = $('#from').val();
 	 var to = $('#to').val();            
 	 from = getMeDate(from);
 	 to = getMeDate(to);
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/failedBackupReportExcel',
             data: {skipValue: skipValue, from: from, to: to,userName: userName, deviceName: deviceName,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html()},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadFailedBackupReportToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
          }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
     
    $scope.expandView = function(pageNumber, searchValue, backupType, productType){
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	if($('#collapse').hasClass('show')){
		$('#collapse').removeClass('show');
		$('.currentBackupText').removeClass('d-none');
		$('.aa').removeClass('d-none');
		$('.bb').removeClass('d-block');
	}
	$scope.productType = productType;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup',
            data: {pageNumber: pageNumber, csrf_token: $('.token').html(),searchValue: searchValue, backupType: backupType, type: 'BACKUP', productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$('.currentlyRunningbackups').modal('show');
                if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    $('.currentBackupError').show();
                    $('.currentBackuptable').hide();
                    $('.currentBackupnavigate').hide();
		    $('#bulkpausebackup').hide();
		    $('#bulkstopbackup').hide();
		    $scope.currentBackupE = [];
                }else{
                    $('.currentBackupError').hide();
                    $('.currentBackuptable').show();
                    $('.currentBackupnavigate').show();
		    if(jData.currentBackup.length > 1){
			$('#bulkpausebackup').show();
			$('#bulkstopbackup').show();
                    }else{
			$('#bulkpausebackup').hide();
			$('#bulkstopbackup').hide();
                    }		    
		    $scope.currentBackupE = jData.currentBackup;
		    if(jData.currentBackup.length > 20){
                        $('.currentBackupTableExpanded').css('overflowY', 'scroll');
                        $('.currentBackupTableExpanded').height('500px');
                    }
                }                  
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.expandViewNavigate = function(url){
	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup1',
            data: {url: url, csrf_token: $('.csrf_token').html(), productType:$scope.productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
		$('.currentlyRunningbackups').modal('show');
                if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    $('.currentBackupError').show();
                    $('.currentBackuptable').hide();
                    $('.currentBackupnavigate').hide();
		    $('#bulkpausebackup').hide();
		    $('#bulkstopbackup').hide();
                    $scope.currentBackupE = [];
                }else{
                    $('.currentBackupError').hide();
                    $('.currentBackuptable').show();
                    $('.currentBackupnavigate').show();
		    if(jData.currentBackup.length > 1){
			$('#bulkpausebackup').show();
			$('#bulkstopbackup').show();
                    }else{
			$('#bulkpausebackup').hide();
			$('#bulkstopbackup').hide();
                    }
                    $scope.currentBackupE = jData.currentBackup;
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.expandViewSharepoint = function(pageNumber, searchValue, backupType, productType){
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	if($('#collapseSharepoint').hasClass('show')){
		$('#collapseSharepoint').removeClass('show');
		$('.currentBackupTextSharepoint').removeClass('d-none');
		$('.aaSharepoint').removeClass('d-none');
		$('.bbSharepoint').removeClass('d-block');
	}
	$scope.productType = productType;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup',
            data: {pageNumber: pageNumber, csrf_token: $('.token').html(),searchValue: searchValue, backupType: backupType, type: 'SHAREPOINT', productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$('.currentlyRunningbackupsSharepoint').modal('show');
                if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    $('.currentBackupErrorSharepoint').show();
                    $('.currentBackupSharepointtable').hide();
                    $('.currentBackupSharepointnavigate').hide();
		    $('#bulkpausebackupSharepoint').hide();
		    $('#bulkstopbackupSharepoint').hide();
		    $scope.currentBackupE = [];
                }else{
                    $('.currentBackupErrorSharepoint').hide();
                    $('.currentBackupSharepointtable').show();
                    $('.currentBackupSharepointnavigate').show();
		    if(jData.currentBackup.length > 1){
			$('#bulkpausebackupSharepoint').show();
			$('#bulkstopbackupSharepoint').show();
                    }else{
			$('#bulkpausebackupSharepoint').hide();
			$('#bulkstopbackupSharepoint').hide();
                    }
		    $scope.currentBackupE = jData.currentBackup;
		    if(jData.currentBackup.length > 20){
                        $('.currentBackupSharepointTableExpanded').css('overflowY', 'scroll');
                        $('.currentBackupSharepointTableExpanded').height('500px');
                    }
                }                    
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.expandViewSharepointNavigate = function(url){
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup1',
            data: {url: url, csrf_token: $('.csrf_token').html(), productType:$scope.productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
                if(jData.currentBackup == null || jData.currentBackup.length == 0){
                    $('.currentBackupErrorSharepoint').show();
                    $('.currentBackupSharepoint').show();
		    $('#bulkpausebackupSharepoint').hide();
		    $('#bulkstopbackupSharepoint').hide();
                    $scope.currentBackupE = [];
                }else{
                    $('.currentBackupErrorSharepoint').hide();
                    $('.currentBackupSharepoint').show();
		    if(jData.currentBackup.length > 1){
			$('#bulkpausebackupSharepoint').show();
			$('#bulkstopbackupSharepoint').show();
                    }else{
			$('#bulkpausebackupSharepoint').hide();
			$('#bulkstopbackupSharepoint').hide();
                    }
                    $scope.currentBackupE = jData.currentBackup;
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };   
 
    /*pdf download start*/
    $scope.downloadUserBackupHistoryPdf = function(userName, from, to,deviceName,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
         toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
         $('.userBackupHistoryError').show();
         $('.userBackupHistory').hide();
            return;
         }
         //var deviceName = $('.searchDeviceName').val();
         //var userName = $('.searchUsername').val();
         if(userName == undefined){
             userName = "null";
         }
         if(userName == "? undefined:undefined ?"){
            userName = "";
         }
         $scope.policyName = policyName;
         if($scope.policy == 'true'){
         	policyName = policyName;
         }else{
         	policyName = 'all';
         }
         if($scope.all == 'all'){
         	policyName = 'all';
         }else{
         	policyName = policyName;
         }
         $('.userBackupHistoryError').hide();
         $('.loading').show();
         /*policyName = $('.selectPicker').selectpicker('val');
         var i = policyName.indexOf("all");
         if(i != -1) {
                 policyName.splice(i, 1);
         }
         policyName = $('#searchPolicyName').val();*/
	 if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }   
                    
          if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            //$('.userBackupHistoryError').show();
            //$('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
         var from = $('#from').val();
         var to = $('#to').val();
         from = getMeDate(from);
         to = getMeDate(to);
	 if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/userBackupHistoryPdf',
             data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadBackupHistoryReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
             toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
 	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
     
     $scope.downloadOverviewPdf = function(userName, deviceName, policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           return;
        }
	if($scope.policy == 'true'){
		policyName = policyName;
		if($scope.all == 'all'){
			policyName = 'all';
		}
	}else{
		policyName = 'all';
	}
	var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled").prop('checked');
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
            policyName.splice(i, 1);
        }
    	var showBlockedUsers = $("#showBlockedUsers").prop('checked');
    	$scope.showBlockedUsers=showBlockedUsers;

    	var showBlockedDevices = $("#showBlockedDevices").prop('checked');
    	$scope.showBlockedDevices=showBlockedDevices;
    	//policyName = $('#searchPolicyName').val();
    	//var userName = $('.searchUsername').val();
        //var deviceName = $('.searchDeviceName').val();
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }   
            
          if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
		$scope.showBlockedDevices = $scope.showBlockedUsers;
        }
        if(productType == undefined){
                productType = '';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
	if(userName == "? undefined:undefined ?"){
            userName = "all";
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/overviewReportPdf',
            data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), userName: userName, deviceName: deviceName, policyName:policyName ,isUserWithoutDeviceEnabled:isUserWithoutDeviceEnabled, showBlockedUsers: $scope.showBlockedUsers, showBlockedDevices: $scope.showBlockedDevices, reportProductType: productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-12').removeClass('block-ui-active block-ui-visible');		
	    $('.col-lg-12').removeClass('block-ui-overlay');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		window.location.href = $scope.BASE_FOLDER+'/report/downloadOverViewReportToPdf';
               toastr.success('Report generated', {allowHtml: true}); 
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-12').removeClass('block-ui-active block-ui-visible');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadFailedBackupPdf = function(from, to, skipValue,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
            $('.failedBackupError').show();
            $('.failedBackup').hide();
            return;
         }
         var userName = $('.searchUsername').val();
         if(userName == "? undefined:undefined ?"){
             userName = "null";
         }
         var deviceName = $('.searchDeviceName').val();
         $scope.policyName = policyName;
         if($scope.policy == 'true'){
         	policyName = policyName;
         }else{
         policyName = 'all';
         }
         if($scope.all == 'all'){
         	policyName = 'all';
         }else{
         	policyName = policyName;
         }
         $('.failedBackupError').hide();
         $('.loading').show();
         policyName = $('.selectPicker').selectpicker('val');
         var i = policyName.indexOf("all");
         if(i != -1) {
                 policyName.splice(i, 1);
         }
         policyName = $('#searchPolicyName').val();
         var from = $('#from').val();
         var to = $('#to').val();
        from = getMeDate(from);
        to = getMeDate(to);
         $.ajax({
              url: $scope.BASE_FOLDER+'/report/download/failedBackupReportPdf',
              data: {skipValue: skipValue, from: from, to: to,userName: userName, deviceName: deviceName,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html()},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadFailedBackupReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
          }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };

     $scope.downloadNoBackupPdf = function(skipValue, numberOfDays,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if ($('#noOfDays').val() == ""){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
             return;
         }
         if (numberOfDays <= 0){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
         }
         if($scope.all == 'all'){
         policyName = 'all';
         }
         else{
         policyName = policyName;
         }
         $('.noBackupError').hide();
         $scope.skipValue = skipValue;
         /*if($('.selectPicker').selectpicker('val') == null){
             policyName = 'all';
         }else{
             policyName = $('.selectPicker').selectpicker('val');
             var i = policyName.indexOf("all");
             if(i != -1) {
                     policyName.splice(i, 1);
             }
         }*/
	 if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                console.log("policyNameOOOOO : "+policyName);
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
         var numberOfDays = $('#noOfDays').val();
	 var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/noBackupPdf',
             data: {skipValue: skipValue, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadNobackupReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                 window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };


     $scope.downloadRestoreHistoryPdf = function(from, to, userName, deviceName, skipValue,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
         toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
         $('.restoreError').show();
         $('.restoreHistory').hide();
            return;
         }
         if(userName.length <= 0 || userName == 'all'){
             userName = $('.searchUsername').val();
         }
         if(deviceName.length <= 0 || deviceName == 'all'){
             deviceName = $('.searchDeviceName').val();
         }
         $scope.policyName = policyName;
         if($scope.policy == 'true'){
         	policyName = policyName;
         }else{
         	policyName = 'all';
         }
         if($scope.all == 'all'){
         	policyName = 'all';
         }else{
         	policyName = policyName;
         }
         //policyName = $('.selectPicker').selectpicker('val');
         /*var i = policyName.indexOf("all");
         if(i != -1) {
                 policyName.splice(i, 1);
         }*/
         $scope.skipValue = skipValue;
         //policyName = $('#searchPolicyName').val();
	 if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val()+' (Microsoft SharePoint)';
                var userName = $('.searchSitename').val();
        }

          if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            //$('.userBackupHistoryError').show();
            //$('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
         var from = $('#from').val();
         var to = $('#to').val();
         from = getMeDate(from);
         to = getMeDate(to);
	 if(userName == "? undefined:undefined ?"){
             //userName = "all";
             userName = "null";
         }
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/restoreHistoryReportPdf',
             data: {skipValue: skipValue,csrf_token: $('.csrf_token').html(), to: to, from: from, userName: userName, deviceName:deviceName,policyName:policyName, reportProductType: productType},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadRestoreHistoryReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
         }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };

     $scope.downloadDailyUserBackupOverviewPdf = function(userName, policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
        toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
           return;
        }
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
	policyName = $('#searchPolicyName').val();
	var userName = $('.searchUsername').val();
	var deviceName = $('.searchDeviceName').val();
	if(userName == "? undefined:undefined ?"){
            userName = "";
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverviewPdf',
            data: {userName: userName, deviceName: deviceName, policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverviewToPdf';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadAgentNotHeardReportPdf = function(number, policyName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }    
        var number = $('#noOfDays').val();
        if (number <= 0 || typeof number === 'undefined' || number === null ){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }
        policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadAgentNotHeardReportPdf',
            data: {number : number, policyName: policyName, reportProductType: $('.reportProductType').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadAgentNotHeardReportToPdf';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadUserBackupSummaryReportPdf = function(){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        /*if($scope.all == 'all'){
        	policyName = 'all';
        }else{
        	policyName = policyName;
        }*/    
        var number = $('#noOfDays').val();
        if (number <= 0 || typeof number === 'undefined' || number === null ){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                policyName.splice(i, 1);
            }
        }
        policyName = $('#searchPolicyName').val();*/
	if($('.reportProductType').html() == 'backup' || $('.reportProductType').html() == 'onedrive' || $('.reportProductType').html() == 'exchange'){
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        }
        if($('.reportProductType').html() == 'sharepoint'){
                var deviceName = $('.searchSitename').val();
                var userName = $('.searchSitename').val();
        }                 
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        if(productType == undefined){
                productType = '';
        }
        if(policyName == ''){
            toastr.error('Please select atleat one Policy.', 'Fail!!!', {allowHtml: true});
            $('.userBackupHistoryError').show();
            $('.userBackupHistory').hide();
                blockUI.stop();
            myBlockUI.stop();
           return;
        }
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadUserBackupSummaryReportPdf',
            data: {number : number, policyName: policyName, reportProductType: productType, includeDetails: $("#includeDetails").prop('checked')},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadUserBackupSummaryReportToPdf';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    /*pdf download end*/
    
    $scope.updateCurrentRestore = function(pageNumber, productType){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore',
            data: {pageNumber: pageNumber, csrf_token: $('.csrf_token').html(), productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(productType == 'backup'){
			if(jData.currentRestore == null){
                    		$('.currentRestoreError').show();
                    		$('.currentRestore').hide();
                    		$('.currentRestoreDiv').hide();
                	}else{
                    		$('.currentRestoreError').hide();
                    		$('.currentRestore').show();
                    		$('.currentRestoreDiv').show();
                	}
		}
		if(productType == 'ONEDRIVE'){
			if(jData.currentRestore == null){
                    		$('.currentRestoreErrorOnedrive').show();
                    		$('.currentRestoreOnedrive').hide();
                    		$('.currentRestoreDivOnedrive').hide();
                    		$('#expandRestoreStatementOnedrive').hide();
                	}else{
                    		$('.currentRestoreErrorOnedrive').hide();
                    		$('.currentRestoreOnedrive').show();
                    		$('.currentRestoreDivOnedrive').show();
                    		$('#expandRestoreStatementOnedrive').show();
                	}
		}
		if(productType == 'EXCHANGE'){
                        if(jData.currentRestore == null){
                    		$('.currentRestoreErrorExchange').show();
                    		$('.currentRestoreExchange').hide();
                    		$('.currentRestoreDivExchange').hide();
                    		$('#expandRestoreStatementExchange').hide();
                	}else{
                    		$('.currentRestoreErrorExchange').hide();
                    		$('.currentRestoreExchange').show();
                    		$('.currentRestoreDivExchange').show();
                    		$('#expandRestoreStatementExchange').show();
                	}
                }
		$scope.next = jData.metadata.links.next;
		if($scope.next){
			$('#expandRestoreStatement').show();
		}
 		$scope.currentRestore = jData.currentRestore;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateCurrentRestoreSharepoint = function(pageNumber, productType){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore',
            data: {pageNumber: pageNumber, csrf_token: $('.csrf_token').html(), productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.currentRestore == null){
                    $('.currentRestoreErrorSharepoint').show();
                    $('.currentRestoreSharepoint').hide();
                    $('.currentRestoreDivSharepoint').hide();
		    $('#expandRestoreStatementSharepoint').hide();
                }else{
                    $('.currentRestoreErrorSharepoint').hide();
                    $('.currentRestoreSharepoint').show();
                    $('.currentRestoreDivSharepoint').show();
		    $('#expandRestoreStatementSharepoint').show();
                }
                $scope.next = jData.metadata.links.next;
                if($scope.next){
			//document.getElementById("expandRestoreStatement").innerHTML = "Expand to view complete list of currently running restores.";
                }
                $scope.currentRestore = jData.currentRestore;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };  

    $scope.expandViewRestore = function(pageNumber, productType){
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	if(productType == 'backup'){
		if($('#collapserestore').hasClass('in')){
			$('#collapserestore').removeClass('in');
			$('.currentRestoreText').removeClass('hide');
			$('.aarestore').removeClass('hide');
			$('.bbrestore').removeClass('show');
		}
	}
	if(productType == 'ONEDRIVE'){
		if($('#collapserestoreOnedrive').hasClass('in')){
                	$('#collapserestoreOnedrive').removeClass('in');
                	$('.currentRestoreTextOnedrive').removeClass('hide');
                	$('.aarestoreOnedrive').removeClass('hide');
                	$('.bbrestoreOnedrive').removeClass('show');
        	}
	}
	if(productType == 'EXCHANGE'){
                if($('#collapserestoreExchange').hasClass('in')){
                        $('#collapserestoreExchange').removeClass('in');
                        $('.currentRestoreTextExchange').removeClass('hide');
                        $('.aarestoreExchange').removeClass('hide');
                        $('.bbrestoreExchange').removeClass('show');
                }
        }
	$scope.productType = productType;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore',
            data: {pageNumber: pageNumber, csrf_token: $('.csrf_token').html(), productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
        	$('.currentlyRunningrestores').modal('show');
		if(productType == 'backup'){
                	if(jData.currentRestore == null){
                    		$('.currentRestoreError').show();
                    		$('.currentRestoretable').hide();
                    		$('.currentRestorenavigate').hide();
		    		$('#bulkStopRestore').hide();
                    		$scope.currentRestoreE = [];
                	}else{
                    		$('.currentRestoreError').hide();
                    		$('.currentRestoretable').show();
                    		$('.currentRestorenavigate').show();
		    		if(jData.currentRestore.length > 1){
					$('#bulkStopRestore').show();
                    		}else{
					$('#bulkStopRestore').hide();
                    		}
                    		$scope.currentRestoreE = jData.currentRestore;
                	}
		}
		if(productType == 'ONEDRIVE'){
			if(jData.currentRestore == null){
                    		$('.currentRestoreError').show();
                    		$('.currentRestoreOnedrivetable').hide();
                    		$('.currentRestoreOnedrivenavigate').hide();
                    		$('#bulkStopRestoreOnedrive').hide();
                    		$scope.currentRestoreE = [];
                	}else{
                    		$('.currentRestoreError').hide();
                    		$('.currentRestoreOnedrivetable').show();
                    		$('.currentRestoreOnedrivenavigate').show();
                    		if(jData.currentRestore.length > 1){
                        		$('#bulkStopRestoreOnedrive').show();
                    		}else{
                        		$('#bulkStopRestoreOnedrive').hide();
                    		}
                    	$scope.currentRestoreE = jData.currentRestore;
                	}
		}
		if(productType == 'EXCHANGE'){
                        if(jData.currentRestore == null){
                                $('.currentRestoreError').show();
                                $('.currentRestoreExchangetable').hide();
                                $('.currentRestoreExchangenavigate').hide();
                                $('#bulkStopRestoreExchange').hide();
                                $scope.currentRestoreE = [];
                        }else{
                                $('.currentRestoreError').hide();
                                $('.currentRestoreExchangetable').show();
                                $('.currentRestoreExchangenavigate').show();
                                if(jData.currentRestore.length > 1){
                                        $('#bulkStopRestoreExchange').show();
                                }else{
                                        $('#bulkStopRestoreExchange').hide();
                                }
                        $scope.currentRestoreE = jData.currentRestore;
                        }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.expandViewRestoreSharepoint = function(pageNumber, productType){
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	if($('#collapserestoreSharepoint').hasClass('in')){
		$('#collapserestoreSharepoint').removeClass('in');
		$('.currentRestoreTextSharepoint').removeClass('hide');
		$('.aarestoreSharepoint').removeClass('hide');
		$('.bbrestoreSharepoint').removeClass('show');
	}
	$scope.productType = productType;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore',
            data: {pageNumber: pageNumber, csrf_token: $('.csrf_token').html(), productType:productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
        	$('.currentlyRunningrestoresSharepoint').modal('show');
                if(jData.currentRestore == null){
                    $('.currentRestoreErrorSharepoint').show();
                    $('.currentRestoreSharepointtable').hide();
                    $('.currentRestoreSharepointnavigate').hide();
		    $('#bulkStopRestoreSharepoint').hide();
                    $scope.currentRestoreE = [];
                }else{
                    $('.currentRestoreErrorSharepoint').hide();
                    $('.currentRestoreSharepointtable').show();
                    $('.currentRestoreSharepointnavigate').show();
		    if(jData.currentRestore.length > 1){
			$('#bulkStopRestoreSharepoint').show();
                    }else{
			$('#bulkStopRestoreSharepoint').hide();
                    }
                    $scope.currentRestoreE = jData.currentRestore;
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };  

    $scope.expandViewRestoreNavigate = function(url){
    	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore1',
            data: {url: url, csrf_token: $('.csrf_token').html(), productType:$scope.productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
		$('.currentlyRunningrestores').modal('show');
                if($scope.productType == 'backup'){
                        if(jData.currentRestore == null){
                                $('.currentRestoreError').show();
                                $('.currentRestoretable').hide();
                                $('.currentRestorenavigate').hide();
                                $('#bulkStopRestore').hide();
                                $scope.currentRestoreE = [];
                        }else{
                                $('.currentRestoreError').hide();
                                $('.currentRestoretable').show();
                                $('.currentRestorenavigate').show();
                                if(jData.currentRestore.length > 1){
                                        $('#bulkStopRestore').show();
                                }else{
                                        $('#bulkStopRestore').hide();
                                }
                                $scope.currentRestoreE = jData.currentRestore;
                        }
                }
                if($scope.productType == 'ONEDRIVE'){
                        if(jData.currentRestore == null){
                                $('.currentRestoreError').show();
                                $('.currentRestoreOnedrivetable').hide();
                                $('.currentRestoreOnedrivenavigate').hide();
                                $('#bulkStopRestoreOnedrive').hide();
                                $scope.currentRestoreE = [];
                        }else{
                                $('.currentRestoreError').hide();
                                $('.currentRestoreOnedrivetable').show();
                                $('.currentRestoreOnedrivenavigate').show();
                                if(jData.currentRestore.length > 1){
                                        $('#bulkStopRestoreOnedrive').show();
                                }else{
                                        $('#bulkStopRestoreOnedrive').hide();
                                }
                        $scope.currentRestoreE = jData.currentRestore;
                        }
                }
                if($scope.productType == 'EXCHANGE'){
                        if(jData.currentRestore == null){
                                $('.currentRestoreError').show();
                                $('.currentRestoreExchangetable').hide();
                                $('.currentRestoreExchangenavigate').hide();
                                $('#bulkStopRestoreExchange').hide();
                                $scope.currentRestoreE = [];
                        }else{
                                $('.currentRestoreError').hide();
                                $('.currentRestoreExchangetable').show();
                                $('.currentRestoreExchangenavigate').show();
                                if(jData.currentRestore.length > 1){
                                        $('#bulkStopRestoreExchange').show();
                                }else{
                                        $('#bulkStopRestoreExchange').hide();
                                }
                        $scope.currentRestoreE = jData.currentRestore;
                        }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.expandViewRestoreNavigateSharepoint = function(url){
    	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentRestore1',
            data: {url: url, csrf_token: $('.csrf_token').html(), productType:$scope.productType},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
		$('.currentlyRunningrestoresSharepoint').modal('show');                
                if(jData.currentRestore == null){
                    $('.currentRestoreErrorSharepoint').show();
                    $('.currentRestoreSharepointtable').hide();
                    $('.currentRestoreSharepointnavigate').hide();
		    $('#bulkStopRestoreSharepoint').hide();
                    $scope.currentRestoreE = [];
                }else{
                    $('.currentRestoreErrorSharepoint').hide();
                    $('.currentRestoreSharepointtable').show();
                    $('.currentRestoreSharepointnavigate').show();
		    if(jData.currentRestore.length > 1){
			$('#bulkStopRestoreSharepoint').show();
                    }else{
			$('#bulkStopRestoreSharepoint').hide();
                    }
                    $scope.currentRestoreE = jData.currentRestore;
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };  
    
    /*userswithout devices start*/
    $scope.usersWithoutDevicesView = function(policyName){
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
    	$('.first').hide();
    	$('.previous').hide();
    	$('.next').hide();
    	$('.last').hide();
    	var pageNumber = $scope.pageNumber;
    	var showBlockedDevices = $("#showBlockedDevices").prop('checked');
    	$scope.showBlockedDevices=showBlockedDevices;
    	policyName = $('#searchPolicyName').val();
    	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/usersWithoutDevicesView',
            data: {policyName: policyName, csrf_token: $('.csrf_token').html(), pageNumber:pageNumber,showBlockedDevices : showBlockedDevices, productTypeReport: $('#productTypeReport').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.usersWithoutDevices.length > 0){
                    $('.nousersWithoutDevices').hide();
                    $('.usersWithoutDevices').show();
                }else{
                    $('.nousersWithoutDevices').show();
                    $('.usersWithoutDevices').hide();
                }
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                $scope.usersWithoutDevices = jData.usersWithoutDevices;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.usersWithoutDevicesViewNavigate = function(policyName,url){
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    
    	var showBlockedDevices = $("#showBlockedDevices").prop('checked');
    	$scope.showBlockedDevices=showBlockedDevices;
    	policyName = $('#searchPolicyName').val();
    	blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/usersWithoutDevicesView1',
            data: {policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, showBlockedDevices: showBlockedDevices, productTypeReport: $('#productTypeReport').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.usersWithoutDevices.length > 0){
                    $('.nousersWithoutDevices').hide();
                    $('.usersWithoutDevices').show();
                }else{
                    $('.nousersWithoutDevices').show();
                    $('.usersWithoutDevices').hide();
                }
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}else{
			$('.first').hide();
		}
		if($scope.previous){
			$('.previous').show();
		}else{
			$('.previous').hide();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}else{
			$('.last').hide();
		}
                $scope.usersWithoutDevices = jData.usersWithoutDevices;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadUsersWithoutDevicesExcel = function(policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        var showBlockedDevices = $("#showBlockedDevices").prop('checked');
        $scope.showBlockedDevices=showBlockedDevices;
        policyName = $('#searchPolicyName').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/downloadUsersWithoutDevices',
            data: {csrf_token: $('.csrf_token').html() , policyName : policyName,showBlockedDevices : showBlockedDevices, productTypeReport: $('#productTypeReport').val()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');	    
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/downloadUsersWithoutDevicesExcel';
                toastr.success('Users without active devices list generated successfully', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');	    
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    /*users without devices end*/

    $scope.redirectTo = function(url){
        window.location = url;
    };

    $scope.redirectToDownload = function(url, to, from){
        window.location = url+'?toDate='+encodeURIComponent(to)+'&fromDate='+encodeURIComponent(from);
    };
    
    $('#product').selectpicker();
    $('#product').on('change', function(){
        var type = $('#product').val();
        if(type == 'BluVault'){
		$('.onedriveSection').addClass('hide');
		$('.bluvaultSection').removeClass('hide');
		$('.AgentHeartBeatReport').removeClass('hide');
        }else if(type == 'OneDrive'){
		$scope.updateStatisticsOneDrive();
		$('.AgentHeartBeatReport').addClass('hide');
		$('.bluvaultSection').addClass('hide');
		$('.onedriveSection').removeClass('hide');
        }else{
        }
    });
    
    /*report schedule start*/
    
    $('#searchPolicyName1').selectpicker().change(function(){toggleSelectAll($(this));}).trigger('change');

    $("input:radio").change(function () {
        $('#searchPolicyName1').selectpicker('render');
        $('#policyName1').find('option[value="all"]').prop("selected",true);
        var val = $('input[name=userOption]:checked').val();
        if(val == 'policy'){
            $scope.policy = 'true';
            $scope.userNdDevice = 'false';
            $('#searchPolicyName1').selectpicker('val', 'all');
            $(".searchUsername1").select2("val", "all");
            $(".searchUsername1").find('option[value="all"]').prop("selected",true);
            $('.searchDeviceName1').val('');
        }else{
            $('#searchPolicyName1').selectpicker('val', 'all');
            $('#searchPolicyName1').find('option[value="all"]').prop("selected",true);
            $('.searchDeviceName1').val('');
            $scope.policy = 'false';
            $scope.userNdDevice = 'true';
        }
    });
    
    /*month start*/
    $scope.toggleSelectPickerAllMonths = function(){
        if($('.selectPickerScheduleMonth').selectpicker('val') != null){
            if($('.selectPickerScheduleMonth').selectpicker('val').length == 12){
                $('.monthDaily').html('Every Month');
                $('.selectPickerScheduleMonth').selectpicker('deselectAll');
            }else{
                $('.monthDaily').html('De-Select All');
                $('.selectPickerScheduleMonth').selectpicker('selectAll');
            }
        }else{
            $('.monthDaily').html('De-Select All');
            $('.selectPickerScheduleMonth').selectpicker('selectAll');
        }
    $('.selectPickerScheduleMonth').selectpicker('refresh');
    };

    $('.selectPickerScheduleMonth').on('change', function(){
        toggleSelectPickerMonth();
    });

    function toggleSelectPickerMonth(){
        if($('.selectPickerScheduleMonth').selectpicker('val') != null){
            if($('.selectPickerScheduleMonth').selectpicker('val').length == 7){
                $('.monthDaily').html('De Select All');
            }else{
                $('.monthDaily').html('Every Month');
            }
        }else{
            $('.monthDaily').html('Every Month');
        }
    }
    /*month end*/

    $scope.schedule = function(trigger){
	$scope.trigger = trigger;
        $('#scheduleModalList').modal('show');
        $scope.usersMailId();
        $scope.getSchedules(trigger);        
    };

    $scope.toggleSelectPickerAll = function(){
        if($('.selectPickerSchedule').selectpicker('val') != null){
            if($('.selectPickerSchedule').selectpicker('val').length == 7){
                $('.scheduleDaily').html('Every Day');
                $('.selectPickerSchedule').selectpicker('deselectAll');
            }else{
                $('.scheduleDaily').html('De-Select All');
                $('.selectPickerSchedule').selectpicker('selectAll');
            }
    $('.selectPickerSchedule').selectpicker('refresh');
        }else{
            $('.scheduleDaily').html('De-Select All');
            $('.selectPickerSchedule').selectpicker('selectAll');
        }
    };

    $('.selectPickerSchedule').on('change', function(){
        toggleSelectPicker();
    });

    function toggleSelectPicker(){
        if($('.selectPickerSchedule').selectpicker('val') != null){
            if($('.selectPickerSchedule').selectpicker('val').length == 7){
                $('.scheduleDaily').html('De Select All');
            }else{
                $('.scheduleDaily').html('Every Day');
            }
        }else{
            $('.scheduleDaily').html('Every Day');
        }
    }

    //new exp start

    $scope.users = [];

    $scope.usersMailId = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/usersMailId',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.users.length >= 1){
                    $('.usersFound').show();
                    $('.noUsers').hide();
                }else{
                    $('.usersFound').hide();
                    $('.noUsers').show();
                }
                $scope.users = jData.users;
                if(jData.users.length > 10){
                    $('.usersTable').scroll();
                    $('.usersTable').height('200px');
                }
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.itemSelect = function(vall){
        var all = $("input.select-all")[0];
        var total = $("input.select-item").length;
        var len = $("input.select-item:checked:checked").length;
        all.checked = len===total;
        var usersSelected;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
        }).get();
        usersSelected = arr;
        var xx = $('#selectedUsers').val();
        if(xx.includes(vall) ){
        	var ary = xx.split(',');
        	ary.splice(ary.indexOf(vall),1)
        	var result = ary;
        	usersSelected = result;
        }else{
        	var usersSelected = usersSelected.concat($('#selectedUsers').val());
        }
        $('.selectedUsers').tagsinput('removeAll');
        $('.selectedUsers').tagsinput('add', usersSelected.join());
    };
    
    function appendLeadingZeroes(n){
      if(n <= 9){
        return "0" + n;
      }
      return n
    }
    
    $scope.createSchedule = function(){
        $scope.id = '';
        $('#createScheduleModal').modal('show');
        $('#scheduleName').removeAttr("readonly");
        $('#scheduleName').val('');
        $('.selectedUsers').tagsinput('removeAll');
	if(document.getElementById("policy1") || document.getElementById("userNdDevice1")){
		$('input:radio[name="userOption1"][value="policy"]').prop('checked', true);
		//var policyBlock = document.getElementById("policy1");
		if($('.reportProductType').html() == 'backup'){
                        var policyBlock = document.getElementById("policy1");
                    }
                    if($('.reportProductType').html() == 'onedrive'){
                        var policyBlock = document.getElementById("searchODBPolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'exchange'){
                        var policyBlock = document.getElementById("searchExchangePolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'sharepoint'){
                        var policyBlock = document.getElementById("searchSharepointPolicyNameBlock1");
                    }
		var userNdDeviceBlock = document.getElementById("userNdDevice1");
		policyBlock.style.display = "block";
		userNdDeviceBlock.style.display = "none";
	}
        $('.displayinfo').hide();
        $('#searchPolicyName1').selectpicker('val', 'all');
        $('#showBlockedUsers1').attr('checked', 'checked');
        $('#showBlockedDevices1').attr('checked', 'checked');
        $('.choiceDays').show();
        $('.choiceMonths').hide();
        $('.choiceTime').hide();
        $('#days').prop('disabled', false);
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#dayOfMonth').val('');
        $('.selectPickerMonth').selectpicker('val', '');
        $('#months').prop('disabled', true);
        $('#scheduleType').find('option[value="choiceDays"]').prop("selected",true);
        $('.selectPickerSchedule').selectpicker('val', '');
        $('#scheduleStartTime').timepicker('setTime', '9:45');
        document.getElementById('allAdmins').checked=false;
        $("[name*='select-item']").css('pointer-events','auto');
        $("[name*='select-item']").css('opacity','1');
        $("[class*='emailId-item']").css('pointer-events','auto');
        $("[class*='emailId-item']").css('opacity','1');
        $('.scheduleDaily').html('Every Day');
        $('.selectPickerSchedule').selectpicker('deselectAll');
        $('#createdBy').val('');
        $('.monthDaily').html('Every Month');
        $('.selectPickerScheduleMonth').selectpicker('deselectAll');
        $('#days').attr('required', 'required');
        $('#months').removeAttr('required');
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
        document.getElementById("months").disabled=true;
        $scope.users.forEach(function(value2){
        	value2.isCheck = 'no';
        });
    };  
        
   $scope.getSchedule = function(id){
        $scope.id = id;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/getSchedule',
            data: {csrf_token: $('.csrf_token').html(), id: id},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $('#createScheduleModal').modal('show');
            $scope.schedulerData = jData.schedulerData;
            $('#scheduleName').val(jData.schedulerData.displayName);
            $('#scheduleName').attr("readonly","readonly");
            $('#createdBy').val(jData.schedulerData.createdBy);
            $('.selectedUsers').tagsinput('removeAll');
            if(jData.schedulerData.userWithoutDeviceEnabled == true){
                $('#isUserWithoutDeviceEnabled1').attr('checked', 'checked');
            }
            if(jData.schedulerData.showBlockedUsers == true){
                $('#showBlockedUsers1').attr('checked', 'checked');
            }else{
                $('#showBlockedUsers1').removeAttr('checked');
            }
            if(jData.schedulerData.showBlockedDevices == true){
                $('#showBlockedDevices1').attr('checked', 'checked');
            }else{
                $('#showBlockedDevices1').removeAttr('checked');
            }
	    if(jData.schedulerData.includeDetails == true){
                $('#includeDetails1').attr('checked', 'checked');
            }else{
                $('#includeDetails1').removeAttr('checked');
            }
            if(jData.schedulerData.startDate){
            	function appendLeadingZeroes(n){
            		if(n <= 9){
            			return "0" + n;
            		}
            		return n
            	}
            	var months = ["Jan", "Feb", "Mar","Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            	var date = jData.schedulerData.startDate;
            	var datearray = date.split("/");
            	var ne = datearray[0] + '/' + datearray[1] + '/' + datearray[2];
            	var current_datetime = new Date(ne)
            	var formatted_date = appendLeadingZeroes(current_datetime.getDate()) + "-" + months[current_datetime.getMonth()] + "-" + current_datetime.getFullYear();
            	$('#from1').val(formatted_date);
            }
            if(jData.schedulerData.endDate){
            	function appendLeadingZeroes(n){
            		if(n <= 9){
            			return "0" + n;
            		}
            		return n
            	}
            	var months = ["Jan", "Feb", "Mar","Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            	var date = jData.schedulerData.endDate;
            	var datearray = date.split("/");
            	var ne = datearray[0] + '/' + datearray[1] + '/' + datearray[2];
            	var current_datetime = new Date(ne)
            	var formatted_date = appendLeadingZeroes(current_datetime.getDate()) + "-" + months[current_datetime.getMonth()] + "-" + current_datetime.getFullYear();
            	$('#to1').val(formatted_date);
            }
            if ($('input:radio[name="userOption1"]').length > 0){       
                //var policyBlock = document.getElementById("policy1");
		if($('.reportProductType').html() == 'backup'){
                        var policyBlock = document.getElementById("policy1");
                    }
                    if($('.reportProductType').html() == 'onedrive'){
                        var policyBlock = document.getElementById("searchODBPolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'exchange'){
                        var policyBlock = document.getElementById("searchExchangePolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'sharepoint'){
                        var policyBlock = document.getElementById("searchSharepointPolicyNameBlock1");
                    }
                var userNdDeviceBlock = document.getElementById("userNdDevice1");
                //if(jData.schedulerData.policyNames.length > 0 && jData.schedulerData.userName == '' && jData.schedulerData.deviceName == ''){
		if(jData.schedulerData.userName == '' && jData.schedulerData.deviceName == ''){
                    $('input:radio[name="userOption1"][value="policy"]').prop('checked', true);
                    policyBlock.style.display = "block";
                    userNdDeviceBlock.style.display = "none";
                    $scope.displayinfo = 'no';
                    $('.displayinfo').hide();
                    $('.optionss').show();
                    document.getElementById("displayusername").innerHTML = jData.schedulerData.userName;
                    document.getElementById("displaydevicename").innerHTML = jData.schedulerData.deviceName;
                }else if(jData.schedulerData.userName != '' || jData.schedulerData.deviceName != ''){
                    $('input:radio[name="userOption1"][value="userNdDevice"]').prop('checked', true);
                    policyBlock.style.display = "none";
                    userNdDeviceBlock.style.display = "block";
                    $scope.displayinfo = 'yes';
                    //$('.displayinfo').show();
                    $('.optionss').hide();
                    $('.displayinfo').hide();
                    if(jData.schedulerData.userName == ''){
                        document.getElementById("displayusername").innerHTML = 'all';
                    }else{
                        document.getElementById("displayusername").innerHTML = jData.schedulerData.userName;
                    }
                    if(jData.schedulerData.deviceName == ''){
                        document.getElementById("displaydevicename").innerHTML = 'all';
                    }else{
                        document.getElementById("displaydevicename").innerHTML = jData.schedulerData.deviceName;
                    }
                /*ssssss*/
                    var use = jData.schedulerData.userName;
                    if(jData.schedulerData.deviceName != ''){
                    var dev = jData.schedulerData.deviceName;
                }else{
                    var dev = 'all';
                }
                $('#searchUsername1').trigger("change");
                $('#searchUsername1').empty().append($("<option/>").val(use).text(use)).val(use).trigger("change");
                $('#searchDeviceName1').removeAttr("readonly", "readonly");
                setTimeout(function(){
                	$('#searchDeviceName1').append($("<option/>").val(dev).text(dev)).val(dev);
                }, 100);
                document.getElementById("displayusername").innerHTML = use;
                document.getElementById("displaydevicename").innerHTML = dev;
                /*eeeeee*/
                }
            }
            if(jData.schedulerData.policyNames.length <= 0){    
                $('#searchPolicyName1').selectpicker('val', 'all');
            }else{  
                //$('#searchPolicyName1').selectpicker('val', jData.schedulerData.policyNames);
		if($('.reportProductType').html() == 'backup'){
                        $('#searchPolicyName1').selectpicker('val', jData.schedulerData.policyNames);
                }
                if($('.reportProductType').html() == 'onedrive'){
                        $('#searchODBPolicyName1').selectpicker('val', jData.schedulerData.policyNames);
                }
                if($('.reportProductType').html() == 'exchange'){
                        $('#searchExchangePolicyName1').selectpicker('val', jData.schedulerData.policyNames);
                }
                if($('.reportProductType').html() == 'sharepoint'){
                        $('#searchSharepointPolicyName1').selectpicker('val', jData.schedulerData.policyNames);
                }
            }
	    if(jData.schedulerData.miniCloudList.length <= 0){
                $('#minicloudName1').selectpicker('val', 'all');
            }else{
                var mini = jData.schedulerData.miniCloudList.split (", ");
                $('#minicloudName1').selectpicker('val', mini);
            }
            $('#noOfDays1').val(jData.schedulerData.noOfDays);
            $('.selectPickerSchedule').selectpicker('val', jData.days);
            if(jData.schedulerData.days == null || jData.schedulerData.days == ''){
                if(jData.schedulerData.months == null || jData.schedulerData.months == ''){
                    $("#choiceTime").prop("checked", true);
                    $('#scheduleType').find('option[value="choiceTime"]').prop("selected",true);
                    $('.choiceTime').show();
                    $('.choiceDays').hide();
                    $('.choiceMonths').hide();
                    $('#date').attr('disabled', false);
                    $('#date').val(jData.schedulerData.date);
                    function appendLeadingZeroes(n){
                    	if(n <= 9){
                    		return "0" + n;
                    	}
                    	return n
                    }
                    var months = ["Jan", "Feb", "Mar","Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                    var date = jData.schedulerData.date;
                    var datearray = date.split("/");
                    var ne = datearray[0] + '/' + datearray[1] + '/' + datearray[2];
                    var current_datetime = new Date(ne)
                    var formatted_date = appendLeadingZeroes(current_datetime.getDate()) + "-" + months[current_datetime.getMonth()] + "-" + current_datetime.getFullYear();                $('#date').val(formatted_date);
                    $('#months').prop('disabled', true);
                    $('.selectPickerScheduleMonth').selectpicker('val', '');
                    $('.selectPickerSchedule').selectpicker('val', '');
                    $('#days').prop('disabled', true);
                    $('#dayOfMonth').prop('disabled', true);
                    $('#dayOfMonth').val('');
                    $('#days').removeAttr('required');
                    $('#months').removeAttr('required');
                }else{
                    console.log("fresh11");
                    $("#choiceMonths").prop("checked", true);
                    $('#scheduleType').find('option[value="choiceMonths"]').prop("selected",true);
                    $('.choiceMonths').show();
                    $('.choiceDays').hide();
                    $('.choiceTime').hide();
                    $('#dayOfMonth').prop('disabled', false);
                    $('#dayOfMonth').val(jData.schedulerData.dayOfMonth);
                    $('#months').prop('disabled', false);
                    $('.selectPickerScheduleMonth').selectpicker('val', jData.schedulerData.months);
                    $('.selectPickerSchedule').selectpicker('val', '');
                    $('#days').removeAttr('required');
                        $('#days').prop('disabled', true);
                    $('#date').datepicker('update', '');
                    $('#date').attr('disabled', true);
                }
            }else{
                if(jData.schedulerData.months == null || jData.schedulerData.months == ''){
                    $("#choiceDays").prop("checked", true);
                    $('#scheduleType').find('option[value="choiceDays"]').prop("selected",true);
                    $('.choiceDays').show();
                    $('.choiceMonths').hide();
                    $('.choiceTime').hide();
                    $('#days').prop('disabled', false);
                    $('.selectPickerSchedule').selectpicker('val', jData.days);
                    $('#date').datepicker('update', '');
                    $('#date').attr('disabled', true);
                    $('#dayOfMonth').val('');
                    $('.selectPickerMonth').selectpicker('val', '');
                    $('#months').prop('disabled', true);
                }else{
                    console.log("non empty");
                    $("#choiceDays").prop("checked", true);
                    $('#scheduleType').find('option[value="choiceDays"]').prop("selected",true);
                    $('.choiceDays').show();
                    $('.choiceMonths').hide();
                    $('.choiceTime').hide();
                    $('#days').prop('disabled', false);
                    $('#date').datepicker('update', '');
                    $('#date').attr('disabled', true);
                }
            }
            $('#scheduleStartTime').timepicker('setTime', jData.schedulerData.time);
            if(jData.schedulerData.allAdmins == 'true'){
            	document.getElementById('allAdmins').checked=true;
            	$("[name*='select-item']").css('pointer-events','none');
            	$("[name*='select-item']").css('opacity','0.19');
            	$("[class*='emailId-item']").css('pointer-events','none');
            	$("[class*='emailId-item']").css('opacity','0.19');
            	$('.selectedUsers').tagsinput('add', 'All admins');
            }else{
            	document.getElementById('allAdmins').checked=false;
            	$("[name*='select-item']").css('pointer-events','auto');
            	$("[name*='select-item']").css('opacity','1');
            	$("[class*='emailId-item']").css('pointer-events','auto');
            	$("[class*='emailId-item']").css('opacity','1');
            	jData.schedulerData.emailIds.forEach(function(value){
			$scope.users.forEach(function(value2){
				if(value2.emailId == value){
				    $scope.isCheck == 'yes';
				    value2.isCheck = 'yes';
				    $scope.$apply();
				}
			});
            		$('#selectedUsers').tagsinput('add', value);
            	});
            }
            toggleSelectPicker();
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $("#allAdmins").click(function(){
        if ($(this).is(':checked')) {
        $("[name*='select-item']").attr('disabled');
        $("[name*='emailId-item']").attr('disabled');
        $("[name*='select-item']").css('pointer-events','none');
        $("[name*='select-item']").css('opacity','0.19');
        $("[class*='emailId-item']").css('pointer-events','none');
        $("[class*='emailId-item']").css('opacity','0.19');
        $('.selectedUsers').tagsinput('removeAll');
        $('.selectedUsers').tagsinput('add', 'All admins');
        $("[name*='select-item']").each(function (index,item) {
                    item.checked = !item.checked;
                });
        }else{
        $("[name*='select-item']").css('pointer-events','auto');
        $("[name*='select-item']").css('opacity','1');
        $("[class*='emailId-item']").css('pointer-events','auto');
        $("[class*='emailId-item']").css('opacity','1');
        $('.selectedUsers').tagsinput('removeAll');
        $("input.select-item").each(function (index,item) {
                    item.checked = false;
                });
        }
    });
    
    $scope.confirmChange = function(){
        var user = $('#searchUsername1').val();
        var device = $('#searchDeviceName1').val();
        document.getElementById("displayusername").innerHTML = user;
        document.getElementById("displaydevicename").innerHTML = device;
        $('.confirmChange').modal('hide');
    };

    $scope.getSchedules = function(trigger){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/getSchedules',
            data: {csrf_token: $('.csrf_token').html(),trigger:trigger},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $scope.schedules = jData.schedules;
            if(jData.schedules.length >= 1){
            	$('.schedulesFound').show();
            	$('.schedulesNotFound').hide();
            }else{
            $('.schedulesFound').hide();
            	$('#scheduleModalList').modal('hide');
                $('#createScheduleModal').modal('show');
            }
            if($scope.currentPage == 'lastAgentServerConnectionDetails' || $scope.currentPage == 'noBackup' || $scope.currentPage == 'userBackupSummary'){
                $('#searchPolicyName1').selectpicker('val', $('#searchPolicyName').val());
            }
            if($("input[name=userOption]").length > 0 ){
		    var val = $('input[name=userOption]:checked').val();
		    var use = '';
		    var dev = '';
		    //var policyBlock = document.getElementById("policy1");
		    if($('.reportProductType').html() == 'backup'){
                        var policyBlock = document.getElementById("policy1");
                    }
                    if($('.reportProductType').html() == 'onedrive'){
                        var policyBlock = document.getElementById("searchODBPolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'exchange'){
                        var policyBlock = document.getElementById("searchExchangePolicyNameBlock1");
                    }
                    if($('.reportProductType').html() == 'sharepoint'){
                        var policyBlock = document.getElementById("searchSharepointPolicyNameBlock1");
                    }
		    var userNdDeviceBlock = document.getElementById("userNdDevice1");
		    if(val == 'policy') {
			$('input:radio[name="userOption1"][value="policy"]').prop('checked', true);
			policyBlock.style.display = "block";
			userNdDeviceBlock.style.display = "none";
			$('#searchPolicyName1').selectpicker('val', $('#searchPolicyName').val());
		    }else{
			$('input:radio[name="userOption1"][value="userNdDevice"]').prop('checked', true);
			policyBlock.style.display = "none";
			userNdDeviceBlock.style.display = "block";
			var use = $('#searchUsername').val();
			//console.log("aabbcc : "+use);
			$('#searchUsername1').trigger("change");
			$('#searchUsername1').empty().append($("<option/>").val(use).text(use)).val(use).trigger("change");
			var dev = $('#searchDeviceName').val();
			//console.log("defff : "+dev);
			$('#searchDeviceName1').removeAttr("readonly", "readonly");
			setTimeout(function(){
			    $('#searchDeviceName1').append($("<option/>").val(dev).text(dev)).val(dev);
			}, 3000);
			document.getElementById("displayusername").innerHTML = use;
			document.getElementById("displaydevicename").innerHTML = dev;
		    }
            }
            var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled").prop('checked');
            var showBlockedUsers = $("#showBlockedUsers").prop('checked');
            var showBlockedDevices = $("#showBlockedDevices").prop('checked');
            if(isUserWithoutDeviceEnabled == true){
                        $('#isUserWithoutDeviceEnabled1').attr('checked', 'checked');
            }
            if(showBlockedUsers == true){
                        $('#showBlockedUsers1').attr('checked', 'checked');
            }else{
                        $('#showBlockedUsers1').removeAttr('checked');
            }
            if(showBlockedDevices == true){
                        $('#showBlockedDevices1').attr('checked', 'checked');
            }else{
                        $('#showBlockedDevices1').removeAttr('checked');
            }
            $('#searchUsername1').val($('#userName').val());
            $('#searchDeviceName1').val($('#deviceName').val());
            var from = $('#from').val();
            var to = $('#to').val();
            $('#from1').val(from);
            $('#to1').val(to);
            from = new Date(from);
            to = new Date(to);
            from = from.toLocaleDateString();
            to = to.toLocaleDateString();
            $('#noOfDays1').val($('#noOfDays').val());        
            $scope.$apply();
    }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.deleteScheduleConfirm = function(id, name){
    	$('.confirmdelete').modal('show');
        $scope.schId = id;
   	$scope.schName = name;
    };

    $scope.deleteSchedule = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deleteSchedule',
            data: {csrf_token: $('.csrf_token').html(), trigger: $scope.trigger, id: $scope.schId, scheduleName: $scope.schName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $('.confirmdelete').modal('hide');
            toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
            $scope.getSchedules($scope.trigger);
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    function addCurrentOwner() {
    	$('#mailId').val(null);
    	$('#mailId').trigger("change");
    	var miniClouds = $('#ownerFor').html().split(',');
    	miniClouds.forEach(function(value){
		if(value.length > 0){
			$('#mailId').append($('<option>', {
			    value: value,
			    text: value
			}));
		    }
        });
    	$('#mailId').trigger("change");
    }
    
    function isSpecialCharForSchedule(val) {
        var tr = $.trim(val).length;
        var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="scheduleName"]').popover('show');
                    return false;
                }
                else{
                    $('[name="scheduleName"]').popover('hide');
                    return true;
                }
    }   

    $scope.saveSchedule = function(userName,policyName){
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
	if($('#searchPolicyName1').val() == ''){
                toastr.error('Please select atleast one policy. ', {allowHtml: true});
                return;
        }
        var days = '';
        var time = $('#scheduleStartTime').val();
        var mailid = $('#selectedUsers').val();
        var months = $('#months').val();
        var dayOfMonth = $('#dayOfMonth').val();
        var date = '';
        var choice = $('#scheduleType').val();
        if(choice == 'choiceDays'){
        	date = '';
        	date = '';
        	days = $('#days').val();
        	months = [];
        	dayOfMonth = '';
        }
        if(choice == 'choiceTime'){
        	date = $('#date').val();
        	date = getMeDate(date);             
        	days = '';
        	months = [];
        	dayOfMonth = '';
		if($('#date').val() == ''){
                        toastr.error('Please add date for schedule. ', {allowHtml: true});
                        return;
                }
        }
        if(choice == 'choiceMonths'){
        	date = '';
        	days = '';
        }
        var scheduleName = $('#scheduleName').val();
        if(isSpecialCharForSchedule(scheduleName) == false){
            $('[name="scheduleName"]').addClass('parsley-error');
            return;
        }
        var id = '';
        if($scope.id != ''){
        	id = $scope.id;
        }else{
        	id = '';
        }
        var noOfDays;
        if($("#noOfDays1").length > 0){
        	noOfDays = $('#noOfDays1').val();
        }else{
        	noOfDays = '';
        }
        var val = $('input[name=userOption1]:checked').val();
        var userName = '';
        var deviceName = '';
        if(val == 'policy'){
        	userName = '';
        	deviceName = '';
        }else{
        	userName = $('#displayusername').html();
        	deviceName = $('#displaydevicename').html();        
        }    
        var isUserWithoutDeviceEnabled = $("#isUserWithoutDeviceEnabled1").prop('checked');
        var showBlockedUsers = $("#showBlockedUsers1").prop('checked');
        var showBlockedDevices = $("#showBlockedDevices1").prop('checked');
	if($('.reportProductType').html() == 'sharepoint'){
                showBlockedDevices = showBlockedUsers;
        }
        var startDate;
        var endDate;
        var reason;
        if($scope.currentPage == 'overview' || $scope.currentPage == 'userBackupHistory' || $scope.currentPage == 'restoreByDate' || $scope.currentPage == 'noBackup' || $scope.currentPage == 'usersNoBackup' || $scope.currentPage == 'dailyUserBackupOverview' || $scope.currentPage == 'lastAgentServerConnectionDetails' || $scope.currentPage == 'userBackupSummary'  || $scope.currentPage == 'incompleteBackup'|| $scope.currentPage == 'minicloudActivityHistory'){
        	startDate = '';
        	endDate = '';
        }else{
                startDate = $('#from1').val();
                endDate = $('#to1').val();
                startDate = getMeDate(startDate);
                endDate = getMeDate(endDate);
        }
        if($scope.currentPage == 'overview' || $scope.currentPage == 'failedBackupByDate' || $scope.currentPage == 'dailyUserBackupOverview'  || $scope.currentPage == 'incompleteBackup'){
        	noOfDays = '';
        }
        if($scope.currentPage == 'incompleteBackup'){
                reason = $('#reasonFilter1').val();
        }else{
                reason = '';
        }
        var allowAllAdmins = false;
        if ($('#switchAllowAllAdmins').is(':checked')) {
        	allowAllAdmins = true;
        }
        var createdBy = $('#createdBy').val();
	if($scope.currentPage == 'noBackup'){
		var systemBased = 'true';
	}else{
		var systemBased = 'false';
	}
	if($scope.currentPage == 'minicloudActivityHistory'){
                var minicloudName = $('#minicloudName1').val();
                policyName = 'all';
        }else{
                var minicloudName = 'all';
        }
	var includeDetails = $("#includeDetails1").prop('checked');
	if($('.reportProductType').html() == 'backup'){
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                var productType = 'Sharepoint';
        }
        $.ajax({
          url: $scope.BASE_FOLDER+'/report/saveSchedule',
            data: {secret: '',csrf_token: $('.csrf_token').html(),days: days, date: date, time: time, mailid: mailid, scheduleName: scheduleName,userName: userName,deviceName: deviceName, policyName: policyName, trigger: $scope.trigger, id: id, months : months, dayOfMonth : dayOfMonth, noOfDays: noOfDays, isUserWithoutDeviceEnabled: isUserWithoutDeviceEnabled, showBlockedUsers:showBlockedUsers, showBlockedDevices:showBlockedDevices, startDate : startDate, endDate : endDate, allowAllAdmins: allowAllAdmins,createdBy: createdBy, reason: reason, productType: productType, systemBased: systemBased, miniCloudList: minicloudName, includeDetails: includeDetails},
            type: 'POST'
        }).done(function(data){
            $scope.$apply();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	$('#createScheduleModal').modal('hide');
                toastr.success('Schedule saved','Successful!!!', {allowHtml: true});
        	$('#createScheduleModal').modal('hide');
                $scope.getSchedules($scope.trigger);
        }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    //new exp end
	
    $('#selectedUsers').on('itemRemoved', function(event) {
        $("input.select-item").each(function (index,item) {
            if(item.value == event.item){
                item.checked = !item.checked;
                $scope.$apply();
            }	    
        });
	$("[name*='select-item']").css('pointer-events','auto');
        $("[name*='select-item']").css('opacity','1');
        $("[class*='emailId-item']").css('pointer-events','auto');
        $("[class*='emailId-item']").css('opacity','1');
        $("input.select-item").each(function (index,item) {
        	item.checked = false;
        });
    }); 
    /*report schedule end*/
    
    $scope.changePasswordForFirstlogin = function(){
        var password = $('#password').val();
        var rePassword = $('#rePassword').val();
        var html = $('#changePasswordBtn').html();
        $('#changePasswordBtn').attr('disabled','disabled');
        $('#changePasswordBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        document.getElementById("passwordError").innerHTML = "";
        document.getElementById("rePasswordError").innerHTML = "";
        if(password == '' && rePassword == ''){
                $('[name="password"]').removeClass('parsley-success');
                $('[name="password"]').addClass('parsley-error');
                $('[name="rePassword"]').removeClass('parsley-success');
                $('[name="rePassword"]').addClass('parsley-error');
                document.getElementById("passwordError").innerHTML = "This value is required.";
                document.getElementById("rePasswordError").innerHTML = "This value is required.";
                return;
        }
        if(password == ''){
                $('[name="password"]').removeClass('parsley-success');
                $('[name="password"]').addClass('parsley-error');
                document.getElementById("passwordError").innerHTML = "This value is required.";
                document.getElementById("rePasswordError").innerHTML = "";
                return;
        }
        if(rePassword == ''){
                $('[name="rePassword"]').removeClass('parsley-success');
                $('[name="rePassword"]').addClass('parsley-error');
                document.getElementById("passwordError").innerHTML = "";
                document.getElementById("rePasswordError").innerHTML = "This value is required.";
                return;
        }
        if(password == rePassword) {
                document.getElementById("passwordError").innerHTML = "";
                document.getElementById("rePasswordError").innerHTML = "";
                $('[name="password"]').removeClass('parsley-error');
                $('[name="password"]').addClass('parsley-success');
                $('[name="rePassword"]').removeClass('parsley-error');
                $('[name="rePassword"]').addClass('parsley-success');
        	$.ajax({
            		url: $scope.BASE_FOLDER+'/changePasswordForFirstlogin',
            		data:{csrf_token: $('.csrf_token').html(), password: password, accessKey: $('#accessKey').val()},
            		type: 'POST'
            	}).done(function(data){
            		var jData = JSON.parse(data);
            		if(jData.result == 'success'){
                		$('#changePasswordForFirstlogin').modal('hide');
                		$('#changePasswordBtn').html('Saved <i class="fa fa-check"></i>').animate();
                		setTimeout(function(){
                			toastr.success('Password Successfully changed', 'Success!!!');
                			$('#changePasswordBtn').html(html);
                			$('#changePasswordBtn').removeAttr('disabled');
                		}, 1000);
                		$('#password').val("");
                		$('#rePassword').val("");
				if($('.forceSessionLogoutAfterChangepassword').html() == '1'){
					setTimeout(function(){
						window.location.href = $scope.BASE_FOLDER+'/logout';
					}, 3000);
				}
            		}else{
                		$('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                		setTimeout(function(){
                			toastr.error('Old and New password cannot be same.', 'Fail!!!');
                			$('#password').val("");
                			$('#rePassword').val("");
                			$('#changePasswordBtn').html(html);
                			$('#changePasswordBtn').removeAttr('disabled');
                		}, 1000);
            		}
            	}).fail(function(data){
                	toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                	if(data.status == 424){
				setTimeout(function(){
					window.location.href = $scope.BASE_FOLDER+'/sleep';
				}, 3000);
                	}else if(data.status == 503){
				setTimeout(function(){
					window.location.href = $scope.BASE_FOLDER+'/serviceDown';
				}, 3000);
                	}
            	});
        }
    };
    
    $scope.requestQR = function(){
    	document.getElementById("statussuccess").innerHTML = "";
        if($('#mailId').val() == ''){
            return false;
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/checkMailNew',
            method: 'POST',
            data: {emailId: $('#mailId').val(), csrf_token: $('.csrf_token').html()}
        }).done(function(data){
                console.log("data : "+data);
                var jData = JSON.parse(data);
                console.log("jData : "+jData.msg);
                if(jData.result == 'success'){
                        document.getElementById("statussuccess").innerHTML = jData.msg;
                        toastr.success('A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.', 'Successful!!!', {allowHtml: true});
                        $('#mailId').val('');
                        setTimeout(function(){
                                $('#qrCollapse').collapse('hide');
                        }, 5000);
                }else{
                        //document.getElementById("statuserror").innerHTML = jData.msg;
                        document.getElementById("statussuccess").innerHTML = jData.msg;
                        toastr.success('A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.', 'Successful!!!', {allowHtml: true});
                        $('#mailId').val('');
                        setTimeout(function(){
                                $('#qrCollapse').collapse('hide');
                        }, 5000);
                        }
        }).fail(function(data){
            var jData = JSON.parse(data);
            //document.getElementById("statuserror").innerHTML = jData.msg;
            document.getElementById("statussuccess").innerHTML = jData.msg;
            toastr.success('A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.', 'Successful!!!', {allowHtml: true});
            $('#mailId').val('');
            setTimeout(function(){
                $('#qrCollapse').collapse('hide');
            }, 5000);
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        var fromDate = new Date();
        var toDate = new Date();
        fromDate = fromDate.setDate(fromDate.getDate() - 6);
        toDate = toDate.setDate(toDate.getDate());
        if($scope.currentPage == 'dashboard'){
	    localStorage.setItem("login","yes");
            localStorage.setItem("redirectUrl","dashboard");
            $scope.updateStatistics();
            $scope.updateStatisticsSync();
            if(localStorage.getItem('selectedDashTab') == '' || localStorage.getItem('selectedDashTab') == undefined){
	    if($('.isSharepointEnabled').html() == 'yes'){
                $scope.updateStatisticsOneDrive('Sharepoint');
		    $('#backupD').removeClass('active');
            $('#exchangeD').removeClass('active');
            $('#sharepointD').removeClass('active');
            $('#onedriveD').removeClass('active');
            $('#backup').removeClass('active');
            $('#exchange').removeClass('active');
            $('#sharepoint').removeClass('active');
            $('#onedrive').removeClass('active');
            $('#sharepointD').addClass('active');
	    $('#sharepointTab').addClass('active');
            }else{
                if($('.isOnedriveEnabled').html() == 'yes'){
			$('#backupD').removeClass('active');
            $('#exchangeD').removeClass('active');
            $('#sharepointD').removeClass('active');
            $('#onedriveD').removeClass('active');
            $('#backup').removeClass('active');
            $('#exchange').removeClass('active');
            $('#sharepoint').removeClass('active');
            $('#onedrive').removeClass('active');
            $('#onedriveD').addClass('active');
            $('#odb').addClass('active');
                        $scope.updateStatisticsOneDrive('ODB');
                }
            }
	}else{
		if(localStorage.getItem('selectedDashTab') == 'onedriveD'){
			$('#backupD').removeClass('active');
            $('#exchangeD').removeClass('active');
            $('#sharepointD').removeClass('active');
            $('#onedriveD').removeClass('active');
            $('#backup').removeClass('active');
            $('#exchange').removeClass('active');
            $('#sharepoint').removeClass('active');
            $('#onedrive').removeClass('active');
            $('#onedriveD').addClass('active');
            $('#odb').addClass('active');
			$scope.updateStatisticsOneDrive('ODB');
		}
		if(localStorage.getItem('selectedDashTab') == 'sharepointD'){
			$('#backupD').removeClass('active');
            $('#exchangeD').removeClass('active');
            $('#sharepointD').removeClass('active');
            $('#onedriveD').removeClass('active');
            $('#backup').removeClass('active');
            $('#exchange').removeClass('active');
            $('#sharepoint').removeClass('active');
            $('#onedrive').removeClass('active');
            $('#sharepointD').addClass('active');
            $('#sharepointTab').addClass('active');
                        $scope.updateStatisticsOneDrive('Sharepoint');
                }
		
	}
            //$scope.updateCurrentBackup(0);
            // $scope.updateStorageTrend(fromDate, toDate);
        }
        if($scope.currentPage == 'serverBackup'){
            $scope.updateServerBackupDetails();
            $scope.updateStorageTrend(fromDate, toDate);
        }
        if($scope.currentPage == 'statistics'){
            $scope.updateStatistics();
        }
        if($scope.currentPage == 'overview'){
            //$scope.updateOverview('all', 0);
        }
        if($scope.currentPage == 'productOverview'){
            $scope.updateProductOverview();
        }
        if($scope.currentPage == 'longBackup'){
            $scope.updateLongBackup(0);
        }
        if($scope.currentPage == 'currentBackup'){
            $scope.updateCurrentBackup(0);
        }
        if($scope.currentPage == 'noBackup'){
            $scope.updateNoBackup(1, 30, 'all');
        }
        if($scope.currentPage == 'usersNoBackup'){
            $scope.updateUsersNoBackup(1, 30, 'all');
        }
        if($scope.currentPage == 'storageUtilized'){
            $scope.updateStorageUtilized('', '', 0);
        }
        if($scope.currentPage == 'storageUtilizedByPG'){
            $scope.updateStorageUtilizedByPG();
        }
        if($scope.currentPage == 'failedBackupByUserOrDevice'){
            $scope.updateFailedBackupByUserOrDevice('', '', 0);
        }
        if($scope.currentPage == 'failedBackupByDate'){
            //$scope.updateFailedBackupByDate('', '', 0);
        }
        if($scope.currentPage == 'storageTrend'){
            $scope.updateStorageTrend('', '');
        }
        if($scope.currentPage == 'blobTrend'){
            $scope.updateBlobTrend('', '');
        }
        if($scope.currentPage == 'backupTrend'){
            $scope.updateBackupTrend('', '');
        }
        if($scope.currentPage == 'userDeviceHistory'){
            $scope.updateUserDeviceHistory('');
        }
        if($scope.currentPage == 'deviceUserHistory'){
            $scope.updateDeviceUserHistory('');
        }
        if($scope.currentPage == 'lastAgentServerConnectionDetails'){
            $scope.updateAgentNotHeard(30, 'all');
        }
        if($scope.currentPage == 'userBackupSummary'){
            $scope.updateUserBackupSummary(30, 'all');
        }
        if($scope.currentPage == 'userMigration'){
            $scope.updateUserMigration(0);
        }
        if($scope.currentPage == 'syncCLoudUsage'){
            $scope.updateSyncCLoudUsage(0);
            $scope.updateSyncCloudUsageDetails($('#from').val(), $('#to').val());
        }
        if($scope.currentPage == 'userBackupHistory'){
            //$('#policyName').find('option[value="all"]').attr("selected",true);
            $('#policyName').find('option[value="all"]').prop("selected",true);
        }
        var error = $('.resultError').html();
        if(error){
            if(error.length > 0){
                toastr.error(error, 'Fail');
            }
        }
	if($scope.currentPage == 'sbmdashboard'){
		localStorage.setItem("login","yes");
                localStorage.setItem("redirectUrl","delegatedDashboard");
		$scope.updateStatisticsMSP();
		$scope.updateUsers('all', 1);
		$scope.manageDevices('backup');
		$scope.updateUserBackupSummary(30, 'all');
        }
    });
    
/*users with systems not protected start*/  
    $scope.updateUsersNoBackup = function(pageNumber, numberOfDays,policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }
        $('.noBackupError').hide();
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                    policyName.splice(i, 1);
            }
        }*/
        $('.first').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        //policyName = $('#searchPolicyName').val();
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
        blockUI.start();
        var numberOfDays = $('#noOfDays').val();
	var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/usersNoBackup',
            data: {pageNumber: pageNumber, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.noBackup == null || jData.noBackup == ''){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                    $('.first').show();
                }
                if($scope.previous){
                    $('.previous').show();
                }
                if($scope.next){
                    $('.next').show();
                }
                if($scope.last){
                    $('.last').show();
                }
                $scope.noBackup = jData.noBackup;
                if(jData.noBackup == 'noData'){
                $('.noBackupError').show();
                                    $('.noBackup').hide();
                }
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
                        $('.next').addClass('invalid');
                }else{
                        $('.next').removeClass('invalid');
                }
                $scope.pageNumber = pageNumber+1;
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                $('.noBackupError').show();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUsersNoBackupNavigate = function(numberOfDays,policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        if ($('#noOfDays').val() == ""){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
            return;
        }
        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }
        $('.noBackupError').hide();
        /*if($('.selectPicker').selectpicker('val') == null){
            policyName = 'all';
        }else{
            policyName = $('.selectPicker').selectpicker('val');
            var i = policyName.indexOf("all");
            if(i != -1) {
                    policyName.splice(i, 1);
            }
        }
        policyName = $('#searchPolicyName').val();*/
        if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
	var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
        blockUI.start();
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/usersNoBackup1',
            data: {numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.noBackup == null || jData.noBackup == ''){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                    $('.first').show();
                }else{
                    $('.first').hide();
                }
                if($scope.previous){
                    $('.previous').show();
                }else{
                    $('.previous').hide();
                }
                if($scope.next){
                    $('.next').show();
                }
                if($scope.last){
                    $('.last').show();
                }else{
                $('.last').hide();
                }
                $scope.noBackup = jData.noBackup;
                if(jData.noBackup == 'noData'){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }
		if(jData.noBackup != null && jData.noBackup.length < jData.metadata.recordsPerPage){
                        $('.next').addClass('invalid');
                }else{
                        $('.next').removeClass('invalid');
                }
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                $('.noBackupError').show();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
    }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadUsersNoBackupExcel = function(skipValue, numberOfDays,policyName){
	 var myBlockUI = blockUI.instances.get('myBlockUI');
	 myBlockUI.start();
         if($('#noOfDays').val() == ""){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
             return;
         }
         if(numberOfDays <= 0){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
         }
         if($scope.all == 'all'){
             policyName = 'all';
         }else{
             policyName = policyName;
         }
         $('.noBackupError').hide();
         $scope.skipValue = skipValue;
         /*if($('.selectPicker').selectpicker('val') == null){
             policyName = 'all';
         }else{
             policyName = $('.selectPicker').selectpicker('val');
             var i = policyName.indexOf("all");
             if(i != -1) {
                     policyName.splice(i, 1);
             }
         }
         policyName = $('#searchPolicyName').val();*/
         if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
         var numberOfDays = $('#noOfDays').val();
	 var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/usersNoBackupExcel',
             data: {skipValue: skipValue, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
             type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();		 
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');	
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadUsersNobackupReportToExcel';
            	toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();		
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                 window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };

    $scope.downloadUsersNoBackupPdf = function(skipValue, numberOfDays,policyName){
         var myBlockUI = blockUI.instances.get('myBlockUI');
         myBlockUI.start();
         if ($('#noOfDays').val() == ""){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
             return;
         }
         if (numberOfDays <= 0){
             toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
         }
         if($scope.all == 'all'){
             policyName = 'all';
         }else{
             policyName = policyName;
         }
         $('.noBackupError').hide();
         $scope.skipValue = skipValue;
         /*if($('.selectPicker').selectpicker('val') == null){
             policyName = 'all';
         }else{
             policyName = $('.selectPicker').selectpicker('val');
             var i = policyName.indexOf("all");
             if(i != -1) {
                     policyName.splice(i, 1);
             }
         }
         policyName = $('#searchPolicyName').val();*/
         if($('.reportProductType').html() == 'backup'){
                policyName = $('#searchPolicyName').val();
                var productType = 'backup';
        }else if($('.reportProductType').html() == 'onedrive'){
                policyName = $('#searchODBPolicyName').val();
                var productType = 'ODB';
        }else if($('.reportProductType').html() == 'exchange'){
                policyName = $('#searchExchangePolicyName').val();
                var productType = 'Exchange';
        }else if($('.reportProductType').html() == 'sharepoint'){
                policyName = $('#searchSharepointPolicyName').val();
                var productType = 'Sharepoint';
        }
         var numberOfDays = $('#noOfDays').val();
	 var includeDevicesHeardFrom = $("#includeDevicesHeardFrom").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/usersNoBackupPdf',
             data: {skipValue: skipValue, numberOfDays: numberOfDays,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: productType, includeDevicesHeardFrom: includeDevicesHeardFrom, daysToIncludeDevicesHeardFrom: $('#daysToIncludeDevicesHeardFrom').val()},
             type: 'POST'
         }).done(function(data){
         $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadUsersNobackupReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                 window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     }; 
/*users with systems not protected end*/
    
/*miniclouds reporting start*/  
     $('#minicloudName').selectpicker().change(function(){
	     toggleSelectAll($(this));
     }).trigger('change');
    
    $scope.updateMinicloudActivityDetails = function(){
        $('.logsPagination').hide();
        var pageNumber = 1;
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $('.loading').show();
        var minicloudName = $('#minicloudName').val();
        var from = $('#from').val();
        var to = $('#to').val();
        from = getMeDate(from);
        to = getMeDate(to);
        $.ajax({
            url: $scope.BASE_FOLDER+'/getMinicloudActivityHistory',
            data: {pageNumber: pageNumber, csrf_token: $('.csrf_token').html(), minicloudName: minicloudName, from: from, to: to},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.audits.length > 0){
                    //$scope.audits = $scope.audits.concat(jData.audits);
                    $scope.audits = jData.audits;
                    $scope.pageNumber = pageNumber+1;
                    $('.mini-timeline').show();
                    $('.logsPagination').show();
                    $('.noData').hide();
                    $scope.previous = jData.metadata.links.previous;
                    $scope.next = jData.metadata.links.next;
                    $scope.last = jData.metadata.links.last;
                    $scope.self = jData.metadata.links.self;
                    $scope.first = jData.metadata.links.first;
                    $scope.currentpageCount = jData.metadata.pageNumber;
                    $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                    if($scope.first){
                	$('.first').show();
                    }
                    if($scope.self){
                	$('.self').show();
                    }
                    if($scope.previous){
                	$('.previous').show();
                    }
                    if($scope.next){
                	$('.next').show();
                    }
                    if($scope.last){
                	$('.last').show();
                    }
                }else{
                    $scope.audits = [];
                    $('.mini-timeline').hide();
                    $('.logsPagination').hide();
                    $('.noData').show();
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateMinicloudActivityDetailsNavigate = function(url){
        $('.logsPagination').hide();
        $('.loading').show();
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var minicloudName = $('#minicloudName').val();
        var from = $('#from').val();
        var to = $('#to').val();
        from = getMeDate(from);
        to = getMeDate(to);
        $.ajax({
            url: $scope.BASE_FOLDER+'/getMinicloudActivityHistory1',
            data: {url: url, csrf_token: $('.csrf_token').html(), minicloudName: minicloudName, from: from, to: to},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){  
                if(jData.audits.length > 0){
            	    $scope.audits = jData.audits;
            	    $('.mini-timeline').show();
            	    $('.logsPagination').show();
            	    $('.noData').hide();
            	    $scope.previous = jData.metadata.links.previous;
            	    $scope.next = jData.metadata.links.next;
            	    $scope.last = jData.metadata.links.last;
            	    $scope.self = jData.metadata.links.self;
            	    $scope.first = jData.metadata.links.first;
            	    $scope.currentpageCount = jData.metadata.pageNumber;
            	    $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            	    if($scope.first){
                	$('.first').show();
            	    }
            	    if($scope.self){
                	$('.self').show();
            	    }
            	    if($scope.previous){
                	$('.previous').show();
            	    }
            	    if($scope.next){
                	$('.next').show();
            	    }
            	    if($scope.last){
                	$('.last').show();
            	    }
                }else{
                    $scope.audits = [];
                    $('.mini-timeline').hide();
                    $('.logsPagination').hide();
                    $('.noData').show();
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadMinicloudActivityExcel = function(){
         var minicloudName = $('#minicloudName').val();
         var from = $('#from').val();
         var to = $('#to').val();
         from = getMeDate(from);
         to = getMeDate(to);
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/minicloudActivityExcel',
             data: {csrf_token: $('.csrf_token').html(), to: to, from: from, minicloudName: minicloudName},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             blockUI.stop();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadMinicloudActivityToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
             }).fail(function(data){
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
     
     $scope.downloadMinicloudActivityPdf = function(){
         var minicloudName = $('#minicloudName').val();
         var from = $('#from').val();
         var to = $('#to').val();
         from = getMeDate(from);
         to = getMeDate(to);
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/minicloudActivityPdf',
             data: {csrf_token: $('.csrf_token').html(), to: to, from: from, minicloudName: minicloudName},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             blockUI.stop();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 window.location.href = $scope.BASE_FOLDER+'/report/downloadMinicloudActivityToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
             }).fail(function(data){
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
    };  
/*miniclouds reporting end*/
    
    $scope.updateProductOverview = function(){
    	$('#productOverviewSpinner').show();
    	$('.productOverview').hide();
        $('.productOverviewError').hide();
    	var policyName = $('#searchPolicyName').val();
    	var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/productOverview',
            data: {secret: '',csrf_token: $('.csrf_token').html(), policyName: policyName, numberOfDays: numberOfDays},
            type: 'POST'
        }).done(function(data){
        	$('#productOverviewSpinner').hide();
            	var jData = JSON.parse(data);
        	if(jData.result == 'success'){
        		$('.productOverview').show();
        		$('.productOverviewError').hide();
                	$scope.productOverviewLicense = jData.productOverviewLicense;
            		$scope.productOverviewPolicyElement = jData.productOverviewPolicyElement;
            		$scope.overview = jData.overview;
        		$scope.failedBackup = jData.failedBackup;
        		$scope.restoreByDate = jData.restoreByDate;
        		$scope.blockedUsers = jData.blockedUsers;
        		$scope.adminDetails = jData.adminDetails;
        		$scope.allBlockedDevices = jData.allBlockedDevices;
        		$scope.userBackupHistory = jData.userBackupHistory;
        		$scope.userPolicyMappingElementList = jData.userPolicyMappingElementList;
        		/*start*/
        		if(jData.overview.length > 0){
                        	$('#overviewTableDiv').show();
            			$('#overviewErrorDiv').hide();
                	}else{
                        	$('#overviewTableDiv').hide();
            			$('#overviewErrorDiv').show();
                	}
                	if(jData.failedBackup.length > 0){
                        	$('#failedBackupTableDiv').show();
            			$('#failedBackupErrorDiv').hide();
                	}else{
                        	$('#failedBackupTableDiv').hide();
            			$('#failedBackupErrorDiv').show();
                	}
                	if(jData.restoreByDate.length > 0){
            			$('#restoreByDateTableDiv').show();
                        	$('#restoreByDateErrorDiv').hide();
                	}else{
            			$('#restoreByDateTableDiv').hide();
                        	$('#restoreByDateErrorDiv').show();
                	}
                	if(jData.blockedUsers.length > 0){
                        	$('#blockedUsersTableDiv').show();
            			$('#blockedUsersErrorDiv').hide();
                	}else{
                        	$('#blockedUsersTableDiv').hide();
            			$('#blockedUsersErrorDiv').show();
                	}
                	if(jData.adminDetails.length > 0){
                        	$('#adminDetailsTableDiv').show();
            			$('#adminDetailsErrorDiv').hide();
                	}else{
                        	$('#adminDetailsTableDiv').hide();
            			$('#adminDetailsErrorDiv').show();
                	}
                	if(jData.allBlockedDevices.length > 0){
                        	$('#allBlockedDevicesTableDiv').show();
            			$('#allBlockedDevicesErrorDiv').hide();
                	}else{
                        	$('#allBlockedDevicesTableDiv').hide();
            			$('#allBlockedDevicesErrorDiv').show();
                	}
                	if(jData.userBackupHistory.length > 0){
                        	$('#userBackupHistoryTableDiv').show();
            			$('#userBackupHistoryErrorDiv').hide();
                	}else{
                        	$('#userBackupHistoryTableDiv').hide();
            			$('#userBackupHistoryErrorDiv').show();
                	}
                	if(jData.userPolicyMappingElementList.length > 0){
                        	$('#userPolicyMappingElementListTableDiv').show();
            			$('#userPolicyMappingElementListErrorDiv').hide();
                	}else{
                        	$('#userPolicyMappingElementListTableDiv').hide();
            			$('#userPolicyMappingElementListErrorDiv').show();
	                }
        		/*end*/
			if(jData.overview.length > 10){
            			$('#overviewTableDiv').height('300px');
            			$('#overviewTableDiv').css('overflow','scroll');
			}else{
            			$('#overviewTableDiv').css('overflow','');
            			$('#overviewTableDiv').height('unset');
			}
			if(jData.failedBackup.length > 10){
            			$('#failedBackupTableDiv').height('300px');
            			$('#failedBackupTableDiv').css('overflow','scroll');
			}else{
            			$('#failedBackupTableDiv').css('overflow','');
            			$('#failedBackupTableDiv').height('unset');
			}
			if(jData.restoreByDate.length > 10){
                        	$('#restoreByDateTableDiv').height('300px');
            			$('#restoreByDateTableDiv').css('overflow','scroll');
                	}else{
            			$('#restoreByDateTableDiv').css('overflow','');
                        	$('#restoreByDateTableDiv').height('unset');
                	}
			if(jData.blockedUsers.length > 10){
                        	$('#blockedUsersTableDiv').height('300px');
                        	$('#blockedUsersTableDiv').css('overflow', 'scroll');
                	}else{
                        	$('#blockedUsersTableDiv').css('overflow','');
                        	$('#blockedUsersTableDiv').height('unset');
                	}
			if(jData.adminDetails.length > 10){
                        	$('#adminDetailsTableDiv').height('300px');
                        	$('#adminDetailsTableDiv').css('overflow', 'scroll');
                	}else{
                        	$('#adminDetailsTableDiv').css('overflow','');
                        	$('#adminDetailsTableDiv').height('unset');
                	}
			if(jData.allBlockedDevices.length > 10){
                        	$('#allBlockedDevicesTableDiv').height('300px');
                        	$('#allBlockedDevicesTableDiv').css('overflow', 'scroll');
                	}else{
                        	$('#allBlockedDevicesTableDiv').css('overflow','');
                        	$('#allBlockedDevicesTableDiv').height('unset');
                	}
			if(jData.userBackupHistory.length > 10){
                        	$('#userBackupHistoryTableDiv').height('300px');
                        	$('#userBackupHistoryTableDiv').css('overflow', 'scroll');
                	}else{
                        	$('#userBackupHistoryTableDiv').css('overflow','');
                        	$('#userBackupHistoryTableDiv').height('unset');
                	}
			if(jData.userPolicyMappingElementList.length > 10){
                        	$('#userPolicyMappingElementListTableDiv').height('300px');
                        	$('#userPolicyMappingElementListTableDiv').css('overflow', 'scroll');
                	}else{
                        	$('#userPolicyMappingElementListTableDiv').css('overflow','');
                        	$('#userPolicyMappingElementListTableDiv').height('unset');
                	}
        	}else{
        		$('.productOverview').hide();
       			$('.productOverviewError').show();
            		toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
        	}
            	$scope.$apply();
            	$('.widget a').removeClass('d-none');
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadProductOverview = function(){
        var policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/downloadProductOverview',
            data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), policyName:policyName, numberOfDays: numberOfDays},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
        window.location.href = $scope.BASE_FOLDER+'/report/downloadProductOverviewExcel';
               toastr.success('Report generated', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadProductOverviewPdf = function(){
        var policyName = $('#searchPolicyName').val();
        var numberOfDays = $('#noOfDays').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/downloadProductOverviewToPdf',
            data: {skipValue: $scope.skipValue,csrf_token: $('.csrf_token').html(), policyName:policyName, numberOfDays: numberOfDays},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
               window.location.href = $scope.BASE_FOLDER+'/report/downloadProductOverviewPdf';
               toastr.success('Report generated', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveScheduleProductOverview = function(){
        var days = '';
        var time = $('#scheduleStartTime').val();
        var mailid = $('#selectedUsers').val();
        var months = $('#months').val();
        var dayOfMonth = $('#dayOfMonth').val();
        var date = '';
        var choice = $('#scheduleType').val();
        if(choice == 'choiceDays'){
        	date = '';
            	date = '';
            	days = $('#days').val();
        	months = [];
        	dayOfMonth = '';
        }
        if(choice == 'choiceTime'){
        	date = $('#date').val();
        	date = getMeDate(date);
            	days = '';
        	months = [];
            	dayOfMonth = '';
        }
        if(choice == 'choiceMonths'){
        	date = '';
        	days = '';
        }
        var scheduleName = $('#scheduleName').val();
        if(isSpecialCharForSchedule(scheduleName) == false){
            	$('[name="scheduleName"]').addClass('parsley-error');
            	return;
        }
        var id = '';
        if($scope.id != ''){
        	id = $scope.id;
        }else{
        	id = '';
        }
        var noOfDays;
        if($("#noOfDays1").length > 0){
        	noOfDays = $('#noOfDays1').val();
        }else{
        	noOfDays = '';
        }
        var startDate = '';
        var endDate = '';
        var allowAllAdmins = false;
        if ($('#switchAllowAllAdmins').is(':checked')) {
        	allowAllAdmins = true;
        }
        var createdBy = $('#createdBy').val();
        var policyName = $('#searchPolicyName1').val();
        $.ajax({
          url: $scope.BASE_FOLDER+'/report/saveScheduleReportProductOverview',
            data: {secret: '',csrf_token: $('.csrf_token').html(),days: days, date: date, time: time, mailid: mailid, scheduleName: scheduleName,policyName: policyName, trigger: $scope.trigger, id: id, months : months, dayOfMonth : dayOfMonth, noOfDays: noOfDays, startDate : startDate, endDate : endDate, allowAllAdmins: allowAllAdmins,createdBy: createdBy},
            type: 'POST'
        }).done(function(data){
            $scope.$apply();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	$('#createScheduleModal').modal('hide');
                toastr.success('Schedule saved','Successful!!!', {allowHtml: true});
            	$('#createScheduleModal').modal('hide');
                $scope.getSchedules($scope.trigger);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.includeDateRange = 'false';
	$('#includeDateRange').on('change', function(){
	var checked = document.getElementById('includeDateRange').checked;
	if(checked){
		$('#dateRangeNote').show();
		if(document.getElementById('reasonFilter').value != 'UsersWithoutAgent' && document.getElementById('reasonFilter').value != 'NotHeardDevices'){
                    $scope.includeDateRange = 'true';
                    document.getElementById("fromDateDiv").style.opacity = "1";
                    document.getElementById("fromDateDiv").style['pointer-events'] = 'unset';
                    document.getElementById("toDateDiv").style.opacity = "1";
                    document.getElementById("toDateDiv").style['pointer-events'] = 'unset';
		    document.getElementById("fromDateDiv").style['display'] = 'block';
                    document.getElementById("toDateDiv").style['display'] = 'block';
		}else if(document.getElementById('reasonFilter').value == 'NotHeardDevices'){
                    $scope.includeDateRange = 'true';
                    document.getElementById("fromDateDiv").style.opacity = "1";
                    document.getElementById("fromDateDiv").style['pointer-events'] = 'unset';
                    document.getElementById("toDateDiv").style.opacity = "1";
                    document.getElementById("toDateDiv").style['pointer-events'] = 'unset';
                    document.getElementById("fromDateDiv").style['display'] = 'block';
                    document.getElementById("toDateDiv").style['display'] = 'block';
		}else{
		    	$scope.includeDateRange = 'false';
                    document.getElementById("fromDateDiv").style.opacity = "0.5";
                    document.getElementById("fromDateDiv").style['pointer-events'] = 'none';
                    document.getElementById("toDateDiv").style.opacity = "0.5";
                    document.getElementById("toDateDiv").style['pointer-events'] = 'none';
		    document.getElementById("fromDateDiv").style['display'] = 'none';
		    document.getElementById("toDateDiv").style['display'] = 'none';
		}
	}else{
		$('#dateRangeNote').hide();
		$scope.includeDateRange = 'false';
		document.getElementById("fromDateDiv").style.opacity = "0.5";
		document.getElementById("fromDateDiv").style['pointer-events'] = 'none';
		document.getElementById("toDateDiv").style.opacity = "0.5";
		document.getElementById("toDateDiv").style['pointer-events'] = 'none';
		document.getElementById("fromDateDiv").style['display'] = 'none';
		document.getElementById("toDateDiv").style['display'] = 'none';
	}
    });
    
    $('#reasonFilter').on('change', function(){
            var checked = document.getElementById('reasonFilter').value;
            if(checked != 'UsersWithoutAgent' && checked != 'NotHeardDevices'){
		    if(document.getElementById('includeDateRange').checked){
		    	$scope.includeDateRange = 'true';
		    }else{
		    	$scope.includeDateRange = 'false';
		    }
                    document.getElementById("includeDateRangeDiv").style.opacity = "1";
                    document.getElementById("includeDateRangeDiv").style['pointer-events'] = 'unset';
		    document.getElementById("fromDateDiv").style['display'] = 'none';
                    document.getElementById("toDateDiv").style['display'] = 'none';
            }else if(checked == 'NotHeardDevices'){
		    $scope.includeDateRange = 'false';
		    document.getElementById('includeDateRange').checked = false;
		    $('#includeDateRange').removeAttr('checked');
                    document.getElementById("fromDateDiv").style.opacity = "0.5";
                    document.getElementById("fromDateDiv").style['pointer-events'] = 'none';
                    document.getElementById("toDateDiv").style.opacity = "0.5";
                    document.getElementById("toDateDiv").style['pointer-events'] = 'none';
		    document.getElementById("fromDateDiv").style['display'] = 'none';
                    document.getElementById("toDateDiv").style['display'] = 'none';
                    document.getElementById("includeDateRangeDiv").style.opacity = "0.5";
                    document.getElementById("includeDateRangeDiv").style['pointer-events'] = 'none';
	    }else{
		    $scope.includeDateRange = 'false';
		    document.getElementById('includeDateRange').checked = false;
		    $('#includeDateRange').removeAttr('checked');
                    document.getElementById("fromDateDiv").style.opacity = "0.5";
                    document.getElementById("fromDateDiv").style['pointer-events'] = 'none';
                    document.getElementById("toDateDiv").style.opacity = "0.5";
                    document.getElementById("toDateDiv").style['pointer-events'] = 'none';
		    document.getElementById("fromDateDiv").style['display'] = 'none';
                    document.getElementById("toDateDiv").style['display'] = 'none';
                    document.getElementById("includeDateRangeDiv").style.opacity = "0.5";
                    document.getElementById("includeDateRangeDiv").style['pointer-events'] = 'none';
            }
    });
    
    $scope.updateIncompleteBackup = function(policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
            policyName = policyName;
        }else{
            policyName = 'all';
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }
        $('.failedBackupError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        $('.first').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        policyName = $('#searchPolicyName').val();
        var reason = $('#reasonFilter').val();
        var from;
        var to;
	var includeDateRange;
        if($scope.includeDateRange == 'false' || reason == 'UsersWithoutAgent'){
                from = '';
                to = '';
		includeDateRange = 'no';
        }else{
                from = $('#from').val();
                to = $('#to').val();
                from = getMeDate(from);
                to = getMeDate(to);
		includeDateRange = 'yes';
        }
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/incompleteBackup',
            data: {reason: reason,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html(), from: from, to: to, includeDateRange: includeDateRange},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupError').show();
                    $('.failedBackup').hide();
                    document.getElementById('optionSpecific').innerHTML = '';
                }else{
                    $('.failedBackupError').hide();
                    $('.failedBackup').show();
                }
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                    $('.first').show();
                }                
                if($scope.previous){
                    $('.previous').show();
                }
                if($scope.next){
                    $('.next').show();
                }
                if($scope.last){
                    $('.last').show();
                }
                if(jData.failedBackup.length > 0){
                    $scope.failedBackup = jData.failedBackup;
                    if(reason == 'NotHeardDevices' || reason == 'UsersWithoutAgent'){
                        $('.last2').show();
                        $('.first3').hide();
                        $('#optionSpecific').show();
                    }else{
                        $('.first3').show();
                        $('.last2').hide();
                        $('#optionSpecific').hide()
                    }
                    if(reason == 'NotHeardDevices'){
                        document.getElementById('optionSpecific').innerHTML = 'Note: Data is for last 7 days.';
                    }
                    if(reason == 'UsersWithoutAgent'){
                        document.getElementById('optionSpecific').innerHTML = 'Note: These licenses have been consumed but users are not using the product.';
                    }
                }
		if(jData.failedBackup != null && jData.failedBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateIncompleteBackupNavigate = function(policyName,url){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
            policyName = policyName;
        }else{
            policyName = 'all';
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }
        $('.failedBackupError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
        policyName = $('#searchPolicyName').val();
        var reason = $('#reasonFilter').val();
        var from;
        var to;
	var includeDateRange;
        if($scope.includeDateRange == 'false' || reason == 'UsersWithoutAgent'){
                from = '';
                to = '';
		includeDateRange = 'no';
        }else{
                from = $('#from').val();
                to = $('#to').val();
                from = getMeDate(from);
                to = getMeDate(to);
		includeDateRange = 'yes';
        }
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/incompleteBackup1',
            data: {reason: reason,policyName:policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: $('.reportProductType').html(), from: from, to: to,includeDateRange: includeDateRange},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
	    myBlockUI.stop();
	    $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	$scope.previous = jData.metadata.links.previous;
            	$scope.next = jData.metadata.links.next;
            	$scope.last = jData.metadata.links.last;
            	$scope.first = jData.metadata.links.first;
            	$scope.currentpageCount = jData.metadata.pageNumber;
            	$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            	if($scope.first){
                	$('.first').show();
            	}else{
                	$('.first').hide();
            	}
            	if($scope.previous){
                	$('.previous').show();
            	}else{
                	$('.previous').hide();
            	}
            	if($scope.next){
                	$('.next').show();
            	}
            	if($scope.last){
                	$('.last').show();
            	}else{
                	$('.last').hide();
            	}
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupError').show();
                    $('.failedBackup').hide();
                    document.getElementById('optionSpecific').innerHTML = '';
                }else{
                    $('.failedBackupError').hide();
                    $('.failedBackup').show();
                }
                if(jData.failedBackup.length > 0){
                    $scope.failedBackup = jData.failedBackup;
                    if(reason == 'NotHeardDevices' || reason == 'UsersWithoutAgent'){
                        $('.last2').show();
                        $('.first3').hide();
                        $('#optionSpecific').show();
                    }else{
                        $('.first3').show();
                        $('.last2').hide();
                        $('#optionSpecific').hide()
                    }
                    if(reason == 'NotHeardDevices'){
                        document.getElementById('optionSpecific').innerHTML = 'Note: Data is for last 7 days.';
                    }
                    if(reason == 'UsersWithoutAgent'){
                        document.getElementById('optionSpecific').innerHTML = 'Note: These licenses have been consumed but users are not using the product.';
                    }
                }
		if(jData.failedBackup != null && jData.failedBackup.length < jData.metadata.recordsPerPage){
			$('.next').addClass('invalid');
		}else{
			$('.next').removeClass('invalid');
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.downloadIncompleteBackupExcel = function(policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
            policyName = policyName;
        }else{
            policyName = 'all';
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }
         $('.failedBackupError').hide();
         $('.loading').show();
         policyName = $('.selectPicker').selectpicker('val');
         var i = policyName.indexOf("all");
         if(i != -1) {
                 policyName.splice(i, 1);
         }
         policyName = $('#searchPolicyName').val();
         var reason = $('#reasonFilter').val();
	    var includeDateRange;
	 if($scope.includeDateRange == 'false' || reason == 'UsersWithoutAgent'){
                from = '';
                to = '';
		 includeDateRange = 'no';
        }else{
                from = $('#from').val();
                to = $('#to').val();
                from = getMeDate(from);
                to = getMeDate(to);
		includeDateRange = 'yes';
        }
         $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/incompleteBackupReportExcel',
            data: {reason: reason,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html(), from: from, to: to,includeDateRange: includeDateRange},
            type: 'POST'
         }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadIncompleteBackupReportToExcel';
                toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		 
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
    
    $scope.downloadIncompleteBackupPdf = function(policyName){
	var myBlockUI = blockUI.instances.get('myBlockUI');
	myBlockUI.start();
        $scope.policyName = policyName;
        if($scope.policy == 'true'){
            policyName = policyName;
        }else{
            policyName = 'all';
        }
        if($scope.all == 'all'){
            policyName = 'all';
        }else{
            policyName = policyName;
        }        
        $('.failedBackupError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
            policyName.splice(i, 1);
        }
        policyName = $('#searchPolicyName').val();
        var reason = $('#reasonFilter').val();
	    var includeDateRange;
	if($scope.includeDateRange == 'false' || reason == 'UsersWithoutAgent'){
                from = '';
                to = '';
		includeDateRange = 'no';
        }else{
                from = $('#from').val();
                to = $('#to').val();
                from = getMeDate(from);
                to = getMeDate(to);
		includeDateRange = 'yes';
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/download/incompleteBackupReportPdf',
            data: {reason: reason,policyName:policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html(), from: from, to: to, includeDateRange:includeDateRange},
            type: 'POST'
        }).done(function(data){
             $('.downloadButton').show();
             blockUI.stop();
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
             $('.loading').hide();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadIncompleteBackupReportToPdf';
                toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
        }).fail(function(data){
	     myBlockUI.stop();
	     $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');		
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
	
    $scope.downloadUserMigration = function(userName, policyName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadUserMigration',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadUserMigrationExcel';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    /*new mockup start*/
    $scope.users = [];

    $scope.updateUsers = function(userName, pageNumber){
	var pageNumber = $scope.pageNumber;
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/users',
	    data: {userName: userName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	if(jData.metadata != ''){
            		$('.userListTableNavigate').show();
            		$scope.previous = jData.metadata.links.previous;
            		$scope.next = jData.metadata.links.next;
            		$scope.last = jData.metadata.links.last;
            		//$scope.self = jData.metadata.links.self;
            		$scope.first = jData.metadata.links.first;
            		$scope.currentpageCount = jData.metadata.pageNumber;
            		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            	}else{
            		$('.userListTableNavigate').hide();
            	}
            	if($scope.first){
            		$('.first').show();
            	}
            	if($scope.previous){
            		$('.previous').show();
            	}
            	if($scope.next){
            		$('.next').show();
            	}
            	if($scope.last){
            		$('.last').show();
            	}
                $('.userListTable').show();
                $('.nouser').hide();
                if(userName == 'all'){
                	$scope.users = jData.users;
                        $scope.$apply();
                }else{
                	$scope.users = jData.users;
                        $scope.$apply();
                }
		$('.userListTable').show();
                if(jData.users.length > 0){
			//$('.userListTable').show();
			$('.userListTableNavigate').show();
			//$('.nouserListTable').hide();
                }else{
			//$('.userListTable').hide();
			$('.userListTableNavigate').hide();
			//$('.nouserListTable').show();
                }
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }
        });
    };

    $scope.updateUsersNavigate = function(userName, url){
	var pageNumber = $scope.pageNumber;
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/users1',
	    data: {userName: userName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
            	if(jData.metadata != ''){
            		$('.userListTableNavigate').show();
            		$scope.previous = jData.metadata.links.previous;
            		$scope.next = jData.metadata.links.next;
            		$scope.last = jData.metadata.links.last;
            		//$scope.self = jData.metadata.links.self;
            		$scope.first = jData.metadata.links.first;
            		$scope.currentpageCount = jData.metadata.pageNumber;
            		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            	}else{
			$('.userListTableNavigate').hide();
		}
		if($scope.first){
			$('.first').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                $('.userListTable').show();
                $('.nouser').hide();
		if(userName == 'all'){
			$scope.users = jData.users;
                        $scope.$apply();
		}else{
			$scope.users = jData.users;
                        $scope.$apply();
		}
		$('.userListTable').show();
		if(jData.users.length > 0){
			//$('.userListTable').show();
			$('.userListTableNavigate').show();
			//$('.nouserListTable').hide();
			$(window).scrollTop(0);
		}else{
			//$('.userListTable').hide();
			$('.userListTableNavigate').hide();
			//$('.nouserListTable').show();
		}
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.devices = [];

    $scope.manageDevices = function(type){
        $('.loading').html('Loading ...');
	$('.status').show();
        $('.status').html('<h4>No Devices have been configured yet</h4>');
        $scope.selected = [];
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/manageDevices',
                data: {csrf_token: $('.csrf_token').html(), type: type},
                type: 'POST'
            }).done(function(data){
                $('#selectable tr').removeClass('ui-selected');
                    $('#selectable1 tr').removeClass('ui-selected');
                    $('#selectable2 tr').removeClass('ui-selected');
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.devices.length > 0){
                        $('.status').hide();
                        $('.devicesList').show();
			$('.devicesListTableNavigate').show();
                        $scope.devices = jData.devices;
			$scope.devices = jData.devices;
                        $scope.previousD = jData.metadata.links.previous;
                        $scope.nextD = jData.metadata.links.next;
                        $scope.lastD = jData.metadata.links.last;
                        $scope.firstD = jData.metadata.links.first;
                        $scope.currentpageCountD = jData.metadata.pageNumber;
                        $scope.totalpageCountD = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                        if($scope.firstD){
                                $('.firstD').show();
                        }
                        if($scope.previousD){
                                $('.previousD').show();
                        }
                        if($scope.nextD){
                                $('.nextD').show();
                        }
                        if($scope.lastD){
                                $('.lastD').show();
                        }
                        $scope.$apply();
                    }else{
                        $('.status').show();
                        $('.status').html('<h4>No Devices have been configured yet</h4>');
			$('.devicesListTableNavigate').hide();
                        //toastr.info('You have not configured any devices yet to be backed up!!!', 'Information!!!', {allowHtml: true});
                    }
                }else{
                    $('.devicesList').hide();
		    $('.devicesListTableNavigate').hide();
                    $('.status').show();
                    $('.status').html('<h4>No Devices have been configured yet</h4>');
                    //toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
            	toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);
                }
            });
    };

    $scope.manageDevicesNavigate = function(type, url){
        $('.loading').html('Loading ...');
        $('.status').show();
        $('.status').html('<h4>No Devices have been configured yet</h4>');
        $scope.selected = [];
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/manageDevicesNavigate',
                data: {csrf_token: $('.csrf_token').html(), type: type,url: url},
                type: 'POST'
            }).done(function(data){
                $('#selectable tr').removeClass('ui-selected');
                    $('#selectable1 tr').removeClass('ui-selected');
                    $('#selectable2 tr').removeClass('ui-selected');
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.devices.length > 0){
                        $('.status').hide();
                        $('.devicesList').show();
                        $('.devicesListTableNavigate').show();
                        $scope.devices = jData.devices;
                        $scope.devices = jData.devices;
                        $scope.previousD = jData.metadata.links.previous;
                        $scope.nextD = jData.metadata.links.next;
                        $scope.lastD = jData.metadata.links.last;
                        $scope.firstD = jData.metadata.links.first;
                        $scope.currentpageCountD = jData.metadata.pageNumber;
                        $scope.totalpageCountD = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
                        if($scope.firstD){
                                $('.firstD').show();
                        }
			if($scope.previousD){
                                $('.previousD').show();
                        }
                        if($scope.nextD){
                                $('.nextD').show();
                        }
                        if($scope.lastD){
                                $('.lastD').show();
                        }
                        $scope.$apply();
                    }else{
                        $('.status').show();
                        $('.status').html('<h4>No Devices have been configured yet</h4>');
                        $('.devicesListTableNavigate').hide();
                        //toastr.info('You have not configured any devices yet to be backed up!!!', 'Information!!!', {allowHtml: true});
                    }
                }else{
                    $('.devicesList').hide();
                    $('.devicesListTableNavigate').hide();
                    $('.status').show();
                    $('.status').html('<h4>No Devices have been configured yet</h4>');
		    //toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    /*configure users start*/
    $scope.pickElement = function(value, index){
                $scope.selectedRow = index;
                $scope.picked = value;
        };

        $scope.addName = function(){
                if($scope.addedSites.indexOf($scope.picked) == '-1'){
                        $scope.addedSites.push($scope.picked);
                        //console.log("addedSites : "+$scope.addedSites);
                }
        };

        $scope.pickElement1 = function(value, index){
                $scope.selectedRow1 = index;
                $scope.picked1 = value;
        };

        $scope.removeName = function(){
                var index = $scope.addedSites.indexOf($scope.picked1); // get index if value found otherwise -1
                if (index > -1) { //if found
                        $scope.addedSites.splice(index, 1);
                }
                //console.log("final list of Elements : "+$scope.addedSites);
        };
function orderKeys(obj, expected) {
console.log("inside sortttt");
  var keys = Object.keys(obj).sort(function keyOrder(k1, k2) {
      if (k1 < k2) return -1;
      else if (k1 > k2) return +1;
      else return 0;
  });

  var i, after = {};
  for (i = 0; i < keys.length; i++) {
    after[keys[i]] = obj[keys[i]];
    delete obj[keys[i]];
  }

  for (i = 0; i < keys.length; i++) {
    obj[keys[i]] = after[keys[i]];
  }
  return obj;
}
	$scope.itemSelect1 = function(){
        	//var all = $("input.select-all")[0];
            	var total = $("input.select-item").length;
            	var len = $("input.select-item:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-item:checkbox:checked').map(function () {
			//console.log("value to be added : "+this.value);
			/*remove login starts*/
			var index = $scope.discoveredSites.indexOf(this.value); // get index if value found otherwise -1
			if (index > -1) { //if found
				$scope.discoveredSites.splice(index, 1);
				$scope.addedSites = $scope.addedSites.concat(this.value);
$scope.aad[this.value] = '';
let sampleObjectKeys = Object.keys($scope.aad);
$scope.siteMapKeys = sampleObjectKeys;
console.log("before sortt");
$scope.aad = Object.keys($scope.aad).sort(Intl.Collator().compare).reduce(
  (obj, key) => {
    obj[key] = $scope.aad[key];
    return obj;
  },
  {}
);
/*$scope.aad = sorted = Object.keys($scope.aad)
    .sort()
    .reduce((acc, key) => ({
        ...acc, [key]: $scope.aad[key]
    }), {});*/
//$scope.aad = Object.entries($scope.aad).sort((a,b)=> a[1]-b[1]);
				console.log("$scope.aad : "+$scope.aad);
				console.log("$scope.aad : "+JSON.stringify($scope.aad));
				$scope.addedSites = $scope.addedSites.sort();
				$scope.discoveredSites = $scope.discoveredSites.sort();
			}
			/*remove logic ends*/
			return this.value;
        	}).get();
        	usersSelected = arr;
	};

	$scope.removeName1 = function(){
		//var all = $("input.select-all")[0];
            	var total = $("input.select-itemright").length;
            	var len = $("input.select-itemright:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-itemright:checkbox:checked').map(function () {
			/*remove login starts*/
			var index = $scope.addedSites.indexOf(this.value); // get index if value found otherwise -1
			var finalIndex;
			console.log("value : "+this.value);
			delete $scope.aad[this.value];
			let sampleObjectKeys = Object.keys($scope.aad);
$scope.siteMapKeys = sampleObjectKeys;
$scope.aad = Object.keys($scope.aad).sort(Intl.Collator().compare).reduce(
  (obj, key) => {
    obj[key] = $scope.aad[key];
    return obj;
  },
  {}
);
			if (index > -1) { //if found
				$scope.addedSites.splice(index, 1);
				$scope.discoveredSites = $scope.discoveredSites.concat(this.value);
				$scope.discoveredSites = $scope.discoveredSites.sort();
				$scope.addedSites = $scope.addedSites.sort();
			}
			/*remove logic ends*/
            	return this.value;
        	}).get();
        	usersSelected = arr;
        };

	$scope.removeAllName = function(){
		$scope.discoveredSites = $scope.discoveredSites.concat($scope.addedSites);
		$scope.discoveredSites = $scope.discoveredSites.sort();
		$scope.addedSites = [];
		$scope.aad = {};
		let sampleObjectKeys = Object.keys($scope.aad);
$scope.siteMapKeys = sampleObjectKeys;
        };

	$scope.addAllName = function(){
		console.log("addallnamessss");
		$scope.addedSites = $scope.addedSites.concat($scope.discoveredSites);
		$scope.addedSites = $scope.addedSites.sort();
//		$scope.discoveredSites = [];
		$scope.discoveredSites.forEach(function(value){
                        $scope.aad[value] = '';
		});
		let sampleObjectKeys = Object.keys($scope.aad);
		$scope.aad = Object.keys($scope.aad).sort(Intl.Collator().compare).reduce(
  (obj, key) => {
    obj[key] = $scope.aad[key];
    return obj;
  },
  {}
);
		$scope.siteMapKeys = sampleObjectKeys;
		$scope.discoveredSites = [];
        };

    $scope.readUserNamesFromExcelMsp = function(files) {
	//$('.bulkUserPanel').hide();
        angular.forEach(files, function(file, key) {
            if (file && !file.$error) {
                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUploadCreateUsersMsp',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });
                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
				    $scope.bulkCreate(response.data.userList);
				    //$scope.bulkCreate(JSON.stringify(response.data.userList));
				    /*$scope.discoveredSites = $scope.discoveredSites.concat(response.data.userNames);
				    console.log("hhhhhhhh");
				    $('.bulkUserPanel').show()*/;
				    $scope.$apply();
                                /*response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#userNames').tagsinput('add', value);
                                    }
                                });*/

                                toastr.success('Usernames has been imported from the excel', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });
                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });
            }
        });
    };

    $scope.bulkCreate = function(devices){
        var devices = devices;
        if(devices != null){
            var html;
            console.log("bulk_create_1 " +devices);
            $.ajax({
                url: $scope.BASE_FOLDER+'/bulkCreate',
                data: {devices: devices, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log("inside jData : "+jData)
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        location.reload();
                    }, 3000);
                    }
                else if(jData.result == 'Not_created'){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    $scope.not_created = jData.users;
                    $('.uncreatedUsers').show();
                    $('#uncreatedDump').show();
                    document.getElementById("uncreatedDumpStatement").innerHTML = "One or more users cannot be created. Click on Download list to view details.";
                    }
                else if(jData.result == 'User_Limit_Exceeded'){
                    $('.uncreatedUsers').hide();
                    toastr.error(jData.msg+'<b>The number of permissible users is '+jData.noOfPossibleUsers+ '</b>', 'Fail!!!', {allowHtml: true});
                    }
                else{
                    $('.uncreatedUsers').hide();
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };
    /*configure users end*/

    $scope.addUsers = function(){
	var val = $('.addNewUser').val();
	$scope.discoveredSites.push(val);
	$('.addNewUser').val('');
	console.log("$scope.discoveredSites : "+$scope.discoveredSites);
    };

$scope.addUserRow = function(){
$('.addUserRow').show();
$('.addUserBtnRow').hide();

};

$scope.addUserCancel = function(){
$('.addUserRow').hide();
$('.addUserBtnRow').show();
$('#newemailId').val('');
};

$scope.downloadSampleMsp = function(type){
        window.location.href = $scope.BASE_FOLDER+'/migration/downloadSampleMsp';
    };

    $scope.showMappingListUsers = function(userName){
        $('.mappingRowUsers'+userName+' .policyNameUsers span').hide();
        $('.mappingRowUsers'+userName+' .policyNameUsers .selectPolicy').show();
        $('.mappingRowUsers'+userName+' .editUsers').hide();
        $('.mappingRowUsers'+userName+' .saveUsers').show();
        $('.mappingRowUsers'+userName+' .cancelUsers').show();
        var value = $('.mappingRowUsers'+userName+' .policyNameUsers span').html();
        $('#userPolicyMappingPolicyNameUsers'+userName+' option[value="'+value+'"]').prop('selected', true);
    };

    $scope.cancelChangePolicyUsers = function(userName){
        $('.mappingRowUsers'+userName+' .policyNameUsers span').show();
        $('.mappingRowUsers'+userName+' .policyNameUsers .selectPolicy').hide();
        $('.mappingRowUsers'+userName+' .editUsers').show();
        $('.mappingRowUsers'+userName+' .saveUsers').hide();
    };

        $scope.changePolicyUsers = function($index,oldPolicyName){
        /*var finalIndex;
	var userName = $('.actualUserName'+$index).html();*/
        var oldPolicyName = oldPolicyName;
	var newPolicyName = $('[name="userPolicyMappingPolicyNameUsers'+$index+'"]').val();
	$('.oldPolicyUsers'+$index).html(newPolicyName);
	$('.mappingRowUsers'+$index+' .policyNameUsers span').show();
                $('.mappingRowUsers'+$index+' .policyNameUsers .selectPolicy').hide();
                $('.mappingRowUsers'+$index+' .editUsers').show();
                $('.mappingRowUsers'+$index+' .saveUsers').hide();
	toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
        /*$.ajax({
            url: $scope.BASE_FOLDER+'/pms/policyMapping/single/save',
            data: {csrf_token: $('.csrf_token').html(), userName: userName, oldPolicyName: oldPolicyName, newPolicyName: newPolicyName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    userName = userName.replace(/\&amp;/g,"&");
                $scope.userPolicyMappingUsers.forEach(function(message, index) {
                    Object.keys(message).forEach(function(prop) {
			    console.log("prop : "+message[prop]);
                if(message[prop] == userName){
                finalIndex = index;
                }
                    });
                });
                $scope.userPolicyMappingUsers[finalIndex].backupPolicyName = newPolicyName;
                $scope.$apply();
		$('.mappingRow'+$index+' .policyName span').show();
                $('.mappingRow'+$index+' .policyName form').hide();
                $('.mappingRow'+$index+' .action .edit').show();
                $('.mappingRow'+$index+' .action .save').hide();
                toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });*/
    };

    $scope.updateMultipleUsersMsp = function(){
	console.log("came inside scope.saveUsers");
  	var data = [];
  	var name, email, policy;
  	$(".userListTable tbody .updatedUser").each(function(index) {
    		name = $(this).find('.gotemail').val();
    		email = $(this).find('.gotemail').val();
    		policy = $(this).find('.userPolicy').val();
    		//---->Form validation goes here
    		data.push({
      			userName: name,
      			emailId: email,
      			policyName: policy
    		});
  	});
  	console.log("data : "+data);
  	console.log("stringify : "+JSON.stringify(data));
    	$.ajax({
                url: $scope.BASE_FOLDER+'/user/updateMultipleMspUser',
		data: {csrf_token: $('.csrf_token').html(),users: data},
                type: 'POST',
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
		    setTimeout(function(){
                        location.reload(true);
                    }, 3000);
//                    var filePath = jData.filePath;
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>','Fail!!!', {allowHtml: true});
		if(data.status == 424){
                setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    function isSpecialCharForEmailEdit(val) {
        val = val.replace(/\s/g,'');
        var regex = /[*|+=?\/]/gi;
                if(regex.test(val)){
                    $('[name="newemailId"]').popover('show');
                    return false;
                }
                else{
                    $('[name="newemailId"]').popover('hide');
                    return true;
                }
    }

    function IsEmail(email) {
            var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if (!regex.test(email)) {
                return false;
            }
            else {
                return true;
            }
        }

    $scope.addSingleMspUser = function(){
	    var emailId = $('#newemailId').val();            
                if(IsEmail(emailId) == false){
			console.log("ifff");
                	//$("#newemailId").focus();
                	$('[name="newemailId"]').addClass('parsley-error');
			$('[name="newemailId"]').popover('show');
                	return;
		}else{
			console.log("else");
			$('[name="newemailId"]').removeClass('parsley-error');
			$('[name="newemailId"]').addClass('parsley-success');
			$('[name="newemailId"]').popover('hide');
		}
	    var data = [];	    
  	    var userName, emailId, policyName;
    	    userName = $('#newemailId').val();
    	    emailId = $('#newemailId').val();
    	    policyName = $('#newpolicy').val();
    	    //---->Form validation goes here
    	    data.push({
      		emailId: emailId,
      		userName: userName,
      		policyName: policyName
    	    });
	    console.log("stringify : "+JSON.stringify(data));
	    $.ajax({
                url: $scope.BASE_FOLDER+'/user/addSingleMspUser',
                data: {csrf_token: $('.csrf_token').html(),user: data},
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                console.log("hhh" +jData);
                console.log("hhh77" +data);
                if(jData.result == 'success'){
                    toastr.success(jData.message, 'Successful!!!');
                    //$('.UserSave').removeAttr('disabled');
                    //$('.UserSave').html(html);

                    if(jData.data == 'false'){
                        $('.account_type').addClass('hide');
                        $('.sync_access').addClass('hide');
                        $('.backup').addClass('hide');
                        $('.miniCloudName').addClass('hide');
                        $('.share_enabled').addClass('hide');
                    }else{
                        //$('.account_type').removeClass('hide');
                        //$('.sync_access').removeClass('hide');
                        //$('.backup').removeClass('hide');
                        //$('.miniCloudName').removeClass('hide');
                        //$('.share_enabled').removeClass('hide');
                    }
			$scope.updateUsers('all', 1);
                    setTimeout(function(){
                       //location.reload();
                    }, 3000);

                }else if(jData.result == 'fieldFail'){
                    $('.error').show();
                    for(var key in jData.msg){
                        if (jData.msg.hasOwnProperty(key)) {
                            if($('.error').html() != ''){
                                $('.error').append('<br/>'+jData.msg[key]);
                            }else{
                                $('.error').html(jData.msg[key]);
                            }
                            $('[name="'+key.toLowerCase()+'"]').removeClass('parsley-success');
                            $('[name="'+key.toLowerCase()+'"]').addClass('parsley-error');
                        }
                    }
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                }else if(jData.result == 'Not_created'){
			toastr.error('User limit reached. '+jData.msg, 'Fail!!!', {allowHtml: true});

		}else{
                    /*$('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                    $('.error').hide();*/
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
		    $('.addUserRow').hide();
		    $('.addUserBtnRow').show();
		    $('#newemailId').val('');
		    $('[name="newemailId"]').removeClass('parsley-error');
                    $('[name="newemailId"]').removeClass('parsley-success');
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $scope.updateStatisticsMSP = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/statisticsMSP',
            data: {secret: '',csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statistics = jData.statistics;
            if(jData.alert == 'yes'){
                $('#storageAlert').show();
                document.getElementById('storagePercentage').innerHTML = jData.percentage;
            }
            if(jData.alertUser == 'yes'){
                $('#userAlert').show();
                document.getElementById('userPercentage').innerHTML = jData.percentageUser;
            }
            $scope.$apply();
            $('.widget a').removeClass('d-none');
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }
        });
    };

    $scope.downloadSampleExcel = function(type){
        switch (type) {
            case 'bulkcreateusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBulkcreateusersSample';
                break;
            case 'bulkblockusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBlockUnblockDeleteusersSample';
                break;
            case 'bulkdeleteunblockusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBlockUnblockDeleteusersSample';
                break;
            case 'downloadDump':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadDump';
                break;
        }
    };

    $scope.blockUserProfile = function(selectedUser, confirmed, isSite){
        $('.loading').html('Loading ...');
	if(selectedUser == $('.uploadUserName').html()){
                toastr.error('This operation cannot be performed, Please ask some other administrator to perform the operation', 'Fail!!!', {allowHtml: true});
                return;
        }
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: Base64.encode(decodeURIComponent(userName)), blockUser: 'false', csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = false;
                    }else{
			if(isSite == 'site'){
                        $scope.sites.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.sites[key].isActive = false;
                            }
                        });
		    	}else{
			$scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = false;
                            }
                        });
			}
                    }
                    $scope.$apply();
                    toastr.success('User "'+decodeURIComponent(userName)+'" has been Inactivated successfully.', 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

        $scope.unBlockUserProfile = function(selectedUser, confirmed, isSite){
        $('.loading').html('Loading ...');
	$scope.operatedUser = selectedUser;
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: Base64.encode(decodeURIComponent(userName)), blockUser: 'true', csrf_token: $('.csrf_token').html(), revokeOwners: 'false'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = true;
                    }else{
			if(isSite == 'site'){
                        $scope.sites.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.sites[key].isActive = true;
                            }
                        });
			}else{
			$scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = true;
                            }
                        });
			}
                    }
                    $scope.$apply();
		    $scope.operatedUser = '';
                    toastr.success('User "'+decodeURIComponent(userName)+'" has been Reactivated successfully.', 'Successful!!!', {allowHtml: true});
                }else if(jData.result == 'fail_revokeOwners'){
                        $('#confirmUnblock').modal('show');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.deleteUserProfile = function(selectedUser, confirmed, isSite){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/delete',
                data: {userName: Base64.encode(decodeURIComponent(userName)), blockUser: 'true', csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(isNaN(selectedUser)){
                        toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                        setTimeout(function(){
                            location.reload(true);
                        }, 3000);
                        //window.location.href = $scope.BASE_FOLDER+'/users';
                    }else{
			if(isSite == 'site'){
                        $scope.sites.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.sites.splice(key, 1);
                            }
                        });
			}else{
			$scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users.splice(key, 1);
                            }
                        });
			}
                        toastr.success('User "'+decodeURIComponent(userName)+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                    }
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
                $scope.$apply();
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.closeMSPUsers = function(){
	location.reload(true);
        //$('.edittUsers').hide();
        //$scope.updateUsers('all', 1);
     };

    var Base64 = {
    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        input = Base64._utf8_encode(input);
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }
            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
},
    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        while (i < input.length) {
            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;
            output = output + String.fromCharCode(chr1);
            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }
        }
        output = Base64._utf8_decode(output);
        return output;
    },
    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";
        for (var n = 0; n < string.length; n++) {
            var c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    },
    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;
        while (i < utftext.length) {
        c = utftext.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');
        return string;
    }

    $scope.exportUsersToExcelModal = function(){
        //$('.exportUsersToExcelModal').modal('show');
    };

    $scope.exportUsersToExcel = function(){
        //$('.exportUsersToExcelModal').modal('hide');
        var userName = '';
        var radioValueUsers = $("input[name='optradioUsers']:checked").val();
        if(radioValueUsers == 'allUsers'){
		var onlyActiveUsers = 'false';
        }else{
                var onlyActiveUsers = 'true';
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/exportUsers',
            data: {csrf_token: $('.csrf_token').html() , userName : userName, onlyActiveUsers: onlyActiveUsers},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/user/downloadUsersExcel';
                toastr.success('Users List Exported', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
	    }
        });
    };

    $('#selectAssignUsersMsp').on('change', function(){
        var userName = $('#selectAssignUsersMsp').val();
        $('.loading').html('Loading ...');
        if(userName.length == 0 || userName == 'all'){
            userName = 'all';
            $scope.users = [];
            $scope.searchUserName='';
            $scope.skipValue = 0;
            $scope.updateUsers('all', 1);
        }else{
            $scope.searchUserName=userName;
            $scope.updateUsers(userName, 1);
         }
    });

/*event hub start*/
    $scope.logAction = function(deviceId, deviceType){
console.log("deviceType : "+deviceType);
	    console.log("deviceId : "+deviceId);
        var finalIndex;
        $scope.devices.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                    finalIndex = index;
                }
            });
        });
if(deviceType == "ONEDRIVE" || deviceType == "OUTLOOK" || deviceType == "SHAREPOINT"){
$('.agLogs').addClass('hide');
$('.fBackup').show();
$('.stopBackupWhileRestoreBlock').addClass('hide');
}
        $scope.selectedDevice = $scope.devices[finalIndex];
        $('#startBackup').removeAttr('disabled');
        $('#stopBackup').removeAttr('disabled');
        $('#pauseBackup').removeAttr('disabled');
        $('#cancelBackup').removeAttr('disabled');
        $('.deviceLogs').modal('show');
	$('#startRestore').removeAttr('disabled');
        $('#stopRestore').removeAttr('disabled');
//        $('#pauseRestore').removeAttr('disabled');
        $('#cancelRestore').removeAttr('disabled');
        $.ajax({
            url: $scope.BASE_FOLDER+'/eventHub',
            data: {deviceId:deviceId },
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            document.getElementById('actionToDeviceUUID').innerHTML = jData.actionToDeviceUUID;
	    document.getElementById('deviceType').innerHTML = deviceType;
            $("#actionToDeviceUUID").val(jData.actionToDeviceUUID);
	    if(jData.isFullBkpRunning == 'true'){
		$('#fullBackup').bootstrapToggle('on');
		$('#fullBackup').attr("disabled","disabled");
	    }else{
		$('#fullBackup').bootstrapToggle('off');
		$('#fullBackup').removeAttr("disabled","disabled");
	    }
	    if(jData.isPrevBkpPaused == 'true'){
		$('#fullBackup').attr("disabled","disabled");
		$('.ios').attr("data-original-title", "Already previous backup has been paused.");
		$('.ios').attr("data-placement", "bottom");
            }else{
		$('#fullBackup').removeAttr("disabled","disabled");
		$('#fullBackup').attr("title", "");
	    }		
            $('#startBackup').hide();
            $('#stopBackup').hide();
	    $('#pauseBackup').hide();
            $('#backupPolicyRefresh').bootstrapToggle('off');
            $('#agentLogs').bootstrapToggle('off');
            $('#cancelBackup').hide();
            $('#startBackup').val('No');
            $('#stopBackup').val('No');
            $('#cancelBackup').val('No');
	    $('#startRestore').hide();
	    $('#stopRestore').hide();
	    //$('#pauseRestore').hide();
	    $('#cancelRestore').hide();
	    $('#startRestore').val('No');
	    $('#stopRestore').val('No');
	    $('#cancelRestore').val('No');
            $scope.currentBackup=jData.currentBackup;
	    $scope.currentRestore=jData.currentRestore;
            if(jData.eventHub.length>0){
              console.log(JSON.stringify(jData.eventHub));
		if(jData.eventHub.includes("BACKUPPOLICY_REFRESH")){
                        $('#backupPolicyRefresh').bootstrapToggle('on');
                }
                if(jData.eventHub.includes("START_BACKUP")){
		      $("#startBackupGet").val('yes');
 		      $scope.buttonValue="cancelBackup";	
                      $("#cancelBackup").show();		      
                }else{
		    document.getElementById("startBackupGet").value = "no";
                    if($scope.currentBackup){
                       $scope.buttonValue="stopBackup";
                       $scope.buttonPauseValue="pauseBackup";
                       $("#stopBackup").show();
                       $("#pauseBackup").show();
                    }
                    else{
 		      $scope.buttonValue="startBackup";
                      $("#startBackup").show();
                    }
                }
		if(jData.eventHub.includes("START_RESTORE")){
        		$("#startRestoreGet").val('yes');
        		document.getElementById("startRestoreGet").value = "yes";
		}else{
			document.getElementById("startRestoreGet").value = "no";
		}
		    /*restore start*/
                    if(jData.eventHub.includes("RESTORE_CREATED")){
                      $scope.buttonValueRestore="cancelRestore";
                      $("#cancelRestore").show();

                }else{
                    if($scope.currentRestore){
                       $scope.buttonValueRestore="stopRestore";
//                       $scope.buttonPauseValueRestore="pauseRestore";
                       $("#stopRestore").show();
//                       $("#pauseRestore").show();
                    }
                    else{
                      $scope.buttonValueRestore="startRestore";
                      $("#startRestore").show();
                    }
                }
                    /*restore end*/
                if(jData.eventHub.includes("PULL_AGENTLOGS")){
                  $('#agentLogs').bootstrapToggle('on');
                }
                if(jData.eventHub.includes("PULL_HISTORICAL_LOGS")){
                  $('#agentLogs').bootstrapToggle('on');
                  $('#historicalLogs').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("SETUP_LOGS")){
                    $('#setupLogs').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("DATABASES")){
                    $('#databases').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("STOP_BACKUP_WHILE_RESTORE")){
                    document.getElementById('stopBackupWhileRestore').checked=true;
                }else{
                    document.getElementById('stopBackupWhileRestore').checked=false;
                }
            }
            else{
                 if($scope.currentBackup){
		                $scope.buttonValue="stopBackup";
                        $scope.buttonPauseValue="pauseBackup";
                        $("#stopBackup").show();
                        $("#pauseBackup").show();
                  }
                 else{
		            $scope.buttonValue="startBackup";
                    $("#startBackup").show();
                 }   
/*restore start*/
if($scope.currentRestore){
                                $scope.buttonValueRestore="stopRestore";
  //                      $scope.buttonPauseValueRestore="pauseRestore";
                        $("#stopRestore").show();
    //                    $("#pauseRestore").show();
                  }
                 else{
                            $scope.buttonValueRestore="startRestore";
                    $("#startRestore").show();
                 }

/*restore end*/
            }
            if(jData){
                $('#saveBtn').addClass('disabled');
                if(jData.status == 'SCANNING' && jData.action == null){
                    console.log("iiiiii");
                    $scope.buttonValue="stopBackup";
                    $scope.buttonPauseValue="pauseBackup";
                    $("#stopBackup").show();
                    $("#pauseBackup").show();
                }
                if(jData.status == 'SCANNING' && jData.action == 'STOP_BACKUP'){
                    console.log("inside scanning & stop");
                    $('#stopBackup').addClass("disabled");
                    $scope.buttonValue="stopBackup";
                    $("#stopBackup").show();
                    $('#stopBackup').css('opacity', '0.4');
                    $('#stopBackup').addClass("disabled");
                    $('#pauseBackup').hide();
                    disableStop();
                }
                if(jData.status == 'SCANNING' && jData.action == 'PAUSE_BACKUP'){
                    console.log("inside scanning & pause");
                    $scope.buttonPauseValue="pauseBackup";
                    $('#pauseBackup').addClass("disabled");
                    $("#pauseBackup").show();
                    $('#stopBackup').hide();
                    disablePause();
                }
		if(jData.isAllowBackup == 'false'){
                            console.log("got isAllowBackup as false");
                            $('.startBackup').addClass("disabled");
                            $scope.isAllowBackup = 'false';
                }
		if(jData.status == 'SCANNING'){
                	$scope.buttonPauseValue='';
                }
                $scope.$apply();
                /*if(jData.status == 'SCANNING'){
                    $('#pauseBackup').hide();
                }*/
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    function disableStop(){
        setTimeout(function(){
        $('#stopBackup').attr("disabled","disabled");
                }, 1000);
    }

    function disablePause(){
        setTimeout(function(){
        $('#pauseBackup').attr("disabled","disabled");
                    }, 1000);
    }

    $scope.saveEventHub = function(){
          var actionToDeviceUUID = $('#actionToDeviceUUID').html();
          var startBackup=$("#startBackup").val();
          var stopBackup=$("#stopBackup").val();
          var pauseBackup=$("#pauseBackup").val();
          var cancelBackup=$("#cancelBackup").val();
            if($('#deviceType').html() == "ONEDRIVE" || $('#deviceType').html() == "OUTLOOK"){
                if($('#fullBackup').is(':checked') && $("#startBackup").val() === ""){
                    console.log("inside condi");
                    toastr.error('Please Start Backup before saving', 'Fail!!!', {allowHtml: true});
                    return false;
                }
            }
            console.log("startBackup : "+startBackup);
            console.log("stopBackup : "+stopBackup);
            console.log("cancelBackup : "+cancelBackup);
 	        console.log("pauseBackup : "+pauseBackup);
           if($("#cancelBackup").is(":visible") && cancelBackup==="No"){
             if($scope.currentBackup){
                stopBackup="true";
                pauseBackup="true";
             }
             else{
                 startBackup="Yes";
             }
           }
/*restore start*/
            var startRestore=$("#startRestore").val();
          var stopRestore=$("#stopRestore").val();
      //    var pauseRestore=$("#pauseRestore").val();
          var cancelRestore=$("#cancelRestore").val();

if($("#cancelRestore").is(":visible") && cancelRestore==="No"){
             if($scope.currentRestore){
                stopRestore="true";
//                pauseRestore="true";
             }
             else{
                 startRestore="Yes";
             }
           }
/*restore end*/
	    var startBackupGet = $("#startBackupGet").val();
	    var startRestoreGet = $("#startRestoreGet").val();
            var backupPolicyRefresh = $("#backupPolicyRefresh").val();
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveEventHub',
                //data: {deviceid : $('#actionToDeviceUUID').html(), name : $('#actionToUserName').html()},
                data: $('.eventHubForm').serialize()+'&actionToDeviceUUID='+actionToDeviceUUID+'&startBackup='+startBackup+'&stopBackup='+stopBackup+'&pauseBackup='+pauseBackup+'&cancelBackup='+cancelBackup+'&startRestore='+startRestore+'&stopRestore='+stopRestore+'&cancelRestore='+cancelRestore+'&startBackupGet='+startBackupGet+'&backupPolicyRefresh='+backupPolicyRefresh+'&startRestoreGet='+startRestoreGet,
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.unblockdeleteusers').show();
                    $('.unblock').removeAttr('disabled');
                    $('.delete').removeAttr('disabled');
                    toastr.success('Your request has been Queued.', 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $('#modalClose').click(function (){
    console.log("clicked");
    window.location.reload(true);
    });
    
    $('#modalCloseX').click(function (){
    console.log("clicked");
    window.location.reload(true);
    });

    $scope.startBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#startBackup').val('Yes');
        $('#startBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.stopBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#stopBackup').val('true');
        $('#stopBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.pauseBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#pauseBackup').val('true');
        $('#pauseBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
 
    $scope.cancelBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#cancelBackup').val('Yes');
        $('#cancelBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
/*event hub end*/

    $scope.blockUnBlockDevice = function(deviceUUID, action,userName, deviceName, isSite){
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/blockUnBlockDevice',
            data: {deviceUUID: deviceUUID, action: action, csrf_token: $('.csrf_token').html(),userName : userName, deviceName : deviceName, revokeOwners: 'false'},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(action == false){
			toastr.success('The selected device has been Reactivated successfully', 'Successful!!!', {allowHtml: true});
		}else{
			toastr.success('The selected device has been Inactivated successfully', 'Successful!!!', {allowHtml: true});
		}
                //toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		setTimeout(function(){
                    window.location.reload(true);
                }, 3000);
                $scope.$apply();
            }else if(jData.result == 'fail_revokeOwners'){
                $('#confirmUnblockDevice').modal('show');
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.deleteDevice = function(deviceUUID,userName, deviceName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/deleteDevice',
            data: {deviceUUID: deviceUUID, csrf_token: $('.csrf_token').html(),userName : userName, deviceName : deviceName},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                $scope.$apply();
                setTimeout(function(){
                    window.location.reload(true);
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openFilesPage = function(deviceId, deviceName, deviceUUID, deviceType, deviceOS, userName, blocked, unusualActivity){
            var isblocked;
            if(blocked == 'true'){
            	isblocked = 'blocked';
            }else{
            	isblocked = 'active';
            }
	    if(unusualActivity == 'true' || unusualActivity == 'unusual'){
            	var unusualActivity = 'unusual';
            }else{
            	var unusualActivity = 'usual';
            }
	    deviceName = deviceName.replaceAll(' ','_PB_');
            deviceType = deviceType.replaceAll(' ','_PB_');
            deviceOS = deviceOS.replaceAll(' ','_PB_');
        window.location.href = $scope.BASE_FOLDER+'/backup/files/'+deviceId+'/'+deviceName+'/'+deviceUUID+'/'+deviceType+'/'+deviceOS+'/'+userName+'/'+isblocked+'/'+unusualActivity;
    };


     $scope.changePasswordMsp = function(){
        var password = $('#password').val();
        var rePassword = $('#rePassword').val();
        var html = $('#changePasswordBtn').html();
        $('#changePasswordBtn').attr('disabled','disabled');
        $('#changePasswordBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if ( $('#changePasswordForm').parsley().isValid() && password == rePassword) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePassword',
                data: $('#changePasswordForm').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePassword').modal('hide');
                    $('#changePasswordBtn').html('Saved <i class="fa fa-check"></i>').animate();
                    toastr.success('Password Successfully changed', 'Success!!!');
                    $('#changePasswordBtn').html(html);
                    $('#changePasswordBtn').removeAttr('disabled');
                    $('#oldpassword').val('');
                    $('#password').val("");
                    $('#rePassword').val("");                    
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);
                }else if(jData.result == 'captchaFail'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    toastr.error('Captcha validation failed.', 'Fail!!!');
//                    $('#oldpassword').addClass('parsley-error');
//                    $('#oldpassword').val('');
                    $('#changePasswordBtn').html(html);
                    $('#changePasswordBtn').removeAttr('disabled');
 /*                   setTimeout(function(){
                        $('#changePassword').modal('hide');
                        location.reload();
                    }, 3000);*/
                }else if(jData.result == 'operation failed'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    toastr.error('Operation failed.', 'Fail!!!');                        
                    $('#oldpassword').addClass('parsley-error');
                    $('#oldpassword').val('');
                    $('#changePasswordBtn').html(html);
                    $('#changePasswordBtn').removeAttr('disabled');
                    setTimeout(function(){
                        $('#changePassword').modal('hide');
                        location.reload();
                    }, 3000);
                }else if(jData.result == 'oldNewSame'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old & New password cannot be same', 'Fail!!!');
                        $('#password').addClass('parsley-error');
                        $('#rePassword').addClass('parsley-error');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old & New password cannot be same', 'Fail!!!');
                        $('#password').addClass('parsley-error');
                        $('#rePassword').addClass('parsley-error');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

/*$('a[data-toggle="tab"]').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
    });

    $('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
        var id = $(e.target).attr("id");
        localStorage.setItem('selectedTab', id)
    });

    var selectedTab = localStorage.getItem('selectedTab');

    if (selectedTab != null) {
        $('a[data-toggle="tab"][href="' + selectedTab + '"]').tab('show');
	    $('#userM').removeClass('active');
	    $('#policyM').removeClass('active');
	    $('#deviceM').removeClass('active');
	    $('#reportM').removeClass('active');
	    $('#user').removeClass('active');
            $('#policy').removeClass('active');
            $('#device').removeClass('active');
            $('#report').removeClass('active');
	    $('#'+selectedTab).addClass('active');
	    var selectedTabN = selectedTab.replace("M", "");
	    $('#'+selectedTabN).addClass('active');
    }*/

    $scope.initiateBackupMSP = function(uuId){ 
        $.ajax({
            url: $scope.BASE_FOLDER+'/saveEventHubMsp',
            data: {csrf_token: $('.csrf_token').html() , actionToDeviceUUID:uuId},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success('Your request has been Queued.', 'Successful!!!', {allowHtml: true});
		setTimeout(function(){
			location.reload();
		}, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserDevicePolicyInfoMsp = function(deviceUUID){
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfoMsp',
            data: {csrf_token: $('.csrf_token').html(), currentDeviceUUID : deviceUUID},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('#foldersMsp').modal('show');
/*              $scope.currentUser.maxSizeAllowed = jData.maxSizeAllowed;
                $scope.currentUser.defaultFolders = jData.defaultFolders;
                $scope.currentUser.fileTypes = jData.fileTypes;
                $scope.currentUser.filterType = jData.filterType;
                $scope.currentUser.userDefinedFolders = jData.userDefinedFolders;
                $scope.currentUser.userExcludedFolders = jData.userExcludedFolders;
                $scope.currentUser.canAdminRestore = jData.canAdminRestore;
                $scope.currentUser.userSQLBackupFolders = jData.userSQLBackupFolders;
                $scope.currentUser.fromFilter = jData.fromFilter;
                $scope.currentUser.toFilter = jData.toFilter;
                $scope.currentUser.subjectFilter = jData.subjectFilter;*/
                $scope.defaultFoldersMspList = jData.defaultFolders
                $scope.maxSizeAllowedMsp = jData.maxSizeAllowed;
                $scope.fileTypesMsp = jData.fileTypes;
                $scope.filterTypeMsp = jData.filterType;
                $scope.userDefinedFoldersMsp = jData.userDefinedFolders;
                $scope.userExcludedFoldersMsp = jData.userExcludedFolders;
/*              if(jData.canAdminRestore == true){
                        $('.canAdminRestore').find('option[value="true"]').prop("selected",true);
                }else{
                        $('.canAdminRestore').find('option[value="false"]').prop("selected",true);
                }
		if(jData.showdisableAdminRestore == false){
                        $('.showdisableAdminRestore').hide();
                }*/
                $scope.$apply();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    /*new mockup end*/

    $scope.updateDeviceOverview = function(userName, from, to,deviceName,policyName){
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        $('.deviceOverviewError').show();
        $('.deviceOverview').hide();
           return;
        }
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        if(userName == undefined){
            userName = "null";
        }
    	if(userName == "? undefined:undefined ?"){
            userName = "";
        }
	console.log("policy : "+policyName);
	console.log("scope222 : "+$scope.policyName);
	$scope.policyName = policyName;
	console.log("scope333 : "+$scope.policyName);
	if($scope.policy == 'true'){
	policyName = policyName;
	console.log("$scope.policywwwww : "+$scope.policy);
	}
	else{
	policyName = 'all';
	}
	console.log("$scope.policyeeeeeee : "+$scope.policy);
	if($scope.all == 'all'){
	policyName = 'all';
	}
	else{
	policyName = policyName;
	}
	$('.deviceOverviewError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }
    	$('.first').hide();
    	//$('.self').hide();
    	$('.previous').hide();
    	$('.next').hide();
    	$('.last').hide();
    	var pageNumber = $scope.pageNumber;
    	policyName = $('#searchPolicyName').val();
        var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
        blockUI.start();
        var currentRunningBackups = $("#currentRunningBackups").prop('checked');
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceOverview',
            data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(), pageNumber:pageNumber, reportProductType: $('.reportProductType').html(), currentRunningBackups: currentRunningBackups},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceOverview == null || jData.deviceOverview.length <= 0){
                    $('.deviceOverviewError').show();
                    $('.deviceOverview').hide();
                }else{
                    $('.deviceOverviewError').hide();
                    $('.deviceOverview').show();
                }
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
		$('.first').show();
		}
		/*if($scope.self){
		$('.self').show();
		}*/
		if($scope.previous){
		$('.previous').show();
		}
		if($scope.next){
		$('.next').show();
		}
		if($scope.last){
		$('.last').show();
		}
		$scope.deviceOverview = jData.deviceOverview;
		$scope.totalCompletedStatusCount = jData.totalCompletedStatusCount;
		//$scope.pageNumber = pageNumber+1;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateDeviceOverviewNavigate = function(userName, from, to,deviceName,policyName,url){
        if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        $('.deviceOverviewError').show();
        $('.deviceOverview').hide();
           return;
        }
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        if(userName == undefined){
            userName = "null";
        }
    	if(userName == "? undefined:undefined ?"){
            userName = "";
        }
	console.log("policy : "+policyName);
	console.log("scope222 : "+$scope.policyName);
	$scope.policyName = policyName;
	console.log("scope333 : "+$scope.policyName);
	if($scope.policy == 'true'){
	policyName = policyName;
	console.log("$scope.policywwwww : "+$scope.policy);
	}
	else{
	policyName = 'all';
	}
	console.log("$scope.policyeeeeeee : "+$scope.policy);
	if($scope.all == 'all'){
	policyName = 'all';
	}
	else{
	policyName = policyName;
	}
	$('.deviceOverviewError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    
    	policyName = $('#searchPolicyName').val();
    	var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
	blockUI.start();
	var currentRunningBackups = $("#currentRunningBackups").prop('checked');
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceOverview1',
            data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(),url:url, reportProductType: $('.reportProductType').html(), currentRunningBackups: currentRunningBackups},
            type: 'POST'
        }).done(function(data){
            $('.downloadButton').show();
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceOverview == null || jData.deviceOverview.length <= 0){
                    $('.deviceOverviewError').show();
                    $('.deviceOverview').hide();
                }else{
                    $('.deviceOverviewError').hide();
                    $('.deviceOverview').show();
                }
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
		$('.first').show();
		}else{
		$('.first').hide();
		}
		if($scope.previous){
		$('.previous').show();
		}else{
		$('.previous').hide();
		}
		if($scope.next){
		$('.next').show();
		}
		if($scope.last){
		$('.last').show();
		}else{
		$('.last').hide();
		}
                $scope.deviceOverview = jData.deviceOverview;
                $scope.totalCompletedStatusCount = jData.totalCompletedStatusCount;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.downloadDeviceOverviewExcel = function(from, to, userName, deviceName, skipValue,policyName){
         var myBlockUI = blockUI.instances.get('myBlockUI');
         myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            	toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        	$('.deviceOverviewError').show();
        	$('.deviceOverview').hide();
           	return;
        }
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        if(userName == undefined){
            userName = "null";
        }
    	if(userName == "? undefined:undefined ?"){
            userName = "";
	}
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
	$('.deviceOverviewError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    	
    	policyName = $('#searchPolicyName').val();
    	var from = $('#from').val();
        var to = $('#to').val(); 
        from = getMeDate(from);
        to = getMeDate(to);
	var currentRunningBackups = $("#currentRunningBackups").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/deviceOverviewReportExcel',
             data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(),reportProductType: $('.reportProductType').html(), currentRunningBackups: currentRunningBackups},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             $('.loading').hide();
             blockUI.stop();
             myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
             	window.location.href = $scope.BASE_FOLDER+'/report/downloadDeviceOverviewReportToExcel';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
          }).fail(function(data){
             myBlockUI.stop();
            $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
     
     $scope.downloadDeviceOverviewPdf = function(from, to, userName, deviceName, skipValue,policyName){
         var myBlockUI = blockUI.instances.get('myBlockUI');
         myBlockUI.start();
         if($('.selectPicker').selectpicker('val') == null && $('input[name=userOption]:checked').val() == 'policy'){
            	toastr.error('Please select atleat one Backup PolicyName.', 'Fail!!!', {allowHtml: true});
        	$('.deviceOverviewError').show();
        	$('.deviceOverview').hide();
           	return;
        }
        var deviceName = $('.searchDeviceName').val();
        var userName = $('.searchUsername').val();
        if(userName == undefined){
            userName = "null";
        }
    	if(userName == "? undefined:undefined ?"){
            userName = "";
        }
	$scope.policyName = policyName;
	if($scope.policy == 'true'){
		policyName = policyName;
	}else{
		policyName = 'all';
	}
	if($scope.all == 'all'){
		policyName = 'all';
	}else{
		policyName = policyName;
	}
	$('.deviceOverviewError').hide();
        $('.loading').show();
        policyName = $('.selectPicker').selectpicker('val');
        var i = policyName.indexOf("all");
        if(i != -1) {
                policyName.splice(i, 1);
        }    
    	policyName = $('#searchPolicyName').val();
    	var from = $('#from').val();
        var to = $('#to').val();        
        from = getMeDate(from);
        to = getMeDate(to);
    	var currentRunningBackups = $("#currentRunningBackups").prop('checked');
         $.ajax({
             url: $scope.BASE_FOLDER+'/report/download/deviceOverviewReportPdf',
             data: {userName: userName, from: from, to: to, deviceName: deviceName,policyName: policyName, csrf_token: $('.csrf_token').html(), reportProductType: $('.reportProductType').html(), currentRunningBackups: currentRunningBackups},
             type: 'POST'
         }).done(function(data){
             console.log(data);
             $('.downloadButton').show();
             $('.loading').hide();
             blockUI.stop();
             myBlockUI.stop();
             $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
             	window.location.href = $scope.BASE_FOLDER+'/report/downloadDeviceOverviewReportToPdf';
                 toastr.success('Report generated', {allowHtml: true});
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
             $scope.$apply();
         }).fail(function(data){
             myBlockUI.stop();
             $('.col-lg-11').removeClass('block-ui-active block-ui-visible"');
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };

$('a[data-toggle="tab"]').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
    });

    $('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
        var id = $(e.target).attr("id");
        localStorage.setItem('selectedDashTab', id)
    });

    var selectedTab = localStorage.getItem('selectedDashTab');

    if (selectedTab != null) {
        $('a[data-toggle="tab"][href="' + selectedTab + '"]').tab('show');
            $('#backupT').removeClass('active');
            $('#exchangeT').removeClass('active');
            $('#sharepointT').removeClass('active');
            $('#onedriveT').removeClass('active');
            $('#backup').removeClass('active');
            $('#exchange').removeClass('active');
            $('#sharepoint').removeClass('active');
            $('#onedrive').removeClass('active');
            $('#'+selectedTab).addClass('active');
            var selectedTabN = selectedTab.replace("T", "");
            $('#'+selectedTabN).addClass('active');
    }

/*$('#searchSharepointPolicyName').on('change', function () {
    // Get the selected values
    const selectedValues = $(this).val();

    // If "all" is not in the selected values and everything else is deselected
    if (!selectedValues || (selectedValues.length === 1 && selectedValues[0] !== 'all')) {
      // Select "all"
      $(this).val('all');
    }
  });

$('#searchODBPolicyName').on('change', function () {
    // Get the selected values
    const selectedValues = $(this).val();

    // If "all" is not in the selected values and everything else is deselected
    if (!selectedValues || (selectedValues.length === 1 && selectedValues[0] !== 'all')) {
      // Select "all"
      $(this).val('all');
    }
  });

$('#searchExchangePolicyName').on('change', function () {
    // Get the selected values
    const selectedValues = $(this).val();

    // If "all" is not in the selected values and everything else is deselected
    if (!selectedValues || (selectedValues.length === 1 && selectedValues[0] !== 'all')) {
      // Select "all"
      $(this).val('all');
    }
  });

$('#searchPolicyName').on('change', function () {
    // Get the selected values
    const selectedValues = $(this).val();

    // If "all" is not in the selected values and everything else is deselected
    if (!selectedValues || (selectedValues.length === 1 && selectedValues[0] !== 'all')) {
      // Select "all"
      $(this).val('all');
    }
  });*/

$scope.changeTab = function(tabName) {
        // Function to be called when a tab is clicked
        $scope.activeTab = tabName;
        // You can perform any other logic here
        $scope.updateStatisticsOneDrive(tabName);
        /*if(tabName == 'ODB'){
                $scope.updateStatisticsOneDrive();
        }
        if(tabName == 'Sharepoint'){
                $scope.updateStatisticsSharepoint();
        }*/
    };

}]);
