/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('MigrationController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.sortType = 'userName';
    $scope.currentPage = $('.currentPage').html();
    $scope.migrationDetails = {};
    $scope.userList = [];
    $scope.policy = '';
    $scope.selectedPolicy = '';

    $scope.updateMigrationDetails = function(){
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/migration',
            data: {secret: 'asd', csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            $scope.migrationDetails.noOfUsersMigrated = jData.details.headers.container.noOfUsersMigrated;
            $scope.migrationDetails.noOfBSInstalled = jData.details.headers.container.noOfBSInstalled;
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getUsers = function(policyName, syncPolicy, exchangePolicy , sharepointPolicy, onedrivePolicy){
        var userList = $('#userNames').tagsinput('items');
        if($('#relax').val() != 'relaxed'){
            var count = 0;
            for(var i=0;i<userList.length;i++){
                var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(userList[i])){
                    count = count+1;
                }
            }
            if(count >0){
                toastr.error("Only allowed special characters are '@','_' and '.' Any other special characters are not allowed.", 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        var cloudType = $('#migrationType').val();
	if(cloudType == ''){
                toastr.info('Please select Migration Type', 'Information!!!', {allowHtml: true});
                return;
        }
        if(cloudType == 'backup'){
            if(!policyName){
                toastr.info('Please select a BluVault Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //syncPolicy = null;
        }else if(cloudType == 'sync'){
            if(!syncPolicy){
                toastr.info('Please select a BluSync Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //policyName = null;
        }/*else if(cloudType == 'o365'){
            if(!o365policy){
                toastr.info('Please select a Office 365 Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            policyName = null;
        }*/else if(cloudType == 'exchange'){
            if(!exchangePolicy){
                toastr.info('Please select a Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //exchangePolicy = null;
        }else if(cloudType == 'onedrive'){
            if(!onedrivePolicy){
                toastr.info('Please select a OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //onedrivePolicy = null;
        }else if(cloudType == 'sharepoint'){
            if(!sharepointPolicy){
                toastr.info('Please select a Sharepoint Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //sharepointPolicy = null;
        }else if(cloudType == 'both'){
	     if($("#policy").length > 0){
                if(!policyName){
                    toastr.info('Please select BluVault Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#exchangePolicy").length > 0){
                if(!exchangePolicy){
                    toastr.info('Please select Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#onedrivePolicy").length > 0){
                if(!onedrivePolicy){
                    toastr.info('Please select OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#sharepointPolicy").length > 0){
                if(!sharepointPolicy){
                    toastr.info('Please select Sharepoint Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#syncPolicy").length > 0){
                if(!syncPolicy){
                    toastr.info('Please select BluSync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             } 

            /*if($("#policy").length > 0 && $("#exchangePolicy").length > 0 && $("#onedrivePolicy").length > 0 && $("#sharepointPolicy").length > 0 && $("#syncPolicy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!syncPolicy){
                    toastr.info('Please select Sync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!o365policy){
                    toastr.info('Please select Office 365 Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
		if(!exchangePolicy){
                    toastr.info('Please select a Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
		if(!onedrivePolicy){
                    toastr.info('Please select a OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
		if(!sharepointPolicy){
                    toastr.info('Please select a Sharepoint Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
            }
            if($("#policy").length > 0 && $("#o365policy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!o365policy){
                    toastr.info('Please select Office 365 Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
            }
            if($("#policy").length > 0 && $("#syncPolicy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!syncPolicy){
                    toastr.info('Please select Sync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
            }*/
        }
        if(userList.length > 0){
            blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/getUsers',
                data: {csrf_token: $('.csrf_token').html(), userList: $('#userNames').tagsinput('items'), policyName: policyName, syncPolicy: syncPolicy, defaultOdbPolicy : onedrivePolicy, defaultExchangePolicy: exchangePolicy, defaultSharepointPolicy: sharepointPolicy, migrationType: cloudType},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log(jData);
                if(jData.result == 'success'){
                    $scope.currentGroupName = jData.groupName.groupName;
                    $scope.userList = jData.userList;
                    $('.migrationDetails').show();
                    $scope.$apply();
                }else if(jData.result == 'fail'){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }else if(jData.result == 'fail_unable'){
                     toastr.error('Unable to Migrate the users. Please verify the following:<br> Domain name<br> Password<br> Common Name<br> Base', 'Fail!!!', {allowHtml: true});
                }else{
                    if($scope.userList.length > 0){
                        $('.migrationDetails').hide();
                    }
                    toastr.error('Entered Users was not found', 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('Please enter the users list that has to be migrated', 'Information!!!', {allowHtml: true});
        }
    };
    
    $scope.getUsersAAD = function(policyName, syncPolicy, exchangePolicy , sharepointPolicy, onedrivePolicy){
        var userList = $('#userNames').tagsinput('items');
        if($('#relax').val() != 'relaxed'){
            var count = 0;
            for(var i=0;i<userList.length;i++){
                var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(userList[i])){
                    count = count+1;
                }
            }
            if(count >0){
                toastr.error("Only allowed special characters are '@','_' and '.' Any other special characters are not allowed.", 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        var cloudType = $('#migrationType').val();
	if(cloudType == ''){
                toastr.info('Please select Migration Type', 'Information!!!', {allowHtml: true});
                return;
        }
        if(cloudType == 'backup'){
            if(!policyName){
                toastr.info('Please select a BluVault Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //syncPolicy = null;
        }else if(cloudType == 'sync'){
            if(!syncPolicy){
                toastr.info('Please select a BluSync Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //policyName = null;
        }/*else if(cloudType == 'o365'){
            if(!o365policy){
                toastr.info('Please select a Office 365 Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            policyName = null;
        }*/else if(cloudType == 'exchange'){
            if(!exchangePolicy){
                toastr.info('Please select a Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //exchangePolicy = null;
        }else if(cloudType == 'onedrive'){
            if(!onedrivePolicy){
                toastr.info('Please select a OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //onedrivePolicy = null;
        }else if(cloudType == 'sharepoint'){
            if(!sharepointPolicy){
                toastr.info('Please select a Sharepoint Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            //sharepointPolicy = null;
        }else if(cloudType == 'both'){
	     if($("#policy").length > 0){
                if(!policyName){
                    toastr.info('Please select BluVault Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#exchangePolicy").length > 0){
                if(!exchangePolicy){
                    toastr.info('Please select Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#onedrivePolicy").length > 0){
                if(!onedrivePolicy){
                    toastr.info('Please select OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#sharepointPolicy").length > 0){
                if(!sharepointPolicy){
                    toastr.info('Please select Sharepoint Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             }
             if($("#syncPolicy").length > 0){
                if(!syncPolicy){
                    toastr.info('Please select BluSync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
             } 

            /*if($("#policy").length > 0 && $("#exchangePolicy").length > 0 && $("#onedrivePolicy").length > 0 && $("#sharepointPolicy").length > 0 && $("#syncPolicy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!syncPolicy){
                    toastr.info('Please select Sync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!o365policy){
                    toastr.info('Please select Office 365 Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
		if(!exchangePolicy){
                    toastr.info('Please select a Microsoft Exchange Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
		if(!onedrivePolicy){
                    toastr.info('Please select a OneDrive for Business Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
		if(!sharepointPolicy){
                    toastr.info('Please select a Sharepoint Policy', 'Information!!!', {allowHtml: true});
                    return;
            	}
            }
            if($("#policy").length > 0 && $("#o365policy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!o365policy){
                    toastr.info('Please select Office 365 Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
            }
            if($("#policy").length > 0 && $("#syncPolicy").length > 0){
                if(!policyName){
                    toastr.info('Please select Backup Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
                if(!syncPolicy){
                    toastr.info('Please select Sync Policy', 'Information!!!', {allowHtml: true});
                    return;
                }
            }*/
             }
             if(userList.length > 0){
             	blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/getUsersAAD',
                data: {csrf_token: $('.csrf_token').html(), userList: $('#userNames').tagsinput('items'), policyName: policyName, syncPolicy: syncPolicy, defaultOdbPolicy : onedrivePolicy, defaultExchangePolicy: exchangePolicy, defaultSharepointPolicy: sharepointPolicy,migrationType: cloudType},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log(jData);
                //$scope.currentGroupName = jData.groupName.groupName;
                if(jData.result == 'success'){
                    $scope.userList = jData.userList;
                    $('.migrationDetails').show();
                    $scope.$apply();
                }else if(jData.result == 'fail'){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }else{
                    if($scope.userList.length > 0){
                        $('.migrationDetails').hide();
                    }
                    toastr.error('Entered Users was not found', 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('Please enter the users list that has to be migrated', 'Information!!!', {allowHtml: true});
        }
    };

    $scope.changePolicy = function(policy, index){
        $('.selectedPolicySpan'+index).hide();
        $('.selectPolicyPicker'+index).show();
        $('.changePolicyBtn'+index).hide();
        $('.savePolicyBtn'+index).show();
        $('[name="selectedPolicy'+index+'"]').val(policy);
    };

    $scope.savePolicy = function(index){
        $('.selectedPolicySpan'+index).show();
        $('.selectPolicyPicker'+index).hide();
        $('.changePolicyBtn'+index).show();
        $('.savePolicyBtn'+index).hide();
        $scope.userList[index].defaultPolicy = $('[name="selectedPolicy'+index+'"]').val();
    };

    $scope.removeRow = function(index){
        $('.selectedPolicySpan'+index).show();
        $('.selectPolicyPicker'+index).hide();
        $('.changePolicyBtn'+index).show();
        $('.savePolicyBtn'+index).hide();
        $scope.userList.splice(index, 1);
        toastr.success('Selected user has been removed from the migrations list', 'Information!!!', {allowHtml: true});
    };

    $scope.changeSyncPolicy = function(policy, index){
        $('.selectedSyncPolicySpan'+index).hide();
        $('.selectSyncPolicyPicker'+index).show();
        $('.changeSyncPolicyBtn'+index).hide();
        $('.saveSyncPolicyBtn'+index).show();
        $('[name="selectedSyncPolicy'+index+'"]').val(policy);
    };

    $scope.saveSyncPolicy = function(index){
        $('.selectedSyncPolicySpan'+index).show();
        $('.selectSyncPolicyPicker'+index).hide();
        $('.changeSyncPolicyBtn'+index).show();
        $('.saveSyncPolicyBtn'+index).hide();
        $scope.userList[index].defaultSyncPolicy = $('[name="selectedSyncPolicy'+index+'"]').val();
    };
    
    $scope.changeOdbPolicy = function(policy, index){
        $('.selectedOdbPolicySpan'+index).hide();
        $('.selectOdbPolicyPicker'+index).show();
        $('.changeOdbPolicyBtn'+index).hide();
        $('.saveOdbPolicyBtn'+index).show();
        $('[name="selectedOdbPolicy'+index+'"]').val(policy);
    };

    $scope.saveOdbPolicy = function(index){
        $('.selectedOdbPolicySpan'+index).show();
        $('.selectOdbPolicyPicker'+index).hide();
        $('.changeOdbPolicyBtn'+index).show();
        $('.saveOdbPolicyBtn'+index).hide();
        $scope.userList[index].defaultOdbPolicy = $('[name="selectedOdbPolicy'+index+'"]').val();
    };

    $scope.changeSharepointPolicy = function(policy, index){
        $('.selectedSharepointPolicySpan'+index).hide();
        $('.selectSharepointPolicyPicker'+index).show();
        $('.changeSharepointPolicyBtn'+index).hide();
        $('.saveSharepointPolicyBtn'+index).show();
        $('[name="selectedSharepointPolicy'+index+'"]').val(policy);
    };

    $scope.saveSharepointPolicy = function(index){
        $('.selectedSharepointPolicySpan'+index).show();
        $('.selectSharepointPolicyPicker'+index).hide();
        $('.changeSharepointPolicyBtn'+index).show();
        $('.saveSharepointPolicyBtn'+index).hide();
        $scope.userList[index].defaultSharepointPolicy = $('[name="selectedSharepointPolicy'+index+'"]').val();
    };

    $scope.changeExchangePolicy = function(policy, index){
        $('.selectedExchangePolicySpan'+index).hide();
        $('.selectExchangePolicyPicker'+index).show();
        $('.changeExchangePolicyBtn'+index).hide();
        $('.saveExchangePolicyBtn'+index).show();
        $('[name="selectedExchangePolicy'+index+'"]').val(policy);
    };

    $scope.saveExchangePolicy = function(index){
        $('.selectedExchangePolicySpan'+index).show();
        $('.selectExchangePolicyPicker'+index).hide();
        $('.changeExchangePolicyBtn'+index).show();
        $('.saveExchangePolicyBtn'+index).hide();
        $scope.userList[index].defaultExchangePolicy = $('[name="selectedExchangePolicy'+index+'"]').val();
    };

    $scope.startMigrating = function(){
        var migrationType = $('#migrationType').val();
        if($scope.userList.length > 0){
            blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/migrateUsers',
                data: {csrf_token: $('.csrf_token').html(), userList: $scope.userList, migrationType: migrationType, groupName: $scope.currentGroupName},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/migration'
                    }, 2000);
                } else if(data.status == 417){
                    toastr.info(jData.msg,  {allowHtml: true});
                }
                else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('No users found for migration', 'Fail!!!', {allowHtml: true});
        }
    };
    
    $scope.startMigratingAAD = function(){
        var migrationType = $('#migrationType').val();
        if($scope.userList.length > 0){
            blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/migrateUsersAAD',
                data: {csrf_token: $('.csrf_token').html(), userList: $scope.userList, migrationType: migrationType},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/migration'
                    }, 2000);
                } else if(data.status == 417){
                    toastr.info(jData.msg,  {allowHtml: true});
                }
                else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('No users found for migration', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.gotTo = function(location){
        window.location.href = $scope.BASE_FOLDER+location;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'migrationDashboard'){
            $scope.updateMigrationDetails();
        }
    });
    
    $scope.downloadSample = function(type){
        window.location.href = $scope.BASE_FOLDER+'/migration/downloadSample';
    };

    $scope.readUserNamesFromExcel = function(files) {
        angular.forEach(files, function(file, key) {
            if (file && !file.$error) {
                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUpload',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });
                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#userNames').tagsinput('add', value);
                                    }
                                });

                                toastr.success('Usernames has been imported from the excel, please click on "import" and continue with the migration proccess', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });
                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });
            }
        });
    };

}]);
