<?php
/**
 * Created by PhpStorm.
 * User: parablu-dev
 * Developer: Prashanth Kumar B
 * Date: 6/10/15
 * Time: 12:41 PM
 */


//create alias for Router
use Core\Router;
use Helpers\Hooks;

//module routes
$hooks = Hooks::get();
$hooks->run('routes');

/* Amazon */
Router::get('amazon/create', 'AmazonController@create');
Router::post('amazon/create', 'AmazonController@saveCloud');
Router::post('amazon/saveUser', 'AmazonController@amazonSaveUser');
Router::post('checkCloudName', 'AmazonController@checkCloudName');

Router::post('up', 'SyncController@upload12');
Router::post('del', 'SyncController@delete12');

Router::get('', 'IndexController@index');
Router::get('dashboard', 'IndexController@index');
Router::get('auth', 'LoginController@authFromAgent');
Router::post('passwordRest', 'LoginController@passwordRest');
Router::get('restPassword', 'LoginController@restPassword');
Router::post('updatePassword', 'LoginController@updatePassword');

Router::post('setSessionForRedirect', 'MechanicController@setSessionForRedirect');
Router::post('getBestBlukrypt', 'MechanicController@getBestBlukrypt');

/* User Related Routes */
Router::get('userGroup', 'UserController@createUserGroup');
Router::post('deleteUserGroup', 'UserController@deleteUserGroup');
Router::get('user/create', 'UserController@createUser');
Router::post('user/create', 'UserController@saveNewUserDetails');
Router::get('users', 'UserController@users');
Router::post('users', 'UserController@getAllUsers');
Router::get('users/usersBulkBlockDelete', 'UserController@usersBulkBlockDelete');
Router::post('user/changePassword', 'UserController@changePassword');
Router::post('user/resetPassword', 'UserController@resetPassword');
Router::post('user/changePasswordForGuest', 'UserController@changePasswordForGuest');
Router::post('user/devices', 'UserController@getAllUserDevices');
Router::get('user/device/policyInfo/(:any)/(:any)/(:any)', 'DeviceController@getDevicePolicyInformation');
Router::post('user/device/policyInfo', 'DeviceController@getCurrentDeviceIDInformation');
Router::post('user/device/policyInfo/addInclusionFolder', 'DeviceController@addInclusionFolder');
Router::post('user/device/policyInfo/removeInclusionFolder', 'DeviceController@removeInclusionFolder');
Router::post('user/device/policyInfo/addExclusionFolder', 'DeviceController@addExclusionFolder');
Router::post('user/device/policyInfo/removeExclusionFolder', 'DeviceController@removeExclusionFolder');
Router::post('device/remoteWipe', 'DeviceController@remoteWipe');
Router::post('user/exportUsers', 'UserController@exportUsersToExcel');
Router::get('user/downloadUsersExcel', 'UserController@downloadUsersToExcel');
Router::get('user/downloadSample', 'UserController@downloadSample');
Router::post('user/getSoftDeleteUsers', 'UserController@getSoftDeleteUsers');

Router::get('user/backupHistory/(:any)/(:any)/(:any)', 'HistoryController@backupHistory');
Router::post('user/backupHistory', 'HistoryController@getBackupHistory');
Router::post('user/backupHistoryDetails', 'HistoryController@getBackupHistoryDetails');
Router::get('activityHistory', 'HistoryController@activityHistory');
Router::post('activityHistory', 'HistoryController@getActivityHistory');

Router::get('backup/files/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)', 'BackupController@files');
Router::get('backup/files/restore/(:any)/(:any)/(:any)', 'BackupController@restoreFiles');
Router::post('backup/files', 'BackupController@getFiles');
Router::post('backup/restore', 'BackupController@initiateRestore');
Router::post('backup/files/fileVersions', 'BackupController@getFileVersions');
Router::post('backup/files/fileChunks', 'BackupController@getFileChunks');
Router::post('backup/file/delete', 'BackupController@backupFileDelete');
Router::post('backup/files/sendFilesForRestore', 'BackupController@initiateRestore');
Router::post('backup/files/checkRestoreProgress', 'BackupController@checkRestoreProgress');
Router::get('backup/devices', 'BackupController@devices');
Router::post('backup/devices', 'BackupController@getDevices');
Router::post('backup/files/share', 'BackupController@shareFile');
Router::post('backup/files/updateSharePolicy', 'BackupController@updateSharePolicy');
Router::post('backup/files/unShare', 'BackupController@unShare');
Router::get('myAccount', 'UserController@myAccount');
Router::get('myAccount/(:any)', 'UserController@myAccount');
Router::get('myAccount/(:any)/(:any)', 'UserController@myAccount');
Router::any('user/settings', 'UserController@settings');
Router::any('user/settings/(:any)', 'UserController@settings');
Router::post('user/device/deviceDetails', 'UserController@deviceDetails');
Router::post('user/save', 'UserController@saveUserDetails');
Router::post('user/block', 'UserController@block');
Router::post('user/delete', 'UserController@delete');
Router::post('user/allNames', 'UserController@getAllUserNames');
Router::get('user/searchUserName', 'UserController@searchUsers');
Router::get('user/searchUserWithDevice', 'UserController@searchUserWithDevice');
Router::get('user/searchUserWithDeviceOwner', 'UserController@searchUserWithDeviceOwner');
Router::get('user/searchUserWithDeviceForRestore', 'UserController@searchUserWithDeviceForRestore');
Router::get('user/getAllBlockedUsers', 'UserController@getAllBlockedUsers');
Router::get('user/getAllUnBlockedUsersWithLoggedInUser', 'UserController@getAllUnBlockedUsersWithLoggedInUser');
Router::get('user/getAllUnBlockedUsers', 'UserController@getAllUnBlockedUsers');
Router::post('users/deleteMultipleUsers', 'UserController@deleteMultipleUsers');
Router::post('users/blockMultipleUsers', 'UserController@blockMultipleUsers');
Router::post('blockUsers', 'UserController@blockUsers');
Router::post('unblockUsers', 'UserController@unblockUsers');
Router::post('bulkCreate', 'UserController@bulkCreate');
Router::get('userGroups/getAllUnBlockedUsersWithGroups', 'UserController@getAllUnBlockedUsersWithGroups');

Router::get('devices', 'DeviceController@devices');
Router::post('eventHub', 'DeviceController@eventHub');
Router::post('saveEventHub', 'DeviceController@saveEventHub');
Router::get('device/searchDevices', 'DeviceController@searchDevices');
Router::post('devices', 'DeviceController@getAllDevices');
Router::post('device/blockUnBlockDevice', 'DeviceController@blockUnBlockDevice');
Router::post('blockDevices', 'DeviceController@blockDevices');
Router::post('blockDevices1', 'DeviceController@blockDevices1');
Router::post('device/deleteDevice', 'DeviceController@deleteDevice');
Router::get('devices/devicesBulkBlock', 'DeviceController@devicesBulkBlock');
Router::post('device/blockMultipleDevices', 'DeviceController@blockMultipleDevices');
Router::post('device/deleteMultipleDevices', 'DeviceController@deleteMultipleDevices');
Router::get('device/getAllBlockedDevices', 'DeviceController@getAllBlockedDevices');
Router::get('device/getAllUnBlockedDevices', 'DeviceController@getAllUnBlockedDevices');
Router::post('device/exportDevices', 'DeviceController@exportDevicesToExcel');
Router::get('device/downloadDevicesExcel', 'DeviceController@downloadDevicesToExcel');
Router::post('device/changeDeviceOwner', 'DeviceController@changeDeviceOwner');
Router::post('device/getDeviceOwner', 'DeviceController@getDeviceOwner');

/* Policy management System */
Router::get('pms', 'PmsController@pms');
Router::get('pms/schedule/create', 'PmsController@createSchedule');
Router::get('pms/schedules', 'PmsController@schedules');
Router::post('pms/schedule', 'PmsController@getSchedule');
Router::post('pms/getParticularSchedule', 'PmsController@getParticularSchedule');
Router::post('pms/schedule/save', 'PmsController@saveSchedule');
Router::post('pms/schedule/saveEdit', 'PmsController@saveScheduleEdit');
Router::post('pms/schedules', 'PmsController@getSchedules');
Router::post('schedule/delete', 'PmsController@deleteSchedule');
Router::post('pms/getGlobalExclusions', 'PmsController@getGlobalExclusions');
Router::post('sync/getSyncRevisionId', 'SyncController@getSyncRevisionId');

Router::get('pms/filter/create', 'PmsController@createFilter');
Router::get('pms/filters', 'PmsController@filters');
Router::post('pms/filter/save', 'PmsController@saveFilter');
Router::post('pms/filter/saveEdit', 'PmsController@saveFilterEdit');
Router::post('pms/filter', 'PmsController@getFilter');
Router::post('pms/filters', 'PmsController@getFilters');

Router::get('pms/filter/create', 'PmsController@createFilter');
Router::get('pms/filter/edit', 'PmsController@editFilter');
Router::post('pms/filter/save', 'PmsController@saveFilter');
Router::post('pms/filter', 'PmsController@getFilter');
Router::post('pms/filters', 'PmsController@getFilters');
Router::post('filter/delete', 'PmsController@deleteFilter');

Router::get('pms/policy/create', 'PmsController@createPolicy');
Router::get('pms/policy/edit/(:any)', 'PmsController@editPolicy');
Router::get('pms/policies', 'PmsController@polices');
Router::post('pms/policy/save', 'PmsController@savePolicy');
Router::post('pms/policy/saveEdit', 'PmsController@savePolicyEdit');
Router::post('pms/policy', 'PmsController@getPolicy');
Router::post('pms/user/policy', 'PmsController@getUserPolicy');
Router::post('pms/policies', 'PmsController@getPolicies');
Router::post('pms/viewpolicy', 'PmsController@viewPolicy');
Router::get('pms/policy/clone/(:any)', 'PmsController@clonePolicy');
Router::post('policy/block', 'PmsController@blockPolicy');
Router::post('odbpolicy/block', 'PmsController@blockOdbPolicy');

Router::get('pms/policyMapping/single','PmsController@singlePolicyMapping');
Router::get('pms/policyMapping/multiple','PmsController@multiplePolicyMapping');
Router::get('pms/policyMapping/server/multiple','PmsController@serverMultiplePolicyMapping');
Router::get('pms/policyMapping/server/single','PmsController@serverSinglePolicyMapping');
Router::post('pms/policyMapping/server/single','PmsController@getServerPolicyMappingList');
Router::post('pms/policyMapping/single','PmsController@getPolicyMappingDetails');
Router::post('pms/policyMapping/single/save','PmsController@saveSinglePolicyMapping');
Router::post('pms/policyMapping/server/save','PmsController@saveServerPolicyMapping');
Router::post('pms/policyMapping/multiple/save','PmsController@saveMultiplePolicyMapping');

Router::get('pms/sync/policy/create', 'SyncPmsController@createPolicy');
Router::get('pms/sync/policy/edit/(:any)', 'SyncPmsController@editPolicy');
Router::get('pms/sync/policies', 'SyncPmsController@polices');
Router::post('pms/sync/policy/save', 'SyncPmsController@savePolicy');
Router::post('pms/sync/policy/saveEdit', 'SyncPmsController@savePolicyEdit');
Router::post('pms/sync/policy', 'SyncPmsController@getPolicy');
Router::post('pms/sync/user/policy', 'SyncPmsController@getUserSyncPolicy');
Router::post('pms/sync/policies', 'SyncPmsController@getPolicies');

Router::get('pms/sync/policyMapping/single','SyncPmsController@singlePolicyMapping');
Router::get('pms/sync/policyMapping/multiple','SyncPmsController@multiplePolicyMapping');
Router::post('pms/sync/policyMapping/single','SyncPmsController@getPolicyMappingDetails');
Router::post('pms/sync/policyMapping/single/save','SyncPmsController@saveSinglePolicyMapping');
Router::post('pms/sync/policyMapping/multiple/save','SyncPmsController@saveMultiplePolicyMapping');
Router::post('pms/sync/viewpolicy', 'SyncPmsController@viewPolicy');
Router::get('pms/sync/policy/clone/(:any)', 'SyncPmsController@clonePolicy');
Router::post('syncpolicy/block', 'SyncPmsController@blockPolicy');

/*User Based file Actions*/
Router::any('upload', 'UserController@upload');

/* Authentication Related Routes */
Router::get('login', 'LoginController@index');
Router::get('sleep', 'LoginController@sleep');
Router::post('login', 'LoginController@authenticate');
Router::get('locallogin', 'LoginController@indexSSO');
Router::get('success', 'LoginController@success');
Router::get('ssoLogin', 'LoginController@ssoLogin');
Router::get('mfa', 'LoginController@mfa');
Router::post('mfaAuthenticate', 'LoginController@mfaAuthenticate');

Router::get('captcha', 'LoginController@captcha');
Router::post('captchaAuthenticate', 'LoginController@captchaAuthenticate');

Router::get('password-rest', 'LoginController@passwordReset');
Router::get('logout', 'LoginController@logout');

Router::get('report/dashboard', 'ReportController@dashboard');
Router::get('report/statistics', 'ReportController@statistics');
Router::post('report/statistics', 'ReportController@getStatistics');
Router::post('report/statistics/serverBackup', 'ReportController@getServerBackupStatistics');
Router::get('report/overview/(:any)', 'ReportController@overview');
Router::post('report/overview', 'ReportController@getOverview');
Router::get('report/syncOverview', 'ReportController@syncOverview');
Router::post('report/syncOverview', 'ReportController@getSyncOverview');
Router::get('report/longBackup', 'ReportController@longBackup');
Router::post('report/longBackup', 'ReportController@getLongBackup');
Router::get('report/currentBackup', 'ReportController@currentBackup');
Router::post('report/currentBackup', 'ReportController@getCurrentBackup');
Router::get('report/noBackup/(:any)', 'ReportController@noBackup');
Router::post('report/noBackup', 'ReportController@getNoBackup');
Router::get('report/usersNoBackup/(:any)', 'ReportController@usersNoBackup');
Router::post('report/usersNoBackup', 'ReportController@getUsersNoBackup');
Router::post('report/usersNoBackup1', 'ReportController@getUsersNoBackup1');
Router::get('report/lastAgentServerConnectionDetails/(:any)', 'ReportController@lastAgentServerConnectionDetails');
Router::post('report/lastAgentServerConnectionDetails', 'ReportController@getLastAgentServerConnectionDetails');
Router::post('report/downloadAgentNotHeardReport', 'ReportController@downloadAgentNotHeardReport');
Router::get('report/downloadAgentNotHeardReportExcel', 'ReportController@downloadAgentNotHeardReportExcel');
Router::get('report/userBackupSummary/(:any)', 'ReportController@userBackupSummary');
Router::post('report/userBackupSummary', 'ReportController@getUserBackupSummary');
Router::post('report/downloadUserBackupSummaryReport', 'ReportController@downloadUserBackupSummaryReport');
Router::get('report/downloadUserBackupSummaryReportExcel', 'ReportController@downloadUserBackupSummaryReportExcel');
Router::get('report/restoreByDate/(:any)', 'ReportController@restoreByDate');
Router::get('report/restoreByUser', 'ReportController@restoreByUsername');
Router::get('report/restoreByDevice', 'ReportController@restoreByDevice');
Router::post('report/restoreHistory', 'ReportController@getRestoreHistory');
Router::post('saveEventHubCurrentBackup', 'ReportController@saveEventHubCurrentBackup');

Router::get('report/storageUtilizedByUser', 'ReportController@storageUtilizedByUser');
Router::get('report/storageUtilizedByDevice', 'ReportController@storageUtilizedByDevice');
Router::post('report/storageUtilized', 'ReportController@getStorageUtilized');
Router::get('report/storageUtilizedByPG', 'ReportController@storageUtilizedByPG');
Router::post('report/storageUtilizedByPG', 'ReportController@getStorageUtilizedByPG');
Router::get('report/failedBackup/(:any)', 'ReportController@failedBackup');
Router::post('report/failedBackup', 'ReportController@getFailedBackup');
Router::get('report/failedBackupByUser', 'ReportController@failedBackupByUser');
Router::get('report/failedBackupByDevice', 'ReportController@failedBackupByDevice');
Router::post('report/failedBackupByUserOrDevice', 'ReportController@getFailedBackupByUserOrDevice');
Router::get('report/incompleteBackup/(:any)', 'ReportController@incompleteBackup');
Router::post('report/incompleteBackup', 'ReportController@getIncompleteBackup');
Router::post('report/incompleteBackup1', 'ReportController@getIncompleteBackup1');
Router::get('report/storageTrend', 'ReportController@storage');
Router::post('report/storageTrend', 'ReportController@getStorageTrend');
Router::get('report/blobTrend', 'ReportController@blobTrend');
Router::post('report/blobTrend', 'ReportController@getBlobTrend');
Router::get('report/backupTrend', 'ReportController@backupTrend');
Router::post('report/backupTrend', 'ReportController@getBackupTrend');
Router::get('report/userDeviceHistory', 'ReportController@userDeviceHistory');
Router::post('report/userDeviceHistory', 'ReportController@getUserDeviceHistory');
Router::get('report/userBackupHistory/(:any)', 'ReportController@userBackupHistory');
Router::post('report/userBackupHistory', 'ReportController@getUserBackupHistory');
Router::get('report/dailyUserBackupOverview/(:any)', 'ReportController@dailyUserBackupOverview');
Router::post('report/getDailyUserBackupOverview', 'ReportController@getDailyUserBackupOverview');
Router::post('report/downloadDailyUserBackupOverview', 'ReportController@downloadDailyUserBackupOverview');
Router::get('report/downloadDailyUserBackupOverviewExcel', 'ReportController@downloadDailyUserBackupOverviewExcel');
Router::get('report/deviceUserHistory', 'ReportController@deviceUserHistory');
Router::post('report/deviceUserHistory', 'ReportController@getDeviceUserHistory');
Router::get('report/deviceBackupHistory', 'ReportController@deviceBackupHistory');
Router::post('report/deviceBackupHistory', 'ReportController@getDeviceBackupHistory');
Router::get('report/lastBackupByUser', 'ReportController@lastBackupByUser');
Router::get('report/lastBackupByDevice', 'ReportController@lastBackupByDevice');
Router::post('report/lastBackupDetails', 'ReportController@getLastBackupDetails');
Router::get('report/alertByDevice', 'ReportController@alertByDevice');
Router::get('report/alertByUser', 'ReportController@alertByUser');
Router::get('report/alertByDate', 'ReportController@alertByDate');
Router::post('report/alertHistory', 'ReportController@getAlertHistory');
Router::get('report/userMigration', 'ReportController@userMigration');
Router::post('report/userMigration', 'ReportController@getUserMigration');
//Router::post('report/download/overviewReport', 'ReportController@downloadOverViewReport');
Router::get('report/download/syncOverviewReport', 'ReportController@downloadSyncOverViewReport');
Router::post('report/download/overviewReport', 'ReportController@downloadOverviewReport');
Router::get('report/downloadOverViewReportToExcel', 'ReportController@downloadOverViewReportToExcel');

Router::get('report/syncDashboard', 'ReportController@syncDashboard');
Router::get('report/syncCLoudUsage', 'ReportController@syncCLoudUsage');
Router::get('report/download/downloadOverViewReportSync', 'ReportController@downloadOverViewReportSync');
Router::post('report/syncCLoudUsage', 'ReportController@getSyncCLoudUsage');
Router::post('report/updateSyncCloudUsageDetails', 'ReportController@updateSyncCloudUsageDetails');


Router::get('migration', 'MigrationController@migration');
Router::post('migration', 'MigrationController@getMigrationDetails');
Router::get('migration/importUsers', 'MigrationController@importUsers');
Router::post('migration/getUsers', 'MigrationController@getUsers');
Router::post('migration/getUsersAAD', 'MigrationController@getUsersAAD');
Router::post('migration/migrateUsers', 'MigrationController@migrateUsers');
Router::post('migration/migrateUsersAAD', 'MigrationController@migrateUsersAAD');

Router::get('settings', 'SettingsController@dashboard');
Router::get('settings/email', 'SettingsController@email');
Router::post('settings/email', 'SettingsController@writeToMailConfig');
Router::get('settings/proxy', 'SettingsController@proxy');
Router::post('settings/proxyremove', 'SettingsController@proxyremove');
Router::post('settings/proxy', 'SettingsController@writeProxySettings');
Router::post('settings/editproxy', 'SettingsController@editProxySettings');
Router::get('settings/domain', 'SettingsController@domain');
Router::post('settings/domain', 'SettingsController@writeDomainHost');
Router::get('settings/sslAndEncryption', 'SettingsController@sslAndEncryption');
Router::post('settings/ssl', 'SettingsController@saveSSLCertificate');
Router::get('settings/encryption', 'SettingsController@encryption');
Router::post('settings/encryption', 'SettingsController@saveEncryption');
Router::get('settings/local', 'SettingsController@local');
Router::post('settings/local', 'SettingsController@saveLocal');
Router::get('settings/connector', 'SettingsController@connector');
Router::post('settings/odb', 'SettingsController@writeODB');
Router::post('settings/odc', 'SettingsController@writeODC');
Router::post('settings/google', 'SettingsController@writeGoogle');
Router::get('settings/adCredentials', 'SettingsController@adCredentials');
Router::post('settings/getAdCredential', 'SettingsController@getAdCredential');
Router::post('settings/getAdCredentials', 'SettingsController@getAdCredentials');
Router::post('settings/saveAdCredentials', 'SettingsController@saveAdCredentials');
Router::post('settings/editAdCredentials', 'SettingsController@editAdCredentials');
Router::post('settings/removeAdCredentials', 'SettingsController@removeAdCredentials');
Router::get('settings/aadCredentials', 'SettingsController@aadCredentials');
Router::post('settings/aadCredentials', 'SettingsController@writeAadSettings');
Router::post('settings/addAadCredentials', 'SettingsController@writeAddAadSettings');
Router::post('settings/getAadCredentials', 'SettingsController@getAadCredentials');
Router::post('settings/removeAadCredentials', 'SettingsController@removeAadCredentials');
Router::get('settings/smtpPage','SettingsController@smtp');
Router::post('settings/smtp','SettingsController@saveSmtp');
Router::get('settings/cloudProperties','SettingsController@cloudProperties');
Router::post('settings/cloudProperties','SettingsController@saveCloudProperties');
Router::get('settings/globalSettings','SettingsController@globalSettings');
Router::post('settings/globalSettings','SettingsController@globalSettings');
Router::post('settings/testMail', 'SettingsController@testMail');
Router::get('settings/mongoProperties','SettingsController@mongoProperties');
Router::post('settings/mongoProperties','SettingsController@saveMongoProperties');
Router::post('settings/proxy', 'SettingsController@writeProxySettings');
Router::get('settings/portalProperties','SettingsController@portalProperties');
Router::post('settings/portalProperties','SettingsController@writePortalProperties');
Router::get('settings/dataMigration','SettingsController@dataMigration');
Router::post('settings/dataMigration','SettingsController@dataMigration');
Router::post('usersDataMigration', 'SettingsController@usersDataMigration');
Router::post('settings/startDataMigration', 'SettingsController@startDataMigration');
Router::post('settings/getSMTP', 'SettingsController@getSMTP');
Router::get('settings/keyManager', 'SettingsController@keyManager');

Router::get('settings/licenseKey', 'SettingsController@licenseKey');
Router::post('settings/uploadLicenseKey', 'SettingsController@uploadLicenseKey');
Router::post('settings/uploadLicenseKeyForce', 'SettingsController@uploadLicenseKeyForce');
Router::post('settings/getLicenseKeyList', 'SettingsController@getLicenseKeyList');
Router::post('settings/view', 'SettingsController@licenseKeyAction');
Router::post('settings/apply', 'SettingsController@licenseKeyAction');

Router::get('settings/cloudCredentials', 'SettingsController@cloudCredentials');
Router::get('pms/cloudCredentials', 'PmsController@cloudCredentials');
Router::post('settings/getCloudCredentials', 'SettingsController@getAllCcS');
Router::post('settings/saveCloudCredentials', 'SettingsController@saveCloudCredentials');
Router::post('settings/removeCloudCredentials', 'SettingsController@removeCloudCredentials');

Router::get('settings/paracloudblukrypt','PmsController@paracloudblukrypt');
Router::post('pms/bluvault','PmsController@getBluvault');
Router::post('pms/bluvault/save','PmsController@saveBluvault');
Router::post('pms/bluvault/editSave','PmsController@editSaveBluvault');
Router::post('pms/bluvault/confirmSave','PmsController@confirmSaveBluvault');
Router::post('pms/bluvault/delete','PmsController@deleteBluvault');

Router::get('settings/networkThrottling','PmsController@networkThrottling');
Router::get('pms/throttling/set/(:any)/(:any)','PmsController@networkThrottlingSet');
Router::post('pms/throttling/save','PmsController@saveThrottlingLimit');
Router::post('pms/throttling/remove','PmsController@removeThrottlingLimit');

Router::get('settings/blukrypt','PmsController@blukrypt');
Router::post('pms/getAllBlukrypts','PmsController@getAllBlukrypts');
Router::post('pms/blukrypt/save','PmsController@saveBlukrypt');
Router::post('pms/blukrypt/editSave','PmsController@editSaveBlukrypt');
Router::post('pms/blukrypt/confirmSave','PmsController@confirmSaveBlukrypt');
Router::post('pms/blukrypt/remove','PmsController@removeBlukrypt');

Router::get('support', 'SupportController@support');
Router::get('logDetails/(:any)', 'SupportController@getLogDetails');
Router::get('downloadLog/(:any)/(:any)', 'SupportController@downloadLog');
Router::post('support', 'SupportController@getSupportLogs');
Router::post('supportOverview', 'SupportController@supportOverview');

Router::get('download', 'MechanicController@download');
Router::get('trigger/download', 'MechanicController@downloadAgent');

/* Sync Releated Routes */
Router::get('sync/files', 'SyncController@files');
Router::get('sync/file/download', 'SyncController@download');
Router::post('sync/files', 'SyncController@getAllFiles');
Router::post('sync/files/delete', 'SyncController@deleteFilesFolders');
Router::post('sync/files/share', 'SyncController@shareFile');
Router::post('sync/files/shareWith', 'SyncController@shareFileWith');
Router::post('sync/files/unShare', 'SyncController@unShare');
Router::post('sync/files/updateSharePolicy', 'SyncController@updateSharePolicy');
Router::post('sync/files/cut', 'SyncController@cut');
Router::post('sync/files/copy', 'SyncController@copy');
Router::post('sync/files/paste', 'SyncController@paste');
Router::post('sync/files/checkForFilesCopiedOrCut', 'SyncController@checkForFilesCopiedOrCut');
Router::post('sync/files/isShareCheck', 'SyncController@isShareCheck');

Router::post('sync/minicloud/delete', 'SyncController@deleteMiniCloud');
Router::post('sync/files/versions', 'SyncController@getFileVersions');
Router::post('sync/files/versions/saveComments', 'SyncController@saveFileRevisionComments');
Router::post('sync/file/upload', 'SyncController@upload');
Router::post('sync/createMiniCloud', 'SyncController@createMiniCloud');
Router::post('sync/createFolder', 'SyncController@createFolder');
Router::post('sync/files/saveRename', 'SyncController@saveRename');
Router::post('sync/sendShareEmail', 'SyncController@sendShareEmail');
Router::post('sync/view', 'ParaViewController@reader');
Router::post('backup/view', 'ParaViewController@backupReader');
Router::get('pdfViewer', 'ParaViewController@pdfViewer');

Router::get('miniClouds', 'SyncController@miniClouds');
Router::post('miniClouds', 'SyncController@getMiniClouds');
Router::post('miniClouds/changeOwner', 'SyncController@changeOwner');
Router::post('miniClouds/assignUsers', 'SyncController@assignUsers');
Router::post('miniclouds/exportMiniClouds','SyncController@exportMiniClouds');
Router::get('miniclouds/downloadMiniCloudsExcel','SyncController@downloadMiniCloudsToExcel');

Router::post('contentSearch', 'SyncController@getSearchResults');
Router::post('contentSearchNavigate', 'SyncController@getSearchResultsNavigate');
Router::post('goToPath', 'SyncController@goToPath');

Router::get('trash', 'SyncController@trash');
Router::post('trash', 'SyncController@getDeletedFiles');
Router::post('trash/restoreFile', 'SyncController@restoreFile');
Router::post('trash/purgeFile', 'SyncController@purgeFile');
Router::post('trash/restoreAll', 'SyncController@restoreAll');
Router::post('trash/purgeAll', 'SyncController@purgeAll');
Router::get('openFileLocation', 'SyncController@openFileLocation');
Router::get('backup/openFileLocation', 'BackupController@openFileLocation');

Router::get('googleOAuth', 'StorageController@googleOAuth');
Router::get('odb', 'StorageController@odb');
Router::get('odbrelogin', 'StorageController@odbrelogin');
Router::get('azure', 'StorageController@azure');
Router::get('azureReauth', 'StorageController@azureReauth');
Router::get('adminConsent', 'StorageController@adminConsent');
Router::get('adminConsentSiem', 'StorageController@adminConsentSiem');
Router::get('adminConsentExchange', 'StorageController@adminConsentExchange');
Router::get('adminConsentMultiTenant', 'StorageController@adminConsentMultiTenant');

Router::get('share/myShares', 'SyncController@myShares');
Router::post('share/myShares', 'SyncController@getSharedFiles');
Router::get('share/filesSharedWithMe', 'SyncController@filesSharedWithMe');
Router::post('share/filesSharedWithMe', 'SyncController@getFilesSharedWithMe');
Router::get('share/SharesWithMe', 'SyncController@SharesWithMe');
Router::post('share/SharesWithMe', 'SyncController@getSharedWithMeFiles');
Router::get('share/activityHistory', 'HistoryController@shareActivityHistory');
Router::post('share/activityHistory', 'HistoryController@getShareActivityHistory');
Router::get('cloudInfo', 'MechanicController@cloudInfo');

Router::get('share/(:any)/(:any)/(:any)/(:any)/(:any)', 'ShareController@index');
Router::get('shareView/(:any)/(:any)/(:any)/(:any)/(:any)', 'ShareController@indexView');
Router::post('share/checkPassword', 'ShareController@checkPassword');
Router::post('share/checkPasswordShareView', 'ShareController@checkPasswordShareView');
Router::get('share/file/download', 'ShareController@download');
Router::post('share/view', 'ParaViewController@sharedFileReader');
Router::post('share/viewShareView', 'ParaViewController@sharedFileReaderShareView');
Router::post('backup/share/view', 'ParaViewController@sharedBackupFileReader');
Router::post('backup/share/viewShareView', 'ParaViewController@sharedBackupFileReaderShareView');
Router::post('share/checkIfFileShared', 'ShareController@checkIfFileShared');
Router::post('share/checkIfFileShared1', 'ShareController@checkIfFileShared1');

Router::post('readExcelFromUpload', 'MechanicController@readExcelFromUpload');
Router::post('readExcelFromUploadCreateUsers', 'MechanicController@readExcelFromUploadForCreateUsers');
Router::post('readExcelFromUploadForDevices', 'MechanicController@readExcelFromUploadForDevices');
Router::get('exportActivityHistoryToExcel/(:any)', 'HistoryController@downloadExportActivityHistoryToExcel');
Router::post('exportActivityHistoryToExcel', 'HistoryController@exportActivityHistoryToExcel');
Router::post('exportActivityHistoryToPdf', 'HistoryController@exportActivityHistoryToPdf');
Router::get('exportActivityHistoryToPdf/(:any)', 'HistoryController@downloadExportActivityHistoryToPdf');
Router::get('exportShareActivityHistoryToExcel/(:any)', 'HistoryController@downloadExportShareActivityHistoryToExcel');
Router::post('exportShareActivityHistoryToExcel', 'HistoryController@exportShareActivityHistoryToExcel');

Router::get('server/dashboard', 'IndexController@serverBackup');
Router::get('server/pms/policyMapping/single', 'PmsController@serverSinglePolicyMapping');
Router::get('server/pms/policyMapping/multiple', 'PmsController@serverMultiplePolicyMapping');
Router::get('servers', 'ServerController@listOfServers');
Router::post('server/files', 'ServerController@getFiles');
Router::post('servers', 'ServerController@getAllDevices');
Router::get('server/jobs', 'ServerController@listOfServerJobs');
Router::get('server/new', 'ServerController@addAServer');
Router::get('server/restore/(:any)/(:any)/(:any)', 'ServerController@restore');
Router::get('server/attachContainer/(:any)/(:any)', 'ServerController@attachContainer');
Router::get('device/getAllServers', 'ServerController@getAllServers');
Router::get('backup/getAllUnblockedDevices', 'BackupController@getAllUnblockedDevices');
Router::get('backup/getAllUnblockedDevicesForDeviceList', 'BackupController@getAllUnblockedDevicesForDeviceList');
Router::post('backup/files/isShareCheck', 'BackupController@isShareCheck');
Router::post('server/jobs', 'ServerController@getListOfServerJobs');
Router::post('server/createContainer', 'ServerController@saveContainer');
Router::post('server/createContainer', 'ServerController@saveContainer');
Router::post('server/editSaveContainer', 'ServerController@editSaveContainer');
Router::post('server/remove/container', 'ServerController@removeContainer');
Router::post('server/containers', 'ServerController@getAllContainers');
Router::post('server/initiateBackup', 'ServerController@initiateBackup');
Router::post('server/getSupportLogs', 'ServerController@getSupportLogs');
Router::post('server/initiateRefreshPolicy', 'ServerController@initiateRefreshPolicy');
Router::post('server/decoupleAgent', 'ServerController@decoupleAgent');
Router::post('server/terminateServerJob', 'ServerController@terminateServerJob');
Router::post('server/initiateRestore', 'ServerController@initiateRestore');

Router::get('user/downloadBulkcreateusersSample', 'UserController@downloadBulkcreateusersSample');
Router::get('user/downloadBlockUnblockDeleteusersSample', 'UserController@downloadBlockUnblockDeleteusersSample');
Router::get('device/downloadSample', 'DeviceController@downloadSample');
Router::get('migration/downloadSample', 'MigrationController@downloadSample');

/*Excel report download*/
Router::post('report/download/noBackupExcel', 'ReportController@downloadNobackupReportExcel');
Router::get('report/downloadNobackupReportToExcel', 'ReportController@downloadNobackupToExcel');
Router::post('report/download/usersNoBackupExcel', 'ReportController@downloadUsersNobackupReportExcel');
Router::get('report/downloadUsersNobackupReportToExcel', 'ReportController@downloadUsersNobackupToExcel');
Router::post('report/download/userBackupHistoryExcel', 'ReportController@downloadUserBackupHistoryExcel');
Router::get('report/downloadBackupHistoryReportToExcel', 'ReportController@downloadBackupHistoryReportExcel');
Router::post('report/download/failedBackupReportExcel', 'ReportController@downloadFailedBackupReportExcel');
Router::get('report/downloadFailedBackupReportToExcel', 'ReportController@downloadFailedBackupReportToExcel');
Router::post('report/download/restoreHistoryReportExcel', 'ReportController@downloadRestoreHistoryReportExcel');
Router::get('report/downloadRestoreHistoryReportToExcel', 'ReportController@downloadRestoreHistoryReportToExcel');
Router::post('report/download/incompleteBackupReportExcel', 'ReportController@downloadIncompleteBackupReportExcel');
Router::get('report/downloadIncompleteBackupReportToExcel', 'ReportController@downloadIncompleteBackupReportToExcel');

/*Sharepoint App*/
Router::get('sharepoint', 'StorageController@sharepoint');
Router::get('settings/sharepoint','SettingsController@sharepoint');
Router::post('settings/saveSharepointConfiguration', 'SettingsController@saveSharepointConfiguration');
Router::get('downloadPackage', 'SettingsController@downloadIt');

/*OneDrive for backup*/
Router::get('settings/oneDriveSettings', 'SettingsController@oneDriveSettings');
Router::get('settings/office365Settings', 'SettingsController@office365Settings');
Router::get('pms/oneDrivePolicies', 'PmsController@oneDrivePolices');
Router::post('settings/oneDriveDetails', 'SettingsController@writeOneDriveSettings');
Router::get('oneDrive', 'StorageController@oneDrive');
Router::get('o365login', 'StorageController@o365login');

Router::post('pms/oneDrivePolicies', 'PmsController@getOneDrivePolicies');
Router::get('pms/oneDrivePolicy/create', 'PmsController@createOneDrivePolicy');
Router::get('pms/oneDrivePolicy/edit/(:any)', 'PmsController@editOneDrivePolicy');
Router::get('pms/oneDrivePolicy/clone/(:any)', 'PmsController@cloneOneDrivePolicy');
Router::post('pms/oneDrivePolicy/save', 'PmsController@saveOneDrivePolicy');
Router::post('pms/oneDrivePolicy/saveEdit', 'PmsController@saveOneDrivePolicyEdit');
Router::post('pms/oneDrivePolicy', 'PmsController@getOneDrivePolicy');
Router::post('pms/viewOneDrivePolicy', 'PmsController@viewOneDrivePolicy');
Router::get('pms/oneDrivePolicyMapping/single','PmsController@singleOneDrivePolicyMapping');
Router::post('pms/oneDrivePolicyMapping/single','PmsController@getOneDrivePolicyMappingDetails');
Router::post('pms/oneDrivePolicyMapping/single/save','PmsController@saveSingleOneDrivePolicyMapping');
Router::post('pms/viewOneDrivePolicy', 'PmsController@viewOneDrivePolicy');
Router::get('pms/oneDrivePolicyMapping/multiple','PmsController@multipleOneDrivePolicyMapping');
Router::post('pms/oneDrivePolicyMapping/multiple/save','PmsController@saveMultipleOneDrivePolicyMapping');

Router::get('oneDriveDashboard', 'IndexController@oneDrive');
Router::post('report/onedDriveStatistics', 'ReportController@getOneDriveStatistics');

Router::get('settings/blukryptSettings', 'SettingsController@blukryptSettings');
Router::post('settings/blukryptSettings', 'SettingsController@saveBlukryptSettings');
Router::post('settings/getOneDriveControllerSettings', 'SettingsController@getAllOneDriveControllerSettings');

Router::post('settings/blukryptSettingsEdit', 'SettingsController@saveEditBlukryptSettings');

Router::post('controller/delete','SettingsController@deleteController');

/*Agent Download related*/

Router::get('settings/epaManager','SettingsController@epaManager');
Router::post('settings/getEPAWindows', 'SettingsController@getEPAWindows');
Router::post('settings/epaWindows', 'SettingsController@saveEPAWindows');
Router::post('settings/epaWindowsOne', 'SettingsController@saveEPAWindowsOne');
Router::post('settings/epaLinux', 'SettingsController@saveEPALinux');
Router::post('settings/epaLinuxOne', 'SettingsController@saveEPALinuxOne');
Router::post('settings/epaLinuxrpm', 'SettingsController@saveEPALinuxrpm');
Router::post('settings/epaLinuxrpmOne', 'SettingsController@saveEPALinuxrpmOne');

Router::post('getEPADetails', 'PmsController@getEPADetails');

Router::post('settings/epaMac', 'SettingsController@saveEPAMac');
Router::post('settings/epaMacOne', 'SettingsController@saveEPAMacOne');

Router::post('report/syncStatistics', 'ReportController@getSyncStatisticsOne');

Router::post('checkFile', 'HistoryController@checkFile');
//download log file
Router::get('downloadLogOne/(:any)/(:any)', 'HistoryController@downloadLogOne');

/* Default Route */
Router::error('error@index');
Router::get('serviceDown', 'error@serviceDown');

/*Download zip download folder*/
Router::post('backup/downloadFolder', 'BackupController@downloadFolder');
Router::post('backup/downloadFolderAsPst', 'BackupController@downloadFolderAsPst');
Router::post('backup/downloadFolderAsPstGlobal', 'BackupController@downloadFolderAsPstGlobal');
Router::post('backup/downloadFolderAsPstSearch', 'BackupController@downloadFolderAsPstGlobal');
Router::post('backup/selectedFles', 'BackupController@selectedFles');
Router::get('backup/downloadFileee', 'BackupController@downloadFileee');

Router::post('sync/downloadFolder', 'SyncController@downloadFolder');
Router::get('sync/downloadFileee', 'SyncController@downloadFileee');

Router::get('sso', 'StorageController@sso');
Router::get('login1', 'LoginController@authenticate1');
Router::get('newLogin', 'IndexController@index');
Router::get('logoutPage', 'LoginController@logoutPage');

Router::post('pms/filterOne', 'PmsController@getFilterOne');
Router::post('pms/filterTemplate', 'PmsController@getFilterTemplate');
Router::post('pms/Allfilters', 'PmsController@getAllFilters');

Router::get('settings/mongoProperties','SettingsController@mongoProperties');
Router::post('settings/mongoProperties','SettingsController@writeMongoProperties');

//pdf report download start
Router::post('report/download/userBackupHistoryPdf', 'ReportController@downloadUserBackupHistoryPdf');
Router::get('report/downloadBackupHistoryReportToPdf', 'ReportController@downloadBackupHistoryReportPdf');
Router::post('report/download/overviewReportPdf', 'ReportController@downloadOverviewReportPdf');
Router::get('report/downloadOverViewReportToPdf', 'ReportController@downloadOverViewReportToPdf');
Router::post('report/download/failedBackupReportPdf', 'ReportController@downloadFailedBackupReportPdf');
Router::get('report/downloadFailedBackupReportToPdf', 'ReportController@downloadFailedBackupReportToPdf');
Router::post('report/download/noBackupPdf', 'ReportController@downloadNobackupReportPdf');
Router::get('report/downloadNobackupReportToPdf', 'ReportController@downloadNobackupToPdf');
Router::post('report/download/usersNoBackupPdf', 'ReportController@downloadUsersNobackupReportPdf');
Router::get('report/downloadUsersNobackupReportToPdf', 'ReportController@downloadUsersNobackupToPdf');
Router::post('report/download/restoreHistoryReportPdf', 'ReportController@downloadRestoreHistoryReportPdf');
Router::get('report/downloadRestoreHistoryReportToPdf', 'ReportController@downloadRestoreHistoryReportToPdf');
Router::post('report/downloadDailyUserBackupOverviewPdf', 'ReportController@downloadDailyUserBackupOverviewPdf');
Router::get('report/downloadDailyUserBackupOverviewToPdf', 'ReportController@downloadDailyUserBackupOverviewToPdf');
Router::post('report/downloadAgentNotHeardReportPdf', 'ReportController@downloadAgentNotHeardReportPdf');
Router::get('report/downloadAgentNotHeardReportToPdf', 'ReportController@downloadAgentNotHeardReportToPdf');
Router::post('report/downloadUserBackupSummaryReportPdf', 'ReportController@downloadUserBackupSummaryReportPdf');
Router::get('report/downloadUserBackupSummaryReportToPdf', 'ReportController@downloadUserBackupSummaryReportToPdf');
Router::post('report/download/incompleteBackupReportPdf', 'ReportController@downloadIncompleteBackupReportPdf');
Router::get('report/downloadIncompleteBackupReportToPdf', 'ReportController@downloadIncompleteBackupReportToPdf');
//pdf end

//for Exchange start
Router::post('backup/filesOutlook', 'BackupController@getFilesOutlook');
Router::post('backup/filesOutlookNavigate', 'BackupController@getFilesOutlookNavigate');
Router::post('backup/viewOutlook', 'BackupController@viewOutlook');
Router::post('contentSearchOutlook', 'BackupController@getSearchResultsOutlook');
Router::post('contentSearchOutlookNavigate', 'BackupController@getSearchResultsOutlookNavigate');
//for Exchange end

//pagination start
Router::post('activityHistory1', 'HistoryController@getActivityHistory1');
Router::post('report/overview1', 'ReportController@getOverview1');
Router::post('report/userBackupHistory1', 'ReportController@getUserBackupHistory1');
Router::post('report/restoreHistory1', 'ReportController@getRestoreHistory1');
Router::post('report/failedBackup1', 'ReportController@getFailedBackup1');
Router::post('report/noBackup1', 'ReportController@getNoBackup1');
Router::post('report/getDailyUserBackupOverview1', 'ReportController@getDailyUserBackupOverview1');
Router::post('report/lastAgentServerConnectionDetails1', 'ReportController@getLastAgentServerConnectionDetails1');
Router::post('report/currentBackup1', 'ReportController@getCurrentBackup1');
Router::post('report/currentRestore', 'ReportController@getCurrentRestore');
Router::post('report/currentRestore1', 'ReportController@getCurrentRestore1');
Router::post('users1', 'UserController@getAllUsers1');
Router::post('devices1', 'DeviceController@getAllDevices1');
Router::post('user/backupHistory1', 'HistoryController@getBackupHistory1');
Router::post('report/backupAttemps', 'HistoryController@getBackupAttemps');
Router::post('support1', 'SupportController@getSupportLogs1');
//pagination ends

//initiate restore from portal start
Router::get('backup/restore/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)', 'BackupController@restore');
Router::post('backup/restore', 'BackupController@getDevicesForRestore');
Router::post('backup/devices1', 'BackupController@getDevicesForRestorePage');
Router::get('backup/files/restore1/(:any)/(:any)/(:any)', 'BackupController@restore1');
Router::post('backup/files/initiateRestores', 'BackupController@initiateRestores');
Router::post('backup/files/deleteRestores', 'BackupController@deleteRestores');
//initiate restore from portal ends

Router::post('muxedUsersList', 'UserController@muxedUsersList');
Router::post('startMuxing', 'UserController@startMuxing');

//user without devices report start
Router::get('report/usersWithoutDevices/(:any)', 'ReportController@usersWithoutDevices');
Router::post('report/usersWithoutDevicesView', 'ReportController@usersWithoutDevicesView');
Router::post('report/usersWithoutDevicesView1', 'ReportController@usersWithoutDevicesView1');
Router::post('downloadUsersWithoutDevices', 'ReportController@downloadUsersWithoutDevices');
Router::get('downloadUsersWithoutDevicesExcel', 'ReportController@downloadUsersWithoutDevicesExcel');
//user without devices report end

Router::get('policy/downloadDump', 'PmsController@downloadDump');
Router::get('policy/downloadSample', 'PmsController@downloadSample');

Router::post('report/getSchedule', 'ReportController@getSchedule');
Router::post('report/getSchedules', 'ReportController@getSchedules');
Router::post('report/deleteSchedule', 'ReportController@deleteSchedule');
Router::post('report/saveSchedule', 'ReportController@saveScheduleReport');
Router::post('usersMailId', 'ReportController@usersMailId');

Router::get('user/downloadDump', 'UserController@downloadDump');
Router::get('device/downloadDump', 'DeviceController@downloadDump');

Router::post('pms/schedule/saveEditMail', 'PmsController@saveScheduleEditMail');
Router::post('pms/schedule/saveOdb', 'PmsController@saveScheduleOdb');
Router::post('pms/schedule/saveMail', 'PmsController@saveScheduleMail');

Router::post('pms/filter/saveOdb', 'PmsController@saveFilterOdb');
Router::post('pms/filter/saveMail', 'PmsController@saveFilterMail');

Router::post('pms/filter/saveEditOdb', 'PmsController@saveFilterEditOdb');
Router::post('pms/filter/saveEditMail', 'PmsController@saveFilterEditMail');

Router::post('pms/user/policyODB', 'PmsController@getUserODBPolicy');

Router::post('backup/files/initiateRestoresOneDrive', 'BackupController@initiateRestoresOneDrive');
Router::post('backup/files/deleteRestoresOneDrive', 'BackupController@deleteRestoresOneDrive');

Router::post('backup/files/initiateRestoresOnedriveDevice', 'BackupController@initiateRestoresOnedriveDevice');
Router::post('backup/files/deleteRestoresOnedriveDevice', 'BackupController@deleteRestoresOnedriveDevice');

Router::post('backup/files/initiateRestoresOutlook', 'BackupController@initiateRestoresOutlook');
Router::post('backup/files/deleteRestoresOutlook', 'BackupController@deleteRestoresOutlook');

Router::post('backup/files/initiateRestoresOutlookFile', 'BackupController@initiateRestoresOutlookFile');
Router::post('backup/files/deleteRestoresOutlookFile', 'BackupController@deleteRestoresOutlookFile');

Router::post('backup/files/initiateRestoresOutlookDevice', 'BackupController@initiateRestoresOutlookDevice');
Router::post('backup/files/deleteRestoresOutlookDevice', 'BackupController@deleteRestoresOutlookDevice');

Router::post('backup/files/initiateRestoresOutlookSearchFile', 'BackupController@initiateRestoresOutlookSearchFile');
Router::post('backup/files/deleteRestoresOutlookSearchFile', 'BackupController@deleteRestoresOutlookSearchFile');

Router::post('viewRestoreProgress', 'ReportController@viewRestoreProgress');
Router::post('viewRestoreProgressEndPoint', 'ReportController@viewRestoreProgressEndPoint');

Router::post('browse', 'SettingsController@browse');
Router::post('browseOnedrive', 'SettingsController@browseOnedrive');

Router::post('settings/brandingUpload', 'SettingsController@brandingUpload');
Router::post('settings/curlCall', 'SettingsController@curlCall');

Router::post('saveBulkEventHubCurrentBackup', 'ReportController@saveBulkEventHubCurrentBackup');
Router::post('stopRestore', 'ReportController@stopRestore');
Router::post('stopBulkRestore', 'ReportController@stopBulkRestore');

Router::get('backup/getAllUnblockedDevicesEndpoint', 'BackupController@getAllUnblockedDevicesEndpoint');
Router::get('backup/getAllUnblockedDevicesOutlook', 'BackupController@getAllUnblockedDevicesOutlook');
Router::get('backup/getAllUnblockedDevicesOnedrive', 'BackupController@getAllUnblockedDevicesOnedrive');

/*policies pagination starts*/
Router::post('pms/policiesPagination', 'PmsController@getAllPoliciesPagination');
Router::post('pms/policiesPaginationNavigate', 'PmsController@getAllPoliciesPaginationNavigate');

Router::post('pms/sync/policiesPagination', 'SyncPmsController@getAllPoliciesPagination');
Router::post('pms/sync/policiesPaginationNavigate', 'SyncPmsController@getAllPoliciesPaginationNavigate');

Router::post('pms/policiesOfficePagination', 'PmsController@getAllPoliciesOfficePagination');
Router::post('pms/policiesOfficePaginationNavigate', 'PmsController@getAllPoliciesOfficePaginationNavigate');

Router::post('pms/policyMapping/singleNavigate','PmsController@getPolicyMappingDetailsNavigate');
Router::post('pms/sync/policyMapping/singleNavigate','SyncPmsController@getPolicyMappingDetailsNavigate');
Router::post('pms/oneDrivePolicyMapping/singleNavigate','PmsController@getOneDrivePolicyMappingDetailsNavigate');
/*policies pagination ends*/

Router::post('report/userMigration1', 'ReportController@getUserMigration1');
Router::post('share/activityHistory1', 'HistoryController@getShareActivityHistory1');

Router::post('backup/files/initiateRestoresOutlookSearchFileGS', 'BackupController@initiateRestoresOutlookSearchFileGS');
Router::post('backup/files/deleteRestoresOutlookSearchFileGS', 'BackupController@deleteRestoresOutlookSearchFileGS');

Router::post('getDeviceEndPoint', 'UserController@getDeviceEndPoint');
Router::post('getDeviceOnedrive', 'UserController@getDeviceOnedrive');
Router::post('getDeviceOutlook', 'UserController@getDeviceOutlook');
Router::post('getDeviceSharepoint', 'UserController@getDeviceSharepoint');

Router::get('share/qrcode/(:any)/(:any)', 'ShareController@qrcode');
Router::post('changePasswordForFirstlogin', 'BackupController@changePasswordForFirstlogin');
Router::post('checkCode', 'UserController@checkCode');

Router::post('backup/sendShareEmail', 'BackupController@sendShareEmail');
Router::post('checkMail', 'ShareController@checkMail');

Router::post('user/device/policyInfo/disableAdminRestore', 'DeviceController@disableAdminRestore');

Router::get('backup/downloadFileAsStream', 'BackupController@downloadFileAsStream');
Router::get('sync/downloadFileAsStream', 'SyncController@downloadFileAsStream');

Router::get('sync/failedFiles/(:any)/(:any)/(:any)', 'SyncController@failedFiles');
Router::post('failedFiles', 'SyncController@getFailedFiles');
Router::post('failedFiles1', 'SyncController@getFailedFilesNavigate');
Router::get('sync/failedFilesPortal', 'SyncController@failedFilesPortal');

Router::post('sync/saveMiniCloud', 'SyncController@saveMiniCloud');
Router::post('sync/getMiniCloud', 'SyncController@getMiniCloud');

/*minicloud reports start*/
Router::get('report/minicloudActivity', 'ReportController@minicloudActivity');
Router::post('getMinicloudActivityHistory', 'ReportController@getMinicloudActivityHistory');
Router::post('getMinicloudActivityHistory1', 'ReportController@getMinicloudActivityHistory1');
Router::post('report/download/minicloudActivityExcel', 'ReportController@minicloudActivityExcel');
Router::get('report/downloadMinicloudActivityToExcel', 'ReportController@downloadMinicloudActivityToExcel');
Router::post('report/download/minicloudActivityPdf', 'ReportController@minicloudActivityPdf');
Router::get('report/downloadMinicloudActivityToPdf', 'ReportController@downloadMinicloudActivityToPdf');
/*minicloud reports end*/
Router::post('calculateRestorableSize', 'BackupController@calculateRestorableSize');

Router::post('readExcelFromUploadForPolicyMapping', 'MechanicController@readExcelFromUploadForPolicyMapping');
Router::get('policy/downloadDumpBulkMapping', 'PmsController@downloadDumpBulkMapping');

Router::get('policy/downloadSample1', 'PmsController@downloadSample1');
Router::post('pms/policyMapping/multiple/saveOld','PmsController@saveMultiplePolicyMappingOld');
Router::post('pms/sync/policyMapping/multiple/saveOld','SyncPmsController@saveMultiplePolicyMappingOld');
Router::post('pms/oneDrivePolicyMapping/multiple/saveOld','PmsController@saveMultipleOneDrivePolicyMappingOld');
Router::post('readExcelFromUploadOld', 'MechanicController@readExcelFromUploadOld');

Router::post('contentSearchAd', 'SyncController@getSearchResultsAd');
Router::post('contentSearchAdNavigate', 'SyncController@getSearchResultsAdNavigate');

Router::get('sync/sharedFiles', 'SyncController@sharedFiles');

/*new one*/
Router::get('pms/spPolicies', 'PmsController@spPolicies');
Router::post('pms/spPoliciesPagination', 'PmsController@getAllSpPoliciesPagination');
Router::post('pms/spPoliciesPaginationNavigate', 'PmsController@getAllSpPoliciesPaginationNavigate');

Router::get('pms/sharepointPolicyMapping/single','PmsController@singleSharePointPolicyMapping');
Router::get('pms/sharepointPolicyMapping/multiple','PmsController@multipleSharePointPolicyMapping');

Router::post('pms/sharepointPolicyMapping/single','PmsController@getSharePointPolicyMappingDetails');
Router::post('pms/sharepointPolicyMapping/singleNavigate','PmsController@getSharePointPolicyMappingDetailsNavigate');
Router::post('pms/sharepointPolicyMapping/single/save','PmsController@saveSingleSharePointPolicyMapping');

Router::get('pms/sharepointPolicy/create', 'PmsController@createSharePointPolicy');

Router::post('pms/sharePointPolicy/save', 'PmsController@saveSharePointPolicy');
Router::post('pms/sharePointPolicy/saveEdit', 'PmsController@saveSharePointPolicyEdit');

Router::post('pms/sharepointPolicy', 'PmsController@getSharePointPolicy');
Router::get('pms/sharepointPolicy/edit/(:any)', 'PmsController@editOneDrivePolicy');
Router::get('pms/sharepointPolicy/clone/(:any)', 'PmsController@cloneOneDrivePolicy');
Router::post('pms/user/sharepointpolicy', 'PmsController@getUserSharepointPolicy');
Router::get('pms/exchangePolicies', 'PmsController@exchangePolices');
Router::post('pms/exchangePolicies', 'PmsController@getExchangePolicies');
Router::get('pms/exchangePolicy/create', 'PmsController@createExchangePolicy');
Router::get('pms/exchangePolicy/edit/(:any)', 'PmsController@editExchangePolicy');
Router::get('pms/exchangePolicy/clone/(:any)', 'PmsController@cloneExchangePolicy');
Router::post('pms/exchangePolicy/save', 'PmsController@saveExchangePolicy');
Router::post('pms/exchangePolicy/saveEdit', 'PmsController@saveExchangePolicyEdit');
Router::post('pms/policiesExchangePagination', 'PmsController@getAllPoliciesExchangePagination');
Router::post('pms/policiesExchangePaginationNavigate', 'PmsController@getAllPoliciesExchangePaginationNavigate');
/*sharepoint ends*/

Router::get('pms/officePolicy/create/(:any)', 'PmsController@createOfficePolicy');
Router::get('pms/officePolicy/edit/(:any)/(:any)', 'PmsController@editOfficePolicy');
Router::get('pms/officePolicy/clone/(:any)/(:any)', 'PmsController@cloneOfficePolicy');

Router::get('pms/officePolicyMapping/single/(:any)','PmsController@singleOfficePolicyMapping');
Router::post('pms/officePolicyMapping/single','PmsController@getOfficePolicyMappingDetails');
Router::post('pms/officePolicyMapping/singleNavigate','PmsController@getOfficePolicyMappingDetailsNavigate');
Router::post('pms/officePolicyMapping/single/save','PmsController@saveSingleOfficePolicyMapping');
Router::post('pms/officePolicyMapping/multiple/saveOld','PmsController@saveMultipleOfficePolicyMappingOld');
Router::get('pms/officePolicyMapping/multiple/(:any)','PmsController@multipleOfficePolicyMapping');

Router::get('sites', 'UserController@sites');
Router::post('sites', 'UserController@getAllSites');

Router::get('getAllUnBlockedSites', 'UserController@getAllUnBlockedSites');
Router::get('getAllUnBlockedSitesG', 'UserController@getAllUnBlockedSitesG');
Router::post('site/exportSites', 'UserController@exportSitesToExcel');
Router::get('site/downloadSitesExcel', 'UserController@downloadSitesToExcel');

Router::post('devicesOneDrive', 'DeviceController@getAllDevicesOneDrive');
Router::post('devicesOneDrive1', 'DeviceController@getAllDevicesOneDrive1');
Router::post('devicesExchange', 'DeviceController@getAllDevicesExchange');
Router::post('devicesExchange1', 'DeviceController@getAllDevicesExchange1');
Router::post('devicesSharepoint', 'DeviceController@getAllDevicesSharepoint');
Router::post('devicesSharepoint1', 'DeviceController@getAllDevicesSharepoint1');

Router::get('getDevicesPt', 'DeviceController@getDevicesPt');
Router::get('getDevicesExchangePt', 'DeviceController@getDevicesExchangePt');
Router::post('sitesDiscovery', 'SettingsController@sitesDiscovery');
Router::post('startSiteConfiguration', 'DeviceController@sitesConfiguration');
Router::post('startSiteConfigurationMapping', 'DeviceController@sitesConfigurationMapping');

/*product overview start*/
Router::get('report/productOverview/(:any)', 'ReportController@productOverview');
Router::post('report/productOverview', 'ReportController@getProductOverview');
Router::post('report/download/downloadProductOverview', 'ReportController@downloadProductOverview');
Router::get('report/downloadProductOverviewExcel', 'ReportController@downloadProductOverviewExcel');
Router::post('report/download/downloadProductOverviewToPdf', 'ReportController@downloadProductOverviewToPdf');
Router::get('report/downloadProductOverviewPdf', 'ReportController@downloadProductOverviewPdf');
Router::post('report/saveScheduleReportProductOverview', 'ReportController@saveScheduleReportProductOverview');
/*product overview end*/

/*new one*/

Router::post('checkMailNew', 'BackupController@checkMailNew');

Router::post('browseEndPointOnedrive', 'SettingsController@browseEndPointOnedrive');

Router::post('usersSearch', 'UserController@getAllUsersSearch');
Router::post('devicesSearch', 'DeviceController@getAllDevicesSearch');
Router::post('sitesSearch', 'UserController@getAllSitesSearch');

Router::post('getDeviceSharepoint', 'UserController@getDeviceSharepoint');
Router::post('browseSharepoint', 'SettingsController@browseSharepoint');

/*export policy as PDF start*/
Router::post('download/policyPdf', 'PmsController@downloadPolicyPdf');
Router::get('downloadPolicyFilePdf', 'PmsController@downloadPolicyFilePdf');
Router::post('download/syncpolicyPdf', 'SyncPmsController@downloadSyncPolicyPdf');
Router::get('downloadSyncPolicyFilePdf', 'SyncPmsController@downloadSyncPolicyFilePdf');
Router::post('download/exchangepolicyPdf', 'PmsController@downloadExchangePolicyPdf');
Router::get('downloadExchangePolicyFilePdf', 'PmsController@downloadExchangePolicyFilePdf');
Router::post('download/onedrivepolicyPdf', 'PmsController@downloadOnedrivePolicyPdf');
Router::get('downloadOnedrivePolicyFilePdf', 'PmsController@downloadOnedrivePolicyFilePdf');
Router::post('download/sharepointpolicyPdf', 'PmsController@downloadSharepointPolicyPdf');
Router::get('downloadSharepointPolicyFilePdf', 'PmsController@downloadSharepointPolicyFilePdf');
/*export policy as PDF ends*/

Router::get('settings/exchangeSettings', 'SettingsController@exchangeSettings');
Router::post('settings/exchangeDetails', 'SettingsController@writeExchangeSettings');

Router::post('login1', 'LoginController@preauthenticate');
Router::get('password-restCaptcha', 'LoginController@passwordResetCaptcha');
Router::post('createCaptcha', 'LoginController@createCaptcha');
Router::post('loginCaptchaRefresh', 'LoginController@loginCaptchaRefresh');
Router::post('loginCaptchaRefreshProfile', 'UserController@loginCaptchaRefreshProfile');

Router::get('settings/siemCredentials', 'SettingsController@siemCredentials');
Router::post('settings/getSiemCredentials', 'SettingsController@getAllSiemCredentials');
Router::post('settings/saveSiemCredentials', 'SettingsController@saveSiemCredentials');
Router::post('settings/removeSiemCredentials', 'SettingsController@removeSiemCredentials');

Router::post('generateOtp', 'ShareController@generateOtp');
Router::post('sync/viewGetting', 'ParaViewController@readerGetting');

Router::post('sync/files/shareMyShare', 'SyncController@shareFileMyShare');
Router::post('sync/getSharedFilesList', 'ShareController@getSharedFilesList');
Router::post('generateOtp1', 'LoginController@generateOtp');
Router::post('generateOtpForcePasswordChange', 'LoginController@generateOtpForcePasswordChange');

Router::get('backup/manageDevices', 'BackupController@manageDevices');
Router::post('backup/manageDevices', 'BackupController@getManageDevices');
Router::post('backup/manageDevicesNavigate', 'BackupController@getManageDevicesNavigate');
Router::post('saveEventHubFromManageDevice', 'BackupController@saveEventHubFromManageDevice');
Router::post('getSitesDiscovery', 'SettingsController@getSitesDiscovery');

Router::post('syncNow', 'MigrationController@syncNow');

Router::post('user/exportSoftDeletedUsers', 'UserController@exportSoftDeletedUsersToExcel');
Router::get('user/downloadSitesExcel', 'UserController@downloadSoftDeletedUsersToExcel');

/*unusual activity*/
Router::get('unusualActivityHistory/(:any)/(:any)/(:any)', 'HistoryController@unusualActivityHistory');
Router::get('unusualActivityHistoryForAll', 'HistoryController@unusualActivityHistoryForAll');
Router::post('unusualActivityHistory', 'HistoryController@getUnusualActivityHistory');
Router::post('unusualActivityHistory1', 'HistoryController@getUnusualActivityHistoryNavigate');

Router::post('history/unusualActivityAction', 'HistoryController@unusualActivityAction');
Router::post('history/uploadInfFile', 'HistoryController@uploadInfFile');
Router::post('history/uploadInfFileApi', 'HistoryController@uploadInfFileApi');
Router::post('history/getInfStatistics', 'HistoryController@getInfStatistics');

Router::get('settings/quarantineList', 'HistoryController@quarantineList');
Router::post('history/getQuarantineList', 'HistoryController@getQuarantineList');
Router::post('history/deleteRwFile', 'HistoryController@deleteRwFile');
Router::post('history/quarantineDevices', 'HistoryController@getQuarantineDevices');
/*unusual activity*/

Router::post('viewFileUrlReader', 'ParaViewController@viewFileUrlReader');
Router::get('viewFile/(:any)/(:any)/(:any)/(:any)', 'ShareController@viewFile');

Router::post('fileArchived', 'ShareController@fileArchived');
Router::get('fileArchivedView', 'ShareController@fileArchivedView');

Router::post('closeWarning', 'ReportController@closeWarning');
Router::post('closeSoftBlockWarning', 'ReportController@closeSoftBlockWarning');
Router::get('ransomwareActivityHistory', 'HistoryController@ransomwareActivityHistory');
Router::get('exportUnusualActivityHistoryToExcel/(:any)', 'HistoryController@downloadExportUnusualActivityHistoryToExcel');
Router::post('exportUnusualActivityHistoryToExcel', 'HistoryController@exportUnusualActivityHistoryToExcel');

Router::get('users/usersBulkBlockDelete/(:any)', 'UserController@usersBulkBlockDeleteBlock');

Router::post('report/downloadUserMigration', 'ReportController@downloadUserMigration');
Router::get('report/downloadUserMigrationExcel', 'ReportController@downloadUserMigrationExcel');

/*etisalat changes start*/
Router::get('delegatedDashboard', 'IndexController@index_mockup');
Router::post('user/addSingleMspUser', 'UserController@addSingleMspUser');
Router::post('user/updateMultipleMspUser', 'UserController@updateMultipleMspUser');
Router::post('report/statisticsMSP', 'ReportController@getStatisticsMSP');
Router::post('readExcelFromUploadCreateUsersMsp', 'MechanicController@readExcelFromUploadForCreateUsersMsp');
Router::post('pms/policy/saveEditMsp', 'PmsController@savePolicyEditMsp');
Router::post('pms/viewpolicyMsp', 'PmsController@viewPolicyMsp');
Router::post('saveEventHubMsp', 'ReportController@saveEventHubMsp');
Router::get('migration/downloadSampleMsp', 'MigrationController@downloadSampleMsp');
Router::post('user/device/policyInfoMsp', 'ReportController@getCurrentDeviceIDInformationMsp');
Router::post('closeStorageWarning', 'ReportController@closeStorageWarning');
Router::post('closeUserWarning', 'ReportController@closeUserWarning');
/*etisalat changes end*/

/*handling pst download*/
Router::get('downloads', 'SupportController@downloads');
Router::post('support/getDownloads', 'SupportController@getDownloads');
Router::get('trigger/downloadFile', 'SupportController@downloadFile');
/*handling pst download*/

Router::get('report/deviceOverview/(:any)', 'ReportController@deviceOverview');
Router::post('report/deviceOverview', 'ReportController@getDeviceOverview');
Router::post('report/deviceOverview1', 'ReportController@getDeviceOverview1');
Router::post('report/download/deviceOverviewReportExcel', 'ReportController@downloadDeviceOverviewReportExcel');
Router::get('report/downloadDeviceOverviewReportToExcel', 'ReportController@downloadDeviceOverviewReportToExcel');
Router::post('report/download/deviceOverviewReportPdf', 'ReportController@downloadDeviceOverviewReportPdf');
Router::get('report/downloadDeviceOverviewReportToPdf', 'ReportController@downloadDeviceOverviewReportToPdf');

Router::get('getDevicesSharepointPt', 'DeviceController@getDevicesSharepointPt');
Router::post('discoverNow', 'BackupController@discoverNow');
Router::post('startSiteConfigurationM', 'DeviceController@savePolicy');

/* turn on old style routing */
Router::$fallback = false;

/* execute matched routes */
Router::dispatch();
