<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Report extends Model{

    public function __construct(){
        parent::__construct();
        $this->log('Report Model was called', 'info');
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStatistics($headers){
        $url = $this->api->getUrl('getStatistics');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveStatistics($headers){
        $url = $this->api->getUrl('getOneDriveStatistics');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getServerBackupStatistics($headers){
        $url = $this->api->getUrl('getServerBackupStatistics');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
  public function getOverview($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('getOverviewNew');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/backup/user/overviewReport?pageNumber=".$pageNumber;
	Model::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOverview1($headers,$data,$url){
	//$url = $this->api->getUrl('getOverviewNew');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->log("url". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getSyncCLoudUsage($headers){
        $url = $this->api->getUrl('syncCLoudUsage');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getOverviewAll($headers){
        $url = $this->api->getUrl('getOverviewAll');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getRestoreHistory($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('getRestoreHistory');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/restoreHistory?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getRestoreHistory1($headers,$data, $url){
	//$url = $this->api->getUrl('getRestoreHistory');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function updateSyncCloudUsageDetails($headers){
        $url = $this->api->getUrl('updateSyncCloudUsageDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLongBackupDetails($headers){
        $url = $this->api->getUrl('longBackup');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getCurrentBackupDetails($headers,$pageNumber){
	//$url = $this->api->getUrl('currentBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/currentBackup?pageNumber=".$pageNumber;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCurrentBackupDetails1($headers,$url){
	//$url = $this->api->getUrl('currentBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCurrentRestoreDetails($headers,$pageNumber){
	//$url = $this->api->getUrl('currentBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/currentRestore?pageNumber=".$pageNumber;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getCurrentRestoreDetails1($headers,$url){
	//$url = $this->api->getUrl('currentBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getNoBackupDetails($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('noBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/noBackup?pageNumber=".$pageNumber;	
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getNoBackupDetails1($headers,$data,$url){
        //$url = $this->api->getUrl('noBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAgentNotHeardDetails($headers, $data,$pageNumber){
	//$url = $this->api->getParacloudUrl('agentNotHeard');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/deviceHeartBeat?pageNumber=".$pageNumber;
        //$url = $url."?noOfDays=".$days;
        $this->curl->setHeaders($headers);
        $this->log('Header: '.json_encode($headers),'info');
        $this->log('data: '.json_encode($data),'info');
        $this->curl->post($url,$data);
        $this->log("URL : ".json_encode($url),"info");
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function getAgentNotHeardDetails1($headers, $data, $url){
        //$url = $this->api->getParacloudUrl('agentNotHeard');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        //$url = $url."?noOfDays=".$days;
        $this->curl->setHeaders($headers);
        $this->log('Header: '.json_encode($headers),'info');
        $this->log('data: '.json_encode($data),'info');
        $this->curl->post($url,$data);
        $this->log("URL : ".json_encode($url),"info");
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function downloadAgentNotHeardReport($headers, $data){
        $url = $this->api->getParacloudUrl('agentNotHeardExcel');
	//$url = $url."?noOfDays=".$days;
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilized($headers){
        $url = $this->api->getUrl('storageUtilized');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilizedByPG($headers){
        $url = $this->api->getUrl('storageUtilizedByPG');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getFailedBackup($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('failedBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/failedBackup?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFailedBackup1($headers,$data,$url){
        //$url = $this->api->getUrl('failedBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;	
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getStorageTrend($startDate, $toDate){
        $url = $this->api->getUrl('storageTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	$data = [];
	Model::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBlobTrend($startDate, $toDate){
        $url = $this->api->getUrl('blobTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	$data = [];
	Model::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBackupTrend($startDate, $toDate){
        $url = $this->api->getUrl('backupTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	$data = [];
	Model::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserDeviceHistory($headers){
        $url = $this->api->getUrl('userDeviceHistory');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserBackupHistory($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('userBackupHistory');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/user/backupHistory?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
         $this->log("data :".json_encode($data),'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUserBackupHistory1($headers,$data,$url){
	//$url = $this->api->getUrl('userBackupHistory');
	$url = PROTOCOL.PARACLOUD_IP.$url;	
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
        $this->log("data :".json_encode($data),'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDailyUserBackupOverview($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('dailyUserBackupOverview');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/storageUtilizitaion?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDailyUserBackupOverview1($headers,$data,$url){
	//$url = $this->api->getUrl('dailyUserBackupOverview');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadDailyUserBackupOverview($headers,$data){
        $url = $this->api->getUrl('downloadDailyUserBackupOverview');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceBackupHistory($headers){
        $url = $this->api->getUrl('deviceBackup');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceUserHistory($headers){
        $url = $this->api->getUrl('deviceUserHistory');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLastBackupDetails($headers){
        $url = $this->api->getUrl('lastBackupDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getAlertHistory($headers){
        $url = $this->api->getUrl('alertHistory');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserMigration($headers, $pageNumber){
        //$url = $this->api->getUrl('userMigration');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/report/adReports?pageNumber=".$pageNumber;
	$data = [];
	Model::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUserMigration1($headers, $url){
        //$url = $this->api->getUrl('userMigration');
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReport($headers,$data){
        $url = $this->api->getUrl('overviewReport');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadSyncOverViewReport($headers){
        $url = $this->api->getUrl('syncOverviewReportDownload');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReportSync($headers){
        $url = $this->api->getUrl('overViewReportSync');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllPolicyName($headers){
	//$url = $this->api->getUrl('getAllPolices');
	$url = $this->api->getUrl('newBackup');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveEventHubCurrentBackup($headers, $data){
        $url = $this->api->getParacloudUrl('saveEventHub');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response 
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadNobackupReportExcel($headers,$data){
         $url = $this->api->getUrl('noBackupExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
 
     public function downloadFailedBackupReportExcel($headers,$data){
         $url = $this->api->getUrl('failedBackupExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
 
     public function downloadRestoreHistoryReportExcel($headers,$data){
         $url = $this->api->getUrl('restoreHistoryExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
 
 
     public function downloadUserBackupHistoryExcel($headers,$data){
         $url = $this->api->getUrl('downloadBackupHistoryExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
    
    public function getSyncStatistics($headers){
        $url = $this->api->getUrl('cloudLicense');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUserBackupSummary($headers,$data){
         $url = $this->api->getParacloudUrl('getUserBackupSummary');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
    
    public function downloadUserBackupSummaryReport($headers, $data){
        $url = $this->api->getParacloudUrl('userBackupSummaryExcel');
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function downloadUserBackupHistoryPdf($headers,$data){
         $url = $this->api->getParacloudUrl('downloadBackupHistoryPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
    
    public function downloadUserBackupSummaryReportPdf($headers, $data){
        $url = $this->api->getParacloudUrl('userBackupSummaryPdf');
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function downloadOverViewReportPdf($headers,$data){
        $url = $this->api->getParacloudUrl('overviewReportPdf');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadFailedBackupReportPdf($headers,$data){
         $url = $this->api->getParacloudUrl('failedBackupPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
     
     public function downloadNobackupReportPdf($headers,$data){
         $url = $this->api->getParacloudUrl('noBackupPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
     
     public function downloadRestoreHistoryReportPdf($headers,$data){
         $url = $this->api->getParacloudUrl('restoreHistoryPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
     
     public function downloadDailyUserBackupOverviewPdf($headers,$data){
        $url = $this->api->getParacloudUrl('downloadDailyUserBackupOverviewPdf');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function downloadAgentNotHeardReportPdf($headers, $data){
        $url = $this->api->getParacloudUrl('agentNotHeardPdf');
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function usersWithoutDevicesView($headers,$data,$pageNumber){
        //$url = $this->api->getUrl('userBackupHistory');
        $data = '';
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/users/userWithoutDevice?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function usersWithoutDevicesView1($headers,$data,$url){
        $data = '';
	//$url = $this->api->getUrl('userBackupHistory');
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadUsersWithoutDevices($headers){
        $data = '';
        $url = $this->api->getParacloudUrl('downloadUsersWithoutDevicesExcel');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getScheduleReport($headers,$schedulerName){
         $url = $this->api->getParacloudUrl('getScheduleReport', array('schedulerName' => $schedulerName));
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }

    public function saveScheduleReport($headers,$data,$schedulerName){
         $url = $this->api->getParacloudUrl('saveScheduleReport', array('schedulerName' => $schedulerName));
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }

    public function usersMailId($headers){
        $url = $this->api->getParacloudUrl('getEmailIds');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteSchedule($headers,$schedulerName){
         $url = $this->api->getParacloudUrl('deleteReportSchedule', array('schedulerName' => $schedulerName));
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->delete($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
	
    public function stopRestore($headers){
        $url = $this->api->getParacloudUrl('stopRestore');
	$data = [];
	Model::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function viewRestoreProgress($headers,$deviceUUID){
         $url = $this->api->getBlukryptUrl('viewRestoreProgress', array('deviceUUID' => $deviceUUID));
         Model::req($url,$headers,$deviceUUID);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
	
    public function viewRestoreProgressEndpoint($headers,$deviceUUID){
         $url = $this->api->getParacloudUrl('viewRestoreProgressEndpoint', array('deviceUUID' => $deviceUUID));
         Model::req($url,$headers,$deviceUUID);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
	
    public function changePasswordForFirstlogin($headers){
        $url = $this->api->getUrl('changePasswordForFirstlogin');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getUsersNoBackupDetails($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('noBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/noBackup?pageNumber=".$pageNumber;
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getUsersNoBackupDetails1($headers,$data,$url){
     	//$url = $this->api->getUrl('noBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function downloadUsersNobackupReportExcel($headers,$data){
         $url = $this->api->getUrl('noBackupExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

    public function downloadUsersNobackupReportPdf($headers,$data){
         $url = $this->api->getParacloudUrl('noBackupPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
	
    public function getAllMiniClouds($headers){
        $url = $this->api->getUrl('allMiniClouds');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getMinicloudActivityHistory($headers, $pageNumber){
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/mc/activities?pageNumber=".$pageNumber;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getMinicloudActivityHistory1($headers, $url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function minicloudActivityExcel($headers){
         $url = $this->api->getParacloudUrl('minicloudActivityExcel');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
     
     public function minicloudActivityPdf($headers){
         $url = $this->api->getParacloudUrl('minicloudActivityPdf');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
	
    public function getProductOverview($headers, $data){
        $url = $this->api->getParacloudUrl('getProductOverview');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getAllSyncPolicyName($headers){
            $url = $this->api->getUrl('newSync');
	    $data = [];
	    Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }

    public function downloadProductOverview($headers,$data){
        $url = $this->api->getParacloudUrl('downloadProductOverview');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function downloadProductOverviewToPdf($headers,$data){
        $url = $this->api->getParacloudUrl('downloadProductOverviewToPdf');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveScheduleReportProductOverview($headers,$data,$schedulerName){
         $url = $this->api->getParacloudUrl('saveScheduleReportProductOverview', array('schedulerName' => $schedulerName));
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
	
    public function getIncompleteBackup($headers,$data,$pageNumber){
	//$url = $this->api->getUrl('failedBackup');
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/incompleteBackupActivityHistory?pageNumber=1";
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getIncompleteBackup1($headers,$data,$url){
     	//$url = $this->api->getUrl('failedBackup');
	$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function downloadIncompleteBackupReportExcel($headers,$data){
         $url = $this->api->getParacloudUrl('incompleteBackupExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

     public function downloadIncompleteBackupReportPdf($headers,$data){
         $url = $this->api->getParacloudUrl('incompleteBackupPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
	
    public function downloadUserMigration($headers){
        $url = $this->api->getUrl('downloadUserMigration');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveEventHubMsp($headers, $data){
        $url = $this->api->getParacloudUrl('saveEventHub');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Result_headers'.json_encode($headers), 'info');
        $this->log('Result_data'.json_encode($data), 'info');
        $this->log('Result_url'.json_encode($url), 'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function userDevicePolicyInfoMsp($headers){
        $url = $this->api->getUrl('userDevicePolicyInfo');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getDeviceOverview($headers,$data,$pageNumber){
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/BackupBatch?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
        $this->log("data :".json_encode($data),'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDeviceOverview1($headers,$data,$url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
        $this->log("data :".json_encode($data),'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function downloadDeviceOverviewReportExcel($headers,$data){
         $url = $this->api->getUrl('deviceOverviewExcel');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }

    public function downloadDeviceOverviewReportPdf($headers,$data){
         $url = $this->api->getUrl('deviceOverviewPdf');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url,$data);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }

    public function getAllOfficePolicyName($headers){
        $url = $this->api->getUrl('newOffice');
        $data = [];
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
