<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <!--<li><h3><?=Language::show('BluSync Dashboard', 'keywords')?> </h3></li>
                <li><?=Language::show('manageMiniClouds', 'keywords')?></li>-->
		<li><h3><?=Language::show('manageMiniClouds', 'keywords')?> </h3></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncController">
    <span class="d-none currentPage"><?='miniClouds'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('manageMiniClouds', 'keywords')?>
		         <a ng-click='exportMiniCloudsToExcel()' class="btn btn-small pull-right" style="margin-right: 10px;">Export MiniClouds</a>
		    </h4>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                    <?php if(!empty($data['miniClouds'])){ ?>
                        <ul class="list-group">
                            <?php foreach($data['miniClouds'] as $key => $value){ ?>
                                <?php if(!empty($value->{'mini-cloud-name'})){ ?>
                                    <li class="list-group-item">
                                        <?php
                                            $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                        ?>
                                        <?=$trimmedName?> (Owner : <?=$value->{'owner'}?>)
                                        <?php if($value->{'mcDisableDate'} != ''){
                                                $expiryDate = strtotime($value->{'mcDisableDate'});
                                                $expiryDate1 = strtotime($value->{'mcDisableDate'}." +1 day");
                                                $now = strtotime("now");
                                                if($now > $expiryDate1){
                                                        $date=date_create($value->{'mcDisableDate'});
                                                        date_add($date,date_interval_create_from_date_string("1 days"));
                                                        $isExpired = 'Expired On: '.date_format($date,"d-M-Y"). ' 12:00:00 AM';
                                                        $expiryStatus = 'expired';
                                                }else{
                                                        $isExpired = '';
                                                        $timeDiff = abs($expiryDate1 - $now);
                                                        $numberDays = intval($timeDiff/86400);
                                                        $date=date_create($value->{'mcDisableDate'});
                                                        date_add($date,date_interval_create_from_date_string("1 days"));

                                                        if($numberDays <= 7){
                                                                $isExpired = 'Expires On: '.date_format($date,"d-M-Y"). ' 12:00:00 AM';
                                                                //$isExpired = 'Expires On: '.$value->{'mcDisableDate'};
                                                        }
                                                        $expiryStatus = 'notexpired';
                                                }?>
					<span class="blink_me"> <?=$isExpired?></span>
                                        <?php } else { $expiryStatus = 'notexpired'; } ?>
                                        <span class="<?php if(!isMobile()){?> pull-right <?php } ?>" style="margin-top: -2px;">
                                            <?php if($data['loggedInUser']['admin'] == true){ ?>
						<a class="btn btn-default btn-small" ng-click="getMiniCloud('<?=$value->{'mini-cloud-name'}?>')">Edit</a>
                                                <a class="btn btn-default btn-small deleteMiniCloudBtn<?=md5($value->{'mini-cloud-name'})?>"
                                                   ng-bootbox-confirm="<?=Language::show('miniCloudDeleteConfirm', 'keywords')?>"
                                                   ng-bootbox-confirm-action="deleteMiniCloudByAdmin('<?=$value->{'mini-cloud-name'}?>', 'admin')"
                                                   ng-bootbox-confirm-action-cancel=""
                                                   href="javascript:;"><i class="fa fa-trash"></i> Delete</a>
                                                <a class="btn btn-default btn-small" onclick="addCurrentOwner('<?=md5($value->{'mini-cloud-name'})?>')" ng-click="loadChangeOwnerShipModal('<?=$value->{'mini-cloud-name'}?>')">Change Ownership</a>
                                            <?php } ?>
                                            <?php if($value->{'owner'} == $data['loggedInUser']['userName']){ ?>
                                            	<a class="btn btn-small btn-success <?php if($expiryStatus == 'expired'){?> disabled <?php } ?>" onclick="addAssignUsers('<?=md5($value->{'mini-cloud-name'})?>')" ng-click="loadAssignUsersModal('<?=$value->{'mini-cloud-name'}?>')">Attach cloud to users</a>
                                            <?php } ?>
                                            <span class="d-none ownerFor<?=md5($value->{'mini-cloud-name'})?>"><?=$value->{'owner'}?></span>
                                            <span class="d-none attachedUsersFor<?=md5($value->{'mini-cloud-name'})?>"><?=$value->{'assigned-users'}?></span>
                                        </span>
                                    </li>
                                <?php } ?>
                            <?php } ?>
                        </ul>
                    <?php }else{ ?>
                        <h3 class="text-center">There are no MiniClouds to manage</h3>
                    <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>

    <div class="modal fade" id="ownerShipChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'ownerShipForm',
                'autocomplete' => 'off',
                'ng-submit' => 'changeOwnerForMiniCloud()',
                'data-parsley-validate' => true
            ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
		    <h4 class="modal-title">Assign a new owner to manage the selected mini cloud</h4>
		    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group d-none">
                        <label for="ownerShipMiniCloud"></label>
                        <input name="miniCloudName" id="ownerShipMiniCloud" type="text"/>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="form-control ownerShipChange" style="width: 100%;" name="owner" id="selectOwnerShip" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary changeOwnerSaveBtn" disabled>Save changes</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
    <div id="editMiniCloud" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
            <div class="modal-header">
                        <h4 class="modal-title">Edit MiniCloud</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <div>
                    <form class="row col-lg-12 newForm" ng-submit="saveMiniCloud()">
			<span class="csrf_token hide"><?=$data['csrf_token'];?></span>
                        <div class="form-group col-lg-10">
                            <label for="miniCloudName">MiniCloud Name</label>
                            <input type="text" style="width: 100%;" class="form-control" name="edit_miniCloudName" id="edit_miniCloudName" placeholder="Enter a Mini Cloud Name" readonly>
                        </div>
<!--new start-->
<div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
        <label style="margin-top:7px;" for="miniCloudSettings"><?=Language::show('MiniCloud Settings', 'keywords');?></label>
        <div class="row">
                <div class="form-group col-lg-6">
                        <label class="col-lg-12" style="margin-left: -14px;" for="mcQuota"><?=Language::show('MiniCloud Quota', 'keywords');?> (In GB)</label>
                        <div class="row">
                                <div class="col-lg-2">
                                        <label class="switch">
                                        <input id="edit_switchsize" type="checkbox">
                                        <div class="slider round"></div>
                                        </label>
                                </div>
                                <div class="col-lg-6">
                                        <input type="text" class="form-control" name="edit_mcQuota" id="edit_mcQuota" placeholder="Enter MiniCloud Quota" required autocomplete="off" value="UNLIMITED" onfocusout="edit_myFunctionMPS();" disabled/>
                                        <span id="edit_sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
				</div>
                </div>
                <div class="form-group col-lg-6">
                        <label class="col-lg-12" style="margin-left: -14px;" for="miniCloudExpiry"><?=Language::show('MiniCloud Expiry', 'keywords');?></label>
                        <div class="row">
                                <div class="col-lg-2">
                                        <label class="switch">
                                                <input id="edit_switchmcDisabled" name="edit_switchmcDisabled" type="checkbox">
                                                <div class="slider round"></div>
                                        </label>
                                </div>
                                <div class="col-lg-6">
                                        <input type="text" class="form-control edit_mcDisableDate" id="edit_mcDisableDate" placeholder="Valid Till" data-parsley-trigger="change" disabled/>
                                </div>
                        </div>
                </div>
        </div>
</div>
<!--new end-->
                        <br>
                        <div class="col-lg-12" style="margin-top:10px;">
                            <button type="submit" class="btn btn-default float-right" style="margin-left:5px;">Save</button>
                            <button type="button" class="btn btn-default float-right" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
    <div class="modal fade" id="assignUsers" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'assignUsersForMiniCloud',
                'autocomplete' => 'off',
                'ng-submit' => 'assignUsersForMiniCloud()',
                'data-parsley-validate' => true
            ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
		    <h4 class="modal-title">Assign users selected  for mini cloud</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group d-none">
                        <label for="assignUsersMiniCloud"></label>
                        <input name="miniCloudName" id="assignUsersMiniCloud" type="text" value="" required/>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="assignUsers" name="userNames[]" style="width: 100%;" id="selectAssignUsers" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary assignSaveBtn">Save changes</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    var owner = $(".ownerShipChange").select2({
        maximumSelectionLength: 1,
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            //url: "<?=DIR?>"+"user/getAllUnBlockedUsersWithLoggedInUser",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select a Owner'
    });

    function addCurrentOwner(selectedMiniCloudName) {
        owner.val(null).trigger("change");
        var miniClouds = $('.ownerFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectOwnerShip').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#ownerShipChange').modal('show');
        owner.val(miniClouds).trigger("change");
    }

    var assignUsers = $(".assignUsers").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsers').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }

    $('#ownerShipChange').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });

    $('#assignUsers').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });

</script>
<script>
$('.edit_mcDisableDate').datepicker({
        format: 'dd-M-yyyy',
        //format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
});

$("#edit_switchsize").click(function(){
        document.getElementById("edit_sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        	$('#edit_mcQuota').removeAttr('disabled'); //enable input
		$('#edit_mcQuota').attr('readonly', false);
        	$('#edit_mcQuota').val('');
    	}else{
        	$('#edit_mcQuota').attr('disabled', true); //disable input
		$('#edit_mcQuota').attr('readonly', true);
        	$('#edit_mcQuota').val('UNLIMITED');
    	}
});

function edit_myFunctionMPS(){        
        document.getElementById("edit_sizeerror").innerHTML = "";
        if(isNaN($('#edit_mcQuota').val()))
        {
		if (  $('#edit_mcQuota').val() !='UNLIMITED')  {
		    document.getElementById("edit_sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
		}		
	}else if($('#edit_mcQuota').val() < 1){
            document.getElementById("edit_sizeerror").innerHTML = "Minimum Size Allowed is 1";
        }else if(!isNaN($('#edit_mcQuota').val()) && $('#edit_mcQuota').val() > 1000){
             document.getElementById("edit_sizeerror").innerHTML = "Maximum Permissible Size Allowed is 1000";
	}else if($('#edit_mcQuota').val().indexOf(".")!=-1){
            document.getElementById("edit_sizeerror").innerHTML = "Please enter an integral value";
        }else{
            document.getElementById("edit_sizeerror").innerHTML = "";
        }
}

$("#edit_switchmcDisabled").click(function(){
//        document.getElementById("edit_sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        	$('#edit_mcDisableDate').removeAttr('disabled'); //enable input
        	$('#edit_mcDisableDate').val('');
	}else{
	    	$('#edit_mcDisableDate').attr('disabled', true); //disable input
        	$('#edit_mcDisableDate').val('');
	}
});
</script>
<style>
.blink_me {
  animation: blinker 2s linear infinite;
  color: red;
}

@keyframes blinker {
  50% {
    opacity: 0;
  }
}
</style>
