<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Url;
use Helpers\Form; ?>
<div class="container">
    <div class="row hide">
        <div class="col-lg-6 col-lg-offset-3" align="center" style="margin-top: -25px;">
            <?php
            Assets::img(array(
                Url::templatePath() . 'images/login_logo.png',
            ));
            ?>
        </div>
    </div>
    <br/><br/><br/>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading text-center" style="margin-right: 8%; padding: 25px 7px 15px 15px;"></div>
                <div class="panel-body">
                    <!--<div class="col-lg-6" style="margin-top:-40px;">
                        <img src="<?=Url::templatePath()?>images/login_logo.png" />
                    </div>-->
		    <?php if(is_file("/var/www/portal/app/templates/default/collateral/login_logo.png")){ ?>
                        <div class="col-lg-6 col-sm-12 col-xs-12 col-md-12 text-center">
			  <center>
                            <?php if(isMobile()){?>
                                <img style="max-width:100%;"src="<?=Url::templatePath()?>collateral/login_logo.png" alt="PARABLU"/>
                            <?php }else { ?>
                                <img src="<?=Url::templatePath()?>collateral/login_logo.png" alt="PARABLU"/>
                            <?php } ?> 
                        </div>
                    <?php } else { ?>
                        <div class="col-lg-6 col-sm-12 col-xs-12 col-md-12 text-center"> 
                            <?php if(isMobile()){?>
                              <img style="max-width:100%;"src="<?=Url::templatePath()?>images/login_logo.png" alt="PARABLU"/>
                            <?php }else { ?>
                                <img src="<?=Url::templatePath()?>images/login_logo.png" alt="PARABLU"/>
                            <?php } ?>
			</center>
                        </div>
                    <?php }?>
                    <div class="col-lg-6" style="margin-top: 10px;">
                        <div class="error" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                        <?=
                            Form::open(array(
                                'method' => 'post',
                                'class' => 'shareForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                        ?>
			<div class="form-group hide">
                            <label for="timeZone"><?=Language::show('Time Zone', 'keywords');?></label>
                            <input type="text" class="form-control" name="timeZone" id="timeZone" required autocomplete="off" value="<?=$data['fileMultiple']->{'timeZone'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="cloudName"><?=Language::show('cloudName', 'keywords');?></label>
                            <input type="text" class="form-control" name="cloudName" id="cloudName" required autocomplete="off" value="<?=$data['fileMultiple']->{'cloud-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="devicePath"><?=Language::show('devicePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="devicePath" id="devicePath" required autocomplete="off" value="<?=$data['fileMultiple']->{'device-path'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="filePath"><?=Language::show('filePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="filePath" id="filePath" required autocomplete="off" value="<?=$data['filePath']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="syncRevisionId"><?=Language::show('syncRevisionId', 'keywords');?></label>
                            <input type="text" class="form-control" name="syncRevisionId" id="syncRevisionId" required autocomplete="off" value="<?=$data['syncRevisionId']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileSize"><?=Language::show('fileSize', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileSize" id="fileSize" required autocomplete="off" value="<?=$data['fileSize']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileName"><?=Language::show('fileName', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileName" id="fileName" required autocomplete="off" value="<?=$data['fileMultiple']->{'file-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key12"><?=Language::show('key12', 'keywords');?></label>
                            <input type="text" class="form-control" name="key12" id="key12" required autocomplete="off" value="<?=$data['fileMultiple']->{'key-12'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key14"><?=Language::show('key14', 'keywords');?></label>
                            <input type="text" class="form-control" name="key14" id="key14" required autocomplete="off" value="<?=$data['fileMultiple']->{'key-14'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key18"><?=Language::show('key18', 'keywords');?></label>
                            <input type="text" class="form-control" name="key18" id="key18" required autocomplete="off" value="<?=$data['fileMultiple']->{'key-18'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key20"><?=Language::show('key20', 'keywords');?></label>
                            <input type="text" class="form-control" name="key20" id="key20" required autocomplete="off" value="<?=$data['fileMultiple']->{'key-20'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="passwordHash"><?=Language::show('passwordHash', 'keywords');?></label>
                            <input type="text" class="form-control" name="passwordHash" id="passwordHash" required autocomplete="off" value="<?=$data['fileMultiple']->{'password-hash'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="userName"><?=Language::show('userName', 'keywords');?></label>
                            <input type="text" class="form-control" name="userName" id="userName" required autocomplete="off" value="<?=$data['fileMultiple']->{'user-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="secretkey"><?=Language::show('secretkey', 'keywords');?></label>
                            <input type="text" class="form-control" value="<?=$data['secretkey']?>" name="secretkey" id="secretkey">
                        </div>
                        <div class="form-group hide">
                            <label for="googleAuth"><?=Language::show('googleAuth', 'keywords');?></label>
                            <input type="text" class="form-control" name="googleAuth" id="googleAuth" <?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?> value="enabled" <?php }else{ ?> value="disabled" <?php } ?>>
                        </div>
                        <div class="form-group hide">
                            <label for="googleAuth"><?=Language::show('secretKeylist', 'keywords');?></label>
                            <input type="text" class="form-control" name="secretKeyList" id="secretKeyList" value="<?=$data['secretKey']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="toEmailList"><?=Language::show('toEmailList', 'keywords');?></label>
                            <input type="text" class="form-control" name="toEmailList" id="toEmailList" value="<?=$data['toEmailList']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="passwordProtected"><?=Language::show('passwordProtected', 'keywords');?></label>
                            <input type="text" class="form-control" name="passwordProtected" id="passwordProtected" <?php if($data['fileMultiple']->{'is-password-protected'} == 'true'){ ?> value="enabled" <?php }else{ ?> value="disabled" <?php } ?>>
                        </div>
                        <div class="form-group hide">
                            <label for="download"><?=Language::show('download', 'keywords');?></label>
                            <input type="text" class="form-control" name="download" id="download" <?php if($data['fileMultiple']->{'is-download'} == 'true'){ ?> value="enabled" <?php }else{ ?> value="disabled" <?php } ?>>
                        </div>
                        <div class="form-group hide">
                            <label for="view"><?=Language::show('view', 'keywords');?></label>
                            <input type="text" class="form-control" name="view" id="view" <?php if($data['fileMultiple']->{'is-view'} == 'true'){ ?> value="enabled" <?php }else{ ?> value="disabled" <?php } ?>>
                        </div>
                        <?php if($data['fileMultiple']->{'is-password-protected'} == 'true'){ ?>
                            <div class="form-group">
                                <label for="password">Please enter the file access password</label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="Please enter the file access password" required autocomplete="off">
                            </div>
                        <?php } ?>
                        <div class="form-group hide">
                            <label for="gotUserName"><?=Language::show('Got User Name', 'keywords');?></label>
                            <input type="text" class="form-control" name="gotUserName" id="gotUserName" required autocomplete="off" value="<?=$data['gotUsername']?>">
                        </div>
			<span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
                        <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
                        <?php if(multifactorAuthWithAccessCode == true){ ?>
                          <?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?>
                            <div class="form-group">
                                <label>Enter One Time Access Code sent to the registered Email address - <a  onclick="generateOtp()" style="cursor:pointer;">Resend One Time Access Code</a></label>
                                <input class="form-control" type="text" name="otpCode" id="otpCode" required/>
                            </div>
                          <?php } ?>
                        <?php }else{ ?>
                          <?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?>
                              <div class="form-group">
                                  <label>Enter multi-factor authentication code - <a data-toggle="collapse" href="#qrCollapse" role="button" aria-expanded="false" aria-controls="qrCollapse"><span class="aa">Request QR Code</span><span class="aa hide">Request QR Code</span></a></label>
                                  <input class="form-control" type="text" name="code" id="code" required/>
                              </div>
                              <div class="col-lg-12 collapse" id="qrCollapse" style="border: 1px solid rgb(242, 115, 49); margin-bottom: 5px;">
                                  <div class="form-group col-lg-12">
                                      <label for="mailId">Enter the same Email ID where you have received the file link</label>
				      <input type="text" class="form-control" name="mailId" id="mailId" placeholder="Enter the same Email ID where you have received the file link" autocomplete="off">
<a type="button" class="btn btn-success" onclick="requestQR()" style="margin-top:10px;"><?=Language::show('Submit', 'share');?></a>
                                              </div>
<!--                                  <div class="col-lg-2">
                                      <a type="button" class="btn btn-success pull-right" onclick="requestQR()" style="margin-top:25px;"><?=Language::show('Submit', 'share');?></a>
                                  </div>-->
                                  <div class="col-lg-12">
                                      <span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
                                      <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
                                  </div>
                              </div>
                          <?php } ?>
                        <?php } ?>
                      <a type="button" class="view btn btn-primary" onclick="getSharedFiles()" <?php if($data['fileMultiple']->{'is-password-protected'} != 'true' && $data['fileMultiple']->{'googleAuthIsEnabled'} != 'true'){ ?> style="margin-top:19%;"<?php } ?>><?=Language::show('Show Files', 'share');?></a>
                      <?php if(isset($_SESSION['loggedIn'])){ ?>
                            <a href="<?=DIR?>share/filesSharedWithMe" class="view btn btn-primary" <?php if($data['fileMultiple']->{'is-password-protected'} != 'true' && $data['fileMultiple']->{'googleAuthIsEnabled'} != 'true'){ ?> style="margin-top:19%;"<?php } ?>><?=Language::show('Go To Portal', 'share');?></a>
                        <?php } ?>
                        <?=
                            Form::close();
                        ?>
                    </div>
                    <!--multiple start-->
                    <div class="panel col-lg-12 sharedFilesList" style="display:none;">
                      <div class="panel-body">
                        <div class="table-responsive">
                          <ul class="list-group">
                            <?php 
				  $index = 1;
				  foreach($data['multipleList'] as $key => $value){ ?>
                              <li class="list-group-item" title="<?=$value->{'file-name'};?>">
				<?php $label = $value->{'file-name'};
                                        if( strlen( $value->{'file-name'} ) > 100 ) {
                                        	$label = substr( $label, 0, 100 ) . '...';
                                	}
				?>
                                <?=$index.'.';?> <?=$label;?>
                                <span class="<?php if(!isMobile()){?> pull-right <?php } ?>" style="margin-top: -2px;">
                                  <?php if($value->{'is-view'} == 'true'){ ?>
                                  <a type="button" class="view btn btn-small btn-primary" onclick="checkAndProceedMultiple(false, '<?=$value->{'backup-id'}?>', '<?=$value->{'file-name'}?>', '<?=$value->{'device-path'}?>', '<?=$value->{'user-name'}?>','<?=$value->{'is-backup'}?>')"><?=Language::show('view', 'share');?></a>
                                  <?php } ?>
                                  <?php if($value->{'is-download'} == 'true'){ ?>
                                  <a type="button" class="download btn btn-small btn-primary" onclick="checkAndProceedMultiple(true, '<?=$value->{'backup-id'}?>', '<?=$value->{'file-name'}?>', '<?=$value->{'device-path'}?>', '<?=$value->{'user-name'}?>', '<?=$value->{'is-backup'}?>')"><?=Language::show('download', 'share');?></a>
                                  <?php } ?>
                                </span>
			    <?php $index++;?>
                            <?php } ?>
                          </ul>
                        </div>
                      </div>
                    </div>
                    <!--multiple ends-->
                </div>
            </div>
        </div>
    </div>
    <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="background-color:white;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h5 class="modal-title">Loading ...</h5>
                </div>
                <br/><br/>
                <div class="modal-body" <?php if($data['file']->{'is-download'} != 'true'){ ?> style="-webkit-user-select: none;-khtml-user-select: none;-moz-user-select: -moz-none;-o-user-select: none;user-select: none;" <?php } ?>>
                    <div class="pageContainer" style="background-color: white;display: none;"></div>
                    <div class="pdfContainer" style="display: none;"></div>
                    <div class="excelContainer" style="background-color: white;display: none;"></div>
                    <div class="content" style="text-align: -webkit-auto;display: none;"></div>
                    <div class="imageViewer" style="display: none;"></div>
                    <div class="pptxViewer" style="background-color: white;display: none;"></div>
                    <div class="paraviewLoading" style="margin-top: 15%">
                        <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

/* USER-AGENTS
================================================== */
function check_user_agent ( $type = NULL ) {
        $user_agent = strtolower ( $_SERVER['HTTP_USER_AGENT'] );
        if ( ($type == 'bot' && (preg_match ( "/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent ))) ||  ( $type == 'browser' && preg_match ( "/mozilla\/|opera\//", $user_agent )) || ( $type == 'mobile' && preg_match ( "/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent )  )) {           
                        return true;
        }
        return false;
}


?>
<script src="<?=Url::templatePath('default/js/plugins/tiff.min.js');?>" type="text/javascript" charset="UTF-8"></script>
<script>
    function getSharedFiles(){
        $('.error').html('');
        $('.error').hide();
	$('.error').removeClass('parsley-error');
        $('.error').removeClass('parsley-success');
        <?php if(multifactorAuthWithAccessCode == true){ ?>
		var code = $('#otpCode').val();
		<?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?>
			if(code == ''){
				$('.error').html('One Time Access Code cannot be empty');
				$('.error').addClass('parsley-error');
				$('.error').show();
				return false;
			}
		<?php } ?>
	<?php } else { ?>       
		var code = $('#code').val();
		<?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?>
			if(code == ''){
				$('.error').html('Authentication Code cannot be empty');
				$('.error').addClass('parsley-error');
				$('.error').show();
				return false;
			}
		<?php } ?>
	<?php } ?>
	<?php if($data['fileMultiple']->{'is-password-protected'} == 'true'){ ?>
		if($('#password').val() == ''){
			$('.error').html('Password Field cannot be empty');
			$('.error').addClass('parsley-error');
			$('.error').show();
			return false;
		}
		var type = true;
		$.ajax({
			url: '<?=DIR?>'+'share/checkPassword',
			method: 'POST',
			data: {password: $('#password').val(), type: type, passwordProtected: $('#passwordProtected').val(),download: $('#download').val(), view: $('#view').val(),passwordHash: $('#passwordHash').val()}
			//data: {password: password, type: type}
		}).done(function(data){
			var jData = JSON.parse(data);
			if(jData.result == 'success'){
	<?php } ?>
        var data = {accessType: 'view',key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), accessKey: code, googleAuth:$('#googleAuth').val(),userId: $('#gotUserName').val(),secretKeyList: $('#secretKeyList').val()};
        $.ajax({
            url: '<?=DIR?>'+'share/checkIfFileShared',
            method: 'POST',
            data: data
        }).done(function(data){
                console.log("data : "+data);
                var jData = JSON.parse(data);
                console.log("jData : "+jData.message);
                if(jData.result == 'success'){
                        $('.sharedFilesList').show();
                }else{
                        $('.error').html(jData.message);
                        $('.error').show();
                }
        }).fail(function(data){
            var jData = JSON.parse(data);
            $('.error').html(jData.message);
            $('.error').show();
        });
	<?php if($data['fileMultiple']->{'is-password-protected'} == 'true'){ ?>    
		}else if(jData.result == 'fail'){
			$('.error').html(jData.message);
			$('.error').show();
			$('.sharedFilesList').hide();
		    }
		}).fail(function(data){
			console.log(data);
			$('.sharedFilesList').hide();
		});
	<?php } ?>
}

<?php if(multifactorAuthWithAccessCode == true){ ?>
function generateOtp(){
        $('.error').html('');
        $('.error').hide();
	document.getElementById("statussuccess").innerHTML = "";
        document.getElementById("statuserror").innerHTML = "";
        console.log("uu : "+$('#gotUserName').val());
        $('#otpCode').val('');
    $.ajax({
            url: '<?=DIR?>'+'generateOtp',
            method: 'POST',
            data: {fileName:$('#fileName').val(), userName: $('#gotUserName').val(),cloudName: $('#cloudName').val()}
        }).done(function(data){
                console.log("data : "+data);
                var jData = JSON.parse(data);
                console.log("jData : "+jData.message);
                if(jData.result == 'success'){
                        //$('.error').html(jData.message);
                        //$('.error').show();
			document.getElementById("statussuccess").innerHTML = jData.message;
                        setTimeout(function(){
                                //$('.error').hide();
				document.getElementById("statussuccess").innerHTML = '';
                        }, 5000);
                }else{
                        document.getElementById("statuserror").innerHTML = jData.message;
                        //$('.error').html(jData.message);
                        //$('.error').show();
                        setTimeout(function(){
                                //$('.error').hide();
				document.getElementById("statuserror").innerHTML = '';
                        }, 5000);
                }
        }).fail(function(data){
            var jData = JSON.parse(data);
            //document.getElementById("statuserror").innerHTML = jData.msg;
            $('.error').html(jData.message);
            $('.error').show();
            setTimeout(function(){
              $('.error').hide();
            }, 5000);
        });
    }
<?php } ?>
    function requestQR(){
        document.getElementById("statussuccess").innerHTML = "";
        document.getElementById("statuserror").innerHTML = "";
        if($('#mailId').val() == ''){
                    return false;
            }
    $.ajax({
            url: '<?=DIR?>'+'checkMail',
            method: 'POST',
            data: {emailId: $('#mailId').val(), toEmailList: $('#toEmailList').val(), secretKeylist: $('#secretKeyList').val(), cloudName: $('#cloudName').val()}
        }).done(function(data){
                console.log("data : "+data);
                var jData = JSON.parse(data);
                console.log("jData : "+jData.msg);
                if(jData.result == 'success'){
                        document.getElementById("statussuccess").innerHTML = jData.msg;
                        $('#mailId').val('');
                        setTimeout(function(){
                                location.reload();
                        }, 5000);                       
                }else{
                        //document.getElementById("statuserror").innerHTML = jData.msg; 
                        document.getElementById("statussuccess").innerHTML = jData.msg;
                        $('#mailId').val('');
                        setTimeout(function(){
                                location.reload();
                        }, 5000);
                }
        }).fail(function(data){
            var jData = JSON.parse(data);
            //document.getElementById("statuserror").innerHTML = jData.msg;
            document.getElementById("statussuccess").innerHTML = jData.msg;
            $('#mailId').val('');
            setTimeout(function(){
              location.reload();
            }, 5000);
        });
    }
  
  /*multiple start*/
    function checkAndProceedMultiple(type, backupId, fileName, filePath, fileUserName){
        $('.error').hide();
        var password = $('[name="password"]').val();
        var backupID = backupId;         
       <?php if($data['fileMultiple']->{'is-password-protected'} == 'true'){ ?>
            if(password.length <= 0){
                $('.error').html('Password Field cannot be empty');
                $('.error').show();
                return;
            }
        <?php } ?>
        <?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true'){ ?>
	<?php if(multifactorAuthWithAccessCode == true){ ?>
		var code = $('[name="otpCode"]').val();
	<?php } else { ?>
		var code = $('[name="code"]').val();
	<?php } ?>
            if(code.length <= 0){
                <?php if(multifactorAuthWithAccessCode == true){ ?>
                        $('.error').html('One Time Access Code cannot be empty');
                <?php } else { ?>
                        $('.error').html('Authentication Code cannot be empty');
                <?php } ?>
                $('.error').show();
                return;
            }
        <?php } ?>
        $.ajax({
            url: '<?=DIR?>'+'share/checkPassword',
            method: 'POST',
            data: {password: password, type: type, passwordProtected: $('#passwordProtected').val(),download: $('#download').val(), view: $('#view').val(),passwordHash: $('#passwordHash').val()}
            //data: {password: password, type: type}
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                var accessType;
                if(type){
                    accessType = 'download';
                }else{
                    accessType = 'view';
                }
                <?php if(multifactorAuthWithAccessCode == true){?>
                	var data = {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), accessKey: $('#otpCode').val(), googleAuth:$('#googleAuth').val(),userId: $('#gotUserName').val()};
                <?php } else { ?>
                	var data = {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), accessKey: $('#code').val(), googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val()};
                <?php } ?>
                $.ajax({
                    url: '<?=DIR?>'+'share/checkIfFileShared',
                    method: 'POST',
                    data : data
                }).done(function(data){
                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                            if(type){
			      var otpCode = '';
			      <?php if(multifactorAuthWithAccessCode == true){?>
                                    otpCode = $('#otpCode').val();
			      <?php }else{ ?>
                                    otpCode = '';
			      <?php } ?>
			      <?php if($data['fileMultiple']->{'googleAuthIsEnabled'} == 'true' && multifactorAuthWithAccessCode == false){ ?>
                                    //otpCode = $('#code').val();
				    otpCode = '';
			      <?php }else{ ?>                             
                                    otpCode = '';
			      <?php } ?>
<?php if(!isset($_SESSION['token'])){
$_SESSION['token'] = '';
                              }
?>
                              var encodedFileName = "<?=urlencode("fileName")?>";
                              window.open('<?=BLUKRPT_URL_WITHOUT_IP?>'+'<?=CLOUD_NAME?>'+'/portal/download/files/?fileName='+Base64.encode(htmlspecialchars_decode(fileName))+'&filePath='+Base64.encode(htmlspecialchars_decode(filePath))+'&token=<?=$_SESSION["token"]?>&loginUserName='+Base64.encode(htmlspecialchars_decode(fileUserName))+'&userName='+Base64.encode(htmlspecialchars_decode(fileUserName))+'&backupID='+backupID+'&path='+Base64.encode(htmlspecialchars_decode(filePath))+'/'+Base64.encode(htmlspecialchars_decode(fileName))+'&deviceUUID=Portal&isSync=true'+'&accessKey='+otpCode+'&userId='+$('#gotUserName').val(), '_self');
//                            }
                        }else{
                            viewMultiple(password, backupID, filePath, fileName, fileUserName);
                        }
                    }else if(jData.result == 'fail'){
                        $('.error').html(jData.message);
                        $('.error').show();
                    }else{
                        window.location.href = '404';
                    }
                });
            }else if(jData.result == 'fail'){
                $('.error').html(jData.message);
                $('.error').show();
            }
        }).fail(function(data){
            console.log(data);
        });
    }

  function viewMultiple(password, backupID, filePath, fileName, fileUserName){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();
        $('#paraviewContainer').modal('show');
        var url = '<?=DIR?>'+'share/view';
        var isSync = true;
        var name = fileName;
        var abc = name.substring(name.lastIndexOf('.') + 1);
        <?php if(multifactorAuthWithAccessCode == true){?>
          var code = $('#otpCode').val();
        <?php } else { ?>
          var code = $('#code').val();
        <?php } ?>
        $.ajax({
        url: url,
            data: {path:filePath, fileName:fileName, syncRevisionId: backupID, userName:fileUserName, password:password, backupID: backupID, isSync: isSync, cloudName: $('#cloudName').val(),passwordProtected: $('#passwordProtected').val(),passwordHash: $('#passwordHash').val(),code: code, googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val(),userId:$('#gotUserName').val()},
            type: 'POST'
        }).done(function(data){
            $('#paraviewContainer .modal-content').css("background-color","white");
            if(abc == 'txt' || abc == 'TXT' || abc == 'log' || abc == 'LOG'){
                $('#paraviewContainer .modal-title').html(fileName);
                $('.content').html('<pre>'+data+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else{
            var jData = JSON.parse(data);
                    if(jData.result == 'fail'){
                        $('#paraviewContainer').modal('hide');
                        $('.error').html(jData.message);
                        $('.error').show();
                        return;
                    }
            if(jData.type == 'image') {
              $('#paraviewContainer .modal-title').html(fileName);
                if(abc == 'TIFF' || abc == 'tiff' || abc == 'TIF' || abc == 'tif'){
                    console.log("inside tif loop");
                    $('.imageViewer').html('<center><span id="tifSpinner"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>');
                    /*start*/
                    Tiff.initialize({TOTAL_MEMORY: 16777216 * 10});
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', jData.fileName);
                    xhr.responseType = 'arraybuffer';
                    xhr.onload = function (e) {
                        var buffer = xhr.response;
                        var tiff = new Tiff({buffer: buffer});
                        for (var i = 0, len = tiff.countDirectory(); i < len; ++i) {
                            tiff.setDirectory(i);
                            var canvas = tiff.toCanvas();
                            console.log("gggggggggg");
                            $('.imageViewer').append(canvas);
                        }
                        $('#tifSpinner').hide();
                    };                  
                    xhr.send();
                    /*end*/
                }else{
                    $('.imageViewer').html(jData.html);     
                }
                $('.imageViewer').show();
                $('.paraviewLoading').hide();
            }else if(jData.type == 'pptx' || jData.type == 'ppt'){
              $('#paraviewContainer .modal-title').html(fileName);
                $('.paraviewLoading').hide();
                $('.pptxViewer').show();
                if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)){
                    // true for mobile device
                    $('.pptxViewer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 22px solid #444343;position:absolute;width:34%;bottom:1%;right:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="-webkit-fill-available" height="-webkit-fill-available" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                }else{
                    // false for not mobile device
                    $('.pptxViewer').html('<p class="text-left">Note: Please use arrow keys to navigate between slides</p><div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 30px solid white;position:absolute;width:100%;bottom:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                    document.getElementsByTagName('iframe').autofocus;
                }
            }else if(jData.type == 'pdf') {            
                $('#paraviewContainer .modal-title').html(fileName);
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();
            }else if(jData.type == 'odt') {         
                $('#paraviewContainer .modal-title').html(fileName);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);
            }else if(jData.type == 'text') {    
                $('#paraviewContainer .modal-title').html(fileName);
                $('.content').html('<pre>'+jData.html+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else if(jData.type == 'excel') {
                $('#paraviewContainer .modal-title').html(fileName);
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                $('.excelContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div style="height: 85%;width: 86%;position: absolute;"><div id="overlay12" style="border-bottom: 31px solid white;position:absolute;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
            }else{
                $('#paraviewContainer .modal-title').html(fileName);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                $('.pageContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div style="height: 565px;width: 80%;position: absolute;"><div id="overlay12" style="border-bottom: 25px solid white;position:absolute;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
            }
        }
        }).fail(function(data){
                console.log("dataaaa : "+data.status);
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/sleep';
                }, 3000);
            }else if(data.status == 451){
                $('.error').html(data.message);
                        $('.error').show();
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/serviceDown';
                }, 3000);
            }
        });

    }
/*multiple ends*/
  
  function checkAndProceed(type){
        $('.error').hide();
        var password = $('[name="password"]').val();
        var backupID = "<?=$data['backupID']?>"         
       <?php if($data['file']->{'is-password-protected'} == 'true'){ ?>
            if(password.length <= 0){
                $('.error').html('Password Field cannot be empty');
                $('.error').show();
                return;
            }
        <?php } ?>
        <?php if($data['file']->{'googleAuthIsEnabled'} == 'true'){ ?>
<?php if(multifactorAuthWithAccessCode == true){ ?>
var code = $('[name="otpCode"]').val();
<?php } else { ?>
            var code = $('[name="code"]').val();
<?php } ?>
        if(code.length <= 0){
                <?php if(multifactorAuthWithAccessCode == true){ ?>
                        $('.error').html('Otp cannot be empty');
                <?php } else { ?>
                        $('.error').html('Authentication Code cannot be empty');
                <?php } ?>
                $('.error').show();
                return;
            }
        <?php } ?>
        $.ajax({
            url: '<?=DIR?>'+'share/checkPassword',
            method: 'POST',
            data: {password: password, type: type, passwordProtected: $('#passwordProtected').val(),download: $('#download').val(), view: $('#view').val(),passwordHash: $('#passwordHash').val()}
            //data: {password: password, type: type}
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                var accessType;
                if(type){
                    accessType = 'download';
                }else{
                    accessType = 'view';
                }
<?php if(multifactorAuthWithAccessCode == true){?>
                var data = {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), accessKey: $('#otpCode').val(), googleAuth:$('#googleAuth').val(),userId: $('#gotUserName').val()};
<?php } else { ?>
                var data = {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), code: $('#code').val(), googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val()};
<?php } ?>
                $.ajax({
                    url: '<?=DIR?>'+'share/checkIfFileShared',
                    method: 'POST',
                    data : data
//                  data: {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), accessKey: $('#otpCode').val(), googleAuth:$('#googleAuth').val(),userId: $('#gotUserName').val()}
//                    data: {accessType: accessType,key12 : $('#key12').val(),key14 : $('#key14').val(),key18 : $('#key18').val(),key20 : $('#key20').val(), code: $('#code').val(), googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val()}
                    //data: {accessType: accessType}
                }).done(function(data){
                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        if(type){
                            if(backupID.length > 0){
                                window.open('<?=BLUKRYPT_URL?>'+'<?=CLOUD_NAME?>'+'/portal/download/files/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=base64_encode($data['file']->{'user-name'})?>'+'&isSync=false'+'&deviceUUID='+'&backupID='+backupID+'&loginUserName=<?=base64_encode($data["file"]->{"user-name"})?>'+'&accessKey='+$('#otpCode').val()+'&userId='+$('#gotUserName').val(), '_self');
                            }else{
                                //window.open('<?=BLUKRPT_URL_WITHOUT_IP?>'+'<?=CLOUD_NAME?>'+'/sync/portal/download/file/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=base64_encode($data['file']->{'user-name'})?>&syncRevisionId=<?=$data['syncRevisionId']?>&path='+encodeURIComponent("<?=$data['filePath']?>")+'/'+encodeURIComponent("<?=urlencode($data['file']->{'file-name'})?>"), '_self');
                                window.open('<?=BLUKRPT_URL_WITHOUT_IP?>'+'<?=CLOUD_NAME?>'+'/portal/download/files/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&loginUserName=<?=base64_encode($data["file"]->{"user-name"})?>&userName=<?=base64_encode($data['file']->{'user-name'})?>&backupID=<?=$data['syncRevisionId']?>&path='+encodeURIComponent("<?=$data['filePath']?>")+'/'+encodeURIComponent("<?=urlencode($data['file']->{'file-name'})?>")+'&deviceUUID=Portal&isSync=true'+'&accessKey='+$('#otpCode').val()+'&userId='+$('#gotUserName').val(), '_self');
                            }
                        }else{
                            view(password, backupID);
                        }
                    }else if(jData.result == 'fail'){
                        $('.error').html(jData.message);
                        $('.error').show();
                    }else{
                        window.location.href = '404';
                    }
                });
            }else if(jData.result == 'fail'){
                $('.error').html(jData.message);
                $('.error').show();
            }
       }).fail(function(data){
            console.log(data);
        });
    }    
    
    function view(password, backupID){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        var url = "";
        if(backupID.length > 0){
            url = '<?=DIR?>backup/share/view';
            isSync = false;
        }else{
            url = '<?=DIR?>share/view';
            isSync = true;
        }
        var name = $('#fileName').val();
        var abc = name.substring(name.lastIndexOf('.') + 1);
        $.ajax({
        url: url,
                data: {path:Base64.encode(htmlspecialchars_decode($('#filePath').val())), fileName:'<?=urlencode($data['file']->{'file-name'})?>', syncRevisionId: '<?=$data['syncRevisionId']?>', userName:'<?=$data['file']->{'user-name'}?>', password:password, backupID: backupID, isSync: isSync, cloudName: $('#cloudName').val(),passwordProtected: $('#passwordProtected').val(),passwordHash: $('#passwordHash').val(),code: $('#otpCode').val(), googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val(),userId:$('#gotUserName').val()},
            //data: {path:Base64.encode(htmlspecialchars_decode($('#filePath').val())), fileName:'<?=urlencode($data['file']->{'file-name'})?>', syncRevisionId: '<?=$data['syncRevisionId']?>', userName:'<?=$data['file']->{'user-name'}?>', password:password, backupID: backupID, isSync: isSync, cloudName: $('#cloudName').val(),passwordProtected: $('#passwordProtected').val(),passwordHash: $('#passwordHash').val(),code: $('#code').val(), googleAuth:$('#googleAuth').val(), secretkey: $('#secretkey').val(), secretKeyList: $('#secretKeyList').val()},
            type: 'POST'
        }).done(function(data){            
            $('#paraviewContainer .modal-content').css("background-color","white");
            if(abc == 'txt' || abc == 'TXT' || abc == 'log' || abc == 'LOG'){
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.content').html('<pre>'+data+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else{
                var jData = JSON.parse(data);
                    if(jData.result == 'fail'){
                        $('#paraviewContainer').modal('hide');
                        $('.error').html(jData.message);
                        $('.error').show();
                        return;
                    }
            if(jData.type == 'image') {
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                if(abc == 'TIFF' || abc == 'tiff' || abc == 'TIF' || abc == 'tif'){
                    console.log("inside tif loop");
                    $('.imageViewer').html('<center><span id="tifSpinner"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>');
                    
                    Tiff.initialize({TOTAL_MEMORY: 16777216 * 10});
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', jData.fileName);
                    xhr.responseType = 'arraybuffer';
                    xhr.onload = function (e) {
                        var buffer = xhr.response;
                        var tiff = new Tiff({buffer: buffer});
                        for (var i = 0, len = tiff.countDirectory(); i < len; ++i) {
                            tiff.setDirectory(i);
                            var canvas = tiff.toCanvas();
                            console.log("gggggggggg");
                            $('.imageViewer').append(canvas);
                        }
                        $('#tifSpinner').hide();
                    };                  
                    xhr.send();
                    
                }else{
                    $('.imageViewer').html(jData.html);
                }
                $('.imageViewer').show();
                $('.paraviewLoading').hide();
            }else if(jData.type == 'pptx' || jData.type == 'ppt'){
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pptxViewer').show();
                if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)){
                    // true for mobile device
                    $('.pptxViewer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 22px solid #444343;position:absolute;width:34%;bottom:1%;right:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="-webkit-fill-available" height="-webkit-fill-available" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                }else{
                    // false for not mobile device
                    $('.pptxViewer').html('<p class="text-left">Note: Please use arrow keys to navigate between slides</p><div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 30px solid white;position:absolute;width:100%;bottom:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                    document.getElementsByTagName('iframe').autofocus;
                }
            }else if(jData.type == 'pdf') {            
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();
            }else if(jData.type == 'odt') {         
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);
            }else if(jData.type == 'text') {
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.content').html('<pre>'+jData.html+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else if(jData.type == 'excel') {
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                <?php if($data['file']->{'is-download'} != 'true'){ ?>
                    $('.excelContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div style="height: 85%;width: 86%;position: absolute;"><div id="overlay12" style="border-bottom: 31px solid white;position:absolute;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php }else{?>
                    $('.excelContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 31px solid white;position:absolute;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php } ?>
            }else{
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                <?php if($data['file']->{'is-download'} != 'true'){ ?>
                    $('.pageContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div style="height: 565px;width: 80%;position: absolute;"><div id="overlay12" style="border-bottom: 25px solid white;position:absolute;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php }else{?>
                    $('.pageContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 25px solid white;position:absolute;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php } ?>
            }
        }
        }).fail(function(data){
                console.log("dataaaa : "+data.status);
                if(data.status == 424){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/sleep';
                }, 3000);
            }else if(data.status == 451){
                $('.error').html(data.message);
                        $('.error').show();
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/serviceDown';
                }, 3000);
            }
        });

    }
  
var Base64 = {


    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",


    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

        }

        return output;
},


    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;
    },

    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {
        c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }

}

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }

    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        });

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }
	
    document.getElementById("password").addEventListener("keyup", function(event) {
      if(event.keyCode === 13) {
      	checkAndProceed(false);
      }
    });
</script>
<style>
canvas{
border: 2px solid black;
margin: 5px;
width:400px;
height:500px;
}
</style>
<?php if($data['fileMultiple']->{'is-download'} != 'true'){ ?>
<script>
	document.addEventListener('DOMContentLoaded', function() {
		//console.log("dom loaded");
	   	document.getElementById("cloudName").focus();
	}, false);
                                
	function copyToClipboard() {
        	//console.log("came inside copyToClipboard");
  		// Create a "hidden" input
  		var aux = document.createElement("input");
  		// Assign it the value of the specified element
  		aux.setAttribute("value", "Not allowed.");
  		// Append it to the body
  		document.body.appendChild(aux);
  		//console.log("val : "+aux.value);
  		// Highlight its content
  		aux.select();
  		// Copy the highlighted text
  		document.execCommand("copy");
  		// Remove it from the body
  		document.body.removeChild(aux);
  		//alert("Print screen disabled.");
	}

        document.addEventListener("keyup", function(event) {
		if(event.keyCode == 44){
			//console.log("came inside 44 keycode");
			copyToClipboard();
		}
	});
</script>
<style>
	@media print {
	  html, body {
	    display: none;  /* hide whole page */
	  }
	}
</style>
<?php } ?>
