<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.5.1
 * @date 05/07/22
 * @time 11:23 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
              <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
</ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='siemCredentials'?></span>
            <?php if(!empty($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'error'){ ?>
             <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php }elseif(!empty($_SESSION['storageResult']) && $_SESSION['storageResult'] == 'success'){ ?>
             <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php } ?>
            <?php $_SESSION['storageResult'] = ''; ?>
            <?php $_SESSION['storageMessage'] = ''; ?>
            <div class="row">
<?php //if(STORAGE_TYPE != "GOOGLE_DRIVE" && STORAGE_TYPE != "ONE_DRIVE"){ ?>
<!--                <div class="panel ccSPanel col-lg-12" style="display: none;">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">SIEM Credentials</h4>
                    </div>
                    <div class="panel-body">
                        <div ng-if="ccS.length > 0">                    
                            <div class="col-lg-4 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                                <div class="panel panel-default no-box-shadow widget-success">
                                    <div class="background">
                                        <i class="fa fa-language"></i>
                                    </div>
                                    <div class="panel-heading widget-header">                                       
                                        <span>
                                            <a>CloudName: </a><a class="pull-right">{{ ccS.cloudNameInCaps }}</a>
                                            <br/>
                                        </span>
                                        <span>
                                            <a>Identity: </a><a class="pull-right">{{ ccS.identity }}</a>
                                            <br/>
                                        </span>
                                    </div>
                                    <div class="panel-footer">
                                        <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeCloudCredentials($index)">Remove</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div ng-if="ccS.length <= 0">                   
                            <h2 align="center">There are no SIEM Credentials Saved</h2>
                        </div>
                    </div>
                    <div class="panel-footer">
                        <p class="help help-block">Note:- Only one SIEM Credential details can be added</p>
                    </div>
                </div>-->
                <div class="panel ccSPanel col-lg-12" style="display:none;">
<div class="panel-body">
                        <div>
                            <div class="col-lg-4 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                                <div class="panel panel-default no-box-shadow widget-success">
                                    <div class="background">
                                        <i class="fa fa-language"></i>
                                    </div>
                                    <div class="panel-heading widget-header" style="overflow:auto;">
                                        <span ng-if="cloudNameInCaps != ''">
                                            <a>CloudName: </a><a class="col-lg-6 pull-right" style="overflow-wrap: break-word;">{{ cloudNameInCaps }}</a>
                                        </span>
                                        <br/>
                                        <span ng-if="identity.length != ''">
                                            <a>Identity: </a><a class="col-lg-6 pull-right" style="overflow-wrap: break-word;">{{ identity }}</a>
                                        </span>
                                        <br/>
                                        <span ng-if="msAppName.length != ''">
                                            <a>App Name: </a><a class="col-lg-6 pull-right" style="overflow-wrap: break-word;">{{ msAppName }}</a>
                                        </span>
                                        <br/>
                                    </div>
                                    <div class="panel-footer">
                                        <a style="margin-top: 5px;" class="btn btn-danger btn-small removeSiemCredentialsBtn" ng-click="removeSiemCredentials()">Remove</a>
                                    </div>
                                </div>
                            </div>
                        </div>
<?php if($data['ccSList']->{"cloudNameInCaps"} && $data['ccSList']->{"cloudNameInCaps"} == 'OneDrive for Business'){ ?>
<div class="panel col-lg-12" style="border: 1px solid #fe6205;">
    <div class="panel-heading"><h4>For Admin Consent</h4></div>
    <div class="panel-body">
        <?php
            $tenentId = $data['ccSList']->{"msTenantId"};
            $clientId = $data['ccSList']->{"msClientId"};
            $user_principal = $data['ccSList']->{"odbLoginId"};
            if(useLocalPackage != true){
            $redirectURI = "https://api-app.parablu.com/adminConsentSiem.php";
            $appURL = "https://api-app.parablu.com/callConsentSiem.php";
            }else{
            $redirectURI = LOCAL_IP."/app/adminConsentSiem.php";
            $appURL = LOCAL_IP."/app/callConsentSiem.php";
            }
            $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
            $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
        ?>
        <p>
            <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
        </p>
    </div>
</div>
<?php } ?> 
<!--                        <div ng-if="ccS.length <= 0">
                            <h2 align="center">There are no Cloud Credentials Saved</h2>
                        </div>-->
                    </div>
</div>
                <div class="panel createCCSPanel col-lg-12">
                    <div class="panel-heading">
                        <h4>SIEM Credentials</h4>
                    </div>
                    <?= Form::open(array(
                        'ng-submit' => 'saveSiemCredentials(false)',
                        'class' => 'siemCredentials',
                        'id' => 'siemCredentials',
                        'csrf' => $data['csrf_token'],
                        'autocomplete' => 'off',
                        'data-parsley-validate' => true
                )); ?>
                        <div class="panel-body">
<div class="row">
                            <div class="form-group col-lg-12" id="cloudTypeDiv">
                              <label for="cloudType">Cloud Type</label>
                                <select class="form-control" name="cloudType" id="cloudType">
                                    <option value="azureBlob"><?=Language::show('azureBlob', 'settings')?></option>
                                    <option value="b2"><?=Language::show('backBlaze', 'settings')?></option>
                                    <option value="ibmCloud"><?=Language::show('ibmSwift', 'settings')?></option>
                                    <option value="s3"><?=Language::show('S3', 'settings')?></option>
                                    <option value="amazon"><?=Language::show('amazonS3', 'settings')?></option>
                                    <option value="localStorage"><?=Language::show('localStorage', 'settings')?></option>
                                    <option value="odb"><?=Language::show('microsoft', 'settings')?></option>
<!--                                <option value="google"><?=Language::show('Google Drive', 'settings')?></option>-->
                                </select>
                            </div>
                            <div class="form-group col-lg-6 siemId hide">
                                <label for="siemId">SIEM Id</label>
                                <input type="text" class="form-control" name="siemId" id="siemId" value="" placeholder="Enter SIEM Id" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 identity">
                                <label for="identity">Identity</label>
                                <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter cloud identity" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 accessKey">
                                <label for="accessKey">Access key</label>
                                <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter access key" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 epaUrl" style="display: none;">
                                <label for="epaUrl">End Point Url</label>
                                <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter End Point Agent URL" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 containerName" style="display: none;">
                                <label id="containerNameAzr" for="containerNameAzr">Amazon Container Name</label>
                                <label id="bucketName" for="bucketName">Container Name</label>
                                <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter Amazon Container Name" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 localStorage" style="display: none;">
                                <label for="localStorage">Local Storage Folder Name</label>
                                <input type="text" class="form-control" name="localStorage" id="localStorage" value="" placeholder="Enter folder Name" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 odbLoginId" style="display: none;">
                                <label for="localStorage">OneDrive for Business Target Id</label>
                                <input type="text" class="form-control" name="odbLoginId" id="odbLoginId" value="" placeholder="Enter OneDrive for Business target Id" autocomplete="off">
                            </div>
                            <!--odb start-->
                            <div class="form-group col-lg-6 clientId" style="display: none;">
                                <label for="clientId">Client ID</label>
                                <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter Client Id" autocomplete="off">
                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created an app.</span>
                            </div>
                            <div class="form-group col-lg-6 clientSecret" style="display: none;">
                                <label for="clientSecret">Client Secret</label>
                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="" placeholder="Enter Secret Key" autocomplete="off">
                                <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created an app.</span>
                            </div>
                            <div class="form-group col-lg-6 appName" style="display: none;">
                                <label for="appName">App Name</label>
                                <input type="text" class="form-control" name="appName" id="appName" value="" placeholder="Enter App Name" autocomplete="off">
                                <span class="help-line text-muted">Note:- App Name will be the name which was provided when you have created an app.</span>
                            </div>
                            <div class="form-group col-lg-6 tenantId" style="display: none;">
                                <label for="tenantId"><?=Language::show('Tenant ID', 'keywords')?></label>
                                <input type="text" class="form-control" name="tenantId" id="tenantId" value="" placeholder="Enter Tenant ID" autocomplete="off">
                                <span class="help-line text-muted">Note:- Tenant ID will be the key which was provided when you have created an app.</span>
                            </div>
                            <div class="form-group col-lg-6 clientRedirectURI hide">
                                <label for="clientRedirectURI">Client Redirect URL</label>
                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="" placeholder="Enter Client Redirect URL" autocomplete="off">
                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                            </div>
                            <div class="form-group col-lg-6 clientResourceURL" style="display: none;">
                                <label for="clientResourceURL">Client OneDrive for Business URL</label>
                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="" placeholder="Enter Client OneDrive for Business URL" autocomplete="off">
                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your SharePoint app URL)</span>
                            </div>
                            <div class="form-group col-lg-6 clientTokenURL" style="margin-bottom:40px;display:none;">
                                <label for="clientTokenURL">Client Token URL</label>
                                <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="" placeholder="Enter client token URL" autocomplete="off">
                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                            </div>
                            <div class="form-group col-lg-6 portalURL" style="display: none;">
                                <label for="portalURL">Portal URL</label>
                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="" placeholder="Enter Portal URL" autocomplete="off">
                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                <br/><br/>
                            </div>
<!--odb end-->
</div>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-success pull-right">Save</button>
                            <a class="btn btn-danger pull-right removeSiemCredentialsBtn" ng-click="removeSiemCredentials()" style="margin-right: 5px;">Remove</a>
                        </div>
                    <?= Form::close(); ?>
                </div>
                <?php //} ?>

            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
//    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.localStorage').hide();
            $('.odbLoginId').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('#containerNameAzr').show();
            $('#bucketName').hide();
            $('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }else if(type == 'ibmCloud'){
            $('.localStorage').hide();
            $('.odbLoginId').hide();
            $('.containerName').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }else if(type == 's3'){
            $('.localStorage').hide();
            $('.odbLoginId').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('#containerNameAzr').hide();
            $('#bucketName').show();
            $('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }else if(type == 'localStorage'){
            $('.localStorage').show();
            $('.odbLoginId').hide();
            $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }else if(type == 'b2'){
            $('.localStorage').hide();
            $('.odbLoginId').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.containerName').show();
            $('#containerNameAzr').hide();
            $('#bucketName').show();
            $('[name="containerName"').attr('placeholder', 'Enter your Bucket Name');
            $('[name="containerName"').attr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }else if(type == 'odb'){
            $('.localStorage').hide();
            $('.odbLoginId').show();
            $('[name="odbLoginId"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.clientId').show();      
            $('.clientSecret').show();
            $('.appName').show();
            $('.tenantId').show();
            //$('.clientRedirectURI').show();
            $('.clientResourceURL').show();
            $('.clientTokenURL').show();
            $('.portalURL').show();     
        }else{
            $('.localStorage').hide();
            $('.odbLoginId').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.clientId').hide();      
            $('.clientSecret').hide();
            $('.appName').hide();
            $('.tenantId').hide();
            $('.clientRedirectURI').hide();
            $('.clientResourceURL').hide();
            $('.clientTokenURL').hide();
            $('.portalURL').hide();     
        }
    });
</script>
