<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
</ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='ccS'?></span>
            <div class="row">
<?php if(STORAGE_TYPE != "GOOGLE_DRIVE" && STORAGE_TYPE != "ONE_DRIVE"){ ?>
                <div class="panel ccSPanel col-lg-12" style="display: none;">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Cloud Credentials</h4>
                    </div>
                    <div class="panel-body">
                        <!--<div ng-if="ccS.length > 0">-->
			<div ng-if="ccS[0].identity != null ">
                            <div ng-repeat="value in ccS track by $index" class="col-lg-4 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                                <div class="panel panel-default no-box-shadow widget-success">
                                    <div class="background">
                                        <i class="fa fa-language"></i>
                                    </div>
                                    <div class="panel-heading widget-header" style="overflow:auto;">
                                        <span ng-if="value.cloudNameInCaps.length > 0">
                                            <a>CloudName: </a><a class="col-lg-6 pull-right">{{ value.cloudNameInCaps }}</a>
                                            <br/>
                                        </span>
                                        <span ng-if="value.identity.length > 0">
                                            <a>Identity: </a><a class="col-lg-6 pull-right" style="overflow-wrap: break-word;">{{ value.identity }}</a>
                                            <br/>
                                        </span>
                                    </div>
                                    <div class="panel-footer">
                                        <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeCloudCredentials($index)">Remove</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--<div ng-if="ccS.length <= 0">-->
			<div ng-if="ccS[0].identity == null ">
                            <h2 align="center">There are no Cloud Credentials Saved</h2>
                        </div>
                    </div>
                    <div class="panel-footer">
                        <p class="help help-block">Note:- Only one Cloud Credential details can be added</p>
                    </div>
                </div>
                <div class="panel createCCSPanel col-lg-12" style="display: none;">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Add your Cloud Credentials</h4>
                    </div>
                    <?= Form::open(array(
                        'ng-submit' => 'saveCloudCredentials(false)',
                        'class' => 'cloudCredentials',
			'id' => 'cloudCredentials',
                        'csrf' => $data['csrf_token'],
                        'autocomplete' => 'off',
                        'data-parsley-validate' => true
		)); ?>
			<div class="panel-body">
<div class="row">
                            <div class="form-group col-lg-12">
                                <label for="cloudType">Cloud Type</label>
                                <select class="form-control" name="cloudType" id="cloudType">
                                    <option value="azureBlob"><?=Language::show('azureBlob', 'settings')?></option>
                                    <option value="b2"><?=Language::show('backBlaze', 'settings')?></option>
                                    <option value="ibmCloud"><?=Language::show('ibmSwift', 'settings')?></option>
                                    <option value="s3"><?=Language::show('S3', 'settings')?></option>
                                    <option value="amazon"><?=Language::show('amazonS3', 'settings')?></option>
                                    <option value="localStorage"><?=Language::show('localStorage', 'settings')?></option>
                                    <option value="odb"><?=Language::show('microsoft', 'settings')?></option>
                                </select>
			    </div>
			    <div class="form-group col-lg-6 blobTagName hide">
                                <label for="blobTagName">Blob Tag Name</label>
                                <input type="text" class="form-control" name="blobTagName" id="blobTagName" value="{{ccS[0].blobTagName}}" placeholder="Enter cloud blobTagName" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 identity">
                                <label for="identity">Identity</label>
                                <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter cloud identity" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 accessKey">
                                <label for="accessKey">Access key</label>
                                <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter access key" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 epaUrl" style="display: none;">
                                <label for="epaUrl">End Point Url</label>
                                <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter End Point Agent URL" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 containerName" style="display: none;">
                                <label id="containerNameAzr" for="containerNameAzr">Amazon Container Name</label>
                                <label id="bucketName" for="bucketName">Container Name</label>
                                <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter Amazon Container Name" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12 localStorage" style="display: none;">
                                <label for="localStorage">Local Storage Folder Name</label>
                                <input type="text" class="form-control" name="localStorage" id="localStorage" value="" placeholder="Enter folder Name" autocomplete="off">
			    </div>
</div>
                        </div>
                        <div class="panel-footer">
                            <button type="submit" class="btn btn-success">Save</button>
			</div>
                    <?= Form::close(); ?>
                </div>
                <?php } ?>
                <?php if(STORAGE_TYPE == "GOOGLE_DRIVE"){ ?>
                <div class="forGD col-lg-12">
                    <div class="panel">
                        <div class="panel-heading"><h4>Google Drive Connection Settings</h4></div>
                                    <div class="panel-body">
					<form class="googleConfiguration" id="googleConfiguration" ng-submit="saveGoogleConfiguration()" data-parsley-validate>
						<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
<div class="row">
                                            <input type="text" class="d-none" hidden value="<?=$data["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="clientId">Client ID</label>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter Client Id" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a google app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret">Client Secret</label>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter Client Secret Key" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a google app.</span>
					    </div>
<div class="col-lg-12">
<button type="submit" class="btn btn-success float-right">Save Settings</button>
</div>
                                            </div>
					</form>
</div>
                                    </div>
                                </div>
                </div>
                <?php } ?>
                
<?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                    <div class="forODB col-lg-12">
                        <div class="panel">
                            <div class="panel-heading"><h4>OneDrive For Business / SharePoint Connection Settings</h4></div>
                            <div class="panel-body">
				<form class="odbConfiguration" id="odbConfiguration" ng-submit="saveOdbConfiguration()" data-parsley-validate>
					<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
				<div class="row">
                                    <input type="text" class="d-none" hidden value="<?=$data["configId"]?>" name="configId" />
                                    <div class="form-group col-lg-6">
                                        <label for="clientId">Client ID</label>
                                        <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter Client Id" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientSecret">Client Secret</label>
                                        <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter Secret Key" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created an app.</span>
                                    </div>
				    <div class="form-group col-lg-6">
                                        <label for="appName">App Name</label>
                                        <input type="text" class="form-control" name="appName" id="appName" value="<?=$data["appName"]?>" placeholder="Enter App Name" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- App Name will be the name which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientRedirectURI">Client Redirect URL</label>
                                        <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter Client Redirect URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientResourceURL">Client OneDrive for Business URL</label>
                                        <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter Client OneDrive for Business URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientTokenURL">Client Token URL</label>
                                        <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="<?=$data["clientTokenURL"]?>" placeholder="Enter Client Token URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="portalURL">Portal URL</label>
                                        <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter Portal URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                        <br/><br/>
                                    </div>
				</div>
				<div class="row" style="display:flow-root;">
                                        <button type="submit" class="btn btn-success pull-right">Save Settings</button>
				</div>
                                </form>
                            </div>
                        </div>
                        <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                            <?php //if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                    <div class="panel">
                                        <div class="panel-heading"><h4>Select Storage Space</h4></div>
                                        <div class="panel-body">
                                            <div class="form-group col-lg-12">
                                                <div class="well well-lg">
                                                    <p class="d-none">
                                                        <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                        - Your cloud does not support this feature
                                                    </p>
                                                    <p class="d-none">
                                                        <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                        - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                    </p>
                                                    <?php
                                                    $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                    ?>
                                                    <p class="d-none">
                                                        <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                        - Google Drive Storage space
                                                    </p>
                                                    <?php
                                                    if(useLocalPackage != true){
                                                        $redirectUri = "https://api-app.parablu.com/";
                                                        $aadURL = 'https://api-app.parablu.com/call.php';
                                                    }else{
                                                        $redirectUri = LOCAL_IP."/app/index.php";
                                                        $aadURL = LOCAL_IP."/app/call.php";
                                                    }
                                                    $user_principal = $data['user_principal'];
                                                    //$params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                    $params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$redirectUri."&state=".$data['loggedInUser']['userName']."&user_principal=".$user_principal;
                                                    //$MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                    $MODBUrl = $aadURL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                    ?>
                                                    <p>
                                                        <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                        - Microsoft OneDrive for business Storage Space
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            <?php //} ?>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.localStorage').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('#containerNameAzr').show();
            $('#bucketName').hide();
            $('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.localStorage').hide();
            $('.containerName').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 's3'){
            $('.localStorage').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('#containerNameAzr').hide();
            $('#bucketName').show();
            $('[name="containerName"').attr('placeholder', 'Enter your Container Name');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'localStorage'){
            $('.localStorage').show();
            $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
        }else if(type == 'b2'){
            $('.localStorage').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.containerName').show();
            $('#containerNameAzr').hide();
            $('#bucketName').show();
            $('[name="containerName"').attr('placeholder', 'Enter your Bucket Name');
            $('[name="containerName"').attr('required', 'required');
        }else{
            $('.localStorage').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }
    });
</script>
