<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ServerController">
    <span class="hide currentPage"><?='serverJobs'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=$data['crumb1']?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <form class="form-inline" ng-submit="updateServerJobs(search.deviceName)" data-parsley-validate>
                                <div class="">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                                        </div>
                                        <div class="col-lg-3">
                                            <select class="jobStatus" id="jobStatus" data-parsley-trigger="change" required>
                                                <option value="running">Running</option>
                                                <option value="completed">Completed</option>
                                                <option value="failed">Failed</option>
                                                <option value="aborted">Aborted</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <button type="submit" class="btn btn-default">Generate Report</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <div class="h4 resultStatus text-center" style="display: none;"></div>
                        <table class="table table-bordered table-striped serverJobsTable" ng-if="serverJobs.length > 0">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('containerName', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('containerType', 'keywords')?></th>
<!--                                <th class="text-center">--><?//=Language::show('processId', 'keywords')?><!--</th>-->
                                <th class="text-center"><?=Language::show('startTime', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('endTime', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('backupJobType', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('deviceName', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('Steps', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('Size On Disk', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('Size On Cloud', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('actions', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in serverJobs track by $index">
                                <td ng-cloak>{{ value.containerName }}</td>
                                <td ng-cloak>{{ value.containerType }}</td>
<!--                                <td ng-cloak>{{ value.processId }}</td>-->
                                <td ng-cloak>{{ value.startTime | timeAgo:'medium' }}</td>
                                <td ng-cloak ng-if="value.endTime <= 0">-</td>
                                <td ng-cloak ng-if="value.endTime > 0">{{ value.endTime | timeAgo:'medium' }}</td>
                                <td ng-cloak>{{ value.backupJobType }}</td>
                                <td ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak><span class="label label-info">{{ value.currentStep }} of {{ value.totalSteps }}</span></td>
                                <td ng-cloak><span class="label label-success">{{ value.status }}</span></td>
                                <td ng-cloak>{{ value.backupSizeOnDiskInBytes | bytes }}</td>
                                <td ng-cloak>{{ value.backupSizeOnCloudInBytes | bytes }}</td>
                                <td ng-if="value.status != 'completed' && value.status != 'failed'">
                                    <a class="btn btn-primary btn-small" ng-click="terminateServerJob(value.containerName, value.deviceName)">Terminate</a>
                                </td>
                                <td ng-if="value.status.toLowerCase() == 'completed' || value.status.toLowerCase() == 'failed'">-</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMoreDevices(skipValue)">Load More ...</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade deviceDetails">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Device Details</h4>
                </div>
                <div class="modal-body">
                    <p><b>Created At</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.createdTimeStamp }}</span></p>
                    <p><b>Name</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.deviceName }}</span></p>
                    <p><b>Os Type</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.osType }}</span></p>
                    <p ng-if="selectedDevice.decoupled == 'true'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">Yes</span></p>
                    <p ng-if="selectedDevice.decoupled == 'false'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">No</span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ServerController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.jobStatus').selectpicker({});
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/getAllServers",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceUUID, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Server'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>