<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=Language::show('downloadAgent', 'keywords')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='downloads'?></span>
            <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                        <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                        <?php if(Auth::checkCloudPermission('backup') == true || Auth::checkCloudPermission('office365') == true){ ?>
                            <?php if($data['isAdmin'] == 'true'){ ?>
                                <li class="nav-item hide" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <?php if(Auth::checkCloudPermission('backup') == true || Auth::checkCloudPermission('office365') == true){ ?>
                            <?php if($data['isAdmin'] == 'true'){ ?>
                                <li class="nav-item hide" role="presentation"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                    <?php } ?>
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
            <?php if(ENABLE_EPA == true){ ?>
                <div class="row">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">For Desktops & Laptops</h4>
                        </div>
                        <div class="panel-body epas1" style="display:none;">
                            <h4 style="padding: 0px 0px 0px 15px;">No Agents available for download</h4>
                        </div>
                        <div class="panel-body epas">
                            <div class="row">
                                <?php if(WINDOWS_EPA == true){ ?>
                                    <div class="col-lg-4 epaWindows">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWSPC_APP == false){echo 'building';} ?>" <?php if(WINDOWSPC_APP == true){echo 'ng-click="download(\'EPAForWindows\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows</i><br>
                                                <a>End Point Agent for Windows</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(MAC_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip epaMac" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Mac Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(MAC_APP == false){echo 'building';} ?>" <?php if(MAC_APP == true){echo ' ng-click="download(\'EPAForMac\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For Mac</i><br>
                                                <a>End Point Agent for Mac</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(LINUX_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip epadebLinux" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Linux Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(LINUX_APP == false){echo 'building';} ?>" <?php if(LINUX_APP == true){echo ' ng-click="download(\'EPAForLinuxDeb\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-linux"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-linux"> End Point Agent </i><br>
                                                <a>Debian Package</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(LINUX_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip eparpmLinux" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Linux Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(LINUX_APP == false){echo 'building';} ?>" <?php if(LINUX_APP == true){echo ' ng-click="download(\'EPAForLinuxRpm\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-linux"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-linux"> End Point Agent </i><br>
                                                <a>RPM Package</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <?php if(ENABLE_MOBILE_APPS == true){ ?>
                <div class="row">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">For Tablets & Smart phones</h4>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <?php if(ENABLE_ANDROID_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(ANDROID_APP == false){echo 'building';} ?>" <?php if(ANDROID_APP == true){echo 'ng-click="download(\'AppForAndroid\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-android"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-android"> For Android</i><br>
                                                <a>App for Android</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_WINDOWS_PHONE_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWS_APP == false){echo 'building';} ?>" <?php if(WINDOWS_APP == true){echo 'ng-click="download(\'AppForWindows\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows Phone</i><br>
                                                <a>App for Windows Phone</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_IOS_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble  <?php if(IOS_APP == false){echo 'building';} ?>" <?php if(IOS_APP == true){echo 'ng-click="download(\'AppForMac\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For iOS</i><br>
                                                <a>App for iOS</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if($data['isAdmin'] == 'true'){ ?>
            <div role="tabpanel" class="tab-pane" id="advanced">
                <div class="row">
                    <div class="panel col-lg-12">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">Available packages</h4>
                        </div>
                        <div class="row">
                                <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluODBSecondaryAdminMappingApp')">
                                            <div class="background">
                                                <i class="fa fa-cloud"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-cloud"> OneDrive for Business Mapper</i><br>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that maps your end-users to the appropriate OneDrive for Business storage target their backups need to go to.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if($data['onedriveBackupEnabled'] == 'true'){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluO365MappingApp')">
                                            <div class="background">
                                                <i class="fa fa-share-alt"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-share-alt"> OneDrive for Business Backup Enabler</i><br>
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that enables the backup software with appropriate privileges to backup MS OneDrive from Business data from your MS Office 365 tenant.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if($data['exchangeBackupEnabled'] == 'true'){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="download('ParabluODBExchangeMappingApp')">
                                            <div class="background">
                                                <i class="fa fa-envelope"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-envelope"> MS Exchange Online Backup Enabler</i><br>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;margin:5px;">
                                            <p>
                                                Utility that enables the backup software with appropriate privileges to backup your MS Exchange mailbox data from your MS Office 365 tenant.
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
</div>
</div>
</div>
<?php } ?>
</div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.building').popover({
        trigger : 'click',
        placement : 'bottom',
        title : function(){
            var t = $(this).attr("id");
            return 'Client Download';
        },
        content : 'Product is not publicly available. If you need this, please contact your relationship manager.'
    });
</script>
<style>
.panel .background {
font-size: 75px !important;
}
.widget-click .widget-body i{
font-size: 16px !important;
}
</style>
