<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Form;
use Helpers\Url;
use Helpers\Session;
$session = new Session();
if(googleAuthenticator == true){
include_once('/var/www/portal/app/views/login/GoogleAuthenticator.php');
$ga = new GoogleAuthenticator();
$website = MFATITLE; //Your Website
$title = $data['userName'];
$secret = $data['secret'];
$qrCodeUrl = $ga->getQRCodeGoogleUrl($title, $secret,$website);
}
?>
<div class="container">
    <div class="row">
    </div>
    <br/>
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading" style="padding: 30px 30px 10px 30px;">
                    <a><b class="h3"><?=$data['title'];?></b> - <?=$data['passwordReset_message']?></a>
                </div>
                <div class="panel-body">
                    <div  id="status" style="display: none; margin-bottom: 10px;"></div>
                    <?=
                        Form::open(array(
                            'action' => Url::basePath('updatePassword'),
                            'method' => 'post',
                            'class' => 'restPassword',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
			?>
			<div class="form-group col-lg-6 hide">
                                <label for="googleSecretKey"><?=Language::show('googleSecretKey', 'keywords');?></label>
                                <input type="text" class="form-control" name="googleSecretKey" id="googleSecretKey" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('googleSecretKey', 'keywords');?>" value="<?=$data['secret']?>" autocomplete="off">
                            </div>
                        <div class="form-group">
                            <label for="password">Password</label>
			                <?php if(complexPassword == true) { ?>
                            <input type="password" class="form-control" name="password" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change" autocomplete="new-password">
				            <?php } else { ?>
                            <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="new-password" data-parsley-required>
                            <?php } ?>
                        </div>
                        <div class="form-group">
                            <label for="rePassword">Re Type Password</label>
                            <input type="password" class="form-control" id="rePassword" placeholder="Re-Type the password" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
			</div>
			<?php if(multifactorAuthWithAccessCode == true){ ?>
                        <div class="form-group">
                            <label for="accessKey">Enter One Time Access Code sent to the registered Email address - <a  id="generateOtpLink" style="cursor:pointer;">Resend One Time Access Code</a></label>
                            <input type="text" class="form-control" name="accessKey" id="accessKey" placeholder="<?=Language::show('Enter', 'keywords');?> <?=Language::show('One Time Access Code', 'keywords');?>" required autocomplete="off">
                        </div>
                        <?php } ?>
			<?php if(enableRecaptcha == true){ ?>
			<div id="captchaDiv">
                        <?php
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                                imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $session->get('captcha-value');
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
                            imagepng($image, "image" . $session->get('countt') . ".png");
                        ?>
                        </div>			
                        <div class="from-group">
                            <label>Enter captcha shown below </label>
                            <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
                            <span id="captchaSpan">
                                <img id="captchaImage" src="image<?=$session->get('countt')?>.png">
                            </span>
                            <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
                        </div>
                        <?php } else { ?>
				<input class="form-control d-none hide" type="text" id="code" name="code" value="<?=$session->get('captcha-value')?>" autocomplete="off"/>
			<?php } ?>
			<?php if(googleAuthenticator == true && multifactorAuthWithAccessCode == false){ ?>
				<center><div id="img">
                                	<img src='<?php echo $qrCodeUrl; ?>' />
					</div>
				</center>
          			<p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan this QR code and generate a one-time key.</p>
			<?php } ?>
                        <div class="row">
                            <div class="col-lg-12">
                                <?=URL::link('login', Language::show('go_backup', 'keywords'))?>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary pull-right submit"><?=Language::show('submit', 'keywords');?></button>
                    <?=
                        Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
