<?php
use \Core\View;
use Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 16/11/22
* @time 15:58 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
		<li><h3><?=$data['title']?></h3></li>
		<li><a href="<?=Url::basePath('unusualActivityHistoryForAll')?>"><?=$data['crumb1']?></a></li>
                <li><a href="" ><?=$data['crumb2']?></a></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="HistoryController">
    <span class="hide currentPage"><?='quarantineList'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><span class="pull-right"><a class="btn btn-success btn-small" ng-click=uploadSampleModal()><?=Language::show('Upload Infected Samples', 'keywords');?></a></span></h4>
                </div>
                <div class="row records">
                    <div class="col-lg-6" block-ui="myBlockUI">
                        <div class="panel panel-default no-box-shadow widget-primary" style="border-radius:10px;">
                            <div class="background">
                                <!--<i class="fa fa-users"></i>-->
                            </div>
                            <div class="panel-heading widget-header" style="border-radius:10px;">
				<a>Uploaded Infected Files</a>
				<!--<a href="" class="pull-right" style="font-size: 18px;"><span class="ng-binding">13</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>-->
				<a href="" class="pull-right" style="font-size: 18px;"><span ng-cloak>{{ uploadedInfFilesCount }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>
                            </div>
                            <!--<div class="panel-body widget widget-body">                                
                                <a href="" class="pull-right" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ uploadedInfFilesCount }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;"> 50 </span></a>
                            </div>-->
                        </div>
                    </div>
                </div>
                <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                    <div class="row">
                        <div class="col-lg-12">
                            <h4><?=Language::show('Quarantine Files List', 'keywords')?></h4>
                        </div>
                    </div>
                </div>
                <div class="panel-body noRecords" style="padding: 0px 10px 10px 10px;">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center">No records found!</h2>
                        </div>
                    </div>
		</div>
                <div class="panel-body records" style="padding: 0px 10px 10px 10px;">
		    <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>Files specified below are considered malicious and will be prevented from being downloaded or restored.</p>
                                </div>
                            </div>
		    </div>
                    <div class="row">
                        <div class="col-lg-12">
                           <div class="table-responsive col-lg-12 quarantineListDiv" style="border: 1px solid #f27331;border-radius: 10px;overflow:scroll;height:500px;">
                            </hr>
                            <table id="quarantineList" class="table table-bordered quarantineList">
                                <thead>
                                <tr>                                
                                <th class="text-center clickAble" ng-click="sortTypeQL = 'fileName'; sortReverseQL = !sortReverseQL">
                                        <?=Language::show('File Name', 'keywords')?>
                                        <span ng-show="sortTypeQL == 'fileName' && !sortReverseQL" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeQL == 'fileName' && sortReverseQL" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortTypeQL = 'timestampInMillis'; sortReverseQL = !sortReverseQL">
                                        <?=Language::show('File Added On', 'keywords')?>
                                        <span ng-show="sortTypeQL == 'timestampInMillis' && !sortReverseQL" class="fa fa-caret-up"></span>
                                        <span ng-show="sortTypeQL == 'timestampInMillis' && sortReverseQL" class="fa fa-caret-down"></span>
                                </th> 				                                                                    
                                <th class="text-center clickAble"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="text-center" ng-repeat="value in quarantineList | orderBy:sortTypeQL:sortReverseQL">
					<td title="{{ value.fileName }}" ng-cloak>{{value.fileName}}</td>
				    	<td ng-cloak>{{value.timestamp}}</td>				    	
				    	<td ng-cloak>
				    		<a class="btn btn-danger btn-small" ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to delete the selected file?', 'keywords')?></h4>" ng-bootbox-confirm-action="deleteRwFile(value.id)" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius: 20px;">Delete</a>
				    	</td>
                                </tr>
                                </tbody>
                            </table>
			    </div> 
                        </div>
                    </div>
                </div>
                <!--modal starts-->
                <div class="modal fade uploadSampleModal" id="uploadSampleModal" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg" style="width:800px !important;">
                    <div class="modal-content">
                        <div class="modal-header">
			                <h4 class="modal-title">Upload File</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
			<div class="modal-body">
			    <div class="panel-body">
	    			<div class="row">
	    			    <div class="col-lg-12">
	    			        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
	    			        	<p>Uploaded files are only processed to create a hash – and are not stored on Parablu’s servers.</p>
	    			        </div>
	    			    </div>
	    			</div>
				<form class="infForm" data-parsley-validate enctype="multipart/form-data" style="border: 1px solid #f27331;border-radius: 10px;">
				    <div class="row" style="margin-left:5px;">					
				        <div class="col-lg-12" style="margin-top:10px;">
				            <span><b>Upload sample files :</b></span>
				        </div>
					<div class="col-lg-12" style="margin-top:10px;">
                                       	Choose File : <input type="file" name="infFileName" id="infFileName">
                                              <?php if(isMobile()){ ?>
                                              	<span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                              <?php } ?>
                                       </div>
                                       <div class="col-lg-12">
                                       		<span id="InfFileUploadingProgress"></span>
                                       </div>
                                       <div class="col-lg-8">
                                       	<div id="progress-div-inf" style="margin-left:10px;display:none;">
                                       	       <div id="progress-bar-inf"></div>
                                              </div>
                                              <div id="targetLayerInf"></div>
				       </div>
                                       <div class="col-lg-12">
                                                    <button type="submit" class="submit btn btn-primary pull-right infFileSave" style="margin-right: 10px;margin-bottom:10px;"><?=Language::show('Upload', 'keywords');?></button>
                                       </div>
				    </div>
				</form>
	    			</div>                        
			</div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
                </div>
                <!--modal ends-->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    /*endpoint backup start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item:checked:checked").length > 1){
		$('.downloadLogs').show();
		$('.quarantineDevice').show();
		$('.ignore').show();
                /*$('#bulkstopbackup').removeClass('disabled');
		$('#bulkpausebackup').removeClass('disabled');*/
            }else{
                $('.downloadLogs').hide();
		$('.quarantineDevice').hide();
		$('.ignore').hide();
                /*$('#bulkstopbackup').addClass('disabled');
		$('#bulkpausebackup').addClass('disabled');*/
	    }
	    var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
           }).get();
        });
        //check selected items
	$("input.select-item").click(function () {
            var checked = this.checked;
	    checkSelected();
	    if($("input.select-item:checked:checked").length > 1){
                $('.downloadLogs').show();
                $('.quarantineDevice').show();
                /*$('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');*/
	    }else{
                $('.downloadLogs').hide();
                $('.quarantineDevice').hide();
                /*$('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');*/
            }
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            all.checked = len===total;
        }
    });
/**endpoint backup end**/
</script>
<style>
#progress-bar-inf {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}
#progress-div-inf {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}
#targetLayerInf{width:100%;text-align:center;}
</style>
