<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Settings extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Settings Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveEncryption($headers,$data){
        $url = $this->api->getVersionUrl('saveEncryption');	
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getEncryption($headers){
        $url = $this->api->getVersionUrl('getEncryption');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveLocalStorageDetails($headers, $data){
        $url = $this->api->getUrl('saveLocalStorageDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveCloudCredentials($headers, $data){
        $url = $this->api->getUrl('saveCloudCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeCloudCredentials($headers){
        $url = $this->api->getUrl('removeCloudCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveAdCredentials($headers, $data){
        $url = $this->api->getUrl('saveAdCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function editAdCredentials($headers, $data){
        $url = $this->api->getUrl('editAdCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeAdCredentials($headers){
        $url = $this->api->getUrl('removeAdCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveSmtp($headers, $smtpDetails){
        $url = $this->api->getUrl('saveSmtp');
        Model::req($url,$headers,$smtpDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $smtpDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSmtp($headers){
        $url = $this->api->getUrl('getSmtp');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $cloudDetails
     * @return array
     */
    public function saveCloudProperties($headers, $cloudDetails){
        $url = $this->api->getVersionUrl('saveCloudProperties');
        Model::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $cloudDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredentials($headers){
        $url = $this->api->getUrl('getAdCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredential($headers){
        $url = $this->api->getUrl('getAdCredential');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getLocalStorageDetails($headers){
        $url = $this->api->getUrl('getLocalStorageDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getProxyDetails($headers){
        $url = $this->api->getVersionUrl('proxy');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function removeProxyDetails($headers){
        $url = $this->api->getVersionUrl('proxy');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveProxyDetails($headers,$data){
        $url = $this->api->getVersionUrl('proxy');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function editProxyDetails($headers,$data){
        $url = $this->api->getVersionUrl('proxy');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $odbDetails
     * @return array
     */
    public function saveOdbDetails($headers, $odbDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        Model::req($url,$headers,$odbDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $odbDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $googleDetails
     * @return array
     */
    public function saveGoogleDetails($headers, $googleDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        Model::req($url,$headers,$googleDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $googleDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */


    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    /**
      * Below Method gets all backup policies
      *
      * token should be sent in header
      * @param $headers
      * @return array
      */
    
    public function getAllPolicies($headers){
         $url = $this->api->getUrl('getAllPolices');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
 
     /**
      * Below Method gets all sync policies
      *
      * token should be sent in header
      * @param $headers
      * @return array
      */
    public function getAllSyncPolicies($headers){
         $url = $this->api->getUrl('getAllSyncPolices');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
     
    public function getAadDetails($headers){
        $url = $this->api->getParacloudUrl('getAadDetails');
        $this->log("URL : ".$url,"info");
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAadDetailsById($headers){
        $url = $this->api->getParacloudUrl('getAadDetailsById');
        $this->log("URL : ".$url,"info");
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveAadDetails($headers,$data){
        $url = $this->api->getParacloudUrl('saveAadDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function removeAadCredentials($headers){
        $url = $this->api->getParacloudUrl('removeAadCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveDetails($headers){
        $url = $this->api->getUrl('getOneDriveDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveOneDriveDetails($headers, $odbDetails){
        $url = $this->api->getUrl('saveOneDriveDetails');
        Model::req($url,$headers,$odbDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $odbDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getBlukryptSettings($headers){
        $url = $this->api->getUrl('getBlukryptSettings');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveBlukryptSettings($headers,$data){
        $url = $this->api->getUrl('saveBlukryptSettings');
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveEPAWindows($headers){
        $url = $this->api->getUrl('updateAgent');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result:::::::::: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }


    public function getEPAWindows($headers){
        $url = $this->api->getUrl('getAgentDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result:::::::::: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllBackupPolicyName($headers){
        $url = $this->api->getUrl('newBackup');
	$data = [];
	Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getAllSyncPolicyName($headers){
            $url = $this->api->getUrl('newSync');
	    $data = [];
	    Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getAllOneDrivePolicies($headers){
        $url = $this->api->getUrl('getAllOneDrivePolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function testMail($headers,$data){
        $url = "https:".DS.DS.PARACLOUD_IP."/paramail/send/customMail/";
        //Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        //Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getMongoProperties($headers){
        $url = $this->api->getUrl('getMongoProperties');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveMongoProperties($headers,$data){
        $url = $this->api->getUrl('saveMongoProperties');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getPortalProperties($headers){
        $url = $this->api->getParacloudUrl('getPortalProperties');
        $data = '';
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function savePortalProperties($headers,$data){
        $url = $this->api->getParacloudUrl('savePortalProperties');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function usersDataMigration($headers){
        $url = $this->api->getUrl('usersDataMigration');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function startDataMigration($headers){
        $url = $this->api->getUrl('startDataMigration');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function browse($headers, $deviceUUID){
        $url = $this->api->getBlukryptUrl('browse', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function browseOnedrive($headers, $deviceUUID){
        $url = $this->api->getBlukryptUrl('browseOnedrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveBranding($headers, $data){
        $url = $this->api->getParacloudUrl('saveBranding');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getLicenseKeyList($headers){
        $url = $this->api->getUrl('getLicenseKeyList');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function applyLicenseKey($headers){
        $url = $this->api->getUrl('viewLicenseKey');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function viewLicenseKey($headers){
        $url = $this->api->getUrl('viewLicenseKey');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveLicenseKey($headers){
        $url = $this->api->getUrl('saveLicenseKey');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function browseEndPointOnedrive($headers){
        $url = $this->api->getBlukryptUrl('browseEndPointOnedrive');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function sitesDiscovery($headers){
        $url = $this->api->getUrl('sitesDiscovery');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function browseSharepoint($headers, $deviceUUID){
        $url = $this->api->getBlukryptUrl('browseSharepoint', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getExchangeDetails($headers){
        $url = $this->api->getUrl('getExchangeDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveExchangeDetails($headers, $odbDetails){
        $url = $this->api->getUrl('saveExchangeDetails');
        Model::req($url,$headers,$odbDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $odbDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getSiemCredentials($headers){
        $url = $this->api->getVersionUrl('getSiemCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveSiemCredentials($headers, $data){
        $url = $this->api->getVersionUrl('saveSiemCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function removeSiemCredentials($headers, $id){
        $url = $this->api->getVersionUrl('removeSiemCredentials', array('id' => $id));
        Model::req($url,$headers,$id);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getSitesDiscovery($headers){
        $url = $this->api->getUrl('getSitesDiscovery');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllOfficePolicies($headers){
        $url = $this->api->getUrl('getAllOneDrivePolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
