<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Migration extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Migration Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getMigrationDetails($headers){
        $url = $this->api->getUrl('migrationDetails');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllPolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all sync polices
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllSyncPolicies($headers){
        $url = $this->api->getUrl('getAllSyncPolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets users to
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function getUsersForMigration($headers, $data){
        $url = $this->api->getUrl('usersForMigration');	
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUsersForMigrationAAD($headers, $data){
        $url = $this->api->getParacloudUrl('usersForMigrationAAD');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets users to
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function migrateUsers($headers, $data){
        $url = $this->api->getUrl('migrateUsers');
        Model::req($url,$headers,$data);
        $this->log('MigrateUsers: '. $data, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function migrateUsersAAD($headers, $data){
        $url = $this->api->getParacloudUrl('migrateUsersAAD');
        Model::req($url,$headers,$data);
        $this->log('MigrateUsers: '. $data, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllBackupPolicyName($headers){
        $url = $this->api->getUrl('newBackup');
	$data = [];
	Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getAllSyncPolicyName($headers){
            $url = $this->api->getUrl('newSync');
	    $data = [];
	    Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getAllOneDrivePolicies($headers){
         $url = $this->api->getUrl('getAllOneDrivePolices');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
    
    public function getAllOfficePolicies($headers){
        $url = $this->api->getUrl('getAllOneDrivePolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function syncNow($headers){
        $url = $this->api->getParacloudUrl('syncNow');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
