<?php
namespace Models;

use Core\Model;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Amazon extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Amazon Model was called', 'info');
    }

    public function isFirstCustomer(){
        $this->curl->get(PARA_URL.'api/check/firstlogin');
        if($this->curl->response_headers->container['first-login'] == 'true'){
            return 'true';
        }else{
            return $this->curl->response_headers->container['cloud-name'];
        }
    }

    public function checkCloud($cloudName){
        $this->curl->get(PARACLOUD_DNS_URL.'api/cloud/ip/v2/'.$cloudName);
        $this->log('Response'. json_encode($this->curl->response_headers), 'info');
        return $this->curl->http_status_code != 200;
    }

    public function registerCloudName($data, $cloudName){
        $this->curl->post(CLOUD_CREATE_URL.'api/amazonregister/cloud/'.$cloudName, $data);
        return $this->curl->http_status_code != 200;
    }

    public function updateDNS($cloudName, $deviceID){
        $this->curl->setHeader('Content-Type', 'application/json');
        $this->curl->setHeader('device-id', $deviceID);
        $this->curl->post(PARACLOUD_DNS_URL.'api/cloud/amazon/mapip/'.$cloudName);
        return $this->curl->http_status_code != 200;
    }

    public function registerUsername($data, $cloudName, $username){
        $this->curl->setHeader('Content-Type', 'application/json');
        $this->curl->post(PARA_URL.'cloud/'.$cloudName.'/create/amazonuser/'.$username."/", $data);
        return $this->curl->http_status_code;
    }

}
