<?php
namespace Helpers\Paraview;
/**
 * Created by PhpStorm.
 * User: parablu-dev
 * Developer: Prashanth Kumar B
 * Date: 3/2/15
 * Time: 10:34 AM
 */

class OdtReader {

    /**
     * @var String This is the path to the file that should be read
     * @since 1.0
     */
    var $odtPath = "";
    /**
     * @var String This is where the zipped contents will be extracted to to process
     * @since 1.0
     */
    var $tempDir = "";
    /**
     *
     * @var String This is the html data that is returned from this class
     * @since 1.0
     */
    var $output = array();
    /**
     *
     * @var String This is where the color of the body is saved
     * @since 1.0
     */
    var $bodyColor = "";
    /**
     * @var Int This is the maximum width of an image after the process
     * @since 1.0
     */
    var $image_max_width = 0;
    /**
     * @var String The path to where the content is extracted
     * @since 1.0
     */
    var $content_folder = "";
    /**
     * @var String The current Status of the class
     * @since 1.0
     */
    var $status = "";
    /**
     * @var String The path to where the media files of the document should be extracted
     * @since 1.0
     */
    var $mediaDir = "";
    /**
     * @var String The value of this variable will be prefixed to the path of the image. This class will create a folder 2 levels up, inside an 'upload' folder and this value should go to there.
     * @since 1.0
     */
    var $imagePathPrefix = "";
    /**
     * @var Float The time the scipt took to complete the file parsing
     * @since 1.0
     */
    var $time = 0;
    /**
     * @var Array This contains the relationships of different elements inside the word document and is used to link to the correct image.
     * @since 1.0
     */
    var $images = array();
    /**
     * @val Array All the fonts will be saved here
     * @since 1.0
     */
    var $fonts = array();
    /**
     * @val Array All the styles will be saved here
     * @since 1.0
     */
    var $styles = array();
    /**
     * @val String The error number generated and the meaning of the error
     * @since 1.0
     */
    var $error = NULL;
    /**
     * @val String This will contain the closing tag of a paragraph level opened tag that can't be specified explicitly
     * @since 1.0
     */
    var $tagclosep = "";
    /**
     * @val String This will contain the closing tag of a text opened tag that can't be specified explicitly
     * @since 1.0
     */
    var $tagcloset = "";

    /**
     * @var String The First path of the tag currently working on
     * @since 1.0
     */
    var $openedTag = "";

    /**
     * @var String The last path of the tag currently working on
     * @since 1.0
     */
    var $closedTag = "";

    /**
     * @var String This element contains the style of the page
     * @since 1.0
     */
    var $pageStyle = "";

    /**
     * @var String This element holds the default style of the document
     * @since 1.0
     */
    var $defaultStyle = array('font-size' => '10pt');

    /**
     * @val Bool would a thumbnail be created as well as to keep the original image in the folder
     * @since 1.0
     */
    var $keepOriginalImage = false;

    /**
     * @val Bool The Entire Data that has been extracted stored in an array
     * @since 1.0
     */
    var $contentsInArray = array('');


    /**
     * This function start the timer of this script
     *
     * @global Float $timeStart The time the function started, used to calculate script proccessing time
     * @return Bool True when the timer have started
     * @since 1.0
     */
    function timer_start() {
        global $timestart;
        $mtime = explode(' ', microtime() );
        $mtime = $mtime[1] + $mtime[0];
        $timestart = $mtime;
        return true;
    }
    /**
     * This function calculates the difference between when the timer_start was called and the current time
     *
     * @global Float $timestart The time the timer have started
     * @global Float $timeend The time the timer is stopped
     * @param Int $display Should the result be displayed or returned
     * @param Int $precision The amount of decimals to return (after the comma)
     * @return Float Containing the Time since the timer start was called
     * @since 1.0
     */
    function timer_stop($display = 0, $precision = 3) { //if called like timer_stop(1), will echo $timetotal
        global $timestart, $timeend;
        $mtime = microtime();
        $mtime = explode(' ',$mtime);
        $mtime = $mtime[1] + $mtime[0];
        $timeend = $mtime;
        $timetotal = $timeend-$timestart;
        $r = number_format($timetotal, $precision);
        if ( $display )
            echo $r;
        return $r;
    }
    /**
     * This function will set the status to Ready when the class is called. The Constructor Method.
     * @since 1.0
     */
    function __construct(){
        $this->timer_start();
        $this->status = "Ready";
        return true;
    }
    /**
     * This function call the Constructor Method
     * @return Bool True when ready
     * @since 1.0
     */
    function OdtReader(){
        return __construct();
    }
    /**
     * This function will initialize the process as well as handle the process automatically.
     * This requires that the vars be set to start
     * @return Bool True when successfully completed
     * @since 1.0
     * @modified 1.2.3
     */
    function Init(){
        if($this->testInput()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "11. Not enough information provided to parse the file.";
            return false;
        }
        if($this->UnZipodt()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "12. The file's contents could not be extracted to use.";
            return false;
        }
        if($this->extractPageStyles()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "13. Could not extract the styles and Fonts";
            return false;
        }
        if($this->extractStylesAndFonts()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "13. Could not extract the styles and Fonts";
            return false;
        }
        if($this->extractImages()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "13. The file data could not be found or read.";
            return false;
        }
        if($this->extractMedia()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "14. The Media could not be found.";
            return false;
        }
        if($this->extractXML()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "15. The file data could not be found or read.";
            return false;
        }
        if($this->DeleteTemps()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "16. The temporary files created during the process could not be deleted.
                The contents, however, might still have been extracted.";
            return false;
        }
        $this->time = $this->timer_stop(0);
        return true;
    }
    /**
     * This function make sure that the script have everything it needs to continue
     * @return Bool True if everything is ready for script execution
     * @since 1.0
     */
    function testInput(){
        if(!empty($this->odtPath) && $this->status == "Ready" ){
            $this->status = "Starting...";
            return true;
        } else {
            return false;
        }
    }
    /**
     * This function handles the extracting of the zipped contents to the temp folder
     * @return Bool True on success
     * @since 1.0
     * @modified 1.2.3
     */
    function UnZipodt(){
        require("zipper.php");
        $targetDir = $this->getUniqueDir();
        $this->tempDir = $targetDir;
        $baseDir = "";
        $maintainStructure = true;
        $unzip = new Zipper();
        $unzip->fileName = $this->odtPath;
        $unzip->unzipAll($targetDir, $baseDir, $maintainStructure);
        unset($unzip);
        if(is_dir($this->tempDir)){
            return true;
        }
        return false;
    }
    /**
     * This function will get a unique directory for the temporary files
     * @return string The first unique directory the function have found
     * @since 1.0
     */
    function getUniqueDir(){
        $targetDir = $this->content_folder."/docTempFolder";
        if(!is_dir($targetDir)){
            return $targetDir;
        }
        $i = 1;
        while(is_dir($targetDir.$i)){
            $i++;
        }
        $i-1;
        return $targetDir.$i;
    }

    function extractPageStyles(){
        $xmlFile = $this->tempDir."/styles.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        $this->pageStyle = [];
        $this->defaultStyle = [];
        foreach($data as $row){
            if($row['tag'] == 'STYLE:PAGE-LAYOUT-PROPERTIES'){
                if($row['type'] == 'open'){
                    $this->pageStyle['width'] = str_replace('cm', '', $row['attributes']['FO:PAGE-WIDTH'])*37.79 . 'px';
                    $this->pageStyle['height'] = str_replace('cm', '', $row['attributes']['FO:PAGE-HEIGHT'])*37.79 . 'px';
                    $this->pageStyle['top'] = str_replace('cm', '', $row['attributes']['FO:MARGIN-TOP'])*37.79 . 'px';
                    $this->pageStyle['bottom'] = str_replace('cm', '', $row['attributes']['FO:MARGIN-BOTTOM'])*37.79 . 'px';
                    $this->pageStyle['left'] = str_replace('cm', '', $row['attributes']['FO:MARGIN-LEFT'])*37.79 . 'px';
                    $this->pageStyle['right'] = str_replace('cm', '', $row['attributes']['FO:MARGIN-RIGHT'])*37.79 . 'px';
                }
                if($row['tag'] == "STYLE:TEXT-PROPERTIES"){
                    if($row['type'] == 'complete'){
                        $this->defaultStyle['font'] = $row['attributes']['STYLE:FONT-NAME'];
                        $this->defaultStyle['font-size'] = $row['attributes']['FO:FONT-SIZE'];
                    }
                }
            }
        }
        return true;
    }

    function extractStylesAndFonts(){
        $xmlFile = $this->tempDir."/content.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        // echo '<pre>';
        // print_r($data);
        foreach($data as $key => $value){
            if($value['tag'] == "STYLE:FONT-FACE"){
                if($value['type'] == "complete"){

                    $font = array(
                            'font' =>  $value["attributes"]["STYLE:NAME"],
                            'font-family' => $value['attributes']['SVG:FONT-FAMILY']
                        );
                    $this->fonts = array_merge(array($font), $this->fonts);
                }
            }
            if($value['tag'] == 'STYLE:STYLE'){
                if($value['type'] == 'open'){
                    $this->openedTag = $key;
                }
                if($value['type'] == 'close'){
                    $this->closedTag = $key;
                }
                $this->styles = array_merge(array($this->getAllStyles()), $this->styles);
            }
        }
        $this->styles = array_reverse($this->styles);
        $this->fonts = array_reverse($this->fonts);
        return true;
    }

    function getAllStyles(){
        $local = $this->contentsInArray;
        $firstTag = (!empty($this->openedTag)) ? $this->openedTag : 0;
        $lastTag = (!empty($this->closedTag)) ? $this->closedTag : 0;
        $sameLevelArray = array();
        $returnStyle = array();
        foreach($local as $key => $row){
            if($key >= $firstTag && $key <= $lastTag){
                array_push($sameLevelArray, $row);
            }
        }
        foreach($sameLevelArray as $key => $row) {
            if(!empty($row['attributes']['STYLE:NAME'])){
                $returnStyle['class'] = $row['attributes']['STYLE:NAME'];
            }
            if(!empty($row['attributes']['STYLE:FAMILY'])){
                $returnStyle['for'] = $row['attributes']['STYLE:FAMILY'];
            }
            if(!empty($row['attributes']['STYLE:FONT-NAME'])){
                $returnStyle['font'] = $row['attributes']['STYLE:FONT-NAME'];
            }
            if(!empty($row['attributes']['FO:FONT-SIZE'])){
                $returnStyle['fontSize'] = $row['attributes']['FO:FONT-SIZE'];
            }
            if(!empty($row['attributes']['FO:FONT-WEIGHT'])){
                $returnStyle['fontWeight'] = $row['attributes']['FO:FONT-WEIGHT'];
            }
            if(!empty($row['attributes']['FO:TEXT-ALIGN'])){
                $returnStyle['textAlign'] = $row['attributes']['FO:TEXT-ALIGN'];
            }     
        }
        return $returnStyle;
    }
    /**
     * This function handles the extraction of the XML building the Rels array
     * @return Bool True on success
     * @since 1.1
     * @modified 1.2.3
     */
    function extractImages(){
        $xmlFile = $this->tempDir."/content.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        $this->output['html'] = array();
        foreach($data as $value){
            if($value['tag']=="DRAW:IMAGE"){
                $image = str_replace('Pictures/', "", $value['attributes']['XLINK:HREF']);
                $this->images = array_merge(array($image), $this->images);
            }
        }
        return true;
    }
    /**
     * This function handles the extraction of the Media
     * @return Bool True on success
     * @since 1.1
     * @modified 1.2.3
     */
    function extractMedia(){
        $wordFolder = $this->tempDir."/Pictures/";
        if(!is_dir($wordFolder)){
            return true;
            //there are no images to extract
        }
        $this->getMediaFolder();
        $i = false;
        foreach($this->images as $key => $value){
            if(strtolower(pathinfo($value,PATHINFO_EXTENSION)) == "png" || strtolower(pathinfo($value,PATHINFO_EXTENSION))=="gif" || strtolower(pathinfo($value,PATHINFO_EXTENSION)) == "jpg"
                || strtolower(pathinfo($value,PATHINFO_EXTENSION)) == "jpeg"){
                $fileType = strtolower(pathinfo($value,PATHINFO_EXTENSION));
                if(is_file($wordFolder.$value)){
                    if($this->keepOriginalImage == true){
                        $image = $this->processImage($wordFolder.$value, $this->image_max_width);
                        $imageorr = $this->processImage($wordFolder.$value);
                    } else {
                        $image = $this->processImage($wordFolder.$value, $this->image_max_width);
                        $imageorr = false;
                    }
                    if($image){
                        $i = true;//this have been resourceful, do not return false
                        //the image was successfully created, now write to file
                        $filename = pathinfo($value,PATHINFO_BASENAME);
                        if($fileType=="png"){
                            if(imagePng($image,$this->mediaDir."/".$filename,0,PNG_NO_FILTER)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        } elseif($fileType=="gif"){
                            if(imageGif($image,$this->mediaDir."/".$filename,0)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        } else {
                            if(imageJpeg($image,$this->mediaDir."/".$filename,100)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        }
                    }
                    if($imageorr){
                        $i = true;//this have been resourceful, do not return false
                        //the image was successfully created, now write to file
                        $pathinfo = pathinfo($value);
                        $filename = $pathinfo['filename']."_big.".$pathinfo['extension'];
                        if($fileType=="png"){
                            if(imagePng($imageorr,$this->mediaDir."/".$filename,0,PNG_NO_FILTER)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        } elseif($fileType=="gif"){
                            if(imageGif($imageorr,$this->mediaDir."/".$filename,0)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        } else {
                            if(imageJpeg($imageorr,$this->mediaDir."/".$filename,100)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        }
                    }
                }
            }
        }
        return $i;
    }
    /**
     * This function creates the folder that will contain the media after the move
     * @return Bool True on success
     * @since 1.0
     */
    function getMediaFolder(){
        if(empty($this->content_folder)){
            $mediaFolder = pathinfo($this->odtPath,PATHINFO_BASENAME);
            $ext = pathinfo($this->odtPath,PATHINFO_EXTENSION);
            $MediaFolder = strtolower(str_replace(".".$ext,"",str_replace(" ","-",$mediaFolder)));
            $this->mediaDir = $MediaFolder;
        } else {
            $this->mediaDir = $this->content_folder;
        }
        if($this->mkdir_p($this->mediaDir)){
            return true;
        } else {
            return false;
        }
    }
    /**
     * This function handles the image proccessing
     * @param String $url Path to the file to proccess
     * @param Int $thumb The maximum width of an proccessed image
     * @return String The binary of the image that was created
     * @since 1.0
     */
    function processImage($url, $thumb=0) {
        $tmp0 = imageCreateFromString(fread(fopen($url, "rb"), filesize( $url )));
        if ($tmp0) {
            if($thumb == 0) {
                $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
            } else {
                if(imagesx($tmp0)<=$thumb){
                    if (imageSy($tmp0) > imageSx($tmp0)){
                        $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
                    } else {
                        $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
                    }
                } else {
                    $dim = Array ('w' => $thumb, 'h' => round(imageSy($tmp0)*$thumb/imageSx($tmp0)));
                }
            }
            $tmp1 = imageCreateTrueColor ( $dim [ 'w' ], $dim [ 'h' ] );
            if ( imagecopyresized  ( $tmp1 , $tmp0, 0, 0, 0, 0, $dim [ 'w' ], $dim [ 'h' ], imageSx ( $tmp0 ), imageSy ( $tmp0 ) ) ) {
                imageDestroy ( $tmp0 );
                return $tmp1;
            } else {
                imageDestroy ( $tmp0 );
                imageDestroy ( $tmp1 );
                return $this -> null;
            }
        } else {
            return $this -> null;
        }
    }

    /**
     * This function handles the extraction of the XML file data used to construct the HTML
     * @return Bool True on success
     * @since 1.0
     * @modified 1.2.3
     */
    function extractXML(){
        $xmlFile = $this->tempDir."/content.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        $this->output['html'] = array();
        $open = ''; $close = '';
        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";
        foreach($data as $key => $row){
            if($row['tag'] == 'DRAW:IMAGE'){
                $text = (!empty($row['attributes']['XLINK:HREF'])) ? '<p><img src="public/temp/'.str_replace('Pictures/', '', $row['attributes']['XLINK:HREF']).'" /></p>' : "<p></p>";
                $this->output['html'] = array_merge(array($text), $this->output['html']);
            }
            if($row['tag'] == "TEXT:P"){
                if($row['type'] == 'complete'){
                    $text = (!empty($row['value'])) ? '<p class="'.$row['attributes']['TEXT:STYLE-NAME'].'">'.$row['value'].'<p>' : "<p></p>";
                    $this->output['html'] = array_merge(array($text), $this->output['html']);
                }elseif($row['type'] == 'open'){
                    $open = $key;
                }elseif($row['type'] == 'close'){
                    $close = $key;
                }
                if($row['type'] != 'complete' && $row['type'] == 'close'){
                    $text = $this->getAllText($open, $close);
                    $this->output['html'] = array_merge(array($text), $this->output['html']);
                }
            }
        }
       $this->output['html'] = array_reverse($this->output['html']); 
       $this->output['styles'] = $this->styles;
       $this->output['fonts'] = $this->fonts;
       $this->output['pageStyle'] = array('width' => $this->pageStyle['width'], 'height' => $this->pageStyle['height']);
       $this->output['contentStyle'] = array(
           'margin-left' => $this->pageStyle['left'],
           'margin-right' => $this->pageStyle['right'],
           'margin-top' => $this->pageStyle['top'],
           'margin-bottom' => $this->pageStyle['bottom'],
           'bottom' => $this->pageStyle['bottom']
        );
       $this->output['defaultStyle'] = $this->defaultStyle;
        return true;
    }

    function getAllText($open, $close){
        if(!empty($open) && !empty($close)){
            $local = $this->contentsInArray;
            $sameLevelArray = array();
            $returnContent = '';
            foreach($local as $key => $row){
                if($key >= $open && $key <= $close){
                    array_push($sameLevelArray, $row);
                }
            }
            if(!empty($sameLevelArray[0]['attributes']['TEXT:STYLE-NAME'])){
                $returnContent = '<p class="'.$sameLevelArray[0]['attributes']['TEXT:STYLE-NAME'].'">';
                foreach($sameLevelArray as $key => $row) {
                    if($row['tag'] == 'TEXT:SPAN'){
                        if(!empty($row['value'])){
                            $returnContent .= '<span class="'.$row['attributes']['TEXT:STYLE-NAME'].'">'.$row['value'].'</span>';
                        }
                    }
                }
                $returnContent .= '</p>';
            }
            return $returnContent;
        }
    }

    /**
     * Below function takes the style array and returns a styles string
     * @param $styleArray
     * @return string
     */
    function convertArrayToString($styleArray){
        $string = '';
        if(is_array($styleArray)){
            foreach($styleArray as $key => $value){
                $string .= $key.': '.$value.';';
            }
            return $string;
        }else{
            return '';
        }
    }

    /**
     * Recursive directory creation based on full path.
     * Will attempt to set permissions on folders.
     * @param string $target Full path to attempt to create.
     * @return bool Whether the path was created or not. True if path already exists.
     * @since 1.0
     */
    function mkdir_p( $target ) {
        // from php.net/mkdir user contributed notes
        $target = str_replace( '//', '/', $target );
        if ( file_exists( $target ) ){
            return @is_dir( $target );
        }
        // Attempting to create the directory may clutter up our display.
        if ( @mkdir( $target ) ) {
            $stat = @stat( dirname( $target ) );
            $dir_perms = $stat['mode'] & 0007777;  // Get the permission bits.
            @chmod( $target, $dir_perms );
            return true;
        } elseif ( is_dir( dirname( $target ) ) ) {
            return false;
        }
        // If the above failed, attempt to create the parent node, then try again.
        if ( ( $target != '/' ) && ( $this->mkdir_p( dirname( $target ) ) ) ){
            return $this->mkdir_p( $target );
        }
        return false;
    }
    /**
     * This function concludes the class by removing all te temporary files and folders as well as unsetting all variables not required
     * @return Bool True on success
     * @since 1.0
     */
    function DeleteTemps(){
        //this function will delete all the temp files except the word document
        //(.odt) itself. If this was uploaded it will be removed when the
        //script terminates
        if(is_dir($this->tempDir)){
            //the temp directory still exist
            $this->rrmdir($this->tempDir);
            unset($this->content_folder);
            unset($this->odtPath);
            unset($this->imagePathPrefix);
            unset($this->image_max_width);
            unset($this->tempDir);
            unset($this->rels);
            unset($this->tagclosep);
            unset($this->tagcloset);
            return true;
        }
        return false;
    }
    /**
     * This function will remove files and directories recursivly
     * @param String $dir The path to the folder to be removed
     */
    function rrmdir($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir."/".$object) == "dir"){
                        $this->rrmdir($dir."/".$object);
                    } else {
                        unlink($dir."/".$object);
                    }
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }
}