<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Pms;
use Models\SyncPms;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SyncPmsController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('syncPms');
        $this->_model = new SyncPms();
        //$this->verifyAndCleanItUp();
    }
	
    public function validateData($value){
        //if(preg_match('/([{}<>;:=]+)(*)/',$value)){
	if(preg_match('/[\'\/~`\\\^&\*\(\)_\-\+=\{\}\[\]\|;:"\<\>,\?\\\]/', $value)){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($response);
                        exit;
                }
    }

    public function polices(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('polices'),
            'active' => 'pms',
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['V'] = true;
        $data['ECD'] = true;
	$headers = array(
                'Content-Type'         => 'application/json',
                'token'         => $this->session->get('token')
            );
        $cloudProperties = $this->_model->getCloudProperties($headers);	    
        if($this->session->get('readOnlyAdmin')){            
            $policyEdit = $cloudProperties['body']->{'cloudPropertyElement'}->{'policyEdit'};
            if($policyEdit == true){
                $data['V'] = true;
                $data['ECD'] = true;
            }else{
                $data['V'] = true;
                $data['ECD'] = false;
            }
        }
	if($this->session->get('isAVScanEnabled') == 'true'){
                $data['isAVScanEnabled'] = 'true';
        }else{
                $data['isAVScanEnabled'] = 'false';
        }
	if($this->session->get('readOnlyAdminUser') == 'Yes'){
		$data['readOnlyAdminUser'] = 'Yes';
	}else{
		$data['readOnlyAdminUser'] = 'No';
	}
	$searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$data['searchEnabled'] = $searchEnabled;
	$noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
	$data['noOfDevicesAllowed'] = $noOfDevicesAllowed;
	$passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
	$data['passwordChangeEnforce'] = $passwordChangeEnforce;
	$canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
	$data['canUserChangePassword'] =  $canUserChangePassword;
	$canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
	$data['canAdminChangeUserPassword'] = $canAdminChangeUserPassword;
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/view', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicies(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true'
            );
            $result = $this->_model->getAllPolicies($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
                    if(!empty($result['body']->{'syncPolicyElementList'})) {
                        foreach ($result['body']->{'syncPolicyElementList'} as $value) {
                            $policy = array(
                                'policygroupName'       => (string)$value->{'policygroupName'},
                                'description' => (string)$value->{'description'},
                                'mappedUserCount' => (int)$value->{'mappedUserCount'},
                                'osType'                => (string)$value->{'osType'},
                                'policyRefresh'         => (string)$value->{'policyRefresh'},
                                'cloudCredential'       => (string)$value->{'cloudCredential'},
                                'maxFileSize'           => (string)$value->{'maxFileSize'},
                                'pftSize'               => (string)$value->{'pftSize'},
                                'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                                'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                                'crawlLimit'            => (string)$value->{'crawlLimit'},
                                'maxVersions'           => $value->{'maxVersions'},
                                'userSizeAllowed'       => $value->{'userSizeAllowed'},
                                'vssEnabled'            => (string)$value->{'vssEnabled'},
                                'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                                'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                                'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                                'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                                //'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                                'filterInclusionName' => (array)$value->{'filterInclusionName'},
                                'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                                'syncInterval'          => (string)$value->{'syncInterval'},
                                'expiredDate'           => (string)$value->{'expiredDate'},
                                'shareEnabled'          => (string)$value->{'shareEnabled'},
                                'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                                'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                                'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                                'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                                'contentIndexEnabled'   => (boolean)$value->{'contentIndexEnabled'},
                                'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                                'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                                'pftEnabled'            => (string)$value->{'pftEnabled'},
                                'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                                'dedup' => (string)$value->{'dedup'},
                                'blocked' => $value->{'blocked'},
                                'noOfDaysToPurgeFile' => $value->{'noOfDaysToPurgeFile'},
                                'downloadAgent' => (boolean)$value->{'downloadAgent'},
                                'canUserChangePassword' =>  $value->{'canUserChangePassword'},
                                'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                                'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
				    'filterType' => (string)$value->{'filterType'},
                            );
                            $policy['maxVersionsForSort'] = $policy['maxVersions'];
                            if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                            }
                            $policies = array_merge(array($policy), $policies);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getDaysString($numString){
        $numString = str_replace('1', Language::show('Sunday', 'keywords'), $numString);
        $numString = str_replace('2', Language::show('Monday', 'keywords'), $numString);
        $numString = str_replace('3', Language::show('Tuesday', 'keywords'), $numString);
        $numString = str_replace('4', Language::show('Wednesday', 'keywords'), $numString);
        $numString = str_replace('5', Language::show('Thursday', 'keywords'), $numString);
        $numString = str_replace('6', Language::show('Friday', 'keywords'), $numString);
        return str_replace('7', Language::show('Saturday', 'keywords'), $numString);
    }

    public function createPolicy(){
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                 if((string)$value->{'productType'} != 'bluvault'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
                    
    $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy'),
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'passwordChangeEnforce' => $passwordChangeEnforce,
             'canUserChangePassword' =>  $canUserChangePassword,
             'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
             'filCanned' => $filCanned,
             'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isAVScanEnabled') == 'true'){
                $data['isAVScanEnabled'] = 'true';
        }else{
                $data['isAVScanEnabled'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/create', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function viewPolicy(){
        $policyName = $_POST['policyName'];
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'syncPolicyElement'};
                    $policyRefresh = explode(':', (string)$value->{'policyRefresh'});
                    if($policyRefresh[1] == '00'){
                        $policyRefresh = $policyRefresh[0];
                    }else{
                        $policyRefresh = (string)$value->{'policyRefresh'};
                    }
                    $nwFromClientToPGMB = round($result['body']->{'syncPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
		    if(!empty($value->{'shareDomainIncExclusions'})){
                        $value->{'shareDomainIncExclusions'} = implode (",", $value->{'shareDomainIncExclusions'});
                    }
		    if(!empty($value->{'shareDomainIncExclusionsException'})){
                        $value->{'shareDomainIncExclusionsException'} = implode (",", $value->{'shareDomainIncExclusionsException'});
                    }
                    $policy = array(
                        'policygroupName'       => (string)$value->{'policygroupName'},
                        'osType'                => (string)$value->{'osType'},
                        'policyRefresh'         => $policyRefresh,
                        //'cloudCredentialName'   => (string)$value->{'cloudCredentialName'},
                        'maxFileSize'           => (string)$value->{'maxFileSize'},
                        'pftSize'               => (string)$value->{'pftSize'},
                        'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                        'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                        'crawlLimit'            => (string)$value->{'crawlLimit'},
                        'maxVersions'           => (string)$value->{'maxVersions'},
                        'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                        //'vssEnabled'            => (string)$value->{'vssEnabled'},
                        'description'           => (string)$value->{'description'},
                        'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                        'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                        'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
			'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                        'filterInclusionName'   => (array)$value->{'filterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'syncInterval'          => (string)$value->{'syncInterval'},
                        'expiredDate'           => (string)$value->{'expiredDate'},
                        'shareEnabled'          => (string)$value->{'shareEnabled'},
			'twoWayShareEnabled'    => (string)$value->{'twoWayShareEnabled'},
                        'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                        'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                        'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                        'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
			'googleAuth' 		=> (boolean)$value->{'googleAuth'},
                        'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                        'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                        'pftEnabled'            => (string)$value->{'pftEnabled'},
                        'searchAlgoForPg'            => (string)$value->{'searchAlgoForPg'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                        'dedup' => (string)$value->{'dedup'},
                        'noOfDaysToPurgeFile' => $value->{'noOfDaysToPurgeFile'},
                        'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'canUserChangePassword' =>  $value->{'canUserChangePassword'},
                         'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
                        'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'noOfDevicesAllowed' => $value->{'noOfDevicesAllowed'},
                        'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'emailsRestriction' => (array)$value->{'emailsRestriction'},
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
			'searchFilterType' => (string)$value->{'searchFilterType'},
			'menuOptions' => (array)$value->{'menuOptions'},
			'shareDomainType' => $value->{'shareDomainType'},
                	'shareDomainIncExclusions' => $value->{'shareDomainIncExclusions'},
			'shareDomainIncExclusionsException' => $value->{'shareDomainIncExclusionsException'},
			'enableAVScan' => (boolean)$value->{'enableAVScan'},
			'showShareLink'   => (boolean)$value->{'showShareLink'},
			'shareDomainsEnabled' => (boolean)$value->{'shareDomainsEnabled'},
			'clientDedup' => (string)$value->{'clientDedup'}
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit();
                case (421):
                    $msg = $this->language->get('421');
                    exit();
                case (500):
                    $msg = $this->language->get('500');
                    exit();
                case (0):
                    $msg = $this->language->get('0');
                    exit();
                default:
                    $msg = $this->language->get('default');
                    exit();
            }
            $result = array(
                        'result' => 'fail',
                        'msg' => $msg
                    );

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function blockPolicy(){
        //Auth::allowOnly('admin');
            $headers = array(
                'token' => $this->session->get('token'),
                'policyType' => 'syncPolicy',
                'policyName' => $_POST['policyName']
            );
            $result = $this->_model->blockPolicy($headers);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('policyBlocked')
                    );
                    echo json_encode($response);
                    exit;
                case (333):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMapped')
                    );
                    echo json_encode($response);
                    exit;
		case (444):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMappedDelegatedAdmin')
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
		case (445):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'This policy is set as default policy for user migration.'
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    public function clonePolicy($policyName){
        $this->session->put('selectedPolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
    $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy'),
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => array_reverse($schedules),
            'filters' => array_reverse($filters),
            'sch1' => $sch1,
            'fil1' => $fil1,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'filCanned' => $filCanned,
            'pgs' => $pgs,
            'ccS' => array_reverse($ccS),
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isAVScanEnabled') == 'true'){
                $data['isAVScanEnabled'] = 'true';
        }else{
                $data['isAVScanEnabled'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/clone', $data);
        View::renderTemplate('footer', $data);
    }

    public function savePolicy(){
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxFileSize']) || $_POST['maxFileSize'] == 'UNLIMITED'){
            $_POST['maxFileSize'] = "1048576";
        }
        if(empty($_POST['userSizeAllowed']) || $_POST['userSizeAllowed'] == 'UNLIMITED'){
            $_POST['userSizeAllowed'] = "102400";
        }
         if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "-1";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if (strpos($_POST['policyRefresh'], ':') == false) {
            $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
        }
	if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   $_POST['nwFromClientToPGMB'] = 10000.0000;
                }
                else{
                    if($_POST['networkThrottlingUnit'] == "kbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
                    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
                    }
                    elseif($_POST['networkThrottlingUnit'] == "gbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
                    }
                    //$_POST['nwFromClientToPGMB'] = number_format($_POST['nwFromClientToPGMB'], 2);
                }

        if(!empty($_POST)){
            $rules = array(
                'incrementalFileTransfer'   => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'userSizeAllowed'           => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'userSizeAllowed'           => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

            //if($validate == true){
            if(true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                $endpointDisabledUiPreferences = [];
                    if(isset($_POST['exitt']) && $_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
                    }
                    if(isset($_POST['decouple']) && $_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }
                    else{
                        array_push($endpointDisabledUiPreferences,'DECOUPLE');
                    }
                    if(isset($_POST['support']) && $_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }
                    if(isset($_POST['initiatesync']) && $_POST['initiatesync']=='true'){
                        array_push($endpointUiPreferences,'INITIATE_SYNC');
                    }else{
                        array_push($endpointDisabledUiPreferences,'INITIATE_SYNC');
                    }
                    if(isset($_POST['syncsettings']) && $_POST['syncsettings']=='true'){
                        array_push($endpointUiPreferences,'SYNC_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYNC_SETTINGS');
                    }
                    if(isset($_POST['syncfiles']) && $_POST['syncfiles']=='true'){
                        array_push($endpointUiPreferences,'SYNC_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYNC_FILES');
                    }
                    if(isset($_POST['refreshsyncpolicy']) && $_POST['refreshsyncpolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_SYNC_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_SYNC_POLICY');
                    }
                    if(isset($_POST['search']) && $_POST['search']=='true'){
                        array_push($endpointUiPreferences,'SEARCH');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SEARCH');
                    }
                    if(isset($_POST['opensyncfolder']) && $_POST['opensyncfolder']=='true'){
                        array_push($endpointUiPreferences,'OPEN_SYNC_FOLDER');
                    }else{
                        array_push($endpointDisabledUiPreferences,'OPEN_SYNC_FOLDER');
                    }
		    if(isset($_POST['blockNotifications']) && $_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if(isset($_POST['about']) && $_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'ABOUT');
                    }
                    if(isset($_POST['updateAgent']) && $_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if(isset($_POST['systrayIcon']) && $_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYSTRAYICON');
                    }		    

		$arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }

            if (strpos($_POST['policyRefresh'], ':') == false) {
                    $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                }
                $_POST['policyName'] = trim($_POST['policyName']);
                
                if(isset($_POST['switchAllowedDomains']) && $_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
		}		
		$menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
                    "rename" => $_POST['rename'],
                    "cutCopyPaste" => $_POST['CutCopyPaste'],
                    "fileUpload" => $_POST['fileUpload'],
                    "createFolder" => $_POST['createFolder'],
                    "createMiniCloud" => $_POST['createMinicloud'],
		    "delete" => $_POST['delete'],
                );
		if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
            		$_POST['highSecureShareEnabled'] = 'false';
        	}else{
            		$_POST['highSecureShareEnabled'] = 'true';
        	}
		if(isset($_POST['controllerSL']) && $_POST['controllerSL'] == 'true'){
                    $_POST['showShareLink'] = 'true';
                }else{
                    $_POST['showShareLink'] = 'false';
                }
		if(isset($_POST['controllerCP']) && $_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
		if(isset($_POST['controllerAD']) && $_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
		if(isset($_POST['controllerED']) && $_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
		if(isset($_POST['controllerMFA']) && $_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		if(empty($_POST['shareDomainsEnabled']) || $_POST['shareDomainsEnabled'] != 'enabled'){
                        $_POST['shareDomainsEnabled'] = 'false';
                }else{
                        $_POST['shareDomainsEnabled'] = 'true';
                }
		$_POST['shareDomainIncExclusions'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusions']);
		$_POST['shareDomainIncExclusionsException'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusionsException']);
		if($this->session->get('isAVScanEnabled') == 'true'){
                	if(isset($_POST['enableAVScan']) && $_POST['enableAVScan'] == 'true'){
            			$_POST['enableAVScan'] = 'true';
        		}else{
            			$_POST['enableAVScan'] = 'false';
        		}
		}else{
			$_POST['enableAVScan'] = 'false';
		}
		if(multifactorAuthWithAccessCode == true){
                        $complexPasswordRequired = 'false';
                }else{
                        $complexPasswordRequired = ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['complexPasswordRequired'];
                }
                $data = array(
                    "syncEnableAutomatic"		=> !empty($_POST['syncEnableAutomatic']) ? $_POST['syncEnableAutomatic'] : '',
                    "syncInterval"                  	=> !empty($_POST['syncInterval']) ? $_POST['syncInterval'] : '',
                    "deDuplicationEnabled"          	=> !empty($_POST['deDuplicationEnabled']) ? $_POST['deDuplicationEnabled'] : '',
                    "shareEnabled"                  	=> !empty($_POST['shareEnabled']) ? $_POST['shareEnabled'] : 'false',
		    "twoWayShareEnabled"            	=> !empty($_POST['twoWayShareEnabled']) ? $_POST['twoWayShareEnabled'] : 'false',
                    "highSecureShareEnabled"        	=> !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPasswordRequired"       	=> $complexPasswordRequired,
                    "preventDownloadEnabled"        	=> ($_POST['highSecureShareEnabled'] == "true") ? "false" : $_POST['preventDownloadEnabled'],
                    "expiredDate"                   	=> ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['expiredDate'],
		    "googleAuth"         	    	=> ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['googleAuth'],
                    "cacheUsedData"                 	=> !empty($_POST['cacheUsedData']) ? $_POST['cacheUsedData'] : '',
                    "policygroupName"               	=> !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   	=> $_POST['description'],
                    "cloudCredential"               	=> !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    	=> !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "maxVersions"                   	=> !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   	=> !empty($_POST['maxFileSize']) ? $_POST['maxFileSize'] : '',
                    "osType"                        	=> 'universal',
                    "pftEnabled"                    	=> !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       	=> !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "fileChunkableSize"             	=> !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               	=> !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              	=> $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            	=> $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           	=> !empty($_POST['filters']) ? $_POST['filters'] : [],
                    "searchFilterInclusionName"         => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    "networkThrottlingNames"        	=> array('DEFAULT_NETWORK_THROTTLE'),
                    "userSizeAllowed"               	=> !empty($_POST['userSizeAllowed']) ? $_POST['userSizeAllowed'] : '',
                    "memoryUtilization"             	=> !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                	=> !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "compressionEnabled"            	=> !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  	=> $privacyGatewayMappingElement,
                    "endpointUiPreferences"         	=> $endpointUiPreferences,
                    "endpointDisabledUiPreferences"     => $endpointDisabledUiPreferences,
                    "policyRefresh"                 	=> !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "dedup"                         	=> !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "noOfDaysToPurgeFile"           	=> !empty($_POST['noOfDaysToPurgeFile']) ? $_POST['noOfDaysToPurgeFile'] : 0,
                    "downloadAgent"                  	=> !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "canUserChangePassword" 	    => !empty($_POST['canUserChangePassword']) ? $_POST['canUserChangePassword'] : 'false',
                    "canAdminChangeUserPassword"    => !empty($_POST['canAdminChangeUserPassword']) ? $_POST['canAdminChangeUserPassword'] : 'false',
                    "searchAlgoForPg"               	=> !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    'noOfDevicesAllowed' 		=> $_POST['noOfDevicesAllowed'],
                    "endpointDomainCheck"      		=> $_POST['switchAllowedDomains'],
                    "allowedDomains"           		=> $_POST['allowedDomains'],
                    "webBasedLogin"                  	=> !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    'contentIndexEnabled'            	=> $_POST['contentIndexEnabled'],
		    "filterType" 			=> $_POST['filtersType'],
		    "searchFilterType" 			=> $_POST['searchFilterType'],
		    "menuOptions"                   	=> $menuOptions,		    
		    "shareDomainType"               => !empty($_POST['shareDomainType']) ? $_POST['shareDomainType']: 'Share only with these Email domains',
                    "shareDomainIncExclusions"     	=> explode (",", $_POST['shareDomainIncExclusions']),
		    "shareDomainIncExclusionsException" => explode (",", $_POST['shareDomainIncExclusionsException']),
		    "enableAVScan" 		        => $_POST['enableAVScan'],
		    "showShareLink"   			=> $_POST['showShareLink'],
		    "shareDomainsEnabled"               => $_POST['shareDomainsEnabled'],
		    "clientDedup"                   	=> $_POST['clientDedup']
                );
		if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->savePolicy($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function savePolicyEdit(){
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxFileSize']) || $_POST['maxFileSize'] == 'UNLIMITED'){
            $_POST['maxFileSize'] = "1048576";
        }
        if(empty($_POST['userSizeAllowed']) || $_POST['userSizeAllowed'] == 'UNLIMITED'){
            $_POST['userSizeAllowed'] = "102400";
        }
         if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "-1";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if (strpos($_POST['policyRefresh'], ':') == false) {
            $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
        }
	if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   $_POST['nwFromClientToPGMB'] = 10000.0000;
                }
                else{
                    if($_POST['networkThrottlingUnit'] == "kbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
                    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
                    }
                    elseif($_POST['networkThrottlingUnit'] == "gbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
                    }
                    //$_POST['nwFromClientToPGMB'] = number_format($_POST['nwFromClientToPGMB'], 2);
                }

        if(!empty($_POST)){
            $rules = array(
                'incrementalFileTransfer'   => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'userSizeAllowed'           => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'userSizeAllowed'           => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

            //if($validate == true){
            if(true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                $endpointDisabledUiPreferences = [];
                    if(isset($_POST['exitt']) && $_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
                    }
                    if(isset($_POST['decouple']) && $_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }
                    else{
                        array_push($endpointDisabledUiPreferences,'DECOUPLE');
                    }
                    if(isset($_POST['support']) && $_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }
                    if(isset($_POST['initiatesync']) && $_POST['initiatesync']=='true'){
                        array_push($endpointUiPreferences,'INITIATE_SYNC');
                    }else{
                        array_push($endpointDisabledUiPreferences,'INITIATE_SYNC');
                    }
                    if(isset($_POST['syncsettings']) && $_POST['syncsettings']=='true'){
                        array_push($endpointUiPreferences,'SYNC_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYNC_SETTINGS');
                    }
                    if(isset($_POST['syncfiles']) && $_POST['syncfiles']=='true'){
                        array_push($endpointUiPreferences,'SYNC_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYNC_FILES');
                    }
                    if(isset($_POST['refreshsyncpolicy']) && $_POST['refreshsyncpolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_SYNC_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_SYNC_POLICY');
                    }
                    if(isset($_POST['search']) && $_POST['search']=='true'){
                        array_push($endpointUiPreferences,'SEARCH');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SEARCH');
                    }
                    if(isset($_POST['opensyncfolder']) && $_POST['opensyncfolder']=='true'){
                        array_push($endpointUiPreferences,'OPEN_SYNC_FOLDER');
                    }else{
                        array_push($endpointDisabledUiPreferences,'OPEN_SYNC_FOLDER');
                    }
		    if(isset($_POST['blockNotifications']) && $_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if(isset($_POST['about']) && $_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'ABOUT');
                    }
                    if(isset($_POST['updateAgent']) && $_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if(isset($_POST['systrayIcon']) && $_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYSTRAYICON');
                    }		    

		$arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }

                if (strpos($_POST['policyRefresh'], ':') == false) {
                    $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                }
                $_POST['policyName'] = trim($_POST['policyName']);
                
                if(isset($_POST['switchAllowedDomains']) && $_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
		}		
		$menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
                    "rename" => $_POST['rename'],
                    "cutCopyPaste" => $_POST['CutCopyPaste'],                    
                    "fileUpload" => $_POST['fileUpload'],
                    "createFolder" => $_POST['createFolder'],
                    "createMiniCloud" => $_POST['createMinicloud'],
		    "delete" => $_POST['delete'],
                );
		if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
            		$_POST['highSecureShareEnabled'] = 'false';
        	}else{
            		$_POST['highSecureShareEnabled'] = 'true';
        	}
		if(isset($_POST['controllerSL']) && $_POST['controllerSL'] == 'true'){
                    $_POST['showShareLink'] = 'true';
                }else{
                    $_POST['showShareLink'] = 'false';
                }
		if(isset($_POST['controllerCP']) && $_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
		if(isset($_POST['controllerAD']) && $_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
		if(isset($_POST['controllerED']) && $_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
		if(isset($_POST['controllerMFA']) && $_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		if(empty($_POST['shareDomainsEnabled']) || $_POST['shareDomainsEnabled'] != 'enabled'){
                        $_POST['shareDomainsEnabled'] = 'false';
                }else{
                        $_POST['shareDomainsEnabled'] = 'true';
                }
		$_POST['shareDomainIncExclusions'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusions']);
		$_POST['shareDomainIncExclusionsException'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusionsException']);
		if($this->session->get('isAVScanEnabled') == 'true'){
                	if(isset($_POST['enableAVScan']) && $_POST['enableAVScan'] == 'true'){
            			$_POST['enableAVScan'] = 'true';
        		}else{
            			$_POST['enableAVScan'] = 'false';
        		}
		}else{
			$_POST['enableAVScan'] = 'false';
		}
		if(multifactorAuthWithAccessCode == true){
                        $complexPasswordRequired = 'false';
                }else{
                        $complexPasswordRequired = ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['complexPasswordRequired'];
                }
                $data = array(
                    "syncEnableAutomatic"           => !empty($_POST['syncEnableAutomatic']) ? $_POST['syncEnableAutomatic'] : '',
                    "syncInterval"                  => !empty($_POST['syncInterval']) ? $_POST['syncInterval'] : '',
                    "deDuplicationEnabled"          => !empty($_POST['deDuplicationEnabled']) ? $_POST['deDuplicationEnabled'] : '',
                    "shareEnabled"                  => !empty($_POST['shareEnabled']) ? $_POST['shareEnabled'] : 'false',
		    "twoWayShareEnabled"            => !empty($_POST['twoWayShareEnabled']) ? $_POST['twoWayShareEnabled'] : 'false',
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPasswordRequired"       => $complexPasswordRequired,
                    "preventDownloadEnabled"        => ($_POST['highSecureShareEnabled'] == "true") ? "false" : $_POST['preventDownloadEnabled'],
                    "expiredDate"                   => ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['expiredDate'],
		    "googleAuth"         	    => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['googleAuth'],
                    "cacheUsedData"                 => !empty($_POST['cacheUsedData']) ? $_POST['cacheUsedData'] : '',
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxFileSize']) ? $_POST['maxFileSize'] : '',
                    "osType"                        => 'universal',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : [],
                    "searchFilterInclusionName"     => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "userSizeAllowed"               => !empty($_POST['userSizeAllowed']) ? $_POST['userSizeAllowed'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "endpointDisabledUiPreferences" => $endpointDisabledUiPreferences,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "noOfDaysToPurgeFile"           => !empty($_POST['noOfDaysToPurgeFile']) ? $_POST['noOfDaysToPurgeFile'] : 0,
                    "canUserChangePassword" 	    => !empty($_POST['canUserChangePassword']) ? $_POST['canUserChangePassword'] : 'false',
                    "canAdminChangeUserPassword"    => !empty($_POST['canAdminChangeUserPassword']) ? $_POST['canAdminChangeUserPassword'] : 'false',
                    "downloadAgent"                 => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    'noOfDevicesAllowed' 	    => $_POST['noOfDevicesAllowed'],
                    "endpointDomainCheck"      	    => $_POST['switchAllowedDomains'],
                    "allowedDomains"                => $_POST['allowedDomains'],
                    "webBasedLogin"                 => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    'contentIndexEnabled'           => $_POST['contentIndexEnabled'],
		    "filterType" 	            => $_POST['filtersType'],
		    "searchFilterType" 		    => $_POST['searchFilterType'],
		    "menuOptions"                   => $menuOptions,		    
		    "shareDomainType"               => !empty($_POST['shareDomainType']) ? $_POST['shareDomainType']: 'Share only with these Email domains',
                    "shareDomainIncExclusions"      => explode (",", $_POST['shareDomainIncExclusions']),
		    "shareDomainIncExclusionsException"  => explode (",", $_POST['shareDomainIncExclusionsException']),
		    "enableAVScan" 		    => $_POST['enableAVScan'],
		    "showShareLink"   		    => $_POST['showShareLink'],
		    "shareDomainsEnabled"           => $_POST['shareDomainsEnabled'],
		    "clientDedup"                   => $_POST['clientDedup']
                );
		if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->savePolicyEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function serializeTheString($oneBigStrings){
        if(!empty($oneBigStrings)){
            $strings = explode('^', $oneBigStrings);
            $array = array();
            foreach($strings as $string){
                list($scriptName, $scriptArgs, $backupType) = explode('|', $string);
                $scriptArray = array(
                    'scriptName' => $scriptName,
                    'backupType' => $backupType,
                    'scriptArgs' => explode(',', $scriptArgs)
                );
                $array = array_merge(array($scriptArray), $array);
            }
            return $array;
        }else{
            return null;
        }
    }

    public function editPolicy($policyName){
        $this->session->put('selectedPolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                  if((string)$value->{'productType'} != 'bluvault'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
    $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy'),
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'filCanned' => $filCanned,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isAVScanEnabled') == 'true'){
                $data['isAVScanEnabled'] = 'true';
        }else{
                $data['isAVScanEnabled'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/edit', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicy(){
        $policyName = $this->session->get('selectedPolicyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'syncPolicyElement'};
                    $policyRefresh = explode(':', (string)$value->{'policyRefresh'});
                    if($policyRefresh[1] == '00'){
                        $policyRefresh = $policyRefresh[0];
                    }else{
                        $policyRefresh = (string)$value->{'policyRefresh'};
                    }

                    $nwFromClientToPGMB = round($result['body']->{'syncPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
		    if(!empty($value->{'shareDomainIncExclusions'})){
                        $value->{'shareDomainIncExclusions'} = implode (",", $value->{'shareDomainIncExclusions'});
                    }
		    if(!empty($value->{'shareDomainIncExclusionsException'})){
                        $value->{'shareDomainIncExclusionsException'} = implode (",", $value->{'shareDomainIncExclusionsException'});
                    }
                    $policy = array(
                        'policygroupName'       => (string)$value->{'policygroupName'},
                        'osType'                => (string)$value->{'osType'},
                        'policyRefresh'         => $policyRefresh,
                        'description' => (string)$value->{'description'},
                        //'cloudCredential'       => (string)$value->{'cloudCredential'},
                        'maxFileSize'           => (string)$value->{'maxFileSize'},
                        'pftSize'               => (string)$value->{'pftSize'},
                        'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                        'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                        'crawlLimit'            => (string)$value->{'crawlLimit'},
                        'maxVersions'           => (string)$value->{'maxVersions'},
                        'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                        //'vssEnabled'            => (string)$value->{'vssEnabled'},
                        'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                        'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                        'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
			'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                        'filterInclusionName'   => (array)$value->{'filterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'syncInterval'          => (string)$value->{'syncInterval'},
                        'expiredDate'           => (string)$value->{'expiredDate'},
                        'shareEnabled'          => (string)$value->{'shareEnabled'},
			'twoWayShareEnabled'    => (string)$value->{'twoWayShareEnabled'},
                        'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                        'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                        'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                        'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
			'googleAuth' 		=> (boolean)$value->{'googleAuth'},
                        'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                        'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                        'pftEnabled'            => (string)$value->{'pftEnabled'},
                        'searchAlgoForPg'       => (string)$value->{'searchAlgoForPg'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                        'dedup'                 => (string)$value->{'dedup'},
                        'noOfDaysToPurgeFile'   => $value->{'noOfDaysToPurgeFile'},
                        'canUserChangePassword' =>  $value->{'canUserChangePassword'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                         'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
                        'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'noOfDevicesAllowed' => $value->{'noOfDevicesAllowed'},
                        'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'emailsRestriction' => (array)$value->{'emailsRestriction'},
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
			'searchFilterType' => (string)$value->{'searchFilterType'},
			'menuOptions' => (array)$value->{'menuOptions'},
			'shareDomainType' => $value->{'shareDomainType'},
                	'shareDomainIncExclusions' => $value->{'shareDomainIncExclusions'},
			'shareDomainIncExclusionsException' => $value->{'shareDomainIncExclusionsException'},
			'enableAVScan' => (boolean)$value->{'enableAVScan'},
			'showShareLink'   => (boolean)$value->{'showShareLink'},
			'shareDomainsEnabled' => (boolean)$value->{'shareDomainsEnabled'},
			'clientDedup' => (string)$value->{'clientDedup'}
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function singlePolicyMapping(){
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));

        $syncPolicies1 = [];
            foreach((array)$syncResult1['body']->{'stringList'} as $value){
                $policy = $value;
                $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
            }
            natcasesort($syncPolicies1);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy_mapping'),
            'crumb2' => $this->language->get('change_user_policy'),
            'active' => 'pms',
            'syncPolicies1' => $syncPolicies1,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	if($this->session->get('readOnlyAdminUser') == 'Yes'){
		$data['readOnlyAdminUser'] = 'Yes';
	}else{
		$data['readOnlyAdminUser'] = 'No';
	}
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicyMapping/single', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicyMappingDetails(){
        if(!empty($_POST)){
            $headers = array(
                    'token' => $this->session->get('token'),
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getPolicyMappingDetails($headers);
            }
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                            'result' => 'success',
                            'policies' => $result['body']->{'data'}->{'existingPolicies'},
                            'users' => !empty($result['body']->{'data'}->{'userBackupPolicyMappingElements'}) ? $result['body']->{'data'}->{'userBackupPolicyMappingElements'} : [],
                            'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
		case (421):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
		    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getPolicyMappingDetailsNavigate(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getPolicyMappingDetailsNavigate($headers, $_POST['url']);
            }
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'policies' => $result['body']->{'data'}->{'existingPolicies'},
			'users' => !empty($result['body']->{'data'}->{'userBackupPolicyMappingElements'}) ? $result['body']->{'data'}->{'userBackupPolicyMappingElements'} : [],
                        'metadata' => $metadata
                );
                    echo json_encode($response);
                    exit;

                case (421):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
		    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
		    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function saveSinglePolicyMapping(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userName'          => html_entity_decode($_POST['userName'], ENT_QUOTES | ENT_HTML5),
                'newPolicyName'     => $_POST['newPolicyName'],
                'existingPolicyName'=> $_POST['oldPolicyName']
            );
            $result = $this->_model->saveSinglePolicyMapping($headers, urldecode($_POST['userName']));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function multiplePolicyMapping(){
        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));

        if(!empty((array)$result['body']->{'syncPolicyElementList'})){
            $policies = [];
            foreach((array)$result['body']->{'syncPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }
            
            $syncPolicies1 = [];
            foreach((array)$syncResult1['body']->{'stringList'} as $value){
                $policy = $value;
                $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
            }
            natcasesort($syncPolicies1);
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('policy_mapping'),
                'crumb2' => (Auth::checkCloudPermission('serverBackup')) ? $this->language->get('assign_policy') : $this->language->get('assign_policy_for_users_in_bulk'),
                'active' => 'pms',
                'csrf_token' => $this->setCSRFToken(),
                'policies' => $policies,
                'syncPolicies1' => $syncPolicies1,
                'loggedInUser' => $this->session->all()
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('pms/syncPolicyMapping/multiple', $data);
            View::renderTemplate('footer', $data);
        }else{
            header('Location: '.Url::basePath('pms/policy/create'));
        }
    }

    public function saveMultiplePolicyMapping(){
        if(!empty($_POST)){
		foreach($_POST['userNamesToTest'] as $value){
			$this->validateData($value);
		}
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),                
            );
            $result = $this->_model->saveMultiplePolicyMapping($headers, $_POST['userNames']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (409):
                    $result = array(
                        'result' => 'fail_withexcel',
                        'msg' => $this->language->get('409')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
	
    public function saveMultiplePolicyMappingOld(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
		'userNames'          => urldecode($_POST['userNames']),
                'policyName'     => $_POST['policyName']
            );
            $result = $this->_model->saveMultiplePolicyMappingOld($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (409):
                    $result = array(
                        'result' => 'fail_withexcel',
                        'msg' => $this->language->get('409')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getUserSyncPolicy(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->getUserSyncPolicy($headers);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'syncPolicyElement'};
                    $policy = array(
                        'policygroupName'       => (string)$value->{'policygroupName'},
                        'osType'                => (string)$value->{'osType'},
                        'policyRefresh'         => (string)$value->{'policyRefresh'},
                        'description'           => (string)$value->{'description'},
                        //'cloudCredential'       => (string)$value->{'cloudCredential'},
                        'maxFileSize'           => (string)$value->{'maxFileSize'},
                        'pftSize'               => (string)$value->{'pftSize'},
                        'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                        'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                        'crawlLimit'            => (string)$value->{'crawlLimit'},
                        'expiredDate'           => (string)$value->{'expiredDate'},
                        'maxVersions'           => (string)$value->{'maxVersions'},
                        'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                        //'vssEnabled'            => (string)$value->{'vssEnabled'},
                        'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                        'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                        'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                        'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                        'filterInclusionName' 	=> (array)$value->{'filterInclusionName'},
                        'syncInterval'          => (string)$value->{'syncInterval'},
                        'shareEnabled'          => (string)$value->{'shareEnabled'},
                        'twoWayShareEnabled'    => (string)$value->{'twoWayShareEnabled'},
                        'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                        'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                        'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                        'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
			'googleAuth' 		=> (boolean)$value->{'googleAuth'},
                        'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                        'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                        'pftEnabled'            => (string)$value->{'pftEnabled'},
                        'noOfDevicesAllowed' => $value->{'noOfDevicesAllowed'},
                        'inclusionFilterElement'=> (array)$value->{'inclusionFilterElement'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                        'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'filterType' => (string)$value->{'filterType'},
			'menuOptions' => (array)$value->{'menuOptions'},
			'showShareLink' => (boolean)$value->{'showShareLink'},
			'shareDomainsEnabled' => (boolean)$value->{'shareDomainsEnabled'},
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllScripts($preBackup, $postBackup, $preRestore, $postRestore){
        $data = [];
        if(!empty($preBackup)){
            foreach($preBackup as $key => $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postBackup)){
            foreach($postBackup as $key => $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        if(!empty($preRestore)){
            foreach($preRestore as $key => $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postRestore)){
            foreach($postRestore as $key => $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        return $data;
    }
	
	
    /*pagination starts*/
	
    public function getAllPoliciesPagination(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
		'Content-Type'  => 'application/json',
		'Accept' => 'application/json'
            );
            $result = $this->_model->getAllPoliciesPagination($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
                    if(!empty($result['body']->{'data'}->{'syncPolicyElements'})) {
                        foreach($result['body']->{'data'}->{'syncPolicyElements'} as $value){
                            $policy = array(
                                /*'policygroupName'       => (string)$value->{'policygroupName'},
                                'description' => (string)$value->{'description'},
                                'mappedUserCount' => (int)$value->{'mappedUserCount'},
                                'osType'                => (string)$value->{'osType'},
                                'policyRefresh'         => (string)$value->{'policyRefresh'},
                                'cloudCredential'       => (string)$value->{'cloudCredential'},
                                'maxFileSize'           => (string)$value->{'maxFileSize'},
                                'pftSize'               => (string)$value->{'pftSize'},
                                'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                                'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                                'crawlLimit'            => (string)$value->{'crawlLimit'},
                                'maxVersions'           => $value->{'maxVersions'},
                                'userSizeAllowed'       => $value->{'userSizeAllowed'},
                                'vssEnabled'            => (string)$value->{'vssEnabled'},
                                'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                                'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                                'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                                'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                                //'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                                'filterInclusionName' => (array)$value->{'filterInclusionName'},
                                'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                                'syncInterval'          => (string)$value->{'syncInterval'},
                                'expiredDate'           => (string)$value->{'expiredDate'},
                                'shareEnabled'          => (string)$value->{'shareEnabled'},
                                'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                                'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                                'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                                'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                                'contentIndexEnabled'   => (boolean)$value->{'contentIndexEnabled'},
                                'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                                'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                                'pftEnabled'            => (string)$value->{'pftEnabled'},
                                'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                                'dedup' => (string)$value->{'dedup'},
                                'blocked' => $value->{'blocked'},
                                'noOfDaysToPurgeFile' => $value->{'noOfDaysToPurgeFile'},
                                'downloadAgent' => (boolean)$value->{'downloadAgent'},
                                'canUserChangePassword' =>  $value->{'canUserChangePassword'},
                                'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                                'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
				'filterType' => (string)$value->{'filterType'},*/
				'policygroupName' => (string)$value->{'policygroupName'},
                                'maxVersions' => $value->{'maxVersions'},
                                'userSizeAllowed'       => $value->{'userSizeAllowed'},
                                'filterInclusionName' => (array)$value->{'filterInclusionName'},
                                'blocked' => $value->{'blocked'},
                                'mappedUserCount' => (int)$value->{'mappedUserCount'},
                            );
                            $policy['maxVersionsForSort'] = $policy['maxVersions'];
                            if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                            }
                            $policies = array_merge(array($policy), $policies);
                        }
                    }
		    if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                	$metadata = [];
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }



public function getAllPoliciesPaginationNavigate(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
		'Content-Type'  => 'application/json',
		'Accept' => 'application/json'
            );
            $result = $this->_model->getAllPoliciesPaginationNavigate($headers, $_POST['url']);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
                    if(!empty($result['body']->{'data'}->{'syncPolicyElements'})) {
                        foreach($result['body']->{'data'}->{'syncPolicyElements'} as $value){
                            $policy = array(
                                /*'policygroupName'       => (string)$value->{'policygroupName'},
                                'description' => (string)$value->{'description'},
                                'mappedUserCount' => (int)$value->{'mappedUserCount'},
                                'osType'                => (string)$value->{'osType'},
                                'policyRefresh'         => (string)$value->{'policyRefresh'},
                                'cloudCredential'       => (string)$value->{'cloudCredential'},
                                'maxFileSize'           => (string)$value->{'maxFileSize'},
                                'pftSize'               => (string)$value->{'pftSize'},
                                'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                                'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                                'crawlLimit'            => (string)$value->{'crawlLimit'},
                                'maxVersions'           => $value->{'maxVersions'},
                                'userSizeAllowed'       => $value->{'userSizeAllowed'},
                                'vssEnabled'            => (string)$value->{'vssEnabled'},
                                'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                                'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                                'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                                'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                                //'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                                'filterInclusionName' => (array)$value->{'filterInclusionName'},
                                'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                                'syncInterval'          => (string)$value->{'syncInterval'},
                                'expiredDate'           => (string)$value->{'expiredDate'},
                                'shareEnabled'          => (string)$value->{'shareEnabled'},
                                'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                                'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                                'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                                'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                                'contentIndexEnabled'   => (boolean)$value->{'contentIndexEnabled'},
                                'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                                'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                                'pftEnabled'            => (string)$value->{'pftEnabled'},
                                'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                                'dedup' => (string)$value->{'dedup'},
                                'blocked' => $value->{'blocked'},
                                'noOfDaysToPurgeFile' => $value->{'noOfDaysToPurgeFile'},
                                'downloadAgent' => (boolean)$value->{'downloadAgent'},
                                'canUserChangePassword' =>  $value->{'canUserChangePassword'},
                                'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                                'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
				'filterType' => (string)$value->{'filterType'},*/
				'policygroupName' => (string)$value->{'policygroupName'},
                                'maxVersions' => $value->{'maxVersions'},
                                'userSizeAllowed'       => $value->{'userSizeAllowed'},
                                'filterInclusionName' => (array)$value->{'filterInclusionName'},
                                'blocked' => $value->{'blocked'},
                                'mappedUserCount' => (int)$value->{'mappedUserCount'},
                            );
                            $policy['maxVersionsForSort'] = $policy['maxVersions'];
                            if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                            }
                            $policies = array_merge(array($policy), $policies);
                        }
                    }
			    
		    if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                	$metadata = [];
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }	
    /*pagination ends*/
	
    public function downloadSyncPolicyPdf(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-Type'  => 'application/json',
                'policyName'   => $_POST['policyName']
        );
            $this->session->put('syncpolicyPdf',$_POST['policyName']);
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->downloadSyncPolicyPdf($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        );
                    echo json_encode($response);
                    exit;
                case (403):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create Pdf.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                        );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
		    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                    default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadSyncPolicyFilePdf(){
        $filePath = AGENT_NOT_HEARD_PATH.$this->session->get('syncpolicyPdf')."_Policy.pdf";
        if(file_exists($filePath)){
                $this->log("iffffffffffffff : ".$filePath,"info");
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.$this->session->get('syncpolicyPdf').".pdf");
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
        }else{
                $this->log("elseeeeeeeeee : ".$filePath,"info");
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }

    }
}
