<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4
* @date 18/09/18
* @time 12:43 PM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
	    <span class="currentPage hide"><?='aadCredentials'?></span>
	    <?php if($_SESSION['storageResult'] == 'error'){ ?>
             <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php }elseif($_SESSION['storageResult'] == 'success'){ ?>
             <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php } ?>
            <?php $_SESSION['storageResult'] = ''; ?>
            <?php $_SESSION['storageMessage'] = ''; ?>
            <div class="row">
                <div class="panel noAadCredentialsPanel col-lg-12">
                    <div class="panel-heading">
                        <h4><span class="pull-right"><button id="addAAD"style="margin-top: 5px;" class="btn btn-success btn-small" data-toggle="modal" data-target="#addAad">Add Credentials</button></span></h4>
                    </div>
                    <div>
                        <h2 align="center">There are no AAD Credentials Saved</h2>
                    </div>
		</div>
                <div class="panel aadCredentialsPanel col-lg-12">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('azureActiveDirectoryCredentials', 'keywords')?><span class="pull-right"><a id="editAAD" style="margin-top: 5px;" class="btn btn-success btn-small" ng-click="editAadCredentials()">Edit Credentials</a></span></h4>
		    </div>
		    <?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
                    <div class="panel-body">
			<form class="aadConfiguration" ng-submit="saveAadConfiguration()" data-parsley-validate>
<div class="row">
				<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off" readonly>
                                </div>
				<?php } ?>
                                <div class="form-group col-lg-6">
                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your client Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 tenentId">
                                        <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenentId" id="tenentId" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 redirectURI">
                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 portalRedirectURI">
                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                    <input type="text" class="form-control" name="loginMode" id="loginMode" value="" placeholder="Enter Login Mode" autocomplete="off" readonly>
                                </div>
                                <div class="col-lg-6">
                                    <label for="groupConfigurations"><?=Language::show('groupConfigurations', 'keywords')?></label></br>
                                    <table id="myTableShow" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Product Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="(key,value) in aad">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-if="key == '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                            <option value="BACKUP" ng-selected="value == 'BACKUP'">Backup</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                            <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                            <option value="O365" ng-selected="value == 'O365'">Office365</option>
                                                        <?php } ?>
                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>                                
                                <!--<button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right aadSave">Save</button>-->
                                <!--<div>
                                    <a href="javascript:;" class="btn btn-default" ng-click="gotTo('/settings/importUsersAAD')"><i class="fa fa-user-plus"> Import Users from AAD</i></a>
				</div>-->
</div>
                        </form>
                    </div>
		</div>
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
		<div class="panel-body">
			<form class="aadConfiguration" ng-submit="saveAadConfiguration()" data-parsley-validate>
<div class="row">
                                <div class="form-group col-lg-6">
                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your client Id" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off" readonly>
                                </div>                                
                                <div class="form-group col-lg-6">
                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 redirectURI">
                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 portalRedirectURI">
                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                    <input type="text" class="form-control" name="loginMode" id="loginMode" value="" placeholder="Enter Login Mode" autocomplete="off" readonly>
                                </div>
<!--tenants start-->
<div class="col-lg-6">
                                    <label for="tenants"><?=Language::show('Tenant Configuration', 'keywords')?></label></br>
                                    <table id="myTableShowTenants" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Tenant Id</th>
                                                <th>Admin Consent</th>
                                            </tr>
                                        </thead>
					<tbody>
                                            <tr ng-if="tenants.length <= 0">
                                            	<td>Not configured</td><td>NA</td>
                                            </tr>
                                            <tr ng-repeat="value in tenants" ng-if="tenants.length > 0">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="tenants" id="tenants{{$index}}" value="{{value}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>                                                
						<td ng-cloak style="white-space:unset !important;">
						<?php
							$tenentId = '';
							$clientId = $data['data']->{'clientId'};
							$user_principal = $data['data']->{'user_principal'};
							//$redirectURI = $data["clientRedirectURI"];
							if(useLocalPackage != true){
								$redirectURI = "https://api-app.parablu.com/adminConsentMultiTenant.php";
								$appURL = "https://api-app.parablu.com/callConsent.php";
							}else{
								$redirectURI = LOCAL_IP."/app/adminConsentMultiTenant.php";
								$appURL = LOCAL_IP."/app/callConsent.php";
							}
							$params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
							//$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							$ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							$aa = $appURL.$params."&tenentId=";
							$bb = "&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
							?>
						<!--<a href="javascript:;" class="btn btn-default" ng-click="redirectTo(<?=$appURL.$params?>'&tenantId={{value}}&scope='<?=AZURE_SCOPE?>'&sourceURI='<?=\Helpers\Url::basePath();?>)"><i class="fa fa-windows"></i> Grant Admin Consent</a>-->
						<a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$aa?>{{value}}<?=$bb?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
<!--tenants ends-->                                                                
                                <div class="col-lg-6">
                                    <label for="groupConfigurations"><?=Language::show('groupConfigurations', 'keywords')?></label></br>
                                    <table id="myTableShow" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Product Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="(key,value) in aad">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-if="key == '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                            <option value="BACKUP" ng-selected="value == 'BACKUP'">Backup</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                            <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                        <?php } ?>
                                                        <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                            <option value="O365" ng-selected="value == 'O365'">Office365</option>
                                                        <?php } ?>
                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>                                
                                <!--<button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right aadSave">Save</button>-->
                                <!--<div>
                                    <a href="javascript:;" class="btn btn-default" ng-click="gotTo('/settings/importUsersAAD')"><i class="fa fa-user-plus"> Import Users from AAD</i></a>
				</div>-->
</div>
                        </form>
                    </div>
                </div>
<?php } ?>
                <!--start add-->
                <div class="modal fade" id="addAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration()',
                                        'class' => 'aadAadCredentials',
                                        'id' => 'aadAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
					<div class="modal-header">
                                            <h4 class="modal-title"><?=Language::show('addYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        </div>
					<div class="modal-body">
<?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
                                            <div class="row">
						<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLoginadd" id="clientIdForLogin2" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
						<?php } ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdadd" id="clientId2" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKeyadd" id="secretKey2" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentIdadd" id="tenentId2" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURIadd" id="endpointRedirectURI2" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURIadd" id="redirectURI2" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURIaad" id="portalRedirectURI2" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode2" id="loginMode2" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                         <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
					    </div>
                                            <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableAdd" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">Backup</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                                        <option value="O365">Office365</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('office365')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('office365'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" id="removeAdd{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
					    </div>
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
<div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdadd" id="clientId2" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKeyadd" id="secretKey2" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURIadd" id="endpointRedirectURI2" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURIadd" id="redirectURI2" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURIaad" id="portalRedirectURI2" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode2" id="loginMode2" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                         <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
                                            </div>
					    <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('Tenant Configuration', 'keywords')?><span class="pull-right"><a onclick="addDynamicAddTenant()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Tenant Id</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableAddTenant" class="myTableAddTenant table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Tenant Id</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadTenant[]" id="aadTenant" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>                                                            
                                                            <td>
                                                                <a onclick="RemoveAddTenant(this)" id="tenantAddRemove{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
					    </div>
					    <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableAdd" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP">Backup</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                                        <option value="O365">Office365</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('office365')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('office365'))){ ?>
                                                                        <option value="BOTH">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" id="removeAdd{{$index}}" class="btn btn-small btn-danger clickAble disabled"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
<?php } ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success addCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end add -->
                <!--start-->
                <div class="modal fade" id="editAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration1()',
                                        'class' => 'editAadCredentials',
                                        'id' => 'editAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
					<div class="modal-header">
<h4 class="modal-title"><?=Language::show('editYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        </div>
					<div class="modal-body">
<?php if($data['multiTenantAADEnabled'] == 'false'){ ?>
                                            <div class="row">
						<?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin1" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
						<?php } ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientId" id="clientId1" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKey" id="secretKey1" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentId" id="tenentId1" value="" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI1" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI1" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI1" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div> 
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode1" id="loginMode1" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                         <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTable" class="myTable table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="(key,value) in aad" class="first">
                                                            <td ng-if="key != '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-if="key == '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductType[]" id="aadProductType{{$index}}" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP" ng-selected="value == 'BACKUP'">Backup</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                                        <option value="O365" ng-selected="value == 'O365'">Office365</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('office365')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('office365'))){ ?>
                                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="Remove(this)" id="remove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
					    </div>
<?php } ?>
<?php if($data['multiTenantAADEnabled'] == 'true'){ ?>
<div class="row">                                                
                                                <div class="form-group col-lg-6">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientId" id="clientId1" value="" placeholder="Enter your client Id" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKey" id="secretKey1" value="" placeholder="Enter your Azure Active Directory secret key" autocomplete="off">
                                                </div>                                                
                                                <div class="form-group col-lg-6 endpointRedirectURI">
                                                    <label for="endpointRedirectURI"><?=Language::show('endpointRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="endpointRedirectURI" id="endpointRedirectURI1" value="" placeholder="Enter your Azure Active Directory Endpoint Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI1" value="" placeholder="Enter your Azure Active Directory Redirect URI" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 portalRedirectURI">
                                                    <label for="portalRedirectURI"><?=Language::show('portalRedirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="portalRedirectURI" id="portalRedirectURI1" value="" placeholder="Enter your Azure Active Directory Portal Redirect URI" autocomplete="off">
                                                </div> 
                                                <div class="form-group col-lg-6">
                                                    <label for="loginMode"><?=Language::show('Authentication Mode', 'keywords')?></label>
                                                    <select class="form-control loginMode selectpicker" name="loginMode1" id="loginMode1" title="Select Login Mode" required="required" >
                                                         <option value="Microsoft"><?=Language::show('Microsoft', 'keywords')?></option>
							 <?php if($data['graphAADEnabled'] == 'false'){ ?>
                                                         <option value="Okta"><?=Language::show('Okta', 'keywords')?></option>
							 <?php } ?>
                                                     </select>
                                                </div>
                                            </div>
                                            <!--tenants start-->
                                            <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                	<h4><?=Language::show('Tenant Configuration', 'keywords')?><span class="pull-right"><a onclick="dynamicAddTenant()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Tenant Id</a></span></h4>
                                            	  </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTableTenantEdit" class="myTableTenantEdit table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Tenant Id</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="value in tenants" class="first" ng-if="tenants.length > 0">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="tenantEdit[]" id="tenantEdit{{$index}}" value="{{value}}" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveTenantEdit(this)" id="tenantEditRemove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
							</tr>
							<tr class="first" ng-if="tenants.length <= 0">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="tenantEdit[]" id="tenantEdit0" value="{{value}}" placeholder="Enter your Azure Active Directory Tenant Id" autocomplete="off">
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveTenantEdit(this)" id="tenantEditRemove0" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
					    </div>
					    </div>
                                            <!--tenants ends-->
                                            <div class="row">
                                                <div class="panel-heading col-lg-12">
                                                	<h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            	  </div>
                                                <div class="panel-body col-lg-12">
                                                <table id="myTable" class="myTable table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="(key,value) in aad" class="first">
                                                            <td ng-if="key != '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-if="key == '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductType[]" id="aadProductType{{$index}}" required>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                                        <option value="BACKUP" ng-selected="value == 'BACKUP'">Backup</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                                        <option value="SYNC" ng-selected="value == 'SYNC'">BluSync</option>
                                                                    <?php } ?>
                                                                    <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                                        <option value="O365" ng-selected="value == 'O365'">Office365</option>
                                                                    <?php } ?>
                                                                    <?php if((\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')) || (\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('office365')) || (\Helpers\Auth::checkCloudPermission('sync') && \Helpers\Auth::checkCloudPermission('office365'))){ ?>
                                                                        <option value="BOTH" ng-selected="value == 'BOTH'">All</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="Remove(this)" id="remove{{$index}}" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
<?php } ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success editCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end-->
	    </div>
		<!--grant start-->
		<?php //if($data['tokenMapped'] == "false") { ?>
		<?php if($data['graphAADEnabled'] == 'true' && $data['multiTenantAADEnabled'] == 'false'){ ?>
			<div class="panel col-lg-12">
				<div class="panel-heading"><h4>For Admin Consent</h4></div>
				 <div class="panel-body">
					<?php
						$tenentId = $data['data']->{'tenentId'};
						$clientId = $data['data']->{'clientId'};
						$user_principal = $data['data']->{'user_principal'};
						//$redirectURI = $data["clientRedirectURI"];
						if(useLocalPackage != true){
							$redirectURI = "https://api-app.parablu.com/adminConsentMultiTenant.php";
							$appURL = "https://api-app.parablu.com/callConsent.php";
						}else{
							$redirectURI = LOCAL_IP."/app/adminConsentMultiTenant.php";
							$appURL = LOCAL_IP."/app/callConsent.php";
						}
						$params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
						//$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
						$ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
					?>
					<p>
					       <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
					</p>
				</div>
			</div>
		<?php } ?>
		<?php //} ?>
		<!--grant ends-->
<?php if($data['graphAADEnabled'] == 'false'){ ?>
            <div class="row storageMappingButton">
                <?php if($data['data']->{'authRequired'} != false) {?>
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h4>Azure Active Directory Mapping</h4>
                    </div>
                    <div class="panel-body">
                        <div class="form-group col-lg-12">
                            <div class="well well-lg">
                                <?php
                                $tenentId = $data['data']->{'tenentId'};
                                $clientId = $data['data']->{'clientId'};
                                $user_principal = $data['data']->{'user_principal'};
                                //$redirectURI = $data['data']->{'redirectURI'};
                                if(useLocalPackage != true){
                                    $redirectURI = "https://api-app.parablu.com/aad.php";
                                    $appURL = "https://api-app.parablu.com/call1.php";
                                }else{
                                    $redirectURI = LOCAL_IP."/app/aad.php";
                                    $appURL = LOCAL_IP."/app/call1.php";
                                }
                                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal".$user_principal;
                                    //$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                                    $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                                ?>
                                <p>
                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Map Azure Active Directory</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
<?php } ?>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>

<script>

function dynamicAdd(){
    var trlength= $('#myTable tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTable tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductType[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupName[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'remove' + trlength); 
    lasttr.find('a').attr("onclick", "Remove(this);");               
    i++;    
    $('#myTable tbody').append(lasttr);
    $("[id*='remove']").removeClass('disabled');
}

function Remove(button) {
        //new
        var trlength= $('#myTable tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTable");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTable tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='remove']").addClass('disabled');
    }
        }else{
         $("[id*='remove']").addClass('disabled');
        }
    //}
};

function addDynamicAdd(){
    var trlength= $('#myTableAdd tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableAdd tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductTypeadd[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupNameadd[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'removeAdd' + trlength); 
    lasttr.find('a').attr("onclick", "RemoveAdd(this);");               
    i++;    
    $('#myTableAdd tbody').append(lasttr);
    trlength= $('#myTableAdd tbody tr').length;
    i = trlength;
    if(i > 1){
    $("[id*='removeAdd']").removeClass('disabled');
    }
}

function RemoveAdd(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAdd");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableAdd tbody tr').length;
    i = trlength;
    if(i == 1){
    $("[id*='removeAdd']").addClass('disabled');
    }
    //}
};

function dynamicAddTenant(){
    var trlength= $('#myTableTenantEdit tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableTenantEdit tbody tr:last').clone();
    lasttr.find('input').attr('id', 'tenantEdit' + trlength);
    lasttr.find('input').attr('name', 'tenantEdit[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'tenantEditRemove' + trlength);
    lasttr.find('a').attr("onclick", "RemoveTenantEdit(this);");
    i++;
    $('#myTableTenantEdit tbody').append(lasttr);
    $("[id*='tenantEditRemove']").removeClass('disabled');
}

function RemoveTenantEdit(button) {
        //new
        var trlength= $('#myTableTenantEdit tbody tr').length;
        var i = trlength;
        if(i > 1){
        //new
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableTenantEdit");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableTenantEdit tbody tr').length;
    i = trlength;
    if(i == 1){
        $("[id*='tenantEditRemove']").addClass('disabled');
    }
        }else{
         $("[id*='tenantEditRemove']").addClass('disabled');
        }
    //}
};


function addDynamicAddTenant(){
    var trlength= $('#myTableAddTenant tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableAddTenant tbody tr:last').clone();
    lasttr.find('input').attr('id', 'aadTenant' + trlength);
    lasttr.find('input').attr('name', 'aadTenant[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'tenantAddRemove' + trlength);
    lasttr.find('a').attr("onclick", "RemoveAdd(this);");
    i++;
    $('#myTableAddTenant tbody').append(lasttr);
    trlength= $('#myTableAddTenant tbody tr').length;
    i = trlength;
    if(i > 1){
    $("[id*='tenantAddRemove']").removeClass('disabled');
    }
}

function RemoveAddTenant(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAddTenant");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    trlength= $('#myTableAddTenant tbody tr').length;
    i = trlength;
    if(i == 1){
    $("[id*='tenantAddRemove']").addClass('disabled');
    }
    //}
};

</script>
