<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/policies')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton')?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel" block-ui="myBlockUI">
                <div class="panel-heading">
                    <h4><?=Language::show('edit_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                    <span class="d-none currentPage"><?='editPolicy'?></span>
                    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
			'id' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreateEdit()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" value="{{ selectedPolicy.policygroupName }}" required autocomplete="off" readonly>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                      <li class="nav-item d-none" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#search" aria-expanded="false" aria-controls="advanced">Search</a></li>
<?php } ?>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                        <!--<li class="shareDetailsTab" role="presentation"><a data-target="#shareDetails" aria-controls="advanced" role="tab" data-toggle="tab">Secure Sharing</a></li>-->
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                        <li class="nav-item d-none" role="presentation"><a href="" class="nav-link" data-target="#search" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?><?php  if(PORTAL_LIGHT_VERSION == false){ ?> - <a href="" class="clickAble" ng-click="addNewSchedule()" style="font-size: small;font-weight: 600;">Create New Schedule</a><?php } ?></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['sch1'])){ ?>
                                                <?php foreach($data['sch1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                            <td>
                                                                <!--<a class="btn btn-default btn-small" ng-click="getParticularSchedule(value.scheduleName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="getParticularSchedule(value.scheduleName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxFileVersions == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchver" type="checkbox" <?php if(maxFileVersions == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxFileVersions == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(maxPermissibleFileSize == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox" <?php if(maxPermissibleFileSize == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(maxPermissibleFileSize == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>d-none<?php } ?>">
					<label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
<div class="row">
                                        <div class="col-lg-2" <?php if(userStorageQuta == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox" <?php if(userStorageQuta == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input <?php if(userStorageQuta == false){ ?> style="pointer-events:none;background-color:gainsboro;"<?php }?>type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                            <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" min="1" onfocusout="myFunctionDevice();"/>
                                        <span id="deviceerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div   class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This field is non-editable in Lite Version">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type' disabled>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div><?php } else {?>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osTypee" required="" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                    		<button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default" style="padding-bottom: 10px;" type="button">Add</button>
                                	    </span>
                                        </div>
                                    </div>
				    <!-- sql start-->
				    <?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
				    <div class="form-group">
                                        <label for="sqlBackupFolders"><?=Language::show('defaultFoldersBackup', 'keywords');?> for MS SQL</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="sqlBackupFolders" name="sqlBackupFolders" id="sqlBackupFolders" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?> for SQL" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                        	<button ng-click="addDefaultFolderSQL(sqlBackupFolders)" class="btn btn-default sqlBackupFoldersBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    	    </span>
                                        </div>
                                    </div>
				    <?php } ?>
				    <!--sql end-->
                                    <div class="form-group">
                                        <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName" placeholder="Enter the full path of the folder" autocomplete="off"
                                                data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default">Add</button>
                                            </span>
                                        </div >
                                    </div>
                                    <!--start-->
                                    <div>
                                        <div class="form-group col-lg-12">
                                            <label for="exceptionFolderName"><?=Language::show('Exceptions to exclusions', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" ng-model="exceptionFolderName" name="exceptionFolderName" id="exceptionFolderName" placeholder="Enter the full path of the folder" autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="<?=Language::show('exclusionError', 'keywords')?>"/>
                                                <span class="input-group-btn">
                                                    <button type="button" ng-click="addExceptionFolder(exceptionFolderName)" class="btn btn-default exceptionFoldersBtn">Add</button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end-->
                                    <div class="form-group d-none">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="clientDedup"><?=Language::show('Client Dedup', 'keywords');?></label>
                                        <select class="form-control clientDedup" name="clientDedup" id="clientDedup" title='Select <?=Language::show('clientDedup', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="maxFileSizeForBkpBatch"><?=Language::show('Maximun File Size For Backup Batch', 'keywords');?></label>
                                        <input type="text" class="form-control" name="maxFileSizeForBkpBatch" id="maxFileSizeForBkpBatch" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSizeForBkpBatch', 'keywords');?>" autocomplete="off" value="50" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="overflow-y: scroll;height: 450px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFolders.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFolders track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
						<?php if($data['isSQLBkpEnabled'] == 'true'){ ?>
						<div class="form-group hide" style="margin-left:10px;">
                                                    <div class="checkbox check-primary">
                                                        <input id="sqlbkpEnabled" name="sqlbkpEnabled" type="checkbox" value="enabled">
                                                        <label for="sqlbkpEnabled"><?=Language::show('Backup SQL Database', 'keywords');?></label>
                                                    </div>
						</div>
						<!--SQl start-->
						<div class="panel panel-default" style="overflow-y: scroll;height: 150px;">
							<div class="panel-heading">
								<h5> <i class="fa fa-folder-open"></i> Default MS SQL Folders</h5>
						       </div>
							<div class="panel-body">
								<div class="table-responsive">
									<div  ng-if="osType == 'universal'">
										<ul class="list-group" ng-if="sqlBackupFoldersList.length >= 1">
											<li style="word-wrap: break-word" ng-repeat="value in sqlBackupFoldersList track by $index" class="list-group-item">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeDefaultFolderSQL($index)"><i class="fa fa-times-circle-o"></i></a></li>
										</ul>
										<span ng-if="sqlBackupFoldersList.length <= 0">There are no default folders for SQL to backup</span>
									</div>
								</div>
							</div>
						</div>
						<!--SQL ends-->
						<?php } ?>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindows.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMac.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversal.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <!--start-->
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Exceptions to exclusions </h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersWindows.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersWindows track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersWindows.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersMac.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersMac track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersMac.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExceptionsFoldersUniversal.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExceptionsFoldersUniversal track by $index">{{ value }} <a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeExceptionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExceptionsFoldersUniversal.length <= 0">These folders will be Exceptions to exclusions</span>
                                                    </div>
                                                </div>
                                                <!--end-->
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectFilterTypePicker" name="filtersType" id="filtersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-2 inclusionBadge"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-2 exclusionBadge" style="display:none;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <!--<select class="form-control selectFilterPicker inc" ng-model="filters" name="filters[]" id="filters" title='Select Filters' multiple>
                                            <?php //if(!empty($data['IncFilters'])){ ?>
                                                <?php //foreach($data['IncFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                            <?php //} ?>
                                        </select>
                                        <select class="form-control selectFilterPicker exc" ng-model="filters" name="filters[]" id="filters1" title='Select Filters' multiple>
                                           <?php //if(!empty($data['ExcFilters'])){ ?>
                                                <?php //foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                        <?php //} ?>
                                        </select>-->
                                        <select class="col-lg-10 selectFilterPicker" name="filters[]" id="filters" required="" title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:unset !important;">
                                                                <!--<a class="btn btn-default btn-small pull-right" ng-click="newFilterEdit(defaultFilter.filterName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control userCreateAdmins" name="createUser[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdmins" name="deviceDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadmins" name="deviceDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsers" name="deviceDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdmins" name="deviceBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadmins" name="deviceBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsers" name="deviceBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdmins" name="deviceDecoupled[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadmins" name="deviceDecoupled[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsers" name="deviceDecoupled[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control deviceLimitReachedAdmins" name="deviceLimitReached[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadmins" name="deviceLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsers" name="deviceLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdmins" name="weeklyBkpreport[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadmins" name="weeklyBkpreport[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsers" name="weeklyBkpreport[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdmins" name="firstBkpCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadmins" name="firstBkpCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsers" name="firstBkpCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdmins" name="restoreInitiated[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadmins" name="restoreInitiated[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsers" name="restoreInitiated[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
				    
				<div class="col-lg-6 d-none">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreCompletedAdmins" name="restoreCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control restoreCompletedReadonlyadmins" name="restoreCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore completed', 'keywords');?></label>
                                        <select class="form-control restoreCompletedUsers" name="restoreCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdmins" name="storageLimitReached[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadmins" name="storageLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsers" name="storageLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <select class="form-control initiatebackup" name="initiatebackup" id="initiatebackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <select class="form-control stopbackup" name="stopbackup" id="stopbackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="about"><?=Language::show('ABOUT', 'keywords');?></label>
                                        <select class="form-control about" name="about" id="about" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                   <div class="form-group">
                                        <label for="systrayIcon"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIcon" name="systrayIcon" id="systrayIcon" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="pauseBackup"><?=Language::show('PAUSE_BACKUP', 'keywords');?></label>
                                        <select class="form-control pauseBackup" name="pauseBackup" id="pauseBackup" required="" title='Select <?=Language::show('pauseBackup', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>				    
				    <div class="form-group hide">
                                        <label for="disallowAdminRestores"><?=Language::show('Disallow Admin Restores', 'keywords');?></label>
                                        <select class="form-control disallowAdminRestores" name="disallowAdminRestores" id="disallowAdminRestores" required="" title='Select <?=Language::show('Disallow Admin Restores', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 row">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share hide">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestore">
                                            <label for="portalRestore"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestore" name="portalRestore" id="portalRestore" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabel hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
			   	    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabled" name="shareDomainsEnabled" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabled"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                        </div>
					<div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusions"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusions" id="shareDomainIncExclusions" placeholder="" autocomplete="off" value="" />
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainType" id="only" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainType" id="withall" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains excepting these', 'keywords');?></label>
							</div>
						</div>
					</div>
				    </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlock">
                                        	<label class="switch">
                                        		<input id="controllerSL" type="checkbox" name="controllerSL" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;">Allow sharer visibility to the shared link</span>

				    </div>
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">
							<div class="col-lg-2 controllerCPBlock">
								<label class="switch">
									<input id="controllerCP" type="checkbox" name="controllerCP" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>							
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlock">
								<label class="switch">
									<input id="controllerMFA" type="checkbox" name="controllerMFA" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				   </div>                                    
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectSearchFilterTypePicker" name="searchFilterType" id="searchfiltersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
                                            <!--<select class="form-control selectSearchFilterPicker incSearch" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple>
                                            <?php if(!empty($data['IncFilters'])){ ?>
                                                <?php foreach($data['IncFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                            </select>
                                            <select class="form-control selectSearchFilterPicker excSearch" name="searchfilters[]" id="searchfilters1" title='Select Filters' multiple>
                                           <?php if(!empty($data['ExcFilters'])){ ?>
                                                <?php foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>-->
					<select class="form-control selectSearchFilterPicker" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple <?php if($data['searchEnabled'] == true){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td>
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4 d-none" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group d-none" <?php if(partialFileTransfer == false){ ?>  class="form-group toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version" <?php } ?>>
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>' <?php if(partialFileTransfer == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                        <div class="col-lg-2" <?php if(networkThrotlling == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switch" type="checkbox" <?php if(networkThrotlling == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromClientToPG }}" onfocusout="myFunction();" disabled/>
                                        <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>-->
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8" <?php if(networkThrotlling == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label class="switch">
                                            <input id="switch" type="checkbox" <?php if(networkThrotlling == false){ ?> disabled <?php }?>>
                                            <div class="slider round"></div>
					</label></div>
<div class="row">
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              <span id="switchwarning" style="color: #f27331;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
					      </div>
</div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="cpuThrottling"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="slidecontainer">
                                              <input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRange">
                                              <p>Value: <span id="demo"></span></p>
                                            </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5 d-none">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group" <?php if(legalHold == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <div class="checkbox check-primary">
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled"  <?php if(legalHold == false){ ?> disabled <?php }?>>
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span class="systemFolders" style="display: none;">
                                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                                </span>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
				    <label class="col-lg-12" style="margin-left: -30px;" for="noOfDaysToKeepDeviceNotHeard"><?=Language::show('Block devices which have not been heard from in', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchnoOfDaysToKeepDeviceNotHeard" type="checkbox" checked>
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-4">
                                            <input type="text" class="form-control" name="noOfDaysToKeepDeviceNotHeard" id="noOfDaysToKeepDeviceNotHeard" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('No. of Days To Keep Device Not Heard', 'keywords');?>" required autocomplete="off" value="60" onfocusout="myFunctionnoOfDaysToKeepDeviceNotHeard();"/>
                                            <span id="noOfDaysToKeepDeviceNotHearderror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
					<div class="col-lg-2" style="margin-top: 10px;"><label>days</label></div>
</div>
                                    </div>
				    <div class="form-group d-none">
                                        <label for="numberOfThreadsAllowedForBackup"><?=Language::show('Number of threads allowed for Backup', 'keywords');?></label>
                                        <input type="number" class="form-control" name="numberOfThreadsAllowedForBackup" id="numberOfThreadsAllowedForBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Number of threads allowed for Backup', 'keywords');?>" required autocomplete="off" value="" min="1" max="5"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestore"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminRestore" id="canAdminRestore" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>' onclick="flipAllowEndUserTocontrolRestore()">
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" style="margin-left:30px;<?php if($data['overridePolicySettings'] == true){?>pointer-events:none;opacity: 0.4;<?php } ?>">
                                        <label for="allowEndUserTocontrolRestore"><?=Language::show('Allow end-user over-ride', 'keywords');?></label>
                                        <select class="form-control allowEndUserTocontrolRestore <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="allowEndUserTocontrolRestore" id="allowEndUserTocontrolRestore" required="" title='Select option'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"> <?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['overridePolicySettings'] == true){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDelete"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDelete <?php if($data["overridePolicySettings"] == true){?> hide <?php } ?>" name="canAdminDelete" id="canAdminDelete" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>' <?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group d-none">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'<?php if(PORTAL_LIGHT_VERSION == true){ ?> disabled <?php }?>>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group d-none">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>' <?php if(enableCompression == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer d-none" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'<?php if(backupFilesInUse == false){ ?> disabled <?php }?>>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg" <?php if(blukryptSearch == false){ ?> class="toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Field cannot be edited in Lite Version"<?php }?>>
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>' <?php if(blukryptSearch == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(PORTAL_LIGHT_VERSION == true){ ?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" style="background-color:#dcdcdc;" id="Blukryptipaddress" readonly />
                                    </div>
                                    <?php } else {?>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <?php if(!empty($data['pgs'])){ ?>
                                            <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                <?php foreach($data['pgs'] as $key => $value){ ?>
                                                    <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                <?php } ?>
                                            </select>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                    <div class="form-group" <?php if(policyRefresh == false){ ?> class="col-lg-2 toolTip" data-toggle="tooltip" data-trigger="hover" data-placement="bottom" title="This Feature is Disabled in Lite Version"<?php }?>>
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" required="" <?php if(policyRefresh == false){ ?> style="pointer-events:none;background-color:gainsboro;" <?php }?>>
                                    </div>
                                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
<div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="switchAgentPassword" style="margin-left:-14px;"><?=Language::show('Agent uninstallation password', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAgentPassword" name="switchAgentPassword" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentPassword" style="margin-left:-14px;"><?=Language::show('password', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentPassword" id="agentPassword" value="" placeholder="Enter Password" autocomplete="off" readonly>
                                                <span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="agentRePassword" style="margin-left:-14px;"><?=Language::show('rePassword', 'keywords');?></label>
                                                <input type="password" class="form-control" name="agentRePassword" id="agentRePassword" placeholder="Re-Type Password" autocomplete="off" value="" data-parsley-equalto="#agentPassword" data-parsley-trigger="change" readonly/>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group">
                                       <label for="canBackupHiddenFiles"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFiles" name="canBackupHiddenFiles" id="canBackupHiddenFiles" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div style="padding-left:3%;" class="form-group row d-none">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithm" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div class="form-group">
					 <span class="row" style="margin-left: 0px;"><p>Purge deleted files from the catalog after</p></span>
<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchnoOfDaysToKeepDeletedFiles" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="noOfDaysToKeepDeletedFiles" id="noOfDaysToKeepDeletedFiles"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionnoOfDaysToKeepDeletedFiles();" disabled/>
                                             <span id="sizenoOfDaysToKeepDeletedFiles" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
					 </div>
</div>
					   <div class="form-group <?php if($data['showUserConsentFieldInPolicies'] != true){?>hide<?php } ?>">
                                         <span class="row" style="margin-left: 0px;"><p>User Consent Display Text</p></span>
<div class="row" style="margin-left: 0px;">
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchuserConsentEnabled" name="userConsentEnabled" value="true" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-10">
                                             <!--<input type="text" class="form-control" name="userConsentDisplayText" id="userConsentDisplayText" autocomptocomplete="off" value="" onfocusout="checkTextLength()"/>-->
						 <textarea style="width:100%" class="userConsentDisplayText" name="userConsentDisplayText" id="userConsentDisplayText" placeholder="Enter User Consent Display Text" data-parsley-trigger="change" rows="3" onfocusout="checkTextLength()"></textarea>
					     <span id="texterror" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
</div>
</div>   
                                     </div>
				    <div class="row">
					    <div class="col-lg-4">
						<label for="preScanCommandEnabled">Enable Pre Scan Command</label><br>
						<label class="switch">
						<input id="preScanCommandEnabled" name="preScanCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="preScanCommand"><?=Language::show('Pre Scan Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preScanCommand" id="preScanCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
					    	<div class="form-group">
					    	    <label for="legalHold">Continue backup on command-failure</label>
						    <input id="continueOnPreScan" name="continueOnPreScan" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
				    <div class="row">
				    	<div class="col-lg-4">
						<label for="preBackupCommandEnabled">Enable Pre Backup Command</label><br>
						<label class="switch">
						<input id="preBackupCommandEnabled" name="preBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					</div>
					<div class="col-lg-5 form-group">
						<label for="preBackupCommand"><?=Language::show('Pre Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="preBackupCommand" id="preBackupCommand" placeholder="" autocomplete="off" value="">
					</div>
					<div class="col-lg-3">
						<div class="form-group">
							<label for="legalHold">Continue backup on command-failure</label>
							<input id="continueOnPreBkp" name="continueOnPreBkp" type="checkbox" value="enabled">
							</div>
					    </div>
					</div>
					<div class="row">
					    <div class="col-lg-4">
						<label for="postBackupCommandEnabled">Enable Post Backup Command</label><br>
						<label class="switch">
						<input id="postBackupCommandEnabled" name="postBackupCommandEnabled" type="checkbox">
						<div class="slider round"></div>
						</label>
					    </div>
					    <div class="col-lg-5 form-group">
						<label for="postBackupCommand"><?=Language::show('Post Backup Command Path', 'keywords');?></label>
						<input type="text" class="form-control" name="postBackupCommand" id="postBackupCommand" placeholder="" autocomplete="off" value="">
					    </div>
					    <div class="col-lg-3">
						<div class="form-group">
					    	<label for="legalHold">Continue backup on command-failure</label>
						<input id="continueOnPostBkp" name="continueOnPostBkp" type="checkbox" value="enabled">
						</div>
					    </div>
				    </div>
                                    <div class="form-group d-none">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
			    <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Grayed out options are currently controlled in Cloud Properties. Please speak to you Administrator or visit the Cloud Properties page to change their behavior.
                                        <br/>Both password enforcement options cannot be disabled at same time.
                                    </p>
                                </div>
                            </div>
			    </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">
                            <!--<button id="save" type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>-->
                            <a ng-bootbox-confirm="<h4><?=Language::show('Will be effective on next policy refresh, for immediate effect manually refresh policy.', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreateEdit()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/policies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleCreateForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <h4 id="addSchedule_title" class="modal-title">Create Schedule</h4>
		    <h4 id="editSchedule_title" class="modal-title" style="display: none;">Edit Schedule</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked d-none" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general1" aria-expanded="true" aria-controls="general">General</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced1" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs d-none" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="active"><a data-target="#general1" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced1" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general1">
				            <br>
                            <div class="form-group">
                                <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                                <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                            </div>
                            <div class="form-group d-none">
                                <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                                <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group">
                                <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                            </div>
                            <div class="form-group">
                                <label for="days"><?=Language::show('days', 'keywords');?></label>
                                <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                                <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                                    <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                    <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                    <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                    <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                    <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                    <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                    <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                                </select>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced1">
                                </br>
                                <div class="form-group backupTypeForm">
                                    <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                    <select class="form-control backupType" name="backupType" id="backupType" required>
                                        <option value="FULL">Full</option>
                                        <option value="INCR" selected>Incremental</option>
                                    </select>
                                </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="addSchedule_save">Save changes</button>
                    <a class="btn btn-primary pull-right" id="editSchedule_save" ng-click="scheduleSavePolicy()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirmAdd" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addDefaultFolderConfirm(defaultFoldersBackup)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
    </div>
            <div class="modal fade" id="confirmAdd1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addExclusionFolderConfirm(exclusionFolderName)">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--start-->
            <div class="modal fade" id="confirmAdd2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                            <div class="modal-dialog" role="document">
                                <form class="" ng-submit="addExceptionFolderConfirm(exceptionFolderName)">
                                    <div class="modal-content smallModal">
                                        <div class="modal-header">
					    <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Are you sure, you want to add the folder path</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            <button type="submit" class="saveRename btn btn-success">Save</button>
                                            </div>
                                    </div>
                                </form>
                            </div>
            </div>
            <!--end-->
    <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <h4 id="add_title" class="modal-title">Create Filter</h4>
		    <h4 id="edit_title" class="modal-title" style="display: none;">Edit Filter</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                    </div>
                    <div class="form-group d-none">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filterTemplate"><?=Language::show('Select Filter Template', 'keywords')?></label>
                        <select class="form-control selectFilterTemplatePickerPolicy" name="filterTemplate[]" id="selectFilterTemplatePickerPolicy" title='Select Filters template' multiple>
                                            <?php if(!empty($data['filCanned'])){ ?>
                                                <?php foreach($data['filCanned'] as $key => $value){ ?>
                                                    <?php $label = $value;
                                                                if( strlen( $value ) > 50 ) {
                                                                   $label = substr( $label, 0, 50 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        <br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="add_save" class="btn btn-primary pull-right">Save changes</button>
                    <a class="btn btn-primary pull-right" id="edit_save" ng-click="filterSavePolicy()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectFilterTemplatePickerPolicy').selectpicker('render');
    $('.filterType').selectpicker('render');
    $('.compEnabled').selectpicker('render');
    $('.selectSchedulePicker').selectpicker('render');
    $('.selectSearchFilterPicker').selectpicker('render');
    $('.vssEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render').on('change', function(){
        if($('.selectOsTypePicker').val() == 'windows'){
            $('.vssContainer').show();
        }else if($('.selectOsTypePicker').val() == 'universal'){
                $('.vssContainer').show();
        }
        else{
            $('.vssContainer').hide();
        }
    });
    $('.selectOsTypePicker').selectpicker('render');
    $('.dedup').selectpicker('render');
    $('.fullBackupEnabled').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render')
        .on("change", function(event){
            if($('.incrementalFileTransfer').val() == 'false'){
                $('.partialfileattributerow').addClass('d-none');
                $('#partialFileSize').attr('disabled', 'disabled');
                $('#fileChunkableSize').attr('disabled', 'disabled');
            }else{
                $('.partialfileattributerow').removeClass('d-none');
                $('#partialFileSize').removeAttr('disabled', 'disabled');
                $('#fileChunkableSize').removeAttr('disabled', 'disabled');
            }
        });
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false
    });
    $('.backupDatePicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#fullBackupEnabled').on('change', function(){
        var option = $('#fullBackupEnabled').val();
        if(option == 'true'){
            $('.backupDate').show();
        $('[name="fullBackupStartDate"').attr('required', 'required');
        }else{
            $('.backupDate').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
            $('#Blukryptipaddress').attr('required', 'required');
        }else{
            $('#Blukryptipaddress').removeAttr('required', 'required');
        }
    });
    $('.Share').on('change', function(){
        if($('#Share').val() == 'true'){
            $('.shareDetailsLabel').show();
            $('.highSecuredShareOptions').show();
            $('.highSecureShareEnabled').show();
        }else{
            $('.shareDetailsLabel').hide();
            $('.highSecuredShareOptions').hide();
            $('.highSecureShareEnabled').hide();
        }
    });
    $('#highSecureShareEnabled').on('change', function(){
        var checked = document.getElementById('highSecureShareEnabled').checked;
        if(checked){
            $('.controllerCPBlock').css('pointer-events','none');
            $('.controllerADBlock').css('pointer-events','none');
            $('.controllerEDBlock').css('pointer-events','none');
            $('.controllerMFABlock').css('pointer-events','none');

            document.getElementById('controllerED').checked=true;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=false;               
            document.getElementById('controllerMFA').checked=true;
        }else{
            $('.controllerCPBlock').css('pointer-events','');
            $('.controllerADBlock').css('pointer-events','');
            $('.controllerEDBlock').css('pointer-events','');
            $('.controllerMFABlock').css('pointer-events','');

            document.getElementById('controllerED').checked=false;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=true;            
            document.getElementById('controllerMFA').checked=false;
        }
    });

</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        console.log(evt);
        console.log(evt.params);
        console.log(evt.params.data);
        var element = evt.params.data.element;
        console.log(element);
        var $element = $(element);
        console.log($element);
        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
        //$('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    /*$("#switch").click(function(){
        document.getElementById("switcherror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPG').removeAttr('disabled'); //enable input
        $('#nwFromClientToPG').val('');
        
    } else {
        
        $('#nwFromClientToPG').attr('disabled', true); //disable input
        $('#nwFromClientToPG').val('UNLIMITED');
    }
        });*/

    $("#switchsize").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxPermissibleFileSize').removeAttr('disabled'); //enable input
        $('#maxPermissibleFileSize').val('');
        
    } else {
        
        $('#maxPermissibleFileSize').attr('disabled', true); //disable input
        $('#maxPermissibleFileSize').val('UNLIMITED');
    }
        });
    
    $("#switchlimit").click(function(){
        document.getElementById("limiterror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#perUserBackupStorageLimit').removeAttr('disabled'); //enable input
        $('#perUserBackupStorageLimit').val('');
        
    } else {
        
        $('#perUserBackupStorageLimit').attr('disabled', true); //disable input
        $('#perUserBackupStorageLimit').val('UNLIMITED');
    }
        });

    $("#switchver").click(function(){
        document.getElementById("vererror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxVersions').removeAttr('disabled'); //enable input
        $('#maxVersions').val('3');
        
    } else {
        
        $('#maxVersions').attr('disabled', true); //disable input
        $('#maxVersions').val('UNLIMITED');
    }
        });
        
    $("#switchFairnessAlgorithm").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
            $('#daysToWaitForNextBackup').removeAttr('disabled'); //enable input
            $('#daysToWaitForNextBackup').val('0');
        }else {
            $('#daysToWaitForNextBackup').attr('disabled', true); //disable input
            $('#daysToWaitForNextBackup').val('0');
        }
    });
</script>

<script>
    /*function myFunction(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPG').val()))
        {
        if (  $('#nwFromClientToPG').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPG').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPG').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter an integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }*/
    
    function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSize').val()))
        {
        if (  $('#maxPermissibleFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if($('#maxPermissibleFileSize').val() < 1){
             document.getElementById("sizeerror").innerHTML = "Minimum File Size Allowed is 1";
         }
         else if(!isNaN($('#maxPermissibleFileSize').val()) && $('#maxPermissibleFileSize').val() > 999999){
             document.getElementById("sizeerror").innerHTML = "Maximum Permissible File Size Allowed is 999999";
         }
         else if($('#maxPermissibleFileSize').val().indexOf(".")!=-1){
            document.getElementById("sizeerror").innerHTML = "Please enter an integral value";
        }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }
    
    function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimit').val()))
        {
        if (  $('#perUserBackupStorageLimit').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
         else if($('#perUserBackupStorageLimit').val() < 1){
             document.getElementById("limiterror").innerHTML = "Minimum Per User Backup Storage Limit Allowed is 1";
         }
        else if(!isNaN($('#perUserBackupStorageLimit').val()) && $('#perUserBackupStorageLimit').val() > 99999){
             document.getElementById("limiterror").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
         }
         else if($('#perUserBackupStorageLimit').val().indexOf(".")!=-1){
            document.getElementById("limiterror").innerHTML = "Please enter an integral value";
        }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }

    function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
    }

function myFunctionMB(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMB').val()))
        {
        if (  $('#nwFromClientToPGMB').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be any integer";
            document.getElementById("switchwarning").innerHTML = "";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPGMB').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
             document.getElementById("switchwarning").innerHTML = "";
         }
        else if($('#nwFromClientToPGMB').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter an integral value";
            document.getElementById("switchwarning").innerHTML = "";
        }
        else if($('#nwFromClientToPGMB').val() < 256 && $('#networkThrottlingUnit').val() == 'kbps'){
        document.getElementById("switchwarning").innerHTML = "Recommended value is 1Mbps or greater.  You should consider increasing this value to at least 256kbps";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        document.getElementById("switchwarning").innerHTML = "";
        }
    }
    
    $(".liteVersion").addClass("disabledbutton");
    $("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});
    
    $("#switch").click(function(){
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPGMB').removeAttr('disabled','disabled'); //enable input
        $('#nwFromClientToPGMB').val('4');
        $('#networkThrottlingUnit').removeAttr("disabled","disabled");
        
    } else {
        
        $('#nwFromClientToPGMB').attr('disabled', true); //disable input
        $('#nwFromClientToPGMB').val('UNLIMITED');
        $('#networkThrottlingUnit').attr("disabled","disabled");
        $('.networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
    }
        });
        
    $("#switchAllowedDomains").click(function(){
      if ($(this).is(':checked')) {
        $('#allowedDomains').prop('readonly', false);
        $('#allowedDomains').attr('required', 'required');
      } else {
        $('#allowedDomains').prop('readonly', true);
        $('#allowedDomains').removeAttr('required');
      }
    });        
        
    function myFunctionDevice(){
        document.getElementById("deviceerror").innerHTML = "";
        /*if($('#noOfDevicesAllowed').val() < 1){
             document.getElementById("deviceerror").innerHTML = "Minimum Number of Devices Allowed is 1";
        }
        else */
        if($('#noOfDevicesAllowed').val() > <?php echo $data['noOfDevicesAllowed'];?>){
            document.getElementById("deviceerror").innerHTML = "This value exceeds the number of devices licensable per user. Please enter a value lower than or equal to <?php echo $data['noOfDevicesAllowed'];?>";
        }else{
            document.getElementById("deviceerror").innerHTML = "";
        }
    }
    
    function myFunctionnoOfDaysToKeepDeviceNotHeard(){
        document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "";
        if(isNaN($('#noOfDaysToKeepDeviceNotHeard').val()))
        {
            if (  $('#noOfDaysToKeepDeviceNotHeard').val() !='UNLIMITED')  {
                document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#noOfDaysToKeepDeviceNotHeard').val()) && $('#noOfDaysToKeepDeviceNotHeard').val() < 7){
            document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "Minimum value allowed is 7";
        }
        else if(!isNaN($('#noOfDaysToKeepDeviceNotHeard').val()) && $('#noOfDaysToKeepDeviceNotHeard').val() > 10000000){
            document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "Maximum No. of Days To Keep Device Not Heard Allowed is 1 Crore";
        }
        else{
            document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "";
        }
    }


    $("#switchnoOfDaysToKeepDeviceNotHeard").click(function(){
        document.getElementById("noOfDaysToKeepDeviceNotHearderror").innerHTML = "";
        if ($(this).is(':checked')) {

        $('#noOfDaysToKeepDeviceNotHeard').removeAttr('disabled'); //enable input
        $('#noOfDaysToKeepDeviceNotHeard').val('60');

    } else {

        $('#noOfDaysToKeepDeviceNotHeard').attr('disabled', true); //disable input
        $('#noOfDaysToKeepDeviceNotHeard').val('UNLIMITED');
    }
        });
        
    $("#switchnoOfDaysToKeepDeletedFiles").click(function(){
         document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "";
         if ($(this).is(':checked')) {
             $('#noOfDaysToKeepDeletedFiles').removeAttr('disabled'); //enable input
             $('#noOfDaysToKeepDeletedFiles').val('90');
         }else {
             $('#noOfDaysToKeepDeletedFiles').attr('disabled', true); //disable input
             $('#noOfDaysToKeepDeletedFiles').val('UNLIMITED');
         }
     }); 
 
     function myFunctionnoOfDaysToKeepDeletedFiles(){
         document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "";
         if(isNaN($('#noOfDaysToKeepDeletedFiles').val()))
         {
             if (  $('#noOfDaysToKeepDeletedFiles').val() !='UNLIMITED')  {
                 document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "Input can be either 'UNLIMITED' or any integer";
             }
         }
         else if(!isNaN($('#noOfDaysToKeepDeletedFiles').val()) && $('#noOfDaysToKeepDeletedFiles').val() < 1){
             document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "Minimum number of Versions Allowed is 1";
         }
         else if($('#noOfDaysToKeepDeletedFiles').val().indexOf(".")!=-1){
            document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "Please enter an integral value";
        }
         else{
             document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "";
         }
     }        

    $(".liteVersion").addClass("disabledbutton");
    $("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});
    
    /*$('html').bind('keypress', function(e)
    {
       if(e.keyCode == 13)
       {
          return false;
       }
    });*/
    
    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
        $('#scheduleName').removeAttr('readonly', 'readonly');
        });

        $('.createFilter').on('hidden.bs.modal', function(){
        $('#filterName').removeAttr('readonly', 'readonly');
        });

    });
    
    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
            $('#addSchedule_title').removeClass("d-none");
            $('#editSchedule_title').removeClass("d-block");
            $('#addSchedule_save').removeClass("d-none");
            $('#editSchedule_save').removeClass("d-block");
        });
        $('.createFilter').on('hidden.bs.modal', function(){
            $('#add_title').removeClass("d-none");
            $('#edit_title').removeClass("d-block");
            $('#add_save').removeClass("d-none");
            $('#edit_save').removeClass("d-block");
        });
    });
    
    $( document ).ready(function() {
        $('tr > ul').addClass('d-none');
    });

    $(".acc").click(function(){
        $(".aa").toggleClass("hide");
        $(".bb").toggleClass("show");
        $('.currentBackupText').toggleClass('hide');
    });

    $(".bb").click(function(){
        $('.currentBackupText').toggleClass('show');
    });
</script>
<style>
    .disabledbutton {
    pointer-events: none;
    opacity: 0.4;
}
</style>
<style>
.slidecontainer {
    width: 100%;
}

.slidercpu {
    -webkit-appearance: none;
    width: 100%;
    height: 15px;
    border-radius: 5px;
    background: #d3d3d3;
    outline: none;
    opacity: 0.7;
    -webkit-transition: .2s;
    transition: opacity .2s;
}

.slidercpu:hover {
    opacity: 1;
}

.slidercpu::-webkit-slider-thumb {
    -webkit-appearance: none;
appearance: none;
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2196F3;
    cursor: pointer;
}

.slidercpu::-moz-range-thumb {
    width: 25px;
    height: 25px;
    border-radius: 50%;
    background: #2196F3;
    cursor: pointer;
}
</style>
<script>
var slider = document.getElementById("myRange");
var output = document.getElementById("demo");
//output.innerHTML = slider.value;

slider.oninput = function() {
  output.innerHTML = this.value;
}
</script>
<style type="text/css">
    .disabled {
    pointer-events:none; //This makes it not clickable
    opacity:0.6;         //This grays it out to look disabled
}
h5{
color:black;
}
</style>
<script>
$("#preScanCommandEnabled").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPreScan').checked=true;
                $('#preScanCommand').attr('required', 'required');
    } else {
            document.getElementById('continueOnPreScan').checked=false;
            $('#preScanCommand').removeAttr('required', 'required');
    }
});

$("#preBackupCommandEnabled").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPreBkp').checked=true;
                $('#preBackupCommand').attr('required', 'required');
    } else {
            document.getElementById('continueOnPreBkp').checked=false;
            $('#preBackupCommand').removeAttr('required', 'required');
    }
});

$("#postBackupCommandEnabled").click(function(){
        if ($(this).is(':checked')) {
                document.getElementById('continueOnPostBkp').checked=true;
                $('#postBackupCommand').attr('required', 'required');
    } else {
            document.getElementById('continueOnPostBkp').checked=false;
            $('#postBackupCommand').removeAttr('required', 'required');
    }
});

$("#switchAgentPassword").click(function(){
      if ($(this).is(':checked')) {
        $('#agentPassword').prop('readonly', false);
        $('#agentRePassword').prop('readonly', false);
        $('#agentPassword').attr('required', 'required');
        $('#agentRePassword').attr('required', 'required');
      } else {
        $('#agentPassword').prop('readonly', true);
        $('#agentRePassword').prop('readonly', true);
        $('#agentPassword').removeAttr('required');
	$('#agentRePassword').removeAttr('required');
	$('#agentPassword').val('');
        $('#agentRePassword').val('');
      }
    });

$( ".toggle-passwordphrase" ).mousedown(function() {
  $("#agentPassword").attr("type", "text");
$(this).toggleClass("fa-eye-slash fa-eye");
});

$( ".toggle-passwordphrase" ).mouseup(function() {
  $("#agentPassword").attr("type", "password");
$(this).toggleClass("fa-eye fa-eye-slash");
});
	
	function flipAllowEndUserTocontrolRestore(){
		if($('.canAdminRestore').val() == 'true'){
			document.getElementById("allowEndUserTocontrolRestore").style.opacity = "1";
			document.getElementById("allowEndUserTocontrolRestore").style['pointer-events'] = 'unset';
			document.getElementById("canAdminDelete").style.opacity = "1";
			document.getElementById("canAdminDelete").style['pointer-events'] = 'unset';
		}else{
			$('.allowEndUserTocontrolRestore').find('option[value="false"]').prop("selected",true);
			$('.canAdminDelete').find('option[value="false"]').prop("selected",true);
			document.getElementById("allowEndUserTocontrolRestore").style.opacity = "0.5";
			document.getElementById("allowEndUserTocontrolRestore").style['pointer-events'] = 'none';
			document.getElementById("canAdminDelete").style.opacity = "0.5";
			document.getElementById("canAdminDelete").style['pointer-events'] = 'none';
		}
	}
	$("#switchuserConsentEnabled").click(function(){
		 document.getElementById("sizenoOfDaysToKeepDeletedFiles").innerHTML = "";
		 if ($(this).is(':checked')) {
			document.getElementById("userConsentDisplayText").style['pointer-events'] = 'unset';
			document.getElementById("userConsentDisplayText").style.opacity = "1";
			document.getElementById("userConsentDisplayText").style.backgroundColor = "white";
			$('#userConsentDisplayText').attr('required', 'required');
		 }else {
			 document.getElementById("userConsentDisplayText").style['pointer-events'] = 'none';
			 document.getElementById("userConsentDisplayText").style.opacity = "0.5";
			 document.getElementById("userConsentDisplayText").style.backgroundColor = "#e9ecef";
			 $('#userConsentDisplayText').removeAttr('required');
		 }
     });
	
    /*$('input[type="radio"]').on('click change', function(e) {
        var radioValue = $("input[name='shareDomainType']:checked").val();

        if(radioValue == 'Share only with these Email domains'){
                $('#shareDomainIncExclusions').removeAttr('required', 'required');
        }else{
                $('#shareDomainIncExclusions').attr('required', 'required');
        }
    });*/
	
    $('#shareDomainsEnabled').on('change', function(){
        var checked = document.getElementById('shareDomainsEnabled').checked;
        if(checked){
                $('#shareDomainIncExclusions').attr('required', 'required');
                document.getElementById("shareDomainIncExclusions").style['pointer-events'] = 'unset';
                document.getElementById("shareDomainIncExclusions").style.opacity = "1";
                document.getElementById("shareDomainIncExclusions").style.backgroundColor = "white";
                document.getElementById("only").style['pointer-events'] = 'unset';
                document.getElementById("withall").style['pointer-events'] = 'unset';
        }else{
                $('#shareDomainIncExclusions').removeAttr('required', 'required');
                document.getElementById("shareDomainIncExclusions").style['pointer-events'] = 'none';
                document.getElementById("shareDomainIncExclusions").style.opacity = "0.5";
                document.getElementById("shareDomainIncExclusions").style.backgroundColor = "#e9ecef";
                document.getElementById("only").style['pointer-events'] = 'none';
                document.getElementById("withall").style['pointer-events'] = 'none';
        }
   });	
	
    function checkTextLength(){
        document.getElementById("texterror").innerHTML = "";
        if($('#userConsentDisplayText').val().length > 8000){
        	document.getElementById("texterror").innerHTML = "User consent display text length cannot exceed 8000 characters.";                
        }else{
        	document.getElementById("texterror").innerHTML = "";
        }
    }
</script>
<style
.glyphicon {
    position: relative;
    top: 1px;
    display: inline-block;
    font-family: 'Glyphicons Halflings';
    font-style: normal;
    font-weight: 400;
    line-height: 1;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}
</style>
