<?php
    use Helpers\Url;
    use Helpers\Auth;
    use Helpers\Session;
?>
<?php $session = new Session();
function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}
?>
<nav class="navbar navbar-blue fixed-top">
    <div class="row col-lg-12">
        <div class="navbar-header col-lg-3">
            <?php if(isMobile()){ ?>
                <div id="mySidenav" class="sidenav">
                    <a href="" style="font-size: 25px;font-weight: 600;color: #f27331 !important;"><?=$session->get('userName')?></a>
                    <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
                    <!-- Side bar MySync Button Logic -->
                    <?php if(Auth::checkCloudPermission('sync')){ ?>
                        <a title="My BluSync" href="<?=Url::basePath('sync/files')?>">My BluSync</a>
                    <?php } ?>
                    <!-- Side bar MyBluvault Button Logic -->
                    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')){ ?>
                        <a title="My BluVault" href="<?=Url::basePath('backup/devices')?>"> My BluVault</a>
                    <?php } ?>
                    <?php if(Auth::checkUserPermission('admin')){ ?>
                        <?php if(CLOUD_SETTINGS == true){ ?>
                            <a title="Settings" href="<?=Url::basePath('settings')?>"> Settings</a>
                        <?php } ?>
                    <?php } ?>
                    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('sync') || Auth::checkCloudPermission('office365')){ ?>
                        <!-- Side bar PMS Button Logic -->
                        <?php if(Auth::checkUserPermission('admin')){ ?>
                            <a title="Policy Management" href="<?=Url::basePath('pms')?>"> Policy Management</a>
                        <?php } ?>
                    <?php } ?>
                    <!-- Side bar Migration Tool, Users, Devices Button Logic -->
                    <?php if(Auth::checkUserPermission('admin')){ ?>
                        <?php if(Auth::checkCloudPermission('sync') || Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('serverBackup') || Auth::checkCloudPermission('office365')){ ?>
                            <?php if($_SESSION['isLdapEnabled'] == 'true' || $_SESSION['isAADEnabled'] == 'true'){ ?>
                                <a title="User Migration" href="<?=Url::basePath('migration')?>"> User Migration</a>
                            <?php } ?>
                        <?php } ?>
                        <!-- Side bar Users Button Logic -->
                        <a title="Users" href="<?=Url::basePath('users')?>"> Users</a>
                        <!-- Side bar Devices Button Logic -->
                        <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')){ ?>
                                <a title="Devices" href="<?=Url::basePath('devices')?>"> Devices</a>
                        <?php } ?>
                    <?php } ?>
                    <!-- Side bar Support Button Logic -->
                    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('sync') || Auth::checkCloudPermission('office365')){ ?>
                        <?php if(Auth::checkUserPermission('readOnlyAdmin')){ ?>
                            <a title="Support" href="<?=Url::basePath('support')?>"> Support</a>
                        <?php } ?>
                    <?php } ?>
                    <a href="<?=Url::basePath('myAccount')?>">My Account</a>
                    <?php if($_SESSION["showAuditHistory"] == true){ ?>
                        <a href="<?=Url::basePath('activityHistory')?>">Activity History</a>
                        <a <?php if(enableShareActivityHistory == true){ ?> href="<?=Url::basePath('share/activityHistory')?>" <?php } ?>>Share Activity History</a>
                    <?php } ?>
                    <?php if(Auth::checkCloudPermission('sync')){ ?>
			    <a href="<?=Url::basePath('sync/failedFilesPortal')?>">Infected Files History</a>
                            <a class="hide" <?php if(enableTrash == true){ ?> href="<?=Url::basePath('trash')?>"<?php } ?>>Trash</a>
                    <?php } ?>
                    <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <a <?php if(enableMinicloud == true){ ?> href="<?=Url::basePath('miniClouds')?>" <?php } ?>>MiniClouds</a>
                    <?php } ?>
                    <?php if(Auth::checkCloudPermission('backup') || (Auth::checkCloudPermission('sync') && BLUDRIVE_MODE == false)){ ?>
                            <?php if($_SESSION["isDownloadAgent"] == 'true') {?>
                                    <?php //if(Auth::checkUserPermission('guest')){ ?>
                                            <a href="<?=Url::basePath('download');?>">Download Agent</a>
                                    <?php //} ?>
                            <?php } ?>
                    <?php } ?>
                    <?php if(REQUEST_SUPPORT_PAGE == true){ ?>
                            <a href="javascript:;">Request Support</a>
                    <?php } ?>
                    <?php if(HELP_PAGE == true){ ?>
                            <a href="javascript:;">Help</a>
                    <?php } ?>
		    <?php if(Auth::checkCloudPermission('sync')){ ?>
		    	<a href="<?=Url::basePath('sync/sharedFiles')?>">Shared Files</a>
		    <?php } ?>
                    <!--<a href="<?=Url::basePath('share/myShares')?>">Files Shared By Me</a>-->
                    <?php //if(SHARE_WITHIN_ORG == true){ ?>
                            <!--<a href="<?=Url::basePath('share/filesSharedWithMe')?>">Files Shared With Me</a>-->
                    <?php //} ?>
                    <a class="toolTip" data-toggle="tooltip" data-placement="bottom" title="logout" href="<?=URL::basePath('logout')?>"> Logout</a>
                </div>
                <span style="font-size:30px;cursor:pointer;color:white;" onclick="openNav()">&#9776; </span>
            <?php } ?>
            <?php if(!isMobile()){?>
                <button type="button" class="navbar-toggle collapsed d-none" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
            <?php } ?>
            <!--<a class="navbar-brand" href="<?=URL::basePath()?>"><?=HEADER_NAME?></a>-->
            <?php if(HEADER_LOGO){ ?>
		<?php if(DISABLE_BLUVAULT == true && Auth::checkUserPermission('admin')){ ?>
			<!--<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>images/<?=HEADER_NAME?>" /></a>-->
			<?php if(is_file("/var/www/portal/app/templates/default/collateral/".HEADER_NAME)){ ?>
                  		<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>collateral/<?=HEADER_NAME?>" /></a>
                    	<?php } else { ?>
                        	<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>images/<?=HEADER_NAME?>" /></a>
			<?php }?>
		<?php } else { ?>
			<!--<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>images/<?=HEADER_NAME?>" /></a>-->
			<?php if(is_file("/var/www/portal/app/templates/default/collateral/".HEADER_NAME)){ ?>
                        	<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>collateral/<?=HEADER_NAME?>" /></a>
                    	<?php } else { ?>
                        	<a href="<?=URL::basePath()?>"><img style="max-width: 55%;" src="<?=Url::templatePath()?>images/<?=HEADER_NAME?>" /></a>
                    	<?php }?>
		<?php } ?>
            <?php } else { ?>
                    <a class="navbar-brand" href="<?=URL::basePath()?>"><?=HEADER_NAME?></a>
            <?php } ?>
        </div>
	<!--<div id="navbar" class="collapse navbar-collapse">
	    <ul class="nav navbar-nav pull-right">-->
	<div class="col-lg-6"></div>
	<div id="navbar" class="navbar-collapse col-lg-3 desktop-only">
	    <ul class="nav navbar-nav float-right" style="display: -webkit-inline-box !important;">
	        <!--<li class="dropdown top-drop">
                    <a class="my-dropdown" data-toggle="dropdown" data-placement="bottom" href="javascript:;"><img class="profileImg sideBarProfilePic1 toolTip" style="cursor: default;" data-placement="right" data-toggle="tooltip" title="<?=$session->get('userName')?>" src="<?=Url::profilePic($session->get('userName'))?>" /></a>
                    <ul class="dropdown-menu">
                        <li><a href="" class="toolTip" data-placement="left" data-toggle="tooltip" title="<?=$session->get('userName')?>">Hello, <?=$session->get('userName')?></a></li>
                        <li><a href="<?=Url::basePath('myAccount')?>">My Account</a></li>
                        <li><a href="<?=Url::basePath('logout')?>">Logout</a></li>
                    </ul>
                </li>-->
                <li class="dropdown top-drop">
                    <a class="my-dropdown" data-toggle="dropdown" data-placement="bottom" title="Settings" href="javascript:;"><i class="fa fa-cogs"></i> <b class="caret"></b></a>
                    <ul class="dropdown-menu">
                        <!--<li><a href="<?=Url::basePath('myAccount')?>">My Account</a></li>-->
                        <?php if($_SESSION["showAuditHistory"] == true){ ?>
                            <li><a href="<?=Url::basePath('activityHistory')?>">Activity History</a></li>
                            <li <?php if(enableShareActivityHistory == false){ ?> class="disabled" style="opacity: 0.65;" <?php } ?>><a <?php if(enableShareActivityHistory == true){ ?> href="<?=Url::basePath('share/activityHistory')?>" <?php } ?>>Share Activity History</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                          <!--  <li><a href="<?=Url::basePath('share/activityHistory')?>">Share Activity History</a></li>-->
			    <li><a href="<?=Url::basePath('sync/failedFilesPortal')?>">Infected Files History</a></li>
                            <li class="hide" <?php if(enableTrash == false){ ?> class="disabled" style="opacity: 0.65;" <?php } ?>><a <?php if(enableTrash == true){ ?> href="<?=Url::basePath('trash')?>"<?php } ?>>Trash</a></li>
                        <?php } ?>
                        <?php if(Auth::checkUserPermission('admin')){ ?>
                            <?php if(Auth::checkCloudPermission('sync')){ ?>
                                <li class="d-none"><a href="<?=Url::basePath('cloudInfo')?>">Cloud Information</a></li>
                            <?php } ?>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sync') || $_SESSION["isDownloadAgent"] == 'true'){ ?>
                        <li class="divider <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>"></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <li <?php if(enableMinicloud == false){ ?> class="disabled" style="opacity: 0.65;" <?php } ?>><a <?php if(enableMinicloud == true){ ?> href="<?=Url::basePath('miniClouds')?>" <?php } ?>>MiniClouds</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('backup') || (Auth::checkCloudPermission('sync') && BLUDRIVE_MODE == false)){ ?>
                            <?php if($_SESSION["isDownloadAgent"] == 'true') {?>
                                <?php //if(Auth::checkUserPermission('guest')){ ?>
                                    <li><a href="<?=Url::basePath('download');?>">Download Agent</a></li>   
                                <?php //} ?>
                            <?php } ?>
                        <?php } ?>
                        <?php if(REQUEST_SUPPORT_PAGE == true){ ?>
                            <li><a href="javascript:;">Request Support</a></li>
                        <?php } ?>
                        <?php if(HELP_PAGE == true){ ?>
                            <li><a href="javascript:;">Help</a></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php if(Auth::checkCloudPermission('sync')){ ?>
		<li><a href="<?=Url::basePath('sync/sharedFiles')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="Shared Files"><i class="fa fa-share-alt"></i></a></li>
                <!--<li><a href="<?=Url::basePath('share/myShares')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="Files Shared By Me"><i class="fa fa-share-alt"></i></a></li>-->
                <!--<li <?php if(enableMyShares == false){ ?> class="disabled" style="opacity: 0.65;"<?php } ?>><a <?php if(enableMyShares == true){ ?> href="<?=Url::basePath('share/myShares')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="Files Shared By Me" <?php } ?>><i class="fa fa-share-alt"></i></a></li>-->
                <!--<li><a href="<?=Url::basePath('share/filesSharedWithMe')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="Files Shared With Me"><i class="fa fa-user"></i><i style="font-size: 80%;" class="fa fa-share-alt"></i></a></li>-->
                <?php } ?>
                <!--<li><a class="toolTip" data-toggle="tooltip" data-placement="bottom" title="logout" href="<?=URL::basePath('logout')?>"><i class="fa fa-sign-out"></i></a></li>-->
		<li class="dropdown top-drop">
                    <a class="my-dropdown" data-toggle="dropdown" data-placement="bottom" href="javascript:;"><img class="profileImg sideBarProfilePic1 toolTip" style="cursor: default;" data-placement="right" data-toggle="tooltip" title="<?=$session->get('userName')?>" src="<?=Url::profilePic($session->get('userName'))?>" /></a>
                    <ul class="dropdown-menu">
			<li><a href="" class="toolTip" data-placement="left" data-toggle="tooltip" title="<?=$session->get('userName')?>" style="font-size: 16px;font-weight: 600;color: #f27331 !important;"><?=$session->get('userName')?></a></li>
			<hr style="margin: 5px 0 !important;">
                        <li><a href="<?=Url::basePath('myAccount')?>">My Account</a></li>
                        <li><a href="<?=Url::basePath('logout')?>">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div><!--/.nav-collapse -->
    </div>
</nav>
<script>
function openNav() {
  document.getElementById("mySidenav").style.width = "300px";
}

function closeNav() {
  document.getElementById("mySidenav").style.width = "0";
}
</script>
<style>

.sidenav {
  height: 100%;
  width: 0;
  position: fixed;
  z-index: 1000;
  top: 0;
  left: 0;
  background-color: #f27331;
  overflow-x: hidden;
  transition: 0.5s;
  padding-top: 60px;
}

.sidenav a {
  padding: 8px 8px 8px 32px;
  text-decoration: none;
  font-size: 20px;
  color: #818181;
  display: block;
  transition: 0.3s;
}

.sidenav a:hover {
  color: #f1f1f1;
}

.sidenav .closebtn {
  position: absolute;
  top: 0;
  right: 25px;
  font-size: 36px;
  margin-left: 50px;
}

@media screen and (max-height: 450px) {
  .sidenav {padding-top: 15px;}
  .sidenav a {font-size: 18px;}
}
</style>
