<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Index extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Index Model was called', 'info');
    }
    
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
        Model::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }



}