<?php
namespace Helpers;
use Helpers\Session;
/**
 * Cross Site Request Forgery helper
 *
 * @author jimgwhit
 * @date May 23 2015
 */

class Csrf {
    /**
     * get CSRF token and generate a new one if expired
     *
     * @access public
     * @static static method
     * @return string
     */
    public static function makeToken() {
        $session = new Session();
        $max_time    = 60 * 60 * 24;
        $stored_time = $session->get('csrf_token');
        $csrf_token  = $session->get('csrf_token_time');
        if($max_time + intval($stored_time) <= time() && empty($csrf_token)){
            $session->put('csrf_token', md5(uniqid(rand(), true)));
            $session->put('csrf_token_time', time());
        }
        return $session->get('csrf_token');
    }

    /**
     * checks if CSRF token in session is same as in the form submitted
     *
     * @access public
     * @static static method
     * @return bool
     */
    public static function isTokenValid($token){
        $session = new Session();
        return $token == $session->get('csrf_token');
    }
}