<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Mechanic;
use Models\Pms;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class MechanicController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('mechanic');
        $this->_model = new Mechanic();
    }
	
    public function validateData($value){
        if(preg_match('/([{}<>;:=]+)(.*)/',$value)){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($response);
                        exit;
                }
    }

    public function download(){
        $data = array(
            'title' => $this->language->get('downloads'),
            'crumb1' => $this->language->get('download_applications'),
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        if($this->session->get('admin') == true){
            $data['isAdmin'] = 'true';
        }
	if($this->session->get('one_drive_backup_enabled') == "true"){
        	$data['onedriveBackupEnabled'] = 'true';
        }else{
                $data['onedriveBackupEnabled'] = 'false';
        }
        if($this->session->get('exchange_backup_enabled') == "true"){
                $data['exchangeBackupEnabled'] = 'true';
        }else{
                $data['exchangeBackupEnabled'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('mechanic/download', $data);
        View::renderTemplate('footer', $data);
    }

    public function downloadAgent(){
        if(!empty($_GET['type'])){
            switch ($_GET['type']) {
                case ('EPAForWindows'):
                    $path 		= PATH_CLIENT_DOWNLOAD . DS .WINDOWS_CLIENT_FILENAME ;
                    $filename 	= WINDOWS_CLIENT_FILENAME;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('EPAForMac'):
                    $path 		= PATH_CLIENT_DOWNLOAD . DS .MAC_CLIENT_FILENAME ;
                    $filename 	= MAC_CLIENT_FILENAME;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('AppForAndroid'):
                    Url::redirect('https://play.google.com/store/apps/details?id=com.parablu.app', true);
                    exit;
                case ('AppForWindows'):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Application for Windows is not yet supported'
                    );
                    echo json_encode($result);
                    break;
                case ('AppForMac'):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Application for Mac is not yet supported'
                    );
                    echo json_encode($result);
                    break;
		case ('EPAForLinuxDeb'):
                    $path               = PATH_CLIENT_DOWNLOAD . DS .LINUX_CLIENT_FILENAME_DEB ;
                    $filename   = LINUX_CLIENT_FILENAME_DEB;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('EPAForLinuxRpm'):
                    $path = PATH_CLIENT_DOWNLOAD . DS .LINUX_CLIENT_FILENAME_RPM ;
                    $filename = LINUX_CLIENT_FILENAME_RPM;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
		case ('ParabluODBExchangeMappingApp'):
                    $path = PATH_CLIENT_DOWNLOAD . DS .'ParabluODBExchangeMappingApp.exe' ;
                    $filename = 'ParabluODBExchangeMappingApp.exe';
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('ParabluO365MappingApp'):
                    $path = PATH_CLIENT_DOWNLOAD . DS .'ParabluO365MappingApp.exe' ;
                    $filename = 'ParabluO365MappingApp.exe';
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('ParabluODBSecondaryAdminMappingApp'):
                    $path = PATH_CLIENT_DOWNLOAD . DS .'ParabluODBSecondaryAdminMappingApp.exe' ;
                    $filename = 'ParabluODBSecondaryAdminMappingApp.exe';
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Selected app type is not yet supported'
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function cloudInfo(){
        Auth::allowOnly('readOnlyAdmin');
        $headers = array(
            'Content-type' => 'application/xml',
            'Accept' => 'application/xml',
            'Accept-Charset' => 'utf-8',
            'token' => $this->session->get('token'),
            'cloudParams' => 'home,users,devices,myclouds,syncUsers,backupUsers,size'
        );
        $cloudDetails = $this->_model->getCloudInfo($headers);
        $this->log('Cloud Details: '. json_encode($cloudDetails), 'info');
        if($cloudDetails['status'] == 200){
            $cloudDetails['body']->{'license'}->{'max-storage'} = round(($cloudDetails['body']->{'license'}->{'max-storage'}) / 1024, 2);
            if((int)$cloudDetails['body']->{'space-used'} < 1024){
                $cloudDetails['body']->{'space-used'} = (int)$cloudDetails['body']->{'space-used'};
                $unit = "MB";
            }else{
                $cloudDetails['body']->{'space-used'} = round(((int)$cloudDetails['body']->{'space-used'})/1024, 2);
                $unit = "GB";
            }
        }else{
            $cloudDetails['body'] = '';
        }
        $data = array(
            'title' => $this->language->get('cloud_information'),
            'crumb1' => $this->language->get('everythingAboutYourCloud'),
            'active' => 'home',
            'csrf_token' => $this->setCSRFToken(),
            'cloudDetails' => $cloudDetails['body'],
            'unit' => $unit,
            'loggedInUser' => $this->session->all()
        );      
        if($this->session->get('lastLoggedInTime') != ""){
	    $data['time'] = date('d-M-Y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
        }
        if($this->session->get('admin') == true){
        $data['isAdmin'] = 'true';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('mechanic/cloudInfo', $data);
        View::renderTemplate('footer', $data);
    }

    public function readExcelFromUpload(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUpload($nameMD5);
            $this->log('Result_$value: '.$value, 'info');
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $this->log('Result_$userName: '.json_encode($userName), 'info');
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $userNames=array_map('trim',$userNames);
                $this->log('Result_userNames: '.json_encode($userNames), 'info');
                $this->log('Result_combined: '.json_encode($sheets->{'deviceList'}), 'info');
		foreach($userNames as $value){
                        $this->validateData($value);
                }
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames),
                );
                die(json_encode($result));
            }else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }


    public function readExcelFromUploadForDevices(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUploadForDevices($nameMD5);
            $this->log('Result_$value: '.$value, 'info');
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $this->log('Result_$userName: '.json_encode($userName), 'info');
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $this->log('Result_userNames: '.json_encode($userNames), 'info');
                $this->log('Result_combined: '.json_encode($sheets->{'deviceList'}), 'info');
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames),
                    'deviceList' => $sheets->{'deviceList'}
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_usernames'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure usernames column is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_devicenames'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure devicenames column is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_samecolumn'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure any values are neither duplicates nor missing'
                );
                die(json_encode($result));
            }
            else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }

    public function readExcelFromUploadForCreateUsers(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUploadForCreateUsers($nameMD5);
            $this->log('Result_$value: '.$value, 'info');
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $this->log('Result_$userName: '.json_encode($userName), 'info');
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $this->log('Result_userNames: '.json_encode($userNames), 'info');
                if(json_encode($userNames) == "[null]"){
                    $this->log('Result_userNames: kkkkkkkkkkkkkk', 'info');
                    $result = array(
                    'result' => 'empty_excel',
                    'msg' => 'Imported excel is empty'
                );
                die(json_encode($result));
                    
                }
                $this->log('Result_combined: '.json_encode($sheets->{'userList'}), 'info');
                $this->log('Result_combined222222222: '.json_encode($sheets->{'userList'}->{'userList'}), 'info');
                if(json_encode($sheets->{'userList'}->{'userList'}) == "null"){
                    $this->log('Result_combined222222222333333: kkkkkkkkkkkkkk3333333', 'info');
                    $result = array(
                    'result' => 'information_missing',
                    'msg' => 'Please ensure all the information is filled'
                );
                die(json_encode($result));
                    
                }
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames),
                    'userList' => $sheets->{'userList'}
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure all the relevant information is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_usernames'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure usernames column is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_emailId'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure emailId is present'
                );
                die(json_encode($result));
            }
            else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }

    public function setSessionForRedirect(){
        if(!empty($_POST)){
            foreach($_POST as $key => $value){
                $this->session->put($key, $value);
            }
            echo json_encode(array('result' => 'success', 'msg' => 'Send him through'));
            exit;
        }else{
            echo json_encode(array('result' => 'success', 'msg' => 'Send him through'));
            exit;
        }
    }

    public function getBestBlukrypt(){
        $pms = new Pms();
        //$this->log("BLUKRYPTS => : ".json_encode($_POST['blukrypts']),"info");
        if(empty($_POST['blukrypts'])){
            echo json_encode(array('result' => 'fail', 'msg' => 'Blukrypts has not been configured'));
        //echo json_encode(array('result' => 'success', 'bestBlukrypt' => "172.104.174.120"));
            exit;
        }
        $result = [];
        $time = 0;
        foreach ($_POST['blukrypts'] as $value) {
            //$this->log("GATEWAYNAME =>: ".$value['gatewayName'],"info");
            $startTime = microtime(true);
            $result = $pms->checkForBluKryptInstallation($value['gatewayName']);
            $stopTime = microtime(true);
            if($result['status'] == 200){
            $status = ($stopTime - $startTime) * 1000;
            $status = floor($status);
            /*
            $this->log("STARTTIME : ".$startTime,"info");
            $this->log("STOPTIME : ".$stopTime,"info");
            $this->log("STATUS1 : ".$status,"info");
            $this->log("TIME1 : ".$time,"info");*/
            if($time == 0){
            	$result1 = array('result' => 'success', 'bestBlukrypt' => $value['gatewayName']);
            	$time = $status;
            }else{
            	$result1 = array('result' => 'success', 'bestBlukrypt' => $value['gatewayName']);
            }
            //$this->log("NNNNNNNEEEEEWWWWW RESULT : ".json_encode($result),"info");
            }
        }
        echo json_encode($result1);
        exit;
    }
	
    public function readExcelFromUploadForPolicyMapping(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUploadForPolicyMapping($nameMD5);
            $this->log('Result_$value: '.$value, 'info');
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $this->log('Result_$userName: '.json_encode($userName), 'info');
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $this->log('Result_userNames: '.json_encode($userNames), 'info');
                $this->log('Result_combined: '.json_encode($sheets->{'deviceList'}), 'info');
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames),
                    'deviceList' => $sheets->{'deviceList'}
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_usernames'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure usernames column is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_policynames'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure policy names column is present'
                );
                die(json_encode($result));
            }
            else if($sheets->result == 'fail_samecolumn'){
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Please ensure any values are neither duplicates nor missing'
                );
                die(json_encode($result));
            }
            else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }
    
    public function readExcelFromUploadOld(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUploadOld($nameMD5);
            $this->log('Result_$value: '.$value, 'info');
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $this->log('Result_$userName: '.json_encode($userName), 'info');
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $userNames=array_map('trim',$userNames);
                $this->log('Result_userNames: '.json_encode($userNames), 'info');
                $this->log('Result_combined: '.json_encode($sheets->{'deviceList'}), 'info');
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames),
                );
                die(json_encode($result));
            }else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }	
}
