<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=Language::show('BluSync Dashboard', 'keywords')?> </h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="TrashController">
    <span class="d-none currentPage"><?='trash'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <!--<div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>-->
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel" block-ui="myBlockUI">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <li><a class="purge toolTip" ng-click="confirmPurge()" data-toggle="tooltip" data-placement="top" title="Purge" style="display: block" href="javascript:;"><i class="fa fa-times"></i></a></li>
                        <li><a class="restore toolTip" ng-click="confirmRestore()" data-toggle="tooltip" data-placement="top" title="Restore" style="display: block" href="javascript:;"><i class="fa fa-refresh"></i></a></li>
                        <li ng-if="items.length>0"><a class="purgeAll toolTip" ng-click="confirmPurgeAll('')" data-toggle="tooltip" data-placement="bottom" title="Purge All" href="javascript:;"><i class="fa fa-trash-o"></i></a></li>
                        <li ng-if="items.length>0"><a class="restoreAll toolTip" ng-click="confirmRestoreAll()" data-toggle="tooltip" data-placement="bottom" title="Restore All" href="javascript:;"><i class="fa fa-recycle"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                            <col class="col-xs-2">
                        </colgroup>
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'modifiedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'modifiedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'modifiedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'size'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'size' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'size' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse" ng-class="{'selectable': value.type == 'Mini Cloud' || value.type == 'Folder' || value.storagePlace == 'ES'}">
                            <td data-name="{{value.$$hashKey}}" ng-if="value.type == 'Mini Cloud'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.$$hashKey}}" ng-if="value.type == 'Folder'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.$$hashKey}}" ng-if="value.type == 'File'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td ng-cloak> {{ value.type }} </td>
                            <td ng-cloak> {{ value.modifiedTime }} </td>
                            <td ng-if="value.type == 'Mini Cloud'" ng-cloak> - </td>
                            <td ng-if="value.type == 'Folder'" ng-cloak> - </td>
                            <td ng-if="value.type == 'File'" ng-cloak>
                                {{ value.size }}
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folders</h3>
            </div>
            <div class="modal fade confirmPurge">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Purge Confirmation</h4>                            
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="purgeFile()" class="btn btn-danger">Purge</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade confirmRestore">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Restore Confirmation</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to restore the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to restore the below selected files and folders?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="restoreFile()" class="btn btn-primary">Restore</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade confirmPurgeAll">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Purge Confirmation</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>Do you want to permanently delete all files and folders?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="purgeAll()" class="btn btn-danger">Purge All</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade confirmRestoreAll">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Restore Confirmation</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
                            <p>
                                <span>Do you want to restore all files and folders?</span>
                            </p>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="restoreAll()" class="btn btn-primary">Restore All</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/TrashController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
