<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.0
* @date 26/03/2019
* @time 5:26 PM
*
*/
?>
<span ng-controller="ShareController" xmlns="http://www.w3.org/1999/html">
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('sync/sharedFiles')?>">Files Shared</a></h3></li>
                <li>Files Shared By Me</li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <span class="d-none shareType"><?php if(SHARE_WITHIN_ORG == true){echo 'shareWith';}else{echo 'share';}?></span>
    <span class="d-none currentPage"><?='trash'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide shareDomainType"><?=$data['shareDomainType']?></span>
    <span class="hide shareDomainIncExclusions"><?=$data['shareDomainIncExclusions']?></span>
    <span class="hide shareDomainIncExclusionsException"><?=$data['shareDomainIncExclusionsException']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <!--<div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>-->
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel" block-ui="myBlockUI">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body" style="height: 40px;">
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <?php if(SHARE_WITHIN_ORG == false){ ?>
                            <li ng-show="showShareLink == true"><a class="getLink toolTip" ng-click="getLink()" data-toggle="tooltip" data-placement="top" title="Get Link" style="display: none;color:black;" href="javascript:;"><i class="fa fa-link"></i></a></li>
                        <?php } ?>
                        <li><a class="share toolTip" ng-click="share()" data-toggle="tooltip" data-placement="bottom" title="Edit" style="display: none;color:black;" href="javascript:;"><i class="fa fa-share"></i></a></li>
                        <!--<li><a class="unShare toolTip" ng-click="unShareFile()" data-toggle="tooltip" data-placement="bottom" title="Un-share" style="display: none;color:black;" href="javascript:;"><i class="fa fa-share-square"></i></a></li>-->
                        <li><a class="openFile toolTip" ng-click="openFile()" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="display: none;color:black;" href="javascript:;"><i class="fa fa-folder-open"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <!--<colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                        </colgroup>-->
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'devicePath'; sortReverse = !sortReverse">
                                Path
                                <span ng-show="sortType == 'devicePath' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'devicePath' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th>Valid Until</th>
                            <!--<th class="clickAble" ng-click="sortType = 'sharedTimeInMillis'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'sharedTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'sharedTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                            <th class="clickAble" ng-click="sortType = 'devicePath'; sortReverse = !sortReverse">
                                Shared with
                                <span ng-show="sortType == 'devicePath' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'devicePath' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr',cancel: 'a.showDetails'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse">
                            <td data-name="{{value.$$hashKey}}" title="{{value.fileName}}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: black;"><span>{{value.fileName | limitTo:40}}{{value.fileName.length > 40 ? '...' : ''}}</span><span ng-if="value.fileName.length > 40">{{value.extension}}</span></a><a ng-if="value.haveMultipleFiles == 'yes'" class="showDetails" ng-click="showSharedFiles(value.backupIDs, value.destinationCollection, value.isShareLatestVersion, value.devicePath, value.userName, value.gatewayName, value.isView, value.isDownload)" style="color:#F27331;cursor:pointer;"><i class="fa fa-plus-circle" style="padding:5px;"></i></a>  <span class="badge badge-danger" ng-if="value.isExpired == 'Expired'"><?=Language::show('Expired', 'keywords')?></span></td>
                            <td title="{{value.devicePath}}" ng-cloak>{{value.devicePath | limitTo:40}}{{value.devicePath.length > 40 ? '...' : ''}}</td>
                            <td ng-if="value.perpetual == 'no'" ng-cloak> {{ value.validUntilDate }} </td>
                            <td ng-if="value.perpetual == 'yes'" ng-cloak> Perpetual </td>
                            <td ng-cloak> <a class="showDetails" ng-click="showDetails(value.toEmailList)" style="cursor:pointer;">{{value.toEmailList | limitTo:40}}{{value.toEmailList.length > 40 ? '(...)' : ''}}</a></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folders</h3>
            </div>
            <!--modal start-->
<div class="modal fade" id="sharedFilesModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <h4 class="modal-title">File shared are as following</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <!--<textarea style="width:100%" class="fileSharedWith" name="fileSharedWith" id="fileSharedWith" rows="10" disabled></textarea>-->
                                        <li ng-repeat="value in sharedFilesList track by $index" ng-cloak>
                                            <a title="{{value.fileName}}" style="word-wrap:break-word;" ng-cloak>{{ value.fileName }}</a>    
                                            <!--<a title="{{value}}" style="word-wrap:break-word;" ng-cloak>{{ value | limitTo:60}}{{value.length > 60 ? '...' : ''}}</a>-->
                                        </li>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<!--modal ends-->
            <!--modal start-->
<div class="modal fade" id="sharedEmailsModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <h4 class="modal-title">File shared with following Email addresses</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12 emailsListDiv">
                                        <!--<textarea style="width:100%" class="fileSharedWith" name="fileSharedWith" id="fileSharedWith" rows="10" disabled></textarea>-->
                                        <li ng-repeat="value in sharedFilesEmails track by $index" ng-cloak>
                                                <a title="{{value}}" style="word-wrap:break-word;" ng-cloak>{{ value }}</a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<!--modal ends-->
            <div class="modal fade" id="shareLink" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body shareLinkLoading">
                            <span>Loading ...</span>
                        </div>
                        <div class="modal-body shareLinkBody" style="display: none;">
                            <div class="mt-md mb-md">
                                <div class="shareLinkBlockLink" style="display: none;">
                                    <h4>
                                        Share the below link to share the file:
                                       <a href="" ng-click="sendEmailShareLink()" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                    </h4>
                                    <textarea class="js-copytextareaLink shareLinkLink" style="width:100%;word-wrap: break-word;" readonly></textarea>
                                    <h4><a href="" class="js-textareacopybtnLink clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboardLink()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h4>
                                    <div class="form-group hide">
                                        <label for="googleAuth"><?=Language::show('Is googleAuth Enabled', 'keywords');?></label>
                                        <input type="text" class="form-control" name="isgoogleAuthIsEnabled" id="isgoogleAuthIsEnabled" value="">
                                    </div>
                                    <br>
                                </div>
                                <div class="form-group sendEmailShareForm hide">
                                    <label for="emails">Emails</label>
                                    <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                    <br/>
                                    <a href="" ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                  <!--          <a ng-click="unShareFile()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>-->
                        </div>
                    </div>
                </div>
            </div>
            <!--new share start-->
<div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShare()">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div class="modal-body shareBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                        <h4 <?php if(multifactorAuthWithAccessCode == true){ ?>class="hide" <?php } ?>>Password Protected:
                                                <span><input type="checkbox" class="sharePasswordSwitch" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo "checked='checked'"; echo "disabled ='true'";}?>/></span>
                                            </h4>
                                            <span class="sharePasswordBlock <?php if(multifactorAuthWithAccessCode == true){ ?> hide <?php } ?>" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>style="display: block;" <?php }else { ?> style="display:none;"<?php } ?>>
                                                <div class="form-group">
                                                    <label for="password">File access password</label>
                                                    <input type="password" class="form-control" id="sharePassword" placeholder="Enter file access password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re-Type file access password</label>
                                                    <input type="password" class="form-control" id="reSharePassword" placeholder="Re-Type file access password" data-parsley-minlength="6" data-parsley-equalto="#sharePassword" data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                            </span>
                                            <div class="form-group currentValidityDiv" style="display:none;">
                                                <span id="linkExpiresOn">Link Expires on : <span id="currentValidity"></span></span> <span class="removeValidUntil text-danger clickable col-lg-12" style="cursor:pointer;display: none;">Change Validity</span>
                                            </div>
                                            <?php if(multifactorAuthWithAccessCode == true){ ?>
                                                <div class="form-group googleAuthIsEnabledDiv" <?php if($data['policy']['googleAuth'] == "1"){  echo "style=display:none;"; } ?>>
                                                        <label for="googleAuthIsEnabled">Enable One Time Access Code authentication</label>
                                                        <input type="checkbox" class="googleAuthIsEnabled" <?php if($data['policy']['googleAuth'] == "1"){  echo "checked='checked'";echo "disabled ='true'"; } ?>/>
                                                </div>
                                            <?php } else { ?>
                                                <div class="form-group">
                                                        <label for="googleAuthIsEnabled">Enable multi-factor authentication</label>
                                                        <input type="checkbox" class="googleAuthIsEnabled" <?php if($data['policy']['googleAuth'] == "1"){  echo "checked='checked'";echo "disabled ='true'"; } ?>/>
                                                </div>
                                            <?php } ?>
                                                <div class="form-group">
                                                        <label for="shareLatestVersion">Let recipient get access to the most current file version</label>
                                                        <input type="checkbox" class="shareLatestVersion">
                                                </div>
                                            <div class="form-group">
                                                        <label for="linkExpiryAlertsEnabled">Allow recipient to get alerts on link expiration</label>
                                                        <input type="checkbox" class="linkExpiryAlertsEnabled" name="linkExpiryAlertsEnabled"/>
                                                </div>
                                            <div class="form-group">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="d-none">
                                                        <label for="enableDownload">Enable Download: </label>
                                                        <input type="checkbox" id="enableDownload" class="enableDownload" />
                                                    </div>
                                                <?php } else { ?>
                                                    <label for="enableDownload">Enable Download: </label>
                                                    <input type="checkbox" id="enableDownload" class="enableDownload" checked />
                                                <?php } ?>
                                            </div>
                                            <span class="shareId hide"></span>
                                            <div class="shareLinkBlock" style="display: none;">
                                                <h4>
                                                    <span ng-show="showShareLink == true">Share the below link to share the file:</span>

                                                    <a href="" ng-click="sendEmailShareLink()" title="Email" class="clickAble sendEmailShareLink" style="font-size:14px;"><i class="fa fa-envelope" style="font-size: 1.5em;"></i> Share this link with others</a>
                                                </h4>
                                                <textarea class="js-copytextarea shareLink" ng-show="showShareLink == true" style="width:100%;word-wrap: break-word;" rows="5" readonly></textarea>
                                                <h4 ng-show="showShareLink == true"><a href="" class="js-textareacopybtn clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h4>
                                                <!--<h5 id="copyTarget" class="shareLink" style="word-wrap: break-word;"></h5>-->
                                                <br>
                                            </div>
                                            <div class="form-group sendEmailShareForm hide">
                                                <label for="emails" style="font-weight:bold;">Enter recipient email addresses (Use comma to separate Email addresses)</label>
                                                <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                                <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-primary shareEmailLinkSendBtn" style="font-weight:bold;"> Send</a>
                                            </div>
                                            <!--new exp start-->
                                            <div class="col-lg-12 validitySettingsDiv" style="border: 1px solid #f27331;border-radius: 10px;padding: 5px;margin-bottom: 10px;display:none">
                                                <div class="checkbox check-primary enableValidityDiv">
                                                        <input id="enableValidity" name="enableValidity" type="checkbox" value="enabled">
                                                        <label for="enableValidity"><?=Language::show('Link Validity', 'keywords');?></label>
                                                </div>
                                                <div class="row validityRow">
                                                        <div class="col-lg-3 form-group">
                                                                <label for="till">Validity Date</label>
                                                                <input type="text" class="form-control till" name="till" id="till" placeholder="Valid Till" <?php if($data['policy']['expiredDate'] == "1"){ echo " required";}?>>
                                                        </div>
                                                        <div class="col-lg-3 form-group">
                                                                <label for="tillTime">Validity Time</label>
                                                                <input type="text" class="form-control timePicker input-small" id="tillTime" name="tillTime" placeholder="Valid Time" <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>>
                                                        </div>
                                                        <!--<div class="form-group col-lg-6">
                                                                <label for="timezone">Validity Time</label>
                                                                <input type="datetime-local" id="pickerDateTime" <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>/>
                                                        </div>-->
                                                        <div class="form-group col-lg-6">
                                                                <label for="timezone">Select Timezone</label>
                                                                <select class="form-control" id="dropdownTimeZone"></select>
                                                        </div>
                                                        <div class="form-group col-lg-2 hide">
                                                            <input type="button" id="btnSubmit" onclick="submitDate()" value="Calculate" />
                                                        </div>
                                                        <div class="report hide"><label>Browser/Local datetime</label>
                                                                <div id="divLocal"></div>
                                                                <label>UTC of browser datetime</label>
                                                                <div id="divUTC"></div>
                                                                <label>Selected datetime with timezone</label>
                                                                <div id="divSelected">
                                                                </div>
                                                                <label>UTC of selected datetime with timezone</label>
                                                                <div id="divUTCSelected">
                                                               </div>
                                                        </div>
                                                </div>
                                            </div>
                                            <!--new exp end-->
                                            <div class="d-none">
                                                    <label for="enableView">Allow View: </label>
                                                    <input type="checkbox" id="enableView" class="enableView" checked />
                                                </div>
                                            </div>
                                            <span class="changeImpactText" style="font-size: 12px;color: #f55753;display: none;">Note :- “Please note that any changes made above will impact the experience for all recipients who access this link going forward – including recipients who’ve already received this link.”</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShareFile()" style="float:left;display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
<!--new share ends-->
        </div>
    </div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
</span>
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ShareController.js?<?php echo microtime();?>" type="text/javascript"></script>
<script>
    var copyTextareaBtn = document.querySelector('.js-textareacopybtn');
copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
    
/*for share modal starts*/
        $( "#sharePassword" ).change(function(){
        console.log("sharePassword clicked");
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
});

$( "#till" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
});

$( "#tillTime" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
});
    
$( "#pickerDateTime" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
});

$( "#dropdownTimeZone" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
                $('.shareBtn').show();
                $('.shareBtn').html('Save');
                $('.changeImpactText').show();
        }
});

var enableDownload = document.querySelector('.enableDownload');
    if(enableDownload){
            enableDownload.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
                        $('.shareBtn').show();
                        $('.shareBtn').html('Save');
                        $('.changeImpactText').show();
                    }
        };
}
    
var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
            sharePasswordSwitch.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
                        $('.shareBtn').show();
                        $('.shareBtn').html('Save');
                        $('.changeImpactText').show();
                    }
        };
    }

$('#share').on('hidden.bs.modal', function(){
        $("#fileShareForm").parsley().reset();
});

$('form').on('reset', function() {
  var $form = $(this);
  $form.find('.error,.valid').css('border-color', '').removeClass('error').removeClass('valid');
  $form.find('.form-error').remove();
});

$("#share").on("hidden.bs.modal", function(){
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('#till').val('');
});

const DEFAULT_FORMAT = 'DD-MM-YYYY HH:mm:ss Z';
//const DEFAULT_FORMAT = 'YYYY-MM-DD HH:mm:ss Z';
    
function loadTimeZoneList(){
     let select = document.getElementById("dropdownTimeZone");
         select.innerHTML = "";
         let browserTimeZone = moment.tz.guess();
         let timeZones = moment.tz.names();
                timeZones.forEach((timeZone) =>{
                option = document.createElement("option");
                  option.textContent = `${timeZone} (GMT${moment.tz(timeZone).format('Z')})`;
                  option.value = timeZone;
                  if (timeZone == browserTimeZone){
                          option.selected = true;
                  }
                  select.appendChild(option);
                });
   }
        function loadDefaultDateTime(){
                //document.getElementById('pickerDateTime').value = moment().format('YYYY-MM-DDTHH:mm');
                //document.getElementById('pickerDateTime').value = moment().format('DD-MM-YYYY HH:mm');
        }
    
function submitDate(){

        let localValue = document.getElementById('pickerDateTime').value;
        let timeZoneValue = document.getElementById("dropdownTimeZone").value;

        let local =  document.getElementById('divLocal');
        local.innerHTML = formatDate(moment(localValue));
        //local.innerHTML = getDate(moment(localValue));
        //console.log("1 : "+moment(localValue));

        let utc =  document.getElementById('divUTC');
        utc.innerHTML = formatDate(getUtcValue(localValue));
        //utc.innerHTML = getDate(getUtcValue(localValue));
        //console.log("2 : "+getUtcValue(localValue));

        let selected =  document.getElementById('divSelected');
        selected.innerHTML = formatDate(getSelectedValue(localValue,timeZoneValue));
        //selected.innerHTML = getDate(getSelectedValue(localValue,timeZoneValue));
        //console.log("3 : "+getSelectedValue(localValue,timeZoneValue));

        let utcSelected =  document.getElementById('divUTCSelected');
        utcSelected.innerHTML = formatDate(getSelectedUTCValue(localValue,timeZoneValue));
        //utcSelected.innerHTML = getDate(getSelectedUTCValue(localValue,timeZoneValue));
        //console.log("4 : "+getSelectedUTCValue(localValue,timeZoneValue));
   }


   function formatDate(momentDate){
                return momentDate.format(DEFAULT_FORMAT);
   }

   function getDate(momentDate){
      return momentDate.toDate();
 }
    
function getUtcValue(localDateTime){
                return moment(localDateTime).utc();
   }

   function getSelectedValue(localDateTime, timeZone)
   {
                return moment.tz(localDateTime,timeZone);
   }

   function getSelectedUTCValue(localDateTime, timeZone)
   {
                return moment.tz(localDateTime,timeZone).utc();
   }


        function init(){
                //loadDefaultDateTime();
                loadTimeZoneList();
                //submitDate();
        }

   init();
    
    $('.removeValidUntil').on('click', function(){
        //$('.till').val('');
        //$('#tillTime').val('');
        $('.validitySettingsDiv').show();
        $('.removeValidUntil').hide();
        //$('.currentValidityDiv').hide();
    });

$('.till').datepicker({
        format: 'dd-M-yyyy',
//      format: 'yyyy-mm-dd',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.till').val() != ''){
            //$('.removeValidUntil').show();
        }
    });
    $("#till").datepicker().datepicker("setDate", new Date());
    $('#tillTime').timepicker({
        showMeridian: false
    });
/*for share modal ends*/
    
var copyTextareaBtn = document.querySelector('.js-textareacopybtn');

copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
    
var copyTextareaBtnLink = document.querySelector('.js-textareacopybtnLink');

copyTextareaBtnLink.addEventListener('click', function(event) {
  var copyTextareaLink = document.querySelector('.js-copytextareaLink');
  copyTextareaLink.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});    
</script>
