<?php
use \Core\View;
use Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=Language::show('BluSync Dashboard', 'keywords')?> </h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
	<div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncController">
    <span class="hide currentPage"><?='failedFiles'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
<span class="hide userName"><?=$data['userName']?></span>
<span class="hide deviceName"><?=$data['deviceName']?></span>
<span class="hide deviceUUID"><?=$data['deviceUUID']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
<div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('Infected Files History', 'keywords')?>
                        <?php if(Auth::checkUserPermission('admin')){ ?>
<!--                            <a class="btn btn-default btn-small pull-right" data-toggle="modal" data-target="#assignUsers">Export Activity History To Excel</a>-->
                        <?php } ?>
                    </h4>
                </div>
		<div class="panel-body noRecords" style="padding: 0px 10px 10px 10px;">
		    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center">No records found!</h2>
                        </div>
                    </div>
		</div>
                <div class="panel-body records" style="padding: 0px 10px 10px 10px;">
                    <div class="table-responsive" style="padding: 20px 10px 20px 40px;">
                        <div class="h4 loading text-center">Loading.....</div>
                        <ul class="mini-timeline">
                            <li ng-repeat="value in audits track by $index" class="mini-timeline-{{value.color}}">
                                <div class="timeline-icon"></div>
                                <div class="timeline-body">
                                    <div class="timeline-content">
					<a href="javascript:;" ng-click="updateBackupActivityDetails(100, value.actionByUser, '', 0)" class="name" ng-cloak>{{ value.actionByUser }}</a> {{ value.action }} <span class="text-primary" ng-cloak>{{ value.actionOnObject }}</span> <span ng-if="value.actionUsingObject.length > 0"> <a ng-if="value.additionalInfo.length > 1" class="name" href="javascript:;" ng-cloak>{{ value.additionalInfo }}</a> using <a ng-click="updateBackupActivityDetails(100, '', value.actionUsingObject, 0)" class="name" href="javascript:;" ng-cloak>{{ value.actionUsingObject }}</a></span>
                                        <span class="time" ng-cloak>{{ value.time }}</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="navigateFailedFiles(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="navigateFailedFiles(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="navigateFailedFiles(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="navigateFailedFiles(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="updateBackupActivityDetails(50, '', '', pageNumber)">Load More ...</a>
                        </div>
                    </div>-->
		</div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
