<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.0
* @date 27/01/2020
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?="Settings"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
            </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='dataMigration'?></span>
            <div class="row">
                <!--modal-->
                  <?php if($data['graphApiEnabled'] == 'false') { ?>
                    <div class="modal fade" id="graphApiEnabledModal" role="dialog" data-keyboard="false" data-backdrop="static">
                      <div class="modal-dialog">
                      <!-- Modal content-->
                      <div class="modal-content">
                        <div class="modal-header">
                          <h4 class="modal-title">Attention...!!!</h4>
                        </div>
                        <div class="modal-body">
                          <div class="form-group">
                            <p>This feature requires your environment to have been configured with Microsoft Graph.  Please speak to your Administrator, tech partner or the Parablu support team for help with this configuration.</p>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <a class="btn btn-default" type="button" href="<?=URL::basePath('settings')?>">Cancel</a>
                        </div>
                      </div>

                    </div>
                  </div>
                  <?php } ?>
                <!--modal-->
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h3><?=$data['crumb1']?>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <ul>
                                      <li>This process is irreversible once initiated.</li>
                                      <li>No Operations are allowed on these users or devices during Data Migration.</li>                                      
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="row usersFound" style="display: none;">
			    <div class="table-responsive browsePathDivOnedrive col-lg-12">
<div class="row">
                                <div class="col-lg-3" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="browseElements" class="table table-hover table-bordered browseElements" >
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Blocked Users</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in browseElements" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
                                                <td ng-click="pickElement(value, $index)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-2">
                                    <a ng-click="itemSelect1()" class="block btn btn-success" style="width:100%;">Add >><a>
                                    <br>
                                    <a ng-click="removeName1()" class="block btn btn-danger" style="width:100%;">< Remove</a>
                                    <br>
                                    <a ng-click="removeAllName()" class="block btn btn-danger" style="width:100%;"><< Remove All</a>
                                </div>
                                <div class="col-lg-3" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="addedElements" class="table table-hover table-bordered">
                                        <thead ng-show="addedElements.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected Users</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedElements.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Users Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="addedElements.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected Users</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedElements.length > 0">
                                            <tr ng-repeat="value1 in addedElements" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1, $index)" ng-cloak><span style="cursor: pointer;">{{ value1 }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-6">
				</div>
</div>
                            </div>
                            <!--<div class="table-responsive col-lg-3 usersTable">
                                <table class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>
                                        <input type="checkbox" class="select-all checkbox" name="select-all"/>
                                        </th>
                                        <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                            <?=Language::show('Blocked Users', 'keywords')?>
                                            <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr ng-repeat="value in users">
                                        <td class="text-center">
                                            <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.userName }}" ng-click="itemSelect()"/>
                                        </td>
                                        <td class="text-left" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>-->
			    <div class="col-lg-12" style="margin-top:5%;">
<div class="row">
                                <div class="col-lg-6">
                                    <!--<div class="form-group row hide">
                                        <label for="selectedUsers"><?=Language::show('Selected users', 'keywords');?></label><br/>
                                        <input type="text" data-role="tagsinput" value="" class="form-control selectedUsers" name="selectedUsers[]" id="selectedUsers" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Selected Users', 'keywords');?>" required autocomplete="off">
                                    </div>-->
                                    <div class="form-group row">
                                        <label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
                                        <input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <a class="btn btn-success btn-small"
                                        ng-bootbox-confirm="<h4><?=Language::show('datamigrationConfirm', 'keywords')?></h4>"
                                        ng-bootbox-confirm-action="startDataMigration()"
                                        ng-bootbox-confirm-action-cancel=""
                                        href="javascript:;" style="margin-top: 25px;" ><?=Language::show('Start Migration', 'keywords');?></a>
				</div>
</div>
                            </div>
                        </div>
                        <div class="row noUsers" style="display: none;">
                            <div class="panel-body col-lg-12">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <h2 align="center"><?=Language::show('No Blocked Users found !!!!!!', 'keywords');?></h2>
                                        </div>
                                </div>
                            </div>
                        </div>
                        <br/>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
            });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                //console.log("items"+items);
                //console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            //console.log("chhhhh");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            //console.log("all clicked");
            var usersSelected;
            var arr = $('input.select-item:checkbox:checked').map(function () {
                return this.value;
            }).get();
            usersSelected = arr;
            $('.selectedUsers').tagsinput('removeAll');
            $('.selectedUsers').tagsinput('add', usersSelected.join());
        });
        //check selected items
        $("input.select-item").click(function () {
            //console.log("vvvvv");
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }


    });
    </script>
    <script type="text/javascript">
       <?php if($data['graphApiEnabled'] == 'false') { ?>
            $('#graphApiEnabledModal').modal('show');
        <?php } ?>
    </script>
