<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container" style="margin-left:0px !important;">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='productOverview'?></span>
	    <span class="reportProductType d-none"><?=$data['reportProductType']?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h3><?=$data['crumb1']?>
                        </h3>
                    </div>
                    <div class="panel-body">
<!--                        <div class="row">
                            <div class="col-lg-12">
                              <form ng-submit="searchUserInOverView(search.userName,search.searchPolicyName)">
                                    <div class="row">

<div class="col-lg-12" style="margin-bottom: 10px;">
    <label class="radio-inline">
      <input type="radio" name="userOption" value="policy" checked>Policy Name
    </label>
    <label class="radio-inline">
      <input type="radio" name="userOption" value="userNdDevice">User ID and Device name
    </label>
</div><br/>
<div class="col-lg-5" id="userNdDevice" style="display: none;">
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsername">User ID</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername"
                                                    id="searchUsername"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName">Device Name</label>
                                            <select class="searchDeviceName form-control" id="searchDeviceName" readonly>
                                                <option value="all">all</option>
                                            </select>
					</div>
</div>
                                    </div>

                                        <div class="col-lg-4" id="policy">
                                        <label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" id="searchPolicyName" name="searchPolicyName[]" id="searchPolicyName" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
                                            <option value="all" selected="selected">all</option>
                                                            <?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){ 
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                    <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>                 
                                        </div>
					<div class="col-lg-3" style="margin-top:35px;">
                                            <input class="isUserWithoutDeviceEnabled" id="isUserWithoutDeviceEnabled" type="checkbox" name="isUserWithoutDeviceEnabled" ng-model="search.isUserWithoutDeviceEnabled">
                                            <label for="isUserWithoutDeviceEnabled">Include Users without a device installed</label><br>
                                              
                                            <input class="showBlockedUsers ng-pristine ng-untouched ng-valid" id="showBlockedUsers" type="checkbox" name="showBlockedUsers" checked>
                                            <label for="showBlockedUsers">Include blocked users</label><br>

                                            <input class="showBlockedDevices ng-pristine ng-untouched ng-valid" id="showBlockedDevices" type="checkbox" name="showBlockedDevices" checked>
                                            <label for="showBlockedDevices">Include blocked devices</label>
                                         </div>
                                        <div class="dropdown col-lg-4">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
                                            <button style="margin-top: 25px" class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadOverview(search.userName, search.deviceName, search.searchPolicyName)">Excel</a></li>
                                                <li><a ng-click="downloadOverviewPdf(search.userName, search.deviceName, search.searchPolicyName)">PDF</a></li>
                                              </ul>
					      <a title="Schedule" class="btn btn-default" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendBackupOverviewReportTimer')" style="margin-top: 25px;"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="table-responsive">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table class="table-bordered overviewListTable" style="display: none;">
                            <div class="h4 noBackupOverviewData text-center" style="display: none;">No details found</div>
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'userId'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="overviewSortType == 'userId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'userId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email_address', 'keywords')?>
                                    <span ng-show="overviewSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="overviewSortType = 'userActive'; sortReverse = !sortReverse">
                                    <?=Language::show('User Status', 'keywords')?>
                                    <span ng-show="overviewSortType == 'userActive' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'userActive' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="overviewSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'deviceActive'; sortReverse = !sortReverse">
                                    <?=Language::show('Device Status', 'keywords')?>
                                    <span ng-show="overviewSortType == 'deviceActive' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'deviceActive' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'clientVersion'; sortReverse = !sortReverse">
                                    <?=Language::show('Client Version', 'keywords')?>
                                    <span ng-show="overviewSortType == 'clientVersion' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'clientVersion' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'policyName'; sortReverse = !sortReverse">
                                    <?=Language::show('Backup Policy Name', 'keywords')?>
                                    <span ng-show="overviewSortType == 'policyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'policyName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'odbPolicyName'; sortReverse = !sortReverse">
                                    <?=Language::show('Office 365 Policy Name', 'keywords')?>
                                    <span ng-show="overviewSortType == 'odbPolicyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'odbPolicyName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'isFirstBackupCompleted'; sortReverse = !sortReverse">
                                    <?=Language::show('Is First Backup Completed', 'keywords')?>
                                    <span ng-show="overviewSortType == 'isFirstBackupCompleted' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'isFirstBackupCompleted' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastSuccessfulBackupEndTimeInMillis'; sortReverse = !sortReverse">
                                    <?=Language::show('lastSuccessfulBackupEndTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'currentBkpStatus'; sortReverse = !sortReverse">
                                    <?=Language::show('currentBackupStatus', 'keywords')?>
                                    <span ng-show="overviewSortType == 'currentBkpStatus' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'currentBkpStatus' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'totalCurrentlyRunningBkpSizeInPer'; sortReverse = !sortReverse">
                                    <?=Language::show('currentBackupCompletionPercentage', 'keywords')?>
                                    <span ng-show="overviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'currentlyRunningBkpTotalSizeOfFilesInKB'; sortReverse = !sortReverse">
                                    <?=Language::show('Current Backup Size', 'keywords')?>
                                    <span ng-show="overviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'isBackupRunning'; sortReverse = !sortReverse">
                                    <?=Language::show('Is backup running', 'keywords')?>
                                    <span ng-show="overviewSortType == 'isBackupRunning' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'isBackupRunning' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastHeardTimeInMillis'; sortReverse = !sortReverse">
                                    <?=Language::show('lastHeardTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastHeardTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastHeardTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'storageUtilizedInKB'; sortReverse = !sortReverse">
                                    <?=Language::show('totalStorageUtilized', 'keywords')?>
                                    <span ng-show="overviewSortType == 'storageUtilizedInKB' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'storageUtilizedInKB' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'reason'; sortReverse = !sortReverse">
                                    <?=Language::show('Notes', 'keywords')?>
                                    <span ng-show="overviewSortType == 'reason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'reason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in overview | orderBy:overviewSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak >{{ value.userId }}</td>
                                <td class="text-center" ng-cloak>{{ value.emailId }}</td>
                                <td class="text-center" ng-cloak>{{ value.userActive }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-cloak>{{value.deviceActive}}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-if="!value.clientVersion" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.clientVersion" ng-cloak>{{ value.clientVersion }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-show="value.policyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.policyName != null" ng-cloak>{{ value.policyName }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <td class="text-center" ng-show="value.odbPolicyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.odbPolicyName != null" ng-cloak>{{ value.odbPolicyName }}</td>
                                <?php } ?>
                                <td class="text-center" ng-cloak>{{ value.isFirstBackupCompleted }}</td>
                                <td class="text-center" ng-if="!value.lastSuccessfulBackupEndTime" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.lastSuccessfulBackupEndTime" ng-cloak>{{ value.lastSuccessfulBackupEndTime }}</td>
                                <td class="text-center" ng-if="!value.currentBkpStatus" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.currentBkpStatus" ng-cloak>{{ value.currentBkpStatus }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalCurrentlyRunningBkpSizeInPer }}</td>
                                <td class="text-center" ng-cloak>{{ value.currentlyRunningBkpTotalSizeOfFiles }}</td>
                                <td class="text-center" ng-cloak>{{ value.isBackupRunning }}</td>
                                <td class="text-center" ng-show="value.lastHeardTime == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.lastHeardTime != ''" ng-cloak>{{ value.lastHeardTime }}</td>
                                <td class="text-center" ng-show="value.storageUtilized == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.storageUtilized != ''" ng-cloak>{{ value.storageUtilized }}</td>
                                <td class="text-center" ng-if="!value.reason" ng-cloak> - </td>
                                <td class="text-center"  ng-if="value.reason" ng-cloak>{{ value.reason }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="row overviewListTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
		    </div>-->
<!--filters start-->
<div class="row">
                            <div class="col-lg-12">
                              <form ng-submit="updateProductOverview()">
                                    <div class="row">

<div class="col-lg-12" style="display:none;margin-bottom: 10px;">
    <label class="radio-inline">
      <input type="radio" name="userOption" value="policy" checked>Policy Name
    </label>
    <label class="radio-inline">
      <input type="radio" name="userOption" value="userNdDevice">User ID and Device name
    </label>
</div><br/>
<div class="col-lg-5" id="userNdDevice" style="display: none;">
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsername">User ID</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername"
                                                    id="searchUsername"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName">Device Name</label>
                                            <select class="searchDeviceName form-control" id="searchDeviceName" readonly>
                                                <option value="all">all</option>
                                            </select>
					</div>
</div>
                                    </div>

                                        <div class="col-lg-4" id="policy">
                                        <label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" id="searchPolicyName" name="searchPolicyName[]" id="searchPolicyName" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
                                            <option value="all" selected="selected">all</option>
                                                            <?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){ 
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                    <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>                 
					</div>
<div class="col-lg-3">
                                            <label for="noOfDays">Product Overview Report for last</label>
					    <input type="number" id="noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:5px;" value="30">
					    <label style="margin-top:12px;">days </label>
                                        </div>
                                        <div class="dropdown col-lg-4">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
                                            <button style="margin-top: 25px" class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadProductOverview()" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadProductOverviewPdf()" style="cursor:pointer;">PDF</a></li>
                                              </ul>
					      <a title="Schedule" class="btn btn-default" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendProductOverviewReportTimer')" style="margin-top: 25px;"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
<!--filters end-->
<center><span id="productOverviewSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
<div class="row productOverviewError" style="margin-left: 0px;margin-right: 0px;display:none;">
	<div class="h4 text-center" style="display: none">No details found</div>
</div>
<div class="row productOverview" style="margin-left: 0px;margin-right: 0px;display:none;">
<div class="col-lg-12 row">
<?php 
$timezone_offset_minutes = 330;
$timezone_name = timezone_name_from_abbr("", $timezone_offset_minutes*60, false);
?>
<div class="col-lg-12" style="padding:10px;"><h4>Timezone: <b><?=$timezone_name;?></b></h4></div>
</div>
<div class="col-lg-12 row" style="border: 1px solid #f27331;border-radius: 10px;overflow-y: scroll;height: 300px;">
<div class="col-lg-12" style="padding:10px;"><h4>License Information</h4></div>
<!--<div class="col-lg-6">
<p><b>Validity : </b><span> {{productOverviewLicense.validityPeriod}} </span></p>
</div>
<div class="col-lg-6">
<p><b>No. of MiniClouds Allowed : </b><span> {{productOverviewLicense.noOfMiniCloudsAllowed}} </span></p>
</div>
<div class="col-lg-6">
<p><b>Cloud Size Allowed : </b><span> {{productOverviewLicense.cloudSizeAllowed}} </span></p>
</div>
<div class="col-lg-6">
<p><b>Total No. of Users : </b><span> {{productOverviewLicense.totalUsers}} </span></p>
</div>
<div class="col-lg-6">
<p><b>No. of BluSync Users : </b><span> {{productOverviewLicense.noOfUsersAllowedWithSync}} </span></p>
</div>
<div class="col-lg-6">
<p><b>No. of BluVault Users : </b><span> {{productOverviewLicense.noOfUsersAllowedWithBackup}} </span></p>
</div>
<div class="col-lg-6">
<p><b>Content Search Allowed : </b><span ng-show="productOverviewLicense.contentSearchAllowed == 1" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.contentSearchAllowed == 0" ng-cloak> Disabled </span>
</div>
<div class="col-lg-6">
<p><b>Cloud Name : </b><span> {{productOverviewLicense.cloudName}} </span></p>
</div>
<div class="col-lg-6">
<p><b>No. of OneDrive for Business Backup Users Allowed : </b><span> {{productOverviewLicense.noOfOneDriveUsersAllowed}} </span></p>
</div>
<div class="col-lg-6">
<p><b>No. of Microsoft Exchange Backup Users Allowed : </b><span> {{productOverviewLicense.noOfExchangeUsersAllowed}} </span></p>
</div>
<div class="col-lg-6">
<p><b>BluVault : </b><span ng-show="productOverviewLicense.backupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.backupEnabled == false" ng-cloak> Disabled </span></p>
</div>
<div class="col-lg-6">
<p><b>BluSync : </b><span ng-show="productOverviewLicense.syncEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.syncEnabled == false" ng-cloak> Disabled </span></p>
</div>
<div class="col-lg-6">
<p><b>OneDrive for Business Backup : </b><span ng-show="productOverviewLicense.oneDriveBackupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.oneDriveBackupEnabled == false" ng-cloak> Disabled </span></p>
</div> 
<div class="col-lg-6">
<p><b>Microsoft Exchange Backup : </b><span ng-show="productOverviewLicense.exchangeBackupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.exchangeBackupEnabled == false" ng-cloak> Disabled </span></p>
</div>
<div class="col-lg-6">
<p><b>Malware Scan : </b><span ng-show="productOverviewLicense.antivirusLicense == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.antivirusLicense == false" ng-cloak> Disabled </span></p>
</div>
<div class="col-lg-6">
<p><b>SQL License : </b><span ng-show="productOverviewLicense.sqllicense == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.sqllicense == false" ng-cloak> Disabled </span></p>
</div>-->

<ul style="list-style:none;">
<li><b>Cloud Name : </b><span> {{productOverviewLicense.cloudName}} </span></li>
<li><b>Validity : </b><span> {{productOverviewLicense.validityPeriod}} </span></li>
<li><b>Cloud Size Allowed : </b><span> {{productOverviewLicense.cloudSizeAllowed}} GB</span></li>
<!--<li><b>Total No. of Users : </b><span> {{productOverviewLicense.totalUsers}} </span></li>-->
<li><b>BluVault : </b><span ng-show="productOverviewLicense.backupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.backupEnabled == false" ng-cloak> Disabled </span></li>
<li><b>No. of BluVault Users Allowed : </b><span> {{productOverviewLicense.noOfUsersAllowedWithBackup}} </span></li>
<li><b>BluSync : </b><span ng-show="productOverviewLicense.syncEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.syncEnabled == false" ng-cloak> Disabled </span></li>
<li><b>No. of BluSync Users Allowed : </b><span> {{productOverviewLicense.noOfUsersAllowedWithSync}} </span></li>
<li><b>No. of MiniClouds Allowed : </b><span> {{productOverviewLicense.noOfMiniCloudsAllowed}} </span></li>
<li><b>OneDrive for Business Backup : </b><span ng-show="productOverviewLicense.oneDriveBackupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.oneDriveBackupEnabled == false" ng-cloak> Disabled </span></li>
<li><b>No. of OneDrive for Business Backup Users Allowed : </b><span> {{productOverviewLicense.noOfOneDriveUsersAllowed}} </span></li>
<li><b>Microsoft Exchange Backup : </b><span ng-show="productOverviewLicense.exchangeBackupEnabled == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.exchangeBackupEnabled == false" ng-cloak> Disabled </span></li>
<li><b>No. of Microsoft Exchange Backup Users Allowed : </b><span> {{productOverviewLicense.noOfExchangeUsersAllowed}} </span></li>
<li><b>Content Search Allowed : </b><span ng-show="productOverviewLicense.contentSearchAllowed == 1" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.contentSearchAllowed == 0" ng-cloak> Disabled </span></li>
<li><b>Malware Scan : </b><span ng-show="productOverviewLicense.antivirusLicense == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.antivirusLicense == false" ng-cloak> Disabled </span></li>
<li><b>SQL License : </b><span ng-show="productOverviewLicense.sqllicense == true" ng-cloak> Enabled </span><span ng-show="productOverviewLicense.sqllicense == false" ng-cloak> Disabled </span></li>
</ul>

</div>
</br>

<div class="col-lg-12 row" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>License Consumption</h4></div>
<div class="col-lg-12">
<table class="table-bordered" style="width: 100%;">
         <thead>
		<tr>
			<th class="text-center">License</th>
			<th class="text-center">Total</th>
			<th class="text-center">Active</th>
		</tr>
	</thead>
 	<tbody>
 	<tr class="text-center">
         <td>Users</td> <td>{{productOverviewLicense.totalUsers}}</td> <td>{{productOverviewLicense.totalActiveUsers}}</td>
        </tr>
        <tr class="text-center">
        <td>Devices</td> <td>{{productOverviewLicense.totalDevices}}</td> <td>{{productOverviewLicense.totalActiveDevices}}</td>
        </tr>
        <tr class="text-center">
        <td>Backup Users</td> <td>{{productOverviewLicense.totalBackupUsers}}</td> <td>{{productOverviewLicense.activeBackupUsers}}</td>
        </tr>
        <tr class="text-center">
        <td>Sync Users</td> <td>{{productOverviewLicense.totalSyncUser}}</td> <td>{{productOverviewLicense.activeSyncUser}}</td>
        </tr>
        <tr class="text-center">
        <td>OneDrive for Backup Users</td> <td>{{productOverviewLicense.totalOneDriveUsers}}</td> <td>{{productOverviewLicense.activeOneDriveUsers}}</td>
        </tr>
        <tr class="text-center">
        <td>Exchange Users</td> <td>{{productOverviewLicense.totalExchangeUsers}}</td> <td>{{productOverviewLicense.activeExchangeUsers}}</td>
        </tr>
         </tbody>
</table>
<br>
</div>
</div>

<!--<div class="col-lg-12 row" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-8" style="padding:10px;"><h4>Server Statistics</h4></div>
<div class="col-lg-8">
<table class="table-bordered" style="width: 100%;">
        <tbody>
        <tr class="text-center">
         <td>Total Users</td> <td>{{productOverviewLicense.totalUsers}}</td>
        </tr>
        <tr class="text-center">
        <td>Active Users</td> <td>{{productOverviewLicense.totalActiveUsers}}</td>
        </tr>
        <tr class="text-center">
        <td>Blocked Users</td> <td>{{productOverviewLicense.blockedUsers}}</td>
        </tr>
         </tbody>
</table>
<br>
</div>
</div>-->

<div class="col-lg-12 row" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Policy Statistics</h4></div>
<div class="col-lg-12">
<table class="table-bordered" style="width: 100%;">
<thead>
	<tr>
<th class="text-center clickAble" ng-click="productOverviewPSSortType = 'policygroupName'; sortReversePS = !sortReversePS">
Policy Name
<span ng-show="productOverviewPSSortType == 'policygroupName' && !sortReversePS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewPSSortType == 'policygroupName' && sortReversePS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewPSSortType = 'productType'; sortReversePS = !sortReversePS">
Product Type
<span ng-show="productOverviewPSSortType == 'productType' && !sortReversePS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewPSSortType == 'productType' && sortReversePS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewPSSortType = 'mappedUserCount'; sortReversePS = !sortReversePS">
No. of Users
<span ng-show="productOverviewPSSortType == 'mappedUserCount' && !sortReversePS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewPSSortType == 'mappedUserCount' && sortReversePS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewPSSortType = 'actualStorageUtilized'; sortReversePS = !sortReversePS">
Storage Usage (GB)
<span ng-show="productOverviewPSSortType == 'actualStorageUtilized' && !sortReversePS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewPSSortType == 'actualStorageUtilized' && sortReversePS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewPSSortType = 'totalSizeofDataBackedup'; sortReversePS = !sortReversePS">
Total Size of Backed Up Files (GB)
<span ng-show="productOverviewPSSortType == 'totalSizeofDataBackedup' && !sortReversePS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewPSSortType == 'totalSizeofDataBackedup' && sortReversePS" class="fa fa-caret-down"></span>
</th>
	</tr>
</thead>
<tbody>
	<tr ng-repeat="value in productOverviewPolicyElement | orderBy:productOverviewPSSortType:sortReversePS" class="text-center">
		<td>{{value.policygroupName}}</td>
		<td>{{value.productType}}</td>
		<td>{{value.mappedUserCount}}</td>
		<td ng-if="value.productType != 'BluSync'">{{value.actualStorageUtilized}}</td>
		<td ng-if="value.productType == 'BluSync'"> NA </td>
		<td ng-if="value.productType != 'BluSync'">{{value.totalSizeofDataBackedup}}</td>
		<td ng-if="value.productType == 'BluSync'"> NA </td>
	</tr>
</tbody>
</table>
<br>
</div>
</div>

<div class="col-lg-12 row" id="overviewParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Backup Overview</h4></div>
<div class="col-lg-12 h4 text-center" id="overviewErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="overviewTableDiv" style="overflow: scroll;display:none">
<table class="table-bordered" style="width: 100%;">
<thead>
<tr>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'userId'; sortReverse = !sortReverse">
<?=Language::show('userId', 'keywords')?>
<span ng-show="productOverviewSortType == 'userId' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'userId' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'emailId'; sortReverse = !sortReverse">
<?=Language::show('email_address', 'keywords')?>
<span ng-show="productOverviewSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'userActive'; sortReverse = !sortReverse">
<?=Language::show('User Status', 'keywords')?>
<span ng-show="productOverviewSortType == 'userActive' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'userActive' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'deviceName'; sortReverse = !sortReverse">
<?=Language::show('deviceName', 'keywords')?>
<span ng-show="productOverviewSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'deviceActive'; sortReverse = !sortReverse">
<?=Language::show('Device Status', 'keywords')?>
<span ng-show="productOverviewSortType == 'deviceActive' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'deviceActive' && sortReverse" class="fa fa-caret-down"></span>
</th>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'clientVersion'; sortReverse = !sortReverse">
<?=Language::show('Client Version', 'keywords')?>
<span ng-show="productOverviewSortType == 'clientVersion' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'clientVersion' && sortReverse" class="fa fa-caret-down"></span>
</th>
<?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'policyName'; sortReverse = !sortReverse">
<?=Language::show('Backup Policy Name', 'keywords')?>
<span ng-show="productOverviewSortType == 'policyName' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'policyName' && sortReverse" class="fa fa-caret-down"></span>
</th>
<?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'odbPolicyName'; sortReverse = !sortReverse">
<?=Language::show('Office 365 Policy Name', 'keywords')?>
<span ng-show="productOverviewSortType == 'odbPolicyName' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'odbPolicyName' && sortReverse" class="fa fa-caret-down"></span>
</th>
<?php } ?>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'isFirstBackupCompleted'; sortReverse = !sortReverse">
<?=Language::show('Is First Backup Completed', 'keywords')?>
<span ng-show="productOverviewSortType == 'isFirstBackupCompleted' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'isFirstBackupCompleted' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'lastSuccessfulBackupEndTimeInMillis'; sortReverse = !sortReverse">
<?=Language::show('lastSuccessfulBackupEndTime', 'keywords')?>
<span ng-show="productOverviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'currentBkpStatus'; sortReverse = !sortReverse">
<?=Language::show('currentBackupStatus', 'keywords')?>
<span ng-show="productOverviewSortType == 'currentBkpStatus' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'currentBkpStatus' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'totalCurrentlyRunningBkpSizeInPer'; sortReverse = !sortReverse">
<?=Language::show('currentBackupCompletionPercentage', 'keywords')?>
<span ng-show="productOverviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'currentlyRunningBkpTotalSizeOfFilesInKB'; sortReverse = !sortReverse">
<?=Language::show('Current Backup Size', 'keywords')?>
<span ng-show="productOverviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'isBackupRunning'; sortReverse = !sortReverse">
<?=Language::show('Is backup running', 'keywords')?>
<span ng-show="productOverviewSortType == 'isBackupRunning' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'isBackupRunning' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'lastHeardTimeInMillis'; sortReverse = !sortReverse">
<?=Language::show('lastHeardTime', 'keywords')?>
<span ng-show="productOverviewSortType == 'lastHeardTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'lastHeardTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'storageUtilizedInKB'; sortReverse = !sortReverse">
<?=Language::show('totalStorageUtilized', 'keywords')?>
<span ng-show="productOverviewSortType == 'storageUtilizedInKB' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'storageUtilizedInKB' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewSortType = 'reason'; sortReverse = !sortReverse">
<?=Language::show('Notes', 'keywords')?>
<span ng-show="productOverviewSortType == 'reason' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewSortType == 'reason' && sortReverse" class="fa fa-caret-down"></span>
</th>
        </tr>
</thead>
<tbody>
        <tr ng-repeat="value in overview | orderBy:productOverviewSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak >{{ value.userId }}</td>
                                <td class="text-center" ng-cloak>{{ value.emailId }}</td>
                                <td class="text-center" ng-cloak>{{ value.userActive }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-cloak>{{value.deviceActive}}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-if="!value.clientVersion" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.clientVersion" ng-cloak>{{ value.clientVersion }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-show="value.policyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.policyName != null" ng-cloak>{{ value.policyName }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <td class="text-center" ng-show="value.odbPolicyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.odbPolicyName != null" ng-cloak>{{ value.odbPolicyName }}</td>
                                <?php } ?>
                                <td class="text-center" ng-cloak>{{ value.isFirstBackupCompleted }}</td>
                                <td class="text-center" ng-if="!value.lastSuccessfulBackupEndTime" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.lastSuccessfulBackupEndTime" ng-cloak>{{ value.lastSuccessfulBackupEndTime }}</td>
                                <td class="text-center" ng-if="!value.currentBkpStatus" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.currentBkpStatus" ng-cloak>{{ value.currentBkpStatus }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalCurrentlyRunningBkpSizeInPer }}</td>
                                <td class="text-center" ng-cloak>{{ value.currentlyRunningBkpTotalSizeOfFiles }}</td>
                                <td class="text-center" ng-cloak>{{ value.isBackupRunning }}</td>
                                <td class="text-center" ng-show="value.lastHeardTime == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.lastHeardTime != ''" ng-cloak>{{ value.lastHeardTime }}</td>
                                <td class="text-center" ng-show="value.storageUtilized == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.storageUtilized != ''" ng-cloak>{{ value.storageUtilized }}</td>
                                <td class="text-center" ng-if="!value.reason" ng-cloak> - </td>
                                <td class="text-center"  ng-if="value.reason" ng-cloak>{{ value.reason }}</td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>

<div class="col-lg-12 row" id="failedBackupParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Failed Backup Status</h4></div>
<div class="col-lg-12 h4 text-center" id="failedBackupErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="failedBackupTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
<th class="text-center clickAble" ng-click="productOverviewFBSortType = 'userName'; sortReverseFB = !sortReverseFB">
<?=Language::show('userId', 'keywords')?>
<span ng-show="productOverviewFBSortType == 'userName' && !sortReverseFB" class="fa fa-caret-up"></span>
<span ng-show="productOverviewFBSortType == 'userName' && sortReverseFB" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewFBSortType = 'deviceName'; sortReverseFB = !sortReverseFB">
<?=Language::show('deviceName', 'keywords')?>
<span ng-show="productOverviewFBSortType == 'deviceName' && !sortReverseFB" class="fa fa-caret-up"></span>
<span ng-show="productOverviewFBSortType == 'deviceName' && sortReverseFB" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewFBSortType = 'startTimeInMillis'; sortReverseFB = !sortReverseFB">
<?=Language::show('startTime', 'keywords')?>
<span ng-show="productOverviewFBSortType == 'startTimeInMillis' && !sortReverseFB" class="fa fa-caret-up"></span>
<span ng-show="productOverviewFBSortType == 'startTimeInMillis' && sortReverseFB" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewFBSortType = 'whenFailedInMillis'; sortReverseFB = !sortReverseFB">
<?=Language::show('endTime', 'keywords')?>
<span ng-show="productOverviewFBSortType == 'whenFailedInMillis' && !sortReverse" class="fa fa-caret-up"></span>
<span ng-show="productOverviewFBSortType == 'whenFailedInMillis' && sortReverse" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewFBSortType = 'failedReason'; sortReverseFB = !sortReverseFB">
<?=Language::show('reason', 'keywords')?>
<span ng-show="productOverviewFBSortType == 'failedReason' && !sortReverseFB" class="fa fa-caret-up"></span>
<span ng-show="productOverviewFBSortType == 'failedReason' && sortReverseFB" class="fa fa-caret-down"></span>
</th>
        </tr>
</thead>
<tbody>
<tr ng-repeat="value in failedBackup | orderBy:productOverviewFBSortType:sortReverseFB" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-cloak>{{ value.startTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.whenFailed }}</td>
                                <td class="text-center" ng-cloak>{{ value.failedReason }}</td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>

<div class="col-lg-12 row" id="userBackupHistoryParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Last Backup Status</h4></div>
<div class="col-lg-12 h4 text-center" id="userBackupHistoryErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="userBackupHistoryTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'userName'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('userId', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'userName' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'userName' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'deviceName'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('deviceName', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'deviceName' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'deviceName' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'startTimeInMillis'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('startTime', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'startTimeInMillis' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'startTimeInMillis' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'endTimeInMillis'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('endTime', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'endTimeInMillis' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'endTimeInMillis' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'noOfFiles'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('Files Backed Up', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'noOfFiles' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'noOfFiles' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
<th class="text-center clickAble" ng-click="productOverviewLBSSortType = 'action'; sortReverseLBS = !sortReverseLBS">
<?=Language::show('Remarks', 'keywords')?>
<span ng-show="productOverviewLBSSortType == 'action' && !sortReverseLBS" class="fa fa-caret-up"></span>
<span ng-show="productOverviewLBSSortType == 'action' && sortReverseLBS" class="fa fa-caret-down"></span>
</th>
      </tr>
</thead>
<tbody>
<tr ng-repeat="value in userBackupHistory | orderBy:productOverviewLBSSortType:sortReverseLBS" class="text-center">
                                <td class="text-center" ng-show="value.userName != null" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-show="value.userName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.deviceName != null" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-show="value.deviceName == null" ng-cloak> - </td>
                                <td ng-cloak>{{ value.startTime }}</td>
                                <td ng-cloak>{{ value.endTime }}</td>
                                <td ng-cloak>{{ value.noOfFiles }}</td>
                                <td ng-cloak>{{ value.action }}</td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>



<div class="col-lg-12 row" id="restoreByDateParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Restore Activity</h4></div>
<div class="col-lg-12 h4 text-center" id="restoreByDateErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="restoreByDateTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
      <tr>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'userName'; sortReverseRA = !sortReverseRA">
                <?=Language::show('userId', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'userName' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'userName' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'deviceName'; sortReverseRA = !sortReverseRA">
                <?=Language::show('Source', 'keywords')?><br><span>DeviceName [Path]</span>
                <span ng-show="productOverviewRASortType == 'deviceName' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'deviceName' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoreByUserName'; sortReverseRA = !sortReverseRA">
                <?=Language::show('Restored By', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'restoreByUserName' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoreByUserName' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoreByDeviceName'; sortReverseRA = !sortReverseRA">
                <?=Language::show('Destination', 'keywords')?><br><span>DeviceName [Path]</span>
                <span ng-show="productOverviewRASortType == 'restoreByDeviceName' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoreByDeviceName' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoreTimeInMillis'; sortReverseRA = !sortReverseRA">
                <?=Language::show('restoredTime', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'restoreTimeInMillis' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoreTimeInMillis' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoreEndTimeInMillis'; sortReverseRA = !sortReverseRA">
                <?=Language::show('restoredEndTime', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'restoreEndTimeInMillis' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoreEndTimeInMillis' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoredFiles'; sortReverseRA = !sortReverseRA">
                <?=Language::show('filesRestored', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'restoredFiles' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoredFiles' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'restoredSizeInKB'; sortReverseRA = !sortReverseRA">
                <?=Language::show('restoredSize', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'restoredSizeInKB' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'restoredSizeInKB' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewRASortType = 'status'; sortReverseRA = !sortReverseRA">
                <?=Language::show('Status', 'keywords')?>
                <span ng-show="productOverviewRASortType == 'status' && !sortReverseRA" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewRASortType == 'status' && sortReverseRA" class="fa fa-caret-down"></span>
                </th>
      </tr>
</thead>
<tbody>
<tr ng-repeat="value in restoreByDate | orderBy:productOverviewRASortType:sortReverseRA" class="text-center">
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <td class="text-center" ng-show="value.userName != null" ng-cloak>{{ value.userName }}</td>
                                    <td class="text-center" ng-show="value.userName == null" ng-cloak> - </td>
                                <?php } ?>
                                <td class="text-center" ng-show="value.deviceName != null" ng-cloak>{{ value.deviceName }}<span ng-if="value.restoreFolder != ''"> [{{value.restoreFolder}}]</span></td>
                                <td class="text-center" ng-show="value.deviceName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.restoreByUserName != null" ng-cloak>{{ value.restoreByUserName }}</td>
                                <td class="text-center" ng-show="value.restoreByUserName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.restoreByDeviceName != null" ng-cloak>{{ value.restoreByDeviceName }}<span ng-if="value.destFolder != ''"> [{{value.destFolder}}]<span></td>
                                <td class="text-center" ng-show="value.restoreByDeviceName == null" ng-cloak> - </td>
<!--                                <td class="text-left" style="word-break: break-all;" ng-show="value.restoreFolder != null" ng-cloak>
                                    <li ng-repeat="parts in value.restoreFolder" ng-cloak>{{ parts }}</li>
                                </td>
                                <td class="text-center" style="word-break: break-all;" ng-show="value.restoreFolder == null" ng-cloak> - </td>-->
				<td class="text-center d-none" style="word-break: break-all;" ng-show="value.restoreFolder != null" ng-cloak>{{ value.restoreFolder }}</td>
                                <td class="text-center d-none" style="word-break: break-all;" ng-show="value.restoreFolder == null" ng-cloak> - </td>
                                <td class="text-center" ng-cloak>{{ value.restoreTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.restoreEndTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.restoredFiles }}</td>
				<?php if($data['reportProductType'] != 'office'){?>
                                	<td class="text-center" ng-show="value.restoredSize != null" ng-cloak>{{ value.restoredSize }}</td>
                                	<td class="text-center" ng-show="value.restoredSize == null" ng-cloak> - </td>
				<?php } ?>
				<td class="text-center" ng-show="value.status != null" ng-cloak>{{ value.status }}</td>
                                <td class="text-center" ng-show="value.status == null" ng-cloak> - </td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>


<div class="col-lg-12 row" id="blockedUsersParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Blocked Users</h4></div>
<div class="col-lg-12 h4 text-center" id="blockedUsersErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="blockedUsersTableDiv" style="overflow: scroll;display:none">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
                <th class="text-center clickAble" ng-click="productOverviewBUSortType = 'userName'; sortReverseBU = !sortReverseBU">
                <?=Language::show('userId', 'keywords')?>
                <span ng-show="productOverviewBUSortType == 'userName' && !sortReverseBU" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewBUSortType == 'userName' && sortReverseBU" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewBUSortType = 'displayName'; sortReverseBU = !sortReverseBU">
                <?=Language::show('Display Name', 'keywords')?>
                <span ng-show="productOverviewBUSortType == 'displayName' && !sortReverseBU" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewBUSortType == 'displayName' && sortReverseBU" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewSortType = 'emailId'; sortReverseBU = !sortReverseBU">
                <?=Language::show('email_address', 'keywords')?>
                <span ng-show="productOverviewSortType == 'emailId' && !sortReverseBU" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewSortType == 'emailId' && sortReverseBU" class="fa fa-caret-down"></span>
                </th>
        </tr>
</thead>
<tbody>
<tr ng-repeat="value in blockedUsers | orderBy:productOverviewBUSortType:sortReverseBU" class="text-center">
				<td class="text-center" ng-cloak>{{ value.userName }}</td>
				<td class="text-center" ng-if="value.displayName" ng-cloak>{{ value.displayName }}</td>
				<td class="text-center" ng-if="!value.displayName" ng-cloak> - </td>
                                <td class="text-center" ng-cloak>{{ value.emailId }}</td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>


<div class="col-lg-12 row" id="adminDetailsParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Administrator Details</h4></div>
<div class="col-lg-12 h4 text-center" id="adminDetailsErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="adminDetailsTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
		<th class="text-center clickAble" ng-click="productOverviewADSortType = 'userName'; sortReverseAD = !sortReverseAD">
                <?=Language::show('userId', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'userName' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'userName' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewADSortType = 'displayName'; sortReverseAD = !sortReverseAD">
                <?=Language::show('Display Name', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'displayName' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'displayName' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewADSortType = 'role'; sortReverseAD = !sortReverseAD">
                <?=Language::show('User Role', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'role' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'role' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewADSortType = 'emailId'; sortReverseAD = !sortReverseAD">
                <?=Language::show('email_address', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'emailId' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'emailId' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewADSortType = 'userName'; sortReverseAD = !sortReverseAD">
                <?=Language::show('Last Logged In Time', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'userName' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'userName' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewADSortType = 'userName'; sortReverseAD = !sortReverseAD">
                <?=Language::show('Policies Managed', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'userName' && !sortReverseAD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'userName' && sortReverseAD" class="fa fa-caret-down"></span>
                </th>
        </tr>
</thead>
<tbody>
<tr ng-repeat="value in adminDetails | orderBy:productOverviewADSortType:sortReverseAD" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-if="value.displayName" ng-cloak>{{ value.displayName }}</td>
                                <td class="text-center" ng-if="!value.displayName" ng-cloak> - </td>
<!--                                <td class="text-center"> <span ng-if="value.admin == true" ng-cloak>Administrator </span><span ng-if="value.readOnlyAdmin == true && value.delegatedAdmin == false" ng-cloak>Delegated Administrator </span><span ng-if="value.readOnlyAdmin == true && value.delegatedAdmin == true" ng-cloak>Read Only Administrator </span></td>-->
<td class="text-center" ng-cloak>{{ value.role }}</td>
                                <td class="text-center" ng-cloak>{{ value.emailId }}</td>
                                <td class="text-center" ng-cloak>{{ value.lastLoggedInTime }}</td>
                                <td class="text-center"><span ng-if="value.admin == true" ng-cloak> All </span> <span ng-if="value.readOnlyAdmin == true" ng-cloak>{{ value.backupPoliciesAdmin }} </span></td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>

<div class="col-lg-12 row" id="allBlockedDevicesParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Blocked Devices</h4></div>
<div class="col-lg-12 h4 text-center" id="allBlockedDevicesErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="allBlockedDevicesTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
                <th class="text-center clickAble" ng-click="productOverviewBDSortType = 'userName'; sortReverseBD = !sortReverseBD">
                <?=Language::show('userId', 'keywords')?>
                <span ng-show="productOverviewADSortType == 'userName' && !sortReverseBD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewADSortType == 'userName' && sortReverseBD" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewBDSortType = 'deviceName'; sortReverseBD = !sortReverseBD">
                <?=Language::show('Device Name', 'keywords')?>
                <span ng-show="productOverviewBDSortType == 'deviceName' && !sortReverseBD" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewBDSortType == 'deviceName' && sortReverseBD" class="fa fa-caret-down"></span>
                </th>
	</tr>
</thead>
<tbody>
<tr ng-repeat="value in allBlockedDevices | orderBy:productOverviewBDSortType:sortReverseBD" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <!--<td class="text-center" ng-cloak>{{ value.status }}</td>-->
                            </tr>
</tbody>
</table>
<br>
</div>
</div>

<div class="col-lg-12 row" id="userPolicyMappingElementListParentDiv" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Policy Mapping</h4></div>
<div class="col-lg-12 h4 text-center" id="userPolicyMappingElementListErrorDiv" style="display: none"><center>No records found</center></div>
<div class="col-lg-12" id="userPolicyMappingElementListTableDiv" style="overflow: scroll;display:none;">
<table class="table-bordered" style="width: 100%;">
<thead>
        <tr>
                <th class="text-center clickAble" ng-click="productOverviewPMSortType = 'policyName'; sortReversePM = !sortReversePM">
                <?=Language::show('Policy Name', 'keywords')?>
                <span ng-show="productOverviewPMSortType == 'policyName' && !sortReversePM" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewPMSortType == 'policyName' && sortReversePM" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewPMSortType = 'productType'; sortReversePM = !sortReversePM">
                <?=Language::show('Product Type', 'keywords')?>
                <span ng-show="productOverviewPMSortType == 'productType' && !sortReversePM" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewPMSortType == 'productType' && sortReversePM" class="fa fa-caret-down"></span>
                </th>
                <th class="text-center clickAble" ng-click="productOverviewPMSortType = 'policyName'; sortReversePM = !sortReversePM">
                <?=Language::show('Mapped Users', 'keywords')?>
                <span ng-show="productOverviewPMSortType == 'policyName' && !sortReversePM" class="fa fa-caret-up"></span>
                <span ng-show="productOverviewPMSortType == 'policyName' && sortReversePM" class="fa fa-caret-down"></span>
                </th> 
      </tr>
</thead>
<tbody>
<tr ng-repeat="value in userPolicyMappingElementList | orderBy:productOverviewPMSortType:sortReversePM" class="text-center">
                                <td ng-cloak>{{ value.policyName }}</td>
				<td ng-cloak>{{ value.productType}}</td>
				<td ng-cloak>{{ value.userNames }}</td>
                            </tr>
</tbody>
</table>
<br>
</div>
</div>


<!--exp start-->
<div class="col-lg-12 row hide" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Policy Statistics:</h4></div>
<div class="col-lg-12">
<span id="exp1result">Result 1</span>
<a class="btn btn-primary" ng-click="call1()">Call 1</a>
<br>
</div>
</div>

<div class="col-lg-12 row hide" style="border: 1px solid #f27331;border-radius: 10px;margin-top:10px;">
<div class="col-lg-12" style="padding:10px;"><h4>Policy Statistics:</h4></div>
<div class="col-lg-12">
<span id="exp2result">Result 2</span>
<a class="btn btn-primary" ng-click="call2()">Call 2</a>
<br>
</div>
</div>
<!--exp end-->
</div>
<!--confirm modal start-->
<div class="modal fade confirmChange" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Change</h4>
				</div>
                        <div class="modal-body">

                            <h4 class="modal-title">The username and device name you’ve picked will over-write the username and device name previously selected for this schedule.  Are you sure you wish to proceed?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="confirmChange()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->
<!--confirm modal start-->
<div class="modal fade confirmdelete" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                                <h4 class="modal-title">Are you sure you want to delete the selected schedule?</h4>

                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteSchedule()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->

<!--modal start-->
<div class="modal fade" id="scheduleModalList" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <div class="modal-header">
                    <h4 class="modal-title"><?=Language::show('List of Schedules', 'keywords')?></h4>
                </div>
                <div class="modal-body">
                    <div class="row schedulesNotFound" style="display: none;">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h2 align="center"><?=Language::show('No Schedules found !!!!!!', 'keywords');?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row schedulesFound" style="display: none;">
                        <div class="table-responsive col-lg-12 schedulesTable">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Schedule Name</th>
                                        <th>Schedule Time</th>
                                        <th>Recipient email IDs</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules">
                                        <td>{{value.scheduleName | limitTo:20}}{{value.scheduleName.length > 20 ? '...' : ''}}</td>
                                        <td>{{value.time}}</td>
                                        <td ng-if="value.allAdmins == 'false'" class="text-left" title="{{ value.emailIds }}" ng-cloak>{{ value.emailIds | limitTo:50}}{{value.emailIds.length > 50 ? '...' : ''}}</td>
                                        <td ng-if="value.allAdmins == 'true'" class="text-left" title="All admins" ng-cloak>All admins</td>
                                        <td>
                                            <a class="btn btn-small btn-success" ng-click="getSchedule(value.id)">Edit</a>
                                            <a class="btn btn-small btn-danger" ng-click="deleteScheduleConfirm(value.id, value.scheduleName)">Delete</a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
			<a href="" class="btn btn-success" ng-click="createSchedule()">Create New Schedule</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--modal ends -->
<!--modal start-->
    <div class="modal fade" id="createScheduleModal" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveScheduleProductOverview(search.userName,search.searchPolicyName)',
                            'class' => 'saveSchedule',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
                                <h4 class="modal-title"><?=Language::show('Schedule Settings', 'keywords')?></h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                            <p>
                                                Any saved schedules will need at least 5 minutes to take effect
                                            </p>
                                        </div>
                                    </div>
				</div>
<div class="col-lg-12">
                                <div class="row">
<div class="form-group col-lg-6">
<label for="searchPolicyName">Policy Name</label>
                 <select class="form-control selectPicker searchPolicyName1" id="searchPolicyName1" name="searchPolicyName[]" multiple  title='Select Backup Policy Name'>
<option value="all">all</option>
			 <?php if(!empty($data["backupPolicies"])) {?>
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
<!--<div class="form-group col-lg-6">
                                        <label for="noOfDays">Product Overview Report for last
                                        <input type="number" class="form-control" id="noOfDays1" min="1" placeholder="Number Of Days" data-parsley-trigger="change" style="margin-top:12px;" required> days </label>
				    </div>-->
<div class="col-lg-6">
                                            <label for="noOfDays1">Product Overview Report for last</label>
                                            <input type="number" name="noOfDays1" id="noOfDays1" min="1" placeholder="Number Of Days" data-parsley-trigger="change" value="30">
                                            <label style="margin-top:5px;">days </label>
                                        </div>
				    <div class="form-group col-lg-12 d-none">
                                        <label for="createdBy"><?=Language::show('createdBy', 'keywords')?></label>
                                            <input type="text" class="form-control" name="createdBy" id="createdBy" placeholder="" autocomplete="off">
				    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords')?></label>
                                        <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleType">Schedule Type :</label>
                                        <select class="form-control" name="scheduleType" id="scheduleType">
                                            <option value="choiceDays"><?=Language::show('Days', 'settings')?></option>
                                            <option value="choiceMonths"><?=Language::show('Months', 'settings')?></option>
                                            <option value="choiceTime"><?=Language::show('Run Once', 'settings')?></option>
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group col-lg-12 choiceDays">
					    <label  class="col-lg-12"><?=Language::show('days', 'keywords');?> -
                                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Every Day</a>
                                        <select class="form-control selectPickerSchedule" name="days[]" id="days" required="" multiple title='Select days'>
                                            <option value="SUN"><?=Language::show('sunday', 'keywords')?></option>
                                            <option value="MON"><?=Language::show('monday', 'keywords')?></option>
                                            <option value="TUE"><?=Language::show('tuesday', 'keywords')?></option>
                                            <option value="WED"><?=Language::show('wednesday', 'keywords')?></option>
                                            <option value="THU"><?=Language::show('thursday', 'keywords')?></option>
                                            <option value="FRI"><?=Language::show('friday', 'keywords')?></option>
                                            <option value="SAT"><?=Language::show('saturday', 'keywords')?></option>
                                        </select>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceMonths" style="display:none;">
                                        <label class="col-lg-12"><?=Language::show('Month', 'keywords');?> -
                                        <a href="javascript:;" class="monthDaily" ng-click="toggleSelectPickerAllMonths()">Every Month</a>
                                        <div class="col-lg-12">
                                            <div class="col-lg-6 form-group">
                                                <input type="number" min='1' max="31" class="form-control" name="dayOfMonth" id="dayOfMonth" placeholder="Enter Day of Month" disabled="disabled">
                                            </div>
                                            <div class="col-lg-6 form-group">
						    <select class="form-control selectPickerScheduleMonth" name="months[]" id="months" multiple title='Select months'>
                                                    <option value="JAN"><?=Language::show('January', 'keywords')?></option>
                                                    <option value="FEB"><?=Language::show('February', 'keywords')?></option>
                                                    <option value="MAR"><?=Language::show('March', 'keywords')?></option>
                                                    <option value="APR"><?=Language::show('April', 'keywords')?></option>
                                                    <option value="MAY"><?=Language::show('May', 'keywords')?></option>
                                                    <option value="JUN"><?=Language::show('June', 'keywords')?></option>
                                                    <option value="JUL"><?=Language::show('July', 'keywords')?></option>
                                                    <option value="AUG"><?=Language::show('August', 'keywords')?></option>
                                                    <option value="SEP"><?=Language::show('September', 'keywords')?></option>
                                                    <option value="OCT"><?=Language::show('October', 'keywords')?></option>
                                                    <option value="NOV"><?=Language::show('November', 'keywords')?></option>
                                                    <option value="DEC"><?=Language::show('December', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceTime" style="display:none;">
                                        <label class="col-lg-8"><?=Language::show('Run once', 'keywords');?>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="The schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control col-lg-4" name="date" id="date" placeholder="Enter Date" disabled="disabled">
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="scheduleStartTime"><?=Language::show('Schedule Time', 'keywords')?></label>
                                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                                    </div>
                                    <span class="d-none ownerFor" id="ownerFor"></span>
				</div>
</div>
                                <div class="row usersFound" id="usersFound" style="display: none;">
                                    <div class="table-responsive col-lg-4 usersTable">
					    <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" class="select-all checkbox d-none" name="select-all"/>
                                                </th>
                                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                                    <?=Language::show('Administrators', 'keywords')?>
                                                    <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                                    <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
						<tr>
                                                    <td class="text-center">
                                                        <input type="checkbox" class="select-item checkbox" name="allAdmins" id="allAdmins" value="All admins" ng-checked="value.allAdmins == 'true'"/>
                                                    </td>
                                                    <td class="text-left" title="All admins" ng-cloak>All admins</td>
                                                </tr>
                                                <tr ng-repeat="value in users">
                                                    <td class="text-center">
                                                    	<input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.emailId }}" ng-click="itemSelect(value.emailId)" ng-checked="value.isCheck == 'yes'"/>
                                                    </td>
                                                    <td class="text-left emailId-item" title="{{ value.emailId }}" ng-cloak>{{ value.emailId | limitTo:20}}{{value.emailId.length > 20 ? '...' : ''}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group row">
                                            <label for="selectedUsers"><?=Language::show('Email reports to', 'keywords');?></label><br/>
						<input type="text" data-role="tagsinput" value="" class="form-control selectedUsers" name="selectedUsers[]" id="selectedUsers" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Selected Users', 'keywords');?>" required autocomplete="off">
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createScheduleBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" id="closeScheduleModal" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!--modal ends -->
                </div>
            </div>
	</div>
    </div>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$("input:radio").change(function () {
        var val = $('input[name=userOption]:checked').val();
        var policyBlock = document.getElementById("policy");
        var userNdDeviceBlock = document.getElementById("userNdDevice");
        if (val == 'policy') {
            policyBlock.style.display = "block";
            userNdDeviceBlock.style.display = "none";
        } else {
            $('#searchPolicyName').selectpicker('render');
            $('#searchPolicyName option:selected').removeAttr('selected');
            $('#searchPolicyName').find('option[value="all"]').attr("selected",true);
            policyBlock.style.display = "none";
            userNdDeviceBlock.style.display = "block";
        }
});

$('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
//	document.getElementById("displayusername").innerHTML = $('#searchUsername1').val();
        if(users.devices != undefined) {
            if (users.devices.length > 0){
                $('.searchDeviceName').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('.searchDeviceName').html(options);
                $('.searchDeviceName').prepend('<option value="all" selected>all</option>');
            }else {
                $('.searchDeviceName').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }else{
            if(users.text == "all"){
                $('.searchDeviceName').html("<option selected>all</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
</script>
<style>
/*.modal {
  overflow-y:auto;
}*/
</style>
<script>
$('.timePicker').timepicker({
        showMeridian: false,
//        defaultTime: '9:45'
    });
    $('.selectPickerSchedule').selectpicker('render');
    $('.selectPickerScheduleMonth').selectpicker('render');
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});

var currentDate = new Date();
    //$('#date').datepicker('update', currentDate);

$('#scheduleType').on('change', function(){
    var choice = $('#scheduleType').val();
    if(choice == 'choiceDays'){
        $('.choiceDays').show();
        $('.choiceMonths').hide();
        $('.choiceTime').hide();
        $('#days').attr('required', 'required');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').prop('disabled', false);
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    } else if(choice == 'choiceTime') {
        $('.choiceTime').show();
        $('.choiceDays').hide();
        $('.choiceMonths').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#date').removeAttr('disabled');
        $('#days').removeAttr('required');
        $('#date').datepicker('update', currentDate);
        $('#days').prop('disabled', 'disabled');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    }else {
        $('.choiceMonths').show();
        $('.choiceDays').hide();
        $('.choiceTime').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').removeAttr('required');
        $('#days').prop('disabled', 'disabled');
        document.getElementById("months").disabled=false;
        $('#months').attr('required','required');
        $('#dayOfMonth').removeAttr('disabled');
        $('#dayOfMonth').attr('required','required');
    }
});
$('#date').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0m',
        //endDate: '-0d',
        todayHighlight: true
    });
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            console.log("chhhhh");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            console.log("all clicked");
            var usersSelected;
            var arr = $('input.select-item:checkbox:checked').map(function () {
                return this.value;
            }).get();
            usersSelected = arr;
                    $('.selectedUsers').tagsinput('removeAll');
            $('.selectedUsers').tagsinput('add', usersSelected.join());
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }


    });

    $("#closeScheduleModal").click(function() {
        $('#createScheduleModal').modal('hide');
    });

    (function(){
        $("#closeScheduleModal").on("hidden.bs.modal", function(){
            $(this).removeData();
        });
    });
    </script>
