<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=Language::show('BluSync Policies', 'syncPms')?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncPmsController">
    <span class="hide currentPage"><?='policy'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('BluSync Policies', 'syncPms')?><?php if($data['readOnlyAdminUser'] == 'No'){ ?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/sync/policy/create')?>"><?=Language::show('create_new_policy', 'keywords');?></a></span><?php } ?></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example syncPolicyTable" style="display: none;" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                </colgroup>
                                <thead>
                                <tr>
                                   <th class="text-left clickAble" ng-click="sortType = 'policygroupName'; sortReverse = !sortReverse">
                                    <?=Language::show('policyName', 'keywords')?>
                                    <span ng-show="sortType == 'policygroupName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'policygroupName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'maxVersionsForSort'; sortReverse = !sortReverse">
                                    <?=Language::show('maxVersions', 'keywords')?>
                                    <span ng-show="sortType == 'maxVersionsForSort' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'maxVersionsForSort' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'userSizeAllowed'; sortReverse = !sortReverse">
                                    <?=Language::show('userStorageQuota', 'keywords')?>
                                    <span ng-show="sortType == 'userSizeAllowed' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userSizeAllowed' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'mappedUserCount'; sortReverse = !sortReverse">
                                    <?=Language::show('No. of Users', 'keywords')?>
                                    <span ng-show="sortType == 'mappedUserCount' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'mappedUserCount' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'filterInclusionName'; sortReverse = !sortReverse">
                                    <?=Language::show('Filters', 'keywords')?>
                                    <span ng-show="sortType == 'filterInclusionName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'filterInclusionName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                   <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in policies | orderBy:sortType:sortReverse">
                                    <td title="{{ value.policygroupName}}" ng-if="value.blocked== false" ng-cloak>{{ value.policygroupName | limitTo:25}}{{value.policygroupName.length > 25 ? '...' : ''}}</td>
                                    <td ng-cloak ng-if="value.maxVersions > 0 && value.blocked== false">{{ value.maxVersions }}</td>
                                    <td ng-cloak ng-if="value.maxVersions < 0 && value.blocked== false">UNLIMITED</td>
                                    <td ng-cloak ng-show="value.userSizeAllowed < 102400 && value.blocked== false">{{ value.userSizeAllowed }}</td>
                                    <td ng-cloak ng-show="value.userSizeAllowed >= 102400 && value.blocked== false">UNLIMITED</td>
                                    <td ng-cloak>{{ value.mappedUserCount }}</td>
                                    <td ng-cloak>{{ value.filterInclusionName.join(', ') }}</td>
                                    <td ng-if="value.blocked== false">
                                        <?php if($data['V']  == true){ ?>
                                            <a title="View" class="toolTip" data-toggle="tooltip" data-placement="top" href="" ng-click="viewPolicy(value.policygroupName)" style="margin:5px;"><i class="fa fa-eye"></i> </a>
                                        <?php } ?>
					<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
                                        <?php if($data['ECD'] == true){ ?>
                                            <a ng-if="value.policygroupName != 'STAGING_SYNC_POLICY'" title="Edit" class="toolTip" data-toggle="tooltip" data-placement="top" href="<?=Url::basePath('pms/sync/policy/edit/{{value.policygroupName}}')?>" style="margin:5px;"><i class="fa fa-edit"></i> </a>
                                            <a ng-if="value.policygroupName != 'STAGING_SYNC_POLICY'" title="Clone" class="toolTip" data-toggle="tooltip" data-placement="top" href="<?=Url::basePath('pms/sync/policy/clone/{{value.policygroupName}}')?>" style="margin:5px;"><i class="fa fa-copy"></i> </a>
                                            <a ng-if="value.policygroupName != 'STAGING_SYNC_POLICY'" href="" title="Block" class="toolTip" data-toggle="tooltip" data-placement="top" ng-bootbox-confirm="<h4>Are you sure you want to block the selected policy?</h4>"
                                               ng-bootbox-confirm-action="blockPolicy(value.policygroupName)"
                                               ng-bootbox-confirm-action-cancel="" style="margin:5px;"><i class="fa fa-ban"></i> 
                                            </a>
                                       <?php } ?>
				       <?php } ?>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
		    <div class="row syncPolicyTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="getPolicesNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="getPolicesNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="getPolicesNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="getPolicesNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <div class="syncPolicyTableEmpty" style="display: none;">
                        <h2 class="-align-center"><?=Language::show('noPolicy', 'syncPms')?></h2>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="modal fade viewPolicy" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                        <div class="modal-header">
			    <h4 class="modal-title">View Policy</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <!-- start -->
                            <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='editPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group hide">
                                <div class="checkbox check-primary">
                                    <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                    <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                    <span class="systemFolders" style="display: none;">
                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" value="{{ selectedPolicy.policygroupName }}" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" readonly>
                                </br>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512" readonly></textarea>
                            </div>
                        </div>
                    </div>
                    
<!-- for mobile start-->
                        <?php if(isMobile()){ ?>
                            <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#contentSearch" aria-expanded="false" aria-controls="advanced">Search</a></li>
<?php } ?>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                            </ul>
                        <?php } ?>
                        <!-- for mobile end -->
                        <?php if(!isMobile()){ ?>
                            <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                                <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                                <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                                <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                            <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#contentSearch" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                                <li class="nav-item" role="presentation"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            </ul>
                        <?php } ?>
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                            <div class="row">
                                <div class="col-lg-12">
                                    <br/>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('BluSync Information', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group syncEnableAutomatic <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="syncEnableAutomatic"><?=Language::show('syncEnableAutomatic', 'keywords');?></label>
                                        <select class="form-control syncEnableAutomatic" name="syncEnableAutomatic" id="syncEnableAutomatic" required="" title='Select <?=Language::show('syncEnableAutomatic', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="syncInterval"><?=Language::show('syncInterval', 'keywords');?> (In Minutes)</label>
                                        <input type="text" class="form-control" name="syncInterval" id="syncInterval" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('syncInterval', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.syncInterval }}" disabled/>
                                    </div>
                                    <div class="form-group deDuplicationEnabled hide">
                                        <label for="deDuplicationEnabled"><?=Language::show('deDuplicationEnabled', 'keywords');?></label>
                                        <select class="form-control deDuplicationEnabled" name="deDuplicationEnabled" id="deDuplicationEnabled" required="" title='Select <?=Language::show('deDuplicationEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxFileSize"><?=Language::show('maxFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxFileSize" id="maxFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="userSizeAllowed"><?=Language::show('User Storage Quota', 'keywords');?> (In GB)</label>
<div class="row">
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="userSizeAllowed" id="userSizeAllowed" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userSizeAllowed', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
                                </div>
                            </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=$data['noOfDevicesAllowed']?>"/>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osType" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal" selected>Universal</option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cacheUsedData"><?=Language::show('cacheUsedData', 'keywords');?></label>
                                        <select class="form-control cacheUsedData" name="cacheUsedData" id="cacheUsedData" required="" title='Select <?=Language::show('cacheUsedData', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
					<label for="filtersType"><?=Language::show('Filter Type', 'keywords');?></label>
                                	<input type="text" class="form-control" name="filtersType1" id="filtersType1" readonly/>
				    </div>
				    <div class="row col-lg-12">
                                        <!--<label for="filters"><?=Language::show('filters', 'keywords');?></label>-->
					<h5 class="col-lg-2 inclusionBadge"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                        <h5 class="col-lg-2 exclusionBadge" style="display:none;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <input type="text" class="col-lg-10" name="filters" id="filters" readonly/>
                                    </div>				    
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                    <div class="col-lg-7 hide">
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('cloudCredentials', 'keywords');?></legend>
                                            <div class="form-group">
                                                <label for="ccS"><?=Language::show('cloudCredentials', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Create New <?=Language::show('cloudCredentials', 'keywords');?></a></label>
                                                 <input type="text" class="form-control" name="ccS" id="ccS" readonly/>
                                            </div>
                                    </div>
                                    <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultCloud != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-cloud"></i> Clouds</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <h5><?=Language::show('cloudName', 'settings');?>: {{ defaultCloud.cloudCredentialName }}</h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'azureBlob'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('azureBlob', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'ibmCloud'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('ibmSoftlayer', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'oneDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('microsoft', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'googleDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('googleDrive', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'amazon'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('amazonS3', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'localStorage'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('localStorage', 'settings');?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
<div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userCreateAdmins" name="createUser[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent', 'keywords')?></legend>
                                </div>
                                                                    <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('OPEN_SYNC_FOLDER', 'keywords');?></label>
                                            <select class="form-control opensyncfolder" name="opensyncfolder" id="opensyncfolder" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SYNC_FILES', 'keywords');?></label>
                                            <select class="form-control syncfiles" name="syncfiles" id="syncfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>                              
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SEARCH', 'keywords');?></label>
                                            <select class="form-control search" name="search" id="search" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                           <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                            <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                               <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                            <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>				    
                                        <div class="form-group">
                                        <label for="systrayIcon"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIcon" name="systrayIcon" id="systrayIcon" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>     
                                    </div>
                                    <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('INITIATE_SYNC', 'keywords');?></label>
                                            <select class="form-control initiatesync" name="initiatesync" id="initiatesync" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SYNC_SETTINGS', 'keywords');?></label>
                                            <select class="form-control syncsettings" name="syncsettings" id="syncsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>    
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('REFRESH_SYNC_POLICY', 'keywords');?></label>
                                            <select class="form-control refreshsyncpolicy" name="refreshsyncpolicy" id="refreshsyncpolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                            <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="about"><?=Language::show('ABOUT', 'keywords');?></label>
                                            <select class="form-control about" name="about" id="about" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                        <div class="form-group">
                                            <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                            <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" ><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                       <?php }?>
				       <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                            <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>                                       
                                    </div>
                            </div>
			    <div class="row">
                                <div class="col-lg-12">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                </div>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group CutCopyPaste">
                                            <label for="CutCopyPaste"><?=Language::show('Cut, Copy and Paste', 'keywords');?></label>
                                            <select class="form-control CutCopyPaste" name="CutCopyPaste" id="CutCopyPaste" required="" title='Select <?=Language::show('Cut', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
						<option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
					<div class="form-group createFolder">
                                            <label for="createFolder"><?=Language::show('Create Folder', 'keywords');?></label>
                                            <select class="form-control createFolder" name="createFolder" id="createFolderr" required="" title='Select <?=Language::show('Create Folder', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group delete">
                                            <label for="delete"><?=Language::show('Delete', 'keywords');?></label>
                                            <select class="form-control delete" name="delete" id="delete" required="" title='Select <?=Language::show('Delete', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group rename">
                                            <label for="rename"><?=Language::show('Rename', 'keywords');?></label>
                                            <select class="form-control rename" name="rename" id="rename" required="" title='Select <?=Language::show('Rename', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
					<div class="form-group fileUpload">
                                            <label for="fileUpload"><?=Language::show('File/Folder Upload', 'keywords');?></label>
                                            <select class="form-control fileUpload" name="fileUpload" id="fileUpload" required="" title='Select <?=Language::show('File Upload', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group createMinicloud">
                                            <label for="createMinicloud"><?=Language::show('Create MiniCloud', 'keywords');?></label>
                                            <select class="form-control createMinicloud" name="createMinicloud" id="createMinicloud" required="" title='Select <?=Language::show('Create MiniCloud', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                            	</div>
                            <div class="row shareDetailsLabel">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
				    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					    <div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabled" name="shareDomainsEnabled" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabled"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                            </div>
					    <div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusions"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusions" id="shareDomainIncExclusions" placeholder="" autocomplete="off" value="" readonly/>
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainType" id="only" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainType" id="withall" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains except these', 'keywords');?></label>
							</div>
						</div>
					    </div>
					    <div class="row">
                                                        <div class="form-group col-lg-6 shareDomainIncExclusionsExceptionDiv">
                                                                <label for="shareDomainIncExclusionsException"><?=Language::show('Allow sharing with the following Email addresses', 'keywords');?></label>
                                                                <a href="#" data-toggle="tooltip" data-placement="top" title="Email addresses specified in this list will always be considered valid recipients irrespective of domain control settings above."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                                <input type="text" class="form-control" name="shareDomainIncExclusionsException" id="shareDomainIncExclusionsException" placeholder="" autocomplete="off" value="" readonly/>
                                                        </div>
                                                </div>
                                        </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlock">
                                        	<label class="switch">
                                        		<input id="controllerSL" type="checkbox" name="controllerSL" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;margin-left: 25px;">Allow sharer visibility to the shared link</span>

				    </div>
				    <div class="form-group twoWayShareEnabled hide">
                                        <label for="twoWayShareEnabled"><?=Language::show('twoWayShareEnabled', 'keywords');?></label>
                                        <select class="form-control twoWayShareEnabled" name="twoWayShareEnabled" id="twoWayShareEnabled" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('twoWayShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                    
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-8 row">
                                                        <div class="col-lg-2 controllerMFABlock">
                                                                <label class="switch">
                                                                        <input id="controllerMFA" type="checkbox" name="controllerMFA" value="true">
                                                                        <div class="slider round"></div>
                                                                </label>
                                                        </div>
						<?php if(multifactorAuthWithAccessCode == true){?>
                                                        <span style="margin-top:5px;margin-left: 25px;">Mandate One Time Access Code authentication</span>
						<?php } else { ?>
                                                        <span style="margin-top:5px;margin-left: 25px;">Enable multi-factor authentication</span>
						<?php } ?>
                                                </div>
                                                <div class="col-lg-8 row <?php if(multifactorAuthWithAccessCode == true){?> hide <?php } ?>">
                                                        <div class="col-lg-2 controllerCPBlock">
                                                                <label class="switch">
                                                                        <input id="controllerCP" type="checkbox" name="controllerCP" value="true">
                                                                        <div class="slider round"></div>
                                                                </label>
                                                        </div>
                                                        <span style="margin-top:5px;margin-left: 25px;">Complex Password</span>
                                                </div>
						<div class="col-lg-4 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;margin-left: 52px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;margin-left: 25px;">Require Expiration Date for shared data</span>
						</div>						
					    </div>
					</div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="contentSearch">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                        <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        </legend>
                                        <div class="col-lg-6">
                                            <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                                <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                                <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-7">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Content Index Filters', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble hide" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                            <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
					    <input type="text" class="form-control" name="searchfiltersType" id="searchfiltersType1" readonly/>
					    <input type="text" class="form-control" name="searchFilterInclusionName" id="searchFilterInclusionName" readonly/>
                                            <!--<select class="form-control selectSearchFilterTypePicker" id="searchfiltersType" title='Select Filter Type'>
                                                <option value="inclusion">Inclusion</option>
                                                <option value="exclusion">Exclusion</option>
                                            </select>
                                                <select class="form-control selectSearchFilterPicker incSearch" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple>
                                                <?php if(!empty($data['IncFilters'])){ ?>
                                                    <?php foreach($data['IncFilters'] as $key => $value){ ?>
                                                        <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                                <select class="form-control selectSearchFilterPicker excSearch" name="searchfilters[]" id="searchfilters1" title='Select Filters' multiple>
                                               <?php if(!empty($data['ExcFilters'])){ ?>
                                                    <?php foreach($data['ExcFilters'] as $key => $value){ ?>
                                                        <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>-->
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <br/><br/>
                                        <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                        <div class="col-lg-12">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                    </div>
                                                    <div class="panel-body" style="word-break:break-all;">
                                                        <div class="table-responsive">
                                                        <table class="table table-bordered table-responsive" style="display: table;">
                                                            <tbody>
                                                            <tr ng-repeat="value in defaultSearchFilter">
                                                                <td style="white-space:unset !important;">
                                                                    <p><b>{{ value.filterName }} :</b></p>
                                                                    <span style="word-break:break-all;">{{value.filters}}</span>
                                                                </td>
                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>
                            
                              <div class="row hide">
                                    <div class="col-lg-7">
                                        <br/>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                            <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        </br>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                        <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunction();" disabled/>
                                        </div><span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>-->
					<div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" data-parsley-min="1" data-parsley-max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>
                                        <div class="form-group hide">
                                            <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                            <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <div class="form-group hide">
                                            <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                            <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        </br></br>
                                        <div class="row partialfileattributerow">
                                            <div class="col-lg-12">
                                                 <div class="panel panel-default">
                                                    <div class="panel-body">
                                                        <div class="form-group">
                                                            <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" readonly/>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" readonly/>
                                                        </div>
                                                    </div>
                                                 </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
				    <?php if($data['isAVScanEnabled'] == 'true'){ ?>
					<div class="col-lg-6 row">
						<span style="margin-top:5px;">Malware Scan during file upload</span>
						<div class="col-lg-2 enableAVScanBlock">
							<label class="switch">
								<input id="enableAVScan" type="checkbox" name="enableAVScan" value="true" checked>
								<div class="slider round"></div>
							</label>
						</div>
                                        </div>
				    <?php } ?>	
                                    <div class="form-group dedup hide">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <input type="text" class="form-control" name="dedup" id="dedup" readonly/>
                                        </div>
                                   
                                   <div class="form-group hide">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <input type="text" class="form-control" name="searchAlgoForPg" id="searchAlgoForPg" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" id="Blukryptipaddress" readonly/>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" required="" readonly>
                                    </div>
                                    <div class="form-group hide">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                    <div class="form-group">
						<label class="col-lg-12" style="margin-left: -14px;" for="noOfDaysToPurgeFile"><?=Language::show('noOfDaysToPurgeFile', 'keywords');?></label>
						<div class="row">
							<div class="col-lg-2">
							    <label class="switch">
								<input id="switchtobedelete" type="checkbox">
								<div class="slider round"></div>
							    </label>
							</div>
							<div class="col-lg-8">
							    <input type="text" class="form-control" name="noOfDaysToPurgeFile" id="noOfDaysToPurgeFile" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('noOfDaysToPurgeFile', 'keywords');?>" required autocomplete="off" value="0" onfocusout="myFunctionFileDelete();"/>
							    <span id="filedeletrerror" style="color: #f55753;font-size: 0.9em;"></span>
							</div>
							<div class="col-lg-2" style="margin-top: 10px;">
								<label>days</label>
							</div>
						</div>
                                            </div>
                                </div>                        
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement', 'keywords')?></legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
                            </div>
                        </div>
                            <!-- end -->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>
                        </div>
                    </div>
                </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
	
    $("[data-toggle=tooltip]").tooltip({
    	placement: $(this).data("placement") || 'right'
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
h5{
color:black;
}
</style>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
