<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4.1
* @date 17/06/19
* @time 04:27 PM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                    <li><span><?='SharePoint Policy Mapping'?></span></li>
                    <li><span><?='Change Site Policy'?></span></li>
                </ol>
            </div>
            <div class="col-lg-6 d-none">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
                <span class="d-none currentPage"><?='singleSharepointPolicyMapping'?></span>
                <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?='Change Site Policy'?></h4>
		    </div>
<!--configuration starts-->
<!--added starts-->
                    <div class="usersFound">
			    <div class="table-responsive browsePathDivOnedrive col-lg-12">
				<div class="row col-lg-12 hide">
					<div class="checkbox check-primary">
                             			<input id="autoDiscover" name="autoDiscover" id="autoDiscover" type="checkbox" value="enabled">
                             			<label for="autoDiscover"><?=Language::show('Auto discover and configure SharePoint sites.', 'keywords');?></label>                             	
                             		</div>
				</div>
			        <div class="row col-lg-12">
                                <div class="col-lg-5" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead>
                                            <tr>
                                                <th></th>
						<th>SharePoint Sites</th>
<th>Policy Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in discoveredSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.userName }}"/>
                                                </td>
						<td ng-click="pickElement(value.userName, $index)" ng-cloak><span style="cursor: pointer;">{{ value.userName }}</span></td>
<td ng-cloak><span>{{ value.spPolicyName | limitTo:25}}{{value.spPolicyName.length > 25 ? '...' : ''}}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
				<div class="col-lg-2">
<center style="margin-top:50%;">
                                    <a ng-click="itemSelect1()" class="block btn btn-small btn-success" style="width: 50%;">><a>
				    <br>
				    <a ng-click="addAllName()" class="block btn btn-small btn-success" style="width: 50%;"> >><a>
				    <br>
                                    <a ng-click="removeName1()" class="block btn btn-small btn-danger" style="width: 50%;"><</a>
                                    <br>
				    <a ng-click="removeAllName()" class="block btn btn-small btn-danger" style="width: 50%;"><<</a>
</center>
                                </div>
                                <div class="col-lg-5" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="addedSites" class="table table-hover table-bordered">
                                        <thead ng-show="addedSites.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected SharePoint Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedSites.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="addedSites.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Selected Users</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="addedSites.length > 0">
                                            <tr ng-repeat="value1 in addedSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1.userName }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1.userName, $index)" ng-cloak><span style="cursor: pointer;">{{ value1.userName }}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-6">
				</div>
</div>
                            </div>
			    <div class="col-lg-12" style="margin-top:20px;">
<div class="row">
<div class="col-lg-6">
</div>
                                <div class="col-lg-6">
                                    <div class="form-group" style="margin-left:10%;">
                                        <!--<label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
					<input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">-->
					<label for="policyName"><?=Language::show('SharePoint Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
				</div>
<div class="col-lg-6">
</div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success btn-small pull-right"
                                        ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to map selected sites to the selected policy?', 'keywords')?></h4>"
                                        ng-bootbox-confirm-action="startSiteConfiguration()"
                                        ng-bootbox-confirm-action-cancel=""
					href="javascript:;" ><?=Language::show('Map policies', 'keywords');?></a>
<a class="btn btn-default btn-small pull-right" ng-click="sendMeTo('/pms')" style="margin-right:10px;">Cancel</a>
				</div>
</div>
                            </div>
                        </div>
                        <!--added ends-->
<!--configuration ends-->		    
                    <!--<div class="panel-body">
                        <div class="row">
                            <form class="col-lg-12" ng-submit="updateOfficePolicyMappingList(0, search.userName)">
                                <div class="col-lg-12">
                                    <input name="searchUsername"
                                           type="text"
                                           class="pull-right form-control"
                                           ng-model="search.userName"
                                           placeholder="Enter a list of comma separated sites or just type 'all' (for all sites) and hit enter to search"
                                           data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                           data-content="Entered sites were not found!!! "
                                        />
                                </div>
                            </form>
                        </div>
                        <br/>
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped userPolicyMappingListTable" style="display: none;">
                            <colgroup>
                                <col class="col-xs-3">
                                <col class="col-xs-5">
                                <col class="col-xs-3">
                            </colgroup>
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="sortTypeMapping = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Sites', 'keywords')?>
                                    <span ng-show="sortTypeMapping == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMapping == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortTypeMapping = 'backupPolicyName'; sortReverse = !sortReverse">
                                    <?=Language::show('policyName', 'keywords')?>
                                    <span ng-show="sortTypeMapping == 'backupPolicyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortTypeMapping == 'backupPolicyName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in userOneDrivePolicyMappingUsers | orderBy:sortTypeMapping:sortReverse" class="mappingRow{{$index}}">
                                <td class="userName" ng-cloak>{{ value.userName | limitTo:25}}{{value.userName.length > 25 ? '...' : ''}}
                                    <span id="actualUserName{{$index}}" class="hide actualUserName{{$index}}">{{value.userName}}</span>
                                </td>
                                <td class="policyName" ng-cloak style="white-space:unset !important;">
                                    <span>{{ value.spPolicyName | limitTo:25}}{{value.spPolicyName.length > 25 ? '...' : ''}}</span>
                                    <form style="display: none;">
                                        <select class="form-control" name="userPolicyMappingPolicyName{{$index}}" id="userPolicyMappingPolicyName{{$index}}" required="">
                                            <option ng-repeat="policy in userOneDrivePolicyMappingPolicies" value="{{ policy }}">{{ policy }}</option>
                                        </select>
                                    </form>
                                </td>
                                <td class="action" ng-cloak>
                                    <a class="edit btn btn-default btn-small" ng-click="showMappingList($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-success btn-small" ng-click="changeOfficePolicy($index,value.spPolicyName)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-danger btn-small" ng-click="cancelChangePolicy($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="row userPolicyMappingListTablePage" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                                <a class="btn btn-primary first" ng-click="updateOneDrivePolicyMappingListNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                                <a class="btn btn-primary previous" ng-click="updateOneDrivePolicyMappingListNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                                <a class="btn btn-primary next" ng-click="updateOneDrivePolicyMappingListNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                                <a class="btn btn-primary last" ng-click="updateOneDrivePolicyMappingListNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
                                    
