<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Share;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ShareController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;
    protected $_codeLength = 6;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('share');
        $this->_model = new Share();

    }

    /**
     * Below method gets the file details
     * and displays the option to Download or View
     *
     * @param $type
     * @param $key1
     * @param $key2
     * @param $key3
     * @param $key4
     */
    public function index($type, $key1, $key2, $key3, $key4){
	//if($_GET['guestUser'] == 'true'){
	    //if(multifactorAuthWithAccessCode == true){
            /*OTP start*/
              /*$headersOtp = array(
                        'clientType' => 'PORTAL',
                        'user-id' => $_GET['userName']
                );
                $resultOtp = $this->_model->generateOtp($headersOtp);
                if($resultOtp['status'] == 200){
                        $otpStatus = 'One Time Access Code generated.';
                        $headersMail = array(
                                'fileName' => $result['body']->{'file-name'},
                                'user-id' => $_GET['userName']
                        );
                        $resultMail = $this->_model->accesskeyMail($headersMail);
                        $this->log("RESULT MAIL : ".json_encode($resultMail),"info");
                }else{
                        $otpStatus = 'One Time Access Code generation failed.';
                }*/
                /*OTP end*/
            //}
		if(SHARE_LOGIN_CHECK == true){
		    $this->auth->loginCheck();
		}
		$stat = $this->collectStats();
		$hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);

		$headers = array(
		    'Content-Type'  => 'application/xml',
		    'osType'        => $this->getOS($_SERVER['HTTP_USER_AGENT']),
		    'browser'       => $_SERVER['SERVER_NAME'],
		    'ip'            => $hostname.' ('.$stat['remoteAdd'].')',
		    'key12'         => $key1,
		    'key14'         => $key2,
		    'key18'         => $key3,
		    'key20'         => $key4,
		    'isBackup'      => false
		);
		$this->session->put('savedFileHeaders', $headers);
		$result = $this->_model->getSharedFileDetails($headers);
	        $result2 = $this->_model->getSharedFileDetailsMultiple($headers);
		$secretKey = array();
		    $mailId = array();
		    $offerArray = array();
		if($result['body']->{'userGooglesecretkeyElement'}){
		    foreach($result['body']->{'userGooglesecretkeyElement'} as $key){
			$this->log("----key---".$key->{'googleSecretKey'}."-----value-----".$key->{'mailId'},"info");	
			if($key->{'googleSecretKey'} != ""){
			    $secretKey[] = $key->{'googleSecretKey'};
			}else{
			    $secretKey[] = "";
			}
			$mailId[] = $key->{'mailId'};
		    };
		}
		$backupID           = $result['header']->{'container'}['backupID'];
		$filePath           = $result['header']->{'container'}['filePath'];
		$syncRevisionId     = $result['header']->{'container'}['syncRevisionId'];
		$fileSize           = $result['header']->{'container'}['fileSize'];
		//if($result['status'] == 200){
		if($result2['status'] == 200){
		    if(multifactorAuthWithAccessCode == true && $result2['body']->{'share-info'}->{'googleAuthIsEnabled'} == 'true'){
			    /*OTP start*/
				$headersOtp = array(
					'clientType' => 'PORTAL',
					'user-id' => $_GET['userName']
				);
				$resultOtp = $this->_model->generateOtp($_GET['userName']);
				//$resultOtp = $this->_model->generateOtp($headersOtp);
				if($resultOtp['status'] == 200){
					$otpStatus = 'One Time Access Code generated.';
					$headersMail = array(
						'fileName' => $result['body']->{'file-name'},
						'user-id' => $_GET['userName']
					);
					$resultMail = $this->_model->accesskeyMail($result['body']->{'file-name'},$_GET['userName']);
					//$resultMail = $this->_model->accesskeyMail($headersMail);
					$this->log("RESULT MAIL : ".json_encode($resultMail),"info");
				}else{
					$otpStatus = 'One Time Access Code generation failed.';
				}
			    /*OTP end*/
		    }
		    $data['mailId'] = $mailId;
		    $data['toEmailList'] = implode(',', $mailId);
		    $data['secretKey'] = implode(',', $secretKey);
		    $data['title']          = $this->language->get('share');
		    $data['csrf_token']     = $this->setCSRFToken();
		    $data['cloudName']      = $this->session->get('cloudName');
		    $data['file']           = $result['body'];
		    $data['filePath']       = $filePath;
		    $data['backupID']       = $backupID;
		    $data['syncRevisionId'] = $syncRevisionId;
		    $data['fileSize']       = $fileSize;
		    $data['type']           = ($type == md5('protected')) ? 'password' : 'read';
		    $passwordProtected      = ($result['body']->{'is-password-protected'} == 'true') ? true : false;
		    $data['secretkey'] = $result['body']->{'secretkey'};
		    $data['mailIDWithGooglesecretkey'] = $result['body']->{'userGooglesecretkeyElement'};
		    $this->session->put('passwordProtected', $passwordProtected);
		    $this->session->put('passwordHash', (string)$result['body']->{'password-hash'});
		    $this->session->put('download', (string)$result['body']->{'is-download'});
		    $this->session->put('view', (string)$result['body']->{'is-view'});
		    $this->session->put('cloudName', (string)$result['body']->{'cloud-name'});
		    $data['gotUsername'] = $_GET['userName'];
                    $data['otpStatus'] = $otpStatus;
		    $data['multipleList'] = $result2['body']->{'share-info'};
                    $data['fileMultiple'] = $result2['body']->{'share-info'}[0];

		    View::renderTemplate('LoginHeader', $data);
		    View::render('share/share', $data);
		    View::renderTemplate('LoginFooter', $data);
		}else{
		    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

		    $data['title'] = $result['status'];
		    $data['error'] = "Oops! There was an error";

		    View::renderTemplate('header', $data);
		    View::render('error/404', $data);
		    View::renderTemplate('footer', $data);
		}
	/*}else{
		if($this->session->get('userName') != $_GET['userName']){
                        header('Location: '.Url::basePath('login'));
            		exit;
		}else{
			Url::redirect('share/filesSharedWithMe');
		}
    	}*/
    }
    
    public function indexView($type, $key1, $key2, $key3, $key4){
        if(SHARE_LOGIN_CHECK == true){
            $this->auth->loginCheck();
        }
        $stat = $this->collectStats();
        $hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
        $headers = array(
            'Content-Type'  => 'application/xml',
            'osType'        => $this->getOS($_SERVER['HTTP_USER_AGENT']),
            'browser'       => $_SERVER['SERVER_NAME'],
            'ip'            => $hostname.' ('.$stat['remoteAdd'].')',
            'key12'         => $key1,
            'key14'         => $key2,
            'key18'         => $key3,
            'key20'         => $key4,
            'isBackup'      => false
        );
        $this->session->put('savedFileHeaders', $headers);
        $result = $this->_model->getSharedFileDetails($headers);
        $backupID           = $result['header']->{'container'}['backupID'];
        $filePath           = $result['header']->{'container'}['filePath'];
        $syncRevisionId     = $result['header']->{'container'}['syncRevisionId'];
        $fileSize           = $result['header']->{'container'}['fileSize'];
        if($result['status'] == 200){
            $data['title']          = $this->language->get('share');
            $data['csrf_token']     = $this->setCSRFToken();
            $data['cloudName']      = $this->session->get('cloudName');
            $data['file']           = $result['body'];
            $data['filePath']       = $filePath;
            $data['backupID']       = $backupID;
            $data['syncRevisionId'] = $syncRevisionId;
            $data['fileSize']       = $fileSize;
            $data['type']           = ($type == md5('protected')) ? 'password' : 'read';
            $passwordProtected      = ($result['body']->{'is-password-protected'} == 'true') ? true : false;
            $this->session->put('passwordProtected', $passwordProtected);
            $this->session->put('passwordHash', (string)$result['body']->{'password-hash'});
            $this->session->put('download', (string)$result['body']->{'is-download'});
            $this->session->put('view', (string)$result['body']->{'is-view'});
            $this->session->put('cloudName', (string)$result['body']->{'cloud-name'});

            View::renderTemplate('LoginHeader', $data);
            View::render('share/shareView', $data);
            View::renderTemplate('LoginFooter', $data);
        }else{
            header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");
            $data['title'] = $result['status'];
            $data['error'] = "Oops! There was an error";

            View::renderTemplate('header', $data);
            View::render('error/404', $data);
            View::renderTemplate('footer', $data);
        }
    }

    /*public function checkPassword(){
        if(!empty($_POST['type'])){
            if($_POST['type'] == true){
                if($this->session->get('download') != true){
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Download is Not Enabled'
                    );
                    echo json_encode($result);
                }
            }else{
                if($this->session->get('view') != true){
                    $result = array(
                        'result' => 'fail',
                        'message' => 'View is Not Enabled'
                    );
                    echo json_encode($result);
                }
            }
        }
        if($this->session->get('passwordProtected') == true){
            if(!empty($_POST['password'])){
                if($this->session->get('passwordHash') == md5($_POST['password'])){
                    $result = array(
                        'result'    => 'success',
                        'message'   => 'Password authentication passed'
                    );
                    echo json_encode($result);
                }else{
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Password authentication failed'
                    );
                    echo json_encode($result);
                }
            }else{
                $result = array(
                    'result' => 'fail',
                    'message' => 'Password field was empty'
                );
                echo json_encode($result);
            }
        }elseif($this->session->get('passwordProtected') == false){
            $result = array(
                'result' => 'success',
                'message' => 'No Password is needed'
            );
            echo json_encode($result);
        }else{
            $result = array(
                'result' => 'fail',
                'message' => 'Did not get any command to proceed'
            );
            echo json_encode($result);
        }
    }*/
    
    public function checkPassword(){
        $result = array();
        if(!empty($_POST['type'])){
                if($_POST['type'] == true){
                        if($_POST['download'] != 'enabled'){
                            $this->log("Download is Not Enabled","info");
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Download is Not Enabled'
                    );
                }
                }else{
                        if($_POST['view'] != 'enabled'){
                            $this->log("View is Not Enabled","info");
                    $result = array(
                        'result' => 'fail',
                        'message' => 'View is Not Enabled'
                    );
                }
            }
        }
            if($_POST['passwordProtected'] == 'enabled'){
                    if(!empty($_POST['password'])){
                if($_POST['passwordHash'] == md5($_POST['password'])){
                    $result = array(
                        'result'    => 'success',
                        'message'   => 'Password authentication passed'
                    );
                }else{
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Password authentication failed'
                    );
                }
            }else{
                $result = array(
                    'result' => 'fail',
                    'message' => 'Password field was empty'
                );
            }
                    }elseif($_POST['passwordProtected'] == 'disabled'){
            $result = array(
                'result' => 'success',
                'message' => 'No Password is needed'
            );
        }else{
            $result = array(
                'result' => 'fail',
                'message' => 'Did not get any command to proceed'
            );
        }
            echo json_encode($result);
    }
    
    public function checkPasswordShareView(){
        $result = array(
        	'result'    => 'success',
        	'message'   => 'Password authentication passed'
        );
        echo json_encode($result);
    }

    public function download(){
        if(!empty($_GET['path']) && !empty($_GET['fileName']) && !empty($_GET['userName']) && !empty($_GET['syncRevisionId']) && !empty($_GET['password'])){
            $checkForShareWith = !empty($_GET['shareWith']) ? true : false;
            if($this->session->get('passwordProtected') == true && $checkForShareWith == false && $this->session->get('passwordHash') != md5($_GET['password'])){
                header('Location: '.Url::basePath('error/404'));
                exit;
            }
            $headers['file-name'] = $_GET['fileName'];
            $headers['file-path'] = $_GET['path'];
            $headers['userName'] = $_GET['userName'];
            $headers['syncRevisionId'] = $_GET['syncRevisionId'];
            $downloadResult = $this->_model->download($headers);
            if($downloadResult['code'] != 449){
                header("Pragma: public");
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private",false);
                header("Content-Type: application/octet-stream");
                header('Content-Disposition: attachment; filename="'.$_GET['fileName'].'"');
                header("Content-Transfer-Encoding: binary");
                header('Content-Length: '.$downloadResult['header']['file-size']);
                ob_clean();
                print $downloadResult['body'];
                exit;
            }else{
                header('Location: '.Url::basePath('sync/files'));
            }

        }else{
            header('Location: '.Url::basePath('error/404'));
        }
    }

    public function collectStats(){
        $browser = array(
            'version'   => '0.0.0',
            'majorver'  => 0,
            'minorver'  => 0,
            'build'     => 0,
            'name'      => 'unknown',
            'useragent' => ''
        );
        $browsers = array(
            'firefox', 'msie', 'opera', 'chrome', 'safari', 'mozilla', 'seamonkey', 'konqueror', 'netscape',
            'gecko', 'navigator', 'mosaic', 'lynx', 'amaya', 'omniweb', 'avant', 'camino', 'flock', 'aol'
        );
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $browser['useragent'] = $_SERVER['HTTP_USER_AGENT'];
            $user_agent = strtolower($browser['useragent']);
            foreach($browsers as $_browser) {
                if (preg_match("/($_browser)[\/ ]?([0-9.]*)/", $user_agent, $match)) {
                    $browser['name'] = $match[1];
                    $browser['version'] = $match[2];
                    @list($browser['majorver'], $browser['minorver'], $browser['build']) = explode('.', $browser['version']);
                    break;
                }
            }
        }
        $browserName = $browser['name'] .' - '. $browser['version'];
        if (getenv('HTTP_CLIENT_IP')){
            $ipAddress = getenv('HTTP_CLIENT_IP');
        }
        else if(getenv('HTTP_X_FORWARDED_FOR')) {
            $ipAddress = getenv('HTTP_X_FORWARDED_FOR');
        }
        else if(getenv('HTTP_X_FORWARDED')){
            $ipAddress = getenv('HTTP_X_FORWARDED');
        }
        else if(getenv('HTTP_FORWARDED_FOR')){
            $ipAddress = getenv('HTTP_FORWARDED_FOR');
        }
        else if(getenv('HTTP_FORWARDED')){
            $ipAddress = getenv('HTTP_FORWARDED');
        }
        else{
            $ipAddress = 'UNKNOWN';
        }
        $remote 	= $_SERVER['REMOTE_ADDR'] ;
        $language 	= $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        return array("ip" => $ipAddress,"remoteAdd" => $remote,
            "browser" => $browserName,"language" => $language);
    }

    public function getOS($user_agent) {
        $os_platform    =   "Unknown OS Platform";
        $os_array       =   array(
            '/windows nt 10/i'     =>  'Windows 10',
            '/windows nt 6.3/i'     =>  'Windows 8.1',
            '/windows nt 6.2/i'     =>  'Windows 8',
            '/windows nt 6.1/i'     =>  'Windows 7',
            '/windows nt 6.0/i'     =>  'Windows Vista',
            '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
            '/windows nt 5.1/i'     =>  'Windows XP',
            '/windows xp/i'         =>  'Windows XP',
            '/windows nt 5.0/i'     =>  'Windows 2000',
            '/windows me/i'         =>  'Windows ME',
            '/win98/i'              =>  'Windows 98',
            '/win95/i'              =>  'Windows 95',
            '/win16/i'              =>  'Windows 3.11',
            '/macintosh|mac os x/i' =>  'Mac OS X',
            '/mac_powerpc/i'        =>  'Mac OS 9',
            '/linux/i'              =>  'Linux',
            '/ubuntu/i'             =>  'Ubuntu',
            '/iphone/i'             =>  'iPhone',
            '/ipod/i'               =>  'iPod',
            '/ipad/i'               =>  'iPad',
            '/android/i'            =>  'Android',
            '/blackberry/i'         =>  'BlackBerry',
            '/webos/i'              =>  'Mobile'
        );
        foreach ($os_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $os_platform    =   $value;
            }
        }
        return $os_platform;
    }

    public function getBrowserDetails(){
        $u_agent = $_SERVER['HTTP_USER_AGENT'];
        $bname = 'Unknown';
        $platform = 'Unknown';
        $version= "";
        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        }
        elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        }
        elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }
        // Next get the name of the useragent yes seperately and for good reason
        if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent))
        {
            $bname = 'Internet Explorer';
            $ub = "MSIE";
        }
        elseif(preg_match('/Firefox/i',$u_agent))
        {
            $bname = 'Mozilla Firefox';
            $ub = "Firefox";
        }
        elseif(preg_match('/Chrome/i',$u_agent))
        {
            $bname = 'Google Chrome';
            $ub = "Chrome";
        }
        elseif(preg_match('/Safari/i',$u_agent))
        {
            $bname = 'Apple Safari';
            $ub = "Safari";
        }
        elseif(preg_match('/Opera/i',$u_agent))
        {
            $bname = 'Opera';
            $ub = "Opera";
        }
        elseif(preg_match('/Netscape/i',$u_agent))
        {
            $bname = 'Netscape';
            $ub = "Netscape";
        }
        // finally get the correct version number
        $known = array('Version', $ub, 'other');
        $pattern = '#(?<browser>' . join('|', $known) .
            ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }
        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
                $version= $matches['version'][0];
            }
            else {
                $version= $matches['version'][1];
            }
        }
        else {
            $version= $matches['version'][0];
        }
        // check if we have a number
        if ($version==null || $version=="") {
            $version="?";
        }
        return array(
            'userAgent' => $u_agent,
            'name'      => $bname,
            'version'   => $version,
            'platform'  => $platform,
            'pattern'    => $pattern
        );
    }

    public function checkIfFileShared(){
        //$headers = $this->session->get('savedFileHeaders');
        $stat = $this->collectStats();
        $hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
        if(multifactorAuthWithAccessCode == true){
		$headers = array(
		    'Content-Type'  => 'application/xml',
		    'osType'        => $this->getOS($_SERVER['HTTP_USER_AGENT']),
		    'browser'       => $_SERVER['SERVER_NAME'],
		    'ip'            => $hostname.' ('.$stat['remoteAdd'].')',
		    'key12'         => $_POST['key12'],
		    'key14'         => $_POST['key14'],
		    'key18'         => $_POST['key18'],
		    'key20'         => $_POST['key20'],
		    'isBackup'      => false,
		    'accessKey'     => $_POST['accessKey'],
		    'userId'        => $_POST['userId']
		);
        }else {
		$headers = array(
		    'Content-Type'  => 'application/xml',
		    'osType'        => $this->getOS($_SERVER['HTTP_USER_AGENT']),
		    'browser'       => $_SERVER['SERVER_NAME'],
		    'ip'            => $hostname.' ('.$stat['remoteAdd'].')',
		    'key12'         => $_POST['key12'],
		    'key14'         => $_POST['key14'],
		    'key18'         => $_POST['key18'],
		    'key20'         => $_POST['key20'],
		    'isBackup'      => false,
	    );
        }
        $headers['accessType'] = $_POST['accessType'];
	if(multifactorAuthWithAccessCode == false){
		if($_POST['googleAuth'] == 'enabled'){
			    $secretList = $_POST['secretKeyList'];
			    $this->log("got list : ".$_POST['secretKeyList'],"info");
			    $newsecretlist = explode(',',$secretList);
			    $this->log("newsecretlist : ".json_encode($newsecretlist),"info");
			    foreach ($newsecretlist as $value) {
				$this->log("LOOP of SECRET : ".$value,"info");
				$checkResult = $this->verifyCode($value, $_POST['accessKey'], 2);
				if($checkResult){
					$result1 = 'Success';
				}else{
					$result1 = 'Failed';
				}
				if($result1 == 'Success'){
					break;
				}

			    }
			    $this->log("resulttttttt after code verification : ".$result1,"info");
			    if($result1 != 'Success'){
				    $this->log("resulttttttt after code verificationlllllllllast : ".$result1,"info");
				    $result11 = array(
					'result' => 'fail',
					'message' => 'Multi-factor Authentication Code verification failed'
				    );
				    echo json_encode($result11);
				    exit();
			    }
		}
	}
        //$result = $this->_model->getSharedFileDetails2($headers,$_POST['accessKey'],$_POST['userId']);
	if(multifactorAuthWithAccessCode == false){
        	$_POST['accessKey'] = '';
        	$_POST['userId'] = '';
        	$result = $this->_model->getSharedFileDetails2Multiple($headers,$_POST['accessKey'],$_POST['userId']);
	}else{
        	$result = $this->_model->getSharedFileDetails2Multiple($headers,$_POST['accessKey'],$_POST['userId']);
	}
        if($result['status'] == 200){
            $result = array(
                'result'    => 'success',
                'message'   => 'Password authentication passed'
            );
            echo json_encode($result);
        }else if($result['status'] == 451){
            $result = array(
                'result'    => 'fail',
                'message'   => 'Entered One Time Access Code is incorrect.'
            );
            echo json_encode($result);
        }else{
            $result = array(
                'result'    => 'fail',
                'message'   => 'File has been unshared or provided link is not valid'
            );
            echo json_encode($result);
        }
    }
    
    public function qrcode($userName, $key){
            $data['title']          = $this->language->get('share');
	    $data['csrf_token']     = $this->setCSRFToken();
	    $data['userName'] = base64_decode($userName);
            $data['secret'] = $key;

            View::renderTemplate('LoginHeader', $data);
            View::render('share/qrcode', $data);
            View::renderTemplate('LoginFooter', $data);
    }

    public function checkMail(){
	    $email = $_POST['toEmailList'];
	    $this->log("1111emailId : ".json_encode($email),"info");
	    $newmail = explode(',',$email);
	    $this->log("mailId : ".json_encode($newmail),"info");
	    $index = 0;
	    $index1 = array_search($_POST['emailId'],array_values($newmail));
	    foreach($newmail as $value){
		    $this->log("valueee : ".$value."---POST MAIL ID : ".$_POST['emailId'],"info");
		    if($value == $_POST['emailId']){
			$found = 'yes';
			$result1 = array(
				'result' => 'success',
				'index' => $index,
				'message' => 'Email id verified.'
			);
		    }else{
			$found = 'no';
			$result1 = array(
				'result' => 'fail',
				'index'  => $index,
				'message' => 'Email id not verified.'
		    );
		    }		
		    if ($found == 'yes') {
			    break;
		    }
	    }                    
	    $this->log("GOT RESULT : ".$found,"info");
	    if($found == 'yes'){
		    $headers = array(
            		'mailId'  => $_POST['emailId'],
            		'mfaLink' => 'https://'.PARACLOUD_IP.'/portal/share/qrcode/'
        	);    
	    $result = $this->_model->sendQR($headers, $_POST['cloudName']);
            $this->log("RESULTTTTTT : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg'  => 'A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.'
                    );
                    echo json_encode($response);
		            exit;
		        case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.'
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
	    }else{
	    	$result = array(
                        'result' => 'fail',
			'msg' => 'A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.'
                        //'msg' => 'File not shared with this Email Id.'
                    );
                    echo json_encode($result);
                    exit();
	    }
    }
	
/*----------------------------------------*/
//protected $_codeLength = 6;

    /**
     * Create new secret.
     * 16 characters, randomly chosen from the allowed base32 characters.
     *
     * @param int $secretLength
     * @return string
     */
    public function createSecret($secretLength = 16){
        $validChars = $this->_getBase32LookupTable();
        unset($validChars[32]);

        $secret = '';
        for ($i = 0; $i < $secretLength; $i++) {
            $secret .= $validChars[array_rand($validChars)];
        }
        return $secret;
    }

    /**
     * Calculate the code, with given secret and point in time
     *
     * @param string $secret
     * @param int|null $timeSlice
     * @return string
     */
    public function getCode($secret, $timeSlice = null){
        if ($timeSlice === null) {
            $timeSlice = floor(time() / 30);
        }

        $secretkey = $this->_base32Decode($secret);

        // Pack time into binary string
        $time = chr(0).chr(0).chr(0).chr(0).pack('N*', $timeSlice);
        // Hash it with users secret key
        $hm = hash_hmac('SHA1', $time, $secretkey, true);
        // Use last nipple of result as index/offset
        $offset = ord(substr($hm, -1)) & 0x0F;
        // grab 4 bytes of the result
        $hashpart = substr($hm, $offset, 4);

        // Unpak binary value
        $value = unpack('N', $hashpart);
        $value = $value[1];
        // Only 32 bits
        $value = $value & 0x7FFFFFFF;

        $modulo = pow(10, $this->_codeLength);
        return str_pad($value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT);
    }
     /**
     * Get QR-Code URL for image, from google charts
     *
     * @param string $name
     * @param string $secret
     * @param string $title
     * @return string
     */
    public function getQRCodeGoogleUrl($name, $secret, $title = null) {
        $urlencoded = urlencode('otpauth://totp/'.$name.'?secret='.$secret.'');
    	if(isset($title)) {
                $urlencoded .= urlencode('&issuer='.urlencode($title));
        }
        return 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl='.$urlencoded.'';
    }
     /**
     * Check if the code is correct. This will accept codes starting from $discrepancy*30sec ago to $discrepancy*30sec from now
     *
     * @param string $secret
     * @param string $code
     * @param int $discrepancy This is the allowed time drift in 30 second units (8 means 4 minutes before or after)
     * @param int|null $currentTimeSlice time slice if we want use other that time()
     * @return bool
     */
    public function verifyCode($secret, $code, $discrepancy = 1, $currentTimeSlice = null){
        if ($currentTimeSlice === null) {
            $currentTimeSlice = floor(time() / 30);
        }
        for ($i = -$discrepancy; $i <= $discrepancy; $i++) {
            $calculatedCode = $this->getCode($secret, $currentTimeSlice + $i);
	    $this->log("CODE : ".json_encode($code),"info");
	    $this->log("getCODE : ".json_encode($calculatedCode),"info");
            if ($calculatedCode == $code ) {
		return true;
            }
        }
        return false;
    }

    /**
     * Set the code length, should be >=6
     *
     * @param int $length
     * @return GoogleAuthenticator
     */
    public function setCodeLength($length){
        $this->_codeLength = $length;
        return $this;
    }
     /**
     * Helper class to decode base32
     *
     * @param $secret
     * @return bool|string
     */
    protected function _base32Decode($secret){
        if (empty($secret)) return '';
        $base32chars = $this->_getBase32LookupTable();
        $base32charsFlipped = array_flip($base32chars);
        $paddingCharCount = substr_count($secret, $base32chars[32]);
        $allowedValues = array(6, 4, 3, 1, 0);
        if (!in_array($paddingCharCount, $allowedValues)) return false;
        for ($i = 0; $i < 4; $i++){
	if ($paddingCharCount == $allowedValues[$i] &&
                substr($secret, -($allowedValues[$i])) != str_repeat($base32chars[32], $allowedValues[$i])) return false;
        }
        $secret = str_replace('=','', $secret);
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i = $i+8) {
            $x = "";
            if (!in_array($secret[$i], $base32chars)) return false;
            for ($j = 0; $j < 8; $j++) {
                $x .= str_pad(base_convert(@$base32charsFlipped[@$secret[$i + $j]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
            $eightBits = str_split($x, 8);
            for ($z = 0; $z < count($eightBits); $z++) {
                $binaryString .= ( ($y = chr(base_convert($eightBits[$z], 2, 10))) || ord($y) == 48 ) ? $y:"";
            }
        }
        return $binaryString;
    }

    /**
     * Helper class to encode base32
     *
     * @param string $secret
     * @param bool $padding
     * @return string
     */
    protected function _base32Encode($secret, $padding = true){
        if (empty($secret)) return '';
        $base32chars = $this->_getBase32LookupTable();
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i++) {
	$binaryString .= str_pad(base_convert(ord($secret[$i]), 10, 2), 8, '0', STR_PAD_LEFT);
        }
        $fiveBitBinaryArray = str_split($binaryString, 5);
        $base32 = "";
        $i = 0;
        while ($i < count($fiveBitBinaryArray)) {
            $base32 .= $base32chars[base_convert(str_pad($fiveBitBinaryArray[$i], 5, '0'), 2, 10)];
            $i++;
        }
        if ($padding && ($x = strlen($binaryString) % 40) != 0) {
            if ($x == 8) $base32 .= str_repeat($base32chars[32], 6);
            elseif ($x == 16) $base32 .= str_repeat($base32chars[32], 4);
            elseif ($x == 24) $base32 .= str_repeat($base32chars[32], 3);
            elseif ($x == 32) $base32 .= $base32chars[32];
        }
        return $base32;
    }
     /**
     * Get array with all 32 characters for decoding from/encoding to base32
     *
     * @return array
     */
    protected function _getBase32LookupTable()
    {
        return array(
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', //  7
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', // 15
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', // 23
            'Y', 'Z', '2', '3', '4', '5', '6', '7', // 31
            '='  // padding char
        );
    }
/*----------------------------------------*/
	
    public function generateOtp(){
        $headersOtp = array(
                        'clientType' => 'PORTAL',
                        'user-id' => $_POST['userName']
                );
                $resultOtp = $this->_model->generateOtp($_POST['userName']);
                if($resultOtp['status'] == 200){
                        $otpStatus = 'One Time Access Code generated.';
                        $result = array(
                                        'result'    => 'success',
                                        'message'   => 'One Time Access Code successfully generated.'
                                );
                        $headersMail = array(
                                'fileName' => $_POST['fileName'],
                                'user-id' => $_POST['userName']
                        );
                        $resultMail = $this->_model->accesskeyMail($_POST['fileName'], $_POST['userName']);
                        $this->log("RESULT MAIL : ".json_encode($resultMail),"info");
                        if($resultMail['status'] == 200){
                                $result = array(
                                        'result'    => 'success',
                                        'message'   => 'One Time Access Code successfully send to the registered emailId.'
                                );
                        }else{
                                $result = array(
                                        'result'    => 'fail',
                                        'message'   => 'Failed to send One Time Access Code.'
                                );
                        }
                }else{
                        $otpStatus = 'One Time Access Code generation failed.';
                        $result = array(
                                        'result'    => 'fail',
                                        'message'   => 'Failed to send One Time Access Code.'
				);
                }
                echo json_encode($result);
    }
	
    public function getSharedFilesList(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'            => 'application/json',
                'token'             => $this->session->get('token'),
                'shared-backup-image-ids'              => $_POST['id'],
                'destination-collection' => $_POST['destinationCollection'],
		'share-latest-version' => $_POST['isShareLatestVersion']
            );
            $result = $this->_model->getSharedFilesList($headers);
            $this->log("SHARED FILE LIST -> ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
		    $items = array();
		    $this->log("file-names : ".json_encode($result['header']->{'container'}['file-names']),"info");
		    if(!empty($result['body']->{'sharedFileImageElementList'})){
                    	foreach($result['body']->{'sharedFileImageElementList'} as $value){
                        	$file = array(
                                	'fileName' => (string)$value->{'fileName'},
                                	'backupId' => (string)$value->{'backupId'},
                                	'devicePath' => $_POST['devicePath'],
                                	'userName' => $_POST['userName'],
                                	'extension' => pathinfo((string)$value->{'fileName'}, PATHINFO_EXTENSION),
                                	'gatewayName' => $_POST['gatewayName'],
					'isView' => $_POST['isView'],
                                        'isDownload' => $_POST['isDownload']
                        	);
                        	$items = array_merge(array($file), $items);
                    	}
		    }
                    $response = array(
                            'result' => 'success',
			    'items' => $items,
                            'fileNames' => explode("|",base64_decode($result['header']->{'container'}['file-names']))
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (411):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('411')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

}
