#!/bin/bash
# DEVELOPER: Vaibhav K

PARABLU_CONFIG_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_component_config.sh
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

# Functions
function service_stop_status ()
{

if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then
        echo 'use parablu001

db.PRIVACY_GATEWAY.find({"gatewayName" : "GATEWAY_NAME"}).forEach(function(e) {print("SERVICESTOP=" +e.isActive)})' >capture_servicestop.js

        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" capture_servicestop.js

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_servicestop.js > capture_servicestop

        SERVICESTOP=`grep "SERVICESTOP" capture_servicestop`
        BK_ACTIVE=$( echo $SERVICESTOP | sed -e 's/SERVICESTOP=//')
else

        ###OTHER SERVERS
        #BK_ACTIVE=true
        echo "NOT BLUKRYPT SERVER"
fi

}

function disk_check ()
{

        service_stop_status

if [ "$BK_ACTIVE" != "false" ]; then
        for wc_disc in ${WATCHDOG_DISK[@]}
        do
               MEMORY_USED_INSLASH=$(df -h $wc_disc | tail -1 | awk '{print $5}')
               MAX_MEMORY_LIMIT="90%"
               if [[ ${MEMORY_USED_INSLASH%?} -ge ${MAX_MEMORY_LIMIT%?} ]];then
		       echo "MongoDump Exited due to Insufficient space"
                        exit
               fi

              if [[ ${MEMORY_USED_INSLASH%?} -lt ${MAX_MEMORY_LIMIT%?} ]];then
		       isclusterdeployed
                       #dbdump
		       rm -rf /parablu/log/mongodb/mgbfull.log
              fi
      done
fi
}

function isclusterdeployed ()
{

        if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] ||  [ "$SERVER_TYPE" == "3 1" ]; then

                echo 'db.isMaster()' > cluster.js
                dbport=$(grep port: /etc/mongod.conf)
                MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < cluster.js > cluster.log
                value=`less cluster.log | grep "secondary" |  sed 's/^.*:/:/' | sed s/://g | sed s/,//g | sed s/" "/""/g`
                 if [[ $value == "true" ]]; then
                        echo "Mongo Cluster Deployed Secondary Environment. Running backup from secondary server"
                  else
                        echo "Not a cluster deployed environment so running normally"

                fi

       fi
}

function check_pgoverload ()
{

echo 'use parablu001

db.PRIVACY_GATEWAY.find({"gatewayName" : "GATEWAY_NAME"}).forEach(function(e) {print("PGOVERLOADLIMIT=" +e.componentsProperties.pgOverloadLimit)})' >capture_pgoverloadlimit.js

        sed -i "s|GATEWAY_NAME|$BLUVAULT_IP|g" capture_pgoverloadlimit.js

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_pgoverloadlimit.js > capture_pgOverloadLimit

        PGOVERLOADLIMIT=`grep "PGOVERLOADLIMIT" capture_pgOverloadLimit`
        PGOVERLOADLIMIT_VAL=$( echo $PGOVERLOADLIMIT | sed -e 's/PGOVERLOADLIMIT=//')
        MIN_PGLIMIT_LIMIT="0"
        PGLIMIT_MSG_BODY="PG OVERLOAD LIMIT IS: $PGOVERLOADLIMIT_VAL"
        if [[ ${PGOVERLOADLIMIT_VAL} == ${MIN_PGLIMIT_LIMIT} ]];then

                if [ "$SERVER_TYPE" == "0" ]; then

                    echo "PG OVERLOAD LIMIT IS SET TO "0" SO EXITING MONGODUMP" |& tee /parablu/log/mongodb/full.log
                    exit
               fi
        else
                echo "PG limit is fine"
        fi

}

setVariables () {

	# Username to access the mongo server e.g. dbuser. Unnecessary if authentication is off
	DBUSERNAME="neil"

	# Password to access the mongo server e.g. password. Unnecessary if authentication is off
	DBPASSWORD="parablu"

	# Database for authentication to the mongo server e.g. admin. Unnecessary if authentication is off
	DBAUTHDB="admin"

	# Host name (or IP address) of mongo server e.g localhost
	DBHOST="$1" 

	# Port that mongo is listening on
	dbport=$(grep port: /etc/mongod.conf)
        DBPORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')


	# Allow DBUSERNAME without DBAUTHDB
	REQUIREDBAUTHDB="no"

	# OPT string for use with mongodump
	OPT=""                                            

	# Use oplog for point-in-time snapshotting.
	OPLOG="no"

	# External DB Backup
        EXTERNAL_bACKUP="no"

        # External DB Backup Path
        EXTERNAL_DB_PATH="/parablu/PROD_CENTRAL_BACKUP/MONGO_BACKUPS/"

        # External DB SSh User
        EXTERNAL_DB_SSH_USER="root"

        # External DB IP
        EXTERNAL_DB_IP="192.168.144.4"

        # External DB Port
        EXTERNAL_DB_SSH_PORT="22"

	### Take value from Database
	echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKDIR=" +e.backupdir)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_ACHDIR=" +e.archivedir)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKID=" +e.backblaze_id)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_APPKEY=" +e.application_key)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BUCKET=" +e.backblaze_bucket)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_CUSTNAME=" +e.customer_name)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKBACKUP=" +e.backblaze_backup)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_ENCBKP=" +e.encrypt_backup)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_USERNAME=" +e.proxyUserName)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PORT=" +e.proxyPort)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_HOST=" +e.proxyHost)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PASSWORD=" +e.proxyPassword)})' >mongoproperties.js

	cp mongoproperties.js mongoproperties_install.js
	sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < mongoproperties_install.js > mongo_properties

	BACKUPDIR_VAL=$(grep "P_BKDIR" mongo_properties | sed -e 's/P_BKDIR=//')
	ARCHIVEDIR_VAL=$(grep "P_ACHDIR" mongo_properties | sed -e 's/P_ACHDIR=//')
	BACKBLAZE_ID_VAL=$(grep "P_BKID" mongo_properties | sed -e 's/P_BKID=//')
	APPLICATION_KEY_VAL=$(grep "P_APPKEY" mongo_properties | sed -e 's/P_APPKEY=//')
	BACKBLAZE_BUCKET_VAL=$(grep "P_BUCKET" mongo_properties | sed -e 's/P_BUCKET=//')
	CLOUD_NAME_VAL=$(grep "P_CUSTNAME" mongo_properties | sed -e 's/P_CUSTNAME=//')
	BACKBLAZE_BACKUP_VAL=$(grep "P_BKBACKUP" mongo_properties | sed -e 's/P_BKBACKUP=//')
	ENCRYPT_BACKUP_VAL=$(grep "P_ENCBKP" mongo_properties | sed -e 's/P_ENCBKP=//')
	

	if [ "$BACKUPDIR_VAL" == "undefined" ]; then

                BACKUPDIR="/parablu/backup/mongodb"

        elif [ ! -z "$BACKUPDIR_VAL" ]; then

                BACKUPDIR=$BACKUPDIR_VAL

        else

                BACKUPDIR="/parablu/backup/mongodb"

        fi

        if [ "$ARCHIVEDIR_VAL" == "undefined" ]; then

                ARCHIVEDIR="/parablu/archive/mongodb_backup"

        elif [ ! -z "$ARCHIVEDIR_VAL" ]; then

                ARCHIVEDIR=$ARCHIVEDIR_VAL

        else

                ARCHIVEDIR="/parablu/archive/mongodb_backup"

        fi

	if [ "$BACKBLAZE_ID_VAL" == "undefined" ]; then

                BACKBLAZE_ID="43fee37666d9"

        elif [ ! -z "$BACKBLAZE_ID_VAL" ]; then

                BACKBLAZE_ID=$BACKBLAZE_ID_VAL

        else

                BACKBLAZE_ID="43fee37666d9"

        fi


	if [ "$APPLICATION_KEY_VAL" == "undefined" ]; then

	decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        elif [ ! -z "$APPLICATION_KEY_VAL" ]; then
                decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')

                APPLICATION_KEY=$decrypt_key_val

        else

                decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        fi

	if [ "$BACKBLAZE_BUCKET_VAL" == "undefined" ]; then

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        elif [ ! -z "$BACKBLAZE_BUCKET_VAL" ]; then

                BACKBLAZE_BUCKET=$BACKBLAZE_BUCKET_VAL

        else

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        fi

        if [ "$CLOUD_NAME_VAL" == "undefined" ]; then

                CLOUD_NAME="$CLOUD_NAME"

        elif [ ! -z "$CLOUD_NAME_VAL" ]; then

                CLOUD_NAME=$CLOUD_NAME_VAL

        else

                CLOUD_NAME="$CLOUD_NAME"

        fi

	if [ "$BACKBLAZE_BACKUP_VAL" == "undefined" ]; then

                BACKBLAZE_BACKUP="no"

        elif [ ! -z "$BACKBLAZE_BACKUP_VAL" ]; then

                BACKBLAZE_BACKUP=$BACKBLAZE_BACKUP_VAL

        else

                BACKBLAZE_BACKUP="no"

        fi

        if [ "$ENCRYPT_BACKUP_VAL" == "undefined" ]; then

                ENCRYPT_BACKUP="yes"

        elif [ ! -z "$ENCRYPT_BACKUP_VAL" ]; then

                ENCRYPT_BACKUP=$ENCRYPT_BACKUP_VAL

        else

                ENCRYPT_BACKUP="yes"

        fi

	max_attempts=7
	timeout=1
	attempt=1
	exitCode=0

	echo 'use parablu
db.CLOUD_PROPERTIES.find({"cloudType" : "enterprise"}).forEach(function(e){print("ENCRYPTPASSWORD=" +e.dbBackupPassword)});' >encrypt_password.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < encrypt_password.js >encryptpassword.log
        DB_ENCRYPT_PASSWORD=`grep "ENCRYPTPASSWORD" encryptpassword.log`
        DB_ENCRYPT_PASSWORD_VAL=$( echo $DB_ENCRYPT_PASSWORD | sed -e 's/ENCRYPTPASSWORD=//')
	decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EcryptionOrDecryption.jar dec  $DB_ENCRYPT_PASSWORD_VAL)
	decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')

        if [ "$DB_ENCRYPT_PASSWORD_VAL" == "undefined" ]; then

                ENCRYPT_PASSPHRASE="$CLOUD_NAME-@#*7#87^t"

        elif [ ! -z "$DB_ENCRYPT_PASSWORD_VAL" ]; then

                ENCRYPT_PASSPHRASE=$decrypt_key_val

        else

                ENCRYPT_PASSPHRASE="$CLOUD_NAME-@#*7#87^t"



        fi


        MONGO_ZIP_FILE="$CLOUD_NAME-`date '+%Y%m%d'`.zip"

	MONGO_ENCRYPTED_FILE="$CLOUD_NAME-`date '+%Y%m%d'`.gpg"
	MONGO_ENCRYPTED_FILECMD="$CLOUD_NAME-`date '+%Y%m%d'cmd`.gpg"

	# Do we need to use a username/password?
	if [ "$DBUSERNAME" ]; then
    		OPT="$OPT --username=$DBUSERNAME --password=$DBPASSWORD"
    		if [ "$REQUIREDBAUTHDB" = "yes" ]; then
        		OPT="$OPT --authenticationDatabase=$DBAUTHDB"
    		fi
	fi

	# Do we use oplog for point-in-time snapshotting?
	if [ "$OPLOG" = "yes" ]; then
    		OPT="$OPT --oplog"
	fi
}

function get_support_mail ()
{

unset MAILARRAY
echo 'use parablu
db.CLOUD_PROPERTIES.find({}).forEach(function(e){print("SUPPORT_MAIL=" +e.supportMail)})' > supportmailids.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < supportmailids.js >supportmailid.log

        WATCHDOG_MAIL_ADDRESS=`grep "SUPPORT_MAIL" supportmailid.log | sed -e 's/SUPPORT_MAIL=//' | sed -e 's/,/\ /g'`

        if [[ -z $WATCHDOG_MAIL_ADDRESS ]]; then

                WATCHDOG_MAIL_ADDRESS="support@parablu.com"
        fi
for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')


}

function get_adminmail_id ()
{

        unset MAILARRAY
echo 'use parablu001
db.USER.find({"admin" : true}).forEach(function(e){print("ADMIN_MAIL=" +e.emailId)})' > adminmailids.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < adminmailids.js >adminmailid.log

        WATCHADMIN_MAIL_ADDRESS=`grep "ADMIN_MAIL" adminmailid.log | sed -e 's/ADMIN_MAIL=//' | sed -e 's/,/\ /g'`

for mail_id in ${WATCHADMIN_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_adminmail_id=$(echo $tempids | sed -e 's/.$//')

}

function send_backpfail_alert ()
{

        ##Get mail ids
        get_support_mail

        MSG_SUBJECT="ALERT: MONGO BACKUP DUMP FAILURE [$CLOUD_NAME] Machine `hostname` at `date`"
        MSG_BODY="MONGO BACKUP FAILED"
        if [ "$SERVER_TYPE" == "3" ]; then
                scp -P $SSH_PORT /parablu/log/mongodb/full.log $SSH_USERNAME@$PARAMAIL_MACHINE:/parablu-scripts/Installable/scripts/
                sleep 5s

                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu-scripts/Installable/scripts/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                sleep 5s
                ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd /parablu-scripts/Installable/scripts/ && rm full.log"

        else
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu/log/mongodb/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi


}

function send_backupsuceed_alert ()
{

        ##Get mail ids
        #get_support_mail
        get_adminmail_id

        MSG_SUBJECT="ALERT: MONGO BACKUP DUMP SUCCESSED  [$CLOUD_NAME] Machine `hostname` at `date`"
        MSG_BODY="MONGO BACKUP SUCCESS"
        if [ "$SERVER_TYPE" == "0" ]; then

                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_adminmail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        fi


}

# Database dump function
dbdump () {
	setVariables "localhost"
	echo
	echo Backup of Database Server - on $DBHOST  >> /parablu/log/mongodb/mgbfull.log
	echo ====================================================================== >> /parablu/log/mongodb/mgbfull.log

	echo Backup Start `date` >> /parablu/log/mongodb/mgbfull.log
	echo ====================================================================== >> /parablu/log/mongodb/mgbfull.log

	DEFAULT_FOLDER=$BACKUPDIR/`hostname`
         echo "Checking for unclean folders"

	if [ -d "$DEFAULT_FOLDER" ]; then
    # Will enter here if $DIRECTORY exists, even if it contains spaces
    		rm -rf $DEFAULT_FOLDER
        fi

	mkdir -p $BACKUPDIR
	mkdir -p $ARCHIVEDIR
	#DEFAULT_FOLDER=$BACKUPDIR/`hostname`
	TIMESTAMP_FOLDER=$DEFAULT_FOLDER/`date '+%Y%m%d'`
	MONGOBACKUP_FOLDER=$TIMESTAMP_FOLDER/DB
	FILES_BACKUP=$TIMESTAMP_FOLDER/FILES
	rm -rf $DEFAULT_FOLDER
	mkdir -p $MONGOBACKUP_FOLDER
	mkdir -p $FILES_BACKUP

    	#mongodump --host=$DBHOST:$DBPORT --out=$MONGOBACKUP_FOLDER $OPT |& tee /parablu/log/mongodb/full.log
		foldersize=`du -sk $DEFAULT_FOLDER | awk '{ print $1/1024/1024 }'`
                 echo $foldersize > tutu.log
                 echo "Previous day Folder size before zipping is $foldersize"  >> /parablu/log/mongodb/mgbfull.log
                 ghansize=`less tutu.log | sed "s/\..*//"`
                 df -Bg /parablu --output=avail > kk.log
                 sed -i 's/Avail//g' kk.log
                 sed -i 's/G//g' kk.log
                 loadfolder=`cat kk.log`
                 addspace=50
                 sum=$(($loadfolder + $addspace))
                 if [ $ghansize -lt $sum ]; then

			mongodump --host=$DBHOST:$DBPORT --out=$MONGOBACKUP_FOLDER $OPT --gzip |& tee /parablu/log/mongodb/full.log
                else
			echo "Exitting due to insufficent space" |& tee /parablu/log/mongodb/full.log
                        echo "Exitting due to insufficent space,Available space is less than $sum" >> /parablu/log/mongodb/mgbfull.log
                        rclone sync -vv /parablu/log/mongodb/mgbfull.log wasabi:mongodbackup/$CLOUD_NAME
                        exit
                fi

	if [ ${PIPESTATUS[0]} -ne 0 ] ; then
                echo "MongoDump Failed" >> /parablu/mongo_backup_status
		send_backpfail_alert
                return 0
        fi

    	if [ ! -e "$MONGOBACKUP_FOLDER" ] ; then 
		echo "MongoDump Failed" >> /parablu/mongo_backup_status
		send_backpfail_alert
		return 0
	fi
	echo ----------------------------------------------------------------------
	echo Backup End Time `date`
	echo ======================================================================
	echo "MONGO BACKUP 
LAST BACKEDUP FILE : "$BACKUPDIR/$MONGO_ZIP_FILE" 
LAST BACKEDUP DATE: `date`" >> /parablu/mongo_backup_status
	check_proxy
	files_folder_backup
	zip -r $BACKUPDIR/$MONGO_ZIP_FILE $DEFAULT_FOLDER
	#if [ "$SERVER_TYPE" == "3" ]; then
	#	get_remote_files
	#fi
	sleep 2s
        rm -rf $DEFAULT_FOLDER
    	cd $BACKUPDIR
        echo "Moving old Backups to archive...."
        for i in `find . -mtime +1`; do
                echo -e "Archiving Backup Folder $i";
                mv $i $ARCHIVEDIR
                #tar -cf $ARCHIVEDIR/$i.tar -C $ARCHIVEDIR $i;
                #rm -rf $ARCHIVEDIR/$i
        done
        cd $ARCHIVEDIR
        ls -t | find . -mtime +3 | xargs -d '\n' rm
	if [ "$EXTERNAL_bACKUP" = "yes" ]; then
                ssh -p $EXTERNAL_DB_SSH_PORT $EXTERNAL_DB_SSH_USER@$EXTERNAL_DB_IP "mkdir -p $EXTERNAL_DB_PATH"
                scp -r $BACKUPDIR/$MONGO_ZIP_FILE $EXTERNAL_DB_SSH_USER@$EXTERNAL_DB_IP:$EXTERNAL_DB_PATH
        fi
	if [ "$BACKBLAZE_BACKUP" = "yes" ]; then
                if [ "$ENCRYPT_BACKUP" = "yes" ]; then

			 echo "STARTING BACKBLAZE BACKUP" |& tee -a /parablu/log/mongodb/full.log

                 #       zip -r $MONGO_ZIP_FILE $FOLDER
                        gpg -c --batch --passphrase $ENCRYPT_PASSPHRASE -o $MONGO_ENCRYPTED_FILE $BACKUPDIR/$MONGO_ZIP_FILE
                         
			#rclone sync -vv $MONGO_ENCRYPTED_FILE  backblazeglobal:CUST-Mongodbbackups/$CLOUD_NAME
			 rclone sync -vv $MONGO_ENCRYPTED_FILE  wasabi:mongodbackup/$CLOUD_NAME
			 		TIMESTAMP=`date`
                                	echo 'use parablu001
                                        	db.MONGO_PROPERTIES.update({},{$set:{"lastsucessfulbackuptime":"TIME_STAMP"}})' > lastbackup.js
                                        sed -i "s|TIME_STAMP|$TIMESTAMP|" lastbackup.js

                                 if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "3 1" ]]; then
					 dbport=$(grep port: /etc/mongod.conf)
                                        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                                         sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < lastbackup.js
                                fi
			rclone delete --min-age 30d wasabi:mongodbackup
			 FILE= "/parablu/log/mongodb/mgbfull.log"
                        if [ -e $FILE ];then
                                 rclone sync -vv /parablu/log/mongodb/mgbfull.log wasabi:mongodbackup/$CLOUD_NAME
                         fi
			send_backupsuceed_alert
			if [ $? -ne 0 ]; then
			#else
   				echo "Uploading using b2 command line"
			###new logic
				while [[ $attempt < $max_attempts ]]
				do
					# rclone sync -vv $MONGO_ENCRYPTED_FILE b2global:$CLOUD_NAME
					
					#get_support_mail

                              MSG_SUBJECT="ALERT: MONGO BACKUP BACKBLAZE UPLOADING USING b2 command line  [$CLOUD_NAME]  `hostname` at `date`"
                              MSG_BODY="MONGO BACKUP BACKBLAZE UPLOAD WITH CMD LINE"
                              if [ "$SERVER_TYPE" == "3" ]; then
                                    scp -P $SSH_PORT /parablu/log/mongodb/full.log $SSH_USERNAME@$PARAMAIL_MACHINE:/parablu-scripts/Installable/scripts/
                                    sleep 5s

                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu-scripts/Installable/scripts/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                                    sleep 5s
                                    ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd /parablu-scripts/Installable/scripts/ && rm full.log"
                              else
                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu/log/mongodb/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                               fi

			#      		backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY |& tee -a /parablu/log/mongodb/full.log
			 #     		backblaze-b2 upload-file  $BACKBLAZE_BUCKET $MONGO_ENCRYPTED_FILE $CLOUD_NAME/$MONGO_ENCRYPTED_FILECMD |& tee -a /parablu/log/mongodb/full.log

			      sed -i "s|bbkey|$BACKBLAZE_ID|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbapp|$APPLICATION_KEY|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbbucket|$BACKBLAZE_BUCKET|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbcloud|$CLOUD_NAME|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbfilename|$MONGO_ENCRYPTED_FILE|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbprxy|$PY_HOST|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbport|$PY_PORT|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbuser|$PY_UNAME|" /parablu-scripts/Installable/scripts/config.properties
                        sed -i "s|bbpass|$PY_PASSWORD|" /parablu-scripts/Installable/scripts/config.properties

                        java -jar /parablu-scripts/Installable/scripts/BackBlazeUpload.jar /parablu-scripts/Installable/scripts/config.properties >> /parablu-scripts/Installable/scripts/backblazejar.log

                        string1=`less /parablu-scripts/Installable/scripts/backblazejar.log | grep "Upload success"`
                        if [ "$string1" == "Upload success" ];then
                                 echo "Uploading using jar"
                                  sed -i "s|keyID=.*|keyID=bbkey|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|applicationKey=.*|applicationKey=bbapp|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|bucketName=.*|bucketName=bbbucket|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|folderName=.*|folderName=bbcloud|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|filePath=.*|filePath=bbfilename|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|proxyHost=.*|proxyHost=bbprxy|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|proxyPort=.*|proxyPort=bbport|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|proxyUserName=.*|proxyUserName=bbuser|" /parablu-scripts/Installable/scripts/config.properties
                                sed -i "s|proxyPassword=.*|proxyPassword=bbpass|" /parablu-scripts/Installable/scripts/config.properties


			fi
                     			exitCode=${PIPESTATUS[0]}
 
			      if [[ $exitCode == 0 ]]
			      then
				        break
			      fi
			      echo "RETRY COUNT: $attempt" |& tee -a /parablu/log/mongodb/full.log
			      echo "FAILURE!! Retrying in $timeout.. MINUTE" |& tee -a /parablu/log/mongodb/full.log
			      sleep ${timeout}m
			      attempt=$(( attempt + 1 ))
			      timeout=$(( timeout * 2 ))
		        done

		       if [[ $exitCode != 0 ]]
		       then
			      echo "FAILED AFTER 6 ATTEMPTS....!!" |& tee -a /parablu/log/mongodb/full.log
			      ##Get mail ids
                              get_support_mail

                              MSG_SUBJECT="ALERT: MONGO BACKUP BACKBLAZE UPLOAD FAILURE [$CLOUD_NAME] Machine `hostname` at `date`"
                              MSG_BODY="MONGO BACKUP BACKBLAZE UPLOAD FAILED"
                              if [ "$SERVER_TYPE" == "3" ]; then
                                    scp -P $SSH_PORT /parablu/log/mongodb/full.log $SSH_USERNAME@$PARAMAIL_MACHINE:/parablu-scripts/Installable/scripts/
                                    sleep 5s

                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu-scripts/Installable/scripts/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                                    sleep 5s
                                    ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd /parablu-scripts/Installable/scripts/ && rm full.log"
                              else
                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu/log/mongodb/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                               fi

		       fi

	       fi
			
		else
	       #elif [ "$ENCRYPT_BACKUP" = "NO" ];then 
                  #      zip -r $MONGO_ZIP_FILE $FOLDER
                        #backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
                        #backblaze-b2 upload-file  $BACKBLAZE_BUCKET $BACKUPDIR/$MONGO_ZIP_FILE $CLOUD_NAME/$MONGO_ZIP_FILE
			if [ $? -ne 0 ]; then
				sleep 20s
			#	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	                 #       backblaze-b2 upload-file  $BACKBLAZE_BUCKET $BACKUPDIR/$MONGO_ZIP_FILE $CLOUD_NAME/$MONGO_ZIP_FILE
			 #rclone sync -vv $MONGO_ENCRYPTED_FILE  backblazeglobal:CUST-Mongodbbackups/$CLOUD_NAME
			 	rclone sync -vv $MONGO_ENCRYPTED_FILE  wasabi:mongodbackup/$CLOUD_NAME
				TIMESTAMP=`date`
				echo 'use parablu001
                 			db.MONGO_PROPERTIES.update({},{$set:{"lastsucessfulbackuptime":"TIME_STAMP"}})' > lastbackup.js
                  			sed -i "s|TIME_STAMP|$TIMESTAMP|" lastbackup.js

               			 if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "3 1" ]]; then
					 dbport=$(grep port: /etc/mongod.conf)
        				MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                       			 sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < lastbackup.js
                		fi

				rclone delete --min-age 30d wasabi:mongodbackup
			 FILE= "/parablu/log/mongodb/mgbfull.log"
                            if [ -e $FILE ];then
                                 rclone sync -vv /parablu/log/mongodb/mgbfull.log wasabi:mongodbackup/$CLOUD_NAME
                            fi
			fi
		fi
	#fi

		sleep 2s
                rm -rf $MONGO_ZIP_FILE
		rm -rf $MONGO_ENCRYPTED_FILE
		rm -rf $MONGO_ENCRYPTED_FILECMD
		rm -rf $ARCHIVEDIR/*
		mv /parablu-scripts/Installable/scripts/backblazejar.log /parablu-scripts/Installable/scripts/backblazejarold.log
		rm -rf /parablu-scripts/Installable/scripts/backblazejar.log
        
	fi
    	return 1
}
function files_folder_backup ()
{
	cp -r --parents /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/privacygateway.properties $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/pb-credential.properties $FILES_BACKUP


}

function get_ip_list ()
{
	if [ "$SERVER_TYPE" == "3 1" ]; then

                echo 'use parablu001
                db.PRIVACY_GATEWAY.distinct("gatewayName");' >iplist.js
        else
                echo 'use parablu001
                db.PRIVACY_GATEWAY.distinct("gatewayName")

                db.BLUVAULT.distinct("bluVaultName");' >iplist.js

        fi

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < iplist.js >iplist.log
        grep '"' iplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_iplist.log
        sed -i "/Implicit/d" sorted_iplist.log
        tr ' ' '\n' < sorted_iplist.log > mongoblukrypt.log
        sed '/^$/d' branding.log > mongoblukryptnew.log

}


function consolidate_remote_files ()
{
        cur_dir=`pwd`
        mkdir -p prop_backup
        cd prop_backup
        cp -r --parents /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties .
        cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/privacygateway.properties .
        cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/pb-credential.properties .
	cp -r --parents /parablu/backup/mongodb/*  .

        cd $cur_dir

        zip -r prop_backup.zip prop_backup
        rm -rf prop_backup
}

function get_remote_files ()
{
        get_ip_list
	readarray -t my_array < mongoblukryptnew.log
        for ping_ip in ${my_array[@]}
        do

                mkdir -p $BACKUPDIR/$ping_ip
                cd $BACKUPDIR/$ping_ip
                ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "$(typeset -f consolidate_remote_files); consolidate_remote_files"
		echo '$BDB_PASS' | ssh -p $SSH_PORT  $BDB_USER@$ping_ip  "cd /parablu-scripts/Installable/scripts && sudo -S ./mongo_full_backupblukrypt.sh"
                scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:~/prop_backup.zip .
                ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf ~/prop_backup.zip"
		cd ..
		zip -r $BACKUPDIR/$MONGO_ZIP_FILE  $ping_ip
		rm -rf $ping_ip
        done
}

function check_proxy ()
{
        echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_USERNAME=" +e.proxyUserName)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PORT=" +e.proxyPort)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_HOST=" +e.proxyHost)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PASSWORD=" +e.proxyPassword)})' >proxy_details.js

        cp proxy_details.js newproxy_details.js
        sleep 1s
        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" newproxy_details.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < newproxy_details.js > proxy_details

        PY_UNAME=$(grep "P_USERNAME" proxy_details | sed -e 's/P_USERNAME=//')
        PY_PORT=$(grep "P_PORT" proxy_details | sed -e 's/P_PORT=//')
        PY_HOST=$(grep "P_HOST" proxy_details | sed -e 's/P_HOST=//')
        PY_PASSWORD=$(grep "P_PASSWORD" proxy_details | sed -e 's/P_PASSWORD=//')

        if [[ ! -z $PY_UNAME ]] && [[ ! -z $PY_PORT ]] && [[ ! -z $PY_HOST ]] && [[ ! -z $PY_PASSWORD ]]; then

                echo "PROXY ENABLED"
                PROXY_URL="https_proxy=\"https://$PY_UNAME:$PY_PASSWORD@$PY_HOST:$PY_PORT\""
                #export $PROXY_URL
		export https_proxy="https://$PY_UNAME:$PY_PASSWORD@$PY_HOST:$PY_PORT"
        else
                echo "Proxy DISABLED"
        fi

}

rm -rf /parablu/mongo_backup_status*
rm -rf /parablu/log/mongodb/mgbfull.log
check_pgoverload
disk_check
dbdump 

exit $STATUS
