<?php

use \Core\View;
use \Helpers\Url;
use Helpers\Auth;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.0
 * @date 12/04/19
 * @time 11:30 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
<li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
<li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='dashboard'?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h4>Office 365 Settings</h4>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                                <div class="col-lg-4">
                                    <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('oneDriveSettings')">
                                        <div class="background">
                                                <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                                <i class="fa fa-hdd-o"> Tenant Settings</i><br>
                                                <a>Change your Tenant Settings</a>
                                        </div>
                                      </div>
                                </div>
                                <?php if($data['exchangeBackupEnabled'] == 'true'){ ?>
                                <div class="col-lg-4">
                                    <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('exchangeSettings')">
                                        <div class="background">
                                                <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                                <i class="fa fa-hdd-o"> Exchange Settings</i><br>
                                                <a>Change your Exchange Tenant Settings</a>
                                        </div>
                                      </div>
				                            </div>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('office365')){?>
                                <div class="col-lg-4">
                                    <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('blukryptSettings')">
                                        <div class="background">
                                            <i class="fa fa-cogs"></i>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-cogs"> Agent Settings</i><br>
                                            <a>Change your Agent Settings</a>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.panel-default{
border-color:#f27331 !important;
border-radius: 10px !important;
}
</style>
