<?php
use \Core\View;
use Helpers\Auth;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.4.2
* @date 23/12/21
* @time 04:30 PM
*
*/

?>

<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide currentPage"><?='minicloudActivityHistory'?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('minicloud_activity_history', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                <!--start-->
                    <div class="col-lg-12">
                                <form ng-submit="updateMinicloudActivityDetails()">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <label for="minicloudName">MiniCloud Name</label>
                                            <select name="minicloudName[]" id="minicloudName" multiple class="form-control selectPicker minicloudName"  title='Select MiniCloud Name'>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['mini'])){ ?>
                                                    <?php foreach($data['mini'] as $key => $value){?>
                                                    <?php
                                                        $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                                    ?>
                                                    <option value="<?=$value->{'mini-cloud-name'}?>"><?=$trimmedName?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="from">From Date</label>
                                                <input type="text" class="form-control" id="from" placeholder="From Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="to">To Date</label>
                                                <input type="text" class="form-control" id="to" placeholder="To Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="dropdown col-lg-4" style="margin-top:25px;">
                                            <button type="submit" class="btn btn-default">View</button>
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadMinicloudActivityExcel()">Excel</a></li>
                                                <li><a ng-click="downloadMinicloudActivityPdf()">PDF</a><li>
                                              </ul>
                                            <a title="Schedule" class="btn btn-default hide" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendBkpSummeryReportTimer')"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                    </div>
                    <!--end-->
                    <div class="table-responsive" style="padding: 20px 10px 20px 40px;">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <div class="h4 noData text-center" style="display: none;">No details found</div>
                        <ul class="mini-timeline">
                            <li ng-repeat="value in audits track by $index" class="mini-timeline-{{value.color}}">
                                <div class="timeline-icon"></div>
                                <div class="timeline-body">
                                    <div class="timeline-content">
                                        <a href="" class="name" ng-cloak style="cursor:default;">{{ value.actionByUser }}</a> {{ value.action }} <span class="text-primary" ng-cloak>{{ value.actionOnObject }}</span> <span ng-if="value.actionUsingObject.length > 0"> <a ng-if="value.additionalInfo.length > 1" class="name" href="javascript:;" ng-cloak>{{ value.additionalInfo }}</a> using <a class="name" href="" ng-cloak style="cursor:default;">{{ value.actionUsingObject }}</a></span>
                                        <span class="time" ng-cloak>{{ value.time }}</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="row logsPagination" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="updateMinicloudActivityDetailsNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="updateMinicloudActivityDetailsNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="updateMinicloudActivityDetailsNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="updateMinicloudActivityDetailsNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>    
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
  $('#from').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-1y',
        todayHighlight: true
  });
  $('#to').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true
  });

$("#to").datepicker().datepicker("setDate", new Date());
$("#to").datepicker().datepicker('setEndDate', new Date());
var currentDate = new Date();
currentDate.setDate(currentDate.getDate() - 31);
$('#from').datepicker('update', currentDate);
$("#from").datepicker().datepicker('setEndDate', new Date());        
</script>
