<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <?php if(BLUDRIVE_MODE == true){?>
                     <li><a href="<?=Url::basePath('pms/sync/policies')?>"><?=Language::show('bludrivepolices', 'syncPms')?></a></li>
                 <?php } else { ?>
                     <li><a href="<?=Url::basePath('pms/sync/policies')?>"><?=$data['crumb1']?></a></li>
                 <?php } ?>
                <li><span><?=Language::show('clonePolicy', 'pms')?></span></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncPmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                     <h4><?=Language::show('clonePolicy', 'pms')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="d-none currentPage"><?='clonePolicy'?></span>
                    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
			'id' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreate()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group d-none">
                                <div class="checkbox check-primary">
                                    <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                    <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                    <a href="#" data-toggle="tooltip" data-placement="top" title="If checked then dependent parameters get changed."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    <span class="systemFolders" style="display: none;">
                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" value="{{ selectedPolicy.policygroupName }}_copy" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter Policy Description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512"></textarea>
                            </div>
                        </div>
                    </div>
                    
                        <!-- for mobile start-->
                        <?php if(isMobile()){ ?>
                            <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
			      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#contentSearch" aria-expanded="false" aria-controls="advanced">Search</a></li>
<?php } ?>
                              <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                            </ul>
                        <?php } ?>
                        <!-- for mobile end -->
                        <?php if(!isMobile()){ ?>
                            <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                                <li role="presentation" class="nav-item"><a class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
				<li class="nav-item" role="presentation"><a class="nav-link" data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                                <li class="nav-item" role="presentation"><a class="nav-link" data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
<?php if($data['searchEnabled'] == true){?>
                            <li class="nav-item" role="presentation"><a class="nav-link" data-target="#contentSearch" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
<?php } ?>
                                <li class="nav-item" role="presentation"><a class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            </ul>
                        <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                            <div class="row">
                                <div class="col-lg-12">
                                    <br/>
                                    <?php if(BLUDRIVE_MODE == true) { ?>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('BluDrive Information', 'keywords')?></legend>
                                        <?php } else { ?>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('sync_information', 'keywords')?></legend>
                                        <?php } ?>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group syncEnableAutomatic <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <label for="syncEnableAutomatic"><?=Language::show('syncEnableAutomatic', 'keywords');?></label>
                                        <select class="form-control syncEnableAutomatic" name="syncEnableAutomatic" id="syncEnableAutomatic" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('syncEnableAutomatic', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <label for="syncInterval"><?=Language::show('syncInterval', 'keywords');?> (In Minutes)</label>
                                        <input type="text" class="form-control" name="syncInterval" id="syncInterval" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('syncInterval', 'keywords');?>" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> autocomplete="off" value="{{ selectedPolicy.syncInterval }}" data-parsley-type="integer" data-parsley-min="5" data-parsley-max="60" />
                                    </div>
                                    <div class="form-group contentIndexEnabled d-none">
                                        <label for="contentIndexEnabled"><?=Language::show('contentIndexEnabled', 'keywords');?></label>
                                        <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('contentIndexEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group deDuplicationEnabled d-none">
                                        <label for="deDuplicationEnabled"><?=Language::show('deDuplicationEnabled', 'keywords');?></label>
                                        <select class="form-control deDuplicationEnabled" name="deDuplicationEnabled" id="deDuplicationEnabled" required="" title='Select <?=Language::show('deDuplicationEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
<div class="row">
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
					</div>
</div>
                                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="maxFileSize"><?=Language::show('maxFileSize', 'keywords');?> (In MB)</label>
<div class="row">
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxFileSize" id="maxFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
                    </div>
                                    <div class="form-group">
					<label class="col-lg-12" style="margin-left: -14px;" for="userSizeAllowed"><?=Language::show('User Storage Quota', 'keywords');?> (In GB)</label>
<div class="row">
                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="userSizeAllowed" id="userSizeAllowed" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userSizeAllowed', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
</div>
                                </div>
                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="noOfDevicesAllowed"><?=Language::show('Maximum Devices Allowed', 'keywords');?></label>
                                        <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" placeholder="<?=Language::show('Maximum Devices Allowed', 'keywords');?>" required autocomplete="off" value="1" data-parsley-type="integer" min="1" onfocusout="myFunctionDevice();"/>
                                        <span id="deviceerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osType" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal" selected>Universal</option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="cacheUsedData"><?=Language::show('cacheUsedData', 'keywords');?></label>
                                        <select class="form-control cacheUsedData" name="cacheUsedData" id="cacheUsedData" required="" title='Select <?=Language::show('cacheUsedData', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a href="" class="clickAble" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                        <select class="form-control selectFilterTypePicker" name="filtersType" id="filtersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
					<div class="row col-lg-12">
                                            <h5 class="col-lg-2 inclusionBadge"><label class="badge badge-success"><i class="fa fa-plus-circle"></i></label></h5>
                                            <h5 class="col-lg-2 exclusionBadge" style="display:none;"><label class="badge badge-danger"><i class="fa fa-minus-circle"></i></label></h5>
                                        <!--<select class="form-control selectFilterPicker inc" name="filters[]" id="filters" title='Select Filters' multiple>
                                            <?php //if(!empty($data['IncFilters'])){ ?>
                                                <?php //foreach($data['IncFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                            <?php //} ?>
                                        </select>
                                        <select class="form-control selectFilterPicker exc" name="filters[]" id="filters1" title='Select Filters' multiple>
                                           <?php //if(!empty($data['ExcFilters'])){ ?>
                                                <?php //foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    
                                                <?php //} ?>
                                        <?php //} ?>
                                        </select>-->
                                        <select class="col-lg-10 selectFilterPicker" name="filters[]" id="filters" required title='Select Filters' multiple>
                                            <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
					</div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive" style="display: table;">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                            <td style="white-space:nowrap !important;">
                                                                <!--<a class="btn btn-default btn-small pull-right" ng-click="newFilterEdit(defaultFilter.filterName)">Edit</a>-->
                                                                <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
<div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateAdmins" name="createUser[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                        	<option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 d-none">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                </div>
                                    <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('OPEN_SYNC_FOLDER', 'keywords');?></label>
                                            <select class="form-control opensyncfolder" name="opensyncfolder" id="opensyncfolder" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SYNC_FILES', 'keywords');?></label>
                                            <select class="form-control syncfiles" name="syncfiles" id="syncfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>                              
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SEARCH', 'keywords');?></label>
                                            <select class="form-control search" name="search" id="search" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                           <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                            <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                               <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                            <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>				    
                                        <div class="form-group">
                                        <label for="systrayIcon"><?=Language::show('Systray Icon', 'keywords');?></label>
                                        <select class="form-control systrayIcon" name="systrayIcon" id="systrayIcon" required="" title='Select <?=Language::show('systrayIcon', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>     
                                    </div>
                                    <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('INITIATE_SYNC', 'keywords');?></label>
                                            <select class="form-control initiatesync" name="initiatesync" id="initiatesync" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SYNC_SETTINGS', 'keywords');?></label>
                                            <select class="form-control syncsettings" name="syncsettings" id="syncsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>    
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('REFRESH_SYNC_POLICY', 'keywords');?></label>
                                            <select class="form-control refreshsyncpolicy" name="refreshsyncpolicy" id="refreshsyncpolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                            <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="about"><?=Language::show('ABOUT', 'keywords');?></label>
                                            <select class="form-control about" name="about" id="about" required="" title='Select <?=Language::show('about', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                        <div class="form-group">
                                            <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                            <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" ><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                       <?php }?>
				       <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                            <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>                                       
                                    </div>
                            </div>
			    <div class="row">
                                <div class="col-lg-12">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal  ', 'keywords')?>
                                <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Portal changes will reflect on user login."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                </legend>
                                </div>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group CutCopyPaste">
                                            <label for="CutCopyPaste"><?=Language::show('Cut, Copy and Paste', 'keywords');?></label>
                                            <select class="form-control CutCopyPaste" name="CutCopyPaste" id="CutCopyPaste" required="" title='Select <?=Language::show('Cut', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
						<option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
					<div class="form-group createFolder">
                                            <label for="createFolder"><?=Language::show('Create Folder', 'keywords');?></label>
                                            <select class="form-control createFolder" name="createFolder" id="createFolder" required="" title='Select <?=Language::show('Create Folder', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group delete">
                                            <label for="delete"><?=Language::show('Delete', 'keywords');?></label>
                                            <select class="form-control delete" name="delete" id="delete" required="" title='Select <?=Language::show('Delete', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group rename">
                                            <label for="rename"><?=Language::show('Rename', 'keywords');?></label>
                                            <select class="form-control rename" name="rename" id="rename" required="" title='Select <?=Language::show('Rename', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
					<div class="form-group fileUpload">
                                            <label for="fileUpload"><?=Language::show('File/Folder Upload', 'keywords');?></label>
                                            <select class="form-control fileUpload" name="fileUpload" id="fileUpload" required="" title='Select <?=Language::show('File Upload', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group createMinicloud">
                                            <label for="createMinicloud"><?=Language::show('Create MiniCloud', 'keywords');?></label>
                                            <select class="form-control createMinicloud" name="createMinicloud" id="createMinicloud" required="" title='Select <?=Language::show('Create MiniCloud', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                            	</div>
                            <div class="row shareDetailsLabel">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
				    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					    <div class="form-group">
                                                <div class="checkbox check-primary">
                                                    <input id="shareDomainsEnabled" name="shareDomainsEnabled" type="checkbox" value="enabled">
                                                    <label for="shareDomainsEnabled"><?=Language::show('Enable Domain Control', 'keywords');?></label>
                                                </div>
                                            </div>
					    <div class="row">
						<div class="form-group col-lg-6">
							<label for="shareDomainIncExclusions"><?=Language::show('Share Domain Inclusions/Exclusions', 'keywords');?></label>
							<input type="text" class="form-control" name="shareDomainIncExclusions" id="shareDomainIncExclusions" placeholder="" autocomplete="off" value="" />
						</div>
						<div class="col-lg-6" style="margin-left:-14px;margin-top:20px;">
							<div class="col-lg-12" style="margin-bottom:15px;">
								<input type="radio" name="shareDomainType" id="only" value="Share only with these Email domains">
								<label for="link"><?=Language::show('Share only with these Email domains', 'keywords');?></label>
								</br>
								<input type="radio" name="shareDomainType" id="withall" value="Share with all Email domains excepting these">
								<label for="link"><?=Language::show('Share with all Email domains excepting these', 'keywords');?></label>
							</div>
						</div>
					    </div>
				    </div>
				    <div class="col-lg-6 row" style="margin-top:10px;">
                                        <div class="col-lg-2 controllerSLBlock">
                                        	<label class="switch">
                                        		<input id="controllerSL" type="checkbox" name="controllerSL" value="true">
                                        		<div class="slider round"></div>
                                        	</label>
                                        </div>
					<span style="margin-top:5px;">Allow sharer visibility to the shared link</span>

				    </div>
				    <div class="form-group twoWayShareEnabled d-none">
                                        <label for="twoWayShareEnabled"><?=Language::show('twoWayShareEnabled', 'keywords');?></label>
                                        <select class="form-control twoWayShareEnabled" name="twoWayShareEnabled" id="twoWayShareEnabled" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('twoWayShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="form-group">
						<div class="checkbox check-primary">
						    <input id="highSecureShareEnabled" name="highSecureShareEnabled" type="checkbox" value="enabled">
						    <label for="highSecureShareEnabled"><?=Language::show('Highly Secure Sharing', 'keywords');?></label>
						</div>
                                    	</div>
					<div class="col-lg-12 row">
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerCPBlock">
								<label class="switch">
									<input id="controllerCP" type="checkbox" name="controllerCP" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Complex Password</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerADBlock">
								<label class="switch">
									<input id="controllerAD" type="checkbox" name="controllerAD" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Allow Download</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerEDBlock">
								<label class="switch">
									<input id="controllerED" type="checkbox" name="controllerED" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Require Expiration Date for shared data</span>
						</div>
						<div class="col-lg-6 row">							
							<div class="col-lg-2 controllerMFABlock">
								<label class="switch">
									<input id="controllerMFA" type="checkbox" name="controllerMFA" value="true">
									<div class="slider round"></div>
								</label>
							</div>
							<span style="margin-top:5px;">Enable multi-factor authentication</span>
						</div>
					</div>
				    </div>                                    
                                </div>
                            </div>
                        </div>
<div role="tabpanel" class="tab-pane" id="contentSearch">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                        <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        </legend>
                                        <div class="col-lg-6">
                                            <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                                <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                                <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-7">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Search Filters', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble d-none" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label><br>
                                            <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label>
                                            <select class="form-control selectSearchFilterTypePicker" name="searchFilterType" id="searchfiltersType" title='Select Filter Type'>
                                                <option value="inclusion">Inclusion</option>
                                                <option value="exclusion">Exclusion</option>
                                            </select>
                                                <!--<select class="form-control selectSearchFilterPicker incSearch" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple>
<?php if(!empty($data['IncFilters'])){ ?>
                                                    <?php foreach($data['IncFilters'] as $key => $value){ ?>
                                                        <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                                <select class="form-control selectSearchFilterPicker excSearch" name="searchfilters[]" id="searchfilters1" title='Select Filters' multiple>
                                               <?php if(!empty($data['ExcFilters'])){ ?>
                                                    <?php foreach($data['ExcFilters'] as $key => $value){ ?>
                                                        <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>-->
					    <select class="form-control selectSearchFilterPicker" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple <?php if($data['searchEnabled'] == true){ ?> required <?php } ?>>
                                           <?php if(!empty($data['fil1'])){ ?>
                                                <?php foreach($data['fil1'] as $key => $value){ ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <br/><br/>
                                        <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                        <div class="col-lg-12">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                    </div>
                                                    <div class="panel-body" style="word-break:break-all;">
                                                        <div class="table-responsive">
                                                        <table class="table table-bordered table-responsive" style="display: table;">
                                                            <tbody>
                                                            <tr ng-repeat="value in defaultSearchFilter">
                                                                <td style="white-space:unset !important;">
                                                                    <p><b>{{ value.filterName }} :</b></p>
                                                                    <span style="word-break:break-all;">{{value.filters}}</span>
								</td>
                                                                <td>
                                                                    <a ng-bootbox-confirm="<h4>If edited in one place across all the policy it will take effect. Are you sure you want to proceed?</h4>"
                                                                    ng-bootbox-confirm-action="newFilterEdit(value.filterName)"
                                                                    ng-bootbox-confirm-action-cancel="" class="btn btn-default btn-small pull-right"><?=Language::show('Edit', 'keywords');?></a>
                                                                </td>
                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            </br>
                            
                              <div class="row d-none">
                                    <div class="col-lg-7">
                                        <br/>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                            <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        </br>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                        <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunction();" disabled/>
                                        </div><span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>-->
				        <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>
                                        <div class="form-group d-none">
                                            <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                            <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <div class="form-group d-none">
                                            <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                            <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        </br></br>
                                        <div class="row partialfileattributerow">
                                            <div class="col-lg-12">
                                                 <div class="panel panel-default">
                                                    <div class="panel-body">
                                                        <div class="form-group">
                                                            <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                                        </div>
                                                    </div>
                                                 </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
				    <?php if($data['isAVScanEnabled'] == 'true'){ ?>
					<div class="col-lg-6 row">
						<span style="margin-top:5px;">Malware Scan during file upload</span>
						<div class="col-lg-2 enableAVScanBlock">
							<label class="switch">
								<input id="enableAVScan" type="checkbox" name="enableAVScan" value="true" checked>
								<div class="slider round"></div>
							</label>
						</div>
                                        </div>
				    <?php } ?>
                                    <div class="form-group dedup_god d-none" id="div_god" style="display: none;">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup_god" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                   
                                        <div class="form-group dedup_oth d-none" id="div_oth" style="display: none;">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup_oth" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global"><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                   <div class="form-group d-none">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group d-none">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <?php if(!empty($data['pgs'])){ ?>
                                            <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                <?php foreach($data['pgs'] as $key => $value){ ?>
                                                    <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                <?php } ?>
                                            </select>
                                        <?php } ?>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?>>
                                    </div>
                                    <div class="form-group d-none">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
				    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'd-none';}?>">
                                       <label for="downloadAgent"><?=Language::show('Enable Download Agent', 'keywords');?></label>
                                       <a href="#" data-toggle="tooltip" data-placement="top" title="Relogin on portal is required"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                    <div class="form-group">
						<label class="col-lg-12" style="margin-left: -14px;" for="noOfDaysToPurgeFile"><?=Language::show('noOfDaysToPurgeFile', 'keywords');?></label>
						<div class="row">
							<div class="col-lg-2">
							    <label class="switch">
								<input id="switchtobedelete" type="checkbox">
								<div class="slider round"></div>
							    </label>
							</div>
							<div class="col-lg-8">
							    <input type="text" class="form-control" name="noOfDaysToPurgeFile" id="noOfDaysToPurgeFile" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('noOfDaysToPurgeFile', 'keywords');?>" required autocomplete="off" value="0" onfocusout="myFunctionFileDelete();" disabled/>
							    <span id="filedeletrerror" style="color: #f55753;font-size: 0.9em;"></span>
							</div>
							<div class="col-lg-2" style="margin-top: 10px;">
								<label>days</label>
							</div>
						</div>
                                            </div>
                                </div>                        
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Go to Global settings to enable this option."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" <?php if($data['passwordChangeEnforce'] == true){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE <?php if($data["passwordChangeEnforce"] == true){echo 'hide';}?>" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
                            </div>
                        </div>

                    </div><br/>
                    <div class="row">
                        <div class="col-lg-6">
                            <!--<button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>-->
                            <a ng-bootbox-confirm="<h4><?=Language::show('Will be effective on next policy refresh, for immediate effect manually refresh policy.', 'keywords')?></h4>"
                                ng-bootbox-confirm-action="policyCreate()"
                                ng-bootbox-confirm-action-cancel="" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/sync/policies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
		    <h4 class="modal-title">Edit Schedule</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                        <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                        <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                    </div>
                    <div class="form-group">
                        <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                    </div>
                    <div class="form-group">
                        <label for="days"><?=Language::show('days', 'keywords');?></label>
                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                        <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                            <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                            <option value="2"><?=Language::show('monday', 'keywords')?></option>
                            <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                            <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                            <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                            <option value="6"><?=Language::show('friday', 'keywords')?></option>
                            <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS" id="addCloudCredentials" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <?=
                            Form::open(array(
                                'ng-submit' => 'saveCloudCredentials(true)',
                                'class' => 'cloudCredentials',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                            ?>
                            <div class="modal-header">
				<h4 class="modal-title">Add your Cloud Credentials</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label for="cloudType">Cloud Type</label>
                                        <select class="form-control" name="cloudType" id="cloudType">
                                            <option value="azureBlob"><?=Language::show('azureBlob', 'settings')?></option>
                                            <option value="ibmCloud"><?=Language::show('ibmSoftlayer', 'settings')?></option>
                                            <option value="amazon"><?=Language::show('amazonS3', 'settings')?></option>
                                            <option value="localStorage"><?=Language::show('localStorage', 'settings')?></option>
                                            <option value="oneDrive"><?=Language::show('microsoft', 'settings')?></option>
                                            <option value="googleDrive"><?=Language::show('googleDrive', 'settings')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 cloudCredentialName">
                                        <label for="cloudCredentialName"><?=Language::show('cloudName', 'settings')?></label>
                                        <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('cloudNameInfo', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        <input type="text" class="form-control" name="cloudCredentialName" id="cloudCredentialName" value="" placeholder="<?=Language::show('cloudNamePH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 identity">
                                        <label for="identity">Identity</label>
                                        <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="<?=Language::show('cloudIdentityPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 accessKey">
                                        <label for="accessKey">Access key</label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="<?=Language::show('accessKeyPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 epaUrl" style="display: none;">
                                        <label for="epaUrl">End Point URL</label>
                                        <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="<?=Language::show('endPointURLPH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 containerName" style="display: none;">
                                        <label for="containerName">Amazon Container Name</label>
                                        <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="<?=Language::show('amazonContainerNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 localStorage" style="display: none;">
                                        <label for="localStorage">Local Storage Folder Name</label>
                                        <input type="text" class="form-control" name="localStorage" id="localStorage" value="" placeholder="<?=Language::show('folderNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <!--Google starts-->
                                    <div class="forGD d-none" >
                                        <div class="panel-body">
                                            <input type="text" class="d-none" hidden value="<?=$ccS["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="clientId">Client ID</label>
                                                 <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                 <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="<?=Language::show('clientIDPH', 'settings')?>" autocomplete="off">
                                                </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret"><?=Language::show('clintIDH', 'settings')?></label>
                                                <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="{{value.credential}}" placeholder="<?=Language::show('secretKeyPH', 'settings')?>" autocomplete="off">
                                                
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('clientRedirectURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="{{value.clientRedirectUri}}" placeholder="<?=Language::show('redirectURIPH', 'settings')?>" autocomplete="off">
                                           </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="{{value.clientResourceUrl}}" placeholder="<?=Language::show('clientResourceURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientTokenURL">Client Token URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="{{value.clientTokenUrl}}" placeholder="<?=Language::show('clientTokenURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="portalURL">Portal URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('portalURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="{{value.endPointUrl}}" placeholder="<?=Language::show('portalURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                <!--Google ends -->
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button type="button" class="btn btn-danger" ng-click="closeModal()" data-dismiss="modal">Cancel</button>
                            </div>
                            <?=
                            Form::close();
                            ?>
                        </div>
                    </div>
    </div> 
    <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                     <h4 id="add_title" class="modal-title">Create Filter</h4>
		     <h4 id="edit_title" class="modal-title" style="display: none;">Edit FIlter</h4>
		     <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                    </div>
                    <div class="form-group d-none">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filterTemplate"><?=Language::show('Select Filter Template', 'keywords')?></label>
                        <select class="form-control selectFilterTemplatePickerPolicy" name="filterTemplate[]" id="selectFilterTemplatePickerPolicy" title='Select Filters template' multiple>
                                            <?php if(!empty($data['filCanned'])){ ?>
                                                <?php foreach($data['filCanned'] as $key => $value){ ?>
                                                    <?php $label = $value;
                                                                if( strlen( $value ) > 50 ) {
                                                                   $label = substr( $label, 0, 50 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                        <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of extensions"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                        <br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="add_save" class="btn btn-primary pull-right">Save changes</button>
                    <a class="btn btn-primary pull-right" id="edit_save" ng-click="filterSavePolicy()" style="display: none;">Save changes</a>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectFilterTemplatePickerPolicy').selectpicker('render');
    $('.dedup').selectpicker('render');
    $('.filterType').selectpicker('render');
    $('.selectSearchFilterPicker').selectpicker('render');
    $('.syncEnableAutomatic').selectpicker('render');
    $('.shareEnabled').selectpicker('render').on('change', function(){
        if($('#shareEnabled').val() == 'true'){
            $('.complexPasswordRequired').show();
            $('.highSecureShareEnabled').show();
            $('.highSecuredShareOptions').show();
            $('.preventDownloadEnabled').show();
            $('.expiredDate').show();
			$('.subimage').show();
        }else{
            $('.complexPasswordRequired').hide();
            $('.highSecureShareEnabled').hide();
            $('.highSecuredShareOptions').hide();
            $('.preventDownloadEnabled').hide();
            $('.expiredDate').hide();
			$('.subimage').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
            $('#Blukryptipaddress').attr('required', 'required');
        }else{
            $('#Blukryptipaddress').removeAttr('required', 'required');
        }
    });
    $('#highSecureShareEnabled').on('change', function(){
        var checked = document.getElementById('highSecureShareEnabled').checked;
        if(checked){
            console.log("checked");
            $('.controllerCPBlock').css('pointer-events','none');
            $('.controllerADBlock').css('pointer-events','none');
            $('.controllerEDBlock').css('pointer-events','none');
            $('.controllerMFABlock').css('pointer-events','none');

            document.getElementById('controllerED').checked=true;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=false;               
            document.getElementById('controllerMFA').checked=true;
        }else{
            console.log("Unchecked");
            $('.controllerCPBlock').css('pointer-events','');
            $('.controllerADBlock').css('pointer-events','');
            $('.controllerEDBlock').css('pointer-events','');
            $('.controllerMFABlock').css('pointer-events','');

            document.getElementById('controllerED').checked=false;
            document.getElementById('controllerCP').checked=true;
            document.getElementById('controllerAD').checked=true;            
            document.getElementById('controllerMFA').checked=false;
        }
    });

    $('.contentIndexEnabled').selectpicker('render');
    $('.deDuplicationEnabled').selectpicker('render');
    $('.cacheUsedData').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.selectCcSPicker').selectpicker('render');


    $('.compEnabled').selectpicker('render');
    $('.selectSchedulePicker').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render')
        .on("change", function(event){
            if($('.incrementalFileTransfer').val() == 'false'){
                $('.partialfileattributerow').addClass('hide');
                $('#partialFileSize').attr('disabled', 'disabled')
                $('#fileChunkableSize').attr('disabled', 'disabled')
            }else{
                $('.partialfileattributerow').removeClass('hide');
                $('#partialFileSize').removeAttr('disabled', 'disabled')
                $('#fileChunkableSize').removeAttr('disabled', 'disabled')
            }
        });
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.containerName').show();
            $('[name="containerName"').attr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.epaUrl').show();
            $('[name="epaUrl"').attr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }else{
            $('.epaUrl').hide();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }
    });
</script>
<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        console.log(evt);
        console.log(evt.params);
        console.log(evt.params.data);
        var element = evt.params.data.element;
        console.log(element);
        var $element = $(element);
        console.log($element);
        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
       // $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
h5{
color:black;
}
</style>
<script>
    /*$("#switch").click(function(){
        document.getElementById("switcherror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPG').removeAttr('disabled'); //enable input
        $('#nwFromClientToPG').val('');
        
    } else {
        
        $('#nwFromClientToPG').attr('disabled', true); //disable input
        $('#nwFromClientToPG').val('UNLIMITED');
    }
        });*/

    $("#switchsize").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxFileSize').removeAttr('disabled'); //enable input
        $('#maxFileSize').val('');
        
    } else {
        
        $('#maxFileSize').attr('disabled', true); //disable input
        $('#maxFileSize').val('UNLIMITED');
    }
        });
    
    $("#switchlimit").click(function(){
        document.getElementById("limiterror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#userSizeAllowed').removeAttr('disabled'); //enable input
        $('#userSizeAllowed').val('');
        
    } else {
        
        $('#userSizeAllowed').attr('disabled', true); //disable input
        $('#userSizeAllowed').val('UNLIMITED');
    }
        });

    $("#switchver").click(function(){
        document.getElementById("vererror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxVersions').removeAttr('disabled'); //enable input
        $('#maxVersions').val('3');
        
    } else {
        
        $('#maxVersions').attr('disabled', true); //disable input
        $('#maxVersions').val('UNLIMITED');
    }
        });
</script>

<script>
    /*function myFunction(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPG').val()))
        {
        if (  $('#nwFromClientToPG').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPG').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }*/
    
    function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxFileSize').val()))
        {
        if (  $('#maxFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if($('#maxFileSize').val() < 1){
             document.getElementById("sizeerror").innerHTML = "Minimum File Size Allowed is 1";
         }
        else if(!isNaN($('#maxFileSize').val()) && $('#maxFileSize').val() > 99999){
             document.getElementById("sizeerror").innerHTML = "Maximum File Size Allowed is 99999";
         }
        else if($('#maxFileSize').val().indexOf(".")!=-1){
            document.getElementById("sizeerror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }
    
    function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#userSizeAllowed').val()))
        {
        if (  $('#userSizeAllowed').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if($('#userSizeAllowed').val() < 1){
             document.getElementById("limiterror").innerHTML = "Minimum User Storage Quota Limit Allowed is 1";
         }
        else if(!isNaN($('#userSizeAllowed').val()) && $('#userSizeAllowed').val() > 99999){
             document.getElementById("limiterror").innerHTML = "Maximum User Storage Quota Limit Allowed is 99999";
         }
         else if($('#userSizeAllowed').val().indexOf(".")!=-1){
            document.getElementById("limiterror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }

    function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
    }

    function myFunctionMB(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMB').val()))
        {
        if (  $('#nwFromClientToPGMB').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPGMB').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPGMB').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }
    
    function myFunctionDevice(){
        document.getElementById("deviceerror").innerHTML = "";
        /*if($('#noOfDevicesAllowed').val() < 1){
             document.getElementById("deviceerror").innerHTML = "Minimum Number of Devices Allowed is 1";
        }
        else */
        if($('#noOfDevicesAllowed').val() > <?php echo $data['noOfDevicesAllowed'];?>){
            document.getElementById("deviceerror").innerHTML = "This value exceeds the number of devices licensable per user. Please enter a value lower than or equal to <?php echo $data['noOfDevicesAllowed'];?>";
        }else{
            document.getElementById("deviceerror").innerHTML = "";
        }
    }
    
    $(".liteVersion").addClass("disabledbutton");
    $("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});
    
    $("#switch").click(function(){
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPGMB').removeAttr('disabled','disabled'); //enable input
        $('#nwFromClientToPGMB').val('4');
        $('#networkThrottlingUnit').removeAttr("disabled","disabled");
        
    } else {
        
        $('#nwFromClientToPGMB').attr('disabled', true); //disable input
        $('#nwFromClientToPGMB').val('UNLIMITED');
        $('#networkThrottlingUnit').attr("disabled","disabled");
        $('.networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
    }
        });
        
    /*$('html').bind('keypress', function(e)
    {
       if(e.keyCode == 13)
       {
          return false;
       }
    });*/
    
    /*$("#edit_save").click(function(){
        $(".filterForm").submit();
    });*/

    $("#editSchedule_save").click(function(){
        $(".scheduleCreateForm").submit();
    });
    
    $("#switchtobedelete").click(function(){
        document.getElementById("filedeletrerror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#noOfDaysToPurgeFile').removeAttr("disabled","disabled"); //enable input
        $('#noOfDaysToPurgeFile').val('0');
        
    } else {
        
        $('#noOfDaysToPurgeFile').attr("disabled","disabled"); //disable input
        $('#noOfDaysToPurgeFile').val('0');
    }
        });
        
    $("#switchAllowedDomains").click(function(){
      if ($(this).is(':checked')) {
        $('#allowedDomains').prop('readonly', false);
        $('#allowedDomains').attr('required', 'required');
      } else {
        $('#allowedDomains').prop('readonly', true);
        $('#allowedDomains').removeAttr('required');
      }
    });         


    function myFunctionFileDelete(){
        document.getElementById("filedeletrerror").innerHTML = "";
        if(isNaN($('#noOfDaysToPurgeFile').val()))
        {
            if (  $('#noOfDaysToPurgeFile').val() !='0')  {
                document.getElementById("filedeletrerror").innerHTML = "Input can be either '0' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#noOfDaysToPurgeFile').val()) && $('#noOfDaysToPurgeFile').val() > 10000000){
            document.getElementById("filedeletrerror").innerHTML = "Maximum number of Files to be deleted is 1 Crore";
        }
        else{
            document.getElementById("filedeletrerror").innerHTML = "";
        }
    }
    
    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
        $('#scheduleName').removeAttr('readonly', 'readonly');
        });

        $('.createFilter').on('hidden.bs.modal', function(){
        $('#filterName').removeAttr('readonly', 'readonly');
        });

    });
    
    $(function() {
        $('.createSchedule').on('hidden.bs.modal', function(){
            $('#addSchedule_title').removeClass("d-none");
            $('#editSchedule_title').removeClass("d-block");
            $('#addSchedule_save').removeClass("d-none");
            $('#editSchedule_save').removeClass("d-block");
        });
        $('.createFilter').on('hidden.bs.modal', function(){
            $('#add_title').removeClass("d-none");
            $('#edit_title').removeClass("d-block");
            $('#add_save').removeClass("d-none");
            $('#edit_save').removeClass("d-block");
        });
    });
    $('.Share').on('change', function(){
        if($('#Share').val() == 'true'){
            $('.shareDetailsLabel').show();
            $('.highSecuredShareOptions').show();
            $('.highSecureShareEnabled').show();
        }else{
            $('.shareDetailsLabel').hide();
            $('.highSecuredShareOptions').hide();
            $('.highSecureShareEnabled').hide();
        }
    });    
	
    /*$('input[type="radio"]').on('click change', function(e) {
        var radioValue = $("input[name='shareDomainType']:checked").val();

        if(radioValue == 'Share only with these Email domains'){
                $('#shareDomainIncExclusions').removeAttr('required', 'required');
        }else{
                $('#shareDomainIncExclusions').attr('required', 'required');
        }
    });*/

    $('#shareDomainsEnabled').on('change', function(){
        var checked = document.getElementById('shareDomainsEnabled').checked;
        if(checked){
                $('#shareDomainIncExclusions').attr('required', 'required');
                document.getElementById("shareDomainIncExclusions").style['pointer-events'] = 'unset';
                document.getElementById("shareDomainIncExclusions").style.opacity = "1";
                document.getElementById("shareDomainIncExclusions").style.backgroundColor = "white";
                document.getElementById("only").style['pointer-events'] = 'unset';
                document.getElementById("withall").style['pointer-events'] = 'unset';
        }else{
                $('#shareDomainIncExclusions').removeAttr('required', 'required');
                document.getElementById("shareDomainIncExclusions").style['pointer-events'] = 'none';
                document.getElementById("shareDomainIncExclusions").style.opacity = "0.5";
                document.getElementById("shareDomainIncExclusions").style.backgroundColor = "#e9ecef";
                document.getElementById("only").style['pointer-events'] = 'none';
                document.getElementById("withall").style['pointer-events'] = 'none';
        }
   });
</script>
