<?php

use \Core\View;
use \Helpers\Url;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="MigrationController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='migrationDashboard'?></span>
            <div class="row dashboard">
                <div class="panel panel-default col-lg-12">
                    <div class="panel-heading"><h3>Migration Overview</h3></div>
                    <div class="panel-body">
                        <ul class="list-group col-lg-6">
                            <li class="list-group-item" style="border-color:#f27331 !important;border-radius:10px !important;">Users On System <b class="pull-right" ng-cloak>{{ migrationDetails.noOfUsersMigrated }}</b></li>
                            <li class="list-group-item" style="border-color:#f27331 !important;border-radius:10px !important;">Parablu End Point Agent Installed on <b class="pull-right" ng-cloak>{{ migrationDetails.noOfBSInstalled }}</b></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row dashboard">
                <div class="panel panel-default col-lg-12">
                    <div class="panel-heading"><h3>Migration Tools</h3></div>
		    <div class="panel-body">
<div class="row">
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="gotTo('/report/userMigration')" style="border-color:#f27331 !important;border-radius: 10px !important;">
                                <div class="background">
                                    <i class="fa fa-pie-chart"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-pie-chart"> Migration Status</i><br>
                                    <a>Check the status of all migrated users</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 toolTip" <?php  if(enableADMigration == false){ ?>data-toggle="tooltip" data-placement="right" title="This feature is Disabled in Lite Version"<?php }?>>
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" <?php  if(enableADMigration == false){ ?>style="cursor: not-allowed;" <?php }?><?php  if(enableADMigration == true){ ?>ng-click="gotTo('/migration/importUsers')"<?php } ?> style="border-color:#f27331 !important;border-radius: 10px !important;">
                                <div class="background">
                                    <i class="fa fa-user-plus"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-user-plus"> Import Users</i><br>
                                    <?php if($data['isLdapEnabled'] == 'true') { ?>
                                        <a>Import users from AD</a>
                                    <?php } else { ?>
                                        <a>Import users from AAD</a>
                                    <?php } ?>
                                </div>
                            </div>
			</div>
</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/MigrationController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
