<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><a href="<?=Url::basePath('backup/devices')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=urldecode($data['crumb2']);?></span></li>
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
        <?php if(RESTORE_FROM_PORTAL){ ?>
            <span class="d-none restoreFromPortal">enable</span>
        <?php }else{ ?>
            <span class="d-none restoreFromPortal">disable</span>
        <?php } ?>
    <?php }else{ ?>
        <span class="d-none restoreFromPortal">disable</span>
    <?php } ?>
    <?php if($data['policy']['shareEnabled'] == "1"){ ?>
        <span class="d-none shareEnabled">enabled</span>
    <?php }else{ ?>
        <span class="d-none shareEnabled">disabled</span>
    <?php } ?>
    <span class="d-none deviceName"><?=$data['crumb2']?></span>
    <span class="d-none currentPage"><?='files'?></span>
    <span class="d-none userType"><?=$data['userType']?></span>
    <span class="d-none ngTracker"><?='backup'?></span>
    <span class="d-none isAdmin"><?=$data['isAdmin']?></span>
    <span class="d-none overridePolicySettings"><?=$data['overridePolicySettings']?></span>
    <span class="d-none isAdminDeleteBackupFile"><?=$data['isAdminDeleteBackupFile']?></span>
    <span class="d-none canAdminRestoreAll"><?=$data['canAdminRestoreAll']?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="d-none device_type"><?=$data['device_type']?></span>
    <span class="d-none device_OS"><?=$data['device_OS']?></span>
    <span class="d-none view_enable"><?php if(view == false){echo 'false';}else{echo 'true';}?></span>
    <span class="d-none disable_download" id="disable_download"><?php if(DISABLE_DOWNLOAD == false){echo 'false';}else{echo 'true';}?></span>
    <span class="d-none disable_view"><?php if(DISABLE_VIEW == false){echo 'false';}else{echo 'true';}?></span>
    <span class="d-none extensionsToPdfView"><?=$data['extensionsToPdfView']?></span>
    <span class="d-none deviceUserName"><?=base64_decode($data['deviceUserName'])?></span>
    <span class="d-none uuid"><?=$data['uuid']?></span>
    <span class="d-none isblocked"><?=$data['isblocked']?></span>
    <span class="hide privacyGatewayNames"><?=$data['privacyGatewayNames']?></span>
    <span class="hide searchAlgoForPg"><?=$data['searchAlgoForPg']?></span>
    <span class="hide canAdminRestoreDevice"><?=$data['canAdminRestoreDevice']?></span>
    <span class="hide allowEndUserTocontrolRestore"><?=$data['allowEndUserTocontrolRestore']?></span>
    <span class="hide canAdminRestore"><?=$data['canAdminRestore']?></span>
    <span class="hide shareDomainType"><?=$data['shareDomainType']?></span>
    <span class="hide shareDomainIncExclusions"><?=$data['shareDomainIncExclusions']?></span>
    <div class="row profile">
	<div class="row col-lg-12" style="flex-flow: row-reverse;">
		<?php if($data['device_type'] != 'OUTLOOK'){?>
			<div>
                             <div class="checkbox check-primary">
                             	<input id="restoreDeletedFile" name="restoreDeletedFile" type="checkbox" value="enabled">
                             	<label for="restoreDeletedFile"><?=Language::show('Include deleted files', 'keywords');?></label>
                             	<a href="#" data-toggle="tooltip" data-placement="left" title="Show files and folders even if they were deleted on the source as of the time of the latest backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                             </div>
                        </div>
		<?php } ?>
	</div>
	<?php if($data['device_type'] == 'OUTLOOK'){?>
	<div class="col-lg-1 col-md-1 col-sm-1">
        </div>
	<div class="col-lg-11 col-md-11 col-sm-11">
		<!--<div class="col-lg-8 col-md-11 col-sm-11<?php if(!isMobile()){?> pull-right <?php } ?>" <?php if(!isMobile()){?> style="float:unset;" <?php } ?>>-->
		<div class="row" style="margin-left:0px;margin-right:0px;">
			<div class="col-lg-8 col-md-11 col-sm-11">
				<form ng-submit="searchOutlook(search.outlook,1)">
					<input name="searchOutlook" type="text" class="form-control" ng-model="search.outlook" placeholder="Search" style="margin-left:-15px;" />
				</form>
			</div>
			<div class="col-lg-4 col-md-11 col-sm-11" >
                                <a ng-click="exportCompleteMailbox()"  class="btn btn-success btn-small exportCompleteMailbox">Export complete mailbox</a>
                                <input class="hide" id="restoreDeletedFile" name="restoreDeletedFile" type="checkbox" value="enabled">
				<?php if($data['device_type'] == 'OUTLOOK'){ ?>
                                	<label class="hide" for="restoreDeletedFile"><?=Language::show('Include Deleted Emails', 'keywords');?></label>
                                	<a class="hide" href="#" data-toggle="tooltip" data-placement="left" title="Show Emails and folders even if they were deleted on the source as of the time of the latest backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
				<?php }else{  ?>
                                	<label for="restoreDeletedFile"><?=Language::show('Include Deleted Files', 'keywords');?></label>
                                	<a href="#" data-toggle="tooltip" data-placement="left" title="Show files and folders even if they were deleted on the source as of the time of the latest backup."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
				<?php } ?>
                                <!--<a ng-click="exportCompleteMailbox()"  class="btn btn-success btn-small exportCompleteMailbox pull-right" style="margin-right:-15px;">Export complete mailbox</a>-->
                        </div>
		</div>
        </div>
        <?php } ?>
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>        
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li style="float:left !important;" ng-cloak><a href="javascript:;" ng-click="updateFileList('root','root')"><i class="fa fa-home"></i> root</a></li>
                        <li style="float:left !important;" ng-repeat="value in crumb track by $index" ng-cloak><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ value }}">{{ value }}</a></li>
                    </ul>
                    <ul class="nav navbar-nav <?php if(!isMobile()){?> pull-right <?php } ?> nav-actions">
                        <!--<li style="float:left !important;" ng-if="showDelete == true" <?php if($data['isAdmin'] != 'true'){ ?> class="d-none" <?php } ?>><a ng-click="deleteConfirmation()" class="toolTip" data-toggle="tooltip" data-placement="top" title="Delete" href="javascript:;" style="color: black !important;"><i class="fa fa-trash"></i></a></li></li>-->
			<li style="float:left !important;" ng-if="showDelete == true && isOutlook == false" <?php if($data['isAdmin'] != 'true'){ ?> class="d-none" <?php } ?>><a ng-click="deleteConfirmation()" class="toolTip deleteAction" data-toggle="tooltip" data-placement="top" title="Delete" href="javascript:;" style="display: none; color: black !important;"><i class="fa fa-trash"></i></a></li></li>
			<li style="float:left !important;" ng-if="showDelete == true && isOutlook == true" <?php if($data['isAdmin'] != 'true'){ ?> class="d-none" <?php } ?>><a ng-click="deleteConfirmationOutlook()" class="toolTip deleteOutlook" data-toggle="tooltip" data-placement="top" title="Delete" href="javascript:;" style="display: none; color: black !important;"><i class="fa fa-trash"></i></a></li></li>
                        <li style="float:left !important;" ng-if="showVersions == true"><a ng-click="getVersions()" class="toolTip versionsBtn" style="display: none" data-toggle="tooltip" data-placement="top" title="Versions" href="javascript:;" style="color: black !important;"><i class="fa fa-clock-o"></i></a></li>
                        <!--<li style="float:left !important;" ng-if="showDownload == true" <?php if(DISABLE_DOWNLOAD == true){ ?> class="d-none" <?php } ?>><a class="downloadAction toolTip" ng-click="download('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a></li>-->
			<li style="float:left !important;" ng-if="showView == true" <?php if(DISABLE_VIEW == true){ ?> class="d-none" <?php } ?> <?php if(view == false){ ?> class="disabled" style="opacity: 0.65;" <?php } ?>><a class="viewAction toolTip" data-toggle="tooltip" data-placement="top"  <?php if(view == true){ ?> title="View" style="display: none; color: black !important;" ng-click="view('')" href="javascript:;" <?php } else {?> style="display: none"  title="View is Disabled in Lite Version" <?php } ?>><i class="fa fa-eye"></i></a></li>
			<!--<li style="float:left !important;"><a class="downloadActionOutlook toolTip" ng-click="downloadOutlook('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none; color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a></li>-->
			<!--<li style="float:left !important;"><a class="inplaceRestoreeFile toolTip" ng-click="initiateRestoreForOutlookFileModal()" data-toggle="tooltip" data-placement="top" title="Restore" style="display:none;color: black !important;" href="javascript:;"><i class="fa fa-history"></i></a></li>-->
			<li style="float:left !important;" ng-if="showDownload == true" <?php if(DISABLE_DOWNLOAD == true){ ?> class="hide" <?php } ?>><a class="downloadAction toolTip" ng-click="download('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none;color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a><a class="downloadActionOutlook toolTip" ng-click="downloadOutlook('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none; color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a></li>
			<li style="float:left !important;" ng-if="showRestore == true">
				<a ng-click="initiateRestoreBackupforFiles('')" class="toolTip initiateRestoreBtnTop" data-toggle="tooltip" data-placement="top" title="Initiate Restore" href="javascript:;" style="display:none;color: black !important;"><i class="fa fa-history"></i></a>
				<a class="inplaceRestoreeOutlook toolTip" ng-click="initiateRestoreForOutlookModal()" data-toggle="tooltip" data-placement="top" title="Restore" style="display:none;color: black !important;" href="javascript:;"><i class="fa fa-history"></i></a>
				<a class="inplaceRestoreeFile toolTip" ng-click="initiateRestoreForOutlookFileModal()" data-toggle="tooltip" data-placement="top" title="Restore" style="display:none;color: black !important;" href="javascript:;"><i class="fa fa-history"></i></a>
				<a class="inplaceRestoreeFileOnedrive toolTip" ng-click="initiateRestoreForOneDriveModal()" data-toggle="tooltip" data-placement="top" title="Restore" style="display:none;color: black !important;" href="javascript:;"><i class="fa fa-history"></i></a>
			</li>		    
                        <?php if($data['policy']['menuOptions']['share'] == "1"){ ?>
                            <li style="float:left !important;" ng-if="showShare == true"><a class="shareAction toolTip" ng-click="share('')" data-toggle="tooltip" data-placement="top" title="Share" style="display: none;color: black !important;" href="javascript:;"><i class="fa fa-share"></i></a></li>
                        <?php } ?>
                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                <li style="float:left !important;" ng-if="showInitiateRestore == true"><a ng-click="initiateRestoreBackupforFiles('')" class="toolTip initiateRestoreBtn" ng-if="selectedFileForRestoreList.length > 0 || selectedFilesForRestoreFromVersions.length > 0" data-toggle="tooltip" data-placement="top" title="Initiate Restore" href="javascript:;" style="color: black !important;"><i class="fa fa-recycle"></i></a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow backupFilesTable" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                            <col class="col-xs-2">
                        </colgroup>
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'clientModifiedTimeInMillis'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'clientModifiedTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'clientModifiedTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'rawSize'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'rawSize' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'rawSize' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse">
                            <td data-name="{{value.name}}" ng-if="value.type == 'Folder' && value.exists == 'true'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" <?php if($data['device_type']=='OUTLOOK'){?> ng-click="updateFileListOutlook(crumbString+value.name, value.name, true)" <?php } else { ?> ng-click="updateFileList(crumbString+value.name, value.name, true)" <?php } ?> style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name | charLimit"></span></a></td>
			    <td data-name="{{value.name}}" ng-if="value.type == 'Folder' && value.exists == 'false'"><i style="color: #c5bcbc !important;" class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" <?php if($data['device_type']=='OUTLOOK'){?> ng-click="updateFileListOutlook(crumbString+value.name, value.name, true)" <?php } else { ?> ng-click="updateFileList(crumbString+value.name, value.name, true)" <?php } ?> style="cursor: pointer;color: #c5bcbc !important;font-style:italic;"><span ng-cloak ng-bind-html="value.name | charLimit"></span></a></td>
                            <td data-name="{{value.name}}" ng-if="value.type == 'File' && value.exists == 'true'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer;color: #000 !important;"><span ng-bind-html="value.name | charLimit"></span></a></td>
			    <td data-name="{{value.name}}" ng-if="value.type == 'File' && value.exists == 'false'"><i style="color: #c5bcbc !important;" class="fa fa-{{ value.icon }} fa-1x"></i> <a ng-class="{{value.exists}}" style="cursor: pointer;color: #c5bcbc !important;font-style:italic;"><span ng-bind-html="value.name | charLimit"></span></a></td>
                            <td ng-if="value.exists == 'true'"> {{ value.type }} </td>
			    <td ng-if="value.exists == 'false'" style="color: #c5bcbc !important;font-style:italic;"> {{ value.type }} </td>
                            <td ng-if="value.exists == 'true'"> {{ value.clientModifiedTime }} </td>
			    <td ng-if="value.exists == 'false'" style="color: #c5bcbc !important;font-style:italic;"> {{ value.clientModifiedTime }} </td>
                            <td ng-if="value.type == 'Folder'"> - </td>
                            <td ng-if="value.type == 'File' &&  value.exists == 'true'">
                                {{ value.size }}
                                <?php if(hosted_setup == false){ ?><span ng-if="value.storagePlace == 'PG'" class="text-warning"> <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span></span><?php } ?>
                            </td>
			    <td ng-if="value.type == 'File' && value.exists == 'false'" style="color: #c5bcbc !important;font-style:italic;">
                                {{ value.size }}
                                <?php if(hosted_setup == false){ ?><span ng-if="value.storagePlace == 'PG'" class="text-warning"> <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span></span><?php } ?>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php } ?>
                </div>
            </div>
<!-- OUTLOOK FULL VIEW START -->
<!--<div class="panel panel-default files-panel no-box-shadow backupFilesTableOutlookFull col-lg-6" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-lg-12">
                            <col class="col-lg-4">
                            <col class="col-lg-3">
                        </colgroup>
                        <thead>
                        <tr>
<th>From</th>
</tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
			       selectable-out="selected"
selectable-options="{filter:'tr', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items">
                            <td data-name="{{value.name1}}" ng-if="value.type == 'Folder'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
                            <td data-name="{{value.name1}}" ng-if="value.type == 'File'">
                                <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                <a style="cursor: pointer;color: #000 !important;">
                                    <span ng-bind-html="value.from"></span>
                                    <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right"></i>
                                    <p>
                                        <span ng-bind-html="value.name"></span>
                                        <span style="float:right" ng-bind-html="value.sentDate"></span>
                                    </p>
                                    <p>
                                        <span ng-bind-html="value.displayContent | trustAsHtml"></span>
                                    </p>
                                    <p>
                                        <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name}} </span>&nbsp;
                                        <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                    </p>
                                </a>
                            </td>
                        </tr>
                        </tbody>
 </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p>
                </div>
	    </div>-->
<!-- OUTLOOK FULL VIEW END -->
<!--OUTLOOK FULL VIEW START WITH PANEL -->
<div class="panel panel-default files-panel no-box-shadow backupFilesTableOutlookFull1" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-lg-12">
                            <col class="col-lg-4">
                            <col class="col-lg-3">
                        </colgroup>
                        <thead>
                        <tr>
<th>From</th>
</tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="value in items">
                            <td data-name="{{value.name1}}" ng-if="value.type == 'Folder'">
                            	<i class="fa fa-{{ value.icon }} fa-1x"></i>
                            	<a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;">
                            		<span ng-cloak ng-bind-html="value.name1"></span>
                            	</a>
                            </td>
							<td data-name="{{value.name1}}" ng-if="value.type == 'File'" style="border-top: 1px solid #fff !important;">
                            <div class="panel-group">
							    <div class="panel panel-default">
							      <div class="panel-heading">
							        <h4 class="panel-title">
							          <a data-toggle="collapse" href="#collapse{{$index}}">
							          	<i class="fa fa-{{ value.icon }} fa-1x"></i>
							          	<span style="color:black !important;" ng-bind-html="value.from"></span>
					<i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right"></i>
<span style="float:right;color:black !important;" ng-bind-html="value.sentDate"></span>
<p style="margin-top: 4px;">
                                        <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:4px;">{{val.name}} </span>&nbsp;
                                        <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                    </p>
							<!--			<p>
                                        	<span style="float:right" ng-bind-html="value.sentDate"></span>
                                    	</p>-->
							          </a>
							        </h4>
							      </div>
							      <div id="collapse{{$index}}" class="panel-collapse collapse">
								<div class="panel-body">
<a class="toolTip" ng-click="downloadOutlookFromPanel(value.backupId, value.userName)" data-toggle="tooltip" data-placement="top" title="Download" style="float:right;color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a>
<div>
<div ng-if="value.subject" class="subject11"><h3>Subject : {{value.subject}}</h3></div>
                        <div ng-if="value.from" class="from11"><p><b>From : </b> {{value.from}}</p></div>
                        <div ng-if="value.sentDate" class="sentDate11"><p>{{value.sentDate}}</p></div>
                        <div ng-if="value.to" class="to11"><p><b>To : </b>{{value.to}}</p></div>
                        <div ng-if="value.cc" class="cc11"><p><b>CC : </b>{{value.cc}}</p></div>
                        <div ng-if="value.bcc" class="bcc11"><p><b>BCC : </b>{{value.bcc}}</p></div>
<span ng-repeat="val in value.attachments" span style="border: 1px solid #f27331;padding:10px;">{{val.name}} <a ng-click="downloadAttachmentFromPanel(value.backupId, value.userName, val.id)" href="javascript:;"><i class="fa fa-download"></i></a></span>&nbsp;
</div>
</br>
<span ng-bind-html="value.bodyContent"></span>
</div>
							      </div>
							    </div>
							 </div>
							</td>
                        </tr>
                        </tbody>
 </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php } ?>
                </div>
            </div>
<!-- OUTLOOK FULL VIEW END WITH PANEL -->
<!--OUTLOOK MEDIUM VIEW START WITH PANEL -->
<div class="panel panel-default files-panel no-box-shadow backupFilesTableOutlookMedium1" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-lg-12">
                            <col class="col-lg-4">
                            <col class="col-lg-3">
                        </colgroup>
                        <thead>
                        <tr>
<th>From</th>
</tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="value in items">
                            <td data-name="{{value.name1}}" ng-if="value.type == 'Folder'">
                                <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                <a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;">
                                        <span ng-cloak ng-bind-html="value.name1"></span>
                                </a>
                            </td>
                                                        <td data-name="{{value.name1}}" ng-if="value.type == 'File'" style="border-top: 1px solid #fff !important;">
                            <div class="panel-group">
                                                            <div class="panel panel-default">
                                                              <div class="panel-heading">
                                                                <h4 class="panel-title">
                                                                  <a data-toggle="collapse" href="#collapseMedium{{$index}}">
                                                                        <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                                                        <span style="color:black !important;" ng-bind-html="value.from"></span>
                                        <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right"></i>
<span style="float:right;color:black !important;" ng-bind-html="value.sentDate"></span>
<!--<p style="margin-top: 4px;">
<span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:4px;">{{val.name}} </span>&nbsp;
                                        <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                    </p>-->
                                                        <!--                    <p>
                                                <span style="float:right" ng-bind-html="value.sentDate"></span>
                                        </p>-->
                                                                  </a>
                                                                </h4>
                                                              </div>
                                                              <div id="collapseMedium{{$index}}" class="panel-collapse collapse">
                                                                <div class="panel-body">
<a class="toolTip" ng-click="downloadOutlookFromPanel(value.backupId, value.userName)" data-toggle="tooltip" data-placement="top" title="Download" style="float:right;color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a>
<div>
<div ng-if="value.subject" class="subject11"><h3>Subject : {{value.subject}}</h3></div>
                        <div ng-if="value.from" class="from11"><p><b>From : </b> {{value.from}}</p></div>
                        <div ng-if="value.sentDate" class="sentDate11"><p>{{value.sentDate}}</p></div>
                        <div ng-if="value.to" class="to11"><p><b>To : </b>{{value.to}}</p></div>
                        <div ng-if="value.cc" class="cc11"><p><b>CC : </b>{{value.cc}}</p></div>
                        <div ng-if="value.bcc" class="bcc11"><p><b>BCC : </b>{{value.bcc}}</p></div>
<span ng-repeat="val in value.attachments" span style="border: 1px solid #f27331;padding:10px;">{{val.name}} <a ng-click="downloadAttachmentFromPanel(value.backupId, value.userName, val.id)" href="javascript:;"><i class="fa fa-download"></i></a></span>&nbsp;
</div>
</br>
<span ng-bind-html="value.bodyContent"></span>
</div>
                                                              </div>
                                                            </div>
                                                         </div>
                                                        </td>
</tr>
                        </tbody>
 </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php } ?>
                </div>
            </div>
<!-- OUTLOOK MEDIUM VIEW END WITH PANEL -->
<!--OUTLOOK MEDIUM VIEW START -->
<!--<div class="panel panel-default files-panel no-box-shadow backupFilesTableOutlookMedium col-lg-6" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-lg-12">
                            <col class="col-lg-4">
                            <col class="col-lg-3">
                        </colgroup>
                        <thead>
                        <tr>
<th>From</th>
</tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items">
                            <td data-name="{{value.name1}}" ng-if="value.type == 'Folder'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
                            <td data-name="{{value.name1}}" ng-if="value.type == 'File'">
                                <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                <a style="cursor: pointer;color: #000 !important;">
                                    <span ng-bind-html="value.from"></span>
                                    <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right"></i>
                                    <p>
                                        <span style="float:right" ng-bind-html="value.sentDate"></span>
				    </p>
                                </a>
                            </td>
                        </tr>
                        </tbody>
 </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p>
                </div>
            </div>-->
<!-- OUTLOOK MEDIUM VIEW END -->
<!--<div class="row paginationOutlook">
<div class="col-lg-12 text-center">
<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" ng-click="updateFileListNavigate(filePath, currentPath, update, refreshed,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a></a>
<a class="btn btn-primary previous" ng-click="updateFileListNavigate(filePath, currentPath, update, refreshed,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" ng-click="updateFileListNavigate(filePath, currentPath, update, refreshed,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" ng-click="updateFileListNavigate(filePath, currentPath, update, refreshed,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>-->
<!--testing OUTLOOK BOTTOM VIEW START start -->
<hr style="border-top:1px solid black !important;display:none;">
<hr style="border-top:1px solid black !important;display:none;">
        <div class="row backupFilesTableOutlookBottom col-lg-12"  style="display:none">
            <div class="col-lg-12">
            <div class="row">
<!--                <span style="margin-left:20px;font-weight:600;" ng-repeat="value in crumb track by $index" ng-cloak> {{value}}</span>-->
            </div>
<div class="panel panel-default files-panel1 no-box-shadow">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
 <col class="col-lg-4">
                            <col class="col-lg-6">
                            <col class="col-lg-2">
			</colgroup>
<thead>
                        <tr>
                            <th>From</th>
                            <th>Subject</th>
                            <th>Date Received</th>
                        </tr>
                        </thead>
<tbody>
<tr ng-class="{'selected':$index == selectedRow}" ng-repeat="value in items">
<td data-name="{{value.name1}}" ng-if="value.type == 'Folder'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
<td data-name="{{value.name}}" ng-if="value.type == 'File'" ng-click="viewOutlook11Bottom(value.userName,value.backupId, value.name, $index)">
                                <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                <a class="folder" style="cursor: pointer;color: #000 !important;">
                                    <span ng-bind-html="value.from | limitTo: 50"></span>
                                </a>
                            </td>
<td data-name="{{value.name}}" ng-if="value.type == 'File'" ng-click="viewOutlook11Bottom(value.userName,value.backupId, value.name, $index)" style="white-space: unset !important;">
<!--                                <a class="folder" style="cursor: pointer;color: #000 !important;">-->
                                    <span ng-bind-html="value.name | charLimitMail"></span>
<!--                                    	<span ng-if="value.displayContent" ng-bind-html="value.displayContent | trustAsHtml"></span>-->
<span ng-if="value.bodyContent1" ng-bind-html="value.bodyContent1 | trustAsHtml" style="color:grey !important;"></span>
<p ng-if="value.attachments.length > 0">
                                        <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name | limitTo:20}}{{val.name.length > 20 ? '...' : ''}} </span>&nbsp;
<span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                    </p>
<!--                                </a>-->
                            </td>
<td data-name="{{value.name}}" ng-if="value.type == 'File'" ng-click="viewOutlook11Bottom(value.userName,value.backupId, value.name, $index)">
                                    	<span ng-bind-html="value.sentDate"></span>
                            </td>
<!--                            <td data-name="{{value.name}}" ng-if="value.type == 'File'" ng-click="viewOutlook11Bottom(value.userName,value.backupId, value.name, $index)">
                                <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                <a class="folder" style="cursor: pointer;color: #000 !important;">
                                    <span ng-bind-html="value.from | limitTo: 50"></span>
                                    <p class="folder" ><span ng-bind-html="value.name | charLimitMail"></span>
                                    <span style="float:right" ng-bind-html="value.sentDate"></span></p>
                                    <p ng-if="value.displayContent"><span ng-bind-html="value.displayContent | trustAsHtml"></span></p>
                                    <p ng-if="value.attachments.length > 0">
                                        <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name | limitTo:20}}{{val.name.length > 20 ? '...' : ''}} </span>&nbsp;
<span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                    </p>
                                </a>
                            </td>-->
                        </tr>
                        </tbody>
                    </table>
                    </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php } ?>
</div>
            </div>
	    </div>
<hr style="border-top:1px solid black !important;display:none;">
            <div class="col-lg-12 mailViewBottom" style="display:none">
                <div class="panel" style="overflow-x: scroll;overflow-y: scroll;height:500px;">
                    <div class="panel-heading"></div>
		    <div class="panel-body">
<a class="toolTip" ng-click="downloadOutlook()" data-toggle="tooltip" data-placement="top" title="Download" style="float:right;color: black !important;" href="javascript:;"><i class="fa fa-download"></i></a>
                        <div class="subject1Bottom" style="display: none;"></div>
                        <div class="from1Bottom" style="display: none;"></div>
                        <div class="sentDate1Bottom" style="display: none;"></div>
                        <div class="to1Bottom" style="display: none;"></div>
                        <div class="cc1Bottom" style="display: none;"></div>
                        <div class="bcc1Bottom" style="display: none;"></div>
                        <div class="attachments1Bottom" style="display: none;">
<div class="dataa1Bottom" style="display:none;">
<span ng-repeat="value1 in attachments" style="margin-right:5px;border: 1px solid #f27331;padding:2px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
<a ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
</span>&nbsp;
</div>
</div>
</br>
<iframe class="contentOutlook1Bottom" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
                    </div>
                </div>
            </div>
    </div>
<!--testing OUTLOOK BOTTOM VIEW END end-->
<!--testing OUTLOOK COMPACTT VIEW START start -->
<hr style="border-top:1px solid black !important;display:none;">
<hr style="border-top:1px solid black !important;display:none;">
        <div class="row backupFilesTableOutlookCompactt col-lg-12"  style="display:none">
            <div class="col-lg-4">
                <div class="row">
                </div>
                <div class="panel panel-default files-panel1 no-box-shadow">
                    <div class="table-responsive">
                        <table id="files-table" class="table table-striped table-hover files-table">
                            <colgroup>
                            	<col class="col-lg-1">
                            	<col class="col-lg-10">
                            </colgroup>
                            <!--<tr ng-class="{'selected':$index == selectedRowMails}" ng-repeat="value in items">
                                <td data-name="{{value.name1}}" ng-if="value.type == 'Folder'" ng-click="showRestoreSubfolder(value.deviceUUID, value.backupId, $index, value.name1, value.userName)" style="width:100%;"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
                                <td data-name="{{value.name}}" ng-show="value.name != '' && value.from != '' && value.taskSubject == ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.name, value.deviceUUID, value.type, $index, 'mail')" style="width:100%;">
                                    <i class="fa fa-{{ value.icon }} fa-1x"></i>
                                    <a class="folder" style="cursor: pointer;color: #000 !important;">
                                        <span ng-bind-html="value.from | limitTo: 50"></span>
                                        <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right" style="color: #000 !important;"></i>
                                        <p class="folder" ><span ng-bind-html="value.name | charLimitMail"></span>
                                        <span style="float:right" ng-bind-html="value.sentDate"></span></p>
                                        <p ng-if="value.displayContent"><span ng-bind-html="value.displayContent | trustAsHtml"></span></p>
                                        <p ng-if="value.attachments.length > 0">
                                            <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name | limitTo:20}}{{val.name.length > 20 ? '...' : ''}} </span>&nbsp;
                                            <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                            </p>
                                    </a>
                                </td>-->
			    <tr ng-class="{'selected':$index == selectedRowMails}" ng-repeat="value in items">
				<td style="vertical-align:middle;">
					<i ng-if="value.type == 'Folder'"class="fa fa-{{ value.icon }} fa-1x"></i>
					<span class="aplhaC" ng-if="value.type == 'File' && value.present == true" style="line-height: 28px;text-align: center;display: inline-block;height: 28px;width: 28px;border-radius: 50%;background:{{value.alphaColor}};">{{value.showIcon}}</span>
					<span class="aplhaC" ng-if="value.type == 'File' && value.present == false" style="line-height: 28px;text-align: center;display: inline-block;height: 28px;width: 28px;border-radius: 50%;background:{{value.alphaColor}};opacity:0.5;">{{value.showIcon}}</span>
				</td>
                                <td class="col-lg-12" style="font-size:14px !important;" data-name="{{value.name1}}" ng-if="value.type == 'Folder' && value.present == true" ng-click="showRestoreSubfolder(value.deviceUUID, value.backupId, $index, value.name1, value.userName)" style="width:100%;"><a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #000 !important;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
				<td class="col-lg-12" style="font-size:14px !important;" data-name="{{value.name1}}" ng-if="value.type == 'Folder' && value.present == false" ng-click="showRestoreSubfolder(value.deviceUUID, value.backupId, $index, value.name1, value.userName)" style="width:100%;"><a class="folder" ng-click="updateFileListOutlook(crumbString+value.name1, value.name1, true)" style="cursor: pointer;color: #c5bcbc !important;font-style:italic;"><span ng-cloak ng-bind-html="value.name1"></span></a></td>
                                <!--<td class="col-lg-12" style="font-size:14px !important;" data-name="{{value.name}}" ng-show="value.name != '' && value.from != '' && value.taskSubject == ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.name, value.deviceUUID, value.type, $index, 'mail')" style="width:100%;">-->
				<!--<td class="col-lg-12" style="font-size:14px !important;" data-name="{{value.name}}" ng-show="value.bodyContent1 != '' && value.taskSubject == ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.name, value.deviceUUID, value.type, $index, 'mail')" style="width:100%;">-->
				<td class="col-lg-12" style="font-size:14px !important;" data-name="{{value.name}}" ng-show="value.taskSubject == ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.name, value.deviceUUID, value.type, $index, 'mail')" style="width:100%;">
                                        <div class="col-lg-12">
                                                <div>
                                                        <a ng-if="value.present == true" class="folder" style="cursor: pointer;color: #000 !important;">
                                                                <span style="font-weight:bold;"> {{value.from | limitTo:10}}{{value.from.length > 10 ? '...' : ''}}</span>
                                                                <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right" style="color: #000 !important;"></i>
                                                                <p class="folder" >
                                                                        <span style="color:#f27331;">{{value.name | limitTo:25}}{{value.name.length > 25 ? '...' : ''}}</span>
                                                                        <span style="float:right;color:grey;" ng-bind-html="value.sentDate"></span>
                                                                </p>
                                                                <p ng-if="value.displayContent"><span ng-bind-html="value.displayContent | trustAsHtml"></span></p>
                                                                <p ng-if="value.attachments.length > 0">
									<span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name | limitTo:20}}{{val.name.length > 20 ? '...' : ''}} </span>&nbsp;
                                                                        <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                                                </p>
                                                        </a>
                                                        <a ng-if="value.present == false" class="folder" style="cursor: pointer;color: #c5bcbc !important;font-style:italic;">
                                                                <span style="font-weight:bold;"> {{value.from | limitTo:10}}{{value.from.length > 10 ? '...' : ''}}</span>
                                                                <i ng-if="value.hasAttachments == true" class="fa fa-paperclip fa-1x pull-right" style="color: #c5bcbc !important;"></i>
                                                                <p class="folder" >
                                                                        <span style="color:#c5bcbc;">{{value.name | limitTo:25}}{{value.name.length > 25 ? '...' : ''}}</span>
                                                                        <span style="float:right;color:grey;" ng-bind-html="value.sentDate"></span>
                                                                </p>
                                                                <p ng-if="value.displayContent"><span ng-bind-html="value.displayContent | trustAsHtml"></span></p>
                                                                <p ng-if="value.attachments.length > 0">
                                                                        <span ng-repeat="val in value.attachments |limitTo:1" span style="border: 1px solid #f27331;padding:2px;">{{val.name | limitTo:20}}{{val.name.length > 20 ? '...' : ''}} </span>&nbsp;
                                                                        <span ng-if="value.attachments.length > 1"> + {{value.attachments.length - 1}}</span>
                                                                </p>
                                                        </a>
                                                </div>
                                        </div>
                                </td>
				<!--<td data-name="{{value.contactName}}" ng-show="value.name == '' && value.from == '' && value.taskSubject == ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.contactName, value.deviceUUID, value.type, $index, 'contacts')" style="width:100%;white-space: unset !important;">
                                    <i class="fa fa-newspaper-o fa-1x"></i>
                                    <a class="folder" style="cursor: pointer;color: #000 !important;">
                                        <span ng-bind-html="value.contactName | charLimitMail"></span>
                                    </a>
                                </td>
                                <td data-name="{{value.taskSubject}}" ng-show="value.name == '' && value.from == '' && value.taskSubject != ''" ng-if="value.type == 'File'" ng-click="viewOutlook11(value.userName,value.backupId, value.taskSubject, value.deviceUUID, value.type, $index, 'tasks')" style="width:100%;white-space: unset !important;">
                                    <i class="fa fa-calendar-o fa-1x"></i>
                                    <a class="folder" style="cursor: pointer;color: #000 !important;">
                                        <span ng-bind-html="value.taskSubject | charLimitMail"></span>
                                    </a>
                                </td>-->
                            </tr>			    
                        </table>
                    </div>
                    <div class="panel-footer" ng-if="items.length > 0">
                        <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php } ?>
</div>
                </div>
            </div>
            <div class="col-lg-8 mailView" style="display:none">
                <div class="panel panelContacts" id="panelContacts" style="display:none;height:300px;">
                    <div class="panel-heading"><h3>Contact Details</h3></div>
                    <div class="panel-body" id="contactspanelBody">
                    <!--contact view start-->
                        <div class="row col-lg-12 example">
                            <div class="col-lg-3">
                                <div class="contactPic" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic('admin')?>" style="border: 1px solid #f27331;"/>
                                </div>
                                <br/>
                            </div>
                            <div class="col-lg-9">
                                <br>
                                <div class="contactName" style="display: none;color: #f27331;"></div>
				<div class="contactInformation"  style="display: none;">
					<div class="contactPhone" style="display: none;color: #f27331;"></div>
					<div class="contactAddress" style="display: none;color: #f27331;"></div>
				</div>
                            </div>
                        </div>
                    <!--contact view end-->
                    </div>
                </div>
                <div class="panel panelTasks" id="panelTasks" style="display:none;height:300px;">
                    <div class="panel-heading"><h3>Task Details</h3></div>
                    <div class="panel-body" id="taskspanelBody">
                        <div class="row col-lg-12">
                            <div class="example">
                                <div class="taskSubject" style="display: none;color: #f27331;"></div>
                                <div class="taskStartDate" style="display: none;color: #f27331;"></div>
                                <div class="taskDueDate" style="display: none;color: #f27331;"></div>
                                <div class="taskReminderTime" style="display: none;color: #f27331;"></div>
                            </div>
			</div>
                    </div>
                </div>
                <div class="panel panelFolder" style="display:none;overflow-x: scroll;overflow-y: scroll;height:500px;">
                                    <div class="panel-heading"></div>
                                    <div class="panel-body">
                                        <iframe class="contentOutlook1Folder" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;">
                                        </iframe>
                                    </div>
                </div>
                <div class="panel panelMail" id="panelMail" style="display:none;overflow-x: scroll;overflow-y: scroll;height:500px;">
                    <div class="panel-heading"></div>
                    <div class="panel-body" id="mailpanelBody">
                        <div class="subject1" style="display: none;"></div>
                        <div class="from1" style="display: none;"></div>
                        <div class="sentDate1" style="display: none;"></div>
                        <div class="to1" style="display: none;"></div>
                        <div class="cc1" style="display: none;"></div>
                        <div class="bcc1" style="display: none;"></div>
                        <div class="attachments1" style="display: none;">
                            <div class="dataa1" style="display:none;">
                                <span ng-repeat="value1 in attachments" style="margin-right:5px;border: 1px solid #f27331;padding:2px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
                                    <a class="d-none" ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
                                </span>&nbsp;
                            </div>
                        </div>
                        <br>
			<div class="contentOutlook1Div">
	                        <iframe class="contentOutlook1" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
			</div>
		    </div>
                </div>
            </div>
        </div>
<!--testing end OUTLOOK COMPACTT VIEW END-->
<!--</div>
</div>-->
<div class="row paginationOutlook" style="display: none;">
<div class="col-lg-12 text-center">
<p ng-if="currentpageCount !='' && totalpageCount != ''"><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" ng-click="updateFileListOutlookNavigate(filePath, currentPath, update, refreshed,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a></a>
<a class="btn btn-primary previous" ng-click="updateFileListOutlookNavigate(filePath, currentPath, update, refreshed,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" ng-click="updateFileListOutlookNavigate(filePath, currentPath, update, refreshed,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" ng-click="updateFileListOutlookNavigate(filePath, currentPath, update, refreshed,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>
            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> backupFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <h4 class="modal-title">
                                File Versions list - File Name: <span>{{ selected[0].name }}</span>
			    </h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                    <thead>
                                    <tr>
                                        <th><?=Language::show('version', 'keywords')?></th>
                                        <th class="clickAble" ng-click="sortType = 'clientModifiedTimeInMillis'; sortReverse = !sortReverse">
                                        <?=Language::show('time', 'keywords')?>
                                        <span ng-show="sortType == 'clientModifiedTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'clientModifiedTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th><?=Language::show('file_size', 'keywords')?></th>
                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            <?php }?>
                                        <?php }?>
                                        <th ng-show="showDownload == true || showView == true">Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr ng-repeat="value in fileVersions track by $index">
                                        <td ng-if="value.status == 'ADDED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <?php if(hosted_setup == false){ ?><span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span><?php } ?></td>
                                        <td ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <?php if(hosted_setup == false){ ?><span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span><?php } ?></td>
                                        <td ng-if="value.status == 'DELETED'" ng-cloak><span style="text-decoration: line-through;">{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></span></td>
                                        <td ng-if="value.status != 'DELETED'" ng-cloak>{{ value.clientModifiedTime }}</td>
                                        <td ng-if="value.status != 'DELETED'" ng-cloak><span class="text-info">{{ value.size }}</span></td>
                                        <td ng-if="value.status == 'DELETED'" ng-cloak><span class="text-info">-</span></td>
                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                                <td ng-cloak ng-if="value.status != 'DELETED'"><a class="btn btn-primary btn-small" ng-click="addToRestoreBackupFromRevisions($index, (fileVersions.length-$index))">Add to Restore</a></td>
                                                <td ng-cloak ng-if="value.status == 'DELETED'">-</td>
                                            <?php } ?>
                                        <?php } ?>
                                        <td ng-if="value.status != 'DELETED'">
						<a ng-if="showDownload == true"class="btn btn-primary btn-small" ng-click="downloadVersion($index)"><i class="fa fa-download"></i></a>
						<a ng-if="showView == true" class="btn btn-success btn-small" ng-click="viewVersions(value.backupId)"><i class="fa fa-eye"></i></a>
					</td>
                                        <td  ng-cloak ng-if="value.status == 'DELETED'">-</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <?php if(hosted_setup == false){ ?><p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p><?php }?>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
	    </div>
<div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="z-index: 10000000000; background-color:white !important;">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h5 class="modal-title">Loading ...</h5>
			    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <br/><br/>
                        <div class="modal-body">                            
                            <div class="subject" style="display: none;"></div>
                            <div class="from" style="display: none;"></div>
                            <div class="sentDate" style="display: none;"></div>
                            <div class="to" style="display: none;"></div>
                            <div class="cc" style="display: none;"></div>
<div class="bcc" style="display: none;"></div>
                            <div class="attachments" style="display: none;">
<div class="dataa" style="display:none;">
<span ng-repeat="value1 in attachments" style="margin-right:5px;border: 1px solid #f27331;padding:2px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
<a class="d-none" ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
</span>&nbsp;
</div>
</div>
</br>
<!--   <div class="contentOutlook" style="display: none;"></div>-->
<iframe class="contentOutlook" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
			    <div class="pageContainer" style="display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="display: none;"></div>
                            <div class="content" style="text-align: -moz-left;text-align: -webkit-auto;display: none;"></div>
                            <div class="imageViewer" style="display: none;"></div>
			    <div class="pptxViewer" style="background-color: white;display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
<!--            <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="z-index: 10000000000; background-color:white !important;">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Loading ...</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <div class="pageContainer" style="display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="display: none;"></div>
                            <div class="content" style="display: none;"></div>
                            <div class="imageViewer" style="display: none;"></div>
                            <div class="subject" style="display: none;"></div>
                            <div class="from" style="display: none;"></div>
                            <div class="sentDate" style="display: none;"></div>
                            <div class="to" style="display: none;"></div>
                            <div class="cc" style="display: none;"></div>
                            <div class="bcc" style="display: none;"></div>
                            <div class="attachments" style="display: none;"></div>
                            <div class="contentOutlook" style="display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
	    </div>--><div class="modal searchOutlookModal whiteAndBigModal" id="searchOutlookModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
				<div class="row col-lg-12">
					<div class="col-lg-4">
					    <h5 class="modal-title">Search Results for <b>{{searchText}}</b></h5>
					</div>
					<div class="col-lg-7">
					    <a class="btn btn-primary pull-right downloadAsPstGSearchlocal" ng-click="searchOutlook1PreAll()" style="display: none;margin-right: 10px;border-radius: 20px;">Download All</a>
					    <a class="btn btn-primary pull-right downloadAsPstGSearchlllocal" ng-click="squeezMailPaneLocal()" style="display: none;margin-right: 10px;border-radius: 20px;">Download Selected</a>
					    <a class="btn btn-primary pull-right downloadAsPstGSearchll11local" ng-click="searchOutlook1Pre('selected')" style="display: none;margin-right: 10px;border-radius: 20px;">Download selected items</a>
					    <a class="btn btn-danger pull-right removeAllLocal" ng-click="removeAllLocal()" style="display: none;margin-right: 10px;border-radius: 20px;">Unselect All</a>
					</div>
					<div class="col-lg-1">
					    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>
				</div>
                        </div>
                        <div class="modal-body">
                            <a class="h4 status-error-outlook" style="display: none;"></a>
			    <center><span id="searchSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                            <div class="row searchRow">
                                <div id="mailListSearch" class="col-lg-5 col-md-6 col-sm-3">        			    
				    <div class="table-responsive">
					<table class="table table-hover" style="background: white;">
						<colgroup>
							<col class="col-lg-1">
							<col class="col-lg-1">
							<col class="col-lg-10">
						</colgroup>
						<thead>
                                            		<tr>
                                                		<th><!--<input type="checkbox" title="Select all" class="select-allLocal checkbox" name="select-allLocal"/>--></th>
                                                		<th>Results</th>
                                            		</tr>
                                        	</thead>
					    	<tr ng-class="{'selectedForSearch':$index == selectedRowSearch}" ng-repeat="value in foundFilesOutlook track by $index">
							<td style="vertical-align:middle;">
								<input type="checkbox" class="select-itemLocal checkbox" ng-if="mailCheckmarklocal == true" name="{{value.subject}}" ng-click="itemSelectLocal(value.subject, value.fileRevisionID, value.deviceUUID, $event)" value="{{ value.fileRevisionID }}"/>
							</td>
							<td style="vertical-align:middle;">
								<span class="aplhaC" style="padding:10px !important;border: 1px solid black;border-radius:50%;background:{{value.alphaColor}};">{{value.showIcon}}</span>
							</td>
					    		<td ng-click="viewOutlookSearch(value.fileRevisionID, value.deviceId, $index)">
							    <div class="col-lg-10" style="width:90% !important;">
								<a class="h4" style="color:black;" ng-bind-html="value.subject | charLimitMail"> </a>
								<span class="pull-right">
									<i ng-if="value.hasAttachments == 'true'" class="fa fa-paperclip fa-1x attach" style="margin-right:5px;color:#f27331;font-weight:bold;"></i>
									<!--<a ng-if="mailCheckmarklocal == false" ng-click="searchDownloadOutlook(value.userName,value.fileRevisionID)" class="pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download" style="cursor:pointer;"><i class="fa fa-download"></i> </a>
									<a ng-if="mailCheckmarklocal == false" ng-click="initiateRestoreForOutlookSearchFileModal(value.deviceUUID, value.fileRevisionID, value.filePath, value.subject)" class="pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Restore file" style="margin-right: 10px;cursor:pointer;"><i class="fa fa-history"></i> </a>-->
									<a ng-if="mailCheckmarklocal == false" ng-click="searchDownloadOutlook(value.userName,value.fileRevisionID)" class="pull-right" title="Download" style="cursor:pointer;"><i class="fa fa-download"></i> </a>
									<a ng-if="mailCheckmarklocal == false" ng-click="initiateRestoreForOutlookSearchFileModal(value.deviceUUID, value.fileRevisionID, value.filePath, value.subject)" class="pull-right" title="Restore file" style="margin-right: 10px;cursor:pointer;"><i class="fa fa-history"></i> </a>
								</span>
								<p style="margin-top:12px;">
									<span ng-bind-html="getHtmlContent(value.content)" style="font-size:12px;"></span>
									<p style="word-break:break-all;font-size:11px;"> <b>Found in:</b><span>{{value.userName}} : {{value.filePath}}</span></p>
								</p>
							    </div>
					    		</td>
					    	</tr>
					</table>
				    </div>
				</div>
				<div id="mailreadingPanellocal" class="col-lg-7" style="background: #f8f8f9;">
					<div class="panel panelMailSearch" style="display:none;overflow-x: scroll;overflow-y: scroll;height:500px;">
                    				<div class="panel-heading"></div>
                    				<div class="panel-body">
							<div class="subject1Search" style="display: none;"></div>
							<div class="from1Search" style="display: none;"></div>
							<div class="sentDate1Search" style="display: none;"></div>
							<div class="to1Search" style="display: none;"></div>
							<div class="cc1Search" style="display: none;"></div>
							<div class="bcc1Search" style="display: none;"></div>
							<div class="attachments1Search" style="display: none;">
							    <div class="dataa1Search" style="display:none;">
								<span ng-repeat="value1 in attachments" style="margin-right:5px;border: 1px solid #f27331;padding:2px;">{{value1.name| limitTo:20}}{{value1.name.length > 20 ? '...' : ''}}&nbsp;
								    <a class="hide" ng-click="downloadAttachment(value1.id)" href="javascript:;"><i class="fa fa-download"></i></a>
								</span>&nbsp;
							    </div>
							</div>
							<br>
							<div class="contentOutlook1SearchDiv">
                        					<iframe class="contentOutlook1Search" frameBorder="0" style="display: none;width : -moz-available; height: -moz-available;width: -webkit-fill-available;height: -webkit-fill-available;"></iframe>
							</div>
            					</div>
                			</div>
				</div>
				<div id="selectedMailPanellocal" class="col-lg-7 col-md-6 col-sm-3" style="overflow-y: scroll;height:500px;display:none;">
					<div class="table-responsive">
						<table class="table table-hover" style="background: white;">
							<colgroup>
								<col class="col-lg-10">
							</colgroup>
							<thead>
								<tr>
									<th>{{ addedElementsCountLocal }} emails selected</th>
								</tr>
							</thead>
							<tr ng-repeat="value in addedElementsUpdatedLocal track by $index">
								<td ng-cloak>
									<span style="cursor: pointer;">{{ value.subject }}</span>
									<a href="" class="<?php if(!isMobile()){?> pull-right <?php } ?> clickAble" ng-click="removeItemLocal($index, value.subject, value.backupId, value.subject)"><i class="fa fa-times-circle-o"></i></a>
								</td>
							</tr>
						</table>
					</div>
				</div>
                            </div>
                        </div>
                        <div class="modal-footer" style="display:block;">
				<!--<div class="searchPagination" style="display:none;">
					<center>		
						<p><span ng-cloak>Page {{currentPage1-1}} of {{searchPageCount}}</span></p>
						<button class="btn btn-primary btn-small" ng-disabled="currentPage1 == 0" ng-click="searchOutlook(search.outlook,currentPagePrev)"> << </button>
						<button class="btn btn-primary btn-small" ng-click="searchOutlook(search.outlook,currentPage1)"> >> </button>
					</center>
				</div>-->
				<div class="row searchPagination">
					<div class="col-lg-12 text-center">
					    <p><span ng-cloak>Page {{currentpageCountSearch}} of {{totalpageCountSearch}}</span></p>
					    <a class="btn btn-primary firstSearch" ng-click="searchOutlookNavigate(search.outlook,firstSearch)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
					    <a class="btn btn-primary previousSearch" ng-click="searchOutlookNavigate(search.outlook,previousSearch)" style="display: none;"><i class="fa fa-angle-left"></i></a>
					    <a class="btn btn-primary nextSearch" ng-click="searchOutlookNavigate(search.outlook,nextSearch)" style="display: none;"><i class="fa fa-angle-right"></i></a>
					    <a class="btn btn-primary lastSearch" ng-click="searchOutlookNavigate(search.outlook,lastSearch)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
					</div>
				</div>
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="float:right;">Close</button>
<!--                            <button type="button" class="btn btn-primary">Save changes</button>-->
                        </div>
                    </div>
                </div>
            </div>
<!--            <div class="modal searchOutlookModal" id="searchOutlookModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Search Results</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <a class="h4 status-error-outlook" style="display: none;"></a>
                            <div class="row" style="overflow-y:scroll;height:500px;">
                                <div class="col-lg-12 col-md-6 col-sm-3">
                                    <section class="dummy-media-object" style="cursor: auto; padding: 15px;" ng-repeat="value in foundFilesOutlook track by $index">
                                        <a class="h4" style="color:black;">{{ value.subject }} </a>
                                        <a ng-click="searchDownloadOutlook(value.fileRevisionID)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                                        <a ng-click="viewOutlookSearch(value.fileRevisionID, value.deviceId)" class="btn btn-primary btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="View file" style="margin-right: 10px"><i class="fa fa-eye"></i> </a>
                                        <p style="margin-top:12px;">
                                            <span>.</span>
                                            <span class="pull-right" style="border: 1px solid #f27331;border-radius:5px;">{{value.filePath}}</span>
                                        </p>
                                    </section>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>-->
            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> chunks">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
			    <h4 class="modal-title">Files Chunk Details</h4>
			    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <hr/>
                            <div class="content" ng-if="chunks.length <= 0">
                                <h3 class="text-center">No Chunk files were found</h3>
                            </div>
                            <div class="content" ng-if="chunks.length >= 1">
                                <h4 class="modal-title">File Name: <span>{{ selected[0].name }}</span></h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <colgroup>
                                            <col class="col-xs-3">
                                            <col class="col-xs-4">
                                            <col class="col-xs-3">
                                        </colgroup>
                                        <thead>
                                        <tr>
                                            <th>Chunk Path On Storage</th>
                                            <th>Chunk Modified On</th>
                                            <th>Chunk Size</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in chunks track by $index">
                                            <td ng-if="value.cloudStoragePath.length >= 1">{{ value.cloudStoragePath }}</td>
                                            <td ng-if="value.cloudStoragePath.length < 1">-</td>
                                            <td>{{ value.uploadedTimeStamp }}</td>
                                            <td>{{ value.size }}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--custom name modal start-->
<div class="modal fade" id="customeNameSubfolderModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Specify Filename</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <div class="form-group">
                                        <label for="customeName">Specify pst filename</label>
                                        <input type="text" style="width: 100%;" class="form-control" name="customeNameSubfolder" id="customeNameSubfolder" placeholder="" value="<?=base64_decode($data['deviceUserName'])?>">
                                </div>
                        </div>
<div class="modal-footer">
                        <a ng-click="downloadFolderOutlookAsPst()" class="btn btn-success">Proceed</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
</div>
<!--custom name modal ends-->
<!--custom name modal start-->
<div class="modal fade" id="customeNameRootAllModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Specify Filename</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <div class="form-group">
                                        <label for="customeName">Specify pst filename</label>
                                        <input type="text" style="width: 100%;" class="form-control" name="customeNameRootAll" id="customeNameRootAll" placeholder="" value="<?=base64_decode($data['deviceUserName'])?>">
                                </div>
                        </div>
<div class="modal-footer">
                        <a ng-click="downloadFolderAsPstRootAll()" class="btn btn-success">Proceed</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
</div>
<!--custom name modal ends-->
<!--custom name modal start-->
<div class="modal fade" id="customeNameRootModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Specify Filename</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <div class="form-group">
                                        <label for="customeName">Specify pst filename</label>
                                        <input type="text" style="width: 100%;" class="form-control" name="customeNameRoot" id="customeNameRoot" placeholder="" value="<?=base64_decode($data['deviceUserName'])?>">
                                </div>
                        </div>
<div class="modal-footer">
                        <a ng-click="downloadFolderAsPst()" class="btn btn-success">Proceed</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
</div>
<!--custom name modal ends-->
<!--custom name modal start-->
<div class="modal fade" id="customeNameLocalModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Specify Filename</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <div class="form-group">
                                        <label for="customeName">Specify pst filename</label>
                                        <input type="text" style="width: 100%;" class="form-control" name="customeNameLocal" id="customeNameLocal" placeholder="" value="<?=$_SESSION['userName']?>">
                                </div>
                        </div>
<div class="modal-footer">
<!--                    <a ng-click="contentSearch1()" class="btn btn-success">Proceed</a>      -->
<a ng-click="newSelectedLocal()" class="btn btn-success">Proceed</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
</div>
<!--custom name modal ends-->
<!--custom name modal start-->
<div class="modal fade" id="customeNameLocalModalAll" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Specify Filename</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <div class="form-group">
                                        <label for="customeNameLocalAll">Specify pst filename</label>
                                        <input type="text" style="width: 100%;" class="form-control" name="customeNameLocalAll" id="customeNameLocalAll" placeholder="" value="<?=$_SESSION['userName']?>">
                                </div>
                        </div>
                        <div class="modal-footer">
                                <a ng-click="searchOutlook1()" class="btn btn-success">Proceed</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
</div>
<!--custom name modal ends-->
<!--typechooser modal start-->
<div class="modal fade" id="typechooser" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Select Download format</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
				<div class="col-lg-12" id="chooser">
						    <div class="col-lg-6">
                                                        <input type="radio" name="optradio" value="downloadaspst" checked>
                                                        <label for="link"><?=Language::show('Download as PST', 'keywords');?></label>
                                                    </div>		   
                                                    <div class="col-lg-6" ng-if="allowZIPDownload == true">
                                                        <input type="radio" name="optradio" value="downloadaszip">
                                                        <label for="link"><?=Language::show('Download as ZIP', 'keywords');?></label>
                                                    </div>                                                    
						</div>
<br>
                        </div>
<div class="modal-footer">
                        <a ng-click="downloadFromChooser()" class="btn btn-success">Proceed to download</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                    </div>
                </div>
</div>
<!--typechooser modal ends-->
<!--typechooser modal start-->
<div class="modal fade" id="typechooserSubfolder" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
                <div class="modal-dialog" role="document">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel">Select Download format</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
				<div class="col-lg-12" id="chooser">
						    <div class="col-lg-6">
                                                        <input type="radio" name="optradiosub" value="downloadaspst" checked>
                                                        <label for="link"><?=Language::show('Download as PST', 'keywords');?></label>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <input type="radio" name="optradiosub" value="downloadaszip">
                                                        <label for="link"><?=Language::show('Download as ZIP', 'keywords');?></label>
                                                    </div>
                                                </div>
<br>
                        </div>
<div class="modal-footer">
                        <a ng-click="downloadFromChooserSubfolder()" class="btn btn-success">Proceed to download</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                    </div>
                </div>
</div>
<!--typechooser modal ends-->
<!-- restore for Onedrive start -->
<div class="modal fade restoreBuckettOnedrive" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOnedrive"></span>
					</div>
				<div class="settingsDivOnedrive">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
					<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOnedrive">User Id</label>
                                            <select name="searchUsernameOnedrive"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedrive"
                                                    id="searchUsernameOnedrive"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php } else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOnedrive">User Id</label>
                                            <select name="searchUsernameOnedrive"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedrive"
                                                    id="searchUsernameOnedrive"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOnedrive" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOnedrive form-control" id="searchDeviceNameOnedrive" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="d-none" type="text" id="uuuOnedrive" value=""/>

                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label id="destinationPathlabelOnedrive" for="destinationPathOnedrive">Select a Destination Path</label>
<!--                                        <input type="text" class="form-control" style="width: 100%;" id="destinationPathOnedrive" placeholder="Enter Destination Path" required/>
                                        <span class="help-block d-none">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>-->
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOnedrive" id="destinationPathOnedrive" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
                                        		<button id="browseOnedrive" ng-click="browseOnedrive()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
<legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedrive"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1Onedrive" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsOnedrive"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsOneDrive" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedrive"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOnedrive" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
							<label style="margin-top:7px;" for="maxVersionsOnedrive"><?=Language::show('Restore Data Before', 'keywords');?></label>
						</div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOnedrive" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOnedrive">Date </label>
                                                    <input type="text" class="form-control restoreDateOnedrive" id="restoreDateOnedrive" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOnedrive"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOnedrive" name="restoreTimeOnedrive" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOnedrive col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="d-none" id="batchIdOneDrive"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>                                            
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
						    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
    					    </td>					    
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    	<div class="progress">
					    		<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                        	</div>
					    </td>
					    <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOnedrive()"  class="btn btn-default initiateRestoreBtnOnedrive">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOnedrive()" class="btn btn-primary cancelRestoreBtnOnedrive" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOnedrive()" class="btn btn-default normalCancelOnedrive" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOnedrive()"  class="btn btn-default warningCancelOnedrive" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseOnedrive" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>
                        </div>
                        <div class="modal-footer">
			  <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOnedrive()">Ok</button>
			  <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOnedrive" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
                        </div>
                        <div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="deleteRestoreOnedrive()">Ok</button>
          			<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOnedrive">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
			    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
				<span>Current Path : </span><span ng-if="pathOnedrive == ''" ng-cloak>/</span><span ng-if="pathOnedrive != ''" ng-cloak>{{pathOnedrive}}</span>
				<div class="col-lg-12">
				<div class="col-lg-7" style="border: 1px solid black;">
				<a class="btn btn-small btn-primary" ng-click="backOnedrive(pathOnedrive)" style="margin:5px;" ng-if="pathOnedrive != ''"><i class="fa fa-arrow-left"></i>Back</a>
				</br>
                        <div class="table-responsive browsePathDivOnedrive">
			<span class="noPathOnedrive" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOnedrive" class="table table-hover table-bordered browsePathOnedrive" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOnedrive(value, $index)" ng-dblclick="getChildsOnedrive(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOnedrive"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOnedrive" id="newFolderOnedrive" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOnedrive()" class="btn btn-default addNewFolderBtnOnedrive" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOnedrive" ng-click="usePathOnedrive(pathOnedrive)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for Onedrive end -->

<!-- restore for outlook start -->

<div class="modal fade restoreBuckettOutlook" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlook"></span>
					</div>
				<div class="settingsDiv">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlook">User Id</label>
                                            <select name="searchUsernameOutlook"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlook"
                                                    id="searchUsernameOutlook"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php } else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOutlook">User Id</label>
                                            <select name="searchUsernameOutlook"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlook"
                                                    id="searchUsernameOutlook"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlook" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlook form-control" id="searchDeviceNameOutlook" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="d-none" type="text" id="uuuOutlook" value=""/>

                                    <div class="form-group col-lg-12 destinationPathlabelOutlookDiv">
                                        <br/>
                                        <label id="destinationPathlabelOutlook" for="destinationPathOutlook">Select a Destination Path</label>
<!--                                        <input type="text" class="form-control" style="width: 100%;" id="destinationPathOutlook" placeholder="Enter Destination Path" required/>
					<span class="help-block d-none">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>-->
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlook" id="destinationPathOutlook" placeholder="<?=Language::show('Select a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
                                        		<button id="browse" ng-click="browse()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row disallowbackupOutlookDiv">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlook"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1Outlook" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlook"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlook" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlook"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlook" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 RestoreDataBeforeDiv" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
							<label style="margin-top:7px;" for="maxVersionsOutlook"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlook" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlook">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlook" id="restoreDateOutlook" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlook"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlook" name="restoreTimeOutlook" disabled>
                                                </div>
					    </div>
</div>
</div>
				    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgress col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="d-none" id="batchIdOutlook"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>					    
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    	<div class="progress">
					    		<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                        	</div>
					    </td>
					    <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
			<button type="submit" ng-click="initiateRestoreOutlook()"  class="btn btn-default initiateRestoreBtn">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOutlook()" class="btn btn-primary cancelRestoreBtn" style="display:none;">Cancel Restore </button>
			<button type="button" ng-click="clearRefresh()" class="btn btn-default normalCancel" data-dismiss="modal">Close</button>
			<button type="submit" ng-click="warningRestore()"  class="btn btn-default warningCancel" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmClose" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            
                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>
                                
                        </div>
                        <div class="modal-footer">
			  <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtn()">Ok</button>
			  <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
	    </div>
<div class="modal fade restoreCancelConfirmOutlook" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
			  <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlook()">Ok</button>
			  <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
	    </div>
<!--browse modal start-->
<div class="modal fade browse">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
			    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="path == ''" ng-cloak>/</span><span ng-if="path != ''" ng-cloak>{{path}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="back(path)" style="margin:5px;" ng-if="path != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDiv">
<span class="noPath" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePath" class="table table-hover table-bordered browsePath" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pick(value, $index)" ng-dblclick="getChilds(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolder"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolder" id="newFolder" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolder()" class="btn btn-default addNewFolderBtn" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePath" ng-click="usePath(path)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook end -->
<!-- restore for outlook file start -->
<div class="modal fade restoreBuckettOutlookFile" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                 <!--       <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookFile"></span>
					</div>
				<div class="settingsDivOutlookFile">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookFile">User Id</label>
                                            <select name="searchUsernameOutlookFile"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookFile"
                                                    id="searchUsernameOutlookFile"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php } else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOutlookFile">User Id</label>
                                            <select name="searchUsernameOutlookFile"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookFile"
                                                    id="searchUsernameOutlookFile"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookFile" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookFile form-control" id="searchDeviceNameOutlookFile" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="d-none" type="text" id="uuuOutlookFile" value=""/>

                                    <div class="form-group col-lg-12 destinationPathlabelOutlookFileDiv">
                                        <br/>
                                        <label id="destinationPathlabelOutlookFile" for="destinationPathOutlookFile">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlookFile" id="destinationPathOutlookFile" placeholder="<?=Language::show('Select a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
						</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
					    		<button id="browseOutlookFile" ng-click="browseOutlookFile()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
					    		</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row disallowbackupOutlookFileDiv">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookFile"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookFile" type="checkbox">
						<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookFile"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookFile" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookFile"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookFile" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 RestoreDataBeforeDivOutlookFile" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
							<label style="margin-top:7px;" for="maxVersionsOutlookFile"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlookFile" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookFile">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookFile" id="restoreDateOutlookFile" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookFile"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookFile" name="restoreTimeOutlookFile" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookFile col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="d-none" id="batchIdOutlookFile"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    	<div class="progress">
							<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					    </td>
					    <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOutlookFile()"  class="btn btn-default initiateRestoreBtnOutlookFile">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOutlookFile()" class="btn btn-primary cancelRestoreBtnOutlookFile" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookFile()" class="btn btn-default normalCancelOutlookFile" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookFile()"  class="btn btn-default warningCancelOutlookFile" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>

<div class="modal fade restoreWindowConfirmCloseOutlookFile" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookFile()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookFile" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
			  <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookFile()">Ok</button>
			  <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookFile">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
			    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookFile == ''" ng-cloak>/</span><span ng-if="pathOutlookFile != ''" ng-cloak>{{pathOutlookFile}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookFile(pathOutlookFile)" style="margin:5px;" ng-if="pathOutlookFile != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookFile">
<span class="noPathOutlookFile" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookFile" class="table table-hover table-bordered browsePathOutlookFile" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookFile(value, $index)" ng-dblclick="getChildsOutlookFile(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOutlookFile"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookFile" id="newFolderOutlookFile" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookFile()" class="btn btn-default addNewFolderBtnOutlookFile" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookFile" ng-click="usePathOutlookFile(pathOutlookFile)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook file end -->

<!-- restore for outlook file search start -->
<div class="modal fade restoreBuckettOutlookSearchFile" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                 <!--       <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookSearchFile"></span>
					</div>
				<div class="settingsDivOutlookSearchFile">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookSearchFile">User Id</label>
                                            <select name="searchUsernameOutlookSearchFile"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookSearchFile"
                                                    id="searchUsernameOutlookSearchFile"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php } else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOutlookSearchFile">User Id</label>
                                            <select name="searchUsernameOutlookSearchFile"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookSearchFile"
                                                    id="searchUsernameOutlookSearchFile"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookSearchFile" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookSearchFile form-control" id="searchDeviceNameOutlookSearchFile" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="d-none" type="text" id="uuuOutlookSearchFile" value=""/>

                                    <div class="form-group col-lg-12 destinationPathlabelOutlookSearchFileDiv">
                                        <br/>
                                        <label id="destinationPathlabelOutlookSearchFile" for="destinationPathOutlookSearchFile">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlookSearchFile" id="destinationPathOutlookSearchFile" placeholder="<?=Language::show('Select a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOutlookSearchFile" ng-click="browseOutlookSearchFile()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
					    <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row disallowbackupOutlookSearchFileDiv">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookSearchFile"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookSearchFile" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookSearchFile"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookSearchFile" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookSearchFile"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookSearchFile" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 RestoreDataBeforeDivOutlookSearchFile" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
<label style="margin-top:7px;" for="maxVersionsOutlookSearchFile"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
							    <input id="switchDateOutlookSearchFile" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookSearchFile">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookSearchFile" id="restoreDateOutlookSearchFile" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookSearchFile"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookSearchFile" name="restoreTimeOutlookSearchFile" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookSearchFile col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
                                    <span class="d-none" id="batchIdOutlookSearchFile"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
						<tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
                                            <td ng-if="progress.currentFolderPath == ''">-</td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOutlookSearchFile()"  class="btn btn-default initiateRestoreBtnOutlookSearchFile">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmOutlookSearchFile()" class="btn btn-primary cancelRestoreBtnOutlookSearchFile" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookSearchFile()" class="btn btn-default normalCancelOutlookSearchFile" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookSearchFile()"  class="btn btn-default warningCancelOutlookSearchFile" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>

<div class="modal fade restoreWindowConfirmCloseOutlookSearchFile" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookSearchFile()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookSearchFile" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookSearchFile()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookSearchFile">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookSearchFile == ''" ng-cloak>/</span><span ng-if="pathOutlookSearchFile != ''" ng-cloak>{{pathOutlookSearchFile}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookSearchFile(pathOutlookSearchFile)" style="margin:5px;" ng-if="pathOutlookSearchFile != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookSearchFile">
<span class="noPathOutlookSearchFile" style="display:none;"> No path available</span>
                        <span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookSearchFile" class="table table-hover table-bordered browsePathOutlookSearchFile" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookSearchFile(value, $index)" ng-dblclick="getChildsOutlookSearchFile(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
	</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOutlookSearchFile"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookSearchFile" id="newFolderOutlookSearchFile" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookSearchFile()" class="btn btn-default addNewFolderBtnOutlookSearchFile" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookSearchFile" ng-click="usePathOutlookSearchFile(pathOutlookSearchFile)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook file search end -->

<!-- restore for EndPoint start -->
<div class="modal fade restoreBuckettEndPoint" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                <!--        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathEndPoint"></span>
					</div>
				<div class="settingsDivEndPoint">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameEndPoint">User Id</label>
                                            <select name="searchUsernameEndPoint"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPoint"
                                                    id="searchUsernameEndPoint"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php } else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameEndPoint">User Id</label>
                                            <select name="searchUsernameEndPoint"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPoint"
                                                    id="searchUsernameEndPoint"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameEndPoint" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameEndPoint form-control" id="searchDeviceNameEndPoint" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="d-none" type="text" id="uuuEndPoint" value=""/>
				    <input class="d-none" type="text" id="uuuEndPointOS" value=""/>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label id="destinationPathlabelEndPoint" for="destinationPathEndPoint">Enter a Destination Path</label>
					<input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPathEndPoint" id="destinationPathEndPoint" placeholder="Enter Destination Path" required/>
                                        <span class="help-block d-none">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
					    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
					<div class="form-group col-lg-12 row">
						<label for="noOfThreads">Number of Threads</label>
						<input type="number" class="form-control" style="width: 100%;" id="noOfThreads" min="1" max="6" value="1" placeholder="Enter number of Threads" required/>
					</div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsEndPoint"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackupEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsEndPoint"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
<div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsEndPoint"><?=Language::show('In place Restore', 'keywords');?></label>
	</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesEndPoint"><?=Language::show('Restore Deleted Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="overwriteNewerFilesEndPoint"><?=Language::show('Overwrite Newer Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchoverwriteNewerFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
                                                    <label style="margin-top:7px;" for="maxVersionsEndPoint"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateEndPoint" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateEndPoint">Date </label>
                                                    <input type="text" class="form-control restoreDateEndPoint" id="restoreDateEndPoint" placeholder="Restore Date" data-parsley-trigger="change" disabled>
</div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTime"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeEndPoint" name="restoreTimeEndPoint" disabled>
							</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressEndPoint col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="d-none" id="batchIdEndPoint"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
						<tr>
						    <th>Source Path</th>
						    <th>Overall Progress</th>
						    <th>Status</th>
						</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
						<td ng-if="progress.currentFolderPath">{{ progress.currentFolderPath | limitTo:40 }}{{progress.currentFolderPath.length > 40 ? '...' : ''}}</td>
						<td ng-if="!progress.currentFolderPath">-</td>
						<td ng-if="progress.totalRestorePct != ''">
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
							</div>
						</td>
						<td ng-if="progress.totalRestorePct == ''">-</td>
					    	<td><span id="statusEndPoint"></span></td>
						</tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreEndPoint()"  class="btn btn-default initiateRestoreBtnEndPoint">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmEndPoint()" class="btn btn-primary cancelRestoreBtnEndPoint" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshEndPoint()" class="btn btn-default normalCancelEndPoint" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreEndPoint()"  class="btn btn-default warningCancelEndPoint" style="display:none;">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<div class="modal fade restoreWindowConfirmCloseEndPoint" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
<!--                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
				</div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnEndPoint()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmEndPoint" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
    <!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
<button type="button" class="btn btn-default" ng-click="deleteRestoreEndPoint()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!-- restore for EndPoint end -->

            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> restoreBucket">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
			    <h4 class="modal-title">Restore Bucket</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <form class="form-inline" ng-submit="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)" data-parsley-validate>
                                        <div class="">
                                            <br/>
                                            <div class="form-group col-lg-12">
                                                <label for="searchDeviceName">Select a Device to restore on:</label>
                                                <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                            </div>
                                            <div class="form-group col-lg-12">
                                                <br/>
                                                <label for="destinationPath">Enter a Destination Path(optional)</label>
                                                <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                                <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backed up from and the backed up drive does not exists then the files will be downloaded to a downloads folder.</span>
                                            </div>
                                            <button ng-if="selectedFileForRestoreList.length > 0 || selectedFilesForRestoreFromVersions.length > 0" type="submit" class="btn btn-default restoreBtnForFiles">Initiate Restore</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <hr/>
                            <div class="content" ng-if="selectedFileForRestoreList.length <= 0 && selectedFilesForRestoreFromVersions.length <= 0 ">
                                <h3 class="text-center">No Files has yet been added to restore.</h3>
                            </div>
                            <div class="content" ng-if="selectedFileForRestoreList.length >= 1">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Last modified</th>
                                            <th>Size</th>
                                            <th>Restore Type</th>
                                            <th>Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in selectedFileForRestoreList track by $index">
                                            <td>{{ value.name }}</td>
                                            <td>{{ value.type }}</td>
                                            <td ng-if="value.serverModifiedTime.length > 0">{{ value.serverModifiedTime }}</td>
                                            <td ng-if="value.size.length > 0">{{ value.size }}</td>
                                            <td ng-if="value.size.length <= 0">-</td>
                                            <td ng-if="value.restoreAllVersions == true">All Versions</td>
                                            <td ng-if="value.restoreAllVersions == false">Current Version</td>
                                            <td>
                                                <a ng-click="removeFromFileRestoreList($index)" class="btn btn-danger btn-small">Remove</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="content" ng-if="selectedFilesForRestoreFromVersions.length >= 1">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Last modified</th>
                                            <th>Size</th>
                                            <th>Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in selectedFilesForRestoreFromVersions track by $index">
                                            <td>{{ value.name }}</td>
                                            <td>File</td>
                                            <td ng-if="value.serverModifiedTime.length > 0">{{ value.serverModifiedTime }}</td>
                                            <td ng-if="value.size.length > 0">{{ value.size }}</td>
                                            <td ng-if="value.size.length <= 0">-</td>
                                            <td>
                                                <a ng-click="removeFromFileVersionsRestoreList($index)" class="btn btn-danger btn-small">Remove</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Delete Confirmation</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
	    <div class="modal fade deleteConfirmationForOutlook">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Delete Confirmation</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
<!--                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>-->
<p>
                                <span>Do you want to permanently delete the selected item?</span>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFileOutlook()" class="btn btn-primary">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade processing">
                <div class="modal-dialog modal-sm">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Processing</h4>
                        </div>
                        <div class="modal-body">
                            <p>Request Processing.........</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="extensionsToPdfView" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
<!--                            <p>Your file will need to converted to PDF before it is shared.  Please select an option below to proceed.</p>-->
				<p>You are sharing this file with a “No download” option. Supported file types are (PDF, TIFF, DOC, DOCX, XLS, XLSX, PPT, PPTX, JPG, PNG). If you still wish to share this file with a “No download” option, please convert this file to PDF or TIFF. You may speak to your Administrator for further details.</p>
                        </div>
                        <div class="modal-footer">
<!--                            <button type="button" ng-click="proceed()" class="btn btn-primary pull-right" style="margin-left: 5px;">Share</button>
                            <button type="button" ng-click="preview()" class="btn btn-primary pull-right">Preview</button>
			    <button type="button" class="btn btn-default pull-right" ng-click="cancell()">Cancel</button>-->
			    <button type="button" class="btn btn-default pull-right" ng-click="cancell()">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShare()">
                            <div class="modal-header">
				<h4 class="modal-title" id="myModalLabel">Share Details</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div class="modal-body shareBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <h4>Password Protected:
                                                <span><input type="checkbox" class="sharePasswordSwitch" <?php if($data['policy']['complexPassword'] == "1"){ echo "checked='checked'";echo "disabled ='true'";}?>/></span>
                                            </h4>
                                            <span class="sharePasswordBlock" <?php if($data['policy']['complexPassword'] == '1'){ ?>style="display: block;" <?php }else { ?> style="display:none;"<?php } ?>>
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="sharePassword" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPassword'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number."<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPassword'] == '1'){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reSharePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#sharePassword" data-parsley-trigger="change" <?php if($data['policy']['complexPassword'] == '1'){echo " required"; }?>>
                                                </div>
                                            </span>
					                        <div class="form-group">
                                                <label for="till">Valid Till <span class="removeValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="form-control till" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly <?php if($data['policy']['shareExpireDateEnable'] == "1"){ echo " required"; }?>>
                                            </div>
                                            <div class="granular">
                                                <?php if($data['policy']['allowDownload'] != "1"){ ?>
                                                    <div class="d-none">
                                                        <label for="enableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="enableDownload" class="enableDownload" />
                                                    </div>
                                                <?php } else { ?>
                                                    <label for="enableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="enableDownload" class="enableDownload" checked />
                                                <?php } ?>
						<div class="form-group">
							<label for="googleAuthIsEnabled">Enable multi-factor authentication</label>
							<input type="checkbox" class="googleAuthIsEnabled" <?php if($data['policy']['googleAuth'] == "1"){  echo "checked='checked'";echo "disabled ='true'"; } ?>/>
                                            	</div>
                                                <div class="d-none">
                                                    <label for="enableView">Allow View: </label>
                                                    <input type="checkbox" id="enableView" class="enableView" checked />
                                                </div>
                                            </div>
                                            <div class="shareLinkBlock" style="display: none;">
                                                <h4>
                                                    <span ng-show="showShareLink == true">Share the below link to share the file:</span>
                                                    <a href="" ng-click="sendEmailShareLink()" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                                </h4>
                                                <textarea class="js-copytextarea shareLink" ng-show="showShareLink == true" style="width:100%;word-wrap: break-word;" rows="5" readonly></textarea>
                                                <h4 ng-show="showShareLink == true"><a href="" class="js-textareacopybtn clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h4>
                                            </div>
                                            <div class="form-group sendEmailShareForm hide">
                                                <label for="emails">Emails</label>
                                                <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                                <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                            </div>
					    <span class="changeImpactText" style="font-size: 12px;color: #f55753;display: none;">Note :- “Please note that any changes made above will impact the experience for all recipients who access this link going forward – including recipients who’ve already received this link.”</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="float:left;display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <ul class="list-group contextMenu" style="display: none;">
                <li ng-click="deleteConfirmation()" class="list-group-item deleteBtn"><i class="fa fa-trash"></i> &nbsp;&nbsp;Delete</li>
                <li ng-click="getVersions()" class="list-group-item versionsBtn"><i class="fa fa-clock-o"></i> &nbsp;&nbsp;Versions</li>
            </ul>
        </div>
    </div>
<div id="overlayText"><center><h2 style="color:white;margin-top:20%;">Your files are being prepared for download. This operation could take some time. Please be patient during this time and don’t close this tab. If you wish to perform other operations – you can duplicate this tab and continue to perform other actions.</h2></center></div>
<div id="overlayTextMail"><center><h2 style="color:white;margin-top:20%;">Your messages are being prepared for download. This operation could take some time. Please be patient during this time and don’t close this tab. If you wish to perform other operations – you can duplicate this tab and continue to perform other actions.</h2></center></div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                       // if(o.deviceName != 'All'){
if(o.deviceUUID){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic, username: o.userName,uuid: o.deviceUUID };
}else{
return { id: o.deviceName, text: o.deviceName, img: o.profilePic, username: o.userName };
}
                       /* }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }*/
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select a destination device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + ", ("+users.username+ ")"+"</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        //$("#uuu").val(users.uuid);
        return users.text + ", ("+users.username+ ")";
    }
	    
    <?php if(SHARE_WITHIN_ORG == false){?>
    $('.till').datepicker({
        //format: 'mm/dd/yyyy',
	format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.till').val() != ''){
            $('.removeValidUntil').show();
        }
    });

    $('.removeValidUntil').on('click', function(){
        $('.till').val('');
        $('.removeValidUntil').hide();
    });
    <?php }else{ ?>
    $('.shareWithValidTill').datepicker({
        //format: 'mm/dd/yyyy',
	format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.shareWithValidTill').val() != ''){
            $('.shareWithRemoveValidUntil').show();
        }
    });

    $('.shareWithRemoveValidUntil').on('click', function(){
        $('.shareWithValidTill').val('');
        $('.shareWithRemoveValidUntil').hide();
    });
    <?php } ?>
    jQuery(document).bind("keyup keydown", function(e){
        if(e.ctrlKey && e.keyCode == 80){
            return false;
        }
    });
    
    $('.timePicker').timepicker({
        showMeridian: false,
//        defaultTime: '9:45'
    });
    
    $('.restoreDate').datepicker({
//        format: 'dd-mm-yyyy',
format: 'dd-M-yyyy',
        autoclose: true,
//        startDate: '-0d',
  //      endDate: '+1y',
        todayHighlight: true
    }).attr('readonly', 'readonly');

$(".restoreDate").datepicker().datepicker("setDate", new Date());
</script>
<script>
    var copyTextareaBtn = document.querySelector('.js-textareacopybtn');

copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
</script>
<script>
$('body').on('hidden.bs.modal', '.modal', function () {
        $(this).removeData('bs.modal');
$('#sharePassword').val('');
$('#reSharePassword').val('');
$('#till').val('');
      });
	
	/*for share modal starts*/	
	$( "#sharePassword" ).change(function(){
        console.log("sharePassword clicked");
        if($(".shareLinkBlock").is(":visible")) {
		$('.shareBtn').show();
		$('.shareBtn').html('Save');
		$('.changeImpactText').show();
        }
});

$( "#till" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
		$('.shareBtn').show();
		$('.shareBtn').html('Save');
		$('.changeImpactText').show();
        }
});

var enableDownload = document.querySelector('.enableDownload');
    if(enableDownload){
            enableDownload.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
			$('.shareBtn').show();
			$('.shareBtn').html('Save');
			$('.changeImpactText').show();
                    }
        };
    }
	
var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
            sharePasswordSwitch.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
			$('.shareBtn').show();
			$('.shareBtn').html('Save');
			$('.changeImpactText').show();
                    }
        };
    }
	
var googleAuthIsEnabledSwitch = document.querySelector('.googleAuthIsEnabled');
    if(googleAuthIsEnabledSwitch){
            googleAuthIsEnabledSwitch.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
                        $('.shareBtn').show();
                        $('.shareBtn').html('Save');
                        $('.changeImpactText').show();
                    }
        };
    }	

$('#share').on('hidden.bs.modal', function(){
        $("#fileShareForm").parsley().reset();
});

$('form').on('reset', function() {
  var $form = $(this);
  $form.find('.error,.valid').css('border-color', '').removeClass('error').removeClass('valid');
  $form.find('.form-error').remove();
});	
	
/*for share modal ends*/
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.example {
  border: 1px solid;
  border-radius: 10px;
  padding: 10px;
  box-shadow: 5px 10px #888888;
}	
</style>
<script>
$("#switchDate").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDate').removeAttr('disabled');
        $('#restoreTime').removeAttr('disabled');
    } else {
        $('#restoreDate').attr('disabled', true); //disable input
        $('#restoreTime').attr('disabled', true);
    }
});


$("#switchinplace").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPath').val('');
        $('#destinationPath').removeAttr('required', 'required');
        $('#destinationPathlabel').removeClass('star');
        $('#destinationPath').attr('disabled', true);        
    } else {
        $('#destinationPath').val('');
        $('#destinationPath').removeAttr('disabled');
        $('#destinationPathlabel').addClass('star');
        $('#destinationPath').attr('required', 'required');
    }
});
</script>
<style>
.selected td{
background: #ece5e2 !important;	
/*background: #f27331 !important;*/
}
</style>

<script>
$('.restoreDateOutlook').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
	container:'.restoreBuckettOutlook',
        todayHighlight: true
    }).attr('readonly', 'readonly');

$(".restoreDateOutlook").datepicker().datepicker("setDate", new Date());

$("#switchDateOutlook").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOutlook').removeAttr('disabled');
        $('#restoreTimeOutlook').removeAttr('disabled');
    } else {
        $('#restoreDateOutlook').attr('disabled', true); //disable input
        $('#restoreTimeOutlook').attr('disabled', true);
    }
});


$("#switchinplaceOutlook").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOutlook').val('');
        $('#destinationPathOutlook').removeAttr('required', 'required');
        $('#destinationPathlabelOutlook').removeClass('star');
        $('#destinationPathOutlook').attr('disabled', true);
	$('#browse').attr('disabled', true);
    } else {
        $('#destinationPathOutlook').val('');
        $('#destinationPathOutlook').removeAttr('disabled');
        $('#destinationPathlabelOutlook').addClass('star');
        $('#destinationPathOutlook').attr('required', 'required');
	$('#browse').removeAttr('disabled');
    }
});
</script>

<script>
$('.restoreDateOutlookFile').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettOutlookFile'
    }).attr('readonly', 'readonly');

$(".restoreDateOutlookFile").datepicker().datepicker("setDate", new Date());

$("#switchDateOutlookFile").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOutlookFile').removeAttr('disabled');
        $('#restoreTimeOutlookFile').removeAttr('disabled');
    } else {
        $('#restoreDateOutlookFile').attr('disabled', true); //disable input
        $('#restoreTimeOutlookFile').attr('disabled', true);
    }
});


$("#switchinplaceOutlookFile").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOutlookFile').val('');
        $('#destinationPathOutlookFile').removeAttr('required', 'required');
        $('#destinationPathlabelOutlookFile').removeClass('star');
        $('#destinationPathOutlookFile').attr('disabled', true);
	$('#browseOutlookFile').attr('disabled', true);
    } else {
        $('#destinationPathOutlookFile').val('');
        $('#destinationPathOutlookFile').removeAttr('disabled');
        $('#destinationPathlabelOutlookFile').addClass('star');
        $('#destinationPathOutlookFile').attr('required', 'required');
	$('#browseOutlookFile').removeAttr('disabled');
    }
});
</script>

<script>
$('.restoreDateOnedrive').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettOnedrive'
    }).attr('readonly', 'readonly');

$(".restoreDateOnedrive").datepicker().datepicker("setDate", new Date());

$("#switchDateOnedrive").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOnedrive').removeAttr('disabled');
        $('#restoreTimeOnedrive').removeAttr('disabled');
    } else {
        $('#restoreDateOnedrive').attr('disabled', true); //disable input
        $('#restoreTimeOnedrive').attr('disabled', true);
    }
});


$("#switchinplaceOnedrive").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOnedrive').val('');
        $('#destinationPathOnedrive').removeAttr('required', 'required');
        $('#destinationPathlabelOnedrive').removeClass('star');
        $('#destinationPathOnedrive').attr('disabled', true);
	$('#browseOnedrive').attr('disabled', true);
    } else {
        $('#destinationPathOnedrive').val('');
        $('#destinationPathOnedrive').removeAttr('disabled');
        $('#destinationPathlabelOnedrive').addClass('star');
        $('#destinationPathOnedrive').attr('required', 'required');
	$('#browseOnedrive').removeAttr('disabled');
    }
});
</script>
<script>
$('.restoreDateEndPoint').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettEndPoint'
    }).attr('readonly', 'readonly');

$(".restoreDateEndPoint").datepicker().datepicker("setDate", new Date());

$("#switchDateEndPoint").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateEndPoint').removeAttr('disabled');
        $('#restoreTimeEndPoint').removeAttr('disabled');
    } else {
        $('#restoreDateEndPoint').attr('disabled', true); //disable input
        $('#restoreTimeEndPoint').attr('disabled', true);
    }
});


$("#switchinplaceEndPoint").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathEndPoint').val('');
        $('#destinationPathEndPoint').removeAttr('required', 'required');
        $('#destinationPathlabelEndPoint').removeClass('star');
        $('#destinationPathEndPoint').attr('disabled', true);
    } else {
        $('#destinationPathEndPoint').val('');
        $('#destinationPathEndPoint').removeAttr('disabled');
        $('#destinationPathlabelEndPoint').addClass('star');
        $('#destinationPathEndPoint').attr('required', 'required');
    }
});
</script>
<style>
.modal {
  overflow-y:auto;
}
</style>
<style>
.selectedForSearch{
background: #ece5e2 !important;	
/*background: #f27331 !important;*/
/*    background-color:black;
    color:white;
    font-weight:bold;*/
}
.selectedForSearch .attach{
/*color: white !important;*/
}
td:nth-child(2) {
white-space: unset !important;
}	
</style>
<script>	
$('.restoreDateOutlookSearchFile').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
        container:'.restoreBuckettOutlookSearchFile'
    }).attr('readonly', 'readonly');

$(".restoreDateOutlookSearchFile").datepicker().datepicker("setDate", new Date());

$("#switchDateOutlookSearchFile").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOutlookSearchFile').removeAttr('disabled');
        $('#restoreTimeOutlookSearchFile').removeAttr('disabled');
    } else {
        $('#restoreDateOutlookSearchFile').attr('disabled', true); //disable input
        $('#restoreTimeOutlookSearchFile').attr('disabled', true);
    }
});


$("#switchinplaceOutlookSearchFile").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOutlookSearchFile').val('');
        $('#destinationPathOutlookSearchFile').removeAttr('required', 'required');
        $('#destinationPathlabelOutlookSearchFile').removeClass('star');
        $('#destinationPathOutlookSearchFile').attr('disabled', true);
	$('#browseOutlookSearchFile').attr('disabled', true);
    } else {
        $('#destinationPathOutlookSearchFile').val('');
        $('#destinationPathOutlookSearchFile').removeAttr('disabled');
        $('#destinationPathlabelOutlookSearchFile').addClass('star');
        $('#destinationPathOutlookSearchFile').attr('required', 'required');
	$('#browseOutlookSearchFile').removeAttr('disabled');
    }
});
</script>
<script>
    $('.searchUsernameEndPoint').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettEndPoint'),
        templateResult: selectTemplateResultEndPoint,
        templateSelection: selectTemplateSelectionEndPoint,
        placeholder: 'Select user'
    });

    function selectTemplateResultEndPoint(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionEndPoint(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceEndPoint",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1.length > 0){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID +","+device.osType+ '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameEndPoint').html(options);
/*xx start*/
if (jData.newone1.length > 0){		    
$("#uuuEndPoint").val(jData.newone1[0].deviceUUID);
$("#uuuEndPointOS").val(jData.newone1[0].osType);
 var src = $('.device_OS').html();
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
	src = src.toLowerCase();
        if(jData.newone1[0].osType){
            var dest = jData.newone1[0].osType;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPoint').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPoint').removeAttr('disabled');
                }
	}
}
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameEndPoint').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameEndPoint').attr("readonly", "readonly");
		$("#uuuEndPoint").val('');
	    }
}).fail(function(data){
	    $('.searchDeviceNameEndPoint').html("<option value='all' selected>User has no devices configured</option>");
            $('.searchDeviceNameEndPoint').attr("readonly", "readonly");
	    $("#uuuEndPoint").val('');
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameEndPoint").change(function () {
	    console.log("inside change"+$('#searchDeviceNameEndPoint').val());
	    var ghr = $('#searchDeviceNameEndPoint').val();
	    var uuid = ghr.split(",")[0];
	    var os = ghr.split(",")[1];
	    console.log("uuid : "+uuid);
	    console.log("os : "+os);
	    $("#uuuEndPoint").val(uuid);
        $("#uuuEndPointOS").val(os);
        var src = $('.device_OS').html();
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
        src = src.toLowerCase();	    
        if(os){
            var dest = os;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPoint').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPoint').removeAttr('disabled');
                }
        }

    });
</script>
<script>
    $('.searchUsernameOutlook').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlook'),
        templateResult: selectTemplateResultOutlook,
        templateSelection: selectTemplateSelectionOutlook,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlook(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlook(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlook').html(options);
/*xx start*/
$("#uuuOutlook").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlook').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlook').attr("readonly", "readonly");
		$("#uuuOutlook").val('');    
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlook").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlook').val());
	    var uuid = $('#searchDeviceNameOutlook').val();	    
	    $("#uuuOutlook").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOutlookFile').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlookFile'),
        templateResult: selectTemplateResultOutlookFile,
        templateSelection: selectTemplateSelectionOutlookFile,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlookFile(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlookFile(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlookFile').html(options);
/*xx start*/
$("#uuuOutlookFile").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlookFile').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlookFile').attr("readonly", "readonly");
		$("#uuuOutlookFile").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlookFile").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlookFile').val());
	    var uuid = $('#searchDeviceNameOutlookFile').val();	    
	    $("#uuuOutlookFile").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOutlookSearchFile').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlookSearchFile'),
        templateResult: selectTemplateResultOutlookSearchFile,
        templateSelection: selectTemplateSelectionOutlookSearchFile,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlookSearchFile(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlookSearchFile(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlookSearchFile').html(options);
/*xx start*/
$("#uuuOutlookSearchFile").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlookSearchFile').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlookSearchFile').attr("readonly", "readonly");
		$("#uuuOutlookSearchFile").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlookSearchFile").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlookSearchFile').val());
	    var uuid = $('#searchDeviceNameOutlookSearchFile').val();	    
	    $("#uuuOutlookSearchFile").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOnedrive').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOnedrive'),
        templateResult: selectTemplateResultOnedrive,
        templateSelection: selectTemplateSelectionOnedrive,
        placeholder: 'Select user'
    });

    function selectTemplateResultOnedrive(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOnedrive(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOnedrive",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOnedrive').html(options);
/*xx start*/
$("#uuuOnedrive").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOnedrive').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOnedrive').attr("readonly", "readonly");
		$("#uuuOnedrive").val('');      
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOnedrive").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOnedrive').val());
	    var uuid = $('#searchDeviceNameOnedrive').val();	    
	    $("#uuuOnedrive").val(uuid);        

    });
	
    $("#share").on("hidden.bs.modal", function(){
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('#till').val('');
    });
	
    $("[data-toggle=tooltip]").tooltip({
    	placement: $(this).data("placement") || 'left'
});
</script>
<style>
canvas{
border: 2px solid black;
margin: 5px;
width:400px;
height:500px;
}
#overlayText {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 1000000000000;
  cursor: pointer;
}
#overlayTextMail {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 1000000000000;
  cursor: pointer;
}
#files-table tbody tr td{
	padding: 8px !important;
}	
</style>
