/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SyncPmsController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.sortReverse = false;
    $scope.sortType = 'policygroupName';
    $scope.sortTypeMapping = 'userName';
    $scope.sortTypeFilter = 'filterName';
    $scope.sortTypeSchedule = 'scheduleName';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.selectedUser = $('.selectedUser').html();
    $scope.schedules = [];
    $scope.filters = [];
    $scope.searchfilters = [];
    $scope.policies = [];
    $scope.scheduleIndex = '';
    $scope.filterIndex = '';
    $scope.selectedPolicy = {};

    $scope.defaultWinFolders = ['c:\\', 'd:\\'];
    $scope.defaultMacFolders = ['/users/', '/home/'];

    $scope.currentDefaultWinFolders = ['c:\\', 'd:\\'];
    $scope.currentDefaultMacFolders = ['/users/', '/home/'];

    $scope.defaultSchedules = [];
    $scope.userPolicyMappingPolicies = [];
    $scope.userPolicyMappingUsers = [];

    $scope.bluvaults = [];
    $scope.blukrypts = [];

    $scope.preBackup = [];
    $scope.postBackup = [];
    $scope.preRestore = [];
    $scope.postRestore = [];

    $scope.ccS = [];
    $scope.IncFilters = [];
    $scope.ExcFilters = [];
	
    $scope.pageNumber = 1;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';
	
    $('#filtersType').on('change', function(){
                var type = $('#filtersType').val();
                if(type == 'inclusion'){
                        $('.inclusionBadge').show();
                        $('.exclusionBadge').hide();
                }else{
                        $('.inclusionBadge').hide();
                        $('.exclusionBadge').show();
                }
    });
	
    $('.selectFilterPicker').on('change', function(){
	$scope.defaultFilter = [];
        if($('.selectFilterPicker :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultFilter = [];
        }
	    $scope.updateSelectedFiltersOne($('#filters').val());
	    //$scope.updateSelectedFiltersOne($('.selectFilterPicker').val());
    });
    
    //search filter start
    /*$('#searchfiltersType').on('change', function(){
        var type = $('#searchfiltersType').val();
        $scope.defaultSearchFilter = [];
        $scope.searchfilters = [];
        $('.incSearch').selectpicker('val', []);
        $('.excSearch').selectpicker('val', []);
        if(type == 'inclusion'){
            $('.excSearch').hide();
            $('.incSearch').show();
            $('.excSearch').removeAttr('required', 'required');
            $('.incSearch').attr('required', 'required');
            for(var i=0;i<$scope.IncFilters.length;i++){
            $('#searchfilters').append($('<option>', {
                                            value: $('[name="$scope.IncFilters[i].filterName"]').val(),
                                            text: $('[name="$scope.IncFilters[i].filterName"]').val()
                                        }));
            }
        }else if(type == 'exclusion'){
            $('.incSearch').hide();
            $('.excSearch').show();
            $('.incSearch').removeAttr('required', 'required');
            $('.excSearch').attr('required', 'required');
            for(var i=0;i<$scope.ExcFilters.length;i++){
            $('#searchfilters1').append($('<option>', { value : $scope.ExcFilters[i].filterName }).text($scope.ExcFilters[i].filterName));
       //     $('#filters').append('<option value="foo" selected="selected">Foo</option>');
            }
        }
	$scope.$apply();
    });

    $('.incSearch').on('change', function(){
        if($('.incSearch :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultSearchFilter = [];
        }
      $scope.updateSelectedSearchFiltersOne($('.incSearch').val());
    });

    $('.excSearch').on('change', function(){
        if($('.excSearch :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultSearchFilter = [];
        }
        $scope.updateSelectedSearchFiltersOne($('.excSearch').val());
    });*/
	
	$('.selectSearchFilterPicker').on('change', function(){
//            console.log("nn : "+$('.incSearch :selected').length);
        if($('.selectSearchFilterPicker :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultSearchFilter = [];
        }
		$scope.updateSelectedSearchFiltersOne($('#searchfilters').val());
      //$scope.updateSelectedSearchFiltersOne($('.selectSearchFilterPicker').val());
    });

    $scope.updateSelectedSearchFiltersOne = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filterOne',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultSearchFilter= jData.filters;
                $scope.searchfilType = jData.filters[0].filterType;
                //$('.selectSearchFilterTypePicker option[value="'+$scope.searchfilType+'"]').prop('selected', true);
                if($scope.searchfilType == 'inclusion'){
                filters.forEach(function(value){
                        $('.incSearch option[value="'+value+'"]').prop('selected', true);
                    });
                    $('.excSearch').hide();
                    $('.incSearch').show();
                }else if($scope.searchfilType == 'exclusion'){
                filters.forEach(function(value){
                        $('.excSearch option[value="'+value+'"]').prop('selected', true);
                    });
                    $('.incSearch').hide();
                    $('.excSearch').show();
                }
                if($scope.currentPage == 'policy'){
                    $('#searchfiltersType').val($scope.searchfilType);
                }
                $scope.$apply();
            }else{
                //toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    //search filter end
    
    function array_diff (a1, a2) {
        var a = [], diff = [];
        for (var i = 0; i < a1.length; i++) {
            a[a1[i]] = true;
        }
        for (var i = 0; i < a2.length; i++) {
            if (a[a2[i]]) {
                delete a[a2[i]];
            } else {
                a[a2[i]] = true;
            }
        }
        for (var k in a) {
            diff.push(k);
        }
        return diff;
    }
    
    //policy selectpicker filter start
    $('.selectFilterTemplatePickerPolicy').on('change', function(){
        if($('.selectFilterTemplatePickerPolicy :selected').length > 0){
            if($('.selectFilterTemplatePickerPolicy').val().indexOf('all_files') != -1){
                $('.selectFilterTemplatePickerPolicy').selectpicker('val', 'all_files');
            }
            $scope.updateSelectedFiltersTemplatePolicy($('#selectFilterTemplatePickerPolicy').val());
        }else{
            var bbb = $scope.xxx;
            $('#editFilters').tagsinput('removeAll');
            $('#editFilters').tagsinput('add',bbb);
            $('#editFilters').tagsinput('refresh');
        }
    });

//end

//for  policy template filter start
    $scope.updateSelectedFiltersTemplatePolicy = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filterTemplate',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                var nameArr = $('#editFilters').val().split(',');
                var kkk = array_diff(nameArr, jData.tags);
                kkk.pop("isNull");
                var kkk1 = kkk.join();
                var experiment = jData.tags.concat($scope.xxx);
                $scope.neww = experiment;
                $('#editFilters').tagsinput('removeAll');
                var nn = experiment.join();
                var aa = 'all';
                if(nn.indexOf(aa) != -1){
                console.log("all present");
                //$('#filters').tagsinput('removeAll');
                        $('#editFilters').tagsinput('add', 'all');
                $('#editFilters').tagsinput('refresh');
                }else{
                console.log("all not present");
                $('#editFilters').tagsinput('add', nn);
                $('#editFilters').tagsinput('refresh');
                }
                $scope.$apply();
            }else{
                //toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    //end

    $scope.toggleSelectPickerAll = function(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('Daily');
                $('.selectPicker').selectpicker('deselectAll');
            }else{
                $('.scheduleDaily').html('De Select All');
                $('.selectPicker').selectpicker('selectAll');
            }
        }else{
            $('.scheduleDaily').html('De Select All');
            $('.selectPicker').selectpicker('selectAll');
        }
    };

    $('.selectPicker').on('change', function(){
        toggleSelectPicker();
    });

    function toggleSelectPicker(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('De Select All');
            }else{
                $('.scheduleDaily').html('Daily');
            }
        }else{
            $('.scheduleDaily').html('Daily');
        }
    }
    
    /*$('#filtersType').on('change', function(){
        var type = $('#filtersType').val();
        $scope.defaultFilter = [];
        $scope.filters = [];
        $('.inc').selectpicker('val', []);
        $('.exc').selectpicker('val', []);
        if(type == 'inclusion'){
            $scope.filType = 'inclusion';
            $('.exc').hide();
            $('.inc').show();
            $('.exc').removeAttr('required', 'required');;
            $('.inc').attr('required', 'required');;
            for(var i=0;i<$scope.IncFilters.length;i++){
                $('#filters').append($('<option>', {
                    value: $('[name="$scope.IncFilters[i].filterName"]').val(),
                    text: $('[name="$scope.IncFilters[i].filterName"]').val()
                }));
            }
        }else if(type == 'exclusion'){
            $scope.filType == 'exclusion';
            $('.inc').hide();
            $('.exc').show();
            $('.inc').removeAttr('required', 'required');;
            $('.exc').attr('required', 'required');;
            for(var i=0;i<$scope.ExcFilters.length;i++){
                $('#filters').append($('<option>', { value : $scope.ExcFilters[i].filterName }).text($scope.ExcFilters[i].filterName));
                //$('#filters').append('<option value="foo" selected="selected">Foo</option>');
            }
        }
	$scope.$apply();
    });*/

    $('.inc').on('change', function(){
        if($('.inc :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultFilter = [];
        }
        //console.log("INC VALUE"+$('.inc').val());
	    $scope.updateSelectedFiltersOne($('.inc').val());
    });

    $('.exc').on('change', function(){
        if($('.exc :selected').length <= 0){
            toastr.error('No Filters selected, Please select atleast one filter', 'Fail!!!', {allowHtml: true});
            $scope.defaultFilter = [];
        }
        //console.log("EXC VALUE"+$('.exc').val());
        $scope.updateSelectedFiltersOne($('.exc').val());
    });
    
    function isSpecialCharForSchedule(val) {
        var tr = $.trim(val).length;
        var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="scheduleName"]').popover('show');
                    return false;
                }
                else{
                    $('[name="scheduleName"]').popover('hide');
                    return true;
                }
    }

    $scope.scheduleCreate = function(remove){
        var scheduleName = $('#scheduleName').val();
        if(isSpecialCharForSchedule(scheduleName) == false){
            $('[name="scheduleName"]').addClass('parsley-error');
            return;
            }
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createSchedule').modal('hide');
                        if($("#schedules option[value='"+$('[name="scheduleName"]').val()+"']").length == 0){
                        $('#schedules').append($('<option>', {
                            value: $('[name="scheduleName"]').val(),
                            text: $('[name="scheduleName"]').val()
                        }));
                        }
                        $('.selectSchedulePicker').selectpicker('refresh');
                        var scheduleNames = $('.selectSchedulePicker').val();
                        if(scheduleNames != null){
                            scheduleNames.push($('[name="scheduleName"]').val());
                            $('.selectSchedulePicker').selectpicker('val', scheduleNames);
                        }else{
                            $('.selectSchedulePicker').selectpicker('val', $('[name="scheduleName"]').val());
                        }
                        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/schedules';
                        }, 3000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.getSchedules = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedules',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.schedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.scheduleEdit = function(index){
        $scope.scheduleIndex = index;
        $('.scheduleEditTime').timepicker('setTime', $scope.schedules[$scope.scheduleIndex].time);
        $('.selectPicker').selectpicker('val', $scope.schedules[$scope.scheduleIndex].daysArray);
        $('.editSchedule').modal('show');
        if($scope.schedules[$scope.scheduleIndex].backupType == 'i'){
            $('.backupType').find('option[value="i"]').prop("selected",true);
        }else{
            $('.backupType').find('option[value="f"]').prop("selected",true);
        }
        $('.backupType').selectpicker('render');
        toggleSelectPicker();
    };

    $scope.scheduleSave = function(){
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $scope.schedules[$scope.scheduleIndex].daysArray = $('.selectPicker').selectpicker('val');
                    $scope.schedules[$scope.scheduleIndex].time = $('[name="scheduleStartTime"]').val();
                    $scope.schedules[$scope.scheduleIndex].days = getDayNames($('.selectPicker').selectpicker('val').join(','));
                    $scope.schedules[$scope.scheduleIndex].backupType = $('.backupType').val();
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.sendMeTo = function(url){
        window.location.href = $scope.BASE_FOLDER+url;
    };

    function getDayNames(numString){
        numString = numString.replace('1', 'Sunday');
        numString = numString.replace('2', 'Monday');
        numString = numString.replace('3', 'Tuesday');
        numString = numString.replace('4', 'Wednesday');
        numString = numString.replace('5', 'Thursday');
        numString = numString.replace('6', 'Friday');
        numString = numString.replace('7', 'Saturday');
        return numString;
    }

    $scope.getFilters = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filters',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.filters = jData.filters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.getAllFilters = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/Allfilters',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.filters = jData.filters;
		        $scope.IncFilters = jData.IncFilters;
		        $scope.ExcFilters = jData.ExcFilters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    function isSpecialCharForFilter(val) {
        var tr = $.trim(val).length;
        var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="filterName"]').popover('show');
                    return false;
                }
                else{
                    $('[name="filterName"]').popover('hide');
                    return true;
                }
    }

    $scope.filterCreate = function(remove){
        var filterName = $('#filterName').val();
        var filterType = $('#filtersType').val();
        if(isSpecialCharForFilter(filterName) == false){
            $('[name="filterName"]').addClass('parsley-error');
            return;
            }
        if($('.filterForm').parsley().isValid()){
            if($('#editFilters') .length > 0 ){
                var filters = $('#editFilters').val();
            }else{
                var filters = $('#filters').val();
            }
            //var filters = $('#filters').val();
            filters = filters.replace(/[&\/\\#+()$|~\[\]%.'":*?<>{}]/g,'');
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/save',
                data: $('form').serialize()+'&filtersNew='+filters,
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createFilter').modal('hide');
		                /*if(filterType == 'inclusion'){            
                            if($("#filters option[value='"+$('[name="filterName"]').val()+"']").length == 0){
                                $('#filters').append($('<option>', {
                                    value: $('[name="filterName"]').val(),
                                    text: $('[name="filterName"]').val()
                                }));
                            }
                            $('.selectFilterPicker').selectpicker('refresh');
                            $('#filters').selectpicker('val', $('[name="filterName"]').val());
                            $scope.updateSelectedFiltersOne($('.inc').val());
                        }else{
                            if($("#filters1 option[value='"+$('[name="filterName"]').val()+"']").length == 0){
                                $('#filters1').append($('<option>', {
                                    value: $('[name="filterName"]').val(),
                                    text: $('[name="filterName"]').val()
                                }));
                            }
                            $('.selectFilterPicker').selectpicker('refresh');
                            $('#filters1').selectpicker('val', $('[name="filterName"]').val());
                            $scope.updateSelectedFiltersOne($('.exc').val());
                        }*/
			    if($('#filters :selected').length <= 0){
			    $('#filters').append($('<option>', {
                                    value: $('[name="filterName"]').val(),
                                    text: $('[name="filterName"]').val()
                                }));
			    $('.selectFilterPicker').selectpicker('refresh');
			    $('.selectFilterPicker').selectpicker('val', $('[name="filterName"]').val());
				    $scope.updateSelectedFiltersOne($('#filters').val());
//			    $scope.updateSelectedFiltersOne($('.selectFilterPicker').val());
			    }else{
				    console.log("elseeeeeeedd");
				    $('#filters').append($('<option>', {
                                    value: $('[name="filterName"]').val(),
                                    text: $('[name="filterName"]').val()
                                	}));
			    	    var xx = $('#filters').val();
				    xx.push($('[name="filterName"]').val());
				    console.log("xx : "+xx);
				    $('.selectFilterPicker').selectpicker('refresh');
				    $('.selectFilterPicker').selectpicker('val', xx);
				    $scope.updateSelectedFiltersOne($('#filters').val());
//                            	    $scope.updateSelectedFiltersOne($('.selectFilterPicker').val());
			    }
                        /*$('.selectFilterPicker').selectpicker('refresh');
                        $('#filters').selectpicker('val', $('[name="filterName"]').val());
                        $scope.updateSelectedFilters($('.selectFilterPicker').val());*/
                        /*$('.selectFilterPicker').selectpicker('val', $('[name="filterName"]').val());
                        $scope.updateSelectedFilters($('[name="filterName"]').val());*/
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/filters';
                        },2000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.filterSave = function(){
        if($('.filterEditForm').parsley().isValid()){
            if($('#editFilters') .length > 0){
                var filters = $('#editFilters').val();
            }else{
                var filters = $('#filters').val();
            }
            filters = filters.replace(/[&\/\\#+()$|~\[\]%.'":*?<>{}]/g,'');
            var finalIndex;
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/saveEdit',
                data: $('form').serialize()+'&filtersNew='+filters,
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $('.editFilter').modal('hide');
                    $scope.filters.forEach(function(message, index) {
                        Object.keys(message).forEach(function(prop) {
                    if(message[prop] == $scope.filter.filterName){
                    finalIndex = index;
                    }
                        });
                    });
                    $scope.filters[finalIndex].filterType = $('.filterType').val();
                    //$scope.filters[finalIndex].filters = $('.editFilters').tagsinput('items').join(',');
                    $scope.filters[finalIndex].filters = filters;
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }
            });
        }
    };

    $scope.filterSavePolicy = function(){
        var $selector = $('.filterForm'),
        form = $selector.parsley();
        if(!form.validate()){
            return;
        }
        if($('.filterForm').parsley().isValid()){
            if($('#editFilters') .length > 0){
                var filters = $('#editFilters').val();
            }else{
                var filters = $('#filters').val();
            }
            //var filters = $('#editFilters').val();
            filters = filters.replace(/[&\/\\#+()$|~\[\]%.'":*?<>{}]/g,'');
            var finalIndex;
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/saveEdit',
                data: $('form').serialize()+'&filtersNew='+filters,
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $('.createFilter').modal('hide');
                    $scope.filters.forEach(function(message, index) {
                        Object.keys(message).forEach(function(prop) {
                    if(message[prop] == $scope.filter.filterName){
                    finalIndex = index;
                    }
                        });
                    });
                    $scope.defaultFilter.filterType = $('#filterType').val();
                    //$scope.defaultFilter.filters = $('#editFilters').tagsinput('items').join(',');
                    $scope.defaultFilter.filters = filters;
                    //console.log("newV :"+$scope.defaultFilter.filters);
                    if($scope.filType == 'inclusion'){
			    $scope.updateSelectedFiltersOne($('#filters').val());
//                        $scope.updateSelectedFiltersOne($('.inc').val());
                    }else{
			    $scope.updateSelectedFiltersOne($('#filters').val());
//                        $scope.updateSelectedFiltersOne($('.exc').val());
                    }
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }
            });
        }
    };

    $scope.filterEdit = function(index){
        $scope.filterIndex = index;
        $('.editFilters').tagsinput('removeAll');
        $('.editFilters').tagsinput('add', $scope.filters[$scope.filterIndex].filters);
        if($scope.filters[$scope.filterIndex].filterType == "exclusion"){
            $('.filterType').find('option[value="exclusion"]').prop("selected",true);
        }else{
            $('.filterType').find('option[value="inclusion"]').prop("selected",true);
        }
        $('.filterType').selectpicker('refresh');
        $('.editFilter').modal('show');
    };

    $scope.newFilterEditPage = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filter',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.editFilter').modal('show');
                $scope.filter = jData.filters;
                $('#filterName').val(jData.filters.filterName);
                $('.editFilters').tagsinput('removeAll');
                $scope.xxx = jData.filters.filters;
                //console.log("ggggggg: "+$scope.xxx);
                $('.editFilters').tagsinput('add', jData.filters.filters);
                if(jData.filters.filterType == "exclusion"){
                    $('.filterType').find('option[value="exclusion"]').prop("selected",true);
                }else{
                    $('.filterType').find('option[value="inclusion"]').prop("selected",true);
                }
                $('.filterType').selectpicker('refresh');
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.newFilterEdit = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filter',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.createFilter').modal('show');
/*                $('#add_title').addClass("hide");
                $('#edit_title').addClass("show");
                $('#add_save').addClass("hide");
                $('#edit_save').addClass("show");*/
		    $('#add_title').addClass("d-none");
                $('#edit_title').addClass("d-block");
                $('#add_save').addClass("d-none");
                $('#edit_save').addClass("d-block");
                $scope.filter = jData.filters;
                $('#filterName').val(jData.filters.filterName);
                $('#filterName').attr("readonly","readonly");
                $('.editFilters').tagsinput('removeAll');
                $scope.xxx = jData.filters.filters;
                $('.editFilters').tagsinput('add', jData.filters.filters);
                if(jData.filters.filterType == "exclusion"){
                    $('.filterType').find('option[value="exclusion"]').prop("selected",true);
                }else{
                    $('.filterType').find('option[value="inclusion"]').prop("selected",true);
                }
                $('.filterType').selectpicker('refresh');
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    /*$scope.getPolices = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policies',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                if (jData.policies.length > 0) {
                    $('.syncPolicyTable').show();
                    $('.syncPolicyTableEmpty').hide();
                    $scope.policies = jData.policies;
                    $scope.$apply();
                }else{
                    $('.syncPolicyTable').hide();
                    $('.syncPolicyTableEmpty').show();
                }
            }else{
                toastr.error('No Policy was found', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };*/
	
    $scope.getPolices = function(){
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policiesPagination',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
		$('.first').show();
		}
		/*if($scope.self){
		$('.self').show();
		}*/
		if($scope.previous){
		$('.previous').show();
		}
		if($scope.next){
		$('.next').show();
		}
		if($scope.last){
		$('.last').show();
		}
                if (jData.policies.length > 0) {
                    $('.syncPolicyTable').show();
                    $('.syncPolicyTableEmpty').hide();
                    $scope.policies = jData.policies;
                    $scope.$apply();
                }else{
                    $('.syncPolicyTable').hide();
                    $('.syncPolicyTableEmpty').show();
                }
            }else{
                toastr.error('No Policy was found', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getPolicesNavigate = function(url){
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policiesPaginationNavigate',
            data: {csrf_token: $('.csrf_token').html(), secret: '',url:url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		//$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
		$('.first').show();
		}
		/*if($scope.self){
		$('.self').show();
		}*/
		if($scope.previous){
		$('.previous').show();
		}
		if($scope.next){
		$('.next').show();
		}
		if($scope.last){
		$('.last').show();
		}
		if (jData.policies.length > 0) {
                    $('.syncPolicyTable').show();
                    $('.syncPolicyTableEmpty').hide();
                    $scope.policies = jData.policies;
                    $scope.$apply();
                }else{
                    $('.syncPolicyTable').hide();
                    $('.syncPolicyTableEmpty').show();
                }
            }else{
                toastr.error('No Policy was found', 'Fail!!!', {allowHtml: true});
}

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewSchedule = function(){
	  $('.scheduleForm').trigger("reset");
	  $('#scheduleName').val('');
	  $('#scheduleStartTime').val('9:45');
	  $('.scheduleDaily').html('Daily');
	  $('.selectPicker').selectpicker('deselectAll');
          $('.createSchedule').modal('show');
    };

    $('.selectSchedulePicker').on('change', function(){
        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
    });

    $scope.updateSelectedScheduleNames = function(names){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedule',
            data: {csrf_token: $('.csrf_token').html(), scheduleNames: names},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultSchedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules were found', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewFilter = function(){
	$('#filterName').val('');
        $('.filterType').find('option[value="inclusion"]').prop("selected",true);
        $('.filterType').selectpicker('refresh');
	$('.selectFilterTemplatePickerPolicy').val('');
        $('.selectFilterTemplatePickerPolicy').selectpicker('refresh');
        $('.editFilters').tagsinput('removeAll');
        $('.editFilters').tagsinput('add',"doc,docx,ppt,pptx,txt,pdf,jpg,png");
        $('.createFilter').modal('show');
    /*    $('#add_title').addClass("show");
        $('#edit_title').addClass("hide");
        $('#add_save').addClass("show");
        $('#edit_save').addClass("hide");*/
	    $('#add_title').addClass("d-block");
        $('#edit_title').addClass("d-none");
        $('#add_save').addClass("d-block");
        $('#edit_save').addClass("d-none");
    };

    $scope.addNewCcS = function(){
        $('.createCcS').modal('show');
    };

    /*$('.selectFilterPicker').on('change', function(){
        $scope.updateSelectedFilters($('.selectFilterPicker').val());
    });*/

    $scope.updateSelectedFilters = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filter',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
            }else{
                //toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.updateSelectedFiltersOne = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filterOne',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		        $scope.defaultFilter= jData.filters;
                filters.forEach(function(value){
                    $('.selectFilterPicker option[value="'+value+'"]').prop('selected', true);
                });
                //$scope.filType = jData.filters[0].filterType;
                //$('.selectFilterTypePicker option[value="'+$scope.filType+'"]').prop('selected', true);
                /*if($scope.filType == 'inclusion'){
		            filters.forEach(function(value){
                        $('.inc option[value="'+value+'"]').prop('selected', true);
                    });
                    $('.exc').hide();
                    $('.inc').show();
                }else if($scope.filType == 'exclusion'){
            		filters.forEach(function(value){
                        $('.exc option[value="'+value+'"]').prop('selected', true);
                    });
                    $('.inc').hide();
                    $('.exc').show();
                }*/
                if($scope.currentPage == 'policy'){
                    $('#filtersType').val($scope.filType);
                }
                $scope.$apply();
            }else{
                //toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    if($('[name="defaultFoldersBackup"]')[0]){
        $('[name="defaultFoldersBackup"]')[0].addEventListener( 'keydown', function( ev ) {
            if(ev.keyCode == 13){
                ev.preventDefault();
            }
        });
    }

    $scope.addDefaultFolder = function($value){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            osType = 'windows';
        }else{
            osType = 'mac';
        }
        if($value != '' && $value != null && $value != undefined){
            if(osType == 'windows'){
                $value = sanitizeValues(osType, $value, $scope.defaultWinFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $('[name="defaultFoldersBackup"]').val('');
                    $scope.defaultWinFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else if(osType == 'mac'){
                $value = sanitizeValues(osType, $value, $scope.defaultMacFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').val('');
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $scope.defaultMacFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else{
                toastr.info('Please select a Operating System type before adding a Folder Path', 'Information!!!', {allowHtml: true});
            }
        }else{
            $('[name="defaultFoldersBackup"]').popover('show');
            return;
        }
    };

    $scope.removeDefaultFolder = function($key){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            $scope.defaultWinFolders.splice($key, 1);
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
        }else if((osType.toLowerCase()).indexOf('mac') > -1){
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            $scope.defaultMacFolders.splice($key, 1);
        }else{
            toastr.info('Please select a Operating System type before deleting', 'Success!!!', {allowHtml: true});
        }
    };

    function sanitizeValues(osType, folder, $folders){
        var pattern = new RegExp(':');
        var result = '';
        if(osType == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }
    }

    $('ul.sortable').sortable({ items: "> li", disableSelection: true });
    
    function isSpecialCharForPolicy(val) {
        var tr = $.trim(val).length;
        var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="policyName"]').popover('show');
                    return false;
                }
                else{
                    $('[name="policyName"]').popover('hide');
                    return true;
                }
    }

    $scope.policyCreate = function(){
        var policyName = $('#policyName').val();
        var $selector = $('.policyForm'),
        form = $selector.parsley();
        if(!form.validate()){
            toastr.error('Please fill all details ', 'Fail!!!', {allowHtml: true});
            return;
        }
	var re = /(<([^>]+)>)/gi;
        var ja = /({([^>]+)})/gi;
        var count = 0;
        $("form#policyForm input[type=text]").each(function(){
		var input = $(this);
		var text = $(this).val();
		if (text.match(re) || text.match(ja)) {
			count = count+1;
		}
	});
        $("form#policyForm textarea").each(function(){
		var input = $(this);
		var text = $(this).val();
		if (text.match(re) || text.match(ja)) {
			count = count+1;
		}
	});
        if(count >0){
		toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
		return;
        }
        if(isSpecialCharForPolicy(policyName) == false){
            $('[name="policyName"]').addClass('parsley-error');
            return;
            }
        var pgList = $('ul.sortable').sortable('toArray');
        var osType = $('[name="osType"]').val();
        if($('select[name="canUserChangePassword"]').val() == 'false' && $('select[name="canAdminChangeUserPassword"]').val() == 'false'){
		$('#canUserChangePassword').addClass('parsley-error');
                $('#canAdminChangeUserPassword').addClass('parsley-error');
                toastr.error('Please check password enforcment  ', 'Fail!!!', {allowHtml: true});
             return;
             }
        if($('span#deviceerror').text() != "")
        {
            toastr.error('Please check the value for Maximum Devices Allowed  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#vererror').text() != "")
        {
            toastr.error('Please check the value for Maximum number of Versions Allowed ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#sizeerror').text() != "")
        {
            toastr.error('Please check the value for Maximum File Size  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#limiterror').text() != "")
        {
            toastr.error('Please check the value for User Storage Quota ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#switcherror').text() != "")
        {
            toastr.error('Please check the value for Network Throttle Setting from Client to BluKrypt ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if(parseInt($('[name="fileChunkableSize"]').val()) > parseInt($('[name="partialFileSize"]').val())){
            toastr.error('Partial File Size should be greater than File Chunkable Size', 'Fail!!!', {allowHtml: true});
            return;
        }
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policy/save',
            data: $('.policyForm').serialize()+'&osTyped='+osType+'&pgList=',
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/sync/policies';
                }, 3000);
            }else{
                myBlockUI.stop();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.policyCreateEdit = function(){
        var pgList = $('ul.sortable').sortable('toArray');
        var osType = $('[name="osType"]').val();
        var $selector = $('.policyForm'),
        form = $selector.parsley();
        if(!form.validate()){
            toastr.error('Please fill all details ', 'Fail!!!', {allowHtml: true});
            return;
        }
	var re = /(<([^>]+)>)/gi;
        var ja = /({([^>]+)})/gi;
        var count = 0;
        $("form#policyForm input[type=text]").each(function(){
		var input = $(this);
		var text = $(this).val();
		if (text.match(re) || text.match(ja)) {
			count = count+1;
		}
	});
        $("form#policyForm textarea").each(function(){
		var input = $(this);
		var text = $(this).val();
		if (text.match(re) || text.match(ja)) {
			count = count+1;
		}
	});
        if(count >0){
		toastr.error('Invalid content', 'Fail!!!', {allowHtml: true});
		return;
        }
        if($('select[name="canUserChangePassword"]').val() == 'false' && $('select[name="canAdminChangeUserPassword"]').val() == 'false'){
		$('#canUserChangePassword').addClass('parsley-error');
                $('#canAdminChangeUserPassword').addClass('parsley-error');
                toastr.error('Please check password enforcment  ', 'Fail!!!', {allowHtml: true});
             return;
             }
        if($('span#deviceerror').text() != "")
        {
            toastr.error('Please check the value for Maximum Devices Allowed  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#vererror').text() != "")
        {
            toastr.error('Please check the value for Maximum number of Versions Allowed ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#sizeerror').text() != "")
        {
            toastr.error('Please check the value for Maximum File Size  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#limiterror').text() != "")
        {
            toastr.error('Please check the value for User Storage Quota ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#switcherror').text() != "")
        {
            toastr.error('Please check the value for Network Throttle Setting from Client to BluKrypt ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if(parseInt($('[name="fileChunkableSize"]').val()) > parseInt($('[name="partialFileSize"]').val())){
            toastr.error('Partial File Size should be greater than File Chunkable Size', 'Fail!!!', {allowHtml: true});
            return;
        }
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policy/saveEdit',
            data: $('.policyForm').serialize()+'&osTyped='+osType+'&pgList=',
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/sync/policies';
                }, 3000);
            }else{
                myBlockUI.stop();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policy',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.policy.filterType == 'inclusion'){
                    $('.inclusionBadge').show();
                    $('.exclusionBadge').hide();
                }else{
                    $('.inclusionBadge').hide();
                    $('.exclusionBadge').show();
                }
                $('#description').val(jData.policy.description);
                $('#noOfDevicesAllowed').val(jData.policy.noOfDevicesAllowed);
		$('#filtersType').val(jData.policy.filterType);
		$('#searchfiltersType').val(jData.policy.searchFilterType);
		if(document.getElementById('enableAVScan')){
			if(jData.policy.enableAVScan == true){
                    		document.getElementById('enableAVScan').checked=true;
                	}else{
                    		document.getElementById('enableAVScan').checked=false;
                	}
		}
                jData.policy.filterInclusionName.forEach(function(value){
                    $('.selectFilterPicker option[value="'+value+'"]').prop('selected', true);
                });
                jData.policy.searchFilterInclusionName.forEach(function(value){
                    $('.selectSearchFilterPicker option[value="'+value+'"]').prop('selected', true);
                });
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            	}
		if(jData.policy.shareDomainsEnabled == true){
        		$('#shareDomainsEnabled').attr('checked', 'checked');
			$('#shareDomainIncExclusions').attr('required', 'required');
		}else{
			$('#shareDomainsEnabled').removeAttr('checked');
			document.getElementById("shareDomainIncExclusions").style['pointer-events'] = 'none';
			document.getElementById("shareDomainIncExclusions").style.opacity = "0.5";
			document.getElementById("shareDomainIncExclusions").style.backgroundColor = "#e9ecef";
			document.getElementById("only").style['pointer-events'] = 'none';
			document.getElementById("withall").style['pointer-events'] = 'none';
		}
		if(jData.policy.shareDomainType == 'Share only with these Email domains'){
                      document.getElementById("only").checked = true;                      
                }else{
                      document.getElementById("withall").checked = true;
		      //$('#shareDomainIncExclusions').attr('required', 'required');
                }
		$('#shareDomainIncExclusions').val(jData.policy.shareDomainIncExclusions);
	    	$('.Open').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.open == true){
                    $('.Open').find('option[value="true"]').prop("selected",true);
                }
                $('.View').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.view == true){
                    $('.View').find('option[value="true"]').prop("selected",true);
                }
                $('.Versions').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.versions == true){
                    $('.Versions').find('option[value="true"]').prop("selected",true);
                }
                if(jData.policy.menuOptions.share == true){
                        console.log("true");
                    $('.Share').find('option[value="true"]').prop("selected",true);
                    $('.shareDetailsLabel').show();
                        $('.highSecureShareEnabled').show();
                    $('.highSecuredShareOptions').show();
                }else{
                        console.log("false");
                    $('.Share').find('option[value="false"]').prop("selected",true);
                    $('.shareDetailsLabel').hide();
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }
                $('.Download').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.download == true){
                    $('.Download').find('option[value="true"]').prop("selected",true);
                }
                $('.rename').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.rename == true){
                    $('.rename').find('option[value="true"]').prop("selected",true);
                }
		$('.CutCopyPaste').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.cutCopyPaste == true){
                    $('.CutCopyPaste').find('option[value="true"]').prop("selected",true);
                }		
		$('.fileUpload').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.fileUpload == true){
                    $('.fileUpload').find('option[value="true"]').prop("selected",true);
                }
		$('.createFolder').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.createFolder == true){
                    $('.createFolder').find('option[value="true"]').prop("selected",true);
                }
		$('.createMinicloud').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.createMiniCloud == true){
                    $('.createMinicloud').find('option[value="true"]').prop("selected",true);
                }
		$('.delete').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.delete == true){
                    $('.delete').find('option[value="true"]').prop("selected",true);
                }
	    if(jData.policy.emailsRestriction.createUser){
                        var array = jData.policy.emailsRestriction.createUser.split(',');
                            array.forEach(function(value){
                                if(value === "admins"){
                                                $('.userCreateAdmins').find('option[value="admins"]').prop("selected",true);
                                            }
                                            if(value === "readonlyadmins"){
                                                $('.userCreateReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                                            }
                                            if(value === "users"){
                                                $('.userCreateUsers').find('option[value="users"]').prop("selected",true);
                                            }
                            });
                }
                if(jData.policy.emailsRestriction.userDeleted){
                    var array = jData.policy.emailsRestriction.userDeleted.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userDeletedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userDeletedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userDeletedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }

                if(jData.policy.emailsRestriction.userBlocked){
                    var array = jData.policy.emailsRestriction.userBlocked.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userBlockedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userBlockedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userBlockedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }
                
                if(jData.policy.emailsRestriction.userLimitReached){
                    var array = jData.policy.emailsRestriction.userLimitReached.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userLimitReachedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userLimitReachedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userLimitReachedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }
            if( $('.exitt')){
                $('.exitt').find('option[value="false"]').prop("selected",true);
            }
            if($('.decouple')){
                $('.decouple').find('option[value="false"]').prop("selected",true);
            }
            if($('.support')){
                $('.support').find('option[value="false"]').prop("selected",true);
            }
            if($('.initiatesync')){
                $('.initiatesync').find('option[value="false"]').prop("selected",true);
            }
            if($('.syncsettings')){
                $('.syncsettings').find('option[value="false"]').prop("selected",true);
            }
            if($('.syncfiles')){
                $('.syncfiles').find('option[value="false"]').prop("selected",true);
            }
            if($('.refreshsyncpolicy')){
                $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
            }
            if($('.search')){
                $('.search').find('option[value="false"]').prop("selected",true);
            }
            if($('.opensyncfolder')){
                $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
            }
            if($('.about')){
                $('.about').find('option[value="false"]').prop("selected",true);
            }
            if($('.updateAgent')){
                $('.updateAgent').find('option[value="false"]').prop("selected",true);
            }
		    if($('.blockNotifications')){
                $('.blockNotifications').find('option[value="false"]').prop("selected",true);
		    }
		    if($('.systrayIcon')){
		        $('.systrayIcon').find('option[value="false"]').prop("selected",true);
		    }		
            if(jData.policy.canUserChangePassword == true){
                     $('.canUserChangePassword').find('option[value="true"]').prop("selected",true);
                 }else{
                     $('.canUserChangePassword').find('option[value="false"]').prop("selected",true);
                 }
                 if(jData.policy.canAdminChangeUserPassword == true){
                     $('.canAdminChangeUserPassword').find('option[value="true"]').prop("selected",true);
                 }else{
                     $('.canAdminChangeUserPassword').find('option[value="false"]').prop("selected",true);
                 }
            if(jData.policy.endpointUiPreferences){    
                jData.policy.endpointUiPreferences.forEach(function(value){
                if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "ABOUT"){
                    $('.about').find('option[value="true"]').prop("selected",true);
                }
                if(value === "UPDATE_AGENT"){
                    $('.updateAgent').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="true"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="true"]').prop("selected",true);
                }
		        if(value === 'BLOCK_NOTIFICATIONS'){
                    $('.blockNotifications').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYSTRAYICON"){
                    $('.systrayIcon').find('option[value="true"]').prop("selected",true);
                }                
                });
            }
                jData.policy.endpointDisabledUiPreferences.forEach(function(value){
                if(value === "EXIT"){
                    $('.exitt').find('option[value="false"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="false"]').prop("selected",true);
                }
                if(value === "ABOUT"){
                    $('.about').find('option[value="false"]').prop("selected",true);
                }
                if(value === "UPDATE_AGENT"){
                    $('.updateAgent').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="false"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="false"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
                }
                if(value === "BLOCK_NOTIFICATIONS"){
                    $('.blockNotifications').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYSTRAYICON"){
                    $('.systrayIcon').find('option[value="false"]').prop("selected",true);
                }		
                });
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
                if($('#policyRefresh')){
                    $('#policyRefresh').val(jData.policy.policyRefresh);
                }
                if((jData.policy.osType.toLowerCase()).indexOf('windows') > -1){
                    $('.selectOsTypePicker').find('option[value="windows"]').prop("selected",true);
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }else{
                    $('.vssContainer').hide();
                    $('.selectOsTypePicker').find('option[value="mac"]').prop("selected",true);
                }
                if(jData.policy.pftEnabled == '1'){
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }else{
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                }
                if($('.syncEnableAutomatic')){
                    if(jData.policy.syncEnableAutomatic == '1'){
                        $('.syncEnableAutomatic').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.syncEnableAutomatic').find('option[value="false"]').prop("selected",true);
                    }
                }
                if(jData.policy.cacheUsedData == '1'){
                    $('.cacheUsedData').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.cacheUsedData').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.contentIndexEnabled == '1'){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.deDuplicationEnabled == '1'){
                    $('.deDuplicationEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.deDuplicationEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.downloadAgent == true){
                   $('.downloadAgent').find('option[value="true"]').prop("selected",true);
                }else{
                   $('.downloadAgent').find('option[value="false"]').prop("selected",true);
                }
                
                if(jData.policy.webBasedLogin == true){
                   $('.webBasedLogin').find('option[value="true"]').prop("selected",true);
                }else{
                   $('.webBasedLogin').find('option[value="false"]').prop("selected",true);
                }
                /*if(jData.policy.shareEnabled == '1'){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }*/
                if($('.twoWayShareEnabled')){
    		        if(jData.policy.twoWayShareEnabled == '1'){
                        $('.twoWayShareEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.twoWayShareEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }
                if(jData.policy.highSecureShareEnabled == '1'){
                    $('#highSecureShareEnabled').attr('checked', 'checked');
                    $('.controllerCPBlock').css('pointer-events','none');
                    $('.controllerADBlock').css('pointer-events','none');
                    $('.controllerEDBlock').css('pointer-events','none');
                    $('.controllerMFABlock').css('pointer-events','none');

                    document.getElementById('controllerED').checked=true;
                    document.getElementById('controllerCP').checked=true;
                    document.getElementById('controllerAD').checked=false;
                    document.getElementById('controllerMFA').checked=true;
                }else{
                    $('#highSecureShareEnabled').removeAttr('checked');
                    $('.controllerCPBlock').css('pointer-events','');
                    $('.controllerADBlock').css('pointer-events','');
                    $('.controllerEDBlock').css('pointer-events','');
                    $('.controllerMFABlock').css('pointer-events','');

                    document.getElementById('controllerED').checked=false;
                    document.getElementById('controllerCP').checked=true;
                    document.getElementById('controllerAD').checked=true;
                    document.getElementById('controllerMFA').checked=false;
                }
		if(jData.policy.showShareLink == '1'){
                    document.getElementById('controllerSL').checked=true;
                }else{
                    document.getElementById('controllerSL').checked=false;
                }
                if(jData.policy.complexPasswordRequired == '1'){
                    document.getElementById('controllerCP').checked=true;
                }else{
                    document.getElementById('controllerCP').checked=false;
                }
                if(jData.policy.preventDownloadEnabled == '1'){
                    document.getElementById('controllerAD').checked=true;
                }else{
                    document.getElementById('controllerAD').checked=false;
                }
                if(jData.policy.expiredDate == '1'){
                    document.getElementById('controllerED').checked=true;
                }else{
                    document.getElementById('controllerED').checked=false;
                }
		if(jData.policy.googleAuth == true){
                    document.getElementById('controllerMFA').checked=true;
                }else{
                    document.getElementById('controllerMFA').checked=false;
                }
                if(jData.policy.contentIndexEnabled == true){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.compressionEnabled == '1'){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                }
                $('.dedup').find('option[value="Disabled"]').prop("selected",true);
                if(jData.policy.dedup == 'User'){
                    $('.dedup').find('option[value="User"]').prop("selected",true);
                }else if(jData.policy.dedup == 'Global'){
                    $('.dedup').find('option[value="Global"]').prop("selected",true);
                }
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
                }
                
                $('#allowedDomains').val(jData.policy.allowedDomains);
                if(jData.policy.endpointDomainCheck == true) {
                    document.getElementById('switchAllowedDomains').checked=true;
                    $('#allowedDomains').prop('readonly', false);
                }
                else{
                    document.getElementById('switchAllowedDomains').checked=false;
                    $('#allowedDomains').prop('readonly', true);
                }		

                //$scope.maxVersions = jData.policy.maxVersions;
                $('#maxVersions').val(jData.policy.maxVersions);
                document.getElementById('switchver').checked=true;
                $('#maxVersions').removeAttr('disabled');
                if(jData.policy.maxVersions == "-1"){
                    document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
                    $('#maxVersions').attr('disabled', 'disabled');
                }
                //$scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxFileSize').val(jData.policy.maxFileSize);
                document.getElementById('switchsize').checked=true;
                $('#maxFileSize').removeAttr('disabled');
                if(jData.policy.maxFileSize == "1048576"){
                    document.getElementById('switchsize').checked = false;
                    $('#maxFileSize').val('UNLIMITED');
                    $('#maxFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                //$scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#userSizeAllowed').val(jData.policy.userSizeAllowed);
                document.getElementById('switchlimit').checked=true;
                $('#userSizeAllowed').removeAttr('disabled');
                if(jData.policy.userSizeAllowed == "102400"){
                    document.getElementById('switchlimit').checked = false;
                    $('#userSizeAllowed').val('UNLIMITED');
                    $('#userSizeAllowed').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').removeAttr('disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		        $('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').removeAttr('disabled');
                $('#networkThrottlingUnit').removeAttr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                $('#noOfDaysToPurgeFile').removeAttr("disabled","disabled");
                $('#noOfDaysToPurgeFile').val(jData.policy.noOfDaysToPurgeFile);
                document.getElementById('switchtobedelete').checked=true;
        
                if(jData.policy.noOfDaysToPurgeFile == "0"){
                    document.getElementById('switchtobedelete').checked = false;
                    $('#noOfDaysToPurgeFile').val('0');
                    $('#noOfDaysToPurgeFile').attr('disabled', 'disabled');
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;

                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                $('.syncEnableAutomatic').selectpicker('render');
                $('.expiredDate').selectpicker('render');
		$('.googleAuth').selectpicker('render');
                $('.cacheUsedData').selectpicker('render');
                $('.contentIndexEnabled').selectpicker('render');
                $('.deDuplicationEnabled').selectpicker('render');
                $('.shareEnabled').selectpicker('render');
                $('.complexPasswordRequired').selectpicker('render');
                $('.selectSearchFilterPicker').selectpicker('render');
                $('.highSecureShareEnabled').selectpicker('render');
                $('.preventDownloadEnabled').selectpicker('render');
                $('.compEnabled').selectpicker('render');
                $('.selectSchedulePicker').selectpicker('render');
                $('.selectOsTypePicker').selectpicker('render');
                $('.incrementalFileTransfer').selectpicker('render');
                $('.dedup').selectpicker('render');
                $('.networkThrottling').selectpicker('render');
                $('.dcmEnabled').selectpicker('render');
                $('.vssEnabled').selectpicker('render');
                $('.selectFilterPicker').selectpicker('render');
                $('#fullBackupPeriod').selectpicker('render');
                $('#fullBackupDay').selectpicker('render');
                $('.selectCcSPicker').selectpicker('render');
                //$scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.updateSelectedFiltersOne(jData.policy.filterInclusionName);
                $scope.updateSelectedSearchFiltersOne(jData.policy.searchFilterInclusionName);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.viewPolicy = function(policyName){
        var policyName = policyName;
        $('.viewPolicy').modal('show');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/viewpolicy',
            data: {csrf_token: $('.csrf_token').html(), secret: '',policyName: policyName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.policy.filterType == 'inclusion'){
                    $('.inclusionBadge').show();
                    $('.exclusionBadge').hide();
                }else{
                    $('.inclusionBadge').hide();
                    $('.exclusionBadge').show();
                }
                $('#description').val(jData.policy.description);
		$('#filtersType1').val(jData.policy.filterType);
                $('#noOfDevicesAllowed').val(jData.policy.noOfDevicesAllowed);
                $('#noOfDevicesAllowed').attr("disabled","disabled");
		$('#filtersType').val(jData.policy.filterType);
		$('#searchfiltersType').val(jData.policy.searchFilterType);
		if(document.getElementById('enableAVScan')){
			if(jData.policy.enableAVScan == true){
                    		document.getElementById('enableAVScan').checked=true;
                	}else{
                    		document.getElementById('enableAVScan').checked=false;
                	}
			$('#enableAVScan').attr('disabled', 'disabled');
		}
                jData.policy.filterInclusionName.forEach(function(value){
                    $('.selectFilterPicker option[value="'+value+'"]').prop('selected', true);
                });
                jData.policy.searchFilterInclusionName.forEach(function(value){
                    $('.selectSearchFilterPicker option[value="'+value+'"]').prop('selected', true);
                });
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            	}
		if(jData.policy.shareDomainsEnabled == true){
        		$('#shareDomainsEnabled').attr('checked', 'checked');
		}else{
        		$('#shareDomainsEnabled').removeAttr('checked');
		}
		$('#shareDomainsEnabled').attr('disabled', 'disabled');
		$('#only').attr('disabled', 'disabled');
		$('#withall').attr('disabled', 'disabled');
		if(jData.policy.shareDomainType == 'Share only with these Email domains'){
                      document.getElementById("only").checked = true;                      
                }else{
                      document.getElementById("withall").checked = true;                      
                }
		$('#shareDomainIncExclusions').val(jData.policy.shareDomainIncExclusions);
		$('.Open').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.open == true){
                    $('.Open').find('option[value="true"]').prop("selected",true);
                }
                $('.View').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.view == true){
                    $('.View').find('option[value="true"]').prop("selected",true);
                }
                $('.Versions').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.versions == true){
                    $('.Versions').find('option[value="true"]').prop("selected",true);
                }
                if(jData.policy.menuOptions.share == true){
                    $('.Share').find('option[value="true"]').prop("selected",true);
                    $('.shareDetailsLabel').show();
                }else{
                    $('.Share').find('option[value="false"]').prop("selected",true);
                    $('.shareDetailsLabel').hide();
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }
                $('.Download').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.download == true){
                    $('.Download').find('option[value="true"]').prop("selected",true);
                }
                $('.rename').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.rename == true){
                    $('.rename').find('option[value="true"]').prop("selected",true);
                }
		$('.CutCopyPaste').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.cutCopyPaste == true){
                    $('.CutCopyPaste').find('option[value="true"]').prop("selected",true);
                }		
		$('.fileUpload').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.fileUpload == true){
                    $('.fileUpload').find('option[value="true"]').prop("selected",true);
                }
		$('.createFolder').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.createFolder == true){
                    $('.createFolder').find('option[value="true"]').prop("selected",true);
                }
		$('.createMinicloud').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.createMiniCloud == true){
                    $('.createMinicloud').find('option[value="true"]').prop("selected",true);
                }
		$('.delete').find('option[value="false"]').prop("selected",true);
                if(jData.policy.menuOptions.delete == true){
                    $('.delete').find('option[value="true"]').prop("selected",true);
                }

		$('#Open').attr('disabled', 'disabled');
                $('#View').attr('disabled', 'disabled');
                $('#Versions').attr('disabled', 'disabled');
                $('#Share').attr('disabled', 'disabled');
                $('#Download').attr('disabled', 'disabled');
                $('#rename').attr('disabled', 'disabled');
                $('#CutCopyPaste').attr('disabled', 'disabled');                
                $('#fileUpload').attr('disabled', 'disabled');
                $('#createFolderr').attr('disabled', 'disabled');
                $('#createMinicloud').attr('disabled', 'disabled');
		$('#delete').attr('disabled', 'disabled');
		    
		$('.userCreateUsers').find('option[value=""]').prop("selected",true);
                $('.userDeletedUsers').find('option[value=""]').prop("selected",true);
                $('.userBlockedUsers').find('option[value=""]').prop("selected",true);
                $('.userLimitReachedUsers').find('option[value=""]').prop("selected",true);

		$('.userCreateAdmins').find('option[value=""]').prop("selected",true);
                $('.userDeletedAdmins').find('option[value=""]').prop("selected",true);
                $('.userBlockedAdmins').find('option[value=""]').prop("selected",true);
                $('.userLimitReachedAdmins').find('option[value=""]').prop("selected",true);

		$('.userCreateReadonlyadmins').find('option[value=""]').prop("selected",true);
                $('.userDeletedReadonlyadmins').find('option[value=""]').prop("selected",true);
                $('.userBlockedReadonlyadmins').find('option[value=""]').prop("selected",true);
                $('.userLimitReachedReadonlyadmins').find('option[value=""]').prop("selected",true);
		if(jData.policy.emailsRestriction.createUser){
                        var array = jData.policy.emailsRestriction.createUser.split(',');
                            array.forEach(function(value){
                                if(value === "admins"){
                                                $('.userCreateAdmins').find('option[value="admins"]').prop("selected",true);
                                            }
                                            if(value === "readonlyadmins"){
                                                $('.userCreateReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                                            }
                                            if(value === "users"){
                                                $('.userCreateUsers').find('option[value="users"]').prop("selected",true);
                                            }
                            });
                }
                if(jData.policy.emailsRestriction.userDeleted){
                    var array = jData.policy.emailsRestriction.userDeleted.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userDeletedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userDeletedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userDeletedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }

                if(jData.policy.emailsRestriction.userBlocked){
                    var array = jData.policy.emailsRestriction.userBlocked.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userBlockedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userBlockedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userBlockedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }
                
                if(jData.policy.emailsRestriction.userLimitReached){
                    var array = jData.policy.emailsRestriction.userLimitReached.split(',');
                    array.forEach(function(value){
                        if(value === "admins"){
                            $('.userLimitReachedAdmins').find('option[value="admins"]').prop("selected",true);
                        }
                        if(value === "readonlyadmins"){
                            $('.userLimitReachedReadonlyadmins').find('option[value="readonlyadmins"]').prop("selected",true);
                        }
                        if(value === "users"){
                            $('.userLimitReachedUsers').find('option[value="users"]').prop("selected",true);
                        }
                    });
                }
            if( $('.exitt')){
                $('.exitt').find('option[value="false"]').prop("selected",true);
            }
            if($('.decouple')){
                $('.decouple').find('option[value="false"]').prop("selected",true);
            }
            if($('.support')){
                $('.support').find('option[value="false"]').prop("selected",true);
            }
            if($('.initiatesync')){
                $('.initiatesync').find('option[value="false"]').prop("selected",true);
            }
            if($('.syncsettings')){
                $('.syncsettings').find('option[value="false"]').prop("selected",true);
            }
            if($('.syncfiles')){
                $('.syncfiles').find('option[value="false"]').prop("selected",true);
            }
            if($('.refreshsyncpolicy')){
                $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
            }
            if($('.search')){
                $('.search').find('option[value="false"]').prop("selected",true);
            }
            if($('.opensyncfolder')){
                $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
            }
            if($('.about')){
                $('.about').find('option[value="false"]').prop("selected",true);
            }
            if($('.updateAgent')){
                $('.updateAgent').find('option[value="false"]').prop("selected",true);
            }
		    if($('.blockNotifications')){
                $('.blockNotifications').find('option[value="false"]').prop("selected",true);
		    }
		    if($('.systrayIcon')){
                $('.systrayIcon').find('option[value="false"]').prop("selected",true);
		    }		
            if(jData.policy.canUserChangePassword == true){
                     $('.canUserChangePassword').find('option[value="true"]').prop("selected",true);
                 }else{
                     $('.canUserChangePassword').find('option[value="false"]').prop("selected",true);
                 }
                 if(jData.policy.canAdminChangeUserPassword == true){
                     $('.canAdminChangeUserPassword').find('option[value="true"]').prop("selected",true);
                 }else{
                     $('.canAdminChangeUserPassword').find('option[value="false"]').prop("selected",true);
                 }
 
            $('.canUserChangePassword').attr("readonly", "readonly");
            $('.canAdminChangeUserPassword').attr("readonly", "readonly");
            if(jData.policy.endpointUiPreferences){
                jData.policy.endpointUiPreferences.forEach(function(value){
                if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "ABOUT"){
                    $('.about').find('option[value="true"]').prop("selected",true);
                }
                if(value === "UPDATE_AGENT"){
                    $('.updateAgent').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="true"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="true"]').prop("selected",true);
                }
		        if(value === "BLOCK_NOTIFICATIONS"){
                    $('.blockNotifications').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYSTRAYICON"){
                    $('.systrayIcon').find('option[value="true"]').prop("selected",true);
                }		
                });
            }
                jData.policy.endpointDisabledUiPreferences.forEach(function(value){
                if(value === "EXIT"){
                    $('.exitt').find('option[value="false"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="false"]').prop("selected",true);
                }
                if(value === "ABOUT"){
                    $('.about').find('option[value="false"]').prop("selected",true);
                }
                if(value === "UPDATE_AGENT"){
                    $('.updateAgent').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="false"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="false"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
                }
                if(value === "BLOCK_NOTIFICATIONS"){
                    $('.blockNotifications').find('option[value="false"]').prop("selected",true);
                }
                if(value === "SYSTRAYICON"){
                    $('.systrayIcon').find('option[value="false"]').prop("selected",true);
                }		
                });
                
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
                if($('#policyRefresh')){
                $('#policyRefresh').val(jData.policy.policyRefresh);
                }
                $("#filters").val(jData.policy.filterInclusionName);
                $('#partialFileSize').val(jData.policy.pftSize);
                    $('#fileChunkableSize').val(jData.policy.fileChunkableSize);
                    $('#dedup').val(jData.policy.dedup);
                    $('#searchAlgoForPg').val(jData.policy.searchAlgoForPg);
                    $('#Blukryptipaddress').val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                if((jData.policy.osType.toLowerCase()).indexOf('windows') > -1){
                    $('.selectOsTypePicker').find('option[value="windows"]').prop("selected",true);
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }else{
                    $('.vssContainer').hide();
                    $('.selectOsTypePicker').find('option[value="mac"]').prop("selected",true);
                }
                if(jData.policy.pftEnabled == '1'){
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }else{
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                }
                if( $('.syncEnableAutomatic')){
                    if(jData.policy.syncEnableAutomatic == '1'){
                        $('.syncEnableAutomatic').find('option[value="true"]').prop("selected",true);
                        $('#syncEnableAutomatic').attr('disabled', 'disabled');
                    }else{
                        $('.syncEnableAutomatic').find('option[value="false"]').prop("selected",true);
                        $('#syncEnableAutomatic').attr('disabled', 'disabled');
                    }
                }
                if(jData.policy.downloadAgent == true){
                   $('.downloadAgent').find('option[value="true"]').prop("selected",true);
                }else{
                   $('.downloadAgent').find('option[value="false"]').prop("selected",true);
                }
                    $('#downloadAgent').attr('disabled', 'disabled');
                
                if(jData.policy.webBasedLogin == true){
                   $('.webBasedLogin').find('option[value="true"]').prop("selected",true);
                }else{
                   $('.webBasedLogin').find('option[value="false"]').prop("selected",true);
                   }
                    $('#webBasedLogin').attr('disabled', 'disabled');
                if(jData.policy.cacheUsedData == '1'){
                    $('.cacheUsedData').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.cacheUsedData').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.contentIndexEnabled == '1'){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.deDuplicationEnabled == '1'){
                    $('.deDuplicationEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.deDuplicationEnabled').find('option[value="false"]').prop("selected",true);
                }
                /*if(jData.policy.shareEnabled == '1'){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }*/
                if($('.twoWayShareEnabled')){
    		        if(jData.policy.twoWayShareEnabled == '1'){
                        $('.twoWayShareEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.twoWayShareEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }
                if(jData.policy.highSecureShareEnabled == '1'){
                    $('#highSecureShareEnabled').attr('checked', 'checked');
                    $('.controllerCPBlock').css('pointer-events','none');
                    $('.controllerADBlock').css('pointer-events','none');
                    $('.controllerEDBlock').css('pointer-events','none');
                    $('.controllerMFABlock').css('pointer-events','none');

                    document.getElementById('controllerED').checked=true;
                    document.getElementById('controllerCP').checked=true;
                    document.getElementById('controllerAD').checked=false;
                    document.getElementById('controllerMFA').checked=true;
                }else{
                    $('#highSecureShareEnabled').removeAttr('checked');
                    $('.controllerCPBlock').css('pointer-events','none');
                    $('.controllerADBlock').css('pointer-events','none');
                    $('.controllerEDBlock').css('pointer-events','none');
                    $('.controllerMFABlock').css('pointer-events','none');

                    document.getElementById('controllerED').checked=false;
                    document.getElementById('controllerCP').checked=true;
                    document.getElementById('controllerAD').checked=true;
                    document.getElementById('controllerMFA').checked=false;
                }
		if(jData.policy.showShareLink == '1'){
                    document.getElementById('controllerSL').checked=true;
                }else{
                    document.getElementById('controllerSL').checked=false;
                }
		$('.controllerSLBlock').css('pointer-events','none');
                if(jData.policy.complexPasswordRequired == '1'){
                    document.getElementById('controllerCP').checked=true;
                }else{
                    document.getElementById('controllerCP').checked=false;
                }
                if(jData.policy.preventDownloadEnabled == '1'){
                    document.getElementById('controllerAD').checked=true;
                }else{
                    document.getElementById('controllerAD').checked=false;
                }
                if(jData.policy.expiredDate == '1'){
                    document.getElementById('controllerED').checked=true;
                }else{
                    document.getElementById('controllerED').checked=false;
                }
		if(jData.policy.googleAuth == true){
                    document.getElementById('controllerMFA').checked=true;
                }else{
                    document.getElementById('controllerMFA').checked=false;
                }   
                if(jData.policy.contentIndexEnabled == true){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                $('#contentIndexEnabled').attr('disabled', 'disabled');
		$("#searchfiltersType1").val(jData.policy.searchFilterType);
		$("#searchFilterInclusionName").val(jData.policy.searchFilterInclusionName);
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                    
                }
                if(jData.policy.compressionEnabled == '1'){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }
                $('.dedup').find('option[value="Disabled"]').prop("selected",true);
                if(jData.policy.dedup == 'User'){
                    $('.dedup').find('option[value="User"]').prop("selected",true);
                }else if(jData.policy.dedup == 'Global'){
                    $('.dedup').find('option[value="Global"]').prop("selected",true);
                }
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
                }
                
                $('#allowedDomains').val(jData.policy.allowedDomains);
                if(jData.policy.endpointDomainCheck == true) {
                    document.getElementById('switchAllowedDomains').checked=true;
                    $('#switchAllowedDomains').attr('disabled', 'disabled');
                    $('#allowedDomains').prop('readonly', false);
                }
                else{
                    document.getElementById('switchAllowedDomains').checked=false;
                    $('#switchAllowedDomains').attr('disabled', 'disabled');
                    $('#allowedDomains').prop('readonly', true);
                }		

                //$scope.maxVersions = jData.policy.maxVersions;
                $('#maxVersions').val(jData.policy.maxVersions);
        document.getElementById('switchver').checked=true;
        $('#switchver').attr('disabled', 'disabled');
                if(jData.policy.maxVersions == "-1"){
            document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
            $('#maxVersions').attr('disabled', 'disabled');
                }
                //$scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxFileSize').val(jData.policy.maxFileSize);
        document.getElementById('switchsize').checked=true;
                $('#switchsize').attr('disabled', 'disabled');
                if(jData.policy.maxFileSize == "1048576"){
            document.getElementById('switchsize').checked = false;
                    $('#maxFileSize').val('UNLIMITED');
            $('#maxFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                //$scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#userSizeAllowed').val(jData.policy.userSizeAllowed);
        document.getElementById('switchlimit').checked=true;
                $('#switchlimit').attr('disabled', 'disabled');
                if(jData.policy.userSizeAllowed == "102400"){
            document.getElementById('switchlimit').checked = false;
                    $('#userSizeAllowed').val('UNLIMITED');
            $('#userSizeAllowed').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').attr('disabled', 'disabled');
                $('#switch').attr('disabled', 'disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		$('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').removeAttr('disabled');
                $('#networkThrottlingUnit').removeAttr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                
                $('#noOfDaysToPurgeFile').val(jData.policy.noOfDaysToPurgeFile);
                document.getElementById('switchtobedelete').checked=true;
                if(jData.policy.noOfDaysToPurgeFile == "0"){
                    document.getElementById('switchtobedelete').checked = false;
                    $('#noOfDaysToPurgeFile').val('0');
                    $('#noOfDaysToPurgeFile').attr('disabled', 'disabled');
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;
                $('.selectSearchFilterPicker').selectpicker('render');
                $('#shareEnabled').attr('disabled', 'disabled');
                if($('#twoWayShareEnabled')){
                    $('#twoWayShareEnabled').attr('disabled', 'disabled');
                }
                $('#highSecureShareEnabled').attr('disabled', 'disabled');
                $('#complexPasswordRequired').attr('disabled', 'disabled');
                $('#preventDownloadEnabled').attr('disabled', 'disabled');
                $('#expiredDate').attr('disabled', 'disabled');
                
                if($('#exitt')){
                    $('#exitt').attr('disabled', 'disabled');
                    $('#syncfiles').attr('disabled', 'disabled');
                    $('#decouple').attr('disabled', 'disabled');
                    $('#refreshsyncpolicy').attr('disabled', 'disabled');
                    $('#support').attr('disabled', 'disabled');
                    $('#search').attr('disabled', 'disabled');
                    $('#initiatesync').attr('disabled', 'disabled');
                    $('#opensyncfolder').attr('disabled', 'disabled');
                    $('#syncsettings').attr('disabled', 'disabled');
                    $('#about').attr('disabled', 'disabled');
                    $('#updateAgent').attr('disabled', 'disabled');
                    $('#systrayIcon').attr('disabled', 'disabled');		    
                }
		$('.userCreateUsers').attr('disabled', 'disabled');
                $('.userCreateReadonlyadmins').attr('disabled', 'disabled');
                $('.userCreateAdmins').attr('disabled', 'disabled');
                $('.userDeletedUsers').attr('disabled', 'disabled');
                $('.userDeletedReadonlyadmins').attr('disabled', 'disabled');
                $('.userDeletedAdmins').attr('disabled', 'disabled');
                $('.userBlockedUsers').attr('disabled', 'disabled');
                $('.userBlockedReadonlyadmins').attr('disabled', 'disabled');
                $('.userBlockedAdmins').attr('disabled', 'disabled');
                $('.userLimitReachedUsers').attr('disabled', 'disabled');
                $('.userLimitReachedReadonlyadmins').attr('disabled', 'disabled');
                $('.userLimitReachedAdmins').attr('disabled', 'disabled');

                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                
                //$scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.updateSelectedFiltersOne(jData.policy.filterInclusionName);
                $scope.updateSelectedSearchFiltersOne(jData.policy.searchFilterInclusionName);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.blockPolicy = function(policyName){
            $.ajax({
                url: $scope.BASE_FOLDER+'/syncpolicy/block',
                data: {csrf_token: $('.csrf_token').html(), policyName: policyName},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.$apply();
                    toastr.success('Policy "'+policyName+'" '+jData.msg, 'Successful!!!', {allowHtml: true});
                    $scope.getPolices();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $scope.getUserPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/user/policy',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function assignCallOutScripts(scripts){
        if(scripts){
            if(scripts.length >= 1){
                scripts.forEach(function(value, key){
                    var items = value.split("|");
                    var scriptName = items[0];
                    var scriptArgs;
                    var scriptType = items[1];
                    if(items[2]){
                        scriptArgs = items[2].split(",");
                    }
                    var data = {};
                    switch (scriptType){
                        case 'preBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        case 'preBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        default:
                            break;
                    }

                });
            }
        }
    }

    $scope.updatePolicyMappingList = function(skipValue, userName){
        $scope.searchForUserName = userName;
	    $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    if(jData.metadata.links){
		    $('.userPolicyMappingListTablePage').show();
                    $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                            }else{
    $('.userPolicyMappingListTablePage').hide();
    }
                if(userName != 'all'){
                    $('.loadMore').hide();
                }
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
			            if(skipValue == 0){
                            $('.noupolicy').show();
                            $('.userPolicyMappingListTable').hide();
                        }
                    }else{
                        $('.noupolicy').hide();
                        $('.userPolicyMappingListTable').show();
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
	                        $('.loadMore').show();
                }else{
                        $('.loadMore').hide();
                }

            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
		        window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

$scope.updatePolicyMappingListNavigate = function(userName, url){
        $scope.searchForUserName = userName;
	$('.first').hide();
	//$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        var myBlockUI = blockUI.instances.get('myBlockUI');
            myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/singleNavigate',
            data: {csrf_token: $('.csrf_token').html(), userName: userName, url: url},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    if(jData.metadata.links){
		    $('.userPolicyMappingListTablePage').show();
                    $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                            }else{
    $('.userPolicyMappingListTablePage').hide();
    }
                    if(jData.users.length <= 0){
                            $('.noupolicy').show();
                            $('.userPolicyMappingListTable').hide();
                    }else{
                        $('.noupolicy').hide();
                        $('.userPolicyMappingListTable').show();
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerPolicyMappingList = function(skipValue, userName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/server/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
                        if(skipValue == 0){
                            toastr.info('There was no servers found for the provided server name', 'Information!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
                    if(userName == 'all' || userName == ''){
                        if($scope.userPolicyMappingUsers.length < 200){
                            $scope.updatePolicyMappingList($scope.skipValue, userName);
                        }
                    }
                }else{
                    if(skipValue != 0) {
                        //toastr.info('All servers has been loaded successfully', 'Information!!!', {allowHtml: true});
                    }
                }
                $('.userPolicyMappingListTable').show();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.stripUsername = function(username) {
        username = username.replace(/\@/g,"WQ");
        username = username.replace(/\./g,"TY");
        username = username.replace(/ /g,"HJ");
        return username;
    }

    $scope.showMappingList = function(userName){
        $('.mappingRow'+userName+' .policyName span').hide();
        $('.mappingRow'+userName+' .policyName form').show();
        $('.mappingRow'+userName+' .action .edit').hide();
        $('.mappingRow'+userName+' .action .save').show();
        $('.mappingRow'+userName+' .action .cancel').show();
        var value = $('.mappingRow'+userName+' .policyName span').html();
        $('#userPolicyMappingPolicyName'+userName+' option[value="'+value+'"]').prop('selected', true);
    };

    $scope.cancelChangePolicy = function(userName){
        $('.mappingRow'+userName+' .policyName span').show();
        $('.mappingRow'+userName+' .policyName form').hide();
        $('.mappingRow'+userName+' .action .edit').show();
        $('.mappingRow'+userName+' .action .save').hide();
    };
    
    $scope.changePolicy = function($index,oldPolicyName){
        var finalIndex;
	var userName = $('.actualUserName'+$index).html();
        var oldPolicyName = oldPolicyName;
        var newPolicyName = $('[name="userPolicyMappingPolicyName'+$index+'"]').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/single/save',
            data: {csrf_token: $('.csrf_token').html(), userName: userName, oldPolicyName: oldPolicyName, newPolicyName: newPolicyName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    userName = userName.replace(/\&amp;/g,"&");
                $scope.userPolicyMappingUsers.forEach(function(message, index) {
                    Object.keys(message).forEach(function(prop) {
                if(message[prop] == userName){
                finalIndex = index;
                }
                    });
                });
                $scope.userPolicyMappingUsers[finalIndex].syncPolicyName = newPolicyName;
                $scope.$apply();
                $('.mappingRow'+$index+' .policyName span').show();
                $('.mappingRow'+$index+' .policyName form').hide();
                $('.mappingRow'+$index+' .action .edit').show();
                $('.mappingRow'+$index+' .action .save').hide();
                toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    
    $scope.changeMultiplePolicy = function(){
        var multiplePolicyName = $('[name="multiplePolicyName"]').selectpicker('val');
        var html = $('.pmsSavePolicyBtn').html();
        $('.pmsSavePolicyBtn').attr('disabled','disabled');
        $('.pmsSavePolicyBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if(multiplePolicyName && $('#userNames').val()){
            var userNames = $('#userNames').val();
            //userNames = userNames.replace(/\s/g,'');
            userNames = userNames.trim();
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/multiple/save',
                data: {csrf_token: $('.csrf_token').html(), userNames: userNames, policyName: multiplePolicyName},
                type: 'POST'
            }).done(function(data){
                $('.pmsSavePolicyBtn').removeAttr('disabled');
                $('.pmsSavePolicyBtn').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
                    $('#userNames').val("");
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/sync/policyMapping/single';
                }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(!$('#userNames').val()){
                toastr.info('Please select users', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }else{
                toastr.info('Please select a Policy', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }
        }
    };

    $scope.getBluvault = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.bluvaults != null){
                    $scope.bluvaults = jData.bluvaults;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBluvault = function(bluvault){
        bluvault.replace("https://", '');
        bluvault.replace("http://", '');
        if(checkIfExistsInBluvault($scope.bluvaults, bluvault)){
            toastr.info('Bluvault has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submit').html();
        $('.submit').attr('disabled','disabled');
        $('.submit').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/save',
            data: {csrf_token: $('.csrf_token').html(), bluvault: bluvault},
            type: 'POST'
        }).done(function(data){
            $('.submit').html(html);
            $('.submit').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.getBluvault();
                toastr.success('Bluvault has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluvault = function(bluvaultId, $key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/delete',
            data: {csrf_token: $('.csrf_token').html(), bluvaultId: bluvaultId},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.bluvaults.splice($key, 1);
                toastr.success('Bluvault has been successfully removed', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.blukrypts = jData.blukrypts;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluKrypt = function(bluKrypt, $key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/remove',
            data: {csrf_token: $('.csrf_token').html(), bluKrypt: bluKrypt},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.blukrypts.splice($key, 1);
                toastr.success('BluKrypt has been successfully removed', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBlukrypt = function(blukrypt){
        var blukryptType = $('[name="blukryptType"]').val();
        blukrypt = blukrypt.replace("https://", '');
        blukrypt = blukrypt.replace("http://", '');
        if(checkIfExistsInBlukrypt($scope.blukrypts, blukrypt, blukryptType)){
            toastr.info('Blukrypt has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submit').html();
        $('.submit').attr('disabled','disabled');
        $('.submit').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/save',
            data: {csrf_token: $('.csrf_token').html(), blukrypt: blukrypt, blukryptType: blukryptType},
            type: 'POST'
        }).done(function(data){
            $('.submit').html(html);
            $('.submit').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="blukrypt"]').val('');
                $scope.getBlukrypts();
                toastr.success('Blukrypt has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.setThrottlingLimit = function(blukrypt){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/save',
            data: $('.throttlingForm').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeThrottlingLimit = function(id){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/remove',
            data: {csrf_token: $('.csrf_token').html(), id: id},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openScript = function(scriptType){
        $scope.scriptType = scriptType;
        $('.addScript').modal('show');
    };

    $scope.addAScript = function(){
        $scope.tempScriptName = $('[name="scriptName"]').val();
        $scope.tempScriptArgs = $('#scriptArgs').val();
        $scope.tempBackupType = $('#backupType').val();

        if($scope.tempScriptName.length >= 1){

            var data = {
                scriptName : $scope.tempScriptName,
                backupType : $scope.tempBackupType,
                scriptArgs : $scope.tempScriptArgs
            };
            switch($scope.scriptType) {
                case 'preBackup':
                    if($scope.preBackup.length <= 2){
                        $scope.preBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postBackup':
                    if($scope.postBackup.length <= 2){
                        $scope.postBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'preRestore':
                    if($scope.preRestore.length <= 2){
                        $scope.preRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postRestore':
                    if($scope.postRestore.length <= 2){
                        $scope.postRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                default:
                    toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                    break;
            }
            $('[name="scriptName"]').val('');
            $('#scriptArgs').val(null).trigger("change");
            $('.addScript').modal('hide');
        }else{
            toastr.error('Please enter a script Name', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.removeScript = function(scriptType, index){
        switch(scriptType) {
            case 'preBackup':
                if($scope.preBackup.length <= 2){
                    $scope.preBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postBackup':
                if($scope.postBackup.length <= 2){
                    $scope.postBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'preRestore':
                if($scope.preRestore.length <= 2){
                    $scope.preRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postRestore':
                if($scope.postRestore.length <= 2){
                    $scope.postRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            default:
                toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                break;
        }
    };

    $scope.getAllCloudCredentials = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getCloudCredentials',
            data: $('form').serialize(),
            type: 'POST'
        }).done(function(data){
            $('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.ccS.length > 0){
                    $scope.ccS = jData.ccS;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveCloudCredentials = function(type){
        if($('.cloudCredentials').parsley().isValid()){
            var html = $('.saveCcS').html();
            $('.saveCcS').attr('disabled','disabled');
            $('.saveCcS').html('Deleting... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/saveCloudCredentials',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.saveCcS').removeAttr('disabled');
                $('.saveCcS').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(type == true){
                        $('.createCcS').modal('hide');
                        $('#ccS').append($('<option>', {
                            value: $('[name="identity"]').val(),
                            text: $('[name="identity"]').val()
                        }));
                        $('.selectCcSPicker').selectpicker('val', $('[name="identity"]').val());
                        $('.selectCcSPicker').selectpicker('refresh');
                    }else{
                        $scope.getAllCloudCredentials();
                    }
                    $('.cloudCredentials input').val('');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.removeCloudCredentials = function(key){
        var btn = $('.removeCredentialsBtn'+key);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Removing... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if($scope.ccS[key]){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/removeCloudCredentials',
                data: {identity: $scope.ccS[key].identity, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                btn.removeAttr('disabled');
                btn.html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $scope.getAllCloudCredentials();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    function checkIfExistsInBluvault(bluvaults, bluvault){
        var result = false;
        if(bluvaults.length > 0){
            bluvaults.forEach(function(value, key){
                if(value.bluVaultName == bluvault){
                    result = true;
                }
            });
        }
        return result;
    }

    function checkIfExistsInBlukrypt(blukrypts, blukrypt, type){
        var result = false;
        if(blukrypts.length > 0) {
            blukrypts.forEach(function (value, key) {
                if (value.gatewayName == blukrypt && value.type == type) {
                    result = true;
                }
            });
        }
        return result;
    }

    function enableLegalHold(){
        $scope.maxVersions = $('#maxVersions').val();
        $scope.maxPermissibleFileSize = $('#maxPermissibleFileSize').val();
        $scope.perUserBackupStorageLimit = $('#perUserBackupStorageLimit').val();
        $scope.cpuUtilization = $('#cpuUtilization').val();
        $scope.memoryUtilization = $('#memoryUtilization').val();
        $scope.currentDefaultWinFolders = $scope.defaultWinFolders;
        $scope.currentDefaultMacFolders = $scope.defaultMacFolders;
        $scope.defaultWinFolders = ['ALL'];
        $scope.defaultMacFolders = ['ALL'];
        $scope.$apply();
        $('.allFilters').hide();
        $('#maxVersions').val('UNLIMITED');
        $('#maxVersions').attr('readonly', 'readonly');
        $('#maxVersions').removeAttr('data-parsley-type','integer');
        $('#maxVersions').removeAttr('data-parsley-min','1');

        $('#maxPermissibleFileSize').val('UNLIMITED');
        $('#maxPermissibleFileSize').attr('readonly', 'readonly');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-min','1');

        $('#perUserBackupStorageLimit').val('UNLIMITED');
        $('#perUserBackupStorageLimit').attr('readonly', 'readonly');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-min','1');

        $('#cpuUtilization').val(100);
        $('#cpuUtilization').attr('readonly', 'readonly');
        $('#cpuUtilization').removeAttr('data-parsley-min','20');
        $('#cpuUtilization').removeAttr('data-parsley-max','100');

        $('#memoryUtilization').val(1024);
        $('#memoryUtilization').attr('readonly', 'readonly');
        $('#memoryUtilization').removeAttr('data-parsley-min','20');
        $('#memoryUtilization').removeAttr('data-parsley-max','100');

        $('#defaultFoldersBackup').attr('disabled', 'disabled');
        $('.defaultFoldersBackupBtn').attr('disabled', 'disabled');

        $('.systemFolders').show();
    }

    function disableLegalHold(){
        if($scope.maxVersions <= 0){
            $scope.maxVersions = 1
        }
        if($scope.maxPermissibleFileSize <= 0){
            $scope.maxPermissibleFileSize = 1024
        }
        if($scope.perUserBackupStorageLimit <= 0){
            $scope.perUserBackupStorageLimit = 10
        }
        if($scope.cpuUtilization <= 0){
            $scope.cpuUtilization = 80
        }
        if($scope.memoryUtilization <= 0){
            $scope.memoryUtilization = 80
        }
        $('.allFilters').show();
        $('#maxVersions').val($scope.maxVersions);
        $('#maxVersions').removeAttr('readonly');
        $('#maxVersions').attr('data-parsley-type','integer');
        $('#maxVersions').attr('data-parsley-min','1');

        $('#maxPermissibleFileSize').val($scope.maxPermissibleFileSize);
        $('#maxPermissibleFileSize').removeAttr('readonly');
        $('#maxPermissibleFileSize').attr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').attr('data-parsley-min','1');

        $('#perUserBackupStorageLimit').val($scope.perUserBackupStorageLimit);
        $('#perUserBackupStorageLimit').removeAttr('readonly');
        $('#perUserBackupStorageLimit').attr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').attr('data-parsley-min','1');

        $('#memoryUtilization').val($scope.memoryUtilization);
        $('#memoryUtilization').removeAttr('readonly');
        $('#memoryUtilization').attr('data-parsley-type','integer');
        $('#memoryUtilization').attr('data-parsley-min','20');
        $('#memoryUtilization').attr('data-parsley-max','100');

        $('#cpuUtilization').val($scope.cpuUtilization);
        $('#cpuUtilization').removeAttr('readonly');
        $('#cpuUtilization').attr('data-parsley-type','integer');
        $('#cpuUtilization').attr('data-parsley-min','20');
        $('#cpuUtilization').attr('data-parsley-max','100');

        $('#defaultFoldersBackup').removeAttr('disabled');
        $('.defaultFoldersBackupBtn').removeAttr('disabled');

        $('.systemFolders').hide();
        $('#systemFolders').removeAttr('checked');
        if($scope.currentDefaultWinFolders != 'ALL' && $scope.currentDefaultMacFolders != 'ALL'){
            $scope.defaultWinFolders = $scope.currentDefaultWinFolders;
            $scope.defaultMacFolders = $scope.currentDefaultMacFolders;
        }else{
            $scope.defaultWinFolders = ['c:\\', 'd:\\'];
            $scope.defaultMacFolders = ['/users/', '/home/'];
        }
        $scope.$apply();
    }

    $scope.redirectTo = function(url){
        window.location = url;
    };
    
    $scope.downloadSample = function(type){
        switch (type) {
            case 'common':
                window.location.href = $scope.BASE_FOLDER+'/policy/downloadSample';
                break;
            case 'downloadDump':
                window.location.href = $scope.BASE_FOLDER+'/policy/downloadDump';
                break;
            }
    };
    
    $scope.readUserNamesFromExcel = function(files) {

        angular.forEach(files, function(file, key) {

            if (file && !file.$error) {

                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUpload',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });

                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#userNames').tagsinput('add', value);
                                    }
                                });

                                toastr.success('Usernames has been imported from the excel, please click on "import" and continue with the migration proccess', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });

                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });

            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        if($scope.currentPage == 'schedule'){
            $scope.getSchedules();
        }

        if($scope.currentPage == 'filter'){
            $scope.getFilters();
        }

        if($scope.currentPage == 'policy'){
            $scope.getPolices();
        }
        
        if($scope.currentPage == 'createPolicy'){
            $scope.getAllFilters();
            $('.exc').hide();
            $('.inc').show();
            $('.selectFilterPicker').selectpicker('val', 'all_files');
            $('.inc').selectpicker('val', 'all_files');
            $('.inc').find('option[value="all_files"]').prop("selected",true);
            //$scope.updateSelectedFiltersOne($('.inc').val());
            $('.selectFilterPicker').selectpicker('refresh');
	    $('.excSearch').hide();
            $('.incSearch').show();
            /*$('.incSearch').selectpicker('val', 'all_files');
            $('.incSearch').find('option[value="all_files"]').prop("selected",true);
	    $scope.updateSelectedSearchFiltersOne($('.incSearch').val());*/
	    $('.excSearch').hide();
            $('.incSearch').show();
            /*$('.incSearch').selectpicker('val', 'all_files');
            $('.incSearch').find('option[value="all_files"]').prop("selected",true);
            $scope.updateSelectedSearchFiltersOne($('.incSearch').val());*/
	    //$scope.updateSelectedFiltersOne($('#filters').val());
	    $('.selectFilterPicker').selectpicker('val', 'all_files');
            $('.selectFilterPicker').selectpicker('val', 'all_files');
            $('.selectFilterPicker').find('option[value="all_files"]').prop("selected",true);
	    //$scope.updateSelectedFiltersOne($('.selectFilterPicker').val());
	    $scope.updateSelectedFiltersOne($('#filters').val());
	    $('.selectSearchFilterPicker').selectpicker('val', 'all_files');
            $('.selectSearchFilterPicker').selectpicker('val', 'all_files');
            $('.selectSearchFilterPicker').find('option[value="all_files"]').prop("selected",true);
            $scope.updateSelectedSearchFiltersOne($('#searchfilters').val());
        }

        if($scope.currentPage == 'editPolicy'){
            $scope.getPolicy();
            $('.selectFilterTypePicker option[value="'+$scope.filType+'"]').prop('selected', true);
            if($scope.filType == 'inclusion'){
                $('.exc').hide();
                $('.inc').show();
            }else if($scope.filType == 'exclusion'){
                $('.inc').hide();
                $('.exc').show();
            }
            $('.selectSearchFilterTypePicker option[value="'+$scope.searchfilType+'"]').prop('selected', true);
            if($scope.searchfilType == 'inclusion'){
                $('.excSearch').hide();
                $('.incSearch').show();
            }else if($scope.searchfilType == 'exclusion'){
                $('.incSearch').hide();
                $('.excSearch').show();
            }
        }
        
        if($scope.currentPage == 'clonePolicy'){
            $scope.getPolicy();
            $('.selectFilterTypePicker option[value="'+$scope.filType+'"]').prop('selected', true);
            if($scope.filType == 'inclusion'){
                $('.exc').hide();
                $('.inc').show();
            }else if($scope.filType == 'exclusion'){
                $('.inc').hide();
                $('.exc').show();
            }
            $('.selectSearchFilterTypePicker option[value="'+$scope.searchfilType+'"]').prop('selected', true);
            if($scope.searchfilType == 'inclusion'){
                $('.excSearch').hide();
                $('.incSearch').show();
            }else if($scope.searchfilType == 'exclusion'){
                $('.incSearch').hide();
                $('.excSearch').show();
            }
        }

        if($scope.currentPage == 'singlePolicyMapping'){
            $scope.updatePolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'singleServerPolicyMapping'){
            $scope.updateServerPolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'bluvault'){
            $scope.getBluvault();
        }

        if($scope.currentPage == 'blukrypts'){
            $scope.getBlukrypts();
        }

        if($scope.currentPage == 'ccS'){
            $scope.getAllCloudCredentials();
        }

        $('#legalHold').on('change', function(){
            var checked = document.getElementById('legalHold').checked;
            if(checked){
                enableLegalHold();
            }else{
                disableLegalHold();
            }
        });

    });

}]);
