/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ShareWithController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'sharedTime';

    $scope.items = [];

    $scope.selected = [];

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/filesSharedWithMe',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                $('.filePanel').show();
                $scope.items = jData.items;
                $scope.$apply();
                if($scope.items.length <= 0){
                    $('.status').show();
                }else{
                    toastr.success('All files loaded successfully', 'Success!!!', {allowHtml: true});
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.selectionStart = function(selected){
        $scope.selected = [];
    };

    $scope.selectionStop = function(selected){
        disableButtons();
        $scope.selected = selected;
        /*if(selected.length == 1){
            enableButtons();
        }*/
	if(selected.length == 1 && $scope.selected[0].isView == 'true'){
                $('.viewAction').show();
        }else{
                $('.viewAction').hide();
        }
        if(selected.length == 1 && $scope.selected[0].isDownload == 'true'){
        	$('.downloadAction').show();
        }else{
        	$('.downloadAction').hide();
	}
    };

    function disableButtons(){
        $('.viewAction').hide();
        $('.downloadAction').hide();
    }

    function enableButtons(){
        $('.viewAction').show();
        $('.downloadAction').show();
    }

    $scope.menuOptions = [
        ['View', function ($itemScope) {
            $scope.view();
        }, function(){
            if($scope.selected.length == 1 && $scope.selected[0].isView == 'true'){
                return true;
            }
        }],
        ['Download', function ($itemScope) {
            $scope.download();
        }, function(){
            if($scope.selected.length == 1 && $scope.selected[0].isDownload == 'true'){
                return true;
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return true;
            }
        }],
        ['Cannot Download Multiple Files', function () {

        }, function(){
            if($scope.selected.length > 1){
                return true;
            }
        }],
	['No option available', function ($itemScope) {
        }, function(){
            if($scope.selected.length == 1 && $scope.selected[0].isView == 'false' && $scope.selected[0].isDownload == 'false'){
                return true;
            }
        }]
    ];

    $scope.download = function(){
        var data = {
            type : 'download',
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == true){
                if($scope.selected[0].gatewayName.length > 0){
                    window.open($('.protocol').html()+$scope.selected[0].gatewayName+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+Base64.encode(htmlspecialchars_decode($scope.selected[0].fileName))+'&filePath='+Base64.encode(htmlspecialchars_decode($scope.selected[0].devicePath))+'&token='+$('.uploadToken').html()+'&userName='+Base64.encode(htmlspecialchars_decode($scope.selected[0].userName))+'&syncRevisionId='+$scope.selected[0].syncRevisionID+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName)+'&loginUserName='+Base64.encode(htmlspecialchars_decode($('.uploadUserName').html())), '_self');
                }else{
                    window.open($('.protocol').html()+$('.blukryptIP').html()+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+Base64.encode(htmlspecialchars_decode($scope.selected[0].fileName))+'&filePath='+Base64.encode(htmlspecialchars_decode($scope.selected[0].devicePath))+'&token='+$('.uploadToken').html()+'&userName='+Base64.encode(htmlspecialchars_decode($scope.selected[0].userName))+'&syncRevisionId='+$scope.selected[0].syncRevisionID+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName)+'&loginUserName='+Base64.encode(htmlspecialchars_decode($('.uploadUserName').html())), '_self');
                }
            }else{
                toastr.error('File has been un-shared or something went wrong while retrieving the file', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    /*$scope.view = function(){
        var data = {
            type : 'view',
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == true){
                $('#paraviewContainer .modal-title').html('Loading ...');
                $('.content').html('');
                $('.content').hide();
                $('.pageContainer').hide();
                $('.excelContainer').hide();
                $('.pdfContainer').hide();
                $('.imageViewer').hide();
                $('.paraviewLoading').show();

                $('#paraviewContainer').modal('show');
                $.ajax({
                    url: $scope.BASE_FOLDER+'/share/view',
                    data: {path: $scope.selected[0].devicePath, fileName:$scope.selected[0].fileName, syncRevisionId: $scope.selected[0].syncRevisionID, userName:$scope.selected[0].userName, password:'shareWith'},
                    type: 'POST'
                }).done(function(data){
                    var jData = JSON.parse(data);

                    if(jData.result == 'fail'){
                        $('#paraviewContainer').modal('hide');
                        toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                        return;
                    } else{
                        if(jData.type == 'image') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.imageViewer').html(jData.html);
                            $('.imageViewer').show();
                            $('.paraviewLoading').hide();

                        }else if(jData.type == 'pdf') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.paraviewLoading').hide();
                            $('.pdfContainer').html(jData.html);
                            $('.pdfContainer').show();

                        }else if(jData.type == 'odt') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.pageContainer').show();
                            $('.paraviewLoading').hide();
                            viewDoc(jData, 300, 100);

                        }else if(jData.type == 'text') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.content').html(jData.html);
                            $('.paraviewLoading').hide();
                            $('.content').show();

                        }else if(jData.type == 'excel') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.excelContainer').show();
                            $('.paraviewLoading').hide();
                            viewExcel(jData);

                        }else{

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.pageContainer').show();
                            $('.paraviewLoading').hide();
                            viewDoc(jData, 400, 100);

                        }
                    }

                }).fail(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(data.status == 503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            }else{
                toastr.error('File has been un-shared or something went wrong while retrieving the file', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };*/
    
    $scope.view = function(){
        $('#paraviewContainer .modal-title').html('Loading ...');
        var abc = $scope.selected[0].fileName.substring($scope.selected[0].fileName.lastIndexOf('.') + 1);
            console.log("abc : "+abc);
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();
        $('.pptxViewer').hide();
        $('#paraviewContainer').modal('show');
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/view',
                data: {path: $scope.selected[0].devicePath, fileName:$scope.selected[0].fileName, fileRevisionId: $scope.selected[0].syncRevisionID, userName:$scope.selected[0].userName, password:'shareWith'},
            type: 'POST'
        }).done(function(data){
            console.log(data);
	    $('#paraviewContainer .modal-content').css("background-color","white");
            if(abc == 'txt' || abc == 'TXT'){
                $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                $('.content').html('<pre>'+data+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else{
		    var jData = JSON.parse(data);
		    if(jData.result == 'fail'){
			toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
			$('#paraviewContainer').modal('hide');
			return;
		    }
		    $('#paraviewContainer .modal-content').css("background-color","white");
		    if(jData.type == 'image') {
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			if(abc == 'TIFF' || abc == 'tiff' || abc == 'TIF' || abc == 'tif'){
			    console.log("inside tif loop");
					$('.imageViewer').html('<center><span id="tifSpinner"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>');
					/*start*/
					Tiff.initialize({TOTAL_MEMORY: 16777216 * 10});
			    var xhr = new XMLHttpRequest();
			    xhr.open('GET', jData.fileName);
			    xhr.responseType = 'arraybuffer';
				    xhr.onload = function (e) {
				var buffer = xhr.response;
				var tiff = new Tiff({buffer: buffer});
				for (var i = 0, len = tiff.countDirectory(); i < len; ++i) {
				    tiff.setDirectory(i);
				    var canvas = tiff.toCanvas();
				    console.log("gggggggggg");
				    $('.imageViewer').append(canvas);
				}
				$('#tifSpinner').hide();
			    };
			    xhr.send();
					/*end*/
			}else{
			    $('.imageViewer').html(jData.html);
				}
			$('.imageViewer').show();
			$('.paraviewLoading').hide();
		    }else if(jData.type == 'pptx' || jData.type == 'ppt'){
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.paraviewLoading').hide();
			$('.pptxViewer').show();
			if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)){
			    // true for mobile device
			    $('.pptxViewer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 22px solid #444343;position:absolute;width:34%;bottom:1%;right:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="-webkit-fill-available" height="-webkit-fill-available" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
			}else{
			    // false for not mobile device
			    $('.pptxViewer').html('<p class="text-left">Note: Please use arrow keys to navigate between slides</p><div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 30px solid white;position:absolute;width:100%;bottom:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
			    document.getElementsByTagName('iframe').autofocus;
			}
		    }else if(jData.type == 'pdf') {
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.paraviewLoading').hide();
			$('.pdfContainer').html(jData.html);
			$('.pdfContainer').show();
		    }else if(jData.type == 'odt') {
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.pageContainer').show();
			$('.paraviewLoading').hide();
			viewDoc(jData, 300, 100);
		    }else if(jData.type == 'text') {
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.content').html('<pre>'+jData.html+'</pre>');
			$('.paraviewLoading').hide();
			$('.content').show();
		    }else if(jData.type == 'excel') {
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.excelContainer').show();
			$('.paraviewLoading').hide();
			$('.excelContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 31px solid white;position:absolute;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
		    }else{
			$('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
			$('.pageContainer').show();
			$('.paraviewLoading').hide();
			$('.pageContainer').html('<div id="container12" style="position:relative;overflow:hidden;"><div id="overlay12" style="border-bottom: 25px solid white;position:absolute;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
		    }
	    }
	}).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $('#paraviewContainer').on('hidden.bs.modal', function () {
        $('.page').remove();
        $('.pageContent').remove();
        $('.pageContainer').html('');
    });

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }
    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        })

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }

    $scope.changePasswordForGuest = function(){

        var passwordGuest = $('#passwordGuest').val();
        var rePasswordGuest = $('#rePasswordGuest').val();
        console.log("passwordGuest : "+passwordGuest)

        var html = $('#changePasswordBtnGuest').html();
        $('#changePasswordBtnGuest').attr('disabled','disabled');
        $('#changePasswordBtnGuest').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if ( $('#changePasswordFormGuest').parsley().isValid() && passwordGuest == rePasswordGuest) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePasswordForGuest',
                data: $('#changePasswordFormGuest').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePasswordForGuest').modal('hide');
                    $('#changePasswordBtnGuest').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        toastr.success('Password Successfully changed', 'Success!!!');
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                    $('#passwordGuest').val("");
                    $('#rePasswordGuest').val("");
                    // location.reload();
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);
                }else{
                    $('#changePasswordBtnGuest').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('old & new password cannot be same', 'Fail!!!');
                        $('#passwordGuest').val("");
                        $('#rePasswordGuest').val("");
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
	
    var Base64 = {


    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",


    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

        }

        return output;
},


    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;
    },

    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {
        c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }

}

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'trash'){
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true);
        }

    });

}]);
