<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Sync extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Sync Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
        $url = $this->api->getUrl('syncFiles');
        Model::req($url,$headers,$data);
        $this->log('Url: '.$url, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $this->log('Headers: '. json_encode($headers), 'info');
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $miniCloudName
     * @return array
     */
    public function createMiniCloud($headers, $miniCloudName){
        $url = $this->api->getUrl('createMiniCloud');
        Model::req($url,$headers,$miniCloudName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $miniCloudName);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveMiniCloud($headers, $miniCloudName){
        $url = $this->api->getUrl('saveMiniCloud');
        Model::req($url,$headers,$miniCloudName);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $miniCloudName);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getMiniCloud($headers, $miniCloudName){
        $url = $this->api->getUrl('getMiniCloud', array('miniCloudName' => $miniCloudName));
        Model::req($url,$headers,$miniCloudName);
        $this->log('URL: '.$url, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Creates a folder
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function cancelUpload($headers){
        $url = $this->api->getUrl('cancelUpload');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Creates a folder
     *
     * Token should be sent in header
     * @param $headers
     * @param $folderName
     * @return array
     */
    public function createFolder($headers, $folderName){
        $url = $this->api->getUrl('createFolder');
        Model::req($url,$headers,$folderName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folderName);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserData($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.$username.DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $content
     * @return array
     */
    public function upload($headers, $content){
        $url = $this->api->getUrl('upload');
        Model::req($url,$headers,$content);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $content);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 448) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
        $url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$_SESSION['cloudName'].DS.'sync'.DS.'portal'.DS.'view'.DS.'file'.DS;
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->log("url: ".$this->api->getUrl("download"), "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadShare($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
        $url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$headers['cloudName'].DS.'sync'.DS.'portal'.DS.'view'.DS.'file'.DS;
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->log("url: ".$this->api->getUrl("download"), "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileInfo($headers){
        $url = $this->api->getUrl('fileInfo');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileVersions($headers){
        $url = $this->api->getUrl('syncFileVersions');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveFileRevisionComments($headers){
        $url = $this->api->getUrl('saveFileRevisionComments');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveRename($headers){
        $url = $this->api->getUrl('syncFileRename');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function deleteFilesFolders($headers){
        $url = $this->api->getUrl('deleteFilesFolders');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function deleteMiniCloud($headers, $xml){
        $url = $this->api->getUrl('deleteMiniCloud');
        Model::req($url,$headers,$xml);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFile($headers, $elements){
        $url = $this->api->getUrl('syncFileShare');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFileWith($headers, $elements){
        $url = $this->api->getUrl('syncFileShareWith');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function updateSharePolicy($headers, $elements){
        $url = $this->api->getUrl('updateSharePolicy');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $fileName
     * @return array
     */
    public function checkForMiniCloud($headers, $fileName){
        $url = $this->api->getUrl('checkForMiniCloud', array('fileName', $fileName));
        Model::req($url,$headers,$fileName);
        $this->log('URL: '.$url, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function isSharedOrNot($headers){
        $url = $this->api->getUrl('isSharedOrNot');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function unShare($headers, $xml){
        $url = $this->api->getUrl('unShare');
        Model::req($url,$headers,$xml);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $selectedFiles
     * @param $action
     * @return array
     */
    public function cutCopy($headers, $selectedFiles, $action){
        $url = $this->api->getUrl('cutCopy');
        $data = array(
            $selectedFiles,
             $action
        );
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url.'/'.$action, $selectedFiles);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSharedFiles($headers){
        $url = $this->api->getUrl('sharedFiles');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFilesSharedWithMe($headers){
        $url = $this->api->getUrl('filesSharedWithMe');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getDeletedFiles($headers){
        $url = $this->api->getUrl('deletedFiles');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function purgeFile($headers){
        $url = $this->api->getUrl('purgeFile');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function purgeAll($headers){
        $url = $this->api->getUrl('purgeAll');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function restoreFile($headers){
        $url = $this->api->getUrl('restoreFile');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function restoreAll($headers){
        $url = $this->api->getUrl('restoreAll');
        Model::req($url,$headers,$data);
        $this->log('Url: '. $url);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Sends an email
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function sendShareEmail($headers, $data){
        $url = $this->api->getUrl('sendEmail');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Sends an auditHistory
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function auditHistory($headers){
        $url = $this->api->getUrl('auditHistory');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $searchType
     * @return array
     */
    public function getSearchResults($headers, $searchType){
//          $url = $this->api->getUrl($searchType);
            $url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/search/file?pageNumber=1";
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getSearchResultsNavigate($headers, $searchType, $url){
//          $url = $this->api->getUrl($searchType);
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllMiniClouds($headers){
        $url = $this->api->getUrl('miniCloud');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function changeOwner($headers){
        $url = $this->api->getUrl('changeOwner');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSyncRevisionId($headers){
        $url = $this->api->getUrl('syncRevisionId');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function assignUsers($headers){
        $url = $this->api->getUrl('assignUsers');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getUserSyncPolicy($headers){
        $url = $this->api->getUrl('getUserSyncPolicy');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function exportMiniCloudsToExcel($headers){
          $url = $this->api->getParacloudUrl('exportMiniCloudsToExcel');
          $this->curl->setHeaders($headers);
          $this->curl->post($url);
          $this->log('Result_headers'.json_encode($headers), 'info');
          $this->log('Result_url'.json_encode($url), 'info');
          $result = array(
              'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
               'body' => $this->curl->response,
              'header' => $this->curl->response_headers
          );
          $this->log('Result: '. json_encode($result), 'info');
          Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
          return $result;
    }
    
    public function downloadFolder($headers, $userName, $fileName,$syncRevisionId,$filePath,$gatewayName){
        //$this->curl->setTimeout(1200);
        $this->curl->setTimeout(0);
        $url = $this->api->getUrl('downloadFolder', array('userName' => $userName,'fileName'=> $fileName, 'syncRevisionId'=>$syncRevisionId, 'filePath'=>$filePath));
            Model::req($url,$headers,$userName);
            $this->curl->setHeaders($headers);
        $url = $url.'?userName='.$userName.'&fileName='.$fileName.'&filePath='.$filePath.'&gatewayName='.$gatewayName.'&syncRevisionId='.$syncRevisionId.'&isSync=true';
        $this->log("URL : ".$url,"info");
        //$this->setOpt(CURLOPT_RETURNTRANSFER, true);
        $this->curl->get($url);
        //    if($this->curl->http_status_code == 200){
                $result = array(
                    'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                    'body' => $this->curl->response,
                    'header' => $this->curl->response_headers
                );
          /*  }else{
          $result = array(
                    'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
                );
            }*/
        $this->log('result: '.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function deleteFolderNew($headers){
        $url = $this->api->getUrl('deleteFolderNew');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
            );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDeviceDetails($headers){
        $url = $this->api->getUrl('getDeviceDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
        Model::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFailedFiles($headers, $pageNumber, $userName, $deviceName, $deviceUUID){
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/activities/failedfiles?deviceName=".$deviceName."&userName=".$userName."&pageNumber=".$pageNumber."&deviceUUID=".$deviceUUID;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getFailedFilesNavigate($headers, $url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
}
