<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Device;
use Models\Login;
use Models\User;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class LoginController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;
    protected $_codeLength = 6;
    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('login');
        $this->_model = new Login();
        $this->verifyAndCleanItUp();
        if(AMAZON_CHECK == true){
            $this->isFirstCustomer();
        }
    }

    public function isFirstCustomer(){
        $cloudName = $this->_model->isFirstCustomer();
        if($cloudName == 'true'){
            Url::redirect('amazon/create');
        }else{
            $this->session->put('cloudName', $cloudName);
        }
    }

    /**
     * Below method will load login template
     */
    /*public function index(){
        $this->auth->loggedOutCheck();

        $data['title'] = $this->language->get('indexPageName');
        $data['indexPage_message'] = $this->language->get('indexPage_message');
        $data['csrf_token'] = $this->setCSRFToken();
        $data['cloudName'] = $this->session->get('cloudName');

        View::renderTemplate('LoginHeader', $data);
        View::render('login/login', $data);
        View::renderTemplate('LoginFooter', $data);
    }*/
    
    public function index(){
        //$this->auth->loggedOutCheck();
	$this->session->put("newmessage","");
        $this->log("kkkkkkkkkkkkk : ".\Helpers\Url::basePath(),"info");
        $result = $this->_model->getEnvDetails();
        $this->log("AAAAA : ".json_encode($result['response_headers']->container['aadEnabled']),"info");
        $aadEnabled = 'false';
        if($result['response_headers']->container['Backup_Enabled'] == 'true'){
                $this->session->put('backup_enabled', 'true');
        }else{
                $this->session->put('backup_enabled', 'false');
        }
        if($result['response_headers']->container['Sync_Enabled'] == 'true'){
                $this->session->put('sync_enabled', 'true');
        }else{
                $this->session->put('sync_enabled', 'false');
        }
        if($result['response_headers']->container['OneDrive_Backup_Enabled'] == 'true'){
                $this->session->put('one_drive_backup_enabled', 'true');
        }else{
                $this->session->put('one_drive_backup_enabled', 'false');
        }
	if($result['response_headers']->container['Exchange_Backup_Enabled'] == 'true'){
                $this->session->put('exchange_backup_enabled', 'true');
        }else{
                $this->session->put('exchange_backup_enabled', 'false');
        }
	if($result['response_headers']->container['isSQLBkpEnabled'] == 'true'){
		$this->session->put('isSQLBkpEnabled', 'true');
	}else{
		$this->session->put('isSQLBkpEnabled', 'false');
	}
	if($result['response_headers']->container['clamAVScanEnabled'] == 'true'){
                $this->session->put('isAVScanEnabled', 'true');
        }else{
                $this->session->put('isAVScanEnabled', 'false');
        }
	if($result['response_headers']->container['graphApiEnabled'] == 'true'){
                $this->session->put('graphApiEnabled', 'true');
        }else{
                $this->session->put('graphApiEnabled', 'false');
        }
	if($result['response_headers']->container['graphAADEnabled'] == 'true'){
                $this->session->put('graphAADEnabled', 'true');
        }else{
                $this->session->put('graphAADEnabled', 'false');
        }
	if($result['response_headers']->container['multiTenantAADEnabled'] == 'true'){
                $this->session->put('multiTenantAADEnabled', 'true');
        }else{
                $this->session->put('multiTenantAADEnabled', 'false');
        }
	$data['aadEnabledEnv'] = $result['response_headers']->container['aadEnabled'];
        if($result['response_headers']->container['aadEnabled'] == 'true'){
                if($result['status'] == 435){
                    $this->log("inside 435......","info");
                        $aadEnabled = 'true';
                        $clientId = $result['body']->{'AADCredentialsElement'}->{'clientId'};
                        $tenentId = $result['body']->{'AADCredentialsElement'}->{'tenentId'};
                        //$portalRedirectURI = $result['body']->{'AADCredentialsElement'}->{'portalRedirectURI'};
			if(useLocalPackage != true){
                        	$portalRedirectURI = "https://api-app.parablu.com/sso.php";
				$SSO_URL = "https://api-app.parablu.com/callSSO.php";
                        }else{
                                $portalRedirectURI = LOCAL_IP."/app/sso.php";
				$SSO_URL = LOCAL_IP."/app/callSSO.php";
                        }
			if($result['response_headers']->container['multiTenantAADEnabled'] == 'true'){
                                if(useLocalPackage != true){
                                        $SSO_URL = "https://api-app.parablu.com/callSSOMultiTenant.php";
                                }else{
                                        $SSO_URL = LOCAL_IP."/app/callSSOMultiTenant.php";
                                }
                        }
                        if(!$_GET['code']){
                            if($result['body']->{'AADCredentialsElement'}->{'loginMode'} == 'Microsoft'){
				//header("Location: ".SSO_URL."?tenentId=".$tenentId."&clientId=".$clientId."&portalRedirectURI=".$portalRedirectURI."&sourceURI=".\Helpers\Url::basePath()."login");
				$data['SSO'] = $SSO_URL."?tenentId=".$tenentId."&clientId=".$clientId."&portalRedirectURI=".$portalRedirectURI."&sourceURI=".\Helpers\Url::basePath()."login";				    
			    }else{
				//header("Location: ".OKTA_URL."?tenentId=".$tenentId."&clientId=".$clientId."&portalRedirectURI=".$portalRedirectURI."&sourceURI=".\Helpers\Url::basePath()."login");
				$data['SSO'] = 	OKTA_URL."?tenentId=".$tenentId."&clientId=".$clientId."&portalRedirectURI=".$portalRedirectURI."&sourceURI=".\Helpers\Url::basePath()."login";
			    }
                        }
			$this->log("AAD Portal SSO is enabled","info");
                        $data['title'] = $this->language->get('indexPageName');
                        $data['indexPage_message'] = $this->language->get('indexPage_message');
                        $data['csrf_token'] = $this->setCSRFToken();
                        $data['cloudName'] = $this->session->get('cloudName');
                        $data['aadEnabled'] = $aadEnabled;
                        View::renderTemplate('LoginHeader', $data);
                        View::render('login/ssoLogin', $data);
                        View::renderTemplate('LoginFooter', $data);

                            if(!empty($_GET['code'])){
                                $this->authenticate1();
                                $this->log("after calling auth1","info");
                                View::renderTemplate('header', $data);
                                View::renderTemplate('navigation', $data);
                                View::render('index/index', $data);
                                View::renderTemplate('footer', $data);
                            }
                }else{
                    //$this->auth->loggedOutCheck();
                    $data['title'] = $this->language->get('indexPageName');
                    $data['indexPage_message'] = $this->language->get('indexPage_message');
                    $data['csrf_token'] = $this->setCSRFToken();
                    $data['cloudName'] = $this->session->get('cloudName');
                    $data['aadEnabled'] = $aadEnabled;
                    View::renderTemplate('LoginHeader', $data);
                    View::render('login/login', $data);
                    View::renderTemplate('LoginFooter', $data);

                }
        }else{
            //$this->auth->loggedOutCheck();
            $data['title'] = $this->language->get('indexPageName');
            $data['indexPage_message'] = $this->language->get('indexPage_message');
            $data['csrf_token'] = $this->setCSRFToken();
            $data['cloudName'] = $this->session->get('cloudName');
            $data['aadEnabled'] = $aadEnabled;
            View::renderTemplate('LoginHeader', $data);
            View::render('login/login', $data);
            View::renderTemplate('LoginFooter', $data);

        }
    }

    public function indexSSO(){
        //$this->auth->loggedOutCheck();
	$result = $this->_model->getEnvDetails();
        $this->log("AAAAA : ".json_encode($result['response_headers']->container['aadEnabled']),"info");
        $aadEnabled = 'false';
        if($result['response_headers']->container['Backup_Enabled'] == 'true'){
                $this->session->put('backup_enabled', 'true');
        }else{
                $this->session->put('backup_enabled', 'false');
        }
        if($result['response_headers']->container['Sync_Enabled'] == 'true'){
                $this->session->put('sync_enabled', 'true');
        }else{
                $this->session->put('sync_enabled', 'false');
        }
        if($result['response_headers']->container['OneDrive_Backup_Enabled'] == 'true'){
                $this->session->put('one_drive_backup_enabled', 'true');
        }else{
                $this->session->put('one_drive_backup_enabled', 'false');
        }
	if($result['response_headers']->container['Exchange_Backup_Enabled'] == 'true'){
                $this->session->put('exchange_backup_enabled', 'true');
        }else{
                $this->session->put('exchange_backup_enabled', 'false');
        }
	if($result['response_headers']->container['isSQLBkpEnabled'] == 'true'){
		$this->session->put('isSQLBkpEnabled', 'true');
	}else{
		$this->session->put('isSQLBkpEnabled', 'false');
	}
	if($result['response_headers']->container['clamAVScanEnabled'] == 'true'){
                $this->session->put('isAVScanEnabled', 'true');
        }else{
                $this->session->put('isAVScanEnabled', 'false');
        }
	if($result['response_headers']->container['graphApiEnabled'] == 'true'){
                $this->session->put('graphApiEnabled', 'true');
        }else{
                $this->session->put('graphApiEnabled', 'false');
        }
	if($result['response_headers']->container['graphAADEnabled'] == 'true'){
                $this->session->put('graphAADEnabled', 'true');
        }else{
                $this->session->put('graphAADEnabled', 'false');
        }
	if($result['response_headers']->container['multiTenantAADEnabled'] == 'true'){
                $this->session->put('multiTenantAADEnabled', 'true');
        }else{
                $this->session->put('multiTenantAADEnabled', 'false');
        }
	$data['aadEnabledEnv'] = $result['response_headers']->container['aadEnabled'];
        $data['title'] = $this->language->get('indexPageName');
        $data['indexPage_message'] = $this->language->get('indexPage_message');
        $data['csrf_token'] = $this->setCSRFToken();
        $data['cloudName'] = $this->session->get('cloudName');

        View::renderTemplate('LoginHeader', $data);
        View::render('login/adminLogin', $data);
        View::renderTemplate('LoginFooter', $data);
    }
    
    public function authenticate1(){
    	$this->log("*******inside authenticate1 function*******".$_GET['code'],"info");
	    	if(useLocalPackage != true){
                   $options = array(
                    'userName' => '',
                    'password' => '',
                    'aadAuthCode' => $_GET['code'],
                    'clientType'     => 'PORTAL',
                    'redirectHost' => 'https://api-app.parablu.com/sso.php',
                    ); 
                }else{
                    $options = array(
                    'userName' => '',
                    'password' => '',
                    'aadAuthCode' => $_GET['code'],
                    'clientType'     => 'PORTAL',
                    'redirectHost' => LOCAL_IP.'/app/sso.php',
                    );  
                }
                $result = $this->_model->authenticate($options);
	    	$this->log("authenticate1 options : ".json_encode($options), 'info');
	    	$this->log("After authenticate1111 result____".json_encode($result),"info");
                $this->log(json_encode($options), 'info');
                switch ($result['status']) {
                    case (200):
                        if($result['body']->userElement->{'backupEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == false && $result['body']->userElement->{'exchangeBkpEnabled'} == false && $result['body']->userElement->{'syncWebAccessEnabled'} == false && $result['body']->userElement->{'syncEnabled'} == false){
				$this->session->put('newmessage','License disabled');
				$this->log("*************License disabled*************","info");
                                header('Location: '.Url::basePath('ssoLogin'));
                                $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'License has been disabled for this account please contact your administrator'
                            );
                            //echo json_encode($result);
                            exit();
                        }
                        /*if($result['body']->userElement->{'serverBackupEnabled'} == false && $result['body']->userElement->{'syncWebAccessEnabled'} == false && $result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'backupEnabled'} == false){
                            $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'Both Sync and Backup has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }elseif($result['body']->userElement->{'backupEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == false){
                            $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'Both Backup and Office365 has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }*/
                        $this->session->refresh();
                        $this->session->put('token', $result['headers']->container['token']);
                        $this->session->put('firstLogin1', $result['headers']->container['firstLogin']);
                        $this->session->put('cloudName', $result['headers']->container['cloudName']);
                        $this->session->put('connectedClients', $result['headers']->container['connectedClients']);
                        $this->session->put('isLdapEnabled', $result['headers']->container['isLdapEnabled']);
                        $this->session->put('isAADEnabled', $result['headers']->container['isAADEnabled']);
                        foreach($result['body']->userElement as $key => $value){
                            $this->session->put($key, $value);
                            $this->log('details: '.$key.' - '.$value, 'info');
			    if($key == 'emailId'){
				$this->session->put('emailId', base64_decode($value));
                            }
			    if($key == 'displayName'){
				$this->session->put('displayName', base64_decode($value));
                            }
                       }
		       	$this->log("*************After details listing*************","info");
			if($result['body']->userElement->{'syncWebAccessEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false){
                            $this->session->put('syncEnabled', true);
                        }
                        $redirectUrl = DIR;
			if($result['body']->userElement->{'backupPolicyElement'}->{'downloadAgent'} == true || $result['body']->userElement->{'syncPolicyElement'}->{'downloadAgent'} == true ){
                		$this->session->put('isDownloadAgent','true');
            		}else{
                		$this->session->put('isDownloadAgent','false');
            		}
            		if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
				$this->log("*************User is either admin or read only admin*************","info");
                		if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false) || ($result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
                                        $redirectUrl = DIR;
                                }
                                else{
                                        //$redirectUrl = 'cloudInfo';
                                        $redirectUrl = DIR;
 				}
                        }else{
				$this->log("*************User is normal user*************","info");
                        	/*if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false) || ($result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
                                        $redirectUrl = 'backup/devices';
                                }
                                else{
                                	//$redirectUrl = 'sync/files';
					$redirectUrl = 'myAccount';
                                }*/
				if($result['body']->userElement->{'backupEnabled'} == true || $result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true ){
                                        $redirectUrl = 'backup/devices';
                                }else{
                                        $redirectUrl = 'sync/files';
                                } 
                        }
			$this->log("*************Redirect URL*************".$redirectUrl,"info");
                        $this->session->put('loggedIn', true);
                        $this->clearCsrfToken();
                        if(DISABLE_BLUVAULT == true){
				$this->log("*************Bluvault is disabled in config file*************","info");
                        	if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
                        		//$re = 'cloudInfo';
                        		$re = 'myAccount';
                        	}else if($result['body']->userElement->{'admin'} == false && $result['body']->userElement->{'readOnlyAdmin'} == false){
                        		$re = 'myAccount';
                        	}
                        	$result = array(
                            		'result' => 'success',
                            		'asdadsasd' => $result['body'],
                            		'redirectUrl' => $re
                        	);
                        }else{
				$this->log("*************Bluvault not disabled in config file*************","info");
                            	if($result['body']->userElement->{'guest'} == '1'){
                            		$redirectUrl = 'share/filesSharedWithMe';
                            	}
                            	$result = array(
                                	'result' => 'success',
                                	'asdadsasd' => $result['body'],
                                	'redirectUrl' => !empty($this->session->get('redirectUrl')) ? $this->session->get('redirectUrl') : $redirectUrl
                            	);
                        }
			$this->log("*************just before redirection to dashboard*************","info");
                        header('Location: '.Url::basePath('dashboard'));
                        echo json_encode($result);
                        exit();
                        $this->session->put('loggedIn', true);
                        $this->clearCsrfToken();
                        $result = array(
                            'result' => 'success',
                            'asdadsasd' => $result['body'],
                            'redirectUrl' => !empty($this->session->get('redirectUrl')) ? $this->session->get('redirectUrl') : $redirectUrl
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    case (401):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('401')
                        );
                        //echo json_encode($result);
                        exit();
                    case (416):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('416')
                        );
                        //echo json_encode($result);
                        exit();
                    case (452):
                         $result = array(
                             'result' => 'fail',
                             'msg' => 'Web based login disabled for the user'
                         );
 //                        echo json_encode($result);
                         exit();
                    case (417):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('417')
                        );
                        //echo json_encode($result);
                        exit();
                    case (403):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        //echo json_encode($result);
                        exit();
                    case (424):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('424')
                        );
                        //echo json_encode($result);
                        exit();
                    case (440):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('440')
                        );
                        //echo json_encode($result);
                        exit();
                    case (441):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('441')
                        );
                        //echo json_encode($result);
                        exit();
                    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('400')
                        );
                        //echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result['status'],
                            'msg' => $this->language->get('default')
                            );
                        echo json_encode($result);
                        exit();
                }
    }



    public function sleep(){
        $this->auth->loginCheck();
        $this->session->put('token', null);
        $data['title'] = $this->language->get('sleep');
        $data['indexPage_message'] = $this->language->get('sleep_message');
        $data['csrf_token'] = $this->setCSRFToken();
        $data['userName'] = $this->session->get('userName');
	$this->log("........SESSION LOCKED DETECTED........","info");
        View::renderTemplate('LoginHeader', $data);
        View::render('login/sleep', $data);
        View::renderTemplate('LoginFooter', $data);
    }
	
    public function success(){
        $this->auth->loggedOutCheck();
        View::renderTemplate('LoginHeader', $data);
        View::render('login/success', $data);
        View::renderTemplate('LoginFooter', $data);
    }
	
    public function ssoLogin(){
        $this->auth->loggedOutCheck();
	if($this->session->get('newmessage') != ''){
		$data['newmessage'] = 'License has been disabled for this account please contact your administrator';
        }else{
        	$data['newmessage'] = '';
        }
        View::renderTemplate('LoginHeader', $data);
        View::render('login/ssoLogin', $data);
        View::renderTemplate('LoginFooter', $data);
    }

    /**
     * Retrieves the rules from Helpers/Rules
     * Retrieves the filters from Helpers/Rules
     */
    public function authenticate(){
        if(!empty($_POST)){
            $rules = array(
                'username'    => 'required|max_len,100|min_len,3',
                'password'    => 'required'
            );
            $filters = array(
                'username' 	  => 'trim|sanitize_string',
                'password'	  => 'trim|base64_encode',
                'email'    	  => 'trim|sanitize_email'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);
            if($validate === true){

                $options = array(
                    'userName'       => htmlspecialchars_decode($_POST['username'],ENT_QUOTES),
                    'password'       => $this->getEncryptPassword($_POST['password']),
		    'clientType'     => 'PORTAL'
                );
            //newwwwwww start
            /*if (enableRecaptcha == true && googleAuthenticator == true){
            $this->log("BOTH TRUE","info");
                $this->log("g-recaptcha-response : ".$_POST['g-recaptcha-response'],"info");
                    $googleRecaptcha = $this->_model->recaptcha($_POST['g-recaptcha-response']);
                    $this->log("googleRecaptcha00000000 : ".json_encode($googleRecaptcha),"info");
                    $this->log("SUCCESS : ".$googleRecaptcha['body']->success,"info");
                    if($googleRecaptcha['body']->success == ''){
                        $result = array(
                                        'result' => 'fail',
                                        'msg' => 'captcha failed'
                                    );
                                    echo json_encode($result);
                                    exit();
            
                    }
            
                    $secret = $_SESSION['secret2way'];
                            $this->log("secret2 : ".$secret,"info");
                            $checkResult = $this->verifyCode($secret, $_POST['code'], 2);
                            $this->log("resulttttttt : ".json_encode($checkResult),"info");
            		$this->log("resulttttttt : ".$checkResult,"info");
            
                            if(!$checkResult){
                                $result = array(
                                            'result' => 'fail',
                                            'asdasd' => $result,
                                            'msg' => 'Google Authentication Code verification failed'
                                        );
                                        echo json_encode($result);
                                        exit();
                            }
                    $result = $this->_model->authenticate($options);
            
            }
            else if(enableRecaptcha == true && googleAuthenticator == false){
            $this->log("RE TRUE AUTH false","info");
                $this->log("g-recaptcha-response : ".$_POST['g-recaptcha-response'],"info");
                    $googleRecaptcha = $this->_model->recaptcha($_POST['g-recaptcha-response']);
                    $this->log("googleRecaptcha00000000 : ".json_encode($googleRecaptcha),"info");
                    $this->log("SUCCESS : ".$googleRecaptcha['body']->success,"info");
                    if($googleRecaptcha['body']->success != ''){
                            $result = $this->_model->authenticate($options);
                    }else{
                            $result = array(
                                        'result' => 'fail',
                                        'msg' => 'captcha failed'
                                    );
                                    echo json_encode($result);
                                    exit();
                    }
            }
            else if(enableRecaptcha == false && googleAuthenticator == true){
            $this->log("Re false Auth TRUE","info");
                $secret = $_SESSION['secret2way'];
                            $this->log("secret2 : ".$secret,"info");
                            $checkResult = $this->verifyCode($secret, $_POST['code'], 2);
                            $this->log("resulttttttt : ".json_encode($checkResult),"info");
                            if($checkResult){
                                    $result = $this->_model->authenticate($options);
                            }else{
                                    $result = array(
                                            'result' => 'fail',
                                            'asdasd' => $result,
                                            'msg' => 'Google Authentication Code verification failed'
                                        );
                                        echo json_encode($result);
                                        exit();
                            }
            }
            else{
            $this->log("BOTH FALSE","info");
                $result = $this->_model->authenticate($options);
            }*/
            //newwwwww end
                $result = $this->_model->authenticate($options);
                $this->log(json_encode($options), 'info');
                switch ($result['status']) {
                    case (200):
                        if($result['body']->userElement->{'backupEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == false && $result['body']->userElement->{'exchangeBkpEnabled'} == false && $result['body']->userElement->{'syncWebAccessEnabled'} == false && $result['body']->userElement->{'syncEnabled'} == false){
                                $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'License has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }
                        /*if($result['body']->userElement->{'serverBackupEnabled'} == false && $result['body']->userElement->{'syncWebAccessEnabled'} == false && $result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'backupEnabled'} == false){
                            $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'Both Sync and Backup has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }elseif($result['body']->userElement->{'backupEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == false){
                            $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'Both Backup and Office365 has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }*/
                        $this->session->refresh();
                        $this->session->put('token', $result['headers']->container['token']);
                        $this->session->put('firstLogin1', $result['headers']->container['firstLogin']);
                        $this->session->put('cloudName', $result['headers']->container['cloudName']);
                        $this->session->put('connectedClients', $result['headers']->container['connectedClients']);
                        $this->session->put('isLdapEnabled', $result['headers']->container['isLdapEnabled']);
                        $this->session->put('isAADEnabled', $result['headers']->container['isAADEnabled']);
                        foreach($result['body']->userElement as $key => $value){
                            $this->session->put($key, $value);
                            $this->log('details: '.$key.' - '.$value, 'info');
			    if($key == 'emailId'){
                                //$this->log('decodedddddddddddddddd: '.$key.' - '.base64_decode($value), 'info');
				$this->session->put('emailId', base64_decode($value));
                            }
			    if($key == 'displayName'){
                                //$this->log('decodedddddddddddddddd: '.$key.' - '.base64_decode($value), 'info');
				$this->session->put('displayName', base64_decode($value));
                            }
                        }
                        if($result['body']->userElement->{'syncWebAccessEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false){
                            $this->session->put('syncEnabled', true);
                        }
//                        $this->session->put('syncEnabled', false);
//                        $this->session->put('backupEnabled', false);
//                        $this->session->put('serverBackupEnabled', true);
                        $redirectUrl = DIR;
      /*if(LOGIN_REDIRECT_FILES_PAGE == true && $result['body']->userElement->{'syncEnabled'} == true || $result['body']->userElement->{'syncWebAccessEnabled'} == true){
                            $redirectUrl = 'sync/files';
                        }*/
/*                        if($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'backupEnabled'} == true ||
$result['body']->userElement->{'backupEnabled'} == true){
                            $redirectUrl = DIR;
                        }
                        elseif($result['body']->userElement->{'syncEnabled'} == true){
if($result['body']->userElement->{'admin'} == false && $result['body']->userElement->{'readOnlyAdmin'} == false){
$redirectUrl = 'myAccount';
}else {
                            $redirectUrl = 'cloudInfo';
}
                        }
*/
            if($result['body']->userElement->{'backupPolicyElement'}->{'downloadAgent'} == true || $result['body']->userElement->{'syncPolicyElement'}->{'downloadAgent'} == true ){
                $this->session->put('isDownloadAgent','true');
            }else{
                $this->session->put('isDownloadAgent','false');
            }
			if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
				if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false) || ($result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
					$redirectUrl = DIR;
				}else{
					//$redirectUrl = 'cloudInfo';
					$redirectUrl = DIR;
				}
			}else{
				/*if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false) || ($result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
					$redirectUrl = 'backup/devices';
				}else{
					//$redirectUrl = 'sync/files';
					$redirectUrl = 'myAccount';
				}
				if(($result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'backupEnabled'} == true) ||  ($result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == false && $result['body']->userElement->{'onedriveBkpEnabled'} == true) || ($result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
					$redirectUrl = 'backup/devices';
				}else if(($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'backupEnabled'} == false) || ($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'onedriveBkpEnabled'} == false) || ($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'exchangeBkpEnabled'} == false)){
					$redirectUrl = 'sync/files';
				}else if(($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'backupEnabled'} == true) || ($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'onedriveBkpEnabled'} == true) || ($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'exchangeBkpEnabled'} == true)){
					$redirectUrl = 'myAccount';
				}*/
				if($result['body']->userElement->{'backupEnabled'} == true || $result['body']->userElement->{'onedriveBkpEnabled'} == true || $result['body']->userElement->{'exchangeBkpEnabled'} == true ){
                                        $redirectUrl = 'backup/devices';
                                }else{
                                        $redirectUrl = 'sync/files';
                                }
			}
			$this->session->put('redirect123',$redirectUrl);
                        //$this->session->put('loggedIn', true);
                        //$this->clearCsrfToken();
			if(googleAuthenticator != true){
				$this->session->put('loggedIn', true);
			}
                        $this->clearCsrfToken();
			if(googleAuthenticator == true && $result['body']->userElement->{'localUser'} == true){
				if($this->session->get('firstLogin1') == "false"){
					$redirectUrl = 'mfa';
					$secret = $this->session->get('googleSecretKey');
                                        $this->session->put('loginSecretKey',$secret);
				}else{
					$this->session->put('loggedIn', true);
					$redirectUrl = $redirectUrl;
				}				
			}
			if(enableRecaptcha == true && $result['body']->userElement->{'localUser'} == true){
				$redirectUrl = 'captcha';
			}
			$this->session->put('redirectUrl', $redirectUrl);
                if(DISABLE_BLUVAULT == true){
                    if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
                        //$re = 'cloudInfo';
                        $re = 'myAccount';
                    }else if($result['body']->userElement->{'admin'} == false && $result['body']->userElement->{'readOnlyAdmin'} == false){
                        $re = 'myAccount';
                    }
                    $result = array(
                        'result' => 'success',
                        'asdadsasd' => $result['body'],
                        'redirectUrl' => $re
                    );
                } else {
                    /*if($result['body']->userElement->{'guest'} == '1'){
                    $redirectUrl = 'share/filesSharedWithMe';
                    }*/
                        $result = array(
                            'result' => 'success',
                            'asdadsasd' => $result['body'],
			    //'redirectUrl' => $redirectUrl
                            'redirectUrl' => !empty($this->session->get('redirectUrl')) ? $this->session->get('redirectUrl') : $redirectUrl
                        );
                }
                        echo json_encode($result);
                        exit();
                    case (401):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('401')
                        );
                        echo json_encode($result);
                        exit();
                    case (452):
                         $result = array(
                             'result' => 'fail',
                             'msg' => 'Web based login disabled for the user'
                         );
                        echo json_encode($result);
                         exit();
                    case (416):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('416')
                        );
                        echo json_encode($result);
                        exit();
                    case (417):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('417')
                        );
                        echo json_encode($result);
                        exit();
                    case (403):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        echo json_encode($result);
                        exit();
                    case (424):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('424')
                        );
                        echo json_encode($result);
                        exit();
                    case (440):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('440')
                        );
                        echo json_encode($result);
                        exit();
                    case (441):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('441')
                        );
                        echo json_encode($result);
                        exit();
                    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('400')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result['status'],
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }
	
    public function mfa(){
            $data['title'] = $this->language->get('indexPageName');
            $data['indexPage_message'] = $this->language->get('indexPage_message');
	    $data['csrf_token'] = $this->setCSRFToken();
            $data['cloudName'] = $this->session->get('cloudName');
	    $data['secret'] = $this->session->get('loginSecretKey');
            $data['userName'] = $this->session->get('userName');
            View::renderTemplate('LoginHeader', $data);
            View::render('login/mfa', $data);
            View::renderTemplate('LoginFooter', $data);
    }

    public function mfaAuthenticate(){
        $this->log("inside mfaAuthenticate","info");
                $secret = $this->session->get('loginSecretKey');
                            $this->log("secret2 : ".$secret,"info");
                            $checkResult = $this->verifyCode($_POST['secret11'], $_POST['code'], 2);
                            $this->log("resulttttttt : ".json_encode($checkResult),"info");
			    if($checkResult){
				$this->session->put('loggedIn', true);				    
                                    //$result = $this->_model->authenticate($options);
                                $result = array(
                            		'result' => 'success',
					'redirectUrl' =>$this->session->get('redirect123')
                            		//'redirectUrl' => DIR
                    		);
                                echo json_encode($result);
                        	exit();
                            }else{
                                    $result = array(
                                            'result' => 'fail',
                                            'asdasd' => $result,
                                            'msg' => 'Multi-factor Authentication Code verification failed'
                                            );
                                    echo json_encode($result);
                                    exit();
				    }
    }
	
    public function captcha(){
            $data['title'] = $this->language->get('indexPageName');
            $data['indexPage_message'] = $this->language->get('indexPage_message');
            $data['csrf_token'] = $this->setCSRFToken();
            $data['cloudName'] = $this->session->get('cloudName');
            $data['userName'] = $this->session->get('userName');
            View::renderTemplate('LoginHeader', $data);
            View::render('login/captcha', $data);
            View::renderTemplate('LoginFooter', $data);
    }

    public function captchaAuthenticate(){
        $this->log("inside captcha","info");
                $this->log("g-recaptcha-response : ".$_POST['g-recaptcha-response'],"info");
                    $googleRecaptcha = $this->_model->recaptcha($_POST['g-recaptcha-response']);
                    $this->log("googleRecaptcha00000000 : ".json_encode($googleRecaptcha),"info");
                    $this->log("SUCCESS : ".$googleRecaptcha['body']->success,"info");
                    if($googleRecaptcha['body']->success != ''){
                      $result = array(
                            'result' => 'success',
			    'redirectUrl' =>$this->session->get('redirect123')
                            //'redirectUrl' => DIR
                      );
                                    echo json_encode($result);
                        exit();
                    }else{
                            $result = array(
                                        'result' => 'fail',
                                        'msg' => 'captcha failed'
                                    );
                            echo json_encode($result);
                            exit();
                    }
    }

    public function authFromAgent(){
        $this->cleanSession();
        $userName 		= urldecode($_GET['u']);
        $cloudName 		= htmlentities($_GET['c']);
        $token 			= htmlentities($_GET['t']);
        $urlRedirect 		= htmlentities($_GET['url']);
        $id 			= htmlentities($_GET['id']);

        if(!empty($userName) && !empty($cloudName) && !empty($token)){
            $data['title'] = $this->language->get('Logging in user '.$userName);
            $data['message'] = $this->language->get('from Agent');

            View::renderTemplate('LoginHeader', $data);
            View::render('login/agentLogin', $data);
            View::renderTemplate('LoginFooter', $data);
            
            $result = $this->_model->getEnvDetails();

            if($result['response_headers']->container['Backup_Enabled'] == 'true'){
                    $this->session->put('backup_enabled', 'true');
            }else{
                    $this->session->put('backup_enabled', 'false');
            }
            if($result['response_headers']->container['Sync_Enabled'] == 'true'){
                    $this->session->put('sync_enabled', 'true');
            }else{
                    $this->session->put('sync_enabled', 'false');
            }
            if($result['response_headers']->container['OneDrive_Backup_Enabled'] == 'true'){
                    $this->session->put('one_drive_backup_enabled', 'true');
            }else{
                    $this->session->put('one_drive_backup_enabled', 'false');
            }
	    if($result['response_headers']->container['Exchange_Backup_Enabled'] == 'true'){
                $this->session->put('exchange_backup_enabled', 'true');
            }else{
                $this->session->put('exchange_backup_enabled', 'false');
            }
	    if($result['response_headers']->container['graphAADEnabled'] == 'true'){
                $this->session->put('graphAADEnabled', 'true');
	    }else{
                $this->session->put('graphAADEnabled', 'false');
	    }
	    if($result['response_headers']->container['multiTenantAADEnabled'] == 'true'){
                $this->session->put('multiTenantAADEnabled', 'true');
	    }else{
                $this->session->put('multiTenantAADEnabled', 'false');
	    }
	    $headersSupport = array(
            	'Content-Type'      => 'application/json',
            	'token'             => $token
    	    );
            $cloudProperties = $this->_model->getCloudProperties($headersSupport);
            $showSupportPage = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSupportPage'};
            $this->session->put('showSupportPage',$showSupportPage);

            $result = $this->authenticateFromAgent($userName, $token, $cloudName);

            switch ($result['status']) {
                case (200):

                    if($urlRedirect == 'mydevices'){
                        Url::redirect('backup/devices');
                        exit();
                    }elseif($urlRedirect == 'mybackup'){
                        $headers = array(
                            'Content-Type' => 'application/json',
                            'token'     => $this->session->get('token'),
                            'deviceUUID' => $id
                        );
                        $result = $this->_model->getDeviceDetails($headers);
                        $this->log('loginDetails '. json_encode($result), 'info');
                        if (strpos(strtolower((string)$result['body']->{'BSDeviceInfoElement'}->{'osType'}), 'windows') === false) {
                            $osType = 'mac';
                        }else{
                            $osType = 'windows';
                        }
                        $deviceName = (string)$result['body']->{'BSDeviceInfoElement'}->{'deviceName'};
                        Url::redirect('user/device/policyInfo/'.base64_encode($userName).'/'.$id.'/'.$osType.'?deviceName='.$deviceName);
                        exit();
                    }elseif($urlRedirect == 'files'){
                        if(!empty($_GET['param'])){
                            $this->session->put('syncFilePath', $_GET['param']);
                        }else{
                            $this->session->put('syncFilePath', null);
                        }
                        Url::redirect('sync/files');
                        exit();
                    }elseif($urlRedirect == 'search'){
                        $_SESSION['search'] = 'enabled';
                        Url::redirect('dashboard');
                        exit();
                    }elseif($urlRedirect == 'failedFiles'){
                            $deviceName = urldecode($_GET['action']);
                            Url:: redirect('sync/failedFiles/'.$userName.'/'.$deviceName.'/'.$id);
                            exit();
                    }elseif($urlRedirect == 'settings'){
                        $_SESSION['search'] = 'enabled';
                        Url::redirect('user/settings/'.base64_encode($userName));
                        exit();
                    }elseif($urlRedirect == 'filesrevision'){
                        $paths = explode('/', $_GET['param']);
                        array_pop($paths);
                        $path = implode('/', $paths);
                        $this->session->put('syncFilePath', $path);
                        $_SESSION['openFileRevision'] = $_GET['param'];
                        Url::redirect('sync/files');
                        exit();
                    }else{
                        Url::redirect('dashboard');
                        exit();
                    }
                    break;
                case (421):
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('401');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;

                case (401):
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('401U');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
                case (416):

                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('416');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
                default:
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('default');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
            }

        }else{
            header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

            $data['title'] = '404';
            $data['error'] = "Oops! Page not found..";
            $data['message'] = "Some Parameters passed from your agent was missing, please trying connecting again if you are still facing issues, contact your administrator. Alternatively use your credentials to login through portal directly.";

            View::renderTemplate('header', $data);
            View::render('error/404', $data);
            View::renderTemplate('footer', $data);
        }

    }

    public function authenticateFromAgent($userName, $token, $cloudName){

        $headers = array(
            'userName' => $userName,
            'token' => $token
        );

        $result = $this->_model->authFromAgent($headers);

        if($result['status'] == 200 || $result['status'] == 202){
            $userHeaders = array(
                'token' => $result['headers']->{'container'}['token']
            );
	    $this->session->put('isLdapEnabled', $result['headers']->container['isLdapEnabled']);
            $this->session->put('isAADEnabled', $result['headers']->container['isAADEnabled']);
            $user = new User();
	    $userName = base64_encode($userName);
            $userResult = $user->getUserDetails($userHeaders, $userName);
            $this->log('USer Details: '. json_encode($userResult), 'info');
            if($userResult['status'] == 200){
                $userDetails = array(
                    'token' => $result['headers']->{'container'}['token'],
                    'firstLogin' => (string)$userResult['body']->{'is-first-login'},
                    'cloudName' => $cloudName,
                    'connectedClients' => '',
                    'userId' => (string)$userResult['body']->{'user-id'},
                    'userName' => (string)$userResult['body']->{'user-name'},
                    'passwdHash' => (string)$userResult['body']->{'password-hash'},
                    'emailId' => (string)$userResult['body']->{'email-id'},
                    'securityRecoveryKey' => (string)$userResult['body']->{'recovery-key'},
                    'active' => (string)$userResult['body']->{'is-active'},
                    'admin' => (string)$userResult['body']->{'is-admin'},
                    'readOnlyAdmin' => (string)$userResult['body']->{'is-readonly-admin'},
                    'lastModifiedTimestamp' => (string)$userResult['body']->{'last-modified-timestamp'},
                    'miniCloudElementList' => (string)$userResult['body']->{'mini-clouds'},
                    'syncEnabled' => (string)$userResult['body']->{'sync-enabled'},
                    'backupEnabled' => (string)$userResult['body']->{'backup-enabled'},
                    'serverBackupEnabled' => (string)$userResult['body']->{'server-backup-enabled'},
                    'storageSelected' => (string)$userResult['body']->{'storage-selected'},
                    'externalStorageAuthorized' => (string)$userResult['body']->{'externalstorage-authorized'},
                    'shareEnabled' => (string)$userResult['body']->{'share-enabled'},
                    'policyName' => (string)$userResult['body']->{'policy-name'},
		    'odbPolicyName' => (string)$userResult['body']->{'odbPolicyName'},
                    'migrationToolEnabled' => (string)$userResult['body']->{'migrationtool-enabled'},
                    'supportEnabled' => (string)$userResult['body']->{'support-enabled'},
                    'pmsEnabled' => (string)$userResult['body']->{'pms-enabled'},
                    'reportEnabled' => (string)$userResult['body']->{'report-enabled'},
                    'azureBlobEnabled' => (string)$userResult['body']->{'is-azureblob-enabled'},
                    'deleted' => (string)$userResult['body']->{'is-deleted'},
                    'ldapEnabled' => (string)$userResult['body']->{'ldap-enabled'}
                );

                $this->session->refresh();

                foreach($userDetails as $key => $value){
                    if($value == 'true'){
                        $value = true;
                    }elseif($value == 'false'){
                        $value = false;
                    }
                    $this->session->put($key, $value);
                }

                $this->session->put('loggedIn', true);
                $this->clearCsrfToken();

                return $userResult;

            }else{
                return $userResult;
            }
        }else{
            return $result;
        }


    }

    /**
     * Define Password Rest title and load template files
     */
    public function passwordReset(){
        $this->auth->loggedOutCheck();

        $data['title'] = $this->language->get('passwordResetPageName');
        $data['passwordReset_message'] = $this->language->get('passwordReset_message');
        $data['csrf_token'] = $this->setCSRFToken();

        View::renderTemplate('LoginHeader', $data);
        View::render('login/passwordReset', $data);
        View::renderTemplate('LoginFooter', $data);
    }

    public function passwordRest(){
        if(!empty($_POST)){
	    if(enableRecaptcha == true){
	    	$this->log("g-recaptcha-response : ".$_POST['g-recaptcha-response'],"info");
	    	$googleRecaptcha = $this->_model->recaptcha($_POST['g-recaptcha-response']);
	    	if($googleRecaptcha['body']->success == ''){
                      $result = array(
                                        'result' => 'fail',
                                        'msg' => 'captcha failed'
                                    );
                            echo json_encode($result);
                            exit();
                    }
	    }
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'userName' => $_POST['userName']
            );
            $result = $this->_model->passwordRest($headers);
            $userName = $result['headers']->{'container'}['userName'];
            switch ($result['status']) {
                case (200):
                    $emailProps = array(
                        'actionOn' => 'User',
                        'action' => 'password-reset',
                        'toAdmins' => 'false',
                        'toUser' => 'true',
                        'actionBy' => $userName,
                        'cloudName' => $_POST['cloudName'],
                        'downloadLink' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$userName.'&cloudname='.$_POST['cloudName']),
                        'recipents' => array(
                            array(
                                'userName' => $userName,
                                'email' => $result['headers']->{'container'}['email']
                            )
                        )
                    );

                    $emailResult = $this->sendMail($emailProps);

                    $result = array(
                        'result' => 'success',
                        'location' => Url::basePath('login'),
                        '$emailProps' => json_encode($emailProps),
                        'emailResult' => json_encode($emailResult),
                        'link' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$_POST['userName'].'&cloudname='.$_POST['cloudName']),
                        'msg' => 'An Email has been sent to your email address please follow the directions to reset your password'
                    );
                    unset($result['$emailProps']);
                    unset($result['emailResult']);
                    unset($result['link']);
                    echo json_encode($result);
                    exit();
                case (622):
                    $emailProps = array(
                        'actionOn' => 'User',
                        'action' => 'password-reset',
                        'toAdmins' => 'false',
                        'actionBy' => $userName,
                        'cloudName' => $_POST['cloudName'],
                        'downloadLink' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$userName.'&cloudname='.$_POST['cloudName']),
                        'recipents' => array(
                            array(
                                'userName' => $userName,
                                'email' => $result['headers']->{'container'}['email']
                            )
                        )
                    );

                    $emailResult = $this->sendMail($emailProps);
                    
                    $result = array(
                        'result' => 'fail',
                        'location' => Url::basePath('login'),
                        '$emailProps' => json_encode($emailProps),
                        'emailResult' => json_encode($emailResult),
                        'link' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$_POST['userName'].'&cloudname='.$_POST['cloudName']),
                        'msg' => 'You are not allowed to reset your password'
                    );
                    unset($result['$emailProps']);
                    unset($result['emailResult']);
                    unset($result['link']);
                    echo json_encode($result);
                    exit();
                case (400):
                    if($result['headers']->{'container'}['ldapuser'] == 'true'){
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'You are not allowed to change your password'
                        );
                    }else if($result['headers']->{'container'}['changepassword'] == 'false'){
                         $result = array(
                             'result' => 'fail',
                             'msg' => 'You are not allowed to reset your password'
                         );
                    }else {
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('400')
                        );
                    }
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result['status'],
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }

    /**
     * Define Password Rest title and load template files
     */
    public function restPassword(){
        $this->auth->loggedOutCheck();
        if(!empty($_GET['tok']) && !empty($_GET['user']) && !empty($_GET['cloudname'])){

            $this->session->put('token', $_GET['tok']);
            $this->session->put('user', $_GET['user']);
            $this->session->put('restCloudName', $_GET['cloudname']);

	if(!empty($_GET['setpassword']))
	{
	    $this->session->put('setpassword', $_GET['setpassword']);
	}

            $headers = array(
                'userName' => $_GET['user'],
                'reset-password-key' => $_GET['tok']
            );
            $url = PARACLOUD_URL.urlencode($_GET['cloudname']).DS.'verify'.DS.'password'.DS.'key';
            $result = $this->_model->verifyPasswordRest($headers, $url);
            $data['showForm'] = ($result['status'] == 200) ? true : false;
	    $data['userName'] = $_GET['user'];
	    if($result['header']->{'container'}['googleSecretkey'] != ''){
		    $data['secret'] = $result['header']->{'container'}['googleSecretkey'];
	    }else{
	    	    $data['secret'] = $this->createSecret();
	    }
            $data['title'] = $this->language->get('passwordResetPageName');
            $data['passwordReset_message'] = $this->language->get('Setting a new <b>Password</b>');
            $data['csrf_token'] = $this->setCSRFToken();

            View::renderTemplate('LoginHeader', $data);
            View::render('login/restPassword', $data);
            View::renderTemplate('LoginFooter', $data);
        }else{
            Url::redirect('404');
        }
    }

    public function updatePassword(){
        if(!empty($_POST['password'])){            
	  if(strlen($_POST['password']) <= 5){
		$response = array(
			'result' => 'fail',
			'msg' => 'Password length validation failed'
		);
		echo json_encode($response);
		exit;
	  }
	  if($this->session->get('setpassword') == "true"){
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'reset-password-key' => $this->session->get('token'),
                'username' => $this->session->get('user'),
                'password' => hash('sha512', $_POST['password']),
		'setpassword' => $this->session->get('setpassword')
            );
	 }else {
	   $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'reset-password-key' => $this->session->get('token'),
                'username' => $this->session->get('user'),
                'password' => hash('sha512', $_POST['password'])
                );
	 }
	    $headers['googleSecretKey'] = $_POST['googleSecretKey'];
            $url = PARACLOUD_URL.$this->session->get('restCloudName').DS.'user/update/password';
            $result = $this->_model->updatePassword($headers, $url);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'location' => Url::basePath('login'),
                        'msg'  => $this->language->get('passwordChanged')
                    );
                    echo json_encode($response);
                    exit;

                case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result['status'],
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }


    /*public function logout(){
        $this->session->forget();
        Url::redirect('login');
    }*/
    public function logout(){
        $this->session->forget();
        unset($_GET['code']);
        //Url::redirect('login');
        Url::redirect('logoutPage');
        unset($_GET['code']);
    }

    public function getEncryptPassword($password){
         $cipher = 'aes-128-cbc';
         $key = md5('a9985ebcae81', $raw_output=true);
 	     $iv_length = openssl_cipher_iv_length($cipher);
 	     $iv = openssl_random_pseudo_bytes($iv_length);
 	     $ciphertext = openssl_encrypt($password, $cipher, $key, OPENSSL_RAW_DATA, $iv);
         $composed = $iv.$ciphertext;
         $composed_encoded = base64_encode($composed);	
         return $composed_encoded;
    }

    public function cleanSession(){
        unset($_GET['code']);
        $this->session->put('token', '');
        $this->session->put('firstLogin', '');
        $this->session->put('firstLogin1', '');
        $this->session->put('cloudName', '');
        $this->session->put('connectedClients', '');
        $this->session->put('userId', '');
        $this->session->put('userName', '');
        $this->session->put('passwdHash', '');
        $this->session->put('emailId', '');
        $this->session->put('securityRecoveryKey', '');
        $this->session->put('active', '');
        $this->session->put('admin', '');
        $this->session->put('readOnlyAdmin', '');
	$this->session->put('isGuest', '');
        $this->session->put('lastModifiedTimestamp', '');
        $this->session->put('miniCloudElementList', '');
        $this->session->put('syncEnabled', '');
        $this->session->put('backupEnabled', '');
        $this->session->put('storageSelected', '');
        $this->session->put('externalStorageAuthorized', '');
        $this->session->put('shareEnabled', '');
        $this->session->put('policyName', '');
        $this->session->put('migrationToolEnabled', '');
        $this->session->put('supportEnabled', '');
        $this->session->put('pmsEnabled', '');
        $this->session->put('reportEnabled', '');
        $this->session->put('azureBlobEnabled', '');
        $this->session->put('deleted', '');
        $this->session->put('ldapEnabled', '');
    }
    
    public function logoutPage(){
        View::renderTemplate('LoginHeader', $data);
        View::render('login/logout', $data);
        View::renderTemplate('LoginFooter', $data);
	if(portalSSOutEnable == true){
            $result = $this->_model->getEnvDetails();
            if($result['response_headers']->container['aadEnabled'] == 'true'){
                if($result['status'] == 435){
                    header("Location: https://login.microsoftonline.com/common/oauth2/logout");
                }
            }
        }
    }



    public function sendMail($emailProps){

        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );

        return $this->_model->sendMail($headers, $emailProps);

    }

/*----------------------------------------*/
//protected $_codeLength = 6;

    /**
     * Create new secret.
     * 16 characters, randomly chosen from the allowed base32 characters.
     *
     * @param int $secretLength
     * @return string
     */
    public function createSecret($secretLength = 16)
    {
        $validChars = $this->_getBase32LookupTable();
        unset($validChars[32]);

        $secret = '';
        for ($i = 0; $i < $secretLength; $i++) {
            $secret .= $validChars[array_rand($validChars)];
        }
        return $secret;
}

    /**
     * Calculate the code, with given secret and point in time
     *
     * @param string $secret
     * @param int|null $timeSlice
     * @return string
     */
    public function getCode($secret, $timeSlice = null)
    {
        if ($timeSlice === null) {
            $timeSlice = floor(time() / 30);
        }

        $secretkey = $this->_base32Decode($secret);

        // Pack time into binary string
$time = chr(0).chr(0).chr(0).chr(0).pack('N*', $timeSlice);
        // Hash it with users secret key
        $hm = hash_hmac('SHA1', $time, $secretkey, true);
        // Use last nipple of result as index/offset
        $offset = ord(substr($hm, -1)) & 0x0F;
        // grab 4 bytes of the result
        $hashpart = substr($hm, $offset, 4);

        // Unpak binary value
        $value = unpack('N', $hashpart);
        $value = $value[1];
        // Only 32 bits
        $value = $value & 0x7FFFFFFF;

        $modulo = pow(10, $this->_codeLength);
        return str_pad($value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT);
    }
/**
     * Get QR-Code URL for image, from google charts
     *
     * @param string $name
     * @param string $secret
     * @param string $title
     * @return string
     */
    public function getQRCodeGoogleUrl($name, $secret, $title = null) {
        $urlencoded = urlencode('otpauth://totp/'.$name.'?secret='.$secret.'');
    if(isset($title)) {
                $urlencoded .= urlencode('&issuer='.urlencode($title));
        }
        return 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl='.$urlencoded.'';
    }
/**
     * Check if the code is correct. This will accept codes starting from $discrepancy*30sec ago to $discrepancy*30sec from now
     *
     * @param string $secret
     * @param string $code
     * @param int $discrepancy This is the allowed time drift in 30 second units (8 means 4 minutes before or after)
     * @param int|null $currentTimeSlice time slice if we want use other that time()
     * @return bool
     */
    public function verifyCode($secret, $code, $discrepancy = 1, $currentTimeSlice = null)
    {
        if ($currentTimeSlice === null) {
            $currentTimeSlice = floor(time() / 30);
        }

        for ($i = -$discrepancy; $i <= $discrepancy; $i++) {
            $calculatedCode = $this->getCode($secret, $currentTimeSlice + $i);
$this->log("CODE : ".json_encode($code),"info");
$this->log("getCODE : ".json_encode($calculatedCode),"info");
            if ($calculatedCode == $code ) {
return true;
            }
        }

        return false;
    }

    /**
     * Set the code length, should be >=6
     *
     * @param int $length
     * @return GoogleAuthenticator
     */
    public function setCodeLength($length)
    {
        $this->_codeLength = $length;
        return $this;
    }
/**
     * Helper class to decode base32
     *
     * @param $secret
     * @return bool|string
     */
    protected function _base32Decode($secret)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();
        $base32charsFlipped = array_flip($base32chars);

        $paddingCharCount = substr_count($secret, $base32chars[32]);
        $allowedValues = array(6, 4, 3, 1, 0);
        if (!in_array($paddingCharCount, $allowedValues)) return false;
        for ($i = 0; $i < 4; $i++){
if ($paddingCharCount == $allowedValues[$i] &&
                substr($secret, -($allowedValues[$i])) != str_repeat($base32chars[32], $allowedValues[$i])) return false;
        }
        $secret = str_replace('=','', $secret);
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i = $i+8) {
            $x = "";
            if (!in_array($secret[$i], $base32chars)) return false;
            for ($j = 0; $j < 8; $j++) {
                $x .= str_pad(base_convert(@$base32charsFlipped[@$secret[$i + $j]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
            $eightBits = str_split($x, 8);
            for ($z = 0; $z < count($eightBits); $z++) {
                $binaryString .= ( ($y = chr(base_convert($eightBits[$z], 2, 10))) || ord($y) == 48 ) ? $y:"";
            }
        }
        return $binaryString;
}

    /**
     * Helper class to encode base32
     *
     * @param string $secret
     * @param bool $padding
     * @return string
     */
    protected function _base32Encode($secret, $padding = true)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();

        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i++) {
$binaryString .= str_pad(base_convert(ord($secret[$i]), 10, 2), 8, '0', STR_PAD_LEFT);
        }
        $fiveBitBinaryArray = str_split($binaryString, 5);
        $base32 = "";
        $i = 0;
        while ($i < count($fiveBitBinaryArray)) {
            $base32 .= $base32chars[base_convert(str_pad($fiveBitBinaryArray[$i], 5, '0'), 2, 10)];
            $i++;
        }
        if ($padding && ($x = strlen($binaryString) % 40) != 0) {
            if ($x == 8) $base32 .= str_repeat($base32chars[32], 6);
            elseif ($x == 16) $base32 .= str_repeat($base32chars[32], 4);
            elseif ($x == 24) $base32 .= str_repeat($base32chars[32], 3);
            elseif ($x == 32) $base32 .= $base32chars[32];
        }
        return $base32;
    }
/**
     * Get array with all 32 characters for decoding from/encoding to base32
     *
     * @return array
     */
    protected function _getBase32LookupTable()
    {
        return array(
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', //  7
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', // 15
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', // 23
            'Y', 'Z', '2', '3', '4', '5', '6', '7', // 31
            '='  // padding char
        );
    }
/*----------------------------------------*/

}
