<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
if(googleAuthenticator == true){
include_once('/var/www/portal/app/views/login/GoogleAuthenticator.php');
$ga = new GoogleAuthenticator();
$website = MFATITLE; //Your Website
$title = $data['selectedUser'];
$secret = $data['secret'];
$qrCodeUrl = $ga->getQRCodeGoogleUrl($title, $secret,$website);
}
?>
<div class="container">
    <div>
	<?php if($data['lastLoginTime'] != "nil"){ ?>
	<div class="col-lg-6" style="float:right;margin-top: 5px;">
		<span style="font-size: 12px;float:right;"><?php if($data['lastLoginTime']) { ?>Last Login Time : <?php echo $data['lastLoginTime']; } ?></span>
	</div>
	<?php } ?>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <span class="d-none currentPage"><?='devices'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="d-none selectedUser"><?=$data['selectedUser']?></span>
    <span class="d-none device_OS"><?=$data['device_OS']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav">
                        <li class="listOfDevices"><a style="color: #000 !important;">List of All Devices</a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow">
                <div class="status" style="display: none; text-align: center;">Loading ...</div>
                <div class="table-responsive devicesList" style="display: none;">
                    <table class="table table-striped table-hover files-table">
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Device
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Device Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successfull Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
							<th class="text-center clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <?php if(RESTORE_FROM_PORTAL){ ?>
                                    <th>Actions</th>
                                <?php }?>
                            <?php } ?>
                        </tr>
                        </thead>
                        <tbody class="clickAble">
                        <tr ng-repeat="value in devices | orderBy:sortType:sortReverse track by $index">
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name }}</td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
			    <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-center"><a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.name }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a></td>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <?php if(RESTORE_FROM_PORTAL){ ?>
                                    <th ng-if="value.blocked == 'false'"><a ng-click="initiateRestoreBackup(value.uuId, value.name, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a></th>
                                    <th ng-if="value.blocked == 'true'">-</th>
                                <?php }?>
                            <?php } ?>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!--modal--><?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
    		<div class="modal-dialog">
      		<!-- Modal content-->
      			<div class="modal-content">
      			<?=
                        Form::open(array(
                            'ng-submit' => 'changePasswordForFirstlogin()',
                            'method' => 'post',
                            'id' => 'changePasswordForFirstlogin',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                    	?>
        <div class="modal-header">
          <h4 class="modal-title">Change Password</h4>
        </div>
        <div class="modal-body">

                        <div class="form-group">
			    <label for="passwordGuest">Password</label>
			    <?php if(complexPassword == true) { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
			    <?php } else { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
                                <?php } ?>
                        </div>
                        <div class="form-group">
			    <label for="rePasswordGuest">Re Type Password</label>
			    <input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
			</div>
<?php if(googleAuthenticator == true){ ?>
<center><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
                                </div></center>
<?php } ?>
        </div>
        <div class="modal-footer">
          <?php if(googleAuthenticator == true){ ?>
          <p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan this QR code and generate a one-time key.</p>
<?php } else { ?>
        <p style="float: left;">Note: Please change password to proceed further.</p>
<?php } ?>
          <!--<a class="btn btn-default" type="button" href="<?=URL::basePath('logout')?>">Cancel</a>-->
          <button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
        </div>
        <?=
                        Form::close();
                    ?>
      </div>

    </div>
  </div>
  <?php } ?>
            <!--modal-->
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
<script type="text/javascript">
   <?php if($data['popup'] == 'visible') { ?>
	$('#changePasswordForFirstlogin').modal('show');
    <?php } ?>
</script>
